/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fyAp
 */

// forked from djakarta_trap's Tweener graphicを100個でドン！
// Tweener で100個の画像（50*50）を動かしてみる。
// フレームレートが落ちるかどうかを見るためのテスト。
package {
	import flash.display.Bitmap;
    import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import jp.progression.casts.CastBitmap;
	import jp.progression.casts.CastSprite;
	import jp.progression.casts.getInstanceById;
	import jp.progression.commands.CommandInterruptType;
	import jp.progression.commands.lists.ParallelList;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.net.LoadBitmapData;
	import jp.progression.commands.Prop;
	import jp.progression.commands.tweens.DoTweener;
	import jp.progression.data.getResourceById;
	import jp.progression.data.Resource;
	import net.hires.debug.Stats;
	
	[SWF(width="465", height="465", frameRate="60")]
	
    public class FlashTest extends Sprite {
		private var _instances:Array;
		private const _uri:String = "http://assets.wonderfl.net/images/related_images/1/10/1055/10559ac9c2940611b5f9b06d6d4d2e3dd04ed096";
        public function FlashTest() {
            this.addChild(new CastSprite( { id:"container" } ));
			this.addChild(new Stats());
			_instances = [];
			
			//画像をロード
			new LoadBitmapData(new URLRequest(_uri),{context:new LoaderContext(true), onComplete:function():void { createInstances(200) } } ).execute();
			
			stage.addEventListener(MouseEvent.CLICK, animateInstances);
			
        }
		
		private function animateInstances(e:MouseEvent):void 
		{
			var comm:ParallelList = new ParallelList();
			for (var i:int = 0; i < _instances.length; i++)
			{
				comm.addCommand( 
					[
						new DoTweener(_instances[i], { x:Math.random() * stage.stageWidth, y:Math.random() * stage.stageHeight, time:1, transition:"easeOutExpo" }, { interruptType:CommandInterruptType.SKIP } ),
						new Prop(_instances[i], { x:_instances[i].x, y:_instances[i].y } )
					]
				)
			}
			comm.execute();
		}
		
		private function createInstances(num:int):void
		{
			for (var i:int = 0; i < num; i++)
			{
				var cast:CastSprite = new CastSprite( { x:Math.random() * stage.stageWidth, y:Math.random() * stage.stageHeight } );
				cast.addChild(new CastBitmap(Resource(getResourceById(_uri)).toBitmapData(), "auto", false, { x:-25,y:-25 } ));
				_instances.push(cast);
				(getInstanceById("container") as CastSprite).addChild(cast);
			}
		}
    }
}