/**
 * Copyright adkOHTAH ( http://wonderfl.net/user/adkOHTAH )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fy29
 */

// Added : Random Line Size & Color Each Refresh + 360 Rotation
// forked from devm's Grid Rotation
package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BlendMode;
    import flash.display.*;
    
    import flash.filters.BlurFilter;
    
    import flash.geom.Point;
    import flash.geom.ColorTransform;
   
    import flash.events.*;

    import net.hires.debug.Stats;
    
    public class RotationExample extends Sprite {
        
        private var _canvas : BitmapData;
        private var _linesHolder : Sprite;
        
        private var _totalLines : int = 400;
        private var _gridSize : int = Math.sqrt( _totalLines );
        
        private var _linesArray : Array;
        private var _lineColor : Array;
        private var _lineSize : int = 20;
        private var _lineSizeRandom : Number = Math.random()*5;
        private var _ColorRanMax : Number = Math.random() * 0xFFFFFF;
        
        //Constructor
        [ SWF( frameRate=60, width=456, height=456 ) ]
        public function RotationExample() {
            
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0x0 );
            addChild( new Bitmap( _canvas ) );
            
            initLines();
            addEventListener( Event.ENTER_FRAME, update );
            addEventListener( MouseEvent.MOUSE_OVER, updateColor);
           
        }
        
        //the loop
        private function update( evt:Event ) : void {
            updateLines();
        }
        
        //create initial lines
        private function initLines() : void {
            
            _linesHolder = new Sprite();
            _linesArray = new Array();
            
            var count : int = 0;
            var lnX : Number = Math.random()*5;
            var lnY : Number = Math.random()*10;
            
            for( var i : int = 0; i < _totalLines; i++ ) {
                
                var ln : Sprite = new Sprite();
                ln.graphics.lineStyle( _lineSizeRandom, _ColorRanMax );
                ln.graphics.moveTo( 0, 0 );
                ln.graphics.lineTo( _lineSize , 0.1 );
                ln.x = lnX;
                ln.y = lnY;
                
                lnX += _lineSize;
                
                count++;
                if( count == _gridSize ) {
                    lnX = _lineSize;
                    lnY += _lineSize;
                    count = 0;
                }
                _linesHolder.addChild( ln );
                _linesArray.push( ln );
            }
        }
        
        //rotate em based on mouse movement
        private function updateLines() : void
        {
            
            for( var i : int = 0; i < _totalLines; i++ ) {
                var ln : Sprite = _linesArray[i] as Sprite;
                var dx : Number = mouseX - ln.x;
                var dy : Number = mouseY - ln.y;
                var radians : Number = Math.atan2( dy, dx );
                ln.rotation = radians * 360 / Math.PI;
            }
            _canvas.colorTransform( _canvas.rect, new ColorTransform( 0, 0.1, 0.2 ) );
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(2, 2));
            _canvas.draw( _linesHolder );
        }
        
        private function updateColor( evt:Event ):void
        {
            var ln : Sprite = new Sprite();
            ln.graphics.lineStyle( _lineSizeRandom, _ColorRanMax );
        }
        
    }
}