/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fxO6
 */

// クリックでパラメーターを変えて再描画

package {
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(backgroundColor="#ffffff")]

	public class PeterDeJongAttractor extends Sprite {

		private var xn:Number;
		private var yn:Number;
		private var a:Number;
		private var b:Number;
		private var c:Number;
		private var d:Number;
		private var color:uint = 0x000000;
		private var bgColor:uint = 0xFFFFFF;
		private var bitmap:BitmapData;
		private var limit:uint;
		private var repeat:uint;

		public function PeterDeJongAttractor() {
			stage.scaleMode = "noScale";
			stage.align = "TL";
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, true, bgColor);
			addChild(new Bitmap(bitmap));
			init(null);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, init);
		}

		public function init(e:MouseEvent):void {
			xn = 0, yn = 0;
			a = (Math.random() - 0.5) * 5;
			b = (Math.random() - 0.5) * 5;
			c = (Math.random() - 0.5) * 5;
			d = (Math.random() - 0.5) * 5;
			bitmap.fillRect(bitmap.rect, bgColor);
			limit = bitmap.width * bitmap.height * 4;
			repeat = 0;

			addEventListener(Event.ENTER_FRAME, draw);
		}

		public function draw(e:Event):void {
			repeat += 10000;
			if (repeat > limit) removeEventListener(Event.ENTER_FRAME, draw);

			bitmap.lock();
			for (var i:int = 0; i < 10000; i++) {
				var x:Number = xn, y:Number = yn;
				var xo:int = bitmap.width  * (0.5 + (xn = Math.sin(a * y) - c * Math.cos(a * x)) / 8);
				var yo:int = bitmap.height * (0.5 + (yn = Math.sin(c * x) - d * Math.cos(b * y)) / 8);
				var alpha:int = Math.min(240, (bitmap.getPixel32(xo, yo) >>> 24) + 3);
				bitmap.setPixel32(xo, yo, (alpha << 24) | color);
			}
			bitmap.unlock();
		}

	}
}
