/**
 * Copyright snowsunny ( http://wonderfl.net/user/snowsunny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fxM2
 */

package
{
    import flash.display.Sprite;
    public class ColorGradation extends Sprite
    {
        public function ColorGradation()
        {
            //必要変数作成・設定
            var i:int , j:int;   //for文用変数
            
            var ColorNum:int = 16;                   //横方向のカラー数(偶数で指定)
            var GradationNum:int = ColorNum/2 - 1;   //グラデーション回数(描画全体が正方形になる様に設定)
            
            var ColorArray:Array = [];      //素材色配列
            var FixColorArray:Array = [];   //グラデーション入り色配列
            
            for(i = 0; i < ColorNum; i++)
            {
                //ChangeHSVtoRGBを使って色相グラデーションを取得
                //ColorArrayにグラデーションの素材となる色を格納
                ColorArray.push(ChangeHSVtoRGB(360/ColorNum * i));
            }
            
            //各グラデーションをInterpolateColorを使って補間カラーを取得、FixColorArrayに格納
            //白のグラデーション色を挿入
            for(i = 1; i <= GradationNum; i++)
            {
                for(j = 0; j < ColorArray.length; j++)
                {
                    FixColorArray.push(InterpolateColor(0xFFFFFF, ColorArray[j], (1/(GradationNum+1)) * i));
                }
            }
            //素材色配列を挿入
            for(i = 0; i < ColorArray.length; i++)
            {
                FixColorArray.push(ColorArray[i]);
            }
            //黒のグラデーション色を挿入
            for(i = 1; i <= GradationNum; i++)
            {
                for(j = 0; j < ColorArray.length; j++)
                {
                    FixColorArray.push(InterpolateColor(ColorArray[j], 0x000000, (1/(GradationNum+1)) * i));
                }
            }
            //グレースケールグラデーションを挿入
            for(i = 0; i <= ColorNum-1; i++)
            {
                FixColorArray.push(InterpolateColor(0x000000, 0xFFFFFF, (1/(ColorNum-1)) * i));
            }
            
            //補間カラー生成関数
            function InterpolateColor(StartColor:uint, EndColor:uint, TransitionPercent1:Number):uint
            {
                var TransitionPercent2:Number = (1 - TransitionPercent1);
                
                //SC:StartColor EC:EndColor IC:InterpolateColor
                //各要素を抽出・計算、ICをreturnする
                var SC1:uint = StartColor >> 24 & 0xFF;
                var SC2:uint = StartColor >> 16 & 0xFF;
                var SC3:uint = StartColor >> 8 & 0xFF;
                var SC4:uint = StartColor & 0xFF;
                
                var EC1:uint = EndColor >> 24 & 0xFF;
                var EC2:uint = EndColor >> 16 & 0xFF;
                var EC3:uint = EndColor >> 8 & 0xFF;
                var EC4:uint = EndColor & 0xFF;
                
                var IC1:uint = SC1 * TransitionPercent2 + EC1 * TransitionPercent1;
                var IC2:uint = SC2 * TransitionPercent2 + EC2 * TransitionPercent1;
                var IC3:uint = SC3 * TransitionPercent2 + EC3 * TransitionPercent1;
                var IC4:uint = SC4 * TransitionPercent2 + EC4 * TransitionPercent1;
                
                var IC:uint = IC1 << 24 | IC2 << 16 | IC3 << 8 | IC4;
                return IC;
            }
            
            //HSVをRGBに変換する関数
            function ChangeHSVtoRGB(H:Number, S:Number=1, V:Number=1):uint
            {
                //変換したRGBを入れる変数を作成
                var RGB:uint;
                
                if(S == 0)
                {
                    //Sが0の時、Hは不必要となりVのみでRGBを設定する
                    //RGBにビットをシフトしながら値を格納
                    RGB = V * 255 << 16 | V * 255 << 8 | V * 255;
                }
                else
                {
                    //変換に必要な変数を作成・設定
                    var Hi:Number = Math.floor((H / 60)) % 6;
                    var f:Number = (H / 60 - Hi);
                    var p:Number = V * (1 - S);
                    var q:Number = V * (1 - f * S);
                    var t:Number = V * (1 - (1 - f) * S);
                    
                    //HiによってRGBに格納する値を変更
                    //RGBにビットをシフトしながら値を格納
                    switch(Hi)
                    {
                        case 0:
                            RGB = V * 255 << 16 | t * 255 << 8 | p * 255 ;
                            break;
                        case 1:
                            RGB = q * 255 << 16 | V * 255 << 8 | p * 255 ;
                            break;
                        case 2:
                            RGB = p * 255 << 16 | V * 255 << 8 | t * 255 ;
                            break;
                        case 3:
                            RGB = p * 255 << 16 | q * 255 << 8 | V * 255 ;
                            break;
                        case 4:
                            RGB = t * 255 << 16 | p * 255 << 8 | V * 255 ;
                            break;
                        case 5:
                            RGB = V * 255 << 16 | p * 255 << 8 | q * 255 ;
                            break;
                    }
                }
                return RGB;
            }
            
            //円描画用Sprite
            var ColorSprite:Sprite = new Sprite;
            
            //ステージの高さに合う様にradを設定
            var rad:Number = (stage.stageHeight/(FixColorArray.length/ColorNum))/2;
            //FixColorArrayの数だけ円を描画
            for(i = 0; i < FixColorArray.length; i++)
            {
                ColorSprite.graphics.beginFill(FixColorArray[i]);
                ColorSprite.graphics.drawCircle(rad*2*(int(i%ColorNum))+rad, rad*2*(int(i/ColorNum))+rad, rad);
            }
            ColorSprite.graphics.endFill();
            addChild(ColorSprite);          
        }
    }
}