/**
 * Copyright nanlow ( http://wonderfl.net/user/nanlow )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fxDE
 */

/**
 * だいぶ遅くなったけど、ワラワラさせてみました。
 * クリックで時計表示とランダムレイアウトが入れ替わります。
 */
package
{
    import flash.display.Sprite;
    import flash.events.Event
    import flash.events.MouseEvent;
    import net.hires.debug.Stats;
     [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
    public class Main extends Sprite
    {
        private var _list:Array = [];
        private var _count:uint = 0;
        private var _clock:Clock;
        private var _h2:NumberGroup;
        private var _h1:NumberGroup;
        private var _m2:NumberGroup;
        private var _m1:NumberGroup;
        private var _dot:DotGroup;
        private var _isRandom:Boolean = false;
        public function Main():void
        {
             Wonderfl.capture_delay( 20 );
            if (!stage)
                addEventListener(Event.ADDED_TO_STAGE, _init);
            else
                _init();
        }
        private function _init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, _init);
            graphics.beginFill(0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            var vw:Array = _saveMotion(new BaseTypo("ワラ"), new VerticalWalkMotion);
            var hw:Array = _saveMotion(new BaseTypo("ワラ"), new HorizontalWalkMotion);
            var jm:Array = _saveMotion(new BaseTypo("ピョン"), new JumpMotion);
            var manager:MotionManager = new MotionManager(jm, vw, hw);
            _clock = new Clock();
            _h2 = new NumberGroup(this, manager, new Pt(110, 230));
            _h1 = new NumberGroup(this, manager, new Pt(180, 230));
            _m2 = new NumberGroup(this, manager, new Pt(285, 230));
            _m1 = new NumberGroup(this, manager, new Pt(355, 230));
            _dot = new DotGroup(this, manager, new Pt(232, 230));
            addEventListener(Event.ENTER_FRAME, _onUpdate);
            stage.addEventListener(MouseEvent.CLICK, _onClickHander);
            _clock.addEventListener(Event.CHANGE, _onClockChangeHandler);
            _onClockChangeHandler();
            //addChild(new Stats());
        }
        private function _saveMotion(sp:Sprite, motion:IMotion):Array
        {
            var result:Array = [];
            for (var i:int = 0; i < Conf.FPS; i++)
            {
                result[i]  = motion.create(sp, i, Conf.FPS);
            }
            return result;
        }
        private function _onUpdate(e:Event):void 
        {
            _h2.update();
            _h1.update();
            _m2.update();
            _m1.update();
            _dot.update();
        }
        private function _onClockChangeHandler(e:Event = null):void
        {
            if (!_isRandom)
            {
                _h2.layout(_clock.hoursUpper);
                _h1.layout(_clock.hoursLower);
                _m2.layout(_clock.minutesUpper);
                _m1.layout(_clock.minutesLower);
                _dot.layout();                
            }
        }
        private function _onClickHander(e:MouseEvent):void 
        {
            _isRandom = !_isRandom;
            if (!_isRandom)
            {
                _onClockChangeHandler();
            }else
            {
                _h2.random();
                _h1.random();
                _m2.random();
                _m1.random();
                _dot.random();
            }
        }
    }
}
class Conf
{
    public static const FPS:uint = 60;
    public static const DOT_MARGIN_X:uint = 10;
    public static const DOT_MARGIN_Y:uint = 12;
    public static const STAGE_WIDTH:uint = 465;
    public static const STAGE_HEIGHT:uint = 465;
    public static const ACTIVE_COLOR:uint = 0xFFFFFFFF;
    public static const UNACTIVE_COLOR:uint = 0x99FFFFFF;
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.TimerEvent;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.Timer;
class MotionManager
{
    private var _jumpList:Array = [];
    private var _verticalWalkList:Array = [];
    private var _horizontalWalkList:Array = [];
    public function MotionManager(jumpList:Array, verticalWalkList:Array, horizontalWalkList:Array) 
    {
        _jumpList = jumpList;
        _verticalWalkList = verticalWalkList;
        _horizontalWalkList = horizontalWalkList;
    }
    public function getImg(type:String, i:uint):BitmapData
    {
        var list:Array;
        switch(type)
        {
            case "jump":
                list = _jumpList;
                break;
            case "vertical_walk":
                list = _verticalWalkList;
                break;
            case "horizontal_walk":
                list = _horizontalWalkList;
                break;
            default:
                throw new Error("該当するアニメーションがありません。");
                break;
        }
        return list[i] as BitmapData;
    }
}
class NumberGroup
{
    private var _container:DisplayObjectContainer;
    private var _manager:MotionManager;
    private var _basePt:Pt;
    private var _list:Array = [];
    public function NumberGroup(container:DisplayObjectContainer, manager:MotionManager, basePt:Pt)
    {
        _container = container;
        _manager = manager;
        _basePt = basePt;
        _create(41)
    }
    public function layout(id:uint):void
    {
        var layoutList:Array = NumberCoordinate.getArray(id);
        var result:Array = [];
        for (var i:int = 0; i < _list.length; i++)
        {
            var particle:MoveParticle = _list[i] as MoveParticle;
            if (layoutList[i] == null)
            {
                particle.color = _unactiveColor();
                result = [_stageRandowPt()];
            }else
            {
                particle.color = _activeColor();
                var pt:Pt = layoutList[i] as Pt;
                pt.x += _basePt.x;
                pt.y += _basePt.y;
                result = [_circleRandomPt(), pt];
            }
            particle.setTargetPointList(result);
        }
    }
    public function update():void
    {
        for (var i:int = 0; i < _list.length; i++)
        {
            var particle:MoveParticle = _list[i] as MoveParticle;
            particle.update();
        }
    }
    public function random():void
    {
        for (var i:int = 0; i < _list.length; i++)
        {
            var particle:MoveParticle = _list[i] as MoveParticle;
            particle.setTargetPointList([_stageRandowPt()]);
            particle.color = _unactiveColor();
        }
    }
    private function _create(num:uint):void
    {
        var r:Number = Math.sqrt(Conf.STAGE_WIDTH * Conf.STAGE_WIDTH + Conf.STAGE_HEIGHT * Conf.STAGE_HEIGHT) >> 1;
        for (var i:int = 0; i < num; i++)
        {
            var particle:MoveParticle = new MoveParticle(_manager);
            _container.addChild(particle);
            _list[i] = particle;
            var rad:Number = Math.PI * 2 * Math.random();
            particle.i = uint(Conf.FPS * Math.random());
            particle.speed = Math.random() * 0.5 + 0.5;
            particle.x = r * Math.cos(rad) + (Conf.STAGE_WIDTH >> 1);
            particle.y = r * Math.sin(rad) + (Conf.STAGE_HEIGHT >> 1);
        }
    }
    private function _activeColor():uint
    {
        var result:uint = Conf.ACTIVE_COLOR;
        //var r:Number = Math.random();
        //if (r < 1 / 3)
        //{
            //result = 0xCCffeb00;
        //}else if(r < 2 / 3)
        //{
            //result = 0xCC97e3ff;
        //}else
        //{
            //result = 0xCCff7cb2;
        //}
        return result;
    }
    private function _unactiveColor():uint
    {
        return Conf.UNACTIVE_COLOR;
        //return 0xCC8076c0;
    }
    private function _stageRandowPt():Pt
    {
        return new Pt(Conf.STAGE_WIDTH * Math.random(), Conf.STAGE_HEIGHT * Math.random());
    }
    private function _circleRandomPt():Pt
    {
        return new Pt(Math.random() * 150 - 75 + _basePt.x, Math.random() * 150 - 75 + _basePt.y);
    }
}
class DotGroup
{
    private var _container:DisplayObjectContainer;
    private var _manager:MotionManager;
    private var _basePt:Pt;
    private var _list:Array = [];
    public function DotGroup(container:DisplayObjectContainer, manager:MotionManager, basePt:Pt)
    {
        _container = container;
        _manager = manager;
        _basePt = basePt;
        _create(4);
    }
    public function layout():void
    {
        var layoutList:Array = DotCoordinate.getArray();
        var result:Array = [];
        for (var i:int = 0; i < _list.length; i++)
        {
            var particle:MoveParticle = _list[i] as MoveParticle;
            particle.color = _activeColor();
            var pt:Pt = layoutList[i] as Pt;
            pt.x += _basePt.x;
            pt.y += _basePt.y;
            result = [_circleRandomPt(), pt];
            particle.setTargetPointList(result);
        }
    }
    public function update():void
    {
        for (var i:int = 0; i < _list.length; i++)
        {
            var particle:MoveParticle = _list[i] as MoveParticle;
            particle.update();
        }
    }
    public function random():void
    {
        for (var i:int = 0; i < _list.length; i++)
        {
            var particle:MoveParticle = _list[i] as MoveParticle;
            particle.setTargetPointList([_stageRandowPt()]);
            particle.color = _unactiveColor();
        }
    }
    private function _create(num:uint):void
    {
        var r:Number = Math.sqrt(Conf.STAGE_WIDTH * Conf.STAGE_WIDTH + Conf.STAGE_HEIGHT * Conf.STAGE_HEIGHT) >> 1;
        for (var i:int = 0; i < num; i++)
        {
            var particle:MoveParticle = new MoveParticle(_manager);
            _container.addChild(particle);
            _list[i] = particle;
            var rad:Number = Math.PI * 2 * Math.random();
            particle.i = uint(Conf.FPS * Math.random());
            particle.speed = Math.random() * 0.5 + 0.5;
            particle.x = r * Math.cos(rad) + (Conf.STAGE_WIDTH >> 1);
            particle.y = r * Math.sin(rad) + (Conf.STAGE_HEIGHT >> 1);
        }
    }
    private function _activeColor():uint
    {
        var result:uint = Conf.ACTIVE_COLOR;
        //var r:Number = Math.random();
        //if (r < 1 / 3)
        //{
            //result = 0xCCffeb00;
        //}else if(r < 2 / 3)
        //{
            //result = 0xCC97e3ff;
        //}else
        //{
            //result = 0xCCff7cb2;
        //}
        return result;
    }
    private function _unactiveColor():uint
    {
        return Conf.UNACTIVE_COLOR;
        //return 0xCC8076c0;
    }
    private function _stageRandowPt():Pt
    {
        return new Pt(Conf.STAGE_WIDTH * Math.random(), Conf.STAGE_HEIGHT * Math.random());
    }
    private function _circleRandomPt():Pt
    {
        return new Pt(Math.random() * 150 - 75 + _basePt.x, Math.random() * 150 - 75 + _basePt.y);
    }
}
class MoveParticle extends Sprite
{
    private var _i:uint;
    private var _count:uint;
    private var _type:String;
    private var _targetPoint:Pt;
    private var _speed:Number;
    private var _speedPoint:Pt
    private var _bitmap:Bitmap;
    private var _manager:MotionManager;
    private var _isMove:Boolean;
    private var _targetPtList:Array= [];
    public function MoveParticle(manager:MotionManager)
    {
        _init(manager);
    }
    private function _init(manager:MotionManager):void
    {
        _manager = manager
        _targetPtList = [];
        _i = 0;
        _type = "jump";
        _speed = 1;
        var bmd:BitmapData = new BitmapData(15, 40, true, 0x00FFFFFF);
        _bitmap = addChild(new Bitmap(bmd)) as Bitmap;
        _bitmap.x = -(_bitmap.width >> 1);
        _bitmap.y = -_bitmap.height;
        _setTargetPoint(new Pt(0, 0));
    }
    private function _setTargetPoint(pt:Pt):void
    {
        _targetPoint = pt;
        var kx:Number = pt.x - x;
        var ky:Number = pt.y - y;
        var k:Number = Math.sqrt(kx * kx + ky * ky);
        var v:Number = k / _speed;
        _speedPoint = new Pt(kx / v, ky / v);
        _count = uint(v);
        _type = (Math.abs(kx) < Math.abs(ky)) ? "vertical_walk" : "horizontal_walk";
        _bitmap.y = -30
        _isMove = true;
    }
    private function _checkList():void
    {
        if (0 < _targetPtList.length)
        {
            _setTargetPoint(_targetPtList.shift());
        }
    }
    public function setTargetPointList(list:Array):void
    {
        _targetPtList = list;
        _checkList();
    }
    public function update():void
    {
        _bitmap.bitmapData = _manager.getImg(_type, _i);
        _i = (_i + 1) % Conf.FPS;
        
        if (!_isMove) { return };
        
        if (0 == _count)
        {
            x = _targetPoint.x;
            y = _targetPoint.y;
            _bitmap.y = -40
            _type = "jump";
            _isMove = false;
            _checkList();
        }else if (0 < _count)
        {
            x += _speedPoint.x;
            y += _speedPoint.y;
            _count--
        }
    }
    public function set i(value:uint):void
    {
        _i = value;
    }
    public function set color(value:uint):void
    {
        transform.colorTransform = new ColorTransform(1, 1, 1, 1, value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, -255 + (value >> 24 & 0xFF));
    }
    public function set type(value:String):void
    {
        _type = value;
    }
    public function set speed(value:Number):void
    {
        _speed = value;
    }
}
class NumberCoordinate 
{
    public static function getArray(id:uint):Array
    {
        var result:Array = [];
        switch(id)
        {
            case 0:
                result = _checkNumber(LIST0);
                break;
            case 1:
                result = _checkNumber(LIST1);
                break;
            case 2:
                result = _checkNumber(LIST2);
                break;
            case 3:
                result = _checkNumber(LIST3);
                break;
            case 4:
                result = _checkNumber(LIST4);
                break;
            case 5:
                result = _checkNumber(LIST5);
                break;
            case 6:
                result = _checkNumber(LIST6);
                break;
            case 7:
                result = _checkNumber(LIST7);
                break;
            case 8:
                result = _checkNumber(LIST8);
                break;
            case 9:
                result = _checkNumber(LIST9);
                break;
            default:
                throw new Error('引数に一桁のuintを指定してください。');
                break;
        }
        return result;
    }
    private static function _checkNumber(_list:Array):Array
    {
        var result:Array = [];
        for (var i:int = 0; i < BASE_LIST.length; i++ )
        {
            if (_list[i] == 1)
            {
                result[i] = new Pt(BASE_LIST[i][0] * Conf.DOT_MARGIN_X, BASE_LIST[i][1] * Conf.DOT_MARGIN_Y);
            }else
            {
                result[i] = null;
            }
        }
        return result;
    }
    private static const LIST0:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
    private static const LIST1:Array = [0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1];
    private static const LIST2:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
    private static const LIST3:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
    private static const LIST4:Array = [1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1];
    private static const LIST5:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
    private static const LIST6:Array = [1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
    private static const LIST7:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1];
    private static const LIST8:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
    private static const LIST9:Array = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1];
    private static const BASE_LIST:Array =[[ -2, -4], [ -1, -4], [0, -4], [1, -4], [2, -4], [ -2, -3], [ -1, -3], [0, -3], [1, -3], [2, -3], [ -2, -2], [ -1, -2],  [1, -2], [2, -2], [ -2, -1], [ -1, -1],  [1, -1], [2, -1], [ -2, 0], [ -1, 0], [0, 0], [1, 0], [2, 0], [ -2, 1], [ -1, 1],  [1, 1], [2, 1], [ -2, 2], [ -1, 2],  [1, 2], [2, 2], [ -2, 3], [ -1, 3], [0, 3], [1, 3], [2, 3], [ -2, 4], [ -1, 4], [0, 4], [1, 4], [2, 4]]
}
class DotCoordinate 
{
    public static function getArray():Array
    {
        var result:Array = [];
        for (var i:int = 0; i < BASE_LIST.length; i++ )
        {
            result[i] = new Pt(BASE_LIST[i][0] * Conf.DOT_MARGIN_X, BASE_LIST[i][1] * Conf.DOT_MARGIN_Y);
        }
        return result;
    }
    private static const BASE_LIST:Array = [[ -0.5, -1.5], [0.5, -1.5], [ -0.5, 1.5], [0.5, 1.5]];
}
class Clock extends EventDispatcher
{
    private var _hours:Number;
    private var _minutes:Number;
    private var _preMinutes:Number;
    public function Clock() 
    {
        var timer:Timer = new Timer(1000);
        timer.addEventListener(TimerEvent.TIMER, _onTimerHandler);
        timer.start();
        _onTimerHandler();
    }
    public function get hoursUpper():int { return _hours / 10; }
    public function get minutesUpper():int { return _minutes / 10; }
    public function get hoursLower():int { return _hours % 10; }
    public function get minutesLower():int  { return _minutes % 10; }
    private function _onTimerHandler(e:TimerEvent = null):void 
    {
        var date:Date = new Date();
        _hours = date.getHours()
        _minutes = date.getMinutes();
        if (_preMinutes != _minutes)
        {
            dispatchEvent(new Event(Event.CHANGE));
        }
        _preMinutes = _minutes;
    }
}
class BaseTypo extends Sprite
{
    public function BaseTypo(str:String) 
    {
        var bitmapData:BitmapData = _getMinimumBitmapData(_createTextField(str));
        var bm:Bitmap = new Bitmap(bitmapData);
        bm.y = -bm.height;
        var sp:Sprite = new Sprite();
        sp.addChild(bm)
        addChild(sp);
    }
    private function _createTextField(str:String):TextField
    {
        var result:TextField = new TextField();
        result.width = 16;
        result.autoSize = TextFieldAutoSize.LEFT;
        result.wordWrap = true;
        result.multiline = true;
        var format:TextFormat = new TextFormat();
        format.size = 14;
        format.font = '_等幅';
        format.leading = -5
        format.color = 0;
        format.bold = true;
        result.defaultTextFormat = format;
        result.text = str;
        result.filters = [new GlowFilter(0, 1, 1.2, 1.2, 3.0)];
        return result;
    }
    private function _getMinimumBitmapData(tf:TextField):BitmapData
    {
        var bmd1:BitmapData = new BitmapData(tf.textWidth, tf.textHeight, true, 0x00000000);
        bmd1.draw(tf, new Matrix(1, 0, 0, 1, -2, -2));
        var rectangle:Rectangle = bmd1.getColorBoundsRect(0xff000000, 0x00000000, false);
        var bmd2:BitmapData = new BitmapData(rectangle.width, rectangle.height, true, 0x00FFFFFF);
        bmd2.draw(bmd1, new Matrix(1, 0, 0, 1, -rectangle.x, -rectangle.y));
        bmd1.dispose();
        return bmd2;
    }
}
interface IMotion
{
    function create(sp:Sprite, i:int, n:int):BitmapData
}
class JumpMotion implements IMotion
{
    public function JumpMotion() { };
    public function create(sp:Sprite, i:int, n:int):BitmapData
    {
        var child:DisplayObject = sp.getChildAt(0);
        var result:BitmapData = new BitmapData(20, 50, true, 0x00FFFFFF);
        var rad:Number = (Math.PI * 2 / n) * i;
        child.x=5
        child.y = Math.abs(Math.cos(rad)) * 10 + 30
        child.scaleY = Math.abs(Math.sin(rad - 0.75)) * 0.4 + 0.6;
        result.draw(sp);
        return result;
    }
}
class VerticalWalkMotion implements IMotion
{
    public function VerticalWalkMotion() { };
    public function create(sp:Sprite, i:int, n:int):BitmapData
    {
        var child:DisplayObject = sp.getChildAt(0);
        var result:BitmapData = new BitmapData(30, child.height, true, 0x00FFFFFF);
        var rad:Number = (Math.PI * 2 / n) * i * 2;
        var x0:Number = 0;
        var x1:Number = 0.5 * Math.abs(Math.cos(rad)) + 0.5;
        var x2:Number = 0.3 * Math.sin(rad*2);
        var y0:Number = 0;
        var y1:Number = 0.3 * Math.sin(rad);
        var y2:Number = 1;
        var mat:Matrix = new Matrix((x1 - x0), (y1 - y0),  (x2 - x0), (y2 - y0), x0, y0);
        child.transform.matrix = mat;
        child.x = 5
        child.y = child.height
        result.draw(sp);
        return result;
    }
}
class HorizontalWalkMotion implements IMotion
{
    public function HorizontalWalkMotion() { };
    public function create(target:Sprite, i:int, fps:int):BitmapData
    {
        var child:DisplayObject = target.getChildAt(0);
        var result:BitmapData = new BitmapData(30, 40, true, 0x00FFFFFF);
        var rad:Number = (Math.PI * 2 / fps) * i * 2;
        var x0:Number = 0;
        var x1:Number = 0.5 * Math.cos(rad);
        var x2:Number = 0.2 * Math.sin(rad*2);
        var y0:Number = 0
        var y1:Number = 0.2;
        var y2:Number = 1;
        var mat:Matrix = new Matrix((x1 - x0), (y1 - y0),  (x2 - x0), (y2 - y0), x0, y0);
        child.transform.matrix = mat;
        child.x = 10
        child.y = child.height
        result.draw(target);
        return result;
    }
}
class Pt
{
    public var x:Number;
    public var y:Number;
    public function Pt(x:Number, y:Number) 
    {
        this.x = x;
        this.y = y;
    }
}