/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fx9C
 */

package {

    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.PNGEncoderOptions;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.utils.ByteArray;
    import mx.utils.Base64Decoder;
    import flash.utils.setTimeout;
    
    public class FlashTest extends Sprite
    {
        
        // Private Static Method
        
        static private var _base64:String = "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";
        
        // Private Const
        
        private const _WIDTH:uint = 314;
        private const _HEIGHT:uint = 43;
        
        // Private Property
        
        private var _byteArray:ByteArray;
        private var _loader:Loader;
        private var _bitmapData:BitmapData;
        private var _isLoading:Boolean;
        private var _count:uint = 0;
        private var _textField:TextField;
        
        //Constructor
        
        public function FlashTest()
        {
            // display
            _bitmapData = new BitmapData(_WIDTH, _HEIGHT, true, 0);
            
            _textField = addChild(new TextField()) as TextField;
            _textField.defaultTextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
            _textField.autoSize = TextFieldAutoSize.LEFT;
            
            // Base64 to ByteArray
            var base64Decoder:Base64Decoder = new Base64Decoder();
            base64Decoder.decode(FlashTest._base64);
            _byteArray = base64Decoder.toByteArray();
            
            // draw background
            var g:Graphics = graphics;
            g.beginFill(0x000000, 1);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            g.endFill();
            
            // draw display BitmapData
            var matrix:Matrix = new Matrix();
            matrix.translate((stage.stageWidth - _WIDTH) >> 1, (stage.stageHeight - _HEIGHT) >> 1);
            g.beginBitmapFill(_bitmapData, matrix);
            g.drawRect(matrix.tx, matrix.ty, _WIDTH, _HEIGHT);
            g.endFill();
            
            // create Loader
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.INIT, _loaderInitHandler);
            
            // load
            _loadBytes();
            
            //stage.addEventListener(MouseEvent.CLICK, _clickHandler);
        }
        
        // Private Method
        
        private function _loadBytes():void
        {
            if (_isLoading)
            {
                return;
            }
            _isLoading = true;
            _loader.loadBytes(_byteArray);
        }
        
        private function _loaderInitHandler(event:Event):void
        {
            // clear and draw
            _bitmapData.fillRect(_bitmapData.rect, 0);
            _bitmapData.draw(_loader);
            
            // to ByteArray
            _byteArray = new ByteArray();
            _bitmapData.encode(_bitmapData.rect, new PNGEncoderOptions(), _byteArray);
            
            // update display
            ++_count;
            _updateCountTextField();
            
            _isLoading = false;
            
            setTimeout(_loadBytes, 30);
        }
        
        private function _clickHandler(event:MouseEvent):void
        {
            _loadBytes();
        }
        
        private function _updateCountTextField():void
        {
            _textField.text = "BitmapData → ByteArray " + _count.toString() + ' 回目';
        }
        
    }
}