/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fwYj
 */

// forked from John_Blackburne's flash on 2011-12-16
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        public const kNumTrials:int    = 5000000;

        public var aData:Vector.<Vec2D>;
       
        public var tf:TextField;

        public function FlashTest() {
            var iTime:int;
            
            InitText();
            InitData();
            
            iTime = getTimer();
            Test1();
            tf.appendText("\nTest 1, accessing members: "
                + String(getTimer() - iTime));

            iTime = getTimer();
            Test2();
            tf.appendText("\nTest 2, using accessors: " 
                + String(getTimer() - iTime));

            iTime = getTimer();
            Test3();
            tf.appendText("\nTest 3 accessing by name: "
                + String(getTimer() - iTime));
            

            iTime = getTimer();
            Test4();
            tf.appendText("\nTest 4, not dereferencing: "
                + String(getTimer() - iTime));

            tf.appendText("\nDone");
            
        }
        
        public function InitText():void {
            tf = new TextField();
            tf.width = 400;
            tf.text = "Initialised";
            addChild(tf);
        }

        public function InitData():void {
            var iIndex:int;
            
            aData = new Vector.<Vec2D>();
            
            for (iIndex = 0; iIndex < kNumTrials; iIndex++) {
                aData.push(new Vec2D(iIndex % 7, iIndex % 11));
            }
        }

        public function Test1():void {
            var iTrial:int, iSum:Number, v:Vec2D;
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aData[iTrial];
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
                iSum += v.iX + v.iY;
            }
        }

        public function Test2():void {
            var iTrial:int, iSum:Number, v:Vec2D;
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aData[iTrial];
                iSum += v.X() + v.Y();
                iSum += v.X() + v.Y();
                iSum += v.X() + v.Y();
                iSum += v.X() + v.Y();
            }
        }

        public function Test3():void {
            var iTrial:int, iSum:Number, v:Vec2D;
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                v = aData[iTrial];
                iSum += v["iX"] + v["iY"];
                iSum += v["iX"] + v["iY"];
                iSum += v["iX"] + v["iY"];
                iSum += v["iX"] + v["iY"];
            }
        }
         public function Test4():void {
            var iTrial:int, iSum:Number;
            iSum = 0;

            for (iTrial = 0; iTrial < kNumTrials; iTrial++) {
                iSum += aData[iTrial].iX + aData[iTrial].iY;
                iSum += aData[iTrial].iX + aData[iTrial].iY;
                iSum += aData[iTrial].iX + aData[iTrial].iY;
                iSum += aData[iTrial].iX + aData[iTrial].iY;
            }
        }

    }
}


class Vec2D {
 public var iX:int;
 public var iY:int;
 
 public function Vec2D(x:int, y:int) {iX = x; iY = y;}
 public function X():int {return iX;}
 public function Y():int {return iY;}
}

