/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fwPa
 */

package {
    import flash.display.Sprite;
    import funnel.*;

    public class AnalogIOExample extends Sprite {
        private var arduino:Arduino;

        // 回転型ポテンショメータ(Potentiometer Twig)に接続したピン
        private var sensorPin:Pin;

        // LED(LED Twig)に接続したピン
        private var ledPin:Pin;

        public function AnalogIOExample() {
            // LEDに接続したピン(D9)のモードをPWMにセット
            var config:Configuration = Arduino.FIRMATA;
            config.setDigitalPinMode(9, PWM);
            arduino = new Arduino(config);

            // センサとLEDに接続したピンを表す変数を初期化
            sensorPin = arduino.analogPin(0);
            ledPin = arduino.digitalPin(9);

            // センサの値が変化した際に発生するイベントに対するリスナをセット
            sensorPin.addEventListener(PinEvent.CHANGE, onChange);
        }

        // センサの値が変化したら以下を実行
        private function onChange(e:PinEvent):void {
            // LEDの値をセンサの値にセット
            ledPin.value = sensorPin.value;
        }
    }
}