/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fwIo
 */

package {
    import com.actionscriptbible.Example;
    import com.bit101.components.InputText;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    
    [SWF(width="465",height="465",frameRate="30",backgroundColor="0xFFFFFF")]
    public class Main extends Example {
        private var _input:InputText;
        private var _reactor:Reactor;
        private var _room:Room;
        
        public function Main() {
            _input = new InputText(this, 100, 440);
            _input.width = 265;
            _input.addEventListener(KeyboardEvent.KEY_UP, sendMessage);
            
            _reactor = new Reactor();
            _reactor.addEventListener(ReactorEvent.READY, onReady);
            _reactor.connect("tryunion.com", 80);
            function onReady(event:ReactorEvent):void {
                _room = _reactor.getRoomManager().createRoom("chatRoom");
                _room.addMessageListener("CHAT_MESSAGE", receiveMessage);
                _room.join();
            }
        }
        
        private function sendMessage(event:KeyboardEvent):void {
            if (_reactor.isReady() && event.keyCode == Keyboard.ENTER) {
                _room.sendMessage("CHAT_MESSAGE", true, null, _input.text);
                _input.text = "";
            }
        }
        
        private function receiveMessage(from:IClient, message:String):void {
            trace("Guest" + from.getClientID() + ": " + message);
        }
    }
}