/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fujX
 */

/*
疲れた。一番大変だったのは星座の線。
20個くらいやって、二度とやりたくないと思ったので、
８８星座全部に線を引いた。

時刻から位置（回転）をつくるわけだけど、
一部、計算が合わなくてそれっぽく見えるような
値を足している。次回への課題。

前から星座表はやりたかったんだけど、
使いやすい星の座標データが見つけられなかったのでできてなかった。
uwiさんに感謝。

惑星と月も追加できたら完璧なんだろうけど、今は無理だな。
特に惑星が。

参考
http://wonderfl.net/code/8d2908ec47387090459c10aef975b823f5d5331b
http://www3.plala.or.jp/cielo/graffias/data/star.html
http://mirahouse.jp/begin/constellation/index.html
http://www.toxsoft.com/stella/index.html
*/
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(backgroundColor="0x000000")]
	public class Main extends Sprite
	{
		private var _dataMgr:DataMgr;
		private var _canvasRect:Rectangle;
		private var _r:Number;
		private var _bitmapData:BitmapData;
		private const FADE:ColorTransform = new ColorTransform(1, 1, 1, 1, -0xF2, -0xF2, -0xF2);
		private const NEWS:Array = ["W","NW","N","NE","E","SE","S","SW"];
		private var _mode:int = 0;//0:line+name,1:line,2:none
		private var _view:int = 0;//0:half,1:top
		private var _bgRect:Shape;
		private var _bgCircle:Shape;
		private var _tf:TextField
		public function Main()
		{
			stage.align = "TL";
			stage.scaleMode = "noScale";
			
			_canvasRect = new Rectangle(0,0,stage.stageWidth,stage.stageHeight);
			_r = Math.max(_canvasRect.width,_canvasRect.height);
			_bitmapData = new BitmapData(_canvasRect.width,_canvasRect.height,false,0);
			
			_dataMgr = new DataMgr();
			addChild(new Bitmap(_bitmapData));
			_bgRect = new Shape();
			_bgCircle = new Shape();
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(_canvasRect.width,_canvasRect.height,Math.PI/2,0,0);
			_bgRect.graphics.beginGradientFill("linear",[0x000000,0x0C0022],[1,1],[0xAA,0xFF],matrix);
			_bgRect.graphics.drawRect(0,0,_canvasRect.width,_canvasRect.height);
			_bgRect.graphics.endFill();
			_bgRect.blendMode = "lighten";
			this.addChild(_bgRect);
			matrix.createGradientBox(_canvasRect.width,_canvasRect.height,0,0,0);
			_bgCircle.graphics.beginGradientFill("radial",[0x000000,0x0C0022],[1,1],[0xAA,0xFF],matrix);
			_bgCircle.graphics.drawCircle(_canvasRect.width/2,_canvasRect.height/2,_r/2.2);
			_bgCircle.graphics.endFill();
			_bgCircle.blendMode = "lighten";
			
			_tf = new TextField();
			_tf.defaultTextFormat = new TextFormat("_sans",12);
			_tf.height = 21;
			_tf.width = 200;
			_tf.textColor = 0x777777;
			_tf.selectable = false;
			this.addChild(_tf);
			
			this.addEventListener(Event.ENTER_FRAME,atEnterFrame);
			stage.addEventListener(MouseEvent.CLICK,atClick);
			
			_r =  (Math.max(_canvasRect.width,_canvasRect.height)/2.2)*2.4;
			_canvasRect.y = stage.stageHeight/2;
		}
		private function atClick(event:MouseEvent):void{
			_mode ++;
			_mode = _mode%3;
			if(_mode == 0){
				_view ++;
				_view = _view%2;
				_dataMgr.init(_view);
				if(_view == 1){
					_canvasRect.y = 0;
					_r = Math.max(_canvasRect.width,_canvasRect.height)/2.2;
					this.removeChild(_bgRect);
					this.addChild(_bgCircle);
				}else{
					_canvasRect.y = _canvasRect.height/2;
					_r = (Math.max(_canvasRect.width,_canvasRect.height)/2.2)*2.4;
					this.removeChild(_bgCircle);
					this.addChild(_bgRect);
				}
			}
		}
		
		private function atEnterFrame(event:Event):void{
			var n:int;
			var i:int;
			var vector:Vector.<Number>;

			_bitmapData.lock();
			_bitmapData.colorTransform(_bitmapData.rect, FADE);
			
			//Stars星
			vector = _dataMgr.getPoz();
			
			n = vector.length/3;
			for (i = 0; i < n; i++) {
				if(vector[i*3+2] > 0){
					/*
					星のHR番号
					if(_dataMgr.hr[i][1] == _dataMgr.testNum){
						var tf0:TextField = new TextField();
						tf0.defaultTextFormat = new TextFormat("_sans",9);
						tf0.text = String(_dataMgr.hr[i][0]);
						tf0.autoSize = "left";
						tf0.textColor = 0x777777;
						_bitmapData.draw(tf0,new Matrix(1,0,0,1,vector[i*3]*_r+_canvasRect.width/2,vector[i*3+1]*_r+_canvasRect.height/2));
					}
					*/
					//2等星以上の場合は、ちょっとだけ大きいまる
					var mag:int = _dataMgr.magnitude[i];
					if(mag <= 2){
						var star:Shape = new Shape();
						star.graphics.beginFill(_dataMgr.colors[i]);
						star.graphics.drawCircle(vector[i*3]*_r+_canvasRect.width/2,vector[i*3+1]*_r+_canvasRect.height/2+_canvasRect.y,(4-mag)/2);
						star.graphics.endFill();
						_bitmapData.draw(star);
					}else{
						_bitmapData.setPixel(vector[i*3]*_r+_canvasRect.width/2,vector[i*3+1]*_r+_canvasRect.height/2+_canvasRect.y,_dataMgr.colors[i]);
					}
				}
			}
			
			//Constellation星座
			n = _dataMgr.constellation.length;
			if(_mode > 1){n = 0};
			for (i = 0; i < n; i++) {
				var j:int;
				var m:int = _dataMgr.constellation[i].length-1;
				var s0:int;
				var s1:int;
				var titlePoz:Array = [];
				//見える範囲にある星だけを
				var shape:Shape = new Shape();
				for (j = 0; j < m; j++) {
					shape.graphics.lineStyle(1,0x222222,1);
					s0 = _dataMgr.constellation[i][j];
					s1 = _dataMgr.constellation[i][j+1];
					if(vector[s0*3+2] < 0 || vector[s1*3+2] < 0){
						continue;
					}
					if((vector[s0*3+1] > 0.2 || vector[s1*3+1] > 0.2) && _view == 0){
						continue;
					}
					titlePoz.push(new Point(vector[s0*3]*_r+_canvasRect.width/2,vector[s0*3+1]*_r+_canvasRect.height/2+_canvasRect.y));
					shape.graphics.moveTo(vector[s0*3]*_r+_canvasRect.width/2,vector[s0*3+1]*_r+_canvasRect.height/2+_canvasRect.y);
					shape.graphics.lineTo(vector[s1*3]*_r+_canvasRect.width/2,vector[s1*3+1]*_r+_canvasRect.height/2+_canvasRect.y);
				}
				//ひとつも描かれなければ、つぎへ
				if(shape.width == 0){
					continue;
				}
				_bitmapData.draw(shape,null,null,"lighten");
				if(_mode > 0){continue};
				//星座名
				var constellationName:TextField = new TextField();
				constellationName.defaultTextFormat = new TextFormat("_sans");
				constellationName.text = _dataMgr.getConstellationName(i);
				constellationName.autoSize = "left";
				constellationName.textColor = 0x666666;
				//表示されている星の位置の中央に来るように
				m = titlePoz.length;
				var titlePoint:Point = new Point();
				for (j = 0; j < m; j++) {
					titlePoint.x += titlePoz[j].x/m;
					titlePoint.y += titlePoz[j].y/m;
				}
				_bitmapData.draw(constellationName,new Matrix(1,0,0,1,titlePoint.x,titlePoint.y));
			}
			//Compass方位
			vector = _dataMgr.getCompass();
			n = vector.length/3;
			for (i = 0; i < n; i++) {
				if(vector[i*3+2] > 0 || _view == 1){
					var x:Number = vector[i*3]*_r+_canvasRect.width/2;
					var y:Number = vector[i*3+1]*_r+_canvasRect.height/2+_canvasRect.y;
					//_bitmapData.setPixel(x,y,0xFF0000);//ドット
					var tf:TextField = new TextField();
					tf.defaultTextFormat = new TextFormat("_sans",14);
					tf.text = NEWS[i];
					tf.autoSize = "left";
					tf.textColor = 0x333399;
					_bitmapData.draw(tf,new Matrix(1,0,0,1,x-tf.width/2,y-20));
				}
			}
			
			_bitmapData.unlock();
			
			var mouseX:Number = stage.mouseX;
			var mouseY:Number = stage.mouseY;
			if(_view == 0 && 0 < mouseX && mouseX < _canvasRect.width){
				var degreeX:Number = -(mouseX-_canvasRect.width/2)/100;
				if(Math.abs(degreeX) > 1){
					_dataMgr.appendRotationY(degreeX/2);
				}
			}
			if(_view == 0 && 0 < mouseY && mouseY < _canvasRect.height){
				var degreeY:Number = -(mouseY-_canvasRect.height/2)/100;
				if(Math.abs(degreeY) > 1){
					_dataMgr.appendRotationZ(degreeY/2);
				}
			}
			//時刻表時
			_tf.text = _dataMgr.getDateText();
		}
	}
}
import flash.display.Sprite;
import flash.geom.Matrix3D;
import flash.geom.Vector3D;

class DataMgr{
	//private var _count:int;
	private var _matrix3D:Matrix3D;
	private var _vin:Vector.<Number>;
	private var _matrix3DCompass:Matrix3D;
	private var _vinCompass:Vector.<Number>;
	public var colors:Vector.<Number>;
	public var magnitude:Vector.<Number>;
	public var hr:Array = [];//
	private var source:Source = new Source("all");
	public function DataMgr(){
		_matrix3D = new Matrix3D();
		_matrix3DCompass = new Matrix3D();
		init();
		_vin = new Vector.<Number>();
		colors = new Vector.<Number>();
		magnitude = new Vector.<Number>();
		magnitude = source.magnitude.concat();
		trace("星の数",source.length)
		for (var i:int = 0; i < source.length; i++) {
			//球面に貼付ける
			//なぜ0.9を足すとちょうどいいのかはわからないw
			var sX:Number = Math.PI*(source.rightAscension[i]/180+0.9);
			var sY:Number = Math.PI*(source.declination[i]/180);
			_vin = _vin.concat(Vector.<Number>([Math.cos(sY)*Math.cos(sX), Math.cos(sY)*Math.sin(sX), Math.sin(sY)]));
			//色
			colors[i] = colorCollection(magnitude[i],source.colors[i]);
			hr[i] = [source.HRNumber[i],source.constellation[i]];
		}
		//compass
		_vinCompass = new Vector.<Number>();
		for (i = 0; i < 8; i++) {
			var cX:Number = Math.PI;
			var cY:Number = Math.PI*(i/4);
			_vinCompass = _vinCompass.concat(Vector.<Number>([Math.cos(cY)*Math.cos(cX), Math.cos(cY)*Math.sin(cX), Math.sin(cY)]));
		}
		//星座
		constellation = [];
		var ar:Array = [];
		var temp:Array = [];
		for (i = 0; i < source.length; i++) {
			ar[i] = source.HRNumber[i];
			//作成時用
//			if(constellation[i] == testNum){
//				temp.push(HRNumber[i]);
//			}
		}
		//if(temp.length > 0){
			//trace(temp);
		//}
		//
		var n:int = source.CONSTELLATION.length;
		for (i = 0; i < n; i++) {
			var array:Array = [];
			for (var j:int = 0; j < source.CONSTELLATION[i].line.length; j++) {
				var t:int = ar.indexOf(source.CONSTELLATION[i].line[j]);
				if(t > 0){
					array.push(t);
				}else{
					//STARSにCONSTELLATION上の番号が無い時
					trace(source.CONSTELLATION[i].line[j],source.CONSTELLATION[i].name,i,j)
				}
				
			}
			constellation[i] = array.concat();
		}
	}
	public function init(view:int = 0):void{
		_matrix3D.identity();
		_matrix3DCompass.identity();
		//北緯35.41（東京）
		_matrix3D.appendRotation(35.41,Vector3D.X_AXIS);
		//現在の時刻ぶん回転
		setTime();
		if(view == 0){
			//北を向く
			_matrix3D.appendRotation(_rY,Vector3D.Y_AXIS);
			_matrix3DCompass.appendRotation(_rY,Vector3D.Y_AXIS);
			//_matrix3D.prependRotation(-_rZ,Vector3D.Z_AXIS);
		}else{
			//頂点を向く
			_matrix3D.appendRotation(-90,Vector3D.X_AXIS);
			_matrix3DCompass.appendRotation(-90,Vector3D.X_AXIS);
		}
		_matrix3D.prependRotation(-_rZ,Vector3D.Z_AXIS);
	}
	public function getDateText():String{
		var date:Date = new Date();
		date.setTime(date.getTime()+86164090.54*_rZ/360);
		var str:String = String(date.getFullYear())+"年"+String(date.getMonth()+1)+"月"+String(date.getDate())+"日";
		str += String(date.getHours())+"時"+String(date.getMinutes())+"分";
		return str;
	}
	private function setTime():void{
		//星座の座標は2000分点（2000年時の座標なので2000年1月1日からどれだけ回転したかを求める。）
		var date:Date = new Date();
		//946652400000は1970年1月1日から2000年までのミリ秒
		//86164090.54は地球が一回転（約一日）するまでのミリ秒
		var rotation:Number = (date.time-946652400000)%86164090.54;
		rotation　/= 86164090.54;
		_matrix3D.prependRotation(-rotation*360,Vector3D.Z_AXIS);
	}
	private function colorCollection(magnitude:Number,spectals:Number):int{
		var r:int = spectals >> 16;
		var g:int = spectals >> 8 & 0xFF;
		var b:int = spectals & 0xFF;
		var percent:Number = (8-magnitude)/9;
		percent = percent*0.9 + 0.1;
		r = Math.floor(r*percent);
		g = Math.floor(g*percent);
		b = Math.floor(b*percent);
		return r*(0x10000)+g*(0x100)+b;
	}
	private var _rY:Number = 0;
	private var _rZ:Number = 0;
	public function appendRotationZ(degrees:Number):void{
		degrees /= 2;
		_matrix3D.prependRotation(degrees,Vector3D.Z_AXIS);
		_rZ -= degrees;
	}
	public function appendRotationY(degrees:Number):void{
		_matrix3D.appendRotation(degrees,Vector3D.Y_AXIS);
		_matrix3DCompass.appendRotation(degrees,Vector3D.Y_AXIS);
		_rY += degrees;
	}
	public function getCompass():Vector.<Number>{
		var vout:Vector.<Number> = new Vector.<Number>();
		_matrix3DCompass.transformVectors(_vinCompass,vout);
		return vout;
	}
	public function getPoz():Vector.<Number>{
		var vout:Vector.<Number> = new Vector.<Number>();
		_matrix3D.transformVectors(_vin,vout);
		return vout;
	}
	public var testNum:int = -1;//
	public function getConstellationName(value:Number):String{
		return source.CONSTELLATION[value].name;
	}
	public var constellation:Array;
}
class Source{
	public var HRNumber:Vector.<Number>;//HR番号
	public var constellation:Vector.<Number>;//星座
	public var rightAscension:Vector.<Number>;//赤経
	public var declination:Vector.<Number>;//赤緯
	public var magnitude:Vector.<Number>;//視等級
	public var colors:Vector.<Number>;//色
	public var length:int;
	private const SPECTALS:Array = [0x7f7fff,0xbfbfff,0xffffff,0xffffbf,0xffff7f,0xffbf7f,0xff7f7f,0xbf7f7f];
	public function Source(type:String = "all"){
		if(type == "all"){
			length = STARS_ALL.length;
		}else{
			length = STARS.length;
		}
		HRNumber = new Vector.<Number>(length,true);
		constellation = new Vector.<Number>(length,true);
		rightAscension = new Vector.<Number>(length,true);
		declination = new Vector.<Number>(length,true);
		magnitude = new Vector.<Number>(length,true);
		colors = new Vector.<Number>(length,true);
		for (var i:int = 0; i < length; i++) {
			if(type == "all"){
				HRNumber[i] = STARS_ALL[i][0];
				constellation[i] = STARS_ALL[i][1];
				rightAscension[i] = STARS_ALL[i][5]*15+STARS_ALL[i][6]*15/60+STARS_ALL[i][7]*15/3600;
				declination[i] = (1-2*STARS_ALL[i][8])*(STARS_ALL[i][9]+STARS_ALL[i][10]/60+STARS_ALL[i][11]/3600);
				magnitude[i] = STARS_ALL[i][12]-1;
				colors[i] = SPECTALS[STARS_ALL[i][13]];
			}else{
				HRNumber[i] = STARS[i][0];
				constellation[i] = STARS[i][1];
				rightAscension[i] = STARS[i][5];
				declination[i] = STARS[i][6];
				magnitude[i] = STARS[i][7]-1;
				colors[i] = SPECTALS[STARS[i][8]];
			}
		}
	}
	public const CONSTELLATION:Array = [
		{name:"アンドロメダ",line:[8961,8976,8965,8762,8965,154,15,165,215,165,337,603,337,269,226,335,464]}//0.
		,{name:"ポンプ",line:[3765,4104,4273]}//1.
		,{name:"ふうちょう",line:[5470,6102,6163,5470]}//2.
		,{name:"わし",line:[7710,7602,7557,7525,7235,7176,7235,7525,7377,7236,7193]}//3.
		,{name:"みずがめ",line:[7950,8232,8414,8518,8499,8418,8499,8518,8558,8539,8558,8597,8698,8679,8709,8812,8892,8858,8834,8597]}//4.
		,{name:"さいだん",line:[6229,6285,6295,6510,6743,6510,6461,6462,6500]}//5.
		,{name:"おひつじ",line:[838,545,553,617]}//6.
		,{name:"ぎょしゃ",line:[1641,1605,1708,2088,2077,2088,2095,1791,1577,1641,1708]}//7.
		,{name:"うしかい",line:[5185,5235,5340,5478,5340,5506,5681,5602,5435,5351,5404,5351,5435,5429,5340]}//8.
		,{name:"ちょうこくぐ",line:[1502,1503,1652]}//9.
		,{name:"きりん",line:[1148,1542,1603,1568]}//10.
		,{name:"やぎ",line:[7747,7776,7936,7980,8204,8260,8278,8322,8278,8075,7776]}//11.
		,{name:"りゅうこつ",line:[2326,3117,3307,3699,4199,3699,3685,4037]}//12.
		,{name:"カシオペア",line:[21,168,264,403,542]}//13.
		,{name:"ケンタウルス",line:[5459,5267,5132,5231,5249,5193,5190,5028,5288,5440,5576,5440,5288,5028,4819,4743,4621]}//14.
		,{name:"ケフェウス",line:[8571,8494,8465,8694,8974,8238,8162,8465,8162,7957,7850]}//15.
		,{name:"くじら",line:[74,188,334,402,539,509,539,681,811,681,779,718,813,896,911,804,718]}//16.
		,{name:"カメレオン",line:[3318,4174,4674]}//17.
		,{name:"コンパス",line:[5670,5463,5704]}//18.
		,{name:"おおいぬ",line:[2294,2429,2491,2574,2657,2491,2693,2580,2693,2618,2693,2827]}//19.
		,{name:"こいぬ",line:[2845,2943]}//20.
		,{name:"かに",line:[3249,3461,3572,3461,3449,3475]}//21.
		,{name:"はと",line:[1862,1956,2040,2120,2040,2106,2296]}//22.
		,{name:"かみのけ",line:[4983]}//23.
		,{name:"みなみのかんむり",line:[6951,7226,7254,7259,7242]}//24.
		,{name:"かんむり",line:[5778,5747,5793,5849,5889,5947,5971]}//25.
		,{name:"コップ",line:[4287,4343,4405,4514,4567,4468,4402,4382,4287]}//26.
		,{name:"みなみじゅうじ",line:[4730,4763,4853,4656]}//27.
		,{name:"からす",line:[4623,4630,4662,4757,4786,4630]}//28.
		,{name:"りょうけん",line:[4785,4915]}//29.
		,{name:"はくちょう",line:[7328,7420,7528,7796,7924,7796,7949,8115,7949,7796,7417]}//30.
		,{name:"いるか",line:[7852,7882,7906,7948,7928,7882]}//31.
		,{name:"かじき",line:[1338,1465,1922,2015]}//32.
		,{name:"りゅう",line:[4434,4787,5291,5744,5986,6132,6396,6920,7582,7310,6688,6554,6536,6705,6688]}//33.
		,{name:"こうま",line:[8097,8131,8123]}//34.
		,{name:"エリダヌス",line:[472,566,721,794,897,1347,1393,1464,1453,1240,1213,1173,1088,1003,919,818,874,1084,1136,1162,1231,1298,1463,1520,1666]}//35.
		,{name:"ろ",line:[612,841,963]}//36.
		,{name:"ふたご",line:[2134,2216,2286,2473,2697,2540,2697,2891,2990,2777,2763,2777,2650,2421,2484]}//37.
		,{name:"つる",line:[8353,8411,8486,8556,8636,8425,8636,8675,8747]}//38.
		,{name:"ヘルクレス",line:[6779,6703,6623,6526,6410,6406,6148,6095,6117,6159,6117,6095,6148,6212,6220,6168,6092,6023,5914,6023,6092,6168,6220,6418,6324,6410,6324,6418,6484,6695,6588]}//39.
		,{name:"とけい",line:[778,934,909,934,1326]}//40.
		,{name:"うみへび",line:[3547,3482,3410,3418,3454,3547,3665,3845,3748,3903,3970,3994,4094,4232,4450,4552,5020,5287,5526]}//41.
		,{name:"みずへび",line:[1208,98,591]}//42.
		,{name:"インディアン",line:[7869,7920,7986,8368]}//43.
		,{name:"とかげ",line:[8498,8579,8632,8523,8572,8541,8585,8538]}//44.
		,{name:"しし",line:[3773,3873,3905,4031,4057,3975,4357,4534,4359,4399,4386,4399,4359,3982,3975]}//45.
		,{name:"うさぎ",line:[1705,1702,1756,1702,1865,1829,1654,1829,1865,2035,1983,2035,1998,1865,1998,2085,2155]}//46.
		,{name:"てんびん",line:[5603,5531,5685,5787,5603]}//47.
		,{name:"こじし",line:[3974,4100,4247]}//48.
		,{name:"おおかみ",line:[5649,5683,5708,5776,5948,5883,5948,5776,5695,5571,5469]}//49.
		,{name:"やまねこ",line:[2238,2560,2818,3275,3690,3705]}//50.
		,{name:"こと",line:[7051,7001,7056,7106,7178,7139,7056]}//51.
		,{name:"テーブルさん",line:[1677,2261,2689]}//52.
		,{name:"けんびきょう",line:[7965,8039,8048]}//53.
		,{name:"いっかくじゅう",line:[3188,2714,2506,2298,2385,2298,2356,2298,2227]}//54.
		,{name:"はえ",line:[4520,4671,4798,4844,4923,4773,4798]}//55.
		,{name:"じょうぎ",line:[5980,5962,6072,6115]}//56.
		,{name:"はちぶんぎ",line:[5339,8630,8254]}//57.
		,{name:"へびつかい",line:[6104,6112,6147,6075,6056,6075,6149,6299,6556,6603,6629,6698,6378,6453,6492,6453,6378,6147]}//58.
		,{name:"オリオン",line:[1601,1567,1552,1543,1544,1570,1580,1638,1790,1852,1788,1713,2004,1948,2061,1879,1790,1879,2061,2124,2199,2159,2135,2047]}//59.
		,{name:"くじゃく",line:[7790,8181,7913,7665,7074,6582,6982,7590,8181]}//60.
		,{name:"ペガスス",line:[8308,8450,8634,8781,39,15,8775,8650,8454,8650,8775,8781,8775,8684,8667,8430,8315]}//61.
		,{name:"ペルセウス",line:[1261,1303,1273,1122,1017,915,834,496,834,915,854,799,936,921,936,799,941,1220,1228,1203,1131]}//62.
		,{name:"ほうおう",line:[25,99,322,429,440,322,338]}//63.
		,{name:"がか",line:[2042,2550,2020]}//64.
		,{name:"みなみのうお",line:[8431,8576,8695,8720,8728,8628,8326,8305,8431]}//65.
		,{name:"うお",line:[352,383,360,437,510,595,489,294,224,9072,8984,8911,8852,8916,8969,9072]}//66.
		,{name:"とも",line:[2451,2773,3045,3185,3165,2773]}//67.
		,{name:"らしんばん",line:[3438,3468,3518]}//68.
		,{name:"レチクル",line:[1175,1336,1355,1247,1175]}//69.
		,{name:"ちょうこくしつ",line:[280,9016,8863,8937]}//70.
		,{name:"さそり",line:[5928,5944,5953,5984,6027,5984,5953,6084,6134,6165,6241,6247,6271,6380,6553,6615,6580,6508,6527]}//71.
		,{name:"たて",line:[6930,6973,7063,7020]}//72.
		,{name:"へび",line:[5867,5842,5879,5933,5867,5788,5854,5892,5881,6561,6869,7141]}//73.
		,{name:"ろくぶんぎ",line:[3909,3981,4119]}//74.
		,{name:"や",line:[7479,7536,7488,7536,7635]}//75.
		,{name:"いて",line:[6746,6859,6879,6832,6879,6859,7039,6913,6812,6913,7039,7121,7234,7194]}//76.
		,{name:"おうし",line:[1910,1457,1412,1346,1239,1030,1251,1101,1251,1030,1038,1373,1346,1373,1409,1791]}//77.
		,{name:"ぼうえんきょう",line:[6783,6897,6905]}//78.
		,{name:"みなみのさんかく",line:[5671,5897,6217,5671]}//79.
		,{name:"さんかく",line:[544,622,664,544]}//80.
		,{name:"きょしちょう",line:[8540,8502,8848,126,77,9076,8848]}//81.
		,{name:"おおぐま",line:[3569,3594,3775,3888,3757,3323,3888,3775,4518,4335,4069,4033,4069,4335,4518,4377,4375,4377,4518,4554,4660,4554,4295,4301,3888,4301,4660,4905,5054,5191]}//82
		,{name:"こぐま",line:[424,6789,6322,5903,6116,5735,5563]}//83.
		,{name:"ほ",line:[3207,3485,3734,3940,4216,3786,3634,3207]}//84.
		,{name:"おとめ",line:[4517,4608,4932,4910,5264,5511,5264,4910,5107,4910,4825,4963,5338,5487,5338,4963,5056,4963,4825,4689,4540]}//85.
		,{name:"とびうお",line:[2736,3223,2803,3223,3347,3615]}//86.
		,{name:"こぎつね",line:[7405,7592]}//87.
	];
	//[HR番号,星座,バイエル符号(ギリシア文字),バイエル符号の上（下）付き数字,フラムスティード番号,赤経,赤緯,視等級（四捨五入した整数）格納値=実際の視等級+1,スペクトル分類]
	//http://www3.plala.or.jp/cielo/graffias/data/star.html
	private const STARS_ALL:Array = [
		[1,88,24,0,0,0,5,10,0,45,13,45,8,2],
		[2,88,24,0,0,0,5,4,1,0,30,11,7,4],
		[3,66,24,0,33,0,5,20,1,5,42,27,6,5],
		[4,61,24,0,86,0,5,42,0,13,23,46,7,4],
		[5,88,24,0,0,0,6,16,0,58,26,12,7,4],
		[6,88,24,0,0,0,6,19,1,49,4,30,7,4],
		[7,13,24,0,10,0,6,27,0,64,11,46,7,1],
		[8,88,24,0,0,0,6,37,0,29,1,17,7,5],
		[9,88,24,0,0,0,6,50,1,23,6,27,7,2],
		[10,88,24,0,0,0,7,18,1,17,23,11,7,2],
		[11,88,24,0,0,0,7,44,1,2,32,56,7,1],
		[12,88,24,0,0,0,7,47,1,22,30,32,7,2],
		[13,88,24,0,0,0,8,4,1,33,31,46,7,5],
		[14,88,24,0,0,0,8,12,1,2,26,52,7,5],
		[15,0,0,0,21,0,8,23,0,29,5,26,3,1],
		[16,88,24,0,0,0,8,17,1,8,49,26,7,4],
		[17,88,24,0,0,0,8,41,0,36,37,36,7,3],
		[18,88,24,0,0,0,8,33,1,17,34,39,7,7],
		[19,88,24,0,0,0,8,52,0,25,27,46,7,5],
		[20,88,24,0,0,0,9,20,0,79,42,53,7,2],
		[21,13,1,0,11,0,9,11,0,59,8,59,3,3],
		[22,61,24,0,87,0,9,2,0,18,12,43,7,4],
		[23,88,24,0,0,0,9,2,1,54,0,7,7,4],
		[24,70,9,1,0,0,9,21,1,27,59,16,6,3],
		[25,63,4,0,0,0,9,25,1,45,44,51,5,5],
		[26,66,24,0,34,0,10,2,0,11,8,44,7,1],
		[27,0,24,0,22,0,10,19,0,46,4,20,6,3],
		[28,88,24,0,0,0,10,30,0,57,9,56,8,1],
		[29,88,24,0,0,0,10,19,1,5,14,55,7,5],
		[30,57,2,3,0,0,10,2,1,82,13,26,6,4],
		[31,88,24,0,0,0,10,43,1,12,34,48,7,5],
		[32,88,24,0,0,0,10,39,1,73,13,28,8,3],
		[33,16,24,0,6,0,11,16,1,15,28,5,6,3],
		[34,70,9,2,0,0,11,34,1,27,47,59,6,5],
		[35,70,7,0,0,0,11,44,1,35,7,59,6,3],
		[36,88,24,0,0,0,11,59,0,48,9,9,7,5],
		[37,88,24,0,0,0,12,10,1,17,56,18,6,5],
		[38,88,24,0,0,0,12,50,0,37,41,36,8,1],
		[39,61,2,0,88,0,13,14,0,15,11,1,4,1],
		[40,88,24,0,0,0,13,24,0,26,59,14,7,4],
		[41,0,24,0,23,0,13,31,0,41,2,7,7,3],
		[42,88,24,0,0,0,13,42,1,26,1,19,7,5],
		[43,88,24,0,0,0,13,44,1,26,17,5,7,5],
		[44,88,24,0,0,0,14,2,0,33,12,22,7,2],
		[45,61,21,0,89,0,14,36,0,20,12,24,6,7],
		[46,88,24,0,0,0,14,28,1,7,46,50,6,7],
		[47,88,24,0,0,0,13,19,1,84,59,39,7,7],
		[48,16,24,0,7,0,14,38,1,18,55,58,5,7],
		[49,88,24,0,0,0,14,56,0,22,17,3,7,2],
		[50,66,24,0,35,0,14,59,0,8,49,15,7,3],
		[51,88,24,0,0,0,14,55,1,9,34,11,7,1],
		[52,88,24,0,0,0,15,7,0,31,32,9,7,5],
		[53,88,24,0,0,0,15,11,0,27,16,59,7,2],
		[54,88,24,0,0,0,14,58,1,34,54,16,7,5],
		[55,88,24,0,0,0,16,14,0,76,57,3,7,1],
		[56,88,24,0,0,0,16,22,0,43,35,41,7,2],
		[57,88,24,0,0,0,16,9,1,31,26,47,7,5],
		[58,88,24,0,0,0,15,55,1,75,54,41,7,4],
		[59,66,24,0,36,0,16,34,0,8,14,24,7,4],
		[60,88,24,0,0,0,16,57,0,61,32,0,7,4],
		[61,88,24,0,0,0,16,43,1,20,12,38,7,1],
		[62,88,24,0,0,0,17,9,0,47,56,51,7,1],
		[63,0,7,0,24,0,17,6,0,38,40,54,6,2],
		[64,88,24,0,0,0,16,49,1,78,46,50,8,3],
		[65,88,24,0,0,0,17,43,0,51,25,59,7,0],
		[66,88,24,0,0,0,17,33,1,19,3,4,7,3],
		[67,88,24,0,0,0,17,48,0,1,41,20,7,5],
		[68,0,17,0,25,0,18,20,0,36,47,7,6,2],
		[69,88,24,0,0,0,18,17,0,11,12,21,7,5],
		[70,0,24,0,26,0,18,42,0,43,47,28,7,1],
		[71,88,24,0,0,0,18,38,0,31,31,2,7,2],
		[72,88,24,0,0,0,18,42,1,8,3,10,7,4],
		[73,88,24,0,0,0,18,43,1,43,14,7,7,5],
		[74,16,8,0,8,0,19,26,1,8,49,26,5,5],
		[75,88,24,0,0,0,19,42,0,40,43,47,7,5],
		[76,88,24,0,0,0,20,5,0,48,51,55,8,2],
		[77,81,5,0,0,0,20,4,1,64,52,29,5,3],
		[78,88,24,0,0,0,20,24,0,30,56,9,7,1],
		[79,88,24,0,0,0,20,46,0,32,54,41,7,5],
		[80,66,24,0,41,0,20,36,0,8,11,25,6,5],
		[81,88,24,0,0,0,20,55,0,10,58,37,8,2],
		[82,0,16,0,27,0,21,7,0,37,58,7,6,3],
		[83,81,15,0,0,0,20,39,1,69,37,30,7,1],
		[84,70,8,0,0,0,21,31,1,28,58,54,6,4],
		[85,88,24,0,0,0,21,46,1,20,3,28,6,7],
		[86,66,24,0,42,0,22,26,0,13,28,57,7,5],
		[87,88,24,0,0,0,21,29,1,77,25,37,7,5],
		[88,16,24,0,9,0,22,52,1,12,12,34,7,4],
		[89,88,24,0,0,0,23,13,1,31,2,10,8,1],
		[90,88,24,0,0,0,24,2,0,38,34,38,8,7],
		[91,88,24,0,0,0,24,16,0,52,1,12,7,1],
		[93,13,24,0,12,0,24,48,0,61,49,52,6,1],
		[94,88,24,0,0,0,24,30,1,2,13,9,7,5],
		[96,88,24,0,0,0,25,6,0,53,2,49,7,1],
		[97,66,24,0,44,0,25,24,0,1,56,23,7,4],
		[98,42,1,0,0,0,25,45,1,77,15,15,4,4],
		[99,63,0,0,0,0,26,17,1,42,18,22,3,5],
		[100,63,9,0,0,0,26,12,1,43,40,48,5,2],
		[101,16,24,0,10,0,26,37,1,0,2,59,7,4],
		[102,88,24,0,0,0,27,15,1,25,32,50,7,4],
		[103,66,24,0,47,0,28,3,0,17,53,35,6,7],
		[104,88,24,0,0,0,28,14,0,44,23,40,6,2],
		[105,70,6,0,0,0,27,56,1,33,0,26,6,7],
		[106,66,24,0,48,0,28,13,0,16,26,42,7,5],
		[107,88,24,0,0,0,28,20,0,10,11,23,7,3],
		[108,88,24,0,0,0,28,21,1,20,20,6,7,4],
		[109,88,24,0,0,0,28,26,1,39,54,54,6,7],
		[110,88,24,0,0,0,28,57,0,36,54,0,7,4],
		[111,88,24,0,0,0,28,43,1,50,31,58,7,5],
		[112,88,24,0,0,0,30,55,0,77,1,10,7,5],
		[113,88,24,0,0,0,30,20,0,59,58,38,7,1],
		[114,0,24,0,28,0,30,7,0,29,45,6,6,2],
		[115,88,24,0,0,0,29,52,1,14,51,51,7,3],
		[116,88,24,0,0,0,29,49,1,32,7,0,8,5],
		[117,16,24,0,12,0,30,2,1,3,57,26,7,7],
		[118,88,24,0,0,0,30,23,1,23,47,16,6,2],
		[119,88,24,0,0,0,30,28,1,40,56,22,7,3],
		[120,88,24,0,0,0,30,26,1,48,12,54,7,3],
		[121,13,24,0,13,0,31,25,0,66,31,10,7,1],
		[122,88,24,0,0,0,31,26,0,33,34,54,7,5],
		[123,13,10,0,14,0,31,46,0,54,31,20,6,1],
		[124,88,24,0,0,0,31,41,0,52,50,22,7,5],
		[125,63,10,1,0,0,31,25,1,48,48,13,6,2],
		[126,81,1,1,0,0,31,33,1,62,57,29,5,1],
		[127,81,1,2,0,0,31,34,1,62,57,57,6,2],
		[128,88,24,0,0,0,32,27,0,43,29,41,8,2],
		[129,88,24,0,0,0,33,19,0,70,58,54,7,2],
		[130,13,9,0,15,0,33,0,0,62,55,54,5,1],
		[131,66,24,0,52,0,32,36,0,20,17,40,6,5],
		[132,66,24,0,51,0,32,24,0,6,57,20,7,1],
		[133,88,24,0,0,0,32,35,0,27,34,50,8,2],
		[134,88,24,0,0,0,32,49,0,28,16,49,7,5],
		[135,88,24,0,0,0,33,10,0,54,53,42,7,5],
		[136,81,1,3,0,0,32,44,1,63,1,52,6,2],
		[137,13,24,0,16,0,34,25,0,66,45,1,7,1],
		[138,88,24,0,0,0,33,41,1,29,33,30,7,5],
		[139,81,7,0,0,0,33,23,1,71,15,58,7,2],
		[140,88,24,0,0,0,34,28,1,52,22,23,7,3],
		[141,88,24,0,0,0,34,55,0,13,22,16,7,5],
		[142,16,24,0,13,0,35,15,1,3,35,34,6,3],
		[143,16,24,0,14,0,35,33,1,0,30,20,7,3],
		[144,88,24,0,0,0,36,8,0,54,10,7,6,1],
		[145,88,24,0,0,0,35,55,0,13,12,24,7,3],
		[146,88,24,0,0,0,36,27,0,60,19,34,7,2],
		[147,63,10,2,0,0,35,41,1,48,0,3,7,3],
		[148,88,24,0,0,0,35,33,1,54,49,19,7,5],
		[149,88,24,0,0,0,36,20,0,27,15,17,8,1],
		[150,88,24,0,0,0,36,3,1,14,58,25,7,4],
		[151,88,24,0,0,0,36,7,1,22,50,33,7,2],
		[152,88,24,0,0,0,36,47,0,44,29,19,6,5],
		[153,13,5,0,17,0,36,58,0,53,53,49,5,1],
		[154,0,15,0,29,0,36,53,0,33,43,10,5,1],
		[155,66,24,0,53,0,36,47,0,15,13,54,7,1],
		[156,88,24,0,0,0,37,7,0,24,0,51,7,5],
		[157,88,24,0,0,0,37,21,0,35,23,58,6,4],
		[158,88,24,0,0,0,39,47,0,82,29,38,7,3],
		[159,88,24,0,0,0,37,21,1,24,46,2,7,4],
		[160,88,24,0,0,0,36,37,1,65,7,29,7,5],
		[161,88,24,0,0,0,37,31,0,3,8,7,7,5],
		[162,88,24,0,0,0,37,18,1,54,23,39,7,5],
		[163,0,4,0,30,0,38,33,0,29,18,42,5,4],
		[164,88,24,0,0,0,39,10,0,49,21,16,6,5],
		[165,0,3,0,31,0,39,20,0,30,51,39,4,5],
		[166,66,24,0,54,0,39,22,0,21,15,2,7,5],
		[167,66,24,0,55,0,39,56,0,21,26,18,6,5],
		[168,13,0,0,18,0,40,31,0,56,32,14,3,5],
		[169,88,24,0,0,0,38,41,1,73,8,14,8,2],
		[170,88,24,0,0,0,39,58,1,33,57,42,8,3],
		[171,88,24,0,0,0,39,52,1,44,47,48,7,5],
		[172,88,24,0,0,0,40,29,1,16,31,1,7,4],
		[173,88,24,0,0,0,40,33,1,23,48,16,7,4],
		[174,88,24,0,0,0,40,42,1,4,21,7,7,5],
		[175,0,24,0,32,0,41,7,0,39,27,31,6,4],
		[176,88,24,0,0,0,40,26,1,59,27,16,7,4],
		[177,88,24,0,0,0,42,3,0,66,8,51,7,4],
		[178,88,24,0,0,0,41,36,0,24,37,45,7,2],
		[179,13,13,0,19,0,42,4,0,50,30,45,6,1],
		[180,63,11,0,0,0,41,20,1,46,5,6,6,4],
		[181,88,24,0,0,0,42,31,0,58,45,12,7,1],
		[183,63,13,0,0,0,41,46,1,56,30,6,7,2],
		[184,13,15,0,20,0,43,28,0,47,1,29,6,2],
		[185,70,10,1,0,0,42,43,1,38,27,48,7,2],
		[186,88,24,0,0,0,42,42,1,60,15,45,7,5],
		[187,81,16,0,0,0,42,28,1,65,28,5,6,3],
		[188,16,1,0,16,0,43,35,1,17,59,12,3,4],
		[189,88,24,0,0,0,44,26,0,47,51,51,7,1],
		[190,88,24,0,0,0,43,50,1,12,0,42,7,5],
		[191,63,6,0,0,0,43,21,1,57,27,47,5,2],
		[192,13,24,0,21,0,45,39,0,74,59,17,7,2],
		[193,13,14,0,22,0,44,44,0,48,17,4,6,1],
		[194,16,20,1,17,0,44,11,1,10,36,34,6,5],
		[195,70,10,2,0,0,44,12,1,38,25,18,7,5],
		[196,88,24,0,0,0,45,17,0,55,13,18,6,2],
		[197,88,24,0,0,0,44,44,1,22,0,22,6,3],
		[198,88,24,0,0,0,44,57,1,42,40,36,7,3],
		[199,88,24,0,0,0,44,32,1,62,29,52,7,3],
		[200,88,24,0,0,0,46,39,0,69,19,30,7,3],
		[201,88,24,0,0,0,45,24,1,4,37,45,7,7],
		[202,88,24,0,0,0,45,0,1,53,42,54,7,3],
		[203,16,24,0,18,0,45,29,1,12,52,51,7,4],
		[204,88,24,0,0,0,46,15,0,55,18,19,8,2],
		[205,88,24,0,0,0,46,11,0,44,51,41,7,1],
		[206,88,24,0,0,0,45,42,1,16,25,27,7,3],
		[207,88,24,0,0,0,46,42,0,59,34,28,7,4],
		[208,13,24,0,23,0,47,46,0,74,50,51,6,1],
		[209,88,24,0,0,0,45,46,1,47,33,6,7,4],
		[210,88,24,0,0,0,46,12,1,22,31,19,7,4],
		[211,66,24,0,57,0,46,33,0,15,28,32,6,7],
		[212,88,24,0,0,0,48,9,0,72,40,30,7,5],
		[213,66,24,0,58,0,47,2,0,11,58,26,7,4],
		[214,66,24,0,59,0,47,14,0,19,34,44,7,3],
		[215,0,5,0,34,0,47,20,0,24,16,2,5,5],
		[216,66,24,0,60,0,47,24,0,6,44,27,7,4],
		[217,66,24,0,61,0,47,55,0,20,55,31,8,3],
		[218,88,24,0,0,0,47,43,1,18,3,41,7,5],
		[219,13,6,0,24,0,49,6,0,57,48,57,4,3],
		[220,88,24,0,0,0,48,1,1,21,43,21,7,1],
		[221,66,24,0,62,0,48,17,0,7,18,0,7,4],
		[222,88,24,0,0,0,48,23,0,5,16,50,7,5],
		[223,13,12,0,25,0,48,50,0,50,58,6,6,1],
		[224,66,3,0,63,0,48,41,0,7,35,6,5,5],
		[225,66,24,0,64,0,48,59,0,16,56,26,6,3],
		[226,0,12,0,35,0,49,49,0,41,4,44,6,1],
		[227,88,24,0,0,0,49,26,1,13,33,41,7,5],
		[228,88,24,0,0,0,49,14,1,24,8,11,7,5],
		[229,88,24,0,0,0,48,57,1,46,41,52,7,4],
		[230,66,24,0,65,0,49,53,0,27,42,39,8,3],
		[231,66,24,0,65,0,49,53,0,27,42,37,8,3],
		[232,88,24,0,0,0,49,33,1,23,21,42,7,2],
		[233,88,24,0,0,0,50,44,0,64,14,51,6,4],
		[234,88,24,0,0,0,50,18,0,45,0,8,7,2],
		[235,16,20,2,19,0,50,8,1,10,38,40,6,3],
		[236,42,10,0,0,0,48,35,1,74,55,24,6,5],
		[237,88,24,0,0,0,51,16,0,61,48,21,7,5],
		[238,88,24,0,0,0,50,57,0,51,30,29,7,3],
		[239,88,24,0,0,0,50,4,1,43,23,41,7,2],
		[240,88,24,0,0,0,54,53,0,83,42,26,7,2],
		[241,88,24,0,0,0,51,34,0,51,34,16,7,1],
		[242,63,16,0,0,0,50,41,1,50,59,13,6,3],
		[243,88,24,0,0,0,51,18,0,3,23,6,7,5],
		[244,88,24,0,0,0,53,4,0,61,7,27,6,3],
		[245,88,24,0,0,0,51,52,1,43,42,33,8,3],
		[246,88,24,0,0,0,52,53,0,38,32,55,8,2],
		[247,88,24,0,0,0,52,41,1,24,0,21,6,5],
		[248,16,24,0,20,0,53,1,1,1,8,39,6,7],
		[249,88,24,0,0,0,53,28,0,37,25,5,7,5],
		[250,88,24,0,0,0,53,48,0,52,41,21,7,2],
		[251,88,24,0,0,0,53,12,1,24,46,37,7,3],
		[252,81,10,1,0,0,52,24,1,69,30,16,7,3],
		[253,13,19,1,26,0,55,0,0,58,58,22,6,5],
		[254,66,24,0,66,0,54,35,0,19,11,18,7,2],
		[255,16,24,0,21,0,54,18,1,8,44,27,7,4],
		[256,88,24,0,0,0,55,5,0,48,40,43,7,7],
		[257,88,24,0,0,0,53,38,1,62,52,17,7,7],
		[258,0,24,0,36,0,54,58,0,23,37,42,6,5],
		[259,88,24,0,0,0,55,15,0,24,33,25,7,7],
		[260,88,24,0,0,0,56,13,0,57,59,48,7,5],
		[261,88,24,0,0,0,56,56,0,68,46,34,7,3],
		[262,66,24,0,67,0,55,59,0,27,12,34,7,2],
		[263,88,24,0,0,0,55,42,1,7,20,50,7,5],
		[264,13,2,0,27,0,56,43,0,60,43,0,3,1],
		[265,13,19,2,28,0,56,40,0,59,10,52,6,4],
		[266,88,24,0,0,0,56,47,0,60,21,46,7,1],
		[267,16,20,3,22,0,56,2,1,11,16,0,6,5],
		[268,88,24,0,0,0,55,56,1,27,46,32,7,7],
		[269,0,11,0,37,0,56,45,0,38,29,58,5,2],
		[270,81,10,2,0,0,55,0,1,69,31,37,6,5],
		[271,0,6,0,38,0,57,12,0,23,25,3,5,4],
		[272,88,24,0,0,0,57,40,0,45,50,23,7,5],
		[273,88,24,0,0,0,58,31,0,66,21,8,7,2],
		[274,66,24,0,68,0,57,50,0,28,59,32,6,4],
		[275,88,24,0,0,0,58,14,0,33,57,3,7,5],
		[276,88,24,0,0,0,57,55,0,13,41,45,7,4],
		[277,88,24,0,0,0,58,19,0,21,24,16,7,2],
		[278,88,24,0,0,1,0,31,0,70,58,59,7,2],
		[279,16,20,4,23,0,58,44,1,11,22,48,7,4],
		[280,70,0,0,0,0,58,36,1,29,21,27,5,1],
		[281,88,24,0,0,0,58,22,1,60,41,47,7,2],
		[282,88,24,0,0,1,0,3,0,44,42,40,8,2],
		[283,88,24,0,0,1,0,4,0,44,42,48,7,1],
		[284,88,24,0,0,0,59,50,0,6,28,59,7,7],
		[285,88,24,0,0,1,8,45,0,86,15,25,5,5],
		[286,88,24,0,0,1,33,50,0,89,0,56,7,2],
		[287,88,24,0,0,1,2,18,0,51,2,6,7,2],
		[288,70,13,0,0,1,1,18,1,38,55,0,7,5],
		[289,88,24,0,0,1,3,2,0,47,22,34,7,2],
		[290,0,24,0,39,1,2,54,0,41,20,42,7,2],
		[291,66,17,0,69,1,2,49,0,31,48,16,7,1],
		[292,88,24,0,0,1,3,37,0,61,4,30,7,3],
		[293,70,17,0,0,1,2,26,1,31,33,7,7,2],
		[294,66,4,0,71,1,2,57,0,7,53,24,5,5],
		[295,63,23,0,0,1,2,2,1,57,0,9,7,4],
		[296,16,24,0,25,1,3,3,1,4,50,12,6,5],
		[297,88,24,0,0,1,4,20,0,61,34,49,7,3],
		[298,88,24,0,0,1,4,2,0,52,30,8,7,5],
		[299,88,24,0,0,1,2,49,1,46,23,51,6,4],
		[300,88,24,0,0,1,3,18,1,29,31,33,7,4],
		[301,16,24,0,26,1,3,49,0,1,22,0,7,3],
		[302,88,24,0,0,1,4,47,0,51,0,36,8,1],
		[303,88,24,0,0,1,4,28,0,29,39,31,7,3],
		[304,88,24,0,0,1,2,43,1,65,27,22,7,7],
		[305,88,24,0,0,1,4,36,0,39,59,28,8,3],
		[306,88,24,0,0,1,16,14,0,87,8,43,7,5],
		[307,66,24,0,73,1,4,53,0,5,39,23,7,5],
		[308,66,24,0,72,1,5,5,0,14,56,46,7,3],
		[309,88,24,0,0,1,6,23,0,62,45,42,8,2],
		[310,66,22,1,74,1,5,41,0,21,28,24,6,2],
		[311,66,22,1,74,1,5,42,0,21,27,55,7,2],
		[312,88,24,0,0,1,9,12,0,80,0,42,7,4],
		[313,66,24,0,77,1,5,49,0,4,54,30,7,3],
		[314,66,24,0,77,1,5,51,0,4,54,34,8,3],
		[315,16,24,0,27,1,5,37,1,9,58,45,7,5],
		[316,88,24,0,0,1,7,0,0,56,56,6,7,5],
		[317,16,24,0,28,1,6,5,1,9,50,22,7,2],
		[318,88,24,0,0,1,7,10,0,53,29,54,7,5],
		[319,66,24,0,75,1,6,34,0,12,57,22,7,4],
		[320,88,24,0,0,1,6,8,1,23,59,33,7,4],
		[321,13,11,0,30,1,8,16,0,54,55,13,6,4],
		[322,63,1,0,0,1,6,5,1,46,43,7,4,4],
		[323,88,24,0,0,1,6,27,1,35,39,39,8,2],
		[324,0,24,0,41,1,8,1,0,43,56,31,6,2],
		[325,88,24,0,0,1,7,13,1,23,59,47,7,2],
		[326,88,24,0,0,1,8,33,0,58,15,49,7,1],
		[327,66,24,0,78,1,8,1,0,32,0,44,7,3],
		[328,66,22,2,79,1,7,57,0,20,44,21,7,2],
		[329,16,24,0,30,1,7,46,1,9,47,8,7,3],
		[330,66,24,0,80,1,8,22,0,5,38,59,7,3],
		[331,63,19,0,0,1,7,48,1,41,29,13,6,2],
		[332,81,8,0,0,1,7,19,1,61,46,31,6,4],
		[333,88,24,0,0,1,12,17,0,79,40,26,7,2],
		[334,16,6,0,31,1,8,35,1,10,10,56,4,5],
		[335,0,20,0,42,1,9,30,0,47,14,31,5,1],
		[336,13,24,0,31,1,10,39,0,68,46,43,6,2],
		[337,0,1,0,43,1,9,44,0,35,37,14,3,7],
		[338,63,5,0,0,1,8,23,1,55,14,45,5,1],
		[339,66,22,3,81,1,9,49,0,19,39,31,7,4],
		[340,0,24,0,44,1,10,19,0,42,4,53,7,3],
		[341,88,24,0,0,1,10,19,0,25,27,28,7,5],
		[342,88,24,0,0,1,11,26,0,64,12,10,7,1],
		[343,13,7,0,33,1,11,6,0,55,8,59,5,2],
		[344,88,24,0,0,1,10,12,0,15,40,27,7,7],
		[345,13,24,0,32,1,11,41,0,65,1,8,7,1],
		[346,16,24,0,32,1,10,12,1,8,54,22,7,5],
		[347,16,24,0,33,1,10,34,0,2,26,44,7,5],
		[348,0,24,0,45,1,11,10,0,37,43,27,7,1],
		[349,66,24,0,82,1,11,7,0,31,25,29,6,3],
		[350,88,24,0,0,1,10,7,1,57,41,40,7,4],
		[351,66,21,0,84,1,11,27,0,21,2,5,6,4],
		[352,66,18,0,83,1,11,40,0,30,5,23,6,5],
		[353,16,24,0,34,1,11,44,1,2,15,4,7,5],
		[354,88,24,0,0,1,13,10,0,61,42,21,7,1],
		[355,88,24,0,0,1,12,34,0,45,20,16,7,7],
		[356,88,24,0,0,1,12,60,0,30,3,51,7,4],
		[357,88,24,0,0,1,16,31,0,79,54,36,7,3],
		[358,88,24,0,0,1,12,23,1,30,48,8,8,3],
		[359,88,24,0,0,1,12,45,1,37,51,23,7,3],
		[360,66,20,0,85,1,13,45,0,24,35,1,6,5],
		[361,66,5,0,86,1,13,44,0,7,34,31,6,2],
		[362,66,5,0,86,1,13,45,0,7,34,42,7,3],
		[363,88,24,0,0,1,14,5,0,28,31,47,7,7],
		[364,66,24,0,87,1,14,8,0,16,8,1,7,1],
		[365,88,24,0,0,1,16,12,0,71,44,38,9,5],
		[366,16,24,0,37,1,14,24,1,7,55,23,6,3],
		[367,66,24,0,88,1,14,42,0,6,59,43,7,4],
		[368,16,24,0,38,1,14,49,1,0,58,26,7,3],
		[369,88,24,0,0,1,16,25,0,48,4,56,8,1],
		[370,63,12,0,0,1,15,11,1,45,31,53,6,3],
		[371,88,24,0,0,1,16,19,0,33,6,53,7,5],
		[372,88,24,0,0,1,17,5,0,44,54,7,7,5],
		[373,16,24,0,39,1,16,36,1,2,30,1,6,4],
		[374,88,24,0,0,1,17,24,0,31,44,41,8,5],
		[375,88,24,0,0,1,20,20,0,77,34,14,7,4],
		[376,88,24,0,0,1,18,10,0,47,25,11,7,5],
		[377,81,9,0,0,1,15,46,1,68,52,34,6,3],
		[378,66,24,0,89,1,17,48,0,3,36,52,6,2],
		[379,88,24,0,0,1,18,47,0,37,23,10,7,2],
		[380,88,24,0,0,1,17,4,1,66,23,53,7,2],
		[381,88,24,0,0,1,21,59,0,76,14,20,7,3],
		[382,13,20,0,34,1,20,5,0,58,13,54,6,3],
		[383,66,19,0,90,1,19,28,0,27,15,51,6,2],
		[384,13,24,0,35,1,21,5,0,64,39,30,7,2],
		[385,16,24,0,42,1,19,48,1,0,30,32,7,4],
		[386,88,24,0,0,1,23,47,0,78,43,33,7,2],
		[387,88,24,0,0,1,20,35,1,3,14,49,7,5],
		[388,88,24,0,0,1,20,28,1,11,14,20,7,5],
		[389,66,24,0,91,1,21,7,0,28,44,17,6,5],
		[390,0,13,0,46,1,22,20,0,45,31,44,6,5],
		[391,88,24,0,0,1,23,22,0,58,8,35,7,3],
		[392,88,24,0,0,1,22,37,0,1,43,35,7,5],
		[393,16,24,0,43,1,22,35,1,0,26,59,7,5],
		[394,88,24,0,0,1,22,31,1,19,4,53,7,3],
		[395,0,24,0,47,1,23,41,0,37,42,54,7,2],
		[396,88,24,0,0,1,23,38,0,34,14,45,7,4],
		[397,88,24,0,0,1,23,25,0,20,28,8,7,5],
		[398,88,24,0,0,1,25,47,0,70,58,48,7,2],
		[399,13,22,0,36,1,25,56,0,68,7,48,6,5],
		[400,88,24,0,0,1,23,31,1,30,56,44,7,5],
		[401,16,24,0,44,1,24,3,1,8,0,27,7,3],
		[402,16,7,0,45,1,24,1,1,8,11,0,5,5],
		[403,13,3,0,37,1,25,49,0,60,14,7,4,2],
		[404,88,24,0,0,1,24,21,1,6,54,53,7,3],
		[405,88,24,0,0,1,24,40,1,15,39,37,7,4],
		[406,88,24,0,0,1,24,49,1,2,50,55,7,4],
		[407,88,24,0,0,1,25,36,0,23,30,42,7,3],
		[408,88,24,0,0,1,24,41,1,41,29,33,6,5],
		[409,88,24,0,0,1,26,19,0,43,27,28,7,3],
		[410,88,24,0,0,1,26,9,0,34,34,47,7,3],
		[411,88,24,0,0,1,24,42,1,44,31,42,7,5],
		[412,16,24,0,46,1,25,37,1,14,35,56,6,5],
		[413,66,16,0,93,1,26,15,0,19,10,20,6,3],
		[414,66,24,0,94,1,26,42,0,19,14,25,7,5],
		[415,88,24,0,0,1,27,6,0,34,22,39,7,3],
		[416,88,24,0,0,1,26,27,1,0,23,55,7,5],
		[417,0,23,0,48,1,27,39,0,45,24,24,6,3],
		[418,88,24,0,0,1,27,27,0,41,6,2,7,2],
		[419,88,24,0,0,1,26,54,0,3,32,7,8,1],
		[420,88,24,0,0,1,25,5,1,64,22,10,7,5],
		[421,16,24,0,47,1,26,52,1,13,3,24,7,3],
		[422,88,24,0,0,1,27,47,0,40,20,8,8,2],
		[423,88,24,0,0,1,26,58,1,32,32,35,7,6],
		[424,83,0,0,1,2,31,49,0,89,15,51,3,3],
		[425,88,24,0,0,1,27,47,1,10,54,6,7,5],
		[426,88,24,0,0,1,28,23,0,7,57,41,7,5],
		[427,13,24,0,38,1,31,14,0,70,15,53,7,3],
		[428,88,24,0,0,1,30,52,0,66,5,53,7,2],
		[429,63,2,0,0,1,28,22,1,43,19,6,4,7],
		[430,0,24,0,49,1,30,6,0,47,0,26,6,5],
		[431,88,24,0,0,1,28,43,1,33,45,49,8,3],
		[432,66,24,0,97,1,29,53,0,18,21,20,7,2],
		[433,16,24,0,48,1,29,36,1,21,37,46,6,2],
		[434,66,11,0,98,1,30,11,0,6,8,38,6,5],
		[435,88,24,0,0,1,29,30,1,46,45,23,7,7],
		[436,88,24,0,0,1,30,23,1,26,12,28,7,5],
		[437,66,6,0,99,1,31,29,0,15,20,45,5,4],
		[438,88,24,0,0,1,32,8,0,34,48,0,7,1],
		[439,88,24,0,0,1,33,26,0,58,19,39,7,5],
		[440,63,3,0,0,1,31,15,1,49,4,22,5,5],
		[441,88,24,0,0,1,31,43,1,30,17,0,7,5],
		[442,13,21,0,39,1,33,56,0,59,13,55,6,4],
		[443,88,24,0,0,1,31,39,1,45,34,32,7,2],
		[444,88,24,0,0,1,33,4,1,9,0,53,8,2],
		[445,88,24,0,0,1,32,56,1,36,51,55,7,5],
		[446,88,24,0,0,1,34,17,0,37,14,14,7,1],
		[447,88,24,0,0,1,32,36,1,49,43,40,7,3],
		[448,88,24,0,0,1,33,43,1,7,1,31,7,4],
		[449,88,24,0,0,1,37,23,0,74,18,3,8,1],
		[450,88,24,0,0,1,34,49,0,18,27,38,7,7],
		[451,16,24,0,49,1,34,38,1,15,40,34,7,2],
		[452,88,24,0,0,1,35,53,0,41,4,35,7,5],
		[453,88,24,0,0,1,34,51,1,31,53,32,7,5],
		[454,88,24,0,0,1,36,27,0,48,43,22,7,5],
		[455,66,24,0,101,1,35,46,0,14,39,41,7,1],
		[456,13,24,0,40,1,38,31,0,73,2,24,6,4],
		[457,88,24,0,0,1,35,55,0,17,26,1,7,3],
		[458,0,19,0,50,1,36,48,0,41,24,20,5,3],
		[459,16,24,0,50,1,35,59,1,15,24,1,6,5],
		[460,88,24,0,0,1,35,15,1,58,8,22,7,3],
		[461,88,24,0,0,1,38,8,0,57,58,39,7,4],
		[462,70,18,0,0,1,36,8,1,29,54,27,7,3],
		[463,66,15,0,102,1,37,6,0,12,8,30,7,3],
		[464,0,24,0,51,1,37,60,0,48,37,42,5,5],
		[465,88,24,0,0,1,38,32,0,45,24,0,7,1],
		[466,88,24,0,0,1,37,38,1,9,24,14,7,3],
		[467,88,24,0,0,1,33,39,1,78,30,17,7,5],
		[468,88,24,0,0,1,36,45,1,58,16,15,7,7],
		[469,0,21,0,52,1,39,21,0,44,23,10,6,4],
		[470,88,24,0,0,1,40,13,0,53,52,6,7,5],
		[471,88,24,0,0,1,38,27,1,36,31,42,7,5],
		[472,35,0,0,0,1,37,43,1,57,14,12,1,1],
		[473,88,24,0,0,1,38,52,1,21,16,31,7,2],
		[474,88,24,0,0,1,38,50,1,25,1,19,8,1],
		[475,66,24,0,105,1,39,41,0,16,24,21,7,5],
		[476,88,24,0,0,1,40,40,0,43,17,52,7,2],
		[477,0,18,0,53,1,40,35,0,40,34,37,6,1],
		[478,13,24,0,43,1,42,21,0,68,2,35,7,2],
		[479,88,24,0,0,1,38,48,1,53,26,20,8,3],
		[480,13,24,0,42,1,42,56,0,70,37,21,6,1],
		[481,88,24,0,0,1,42,3,0,61,2,18,8,1],
		[482,88,24,0,0,1,42,18,0,58,37,40,7,1],
		[483,88,24,0,0,1,41,47,0,42,36,49,6,4],
		[484,88,24,0,0,1,41,18,0,25,44,45,7,3],
		[485,88,24,0,0,1,41,39,0,30,2,50,7,5],
		[486,88,24,0,0,1,39,47,1,56,11,53,7,5],
		[487,88,24,0,0,1,39,48,1,56,11,41,7,5],
		[488,88,24,0,0,1,42,58,0,61,25,18,7,1],
		[489,66,12,0,106,1,41,26,0,5,29,15,5,5],
		[490,88,24,0,0,1,42,4,0,35,14,44,7,1],
		[491,13,24,0,44,1,43,20,0,60,33,4,7,1],
		[492,88,24,0,0,1,41,45,1,11,19,29,7,3],
		[493,66,24,0,107,1,42,30,0,20,16,7,6,5],
		[494,88,24,0,0,1,41,27,1,38,7,59,7,3],
		[495,88,24,0,0,1,43,17,0,45,19,20,7,5],
		[496,62,20,0,0,1,43,40,0,50,41,19,5,1],
		[497,70,15,0,0,1,42,9,1,32,19,37,6,5],
		[498,88,24,0,0,1,42,3,1,36,49,57,7,2],
		[499,88,24,0,0,1,44,18,0,57,32,11,7,2],
		[500,88,24,0,0,1,42,44,1,3,41,25,6,5],
		[501,88,24,0,0,1,41,41,1,50,2,20,8,2],
		[502,88,24,0,0,1,44,46,0,57,5,21,7,2],
		[503,88,24,0,0,1,43,50,0,32,11,30,7,4],
		[504,88,24,0,0,1,44,27,0,46,8,23,7,5],
		[505,88,24,0,0,1,41,48,1,60,47,22,7,5],
		[506,88,24,0,0,1,42,29,1,53,44,26,7,3],
		[507,88,24,0,0,1,43,55,1,4,45,56,7,5],
		[508,66,24,0,109,1,44,56,0,20,4,59,7,4],
		[509,16,18,0,52,1,44,4,1,15,56,15,5,4],
		[510,66,14,0,110,1,45,24,0,9,9,28,5,4],
		[511,88,24,0,0,1,47,45,0,63,51,8,7,5],
		[512,88,24,0,0,1,37,56,1,82,58,30,7,4],
		[513,88,24,0,0,1,45,59,1,5,44,0,6,5],
		[514,70,4,0,0,1,45,39,1,25,3,9,6,3],
		[515,88,24,0,0,1,46,35,0,17,24,47,8,2],
		[516,42,18,1,0,1,41,21,1,79,8,54,7,4],
		[517,88,24,0,0,1,46,1,1,27,20,57,7,3],
		[518,88,24,0,0,1,47,48,0,46,13,47,7,3],
		[519,88,24,0,0,1,46,6,1,50,48,59,6,7],
		[520,88,24,0,0,1,46,6,1,53,31,19,6,2],
		[521,88,24,0,0,1,48,39,0,37,57,10,7,5],
		[522,6,24,0,4,1,48,11,0,16,57,20,7,1],
		[523,88,24,0,0,1,48,42,0,32,41,25,7,3],
		[524,88,24,0,0,1,47,17,1,41,45,36,7,5],
		[525,88,24,0,0,1,37,28,1,84,46,11,7,4],
		[526,88,24,0,0,1,49,16,0,47,53,49,7,2],
		[527,88,24,0,0,1,48,26,0,3,41,8,7,4],
		[528,88,24,0,0,1,47,48,1,37,9,35,7,5],
		[529,88,24,0,0,1,50,57,0,51,56,0,7,3],
		[530,6,24,0,1,1,50,9,0,22,16,31,7,5],
		[531,16,21,0,53,1,49,35,1,10,41,11,6,3],
		[532,88,24,0,0,1,49,20,1,31,4,22,7,5],
		[533,62,24,0,1,1,51,59,0,55,8,51,7,1],
		[534,88,24,0,0,1,50,52,0,11,2,36,7,3],
		[535,88,24,0,0,1,49,49,1,38,24,14,7,3],
		[536,62,24,0,2,1,52,9,0,50,47,34,7,1],
		[537,88,24,0,0,1,50,20,1,47,48,59,7,5],
		[538,88,24,0,0,1,52,51,0,51,28,29,7,2],
		[539,16,5,0,55,1,51,28,1,10,20,6,5,5],
		[540,88,24,0,0,1,53,49,0,55,35,53,7,2],
		[541,88,24,0,0,1,50,55,1,50,12,22,7,2],
		[542,13,4,0,45,1,54,24,0,63,40,12,4,1],
		[543,0,24,0,55,1,53,17,0,40,43,47,6,5],
		[544,80,0,0,2,1,53,5,0,29,34,44,4,3],
		[545,6,2,1,5,1,53,32,0,19,17,45,6,1],
		[546,6,2,2,5,1,53,32,0,19,17,37,6,2],
		[547,88,24,0,0,1,52,52,1,16,55,45,7,3],
		[548,13,23,0,46,1,56,0,0,68,41,7,6,1],
		[549,66,13,0,111,1,53,33,0,3,11,15,6,5],
		[550,42,18,2,0,1,47,47,1,80,10,36,7,3],
		[551,88,24,0,0,1,54,54,0,40,42,7,7,5],
		[552,88,24,0,0,1,54,58,0,37,7,42,7,5],
		[553,6,1,0,6,1,54,38,0,20,48,29,4,2],
		[554,88,24,0,0,1,53,23,1,38,35,41,7,5],
		[555,63,22,0,0,1,53,39,1,46,18,9,5,7],
		[556,88,24,0,0,1,55,54,0,37,16,40,7,7],
		[557,0,24,0,56,1,56,9,0,37,15,6,7,5],
		[558,63,20,0,0,1,54,22,1,42,29,49,6,2],
		[559,6,24,0,7,1,55,51,0,23,34,38,7,5],
		[560,88,24,0,0,1,55,54,0,1,50,59,7,3],
		[561,88,24,0,0,1,58,33,0,61,41,53,7,1],
		[562,88,24,0,0,1,57,56,0,41,41,40,8,1],
		[563,6,8,0,8,1,57,21,0,17,49,3,6,5],
		[564,88,24,0,0,1,57,44,0,27,48,16,7,7],
		[565,16,24,0,56,1,56,40,1,22,31,37,6,5],
		[566,35,21,0,0,1,55,58,1,51,36,32,5,4],
		[567,88,24,0,0,1,59,38,0,64,37,17,6,2],
		[568,62,24,0,3,1,58,34,0,49,12,15,7,5],
		[569,6,10,0,9,1,57,56,0,23,35,46,6,3],
		[570,42,6,2,0,1,54,56,1,67,38,50,6,4],
		[571,88,24,0,0,1,55,46,1,60,51,41,7,3],
		[572,88,24,0,0,2,2,57,0,77,54,59,7,5],
		[573,88,24,0,0,1,57,0,1,51,45,58,7,3],
		[574,88,24,0,0,1,57,10,1,47,23,6,6,4],
		[575,13,24,0,48,2,1,57,0,70,54,25,6,2],
		[576,88,24,0,0,1,58,27,1,33,4,0,7,5],
		[577,88,24,0,0,1,59,36,0,21,3,30,7,5],
		[578,88,24,0,0,1,59,26,0,12,17,41,7,2],
		[579,88,24,0,0,2,3,11,0,73,51,2,7,2],
		[580,13,24,0,50,2,3,26,0,72,25,17,5,2],
		[581,13,24,0,47,2,5,7,0,77,16,53,6,3],
		[582,66,24,0,112,2,0,9,0,3,5,50,7,4],
		[583,16,24,0,57,1,59,46,1,20,49,28,6,7],
		[584,88,24,0,0,1,57,54,1,65,25,29,7,4],
		[585,16,19,0,59,2,0,0,1,21,4,40,5,7],
		[586,13,24,0,52,2,2,53,0,64,54,5,7,2],
		[587,88,24,0,0,2,0,27,1,8,31,25,7,7],
		[588,88,24,0,0,1,59,39,1,42,1,50,7,5],
		[589,13,24,0,53,2,3,0,0,64,23,24,7,1],
		[590,62,24,0,4,2,2,18,0,54,29,15,6,1],
		[591,42,0,0,0,1,58,46,1,61,34,11,4,3],
		[592,13,24,0,49,2,5,31,0,76,6,54,6,4],
		[593,42,17,0,0,1,55,51,1,78,20,54,7,3],
		[594,36,15,0,0,2,1,15,1,30,0,6,6,4],
		[595,66,0,0,113,2,2,3,0,2,45,49,6,2],
		[596,66,0,0,113,2,2,3,0,2,45,49,5,2],
		[597,88,24,0,0,2,9,25,0,81,17,45,7,2],
		[598,88,24,0,0,2,4,40,0,65,6,12,8,2],
		[599,80,4,0,3,2,2,58,0,33,17,2,7,2],
		[600,88,24,0,0,1,59,41,1,66,3,59,7,5],
		[601,88,24,0,0,2,2,35,0,13,28,36,7,7],
		[602,63,21,0,0,2,1,42,1,44,42,49,6,5],
		[603,0,2,1,57,2,3,54,0,42,19,47,3,5],
		[604,0,2,2,57,2,3,55,0,42,19,51,6,1],
		[605,6,24,0,10,2,3,39,0,25,56,8,7,3],
		[606,88,24,0,0,2,2,28,1,29,39,54,7,2],
		[607,16,24,0,60,2,3,12,0,0,7,42,6,2],
		[608,88,24,0,0,2,2,59,1,15,18,21,7,4],
		[609,88,24,0,0,2,3,43,0,18,15,12,7,5],
		[610,16,24,0,61,2,3,48,1,0,20,25,7,4],
		[611,88,24,0,0,2,3,41,1,4,6,13,7,5],
		[612,36,12,0,0,2,4,29,1,29,17,49,6,1],
		[613,6,9,0,12,2,6,34,0,22,38,54,6,2],
		[614,88,24,0,0,2,6,12,0,8,14,51,7,7],
		[615,6,24,0,11,2,6,49,0,25,42,17,7,1],
		[616,88,24,0,0,2,6,29,0,0,2,6,7,5],
		[617,6,0,0,13,2,7,10,0,23,27,45,3,5],
		[618,88,24,0,0,2,8,41,0,58,25,25,7,2],
		[619,88,24,0,0,2,8,34,0,44,27,34,7,4],
		[620,0,24,0,58,2,8,29,0,37,51,33,6,2],
		[621,88,24,0,0,2,10,8,0,53,50,35,7,4],
		[622,80,1,0,4,2,9,33,0,34,59,14,4,2],
		[623,6,24,0,14,2,9,25,0,25,56,23,6,3],
		[624,88,24,0,0,2,9,23,0,17,13,28,7,3],
		[625,88,24,0,0,2,8,46,1,17,46,46,7,7],
		[626,88,24,0,0,2,13,21,0,74,1,40,7,4],
		[627,62,24,0,5,2,11,29,0,57,38,45,7,1],
		[628,0,24,0,59,2,10,53,0,39,2,22,7,1],
		[629,0,24,0,59,2,10,54,0,39,2,35,7,2],
		[630,88,24,0,0,2,9,35,1,24,20,45,7,3],
		[631,6,24,0,15,2,10,38,0,19,30,1,7,7],
		[632,88,24,0,0,2,9,9,1,43,31,0,7,5],
		[633,6,24,0,16,2,11,12,0,25,56,13,7,5],
		[634,80,24,0,5,2,11,25,0,31,31,35,7,2],
		[635,16,24,0,64,2,11,21,0,8,34,11,7,4],
		[636,88,24,0,0,2,10,5,1,43,48,56,7,4],
		[637,88,24,0,0,2,10,26,1,50,49,28,7,5],
		[638,88,24,0,0,2,11,22,1,10,3,8,7,3],
		[639,16,24,0,63,2,11,36,1,1,49,31,7,4],
		[640,13,24,0,55,2,14,29,0,66,31,28,7,4],
		[641,88,24,0,0,2,13,42,0,58,33,40,7,2],
		[642,80,24,0,6,2,12,22,0,30,18,11,6,4],
		[643,0,24,0,60,2,13,13,0,44,13,54,6,5],
		[644,88,24,0,0,2,12,38,0,24,10,4,7,5],
		[645,88,24,0,0,2,13,36,0,51,3,57,6,4],
		[646,6,6,0,17,2,12,48,0,21,12,39,6,3],
		[647,88,24,0,0,2,14,3,0,47,29,3,7,3],
		[648,6,24,0,19,2,13,3,0,15,16,47,7,7],
		[649,16,13,1,65,2,13,0,0,8,50,48,5,4],
		[650,16,24,0,66,2,12,48,1,2,23,37,7,3],
		[651,88,24,0,0,2,13,1,1,21,0,1,7,4],
		[652,36,11,0,0,2,12,55,1,30,43,26,6,1],
		[653,88,24,0,0,2,15,58,0,47,48,41,7,4],
		[654,88,24,0,0,2,16,52,0,57,3,19,7,1],
		[655,80,24,0,7,2,15,56,0,33,21,32,6,2],
		[656,6,24,0,20,2,15,46,0,25,46,59,7,3],
		[657,6,24,0,21,2,15,43,0,25,2,35,7,3],
		[658,88,24,0,0,2,15,28,1,9,27,56,8,2],
		[659,88,24,0,0,2,14,32,1,41,10,0,7,4],
		[660,80,3,0,8,2,17,3,0,34,13,27,6,4],
		[661,62,24,0,8,2,17,60,0,57,53,59,7,5],
		[662,62,24,0,7,2,18,5,0,57,31,0,7,4],
		[663,88,24,0,0,2,17,33,0,44,18,25,8,7],
		[664,80,2,0,9,2,17,19,0,33,50,50,5,2],
		[665,88,24,0,0,2,17,10,0,23,46,4,8,4],
		[666,16,24,0,67,2,16,59,1,6,25,20,7,4],
		[667,42,15,1,0,2,14,15,1,67,50,30,7,7],
		[668,88,24,0,0,2,20,13,0,64,20,14,8,1],
		[669,6,7,0,22,2,18,8,0,19,54,4,7,2],
		[670,0,24,0,62,2,19,17,0,47,22,48,6,2],
		[671,88,24,0,0,2,19,11,0,46,28,21,7,2],
		[672,88,24,0,0,2,18,1,0,1,45,28,7,4],
		[673,88,24,0,0,2,19,23,0,48,57,19,7,3],
		[674,35,20,0,0,2,16,31,1,51,30,44,5,1],
		[675,80,24,0,10,2,18,57,0,28,38,33,6,2],
		[676,88,24,0,0,2,18,58,0,23,10,4,7,2],
		[677,88,24,0,0,2,19,37,0,39,50,6,8,1],
		[678,42,15,2,0,2,15,29,1,67,44,47,7,5],
		[679,88,24,0,0,2,20,41,0,47,18,39,7,1],
		[680,88,24,0,0,2,20,4,0,30,11,18,7,5],
		[681,16,14,0,68,2,19,21,1,2,58,39,4,7],
		[682,0,24,0,63,2,20,58,0,50,9,5,7,1],
		[683,88,24,0,0,2,18,59,1,25,56,44,7,4],
		[684,88,24,0,0,2,19,41,1,4,20,44,8,2],
		[685,62,24,0,9,2,22,21,0,55,50,44,6,2],
		[686,88,24,0,0,2,19,25,1,41,50,54,7,5],
		[687,88,24,0,0,2,22,50,0,41,23,47,7,3],
		[688,88,24,0,0,2,19,54,1,55,56,41,7,5],
		[689,16,24,0,69,2,21,57,0,0,23,45,6,7],
		[690,88,24,0,0,2,23,52,0,55,21,52,7,3],
		[691,16,24,0,70,2,22,12,1,0,53,6,6,3],
		[692,88,24,0,0,2,22,1,1,10,46,40,6,3],
		[693,88,24,0,0,2,22,5,1,17,39,44,7,5],
		[694,0,24,0,64,2,24,25,0,50,0,24,6,4],
		[695,36,9,0,0,2,22,33,1,23,48,59,6,4],
		[696,62,24,0,10,2,25,16,0,56,36,36,7,1],
		[697,88,24,0,0,2,22,58,1,18,21,16,7,4],
		[698,88,24,0,0,2,22,12,1,43,12,0,7,5],
		[699,0,24,0,65,2,25,37,0,50,16,43,6,5],
		[700,88,24,0,0,2,23,7,1,37,34,35,8,5],
		[701,88,24,0,0,2,22,55,1,51,5,32,7,2],
		[702,6,13,0,24,2,24,49,0,10,36,38,6,1],
		[703,88,24,0,0,2,24,20,1,25,50,51,7,5],
		[704,16,24,0,71,2,24,58,1,2,46,48,7,2],
		[705,42,3,0,0,2,21,45,1,68,39,34,5,2],
		[706,88,24,0,0,2,24,34,1,40,50,26,7,4],
		[707,13,8,0,0,2,29,4,0,67,24,9,6,2],
		[708,16,16,0,72,2,25,57,1,12,17,26,6,1],
		[709,0,24,0,66,2,27,52,0,50,34,11,7,3],
		[710,88,24,0,0,2,26,0,1,15,20,28,7,2],
		[711,88,24,0,0,2,27,7,0,27,0,48,7,5],
		[712,80,24,0,11,2,27,28,0,31,48,5,7,5],
		[713,88,24,0,0,2,26,35,1,20,2,34,7,5],
		[714,40,10,0,0,2,24,54,1,60,18,43,6,3],
		[715,42,9,0,0,2,22,52,1,73,38,45,6,5],
		[716,88,24,0,0,2,29,25,0,55,32,11,8,2],
		[717,80,24,0,12,2,28,10,0,29,40,10,6,3],
		[718,16,13,2,73,2,28,10,0,8,27,36,5,1],
		[719,88,24,0,0,2,28,0,0,1,57,39,7,5],
		[720,80,24,0,13,2,28,49,0,29,55,55,7,4],
		[721,35,9,0,0,2,26,59,1,47,42,14,5,1],
		[722,88,24,0,0,2,25,26,1,66,29,41,7,7],
		[723,88,24,0,0,2,29,14,0,23,28,8,7,2],
		[724,36,20,0,0,2,28,2,1,33,48,40,6,2],
		[725,88,24,0,0,2,29,35,0,9,33,57,7,5],
		[726,88,24,0,0,2,30,17,0,33,50,2,7,5],
		[727,88,24,0,0,2,28,35,1,31,6,9,7,5],
		[728,88,24,0,0,2,30,32,0,25,14,6,7,3],
		[729,6,24,0,26,2,30,38,0,19,51,19,7,2],
		[730,88,24,0,0,2,29,55,1,22,40,58,8,2],
		[731,6,24,0,27,2,30,54,0,17,42,14,7,4],
		[732,88,24,0,0,2,30,45,0,0,15,19,7,2],
		[733,88,24,0,0,2,30,14,1,25,11,11,8,2],
		[734,88,24,0,0,2,28,4,1,64,17,59,7,2],
		[735,88,24,0,0,2,30,33,1,22,32,44,7,7],
		[736,80,24,0,14,2,32,6,0,36,8,50,6,5],
		[737,88,24,0,0,2,31,30,0,2,16,2,6,5],
		[738,88,24,0,0,2,32,53,0,34,32,33,7,5],
		[739,16,24,0,75,2,32,9,1,1,2,6,6,4],
		[740,16,17,0,76,2,32,5,1,15,14,41,6,3],
		[741,6,24,0,29,2,32,54,0,15,2,5,7,3],
		[742,88,24,0,0,2,32,15,1,36,25,39,7,4],
		[743,88,24,0,0,2,38,2,0,72,49,6,6,4],
		[744,36,10,1,0,2,33,7,1,34,39,0,7,5],
		[745,88,24,0,0,2,33,40,1,20,0,7,7,5],
		[746,88,24,0,0,2,35,28,0,39,39,52,7,1],
		[747,88,24,0,0,2,37,36,0,65,44,44,7,5],
		[748,88,24,0,0,2,35,39,0,37,18,44,7,5],
		[749,36,23,0,0,2,33,51,1,28,13,57,6,1],
		[750,80,24,0,15,2,35,47,0,34,41,15,6,7],
		[751,88,24,0,0,2,35,4,0,7,28,17,7,4],
		[752,16,24,0,77,2,34,43,1,7,51,34,7,5],
		[753,88,24,0,0,2,36,5,0,6,53,13,7,5],
		[754,16,12,0,78,2,35,53,0,5,35,36,6,4],
		[755,88,24,0,0,2,33,55,1,51,5,37,7,3],
		[756,88,24,0,0,2,36,57,0,38,43,58,7,3],
		[757,88,24,0,0,2,36,43,0,31,36,27,7,5],
		[758,88,24,0,0,2,37,3,0,34,15,50,6,7],
		[759,16,24,0,80,2,36,0,1,7,49,54,7,7],
		[760,88,24,0,0,2,37,21,0,39,53,45,8,1],
		[761,88,24,0,0,2,37,6,0,32,53,31,7,3],
		[762,88,24,0,0,2,33,34,1,62,35,13,8,1],
		[763,6,24,0,31,2,36,38,0,12,26,51,7,3],
		[764,6,24,0,30,2,36,58,0,24,38,54,8,3],
		[765,6,24,0,30,2,37,1,0,24,38,51,8,3],
		[766,88,24,0,0,2,36,35,0,7,43,47,7,5],
		[767,36,8,1,0,2,36,9,1,30,2,41,7,4],
		[768,88,24,0,0,2,38,18,0,37,43,36,7,3],
		[769,88,24,0,0,2,38,28,0,38,5,22,7,1],
		[770,88,24,0,0,2,38,1,0,7,41,43,7,3],
		[771,16,24,0,81,2,37,42,1,3,23,46,7,4],
		[772,36,10,2,0,2,36,59,1,34,34,42,7,4],
		[773,6,12,0,32,2,38,49,0,21,57,41,6,2],
		[774,88,24,0,0,2,47,48,0,81,26,54,7,4],
		[775,88,24,0,0,2,38,37,0,3,26,35,7,4],
		[776,42,11,0,0,2,31,41,1,79,6,34,6,4],
		[777,36,8,2,0,2,38,19,1,30,11,39,7,3],
		[778,40,6,0,0,2,37,24,1,52,32,35,6,2],
		[779,16,3,0,82,2,39,29,0,0,19,43,5,1],
		[780,88,24,0,0,2,38,25,1,37,59,26,7,4],
		[781,16,4,0,83,2,39,34,1,11,52,20,6,3],
		[782,6,24,0,33,2,40,41,0,27,3,39,6,2],
		[783,88,24,0,0,2,40,16,0,6,6,43,7,3],
		[784,88,24,0,0,2,40,12,1,9,27,11,7,3],
		[785,62,24,0,11,2,43,3,0,55,6,21,7,1],
		[786,88,24,0,0,2,40,3,1,30,38,2,8,5],
		[787,88,24,0,0,2,42,60,0,53,31,34,7,5],
		[788,62,24,0,12,2,42,15,0,40,11,38,6,3],
		[789,88,24,0,0,2,39,48,1,42,53,30,6,2],
		[790,16,24,0,84,2,41,14,1,0,41,45,7,3],
		[791,88,24,0,0,2,44,50,0,67,49,29,7,2],
		[792,88,24,0,0,2,43,2,0,48,15,56,7,4],
		[793,6,11,0,34,2,42,22,0,20,0,42,7,2],
		[794,35,8,0,0,2,40,40,1,39,51,20,5,5],
		[795,88,24,0,0,2,41,48,1,3,12,48,7,4],
		[796,88,24,0,0,2,41,34,1,14,32,58,7,3],
		[797,88,24,0,0,2,42,29,0,10,44,30,7,2],
		[798,88,24,0,0,2,39,32,1,64,16,55,8,1],
		[799,62,7,0,13,2,44,12,0,49,13,42,5,3],
		[800,62,24,0,14,2,44,5,0,44,17,49,6,4],
		[801,6,24,0,35,2,43,27,0,27,42,26,6,1],
		[802,40,5,0,0,2,40,40,1,54,33,0,6,3],
		[803,88,24,0,0,2,43,51,0,25,38,17,7,2],
		[804,16,2,0,86,2,43,18,0,3,14,9,4,2],
		[805,88,24,0,0,2,42,7,1,38,23,2,7,4],
		[806,42,4,0,0,2,39,35,1,68,16,1,5,1],
		[807,88,24,0,0,2,42,9,1,46,31,28,7,5],
		[808,6,24,0,36,2,44,19,0,17,45,50,7,5],
		[809,6,14,0,37,2,44,33,0,15,18,42,7,1],
		[810,40,8,0,0,2,42,34,1,50,48,1,6,4],
		[811,16,15,0,89,2,44,7,1,13,51,31,5,1],
		[812,6,24,0,38,2,44,58,0,12,26,45,6,2],
		[813,16,11,0,87,2,44,57,0,10,6,51,5,3],
		[814,88,24,0,0,2,43,20,1,40,31,39,7,1],
		[815,88,24,0,0,2,48,56,0,69,38,3,7,2],
		[816,88,24,0,0,2,45,21,0,4,42,42,7,3],
		[817,88,24,0,0,2,44,21,1,32,31,30,7,2],
		[818,35,18,1,1,2,45,6,1,18,34,21,5,3],
		[819,88,24,0,0,2,46,58,0,35,59,1,7,4],
		[820,88,24,0,0,2,47,4,0,35,33,18,7,2],
		[821,88,24,0,0,2,44,11,1,52,34,14,7,2],
		[822,88,24,0,0,2,45,17,1,46,17,14,8,5],
		[823,88,24,0,0,2,43,27,1,66,42,52,7,3],
		[824,6,24,0,39,2,47,55,0,29,14,50,6,5],
		[825,88,24,0,0,2,49,31,0,57,5,3,7,2],
		[826,88,24,0,0,2,46,45,1,21,38,23,7,3],
		[827,88,24,0,0,2,47,11,1,22,29,8,7,3],
		[828,6,24,0,40,2,48,32,0,18,17,1,7,5],
		[829,88,24,0,0,2,51,59,0,68,53,19,7,3],
		[830,88,24,0,0,2,48,46,0,25,11,17,7,2],
		[831,88,24,0,0,2,49,27,0,37,19,34,7,3],
		[832,88,24,0,0,2,47,56,1,12,27,38,8,7],
		[833,40,2,0,0,2,45,28,1,63,42,16,7,4],
		[834,62,6,0,15,2,50,42,0,55,53,44,5,5],
		[835,36,6,1,0,2,47,34,1,35,33,3,8,5],
		[836,6,15,0,42,2,49,18,0,17,27,51,6,1],
		[837,42,5,0,0,2,45,33,1,67,37,0,6,2],
		[838,6,24,0,41,2,49,59,0,27,15,38,5,1],
		[839,88,24,0,0,2,51,46,0,58,18,53,7,2],
		[840,62,24,0,16,2,50,35,0,38,19,7,5,3],
		[841,36,1,0,0,2,49,5,1,32,24,21,5,5],
		[842,88,24,0,0,2,51,42,0,46,50,31,7,4],
		[843,62,24,0,17,2,51,31,0,35,3,35,6,5],
		[844,36,2,1,0,2,49,51,1,24,33,37,7,5],
		[845,36,2,2,0,2,49,54,1,27,56,30,6,2],
		[846,88,24,0,0,2,52,52,0,52,59,52,7,1],
		[847,6,17,0,43,2,51,30,0,15,4,55,6,1],
		[848,36,6,2,0,2,50,15,1,35,50,37,7,5],
		[849,88,24,0,0,2,53,21,0,48,34,10,7,4],
		[850,35,18,2,2,2,51,2,1,21,0,15,6,5],
		[851,36,6,3,0,2,50,40,1,35,40,34,6,5],
		[852,40,12,0,0,2,49,2,1,62,48,24,6,2],
		[853,88,24,0,0,2,50,48,1,39,55,54,7,2],
		[854,62,18,0,18,2,54,16,0,52,45,45,5,4],
		[855,62,24,0,20,2,53,43,0,38,20,15,6,3],
		[856,88,24,0,0,2,53,12,0,16,29,0,7,3],
		[857,88,24,0,0,2,52,32,1,12,46,10,7,5],
		[858,88,24,0,0,2,51,55,1,30,48,52,7,3],
		[859,88,24,0,0,2,52,51,1,9,26,28,7,2],
		[860,88,24,0,0,2,55,57,0,61,31,16,7,3],
		[861,88,24,0,0,2,56,25,0,64,19,57,7,5],
		[862,88,24,0,0,2,53,35,1,22,22,35,7,5],
		[863,36,22,0,0,2,53,34,1,38,26,13,7,3],
		[864,88,24,0,0,2,56,51,0,51,15,39,7,5],
		[865,88,24,0,0,2,56,33,0,47,9,50,7,5],
		[866,88,24,0,0,2,52,19,1,62,54,35,7,5],
		[867,6,16,2,45,2,55,49,0,18,19,54,7,7],
		[868,88,24,0,0,2,53,53,1,49,53,25,5,7],
		[869,6,16,3,46,2,56,26,0,18,1,23,7,3],
		[870,88,24,0,0,2,56,14,0,8,22,54,7,3],
		[871,88,24,0,0,2,54,7,1,50,52,17,7,5],
		[872,42,12,0,0,2,50,29,1,75,4,1,6,5],
		[873,62,24,0,21,2,57,17,0,31,56,3,6,1],
		[874,35,6,0,3,2,56,26,1,8,53,53,5,5],
		[875,88,24,0,0,2,56,37,1,3,42,44,6,2],
		[876,88,24,0,0,2,58,2,0,38,36,54,7,5],
		[877,88,24,0,0,2,57,5,0,4,30,4,7,7],
		[878,6,24,0,47,2,58,5,0,20,40,7,7,3],
		[879,62,15,0,22,2,58,46,0,39,39,46,6,2],
		[880,88,24,0,0,2,54,21,1,64,26,8,8,5],
		[881,88,24,0,0,3,6,8,0,79,25,7,6,7],
		[882,62,24,0,24,2,59,4,0,35,10,59,6,5],
		[883,35,24,0,4,2,57,24,1,23,51,43,6,2],
		[884,88,24,0,0,2,57,13,1,29,51,19,7,2],
		[885,88,24,0,0,2,59,50,0,47,13,15,6,4],
		[886,88,24,0,0,2,59,40,0,41,1,59,7,5],
		[887,6,4,0,48,2,59,13,0,21,20,25,6,2],
		[888,6,4,0,48,2,59,13,0,21,20,25,6,2],
		[889,35,24,0,6,2,58,6,1,23,36,22,7,5],
		[890,88,24,0,0,3,0,52,0,52,21,6,6,1],
		[891,88,24,0,0,3,0,53,0,52,21,8,8,1],
		[892,88,24,0,0,2,58,42,1,2,46,57,6,2],
		[893,88,24,0,0,2,57,33,1,38,11,28,7,2],
		[894,88,24,0,0,3,0,12,0,38,7,54,7,1],
		[895,88,24,0,0,2,58,47,1,9,46,35,7,2],
		[896,16,10,0,91,2,59,43,0,8,54,27,6,1],
		[897,35,7,1,0,2,58,16,1,40,18,17,4,2],
		[898,35,7,2,0,2,58,16,1,40,18,16,5,2],
		[899,35,24,0,5,2,59,41,1,2,27,54,7,1],
		[900,88,24,0,0,2,59,7,1,28,54,25,7,5],
		[901,36,5,0,0,2,59,36,1,25,16,27,7,3],
		[902,88,24,0,0,3,0,44,0,10,52,13,7,5],
		[903,88,24,0,0,2,59,38,1,32,30,26,7,2],
		[904,35,24,0,7,3,0,51,1,2,52,43,7,7],
		[905,6,24,0,49,3,1,54,0,26,27,44,7,2],
		[906,88,24,0,0,3,11,43,0,81,28,14,7,2],
		[907,35,16,1,8,3,1,10,1,7,39,46,7,5],
		[908,88,24,0,0,3,1,52,0,5,20,10,7,5],
		[909,40,1,0,0,2,58,48,1,64,4,17,6,2],
		[910,16,24,0,93,3,2,23,0,4,21,10,7,1],
		[911,16,0,0,92,3,2,17,0,4,5,23,4,7],
		[912,88,24,0,0,3,1,56,1,9,57,41,7,4],
		[913,88,24,0,0,3,2,9,1,6,29,41,7,4],
		[914,36,4,0,0,3,1,38,1,28,5,30,7,4],
		[915,62,2,0,23,3,4,48,0,53,30,23,4,4],
		[916,88,24,0,0,3,3,30,0,28,16,11,7,3],
		[917,35,16,2,9,3,2,42,1,7,41,7,6,5],
		[918,88,24,0,0,3,5,32,0,56,42,21,6,4],
		[919,35,18,3,11,3,2,24,1,23,37,28,5,2],
		[920,88,24,0,0,3,5,40,0,56,4,7,7,4],
		[921,62,16,0,25,3,5,11,0,38,50,25,4,7],
		[922,88,24,0,0,3,7,19,0,64,3,28,7,1],
		[923,88,24,0,0,3,5,21,0,40,34,57,7,5],
		[924,88,24,0,0,3,4,41,0,15,51,22,7,5],
		[925,35,16,3,10,3,4,16,1,7,36,3,6,2],
		[926,88,24,0,0,3,4,38,0,1,51,49,7,5],
		[927,6,24,0,52,3,5,27,0,25,15,19,8,1],
		[928,6,24,0,52,3,5,27,0,25,15,19,8,1],
		[929,88,24,0,0,3,2,56,1,46,58,30,7,5],
		[930,88,24,0,0,3,8,4,0,52,12,48,7,1],
		[931,88,24,0,0,3,6,24,0,13,11,14,7,5],
		[932,88,24,0,0,3,11,56,0,74,23,37,6,2],
		[933,88,24,0,0,3,7,47,0,47,18,30,7,2],
		[934,40,11,0,0,3,3,37,1,59,44,16,6,3],
		[935,88,24,0,0,3,6,34,1,6,5,19,6,7],
		[936,62,1,0,26,3,8,10,0,40,57,20,3,1],
		[937,62,8,0,0,3,9,4,0,49,36,48,5,4],
		[938,6,24,0,53,3,7,26,0,17,52,48,7,1],
		[939,42,7,0,0,3,2,15,1,71,54,9,7,1],
		[940,6,24,0,54,3,8,21,0,18,47,42,7,7],
		[941,62,9,0,27,3,9,30,0,44,51,26,5,5],
		[942,88,24,0,0,3,8,39,0,8,28,15,7,4],
		[943,88,24,0,0,3,7,51,1,27,49,52,7,2],
		[944,6,24,0,55,3,9,37,0,29,4,37,7,1],
		[945,88,24,0,0,3,10,9,0,27,49,12,7,2],
		[946,88,24,0,0,3,10,27,0,26,53,47,7,5],
		[947,62,23,0,28,3,11,17,0,39,36,42,6,5],
		[948,88,24,0,0,3,10,39,0,11,52,21,7,1],
		[949,88,24,0,0,3,12,26,0,47,43,33,7,5],
		[950,88,24,0,0,3,12,10,0,42,22,34,7,1],
		[951,6,3,0,57,3,11,38,0,19,43,36,5,5],
		[952,88,24,0,0,3,11,22,0,13,2,52,7,5],
		[953,88,24,0,0,3,10,35,1,23,44,18,7,5],
		[954,6,24,0,56,3,12,14,0,27,15,25,7,1],
		[955,88,24,0,0,3,11,19,1,3,48,42,7,7],
		[956,88,24,0,0,3,13,24,0,48,10,37,7,4],
		[957,88,24,0,0,3,11,17,1,16,1,31,7,5],
		[958,88,24,0,0,3,12,26,0,6,39,39,7,5],
		[959,88,24,0,0,3,7,49,1,69,15,56,7,5],
		[960,88,24,0,0,3,10,27,1,48,44,3,7,5],
		[961,88,24,0,0,3,20,20,0,77,44,5,6,2],
		[962,16,24,0,94,3,12,46,1,1,11,46,6,3],
		[963,36,0,0,0,3,12,4,1,28,59,13,5,3],
		[964,88,24,0,0,3,15,48,0,57,8,27,7,2],
		[965,88,24,0,0,3,32,20,0,84,54,40,7,4],
		[966,88,24,0,0,3,14,57,0,42,30,14,7,5],
		[967,88,24,0,0,3,17,32,0,65,39,31,7,2],
		[968,88,24,0,0,3,12,26,1,44,25,11,7,3],
		[969,88,24,0,0,3,16,12,0,50,56,16,6,4],
		[970,88,24,0,0,3,13,2,1,35,56,38,7,1],
		[971,88,24,0,0,3,15,21,0,30,33,24,7,2],
		[972,6,5,0,58,3,14,54,0,21,2,40,6,2],
		[973,88,24,0,0,3,16,5,0,45,20,45,7,7],
		[974,88,24,0,0,3,13,38,1,29,48,15,7,5],
		[975,88,24,0,0,3,15,47,0,32,51,23,7,3],
		[976,88,24,0,0,3,16,2,0,34,41,19,7,2],
		[977,88,24,0,0,3,12,33,1,57,19,18,7,6],
		[978,88,24,0,0,3,16,35,0,32,11,1,7,4],
		[979,88,24,0,0,3,17,11,0,40,29,0,7,1],
		[980,88,24,0,0,3,15,0,1,26,6,1,7,2],
		[981,88,24,0,0,3,7,32,1,78,59,22,7,3],
		[982,62,24,0,30,3,17,47,0,44,1,30,6,1],
		[983,88,24,0,0,3,16,1,1,5,55,7,7,1],
		[984,35,5,0,13,3,15,50,1,8,49,11,6,2],
		[985,88,24,0,0,3,19,59,0,65,39,8,6,1],
		[986,88,24,0,0,3,17,46,0,39,17,0,7,2],
		[987,62,24,0,29,3,18,38,0,50,13,20,6,1],
		[988,35,24,0,14,3,16,36,1,9,9,16,7,3],
		[989,62,24,0,31,3,19,8,0,50,5,42,6,1],
		[990,88,24,0,0,3,16,11,1,30,49,39,8,2],
		[991,88,24,0,0,3,18,44,0,34,13,22,6,5],
		[992,16,24,0,95,3,18,22,1,0,55,49,6,4],
		[993,88,24,0,0,3,18,3,1,28,47,49,7,3],
		[994,35,24,0,15,3,18,22,1,22,30,41,6,4],
		[995,6,24,0,59,3,19,56,0,27,4,16,7,4],
		[996,16,9,1,96,3,19,22,0,3,22,13,6,4],
		[997,88,24,0,0,3,18,41,1,18,33,35,7,3],
		[998,88,24,0,0,3,17,27,1,47,45,6,7,5],
		[999,88,24,0,0,3,20,20,0,29,2,54,5,5],
		[1000,6,24,0,60,3,20,26,0,25,39,46,7,5],
		[1001,88,24,0,0,3,21,53,0,49,4,15,7,3],
		[1002,62,24,0,32,3,21,27,0,43,19,46,6,2],
		[1003,35,18,4,16,3,19,31,1,21,45,28,5,7],
		[1004,88,24,0,0,3,19,35,1,24,7,23,7,7],
		[1005,6,18,1,61,3,21,14,0,21,8,49,6,1],
		[1006,69,5,1,0,3,17,46,1,62,34,31,7,4],
		[1007,16,9,2,97,3,21,7,0,3,40,32,7,4],
		[1008,88,24,0,0,3,19,56,1,43,4,11,5,4],
		[1009,88,24,0,0,3,24,41,0,64,35,10,6,7],
		[1010,69,5,2,0,3,18,13,1,62,30,23,6,4],
		[1011,88,24,0,0,3,23,13,0,49,12,48,6,1],
		[1012,6,24,0,62,3,22,12,0,27,36,27,7,4],
		[1013,88,24,0,0,3,20,45,1,26,36,23,7,3],
		[1014,88,24,0,0,3,17,59,1,66,55,37,7,2],
		[1015,6,18,2,63,3,22,45,0,20,44,31,6,5],
		[1016,88,24,0,0,3,21,24,1,23,38,7,7,4],
		[1017,62,0,0,33,3,24,19,0,49,51,40,3,3],
		[1018,88,24,0,0,3,22,16,1,25,35,16,7,2],
		[1019,88,24,0,0,3,24,30,0,33,32,9,7,2],
		[1020,88,24,0,0,3,25,48,0,53,55,18,8,2],
		[1021,88,24,0,0,3,21,33,1,47,46,37,7,5],
		[1022,6,24,0,64,3,24,19,0,24,43,27,7,5],
		[1023,88,24,0,0,3,23,39,0,4,52,55,7,4],
		[1024,88,24,0,0,3,23,18,1,7,47,39,7,4],
		[1025,42,8,0,0,3,15,58,1,77,23,18,7,3],
		[1026,88,24,0,0,3,25,9,0,41,15,26,8,2],
		[1027,6,24,0,65,3,24,26,0,20,48,13,7,2],
		[1028,88,24,0,0,3,24,10,0,12,37,46,7,5],
		[1029,88,24,0,0,3,25,57,0,49,7,15,7,1],
		[1030,77,14,0,1,3,24,49,0,9,1,44,5,4],
		[1031,88,24,0,0,3,23,45,1,32,42,26,8,5],
		[1032,88,24,0,0,3,30,20,0,71,51,50,7,7],
		[1033,88,24,0,0,3,28,24,0,60,15,20,7,1],
		[1034,88,24,0,0,3,28,3,0,49,3,46,6,1],
		[1035,88,24,0,0,3,29,4,0,59,56,25,5,1],
		[1036,88,24,0,0,3,27,3,0,18,45,23,8,2],
		[1037,88,24,0,0,3,28,52,0,49,50,54,7,1],
		[1038,77,13,0,2,3,27,10,0,9,43,58,5,1],
		[1039,88,24,0,0,3,27,19,0,12,44,6,7,2],
		[1040,88,24,0,0,3,29,55,0,58,52,43,6,2],
		[1041,88,24,0,0,3,28,21,0,33,48,27,7,2],
		[1042,36,21,1,0,3,25,56,1,35,55,15,7,2],
		[1043,88,24,0,0,3,30,11,0,59,21,58,7,2],
		[1044,62,24,0,34,3,29,22,0,49,30,32,6,1],
		[1045,88,24,0,0,3,26,23,1,27,19,3,7,4],
		[1046,88,24,0,0,3,30,0,0,55,27,7,6,2],
		[1047,88,24,0,0,3,29,26,0,46,56,16,7,1],
		[1048,6,24,0,66,3,28,27,0,22,48,15,7,5],
		[1049,88,24,0,0,3,26,12,1,41,38,13,7,2],
		[1050,88,24,0,0,3,28,1,1,11,17,12,7,5],
		[1051,88,24,0,0,3,30,37,0,48,6,13,7,1],
		[1052,62,17,0,35,3,30,35,0,47,59,43,5,5],
		[1053,88,24,0,0,3,24,3,1,69,37,29,7,4],
		[1054,36,21,2,0,3,27,33,1,35,40,53,7,5],
		[1055,88,24,0,0,3,35,12,0,73,20,49,8,2],
		[1056,88,24,0,0,3,31,29,0,49,12,35,7,2],
		[1058,36,21,3,0,3,28,12,1,35,51,12,8,2],
		[1059,88,24,0,0,3,31,49,0,49,24,3,7,1],
		[1060,88,24,0,0,3,29,39,1,6,48,18,7,4],
		[1061,77,24,0,4,3,30,25,0,11,20,11,6,2],
		[1062,88,24,0,0,3,29,36,1,12,40,29,7,2],
		[1063,88,24,0,0,3,32,9,0,48,1,25,6,1],
		[1064,88,24,0,0,3,25,36,1,69,20,11,7,3],
		[1065,88,24,0,0,3,31,21,0,27,34,19,7,2],
		[1066,77,24,0,5,3,30,52,0,12,56,12,5,5],
		[1067,88,24,0,0,3,30,45,0,6,11,19,7,4],
		[1068,88,24,0,0,3,33,32,0,58,45,54,7,2],
		[1069,62,24,0,36,3,32,26,0,46,3,25,6,3],
		[1070,35,24,0,17,3,30,37,1,5,4,31,6,1],
		[1071,88,24,0,0,3,33,41,0,57,52,8,7,3],
		[1072,88,24,0,0,3,32,39,0,44,51,20,7,1],
		[1073,88,24,0,0,3,33,39,0,54,58,29,7,2],
		[1074,88,24,0,0,3,32,40,0,35,27,42,7,1],
		[1075,88,24,0,0,3,29,55,1,42,38,3,7,2],
		[1076,88,24,0,0,3,30,14,1,41,22,12,7,3],
		[1077,88,24,0,0,3,35,1,0,60,2,28,7,3],
		[1078,88,24,0,0,3,33,35,0,39,53,58,7,2],
		[1079,77,24,0,6,3,32,36,0,9,22,25,7,1],
		[1080,88,24,0,0,3,39,25,0,75,44,23,7,4],
		[1081,88,24,0,0,3,30,37,1,47,22,31,7,2],
		[1082,88,24,0,0,3,31,54,1,25,36,51,7,2],
		[1083,69,9,0,0,3,29,23,1,62,56,15,6,3],
		[1084,35,4,0,18,3,32,56,1,9,27,30,5,5],
		[1085,88,24,0,0,3,34,8,0,17,49,58,7,5],
		[1086,77,24,0,7,3,34,27,0,24,27,52,7,2],
		[1087,62,22,0,37,3,36,29,0,48,11,34,5,1],
		[1088,35,18,5,19,3,33,47,1,21,37,58,5,1],
		[1089,88,24,0,0,3,34,49,0,6,25,4,7,4],
		[1090,88,24,0,0,3,32,35,1,50,22,43,7,5],
		[1091,88,24,0,0,3,34,37,1,9,52,7,7,2],
		[1092,88,24,0,0,3,30,52,1,66,29,23,7,1],
		[1093,88,24,0,0,3,33,57,1,31,4,49,7,3],
		[1094,88,24,0,0,3,38,20,0,56,55,58,7,1],
		[1095,88,24,0,0,3,34,34,1,31,52,29,7,5],
		[1096,88,24,0,0,3,32,52,1,61,1,1,7,5],
		[1097,88,24,0,0,3,38,0,0,42,34,59,7,1],
		[1098,88,24,0,0,3,35,58,1,11,11,37,7,4],
		[1099,88,24,0,0,3,36,47,0,0,35,16,7,4],
		[1100,35,24,0,20,3,36,17,1,17,28,1,6,1],
		[1101,77,24,0,10,3,36,52,0,0,24,6,5,3],
		[1102,88,24,0,0,3,37,48,0,15,25,51,7,2],
		[1103,88,24,0,0,3,39,0,0,20,54,57,8,2],
		[1104,88,24,0,0,3,34,25,1,65,45,52,8,2],
		[1105,88,24,0,0,3,42,9,0,63,13,0,6,7],
		[1106,88,24,0,0,3,37,6,1,40,16,29,6,5],
		[1107,88,24,0,0,4,10,2,0,86,37,34,7,3],
		[1108,88,24,0,0,3,38,29,1,7,23,30,7,4],
		[1109,88,24,0,0,3,29,59,1,78,21,7,7,4],
		[1110,88,24,0,0,3,39,26,0,16,32,12,7,5],
		[1111,35,24,0,21,3,39,1,1,5,37,34,7,5],
		[1112,88,24,0,0,3,42,43,0,59,58,10,7,5],
		[1113,88,24,0,0,3,41,8,0,37,34,48,7,1],
		[1114,36,18,0,0,3,38,48,1,27,56,35,7,2],
		[1115,77,24,0,12,3,39,51,0,3,3,25,7,4],
		[1116,88,24,0,0,3,39,38,1,3,23,35,7,4],
		[1117,88,24,0,0,3,39,25,1,10,26,14,7,4],
		[1118,77,24,0,11,3,40,46,0,25,19,46,7,2],
		[1119,88,24,0,0,3,39,60,1,1,7,14,7,5],
		[1120,88,24,0,0,3,40,11,1,15,13,36,7,4],
		[1121,35,24,0,22,3,40,38,1,5,12,38,7,1],
		[1122,62,3,0,39,3,42,56,0,47,47,15,4,1],
		[1123,62,24,0,40,3,42,23,0,33,57,54,6,1],
		[1124,88,24,0,0,3,46,1,0,67,12,6,7,3],
		[1125,88,24,0,0,3,41,14,1,11,48,11,7,3],
		[1126,77,24,0,13,3,42,19,0,19,42,1,7,1],
		[1127,88,24,0,0,3,44,6,0,48,31,25,7,5],
		[1128,88,24,0,0,3,41,22,1,19,35,5,8,2],
		[1129,88,24,0,0,3,46,2,0,63,20,42,6,4],
		[1130,88,24,0,0,3,44,41,0,46,5,59,7,2],
		[1131,62,14,0,38,3,44,19,0,32,17,18,5,1],
		[1132,77,24,0,14,3,43,47,0,19,39,54,7,4],
		[1133,88,24,0,0,3,44,31,0,36,27,36,7,2],
		[1134,36,3,0,0,3,42,15,1,31,56,18,6,1],
		[1135,62,12,0,41,3,45,12,0,42,34,43,5,3],
		[1136,35,3,0,23,3,43,15,1,9,45,48,5,5],
		[1137,88,24,0,0,3,44,28,0,20,55,43,7,2],
		[1138,88,24,0,0,3,49,14,0,70,52,16,6,2],
		[1139,88,24,0,0,3,43,34,1,10,29,8,7,2],
		[1140,77,24,0,16,3,44,48,0,24,17,22,6,1],
		[1141,88,24,0,0,3,45,59,0,45,40,55,7,1],
		[1142,77,24,0,17,3,44,53,0,24,6,48,5,1],
		[1143,88,24,0,0,3,42,50,1,37,18,49,6,5],
		[1144,77,24,0,18,3,45,10,0,24,50,21,7,1],
		[1145,77,24,0,19,3,45,13,0,24,28,2,5,1],
		[1146,35,24,0,24,3,44,31,1,1,9,47,6,1],
		[1147,88,24,0,0,3,47,32,0,55,55,21,7,1],
		[1148,10,2,0,0,3,50,22,0,71,19,56,6,2],
		[1149,77,24,0,20,3,45,50,0,24,22,4,5,1],
		[1150,35,24,0,25,3,44,57,1,0,17,48,7,5],
		[1151,77,24,0,21,3,45,54,0,24,33,17,7,1],
		[1152,77,24,0,22,3,46,3,0,24,31,41,7,2],
		[1153,77,24,0,29,3,45,40,0,6,3,0,6,1],
		[1154,88,24,0,0,3,36,30,1,78,19,23,7,5],
		[1155,88,24,0,0,3,49,31,0,65,31,34,5,7],
		[1156,77,24,0,23,3,46,20,0,23,56,54,5,1],
		[1157,88,24,0,0,3,44,6,1,40,39,37,7,5],
		[1158,88,24,0,0,3,49,37,0,63,17,50,7,2],
		[1159,88,24,0,0,3,46,10,0,6,48,11,7,4],
		[1160,88,24,0,0,3,48,18,0,50,44,12,7,1],
		[1161,88,24,0,0,3,49,20,0,57,7,5,7,2],
		[1162,35,15,0,26,3,46,9,1,12,6,6,5,7],
		[1163,88,24,0,0,3,47,53,0,33,36,0,8,1],
		[1164,88,24,0,0,3,47,49,0,32,11,42,7,4],
		[1165,77,6,0,25,3,47,29,0,24,6,18,4,1],
		[1166,88,24,0,0,3,51,42,0,68,30,27,7,1],
		[1167,88,24,0,0,3,44,51,1,48,3,41,7,4],
		[1168,88,24,0,0,3,44,34,1,54,16,26,7,5],
		[1169,88,24,0,0,3,45,16,1,47,21,35,7,5],
		[1170,88,24,0,0,3,49,8,0,43,57,47,7,2],
		[1171,36,17,0,0,3,46,27,1,29,20,17,7,2],
		[1172,88,24,0,0,3,48,21,0,23,25,16,6,1],
		[1173,35,18,6,27,3,46,51,1,23,14,59,5,3],
		[1174,77,24,0,30,3,48,16,0,11,8,36,6,1],
		[1175,69,1,0,0,3,44,12,1,64,48,25,5,5],
		[1176,88,24,0,0,3,50,5,0,44,58,4,7,4],
		[1177,62,24,0,42,3,49,33,0,33,5,29,6,2],
		[1178,77,24,0,27,3,49,10,0,24,3,12,5,1],
		[1179,88,24,0,0,3,47,20,1,29,54,7,8,3],
		[1180,77,24,0,28,3,49,11,0,24,8,12,6,1],
		[1181,35,18,7,28,3,47,40,1,23,52,29,6,2],
		[1182,88,24,0,0,3,48,39,0,0,13,40,7,5],
		[1183,88,24,0,0,3,49,44,0,23,42,42,7,1],
		[1184,36,16,0,0,3,47,56,1,30,10,4,7,4],
		[1185,88,24,0,0,3,49,55,0,22,14,40,7,1],
		[1186,88,24,0,0,3,47,50,1,36,6,21,7,1],
		[1187,88,24,0,0,3,48,36,1,20,54,11,7,5],
		[1188,88,24,0,0,3,50,19,0,25,34,46,6,2],
		[1189,88,24,0,0,3,48,35,1,37,37,20,6,2],
		[1190,88,24,0,0,3,48,36,1,37,37,14,6,1],
		[1191,88,24,0,0,3,51,54,0,34,21,33,7,1],
		[1192,88,24,0,0,3,53,43,0,57,58,30,7,2],
		[1193,88,24,0,0,3,51,37,0,22,1,54,8,5],
		[1194,88,24,0,0,3,51,16,0,13,2,45,7,1],
		[1195,88,24,0,0,3,49,27,1,36,12,1,5,4],
		[1196,88,24,0,0,3,56,30,0,71,49,18,7,2],
		[1197,88,24,0,0,3,52,4,0,31,10,6,7,2],
		[1198,88,24,0,0,3,53,39,0,48,39,2,7,5],
		[1199,77,24,0,31,3,52,0,0,6,32,5,7,1],
		[1200,88,24,0,0,3,50,38,1,36,25,31,8,1],
		[1201,88,24,0,0,3,53,10,0,17,19,37,7,3],
		[1202,35,24,0,30,3,52,42,1,5,21,41,6,1],
		[1203,62,5,0,44,3,54,8,0,31,53,1,4,1],
		[1204,88,24,0,0,3,57,26,0,63,4,20,6,1],
		[1205,88,24,0,0,3,57,8,0,61,6,32,6,5],
		[1206,88,24,0,0,3,53,13,1,18,26,4,7,5],
		[1207,88,24,0,0,3,55,58,0,47,52,17,6,1],
		[1208,42,2,0,0,3,47,14,1,74,14,20,4,7],
		[1209,88,24,0,0,3,55,23,0,31,2,45,7,0],
		[1210,62,24,0,43,3,56,37,0,50,41,43,6,3],
		[1211,35,24,0,32,3,54,17,1,2,57,10,7,2],
		[1212,35,24,0,32,3,54,18,1,2,57,17,6,4],
		[1213,35,18,8,33,3,53,43,1,24,36,45,6,1],
		[1214,88,24,0,0,3,53,39,1,34,43,56,6,1],
		[1215,88,24,0,0,3,56,29,0,35,4,52,6,1],
		[1216,88,24,0,0,3,53,33,1,46,53,37,7,5],
		[1217,88,24,0,0,3,55,16,1,12,5,57,7,2],
		[1218,77,24,0,32,3,56,52,0,22,28,41,7,3],
		[1219,88,24,0,0,3,54,23,1,40,21,26,7,5],
		[1220,62,4,0,45,3,57,51,0,40,0,37,4,1],
		[1221,77,24,0,33,3,57,4,0,23,10,32,7,1],
		[1222,88,24,0,0,3,57,26,0,24,27,43,7,5],
		[1223,88,24,0,0,3,58,3,0,34,48,52,8,2],
		[1224,88,24,0,0,3,57,2,0,6,2,24,7,2],
		[1225,88,24,0,0,3,56,38,1,9,45,3,7,3],
		[1226,88,24,0,0,3,58,29,0,38,50,25,7,5],
		[1227,88,24,0,0,3,54,34,1,52,41,26,7,2],
		[1228,62,13,0,46,3,58,58,0,35,47,28,5,0],
		[1229,88,24,0,0,3,59,40,0,38,49,14,7,2],
		[1230,88,24,0,0,4,10,3,0,80,41,55,6,4],
		[1231,35,2,0,34,3,58,2,1,13,30,31,4,7],
		[1232,88,24,0,0,3,58,52,1,5,28,12,7,4],
		[1233,88,24,0,0,3,59,41,0,10,19,51,7,3],
		[1234,88,24,0,0,4,1,15,0,36,59,24,7,2],
		[1235,88,24,0,0,3,59,30,1,12,34,27,7,5],
		[1236,88,24,0,0,3,56,4,1,63,27,49,7,5],
		[1237,88,24,0,0,4,0,37,0,17,17,48,7,2],
		[1238,88,24,0,0,4,0,49,0,18,11,38,7,3],
		[1239,77,10,0,35,4,0,41,0,12,29,25,4,1],
		[1240,35,18,9,36,3,59,56,1,24,0,59,6,1],
		[1241,88,24,0,0,4,6,3,0,68,40,48,7,5],
		[1242,88,24,0,0,4,4,27,0,59,9,20,6,3],
		[1243,88,24,0,0,4,1,46,0,9,59,52,7,1],
		[1244,35,24,0,35,4,1,32,1,1,32,59,6,1],
		[1245,88,24,0,0,3,58,43,1,57,6,9,7,3],
		[1246,88,24,0,0,4,0,41,1,30,29,27,7,2],
		[1247,69,3,0,0,3,58,45,1,61,24,1,6,7],
		[1248,88,24,0,0,4,6,39,0,65,31,15,7,2],
		[1249,88,24,0,0,4,2,37,1,0,16,8,6,3],
		[1250,88,24,0,0,4,0,16,1,51,33,53,8,7],
		[1251,77,12,0,38,4,3,9,0,5,59,21,5,2],
		[1252,77,24,0,36,4,4,22,0,24,6,21,6,4],
		[1253,77,24,0,40,4,3,45,0,5,26,8,6,1],
		[1254,88,24,0,0,4,3,57,0,8,11,50,6,3],
		[1255,88,24,0,0,4,6,37,0,54,0,31,7,5],
		[1256,77,24,0,37,4,4,42,0,22,4,55,5,5],
		[1257,88,24,0,0,4,4,10,0,2,49,37,6,3],
		[1258,88,24,0,0,4,3,25,1,20,8,39,7,1],
		[1259,88,24,0,0,4,3,37,1,20,9,30,8,5],
		[1260,88,24,0,0,4,7,51,0,62,19,48,8,1],
		[1261,62,10,0,47,4,6,35,0,50,21,5,5,2],
		[1262,77,24,0,39,4,5,20,0,22,0,32,7,4],
		[1263,88,24,0,0,4,4,9,1,16,35,20,7,5],
		[1264,69,2,0,0,4,0,54,1,62,9,34,6,7],
		[1265,88,24,0,0,4,4,23,1,12,47,33,7,5],
		[1266,69,8,0,0,4,1,18,1,61,4,44,6,5],
		[1267,88,24,0,0,4,4,41,1,20,22,54,7,5],
		[1268,77,24,0,41,4,6,36,0,27,36,0,6,1],
		[1269,77,22,0,42,4,7,1,0,29,0,5,6,3],
		[1270,88,24,0,0,4,9,28,0,59,54,29,7,4],
		[1271,88,24,0,0,3,42,32,1,85,15,44,7,1],
		[1272,88,24,0,0,4,5,57,1,8,51,22,7,2],
		[1273,62,24,0,48,4,8,40,0,47,42,45,5,1],
		[1274,88,24,0,0,4,5,47,1,20,30,44,7,4],
		[1275,88,24,0,0,4,5,37,1,27,39,6,7,3],
		[1276,88,24,0,0,4,9,22,0,54,49,44,7,3],
		[1277,62,24,0,49,4,8,15,0,37,43,40,7,5],
		[1278,62,24,0,50,4,8,37,0,38,2,23,7,3],
		[1279,88,24,0,0,4,7,42,0,15,9,46,7,3],
		[1280,88,24,0,0,4,7,59,0,17,20,23,7,5],
		[1281,88,24,0,0,4,13,45,0,72,7,35,7,5],
		[1282,88,24,0,0,4,12,52,0,68,30,6,7,5],
		[1283,77,23,1,43,4,9,10,0,19,36,33,7,5],
		[1284,88,24,0,0,4,9,2,0,13,23,54,7,1],
		[1285,88,24,0,0,4,7,25,1,42,55,1,8,5],
		[1286,88,24,0,0,4,10,59,0,33,35,12,7,5],
		[1287,77,24,0,44,4,10,50,0,26,28,51,6,3],
		[1288,88,24,0,0,4,9,18,1,16,23,9,6,1],
		[1289,88,24,0,0,4,28,13,0,83,48,28,7,1],
		[1290,35,24,0,37,4,10,23,1,6,55,26,6,4],
		[1291,88,24,0,0,4,8,34,1,45,51,53,8,3],
		[1292,77,24,0,45,4,11,20,0,5,31,23,7,3],
		[1293,88,24,0,0,4,10,48,1,8,49,11,7,4],
		[1294,88,24,0,0,4,7,22,1,64,13,21,7,4],
		[1295,88,24,0,0,4,12,31,0,17,16,39,7,5],
		[1296,88,24,0,0,4,15,2,0,57,27,37,7,2],
		[1297,88,24,0,0,4,12,51,0,22,24,49,7,1],
		[1298,35,14,1,38,4,11,52,1,6,50,15,5,3],
		[1299,88,24,0,0,4,10,46,1,35,16,26,7,5],
		[1300,88,24,0,0,4,11,36,1,20,21,22,7,2],
		[1301,88,24,0,0,4,13,60,0,37,58,1,7,4],
		[1302,40,3,0,0,4,10,51,1,41,59,37,6,2],
		[1303,62,11,0,51,4,14,54,0,48,24,34,5,4],
		[1304,88,24,0,0,4,30,0,0,83,20,26,6,4],
		[1305,88,24,0,0,4,16,54,0,61,51,1,7,1],
		[1306,62,24,0,52,4,14,53,0,40,29,1,6,4],
		[1307,88,24,0,0,4,13,35,0,10,12,44,7,1],
		[1308,88,24,0,0,4,13,31,0,8,53,26,8,2],
		[1309,77,24,0,46,4,13,33,0,7,42,58,6,3],
		[1310,88,24,0,0,4,13,50,0,12,45,12,7,5],
		[1311,77,24,0,47,4,13,56,0,9,15,49,6,4],
		[1312,88,24,0,0,4,13,38,1,1,8,59,7,1],
		[1313,88,24,0,0,4,17,8,0,57,51,38,7,5],
		[1314,88,24,0,0,4,16,43,0,53,36,43,6,2],
		[1315,88,24,0,0,4,14,36,0,10,0,40,6,1],
		[1316,88,24,0,0,4,12,32,1,44,22,6,8,5],
		[1317,88,24,0,0,4,27,3,0,80,49,27,6,4],
		[1318,35,24,0,39,4,14,24,1,10,15,23,6,5],
		[1319,77,24,0,48,4,15,46,0,15,24,2,7,3],
		[1320,77,11,0,49,4,15,32,0,8,53,32,5,1],
		[1321,88,24,0,0,4,15,26,0,6,11,59,8,4],
		[1322,88,24,0,0,4,15,29,0,6,11,12,7,4],
		[1323,88,24,0,0,4,13,36,1,40,21,28,7,5],
		[1324,88,24,0,0,4,18,15,0,50,17,44,6,2],
		[1325,35,14,2,40,4,15,16,1,7,39,10,5,5],
		[1326,40,0,0,0,4,14,0,1,42,17,40,5,5],
		[1327,88,24,0,0,4,20,40,0,65,8,26,6,4],
		[1328,88,24,0,0,4,18,8,0,42,8,28,7,1],
		[1329,77,23,2,50,4,17,16,0,20,34,43,6,2],
		[1330,88,24,0,0,4,19,13,0,50,2,56,6,2],
		[1331,77,24,0,51,4,18,23,0,21,34,45,7,3],
		[1332,88,24,0,0,4,17,19,1,6,28,19,7,4],
		[1333,88,24,0,0,4,20,12,0,50,55,15,7,1],
		[1334,88,24,0,0,4,18,25,0,9,29,12,8,2],
		[1335,88,24,0,0,4,21,48,0,60,44,8,6,7],
		[1336,69,0,0,0,4,14,26,1,62,28,26,4,4],
		[1337,88,24,0,0,4,20,14,0,41,48,29,7,5],
		[1338,32,2,0,0,4,16,2,1,51,29,12,5,3],
		[1339,77,24,0,53,4,19,26,0,21,8,32,6,1],
		[1340,88,24,0,0,4,14,49,1,62,11,31,6,5],
		[1341,77,24,0,56,4,19,37,0,21,46,25,6,2],
		[1342,88,24,0,0,4,21,52,0,56,30,24,7,2],
		[1343,62,24,0,54,4,20,25,0,34,34,0,6,4],
		[1344,88,24,0,0,4,20,10,0,31,57,12,7,5],
		[1345,88,24,0,0,4,18,16,1,20,42,56,7,4],
		[1346,77,2,0,54,4,19,48,0,15,37,39,5,5],
		[1347,35,19,4,41,4,17,54,1,33,47,54,5,1],
		[1348,77,20,0,52,4,20,21,0,27,21,3,6,5],
		[1349,88,24,0,0,4,19,38,0,10,7,17,7,5],
		[1350,62,24,0,53,4,21,33,0,46,29,56,6,1],
		[1351,77,24,0,57,4,19,58,0,14,2,7,7,3],
		[1352,88,24,0,0,4,22,58,0,59,36,59,7,2],
		[1353,88,24,0,0,4,18,37,1,22,58,13,7,2],
		[1354,88,24,0,0,4,20,25,0,18,44,33,7,3],
		[1355,69,4,0,0,4,16,29,1,59,18,7,5,5],
		[1356,77,24,0,58,4,20,36,0,15,5,43,6,3],
		[1357,88,24,0,0,4,16,21,1,60,56,55,7,2],
		[1358,88,24,0,0,4,20,53,0,13,51,51,7,3],
		[1359,88,24,0,0,4,19,3,1,33,54,18,7,2],
		[1360,88,24,0,0,4,20,41,0,6,7,51,7,4],
		[1361,88,24,0,0,4,20,49,0,9,13,32,8,2],
		[1362,88,24,0,0,4,20,39,1,6,14,44,7,4],
		[1363,88,24,0,0,4,20,43,1,7,35,33,7,1],
		[1364,88,24,0,0,4,19,17,1,44,16,5,6,5],
		[1365,88,24,0,0,4,18,40,1,52,51,36,7,3],
		[1366,88,24,0,0,4,21,27,1,0,5,53,7,5],
		[1367,88,24,0,0,4,20,39,1,20,38,23,6,2],
		[1368,77,24,0,60,4,22,4,0,14,4,38,7,2],
		[1369,77,21,0,59,4,22,35,0,25,37,45,6,1],
		[1370,88,24,0,0,4,22,23,0,20,49,17,7,7],
		[1371,88,24,0,0,4,23,36,0,42,25,41,7,2],
		[1372,69,7,0,0,4,17,40,1,63,15,20,7,1],
		[1373,77,3,1,61,4,22,56,0,17,32,33,5,5],
		[1374,88,24,0,0,4,21,31,1,25,43,42,7,3],
		[1375,88,24,0,0,4,23,32,0,20,58,56,7,1],
		[1376,77,24,0,63,4,23,25,0,16,46,38,7,2],
		[1377,62,24,0,55,4,24,29,0,34,7,50,7,1],
		[1378,77,24,0,62,4,23,60,0,24,18,4,7,1],
		[1379,62,24,0,56,4,24,37,0,33,57,35,7,3],
		[1380,77,3,2,64,4,24,6,0,17,26,38,6,2],
		[1381,77,24,0,66,4,23,52,0,9,27,39,6,2],
		[1382,88,24,0,0,4,27,1,0,57,35,7,7,2],
		[1383,35,13,0,42,4,23,41,1,3,44,44,6,2],
		[1384,88,24,0,0,4,23,6,1,24,53,32,7,5],
		[1385,88,24,0,0,4,24,57,0,19,2,30,7,3],
		[1386,88,24,0,0,4,23,8,1,35,32,42,7,5],
		[1387,77,9,1,65,4,25,22,0,22,17,38,5,2],
		[1388,77,9,2,67,4,25,25,0,22,11,59,6,2],
		[1389,77,3,3,68,4,25,29,0,17,55,41,5,2],
		[1390,88,24,0,0,4,26,6,0,31,26,20,6,5],
		[1391,77,24,0,70,4,25,37,0,15,56,27,7,3],
		[1392,77,19,0,69,4,26,19,0,22,48,49,5,2],
		[1393,35,24,0,43,4,24,2,1,34,1,1,5,5],
		[1394,77,24,0,71,4,26,21,0,15,37,6,5,3],
		[1395,69,6,0,0,4,21,53,1,63,23,11,6,4],
		[1396,77,15,0,73,4,26,36,0,14,42,49,6,4],
		[1397,88,24,0,0,4,26,21,0,8,35,25,7,1],
		[1398,88,24,0,0,4,24,56,1,34,45,28,8,3],
		[1399,77,24,0,72,4,27,18,0,22,59,47,7,1],
		[1400,88,24,0,0,4,27,1,0,2,4,46,7,5],
		[1401,88,24,0,0,4,33,31,0,72,31,43,7,2],
		[1402,88,24,0,0,4,27,29,0,11,12,45,7,1],
		[1403,88,24,0,0,4,28,1,0,21,37,12,7,2],
		[1404,88,24,0,0,4,25,19,1,44,9,39,7,3],
		[1405,88,24,0,0,4,24,12,1,57,4,17,7,4],
		[1406,88,24,0,0,4,28,52,0,30,21,41,7,3],
		[1407,77,24,0,75,4,28,26,0,16,21,35,6,5],
		[1408,77,24,0,76,4,28,23,0,14,44,27,7,3],
		[1409,77,4,0,74,4,28,37,0,19,10,49,5,4],
		[1410,88,24,0,0,4,26,57,1,24,4,53,7,2],
		[1411,77,7,1,77,4,28,35,0,15,57,44,5,5],
		[1412,77,7,2,78,4,28,40,0,15,52,15,4,2],
		[1413,88,24,0,0,4,28,4,0,1,51,31,7,4],
		[1414,77,24,0,79,4,28,50,0,13,2,51,6,2],
		[1415,88,24,0,0,4,28,32,0,1,22,51,7,1],
		[1416,88,24,0,0,4,25,5,1,61,14,18,7,5],
		[1417,10,24,0,1,4,32,2,0,53,54,39,7,1],
		[1418,88,24,0,0,4,27,6,1,46,56,51,7,3],
		[1419,88,24,0,0,4,30,38,0,32,27,29,7,1],
		[1420,88,24,0,0,4,29,43,0,10,31,18,8,1],
		[1421,88,24,0,0,4,28,39,1,19,27,30,7,5],
		[1422,77,24,0,80,4,30,9,0,15,38,17,7,3],
		[1423,88,24,0,0,4,29,7,1,13,2,54,7,1],
		[1424,88,24,0,0,4,31,24,0,40,0,37,7,1],
		[1425,88,24,0,0,4,30,2,0,10,15,45,7,4],
		[1426,52,3,0,0,4,17,59,1,80,12,50,7,5],
		[1427,88,24,0,0,4,30,34,0,16,11,38,6,2],
		[1428,77,24,0,81,4,30,39,0,15,41,31,6,2],
		[1429,88,24,0,0,4,28,9,1,41,57,36,7,7],
		[1430,77,24,0,83,4,30,37,0,13,43,28,6,3],
		[1431,88,24,0,0,4,30,10,1,13,35,32,7,4],
		[1432,77,24,0,85,4,31,52,0,15,51,6,7,3],
		[1433,88,24,0,0,4,29,20,1,46,30,55,7,5],
		[1434,62,24,0,57,4,33,25,0,43,3,50,7,3],
		[1435,88,24,0,0,4,27,46,1,62,31,15,7,5],
		[1436,88,24,0,0,4,32,5,0,5,24,36,7,3],
		[1437,35,24,0,45,4,31,53,1,0,2,38,6,5],
		[1438,88,24,0,0,4,31,26,1,13,38,42,7,2],
		[1439,88,24,0,0,4,30,40,1,35,39,13,7,5],
		[1440,88,24,0,0,4,36,24,0,64,15,42,7,2],
		[1441,88,24,0,0,4,32,37,1,3,12,33,7,1],
		[1442,88,24,0,0,4,33,33,0,18,1,0,7,1],
		[1443,9,3,0,0,4,30,50,1,44,57,14,6,1],
		[1444,77,16,0,86,4,33,51,0,14,50,40,6,2],
		[1445,88,24,0,0,4,34,38,0,28,57,40,7,1],
		[1446,88,24,0,0,4,33,48,0,9,24,47,7,4],
		[1447,88,24,0,0,4,33,22,1,10,47,9,7,5],
		[1448,88,24,0,0,4,34,8,0,5,34,7,7,2],
		[1449,35,24,0,46,4,33,55,1,6,44,20,7,1],
		[1450,88,24,0,0,4,34,14,1,6,50,16,7,5],
		[1451,35,24,0,47,4,34,12,1,8,13,53,6,7],
		[1452,88,24,0,0,4,34,12,1,8,58,13,6,5],
		[1453,35,19,1,50,4,33,31,1,29,46,0,6,5],
		[1454,62,24,0,58,4,36,41,0,41,15,53,5,5],
		[1455,88,24,0,0,4,35,43,0,19,52,54,7,4],
		[1456,52,12,0,0,4,20,58,1,81,34,48,7,3],
		[1457,77,0,0,87,4,35,55,0,16,30,33,2,5],
		[1458,77,24,0,88,4,35,39,0,10,9,39,5,2],
		[1459,88,24,0,0,4,36,29,0,23,20,27,7,3],
		[1460,88,24,0,0,4,35,14,1,9,44,12,7,2],
		[1461,88,24,0,0,4,35,1,1,19,55,14,7,5],
		[1462,88,24,0,0,4,36,2,1,3,36,43,7,1],
		[1463,35,12,0,48,4,36,19,1,3,21,9,5,1],
		[1464,35,19,2,52,4,35,33,1,30,33,44,5,4],
		[1465,32,0,0,0,4,33,60,1,55,2,42,4,2],
		[1466,10,24,0,2,4,39,58,0,53,28,23,6,2],
		[1467,10,24,0,3,4,39,55,0,53,4,47,6,5],
		[1468,88,24,0,0,4,46,0,0,76,36,40,7,3],
		[1469,88,24,0,0,4,37,14,0,0,59,54,6,1],
		[1470,88,24,0,0,4,38,30,0,26,56,24,7,3],
		[1471,88,24,0,0,4,38,16,0,20,41,5,7,1],
		[1472,77,24,0,89,4,38,9,0,16,2,0,7,3],
		[1473,77,24,0,90,4,38,10,0,12,30,39,5,2],
		[1474,35,24,0,51,4,37,36,1,2,28,24,6,3],
		[1475,88,24,0,0,4,33,34,1,62,49,25,7,5],
		[1476,88,24,0,0,4,36,51,1,30,43,0,7,1],
		[1477,88,24,0,0,4,39,23,0,25,13,6,7,2],
		[1478,77,17,1,91,4,39,9,0,15,47,59,6,2],
		[1479,77,17,2,92,4,39,17,0,15,55,5,6,2],
		[1480,88,24,0,0,4,39,6,0,7,52,15,6,2],
		[1481,35,24,0,53,4,38,11,1,14,18,14,5,5],
		[1482,88,24,0,0,4,41,24,0,48,18,3,7,2],
		[1483,88,24,0,0,4,38,54,1,12,7,23,6,2],
		[1484,77,24,0,93,4,40,3,0,12,11,52,6,1],
		[1485,88,24,0,0,4,22,51,1,82,53,57,8,2],
		[1486,88,24,0,0,4,43,18,0,59,31,15,8,2],
		[1487,88,24,0,0,4,39,20,1,14,21,33,6,5],
		[1488,88,24,0,0,4,39,47,1,1,3,10,7,5],
		[1489,88,24,0,0,4,41,50,0,38,16,49,7,4],
		[1490,88,24,0,0,4,41,20,0,28,36,54,7,2],
		[1491,88,24,0,0,4,48,50,0,75,56,28,7,2],
		[1492,88,24,0,0,4,36,46,1,62,4,39,6,7],
		[1493,88,24,0,0,4,43,22,0,49,58,26,7,1],
		[1494,62,24,0,59,4,42,54,0,43,21,54,6,2],
		[1495,88,24,0,0,4,40,7,1,24,28,57,7,4],
		[1496,35,24,0,54,4,40,27,1,19,40,18,5,7],
		[1497,77,18,0,94,4,42,15,0,22,57,25,5,1],
		[1498,88,24,0,0,4,39,4,1,51,40,22,7,5],
		[1499,77,24,0,95,4,43,14,0,24,5,20,7,3],
		[1500,88,24,0,0,4,44,13,0,40,47,13,7,1],
		[1501,88,24,0,0,4,43,48,0,32,51,55,7,2],
		[1502,9,0,0,0,4,40,34,1,41,51,50,5,3],
		[1503,9,1,0,0,4,42,4,1,37,8,40,6,3],
		[1504,88,24,0,0,4,40,18,1,58,56,37,8,4],
		[1505,35,24,0,55,4,43,35,1,8,47,37,8,3],
		[1506,35,24,0,55,4,43,35,1,8,47,46,8,4],
		[1507,88,24,0,0,4,44,26,0,11,8,46,6,3],
		[1508,35,24,0,56,4,44,5,1,8,30,13,7,1],
		[1509,88,24,0,0,4,43,9,1,30,45,56,7,5],
		[1510,88,24,0,0,4,50,36,0,70,56,30,7,2],
		[1511,10,24,0,4,4,48,0,0,56,45,26,6,2],
		[1512,88,24,0,0,4,45,43,0,23,37,41,7,1],
		[1513,88,24,0,0,4,44,8,1,18,40,0,7,2],
		[1514,88,24,0,0,4,46,44,0,40,18,46,7,4],
		[1515,88,24,0,0,4,48,7,0,55,36,9,7,3],
		[1516,64,10,0,0,4,42,46,1,50,28,53,6,5],
		[1517,88,24,0,0,4,46,17,0,18,44,6,7,5],
		[1518,88,24,0,0,4,43,44,1,41,3,53,7,5],
		[1519,88,24,0,0,4,46,2,0,11,42,20,6,2],
		[1520,35,11,0,57,4,45,30,1,3,15,17,5,1],
		[1521,88,24,0,0,4,45,4,1,21,17,1,7,5],
		[1522,88,24,0,0,4,46,24,1,2,57,16,7,2],
		[1523,88,24,0,0,5,0,21,0,81,11,38,6,5],
		[1524,88,24,0,0,4,45,50,1,34,0,18,8,2],
		[1525,88,24,0,0,4,46,26,1,28,5,15,7,2],
		[1526,88,24,0,0,4,45,55,1,39,21,24,7,5],
		[1527,88,24,0,0,4,52,5,0,63,30,19,6,7],
		[1528,88,24,0,0,4,49,19,0,32,35,18,7,2],
		[1529,88,24,0,0,4,49,13,0,31,26,14,7,5],
		[1530,32,9,0,0,4,44,21,1,59,43,58,6,2],
		[1531,88,24,0,0,4,38,22,1,77,39,22,7,5],
		[1532,35,24,0,58,4,47,36,1,16,56,4,7,4],
		[1533,88,24,0,0,4,49,55,0,37,29,18,6,5],
		[1534,88,24,0,0,4,48,45,0,3,35,18,7,5],
		[1535,88,24,0,0,4,51,9,0,48,44,27,7,4],
		[1536,88,24,0,0,4,48,36,1,5,40,26,7,3],
		[1537,77,24,0,96,4,49,44,0,15,54,15,7,5],
		[1538,35,24,0,59,4,48,33,1,16,19,46,7,3],
		[1539,9,5,0,0,4,47,50,1,30,1,13,7,5],
		[1540,88,24,0,0,4,44,58,1,63,13,47,7,5],
		[1541,52,11,0,0,4,43,4,1,70,55,52,7,1],
		[1542,10,0,0,9,4,54,3,0,66,20,34,5,0],
		[1543,59,15,3,1,4,49,50,0,6,57,41,4,3],
		[1544,59,15,2,2,4,50,37,0,8,54,1,5,2],
		[1545,88,24,0,0,4,49,42,1,13,46,11,7,3],
		[1546,88,24,0,0,4,53,10,0,52,50,27,7,2],
		[1547,77,24,0,97,4,51,23,0,18,50,23,6,2],
		[1548,88,24,0,0,4,48,34,1,43,58,48,8,4],
		[1549,35,24,0,60,4,50,12,1,16,13,2,6,5],
		[1550,88,24,0,0,4,52,48,0,42,35,12,7,2],
		[1551,7,24,0,2,4,52,38,0,36,42,11,6,5],
		[1552,59,15,4,3,4,51,12,0,5,36,18,5,1],
		[1553,88,24,0,0,4,51,43,0,9,58,30,7,1],
		[1554,88,24,0,0,4,52,47,0,27,53,51,7,3],
		[1555,10,24,0,5,4,55,3,0,55,15,33,7,1],
		[1556,59,14,1,4,4,52,32,0,14,15,2,6,7],
		[1557,88,24,0,0,4,50,16,1,41,19,15,7,3],
		[1558,88,24,0,0,4,54,51,0,44,3,39,7,2],
		[1559,88,24,0,0,4,51,28,1,34,54,23,7,2],
		[1560,35,23,0,61,4,52,54,1,5,27,10,5,3],
		[1561,88,24,0,0,4,56,7,0,52,52,10,7,2],
		[1562,59,24,0,5,4,53,23,0,2,30,29,6,7],
		[1563,64,8,0,0,4,50,55,1,53,27,41,7,3],
		[1564,64,8,0,0,4,50,56,1,53,27,35,7,3],
		[1565,88,24,0,0,4,53,56,0,1,34,10,8,2],
		[1566,88,24,0,0,4,54,58,0,19,29,7,7,3],
		[1567,59,15,5,8,4,54,15,0,2,26,26,5,1],
		[1568,10,24,0,7,4,57,17,0,53,45,8,5,2],
		[1569,59,24,0,6,4,54,47,0,11,25,34,6,2],
		[1570,59,15,1,7,4,54,54,0,10,9,3,6,2],
		[1571,88,24,0,0,4,54,48,0,7,46,45,6,5],
		[1572,88,24,0,0,5,2,20,0,74,16,9,7,5],
		[1573,88,24,0,0,4,56,20,0,36,10,8,7,1],
		[1574,88,24,0,0,4,54,51,0,0,28,3,7,1],
		[1575,88,24,0,0,4,56,16,0,24,35,32,7,3],
		[1576,88,24,0,0,4,55,50,0,15,2,24,7,1],
		[1577,7,8,0,3,4,56,60,0,33,9,58,4,5],
		[1578,88,24,0,0,4,55,58,0,5,23,57,8,2],
		[1579,88,24,0,0,4,55,7,1,16,44,26,7,4],
		[1580,59,14,2,9,4,56,22,0,13,30,52,5,5],
		[1581,88,24,0,0,4,55,19,1,16,25,4,7,4],
		[1582,35,24,0,62,4,56,24,1,5,10,17,7,1],
		[1583,88,24,0,0,4,55,30,1,25,43,40,8,3],
		[1584,88,24,0,0,4,54,55,1,39,37,43,7,5],
		[1585,88,24,0,0,4,57,22,0,17,9,13,6,5],
		[1586,77,24,0,99,4,57,49,0,23,56,55,7,4],
		[1587,88,24,0,0,5,4,13,0,73,45,50,8,5],
		[1588,10,24,0,8,4,59,46,0,53,9,20,7,5],
		[1589,88,24,0,0,5,4,40,0,74,4,1,7,2],
		[1590,77,24,0,98,4,58,9,0,25,3,1,7,2],
		[1591,88,24,0,0,4,57,17,1,1,4,2,7,3],
		[1592,7,23,0,4,4,59,15,0,37,53,25,6,2],
		[1593,88,24,0,0,5,1,36,0,61,4,41,7,3],
		[1594,88,24,0,0,5,2,50,0,66,49,22,7,3],
		[1595,88,24,0,0,4,57,45,1,14,13,53,7,1],
		[1596,88,24,0,0,4,58,11,1,2,12,45,7,2],
		[1597,88,24,0,0,4,54,53,1,58,32,50,7,3],
		[1598,88,24,0,0,4,53,31,1,66,40,32,7,7],
		[1599,7,24,0,5,5,0,18,0,39,23,41,7,3],
		[1600,88,24,0,0,4,58,59,0,14,32,34,7,1],
		[1601,59,15,6,10,4,58,33,0,1,42,51,5,5],
		[1602,7,24,0,6,5,0,23,0,39,39,18,8,5],
		[1603,10,1,0,10,5,3,25,0,60,26,32,5,4],
		[1604,88,24,0,0,4,59,1,1,16,22,33,7,3],
		[1605,7,4,0,7,5,1,58,0,43,49,24,4,3],
		[1606,88,24,0,0,4,53,6,1,72,24,27,7,3],
		[1607,88,24,0,0,4,59,37,1,14,48,21,9,6],
		[1608,35,24,0,63,4,59,50,1,10,15,48,6,4],
		[1609,88,24,0,0,5,0,33,0,3,36,55,8,1],
		[1610,88,24,0,0,5,0,34,0,3,36,58,8,1],
		[1611,35,24,0,64,4,59,56,1,12,32,15,6,3],
		[1612,7,5,0,8,5,2,29,0,41,4,33,5,5],
		[1613,88,24,0,0,5,0,40,1,2,3,56,7,2],
		[1614,88,24,0,0,5,0,49,1,5,45,12,7,5],
		[1615,88,24,0,0,5,3,19,0,41,26,30,7,2],
		[1616,88,24,0,0,5,31,48,0,85,56,19,8,2],
		[1617,35,22,0,65,5,1,26,1,7,10,26,6,1],
		[1618,88,24,0,0,5,1,50,0,0,43,20,7,5],
		[1619,88,24,0,0,5,2,0,0,1,36,32,7,1],
		[1620,77,8,0,102,5,3,6,0,21,35,24,6,2],
		[1621,88,24,0,0,5,1,26,1,20,3,7,6,1],
		[1622,10,24,0,11,5,6,9,0,58,58,21,6,1],
		[1623,10,24,0,12,5,6,12,0,59,1,16,7,5],
		[1624,88,24,0,0,5,6,30,0,61,10,12,7,5],
		[1625,88,24,0,0,5,2,46,1,4,12,35,7,5],
		[1626,88,24,0,0,5,4,15,0,30,29,41,7,5],
		[1627,88,24,0,0,5,4,37,0,32,19,13,8,2],
		[1628,88,24,0,0,5,2,10,1,26,16,30,6,5],
		[1629,52,6,0,0,4,55,11,1,74,56,13,6,5],
		[1630,88,24,0,0,5,6,22,0,54,24,21,8,4],
		[1631,88,24,0,0,5,1,35,1,39,43,5,7,4],
		[1632,88,24,0,0,5,4,38,0,27,41,46,8,3],
		[1633,88,24,0,0,5,4,22,0,21,16,41,7,5],
		[1634,46,24,0,1,5,2,45,1,22,47,42,7,5],
		[1635,88,24,0,0,5,2,23,1,31,46,17,7,4],
		[1636,88,24,0,0,5,9,37,0,69,38,22,7,5],
		[1637,7,24,0,9,5,6,41,0,51,35,52,6,3],
		[1638,59,24,0,11,5,4,34,0,15,24,15,6,2],
		[1639,88,24,0,0,5,6,1,0,35,56,11,8,2],
		[1640,88,24,0,0,5,3,52,1,14,22,10,7,1],
		[1641,7,6,0,10,5,6,31,0,41,14,4,4,1],
		[1642,88,24,0,0,5,5,32,0,19,48,23,7,2],
		[1643,88,24,0,0,5,12,22,0,73,56,48,6,1],
		[1644,88,24,0,0,5,6,50,0,43,10,29,7,3],
		[1645,88,24,0,0,5,3,53,1,24,23,16,7,2],
		[1646,88,24,0,0,5,4,55,1,3,2,23,7,1],
		[1647,88,24,0,0,5,9,45,0,64,55,10,7,3],
		[1648,88,24,0,0,5,5,24,0,1,10,39,7,6],
		[1649,64,6,1,0,5,2,49,1,49,9,5,6,3],
		[1650,88,24,0,0,5,14,36,0,76,28,22,7,2],
		[1651,88,24,0,0,5,3,54,1,41,44,42,7,3],
		[1652,9,2,1,0,5,4,24,1,35,29,0,6,5],
		[1653,9,2,2,0,5,4,26,1,35,42,19,7,3],
		[1654,46,4,0,2,5,5,28,1,22,22,16,4,5],
		[1655,88,24,0,0,5,5,16,1,26,9,9,7,5],
		[1656,77,24,0,104,5,7,27,0,18,38,42,6,4],
		[1657,35,24,0,66,5,6,46,1,4,39,18,6,1],
		[1658,77,24,0,106,5,7,48,0,20,25,6,6,2],
		[1659,77,24,0,103,5,8,7,0,24,15,55,7,1],
		[1660,77,24,0,105,5,7,56,0,21,42,17,7,1],
		[1661,88,24,0,0,5,6,37,1,13,7,19,7,2],
		[1662,59,24,0,13,5,7,38,0,9,28,19,7,4],
		[1663,64,6,2,0,5,4,58,1,49,34,40,6,5],
		[1664,59,24,0,14,5,7,53,0,8,29,54,6,2],
		[1665,88,24,0,0,5,7,25,1,12,29,26,7,3],
		[1666,35,1,0,67,5,7,51,1,5,5,11,4,2],
		[1667,88,24,0,0,5,5,1,1,54,24,27,7,7],
		[1668,88,24,0,0,5,10,43,0,46,57,44,7,3],
		[1669,88,24,0,0,5,10,19,0,37,18,7,7,5],
		[1670,88,24,0,0,5,9,45,0,28,1,50,7,2],
		[1671,88,24,0,0,5,8,20,1,8,39,54,7,1],
		[1672,59,24,0,16,5,9,20,0,9,49,46,6,2],
		[1673,35,24,0,68,5,8,44,1,4,27,22,6,3],
		[1674,32,5,0,0,5,5,31,1,57,28,22,6,3],
		[1675,88,24,0,0,5,13,3,0,61,51,0,7,2],
		[1676,59,24,0,15,5,9,42,0,15,35,50,6,3],
		[1677,52,1,0,0,5,2,43,1,71,18,52,6,4],
		[1678,10,24,0,14,5,13,31,0,62,41,29,8,2],
		[1679,35,10,0,69,5,9,9,1,8,45,15,5,1],
		[1680,88,24,0,0,5,8,15,1,35,43,6,8,5],
		[1681,88,24,0,0,5,10,3,1,0,33,55,7,5],
		[1682,88,24,0,0,5,0,13,1,78,18,1,7,5],
		[1683,88,24,0,0,5,18,13,0,73,16,5,7,2],
		[1684,88,24,0,0,5,11,42,0,16,2,44,6,5],
		[1685,88,24,0,0,5,10,58,1,2,15,14,7,5],
		[1686,88,24,0,0,5,22,34,0,79,13,52,6,3],
		[1687,88,24,0,0,5,11,19,1,2,29,27,7,3],
		[1688,88,24,0,0,5,15,11,0,59,24,20,7,5],
		[1689,7,11,0,11,5,13,26,0,38,29,4,6,2],
		[1690,88,24,0,0,5,11,41,0,0,30,53,8,1],
		[1691,88,24,0,0,5,11,45,0,1,2,13,7,4],
		[1692,88,24,0,0,5,14,44,0,53,12,50,7,2],
		[1693,88,24,0,0,5,11,23,1,11,50,57,7,7],
		[1694,88,24,0,0,5,10,45,1,25,54,34,7,5],
		[1695,88,24,0,0,5,7,34,1,63,23,59,6,7],
		[1696,46,8,0,3,5,12,18,1,11,52,9,5,1],
		[1697,88,24,0,0,5,12,48,1,6,3,26,7,4],
		[1698,59,16,0,17,5,13,18,0,2,51,40,5,5],
		[1699,88,24,0,0,5,11,36,1,37,23,43,8,5],
		[1700,88,24,0,0,5,6,9,1,73,2,16,7,2],
		[1701,88,24,0,0,5,13,32,0,1,58,5,7,2],
		[1702,46,11,0,5,5,12,56,1,16,12,20,4,1],
		[1703,88,24,0,0,5,13,47,0,0,33,37,7,7],
		[1704,88,24,0,0,5,13,33,1,8,8,52,7,1],
		[1705,46,9,0,4,5,13,14,1,12,56,29,5,1],
		[1706,7,24,0,14,5,15,24,0,32,41,16,6,2],
		[1707,88,24,0,0,5,17,18,0,53,35,10,8,7],
		[1708,7,0,0,13,5,16,41,0,45,59,53,1,4],
		[1709,88,24,0,0,5,14,44,0,5,9,22,7,5],
		[1710,88,24,0,0,5,13,60,1,14,36,24,7,3],
		[1711,77,24,0,108,5,15,28,0,22,17,5,7,2],
		[1712,88,24,0,0,5,16,18,0,34,18,43,7,0],
		[1713,59,1,0,19,5,14,32,1,8,12,6,1,1],
		[1714,88,24,0,0,5,43,49,0,85,40,5,8,2],
		[1715,88,24,0,0,5,13,47,1,35,49,32,8,5],
		[1716,52,13,0,0,4,58,51,1,82,28,14,7,4],
		[1717,88,24,0,0,5,15,18,1,1,24,33,7,3],
		[1718,59,24,0,18,5,16,4,0,11,20,29,7,2],
		[1719,10,24,0,15,5,19,28,0,58,7,2,7,1],
		[1720,88,24,0,0,5,20,23,0,62,39,13,7,5],
		[1721,88,24,0,0,5,14,29,1,35,58,38,7,4],
		[1722,88,24,0,0,5,18,16,0,42,47,32,6,7],
		[1723,88,24,0,0,5,15,24,1,26,56,36,6,1],
		[1724,88,24,0,0,5,16,41,0,1,56,50,7,2],
		[1725,88,24,0,0,5,18,40,0,40,27,54,7,5],
		[1726,7,24,0,16,5,18,11,0,33,22,18,6,5],
		[1727,88,24,0,0,5,13,53,1,52,1,52,7,5],
		[1728,7,24,0,17,5,18,19,0,33,46,2,7,1],
		[1729,7,10,0,15,5,19,9,0,40,5,57,6,4],
		[1730,88,24,0,0,5,15,47,1,34,55,36,8,2],
		[1731,88,24,0,0,5,16,48,1,17,8,30,8,1],
		[1732,88,24,0,0,5,19,0,0,33,44,54,6,2],
		[1733,88,24,0,0,5,20,2,0,44,25,32,8,5],
		[1734,7,24,0,18,5,19,24,0,33,59,8,7,2],
		[1735,59,18,0,20,5,17,36,1,6,50,40,5,1],
		[1736,88,24,0,0,5,20,39,0,46,57,50,8,4],
		[1737,88,24,0,0,5,17,40,1,13,31,11,7,4],
		[1738,88,24,0,0,5,20,15,0,41,5,10,7,2],
		[1739,77,24,0,109,5,19,17,0,22,5,47,6,4],
		[1740,7,24,0,19,5,20,1,0,33,57,29,6,2],
		[1741,88,24,0,0,5,19,15,0,20,8,5,7,4],
		[1742,88,24,0,0,5,15,39,1,52,10,55,7,5],
		[1743,22,14,0,0,5,17,29,1,34,53,43,6,5],
		[1744,32,7,0,0,5,13,45,1,67,11,7,6,5],
		[1745,88,24,0,0,5,29,26,0,77,58,39,8,2],
		[1746,59,24,0,21,5,19,11,0,2,35,45,6,3],
		[1747,88,24,0,0,5,18,50,1,18,7,48,7,4],
		[1748,88,24,0,0,5,19,35,1,1,24,44,7,1],
		[1749,7,16,0,20,5,21,48,0,41,48,16,6,1],
		[1750,88,24,0,0,5,20,59,0,27,57,26,7,1],
		[1751,10,24,0,16,5,23,28,0,57,32,40,6,2],
		[1752,88,24,0,0,5,21,13,0,29,34,12,7,2],
		[1753,88,24,0,0,5,19,18,1,18,31,12,7,1],
		[1754,88,24,0,0,5,19,18,1,18,30,35,8,1],
		[1755,88,24,0,0,5,20,57,0,19,48,51,7,5],
		[1756,46,10,0,6,5,19,35,1,13,10,36,5,1],
		[1757,46,12,0,7,5,19,59,1,12,18,56,6,1],
		[1758,88,24,0,0,5,19,24,1,27,22,8,7,2],
		[1759,88,24,0,0,5,20,26,1,5,22,0,7,1],
		[1760,88,24,0,0,5,22,50,0,41,1,46,7,2],
		[1761,88,24,0,0,5,21,19,0,4,0,43,8,1],
		[1762,88,24,0,0,5,20,27,1,21,14,22,6,2],
		[1763,88,24,0,0,5,21,44,0,8,25,43,7,1],
		[1764,88,24,0,0,5,21,32,1,0,24,59,7,1],
		[1765,59,24,0,22,5,21,46,1,0,22,57,6,1],
		[1766,88,24,0,0,5,20,21,1,34,41,56,7,3],
		[1767,64,5,0,0,5,19,22,1,50,36,22,6,3],
		[1768,7,24,0,22,5,23,23,0,28,56,12,7,1],
		[1769,88,24,0,0,5,21,51,1,13,45,22,8,1],
		[1770,59,24,0,23,5,22,50,0,3,32,40,6,1],
		[1771,88,24,0,0,5,21,46,1,24,46,23,6,4],
		[1772,88,24,0,0,5,21,17,1,34,20,43,7,1],
		[1773,7,17,0,21,5,24,39,0,37,23,8,6,5],
		[1774,77,24,0,110,5,23,38,0,16,41,58,7,2],
		[1775,88,24,0,0,5,24,38,0,31,13,26,7,5],
		[1776,88,24,0,0,5,24,39,0,31,8,35,7,1],
		[1777,88,24,0,0,5,23,31,0,5,19,21,7,2],
		[1778,88,24,0,0,5,23,19,1,8,24,57,7,1],
		[1779,88,24,0,0,5,25,13,0,34,51,19,8,5],
		[1780,77,24,0,111,5,24,25,0,17,23,0,6,3],
		[1781,88,24,0,0,5,23,42,1,0,9,35,7,1],
		[1782,88,24,0,0,5,23,51,1,0,52,2,7,3],
		[1783,46,24,0,8,5,23,30,1,13,55,38,6,1],
		[1784,59,24,0,29,5,23,57,1,7,48,29,5,4],
		[1785,88,24,0,0,5,23,12,1,26,42,21,7,3],
		[1786,88,24,0,0,5,24,36,0,2,21,10,7,1],
		[1787,59,24,0,27,5,24,29,1,0,53,29,6,4],
		[1788,59,6,0,28,5,24,29,1,2,23,49,4,1],
		[1789,59,22,1,25,5,24,45,0,1,50,47,6,1],
		[1790,59,2,0,24,5,25,8,0,6,20,59,3,1],
		[1791,77,1,0,112,5,26,18,0,28,36,27,3,1],
		[1792,88,24,0,0,5,24,28,1,16,58,34,7,2],
		[1793,88,24,0,0,5,23,24,1,39,40,43,7,7],
		[1794,88,24,0,0,5,26,54,0,35,27,26,7,5],
		[1795,88,24,0,0,5,26,49,0,34,23,30,7,2],
		[1796,88,24,0,0,5,26,51,0,33,15,46,7,5],
		[1797,88,24,0,0,5,23,39,1,37,20,12,8,5],
		[1798,77,24,0,113,5,26,6,0,16,42,1,7,1],
		[1799,88,24,0,0,5,25,2,1,10,19,45,7,5],
		[1800,88,24,0,0,5,25,31,1,0,32,39,8,1],
		[1801,64,9,0,0,5,22,22,1,56,8,4,7,1],
		[1802,10,24,0,17,5,30,10,0,63,4,2,6,7],
		[1803,88,24,0,0,5,25,47,0,0,31,15,7,1],
		[1804,88,24,0,0,5,27,8,0,30,12,31,7,1],
		[1805,7,20,0,24,5,27,39,0,34,28,33,6,5],
		[1806,88,24,0,0,5,26,2,1,5,31,6,7,1],
		[1807,88,24,0,0,5,26,39,0,6,52,9,7,2],
		[1808,77,24,0,115,5,27,10,0,17,57,44,6,1],
		[1809,88,24,0,0,5,27,14,0,15,15,28,7,2],
		[1810,77,24,0,114,5,27,38,0,21,56,13,6,1],
		[1811,59,22,2,30,5,26,50,0,3,5,44,6,1],
		[1812,88,24,0,0,5,25,60,1,19,41,44,7,3],
		[1813,88,24,0,0,5,24,56,1,44,13,33,7,5],
		[1814,77,24,0,116,5,27,46,0,15,52,27,7,1],
		[1815,88,24,0,0,5,12,26,1,81,32,30,8,5],
		[1816,77,24,0,117,5,28,2,0,17,14,20,7,7],
		[1817,88,24,0,0,5,27,5,1,11,54,3,7,3],
		[1818,64,7,0,0,5,24,46,1,52,18,59,7,2],
		[1819,88,24,0,0,5,28,35,0,13,40,44,7,2],
		[1820,88,24,0,0,5,28,2,0,1,17,54,7,1],
		[1821,77,24,0,118,5,29,17,0,25,9,2,6,1],
		[1822,88,24,0,0,5,29,41,0,29,11,11,7,3],
		[1823,88,24,0,0,5,27,37,1,21,22,32,7,4],
		[1824,88,24,0,0,5,30,49,0,41,27,43,7,5],
		[1825,88,24,0,0,5,30,45,0,39,49,33,7,4],
		[1826,88,24,0,0,5,28,57,1,3,18,27,7,2],
		[1827,88,24,0,0,5,27,5,1,40,56,37,7,2],
		[1828,10,24,0,18,5,32,34,0,57,13,16,7,3],
		[1829,46,1,0,9,5,28,15,1,20,45,34,4,4],
		[1830,88,24,0,0,5,29,24,1,3,26,47,7,5],
		[1831,88,24,0,0,5,30,43,0,22,27,45,7,5],
		[1832,88,24,0,0,5,30,26,0,15,21,37,7,2],
		[1833,88,24,0,0,5,29,55,0,1,47,21,7,1],
		[1834,59,24,0,31,5,29,44,1,1,5,32,6,5],
		[1835,88,24,0,0,5,28,15,1,37,13,50,7,2],
		[1836,32,10,0,0,5,26,19,1,58,54,45,6,4],
		[1837,88,24,0,0,5,30,20,0,4,12,15,7,5],
		[1838,88,24,0,0,5,29,7,1,30,7,0,8,4],
		[1839,59,24,0,32,5,30,47,0,5,56,53,5,1],
		[1840,88,24,0,0,5,30,21,1,7,26,5,7,1],
		[1842,59,24,0,33,5,31,15,0,3,17,32,6,1],
		[1843,7,21,0,25,5,32,44,0,32,11,31,6,1],
		[1844,88,24,0,0,5,39,44,0,75,2,38,7,7],
		[1845,77,24,0,119,5,32,13,0,18,35,40,5,7],
		[1846,88,24,0,0,5,33,29,0,42,6,32,8,1],
		[1847,88,24,0,0,5,32,14,0,17,3,29,6,1],
		[1848,88,24,0,0,5,31,21,1,6,42,30,7,1],
		[1849,46,24,0,10,5,31,8,1,20,51,49,7,2],
		[1850,88,24,0,0,5,33,28,0,32,48,4,7,2],
		[1851,59,3,0,34,5,32,1,1,0,17,4,8,1],
		[1852,59,3,0,34,5,32,0,1,0,17,57,3,0],
		[1853,88,24,0,0,5,37,16,0,66,41,46,7,2],
		[1854,88,24,0,0,5,33,38,0,34,43,33,7,2],
		[1855,59,19,0,36,5,31,56,1,7,18,5,6,1],
		[1856,88,24,0,0,5,30,10,1,47,4,40,6,4],
		[1857,10,24,0,19,5,37,15,0,64,9,17,7,2],
		[1858,77,24,0,120,5,33,32,0,18,32,25,7,1],
		[1859,88,24,0,0,5,27,0,1,68,37,22,7,3],
		[1860,88,24,0,0,5,33,39,0,20,28,27,7,1],
		[1861,88,24,0,0,5,32,41,1,1,35,31,6,1],
		[1862,22,4,0,0,5,31,13,1,35,28,14,5,5],
		[1863,88,24,0,0,5,33,7,1,1,43,6,7,1],
		[1864,59,24,0,35,5,33,54,0,14,18,20,7,1],
		[1865,46,0,0,11,5,32,44,1,17,49,20,4,3],
		[1866,88,24,0,0,5,36,35,0,54,25,44,7,7],
		[1867,88,24,0,0,5,29,17,1,62,18,52,8,5],
		[1868,88,24,0,0,5,33,31,1,1,9,22,6,1],
		[1869,88,24,0,0,5,36,16,0,47,42,55,7,3],
		[1870,88,24,0,0,5,31,36,1,45,55,31,7,5],
		[1871,88,24,0,0,5,33,58,0,1,24,28,8,1],
		[1872,59,24,0,38,5,34,17,0,3,46,1,6,2],
		[1873,88,24,0,0,5,34,4,1,1,2,8,7,1],
		[1874,88,24,0,0,5,34,4,1,1,28,14,7,5],
		[1875,77,24,0,121,5,35,27,0,24,2,22,6,1],
		[1876,59,20,1,37,5,34,49,0,9,29,22,5,1],
		[1877,88,24,0,0,5,32,51,1,38,30,47,6,5],
		[1878,88,24,0,0,5,35,56,0,27,39,44,7,5],
		[1879,59,10,0,39,5,35,8,0,9,56,3,5,0],
		[1880,59,10,0,39,5,35,9,0,9,56,6,7,1],
		[1881,88,24,0,0,5,33,7,1,35,8,23,7,5],
		[1882,88,24,0,0,5,30,16,1,63,55,40,7,3],
		[1883,88,24,0,0,5,35,13,0,10,14,24,7,1],
		[1884,88,24,0,0,5,36,52,0,40,10,56,7,4],
		[1885,88,24,0,0,6,1,20,0,85,10,56,7,7],
		[1886,88,24,0,0,5,35,1,1,6,0,33,7,1],
		[1887,88,24,0,0,5,35,3,1,6,0,7,6,1],
		[1888,88,24,0,0,5,33,52,1,29,50,56,8,2],
		[1889,88,24,0,0,5,36,30,0,25,56,22,7,3],
		[1890,88,24,0,0,5,35,22,1,4,29,36,8,1],
		[1891,88,24,0,0,5,35,23,1,4,25,31,7,1],
		[1892,59,24,0,42,5,35,23,1,4,50,18,6,1],
		[1893,59,7,1,41,5,35,16,1,5,23,14,8,1],
		[1894,59,7,1,41,5,35,16,1,5,23,7,9,1],
		[1895,59,7,1,41,5,35,17,1,5,23,23,6,0],
		[1896,59,7,1,41,5,35,17,1,5,23,16,8,1],
		[1897,59,7,2,43,5,35,23,1,5,24,58,6,0],
		[1898,88,24,0,0,5,35,31,1,4,21,53,7,1],
		[1899,59,8,0,44,5,35,26,1,5,54,36,4,0],
		[1900,88,24,0,0,5,35,36,1,3,15,10,7,1],
		[1901,59,24,0,45,5,35,40,1,4,51,21,6,3],
		[1902,88,24,0,0,5,37,9,0,26,55,27,7,1],
		[1903,59,4,0,46,5,36,13,1,1,12,7,3,1],
		[1904,88,24,0,0,5,37,46,0,33,33,33,7,5],
		[1905,77,24,0,122,5,37,4,0,17,2,25,7,3],
		[1906,88,24,0,0,5,36,15,1,5,38,53,8,1],
		[1907,59,20,2,40,5,36,54,0,9,17,26,5,5],
		[1908,88,24,0,0,5,37,4,0,11,2,6,7,5],
		[1909,88,24,0,0,5,35,15,1,33,4,48,7,5],
		[1910,77,5,0,123,5,37,39,0,21,8,33,4,1],
		[1911,88,24,0,0,5,36,36,1,6,3,54,7,1],
		[1912,88,24,0,0,5,33,44,1,54,54,8,7,3],
		[1913,88,24,0,0,5,37,19,0,8,57,7,7,1],
		[1914,7,24,0,26,5,38,38,0,30,29,33,6,3],
		[1915,88,24,0,0,5,36,10,1,28,42,28,7,2],
		[1916,88,24,0,0,5,42,26,0,65,41,52,7,5],
		[1917,88,24,0,0,5,32,60,1,64,13,39,6,4],
		[1918,88,24,0,0,5,37,27,1,5,56,18,7,1],
		[1919,88,24,0,0,5,37,9,1,11,46,32,7,2],
		[1920,88,24,0,0,5,38,1,0,7,32,29,7,1],
		[1921,88,24,0,0,5,38,57,0,26,37,4,7,4],
		[1922,32,1,0,0,5,33,38,1,62,29,23,5,3],
		[1923,88,24,0,0,5,37,53,1,4,48,49,7,1],
		[1924,88,24,0,0,5,39,18,0,29,12,55,7,1],
		[1925,88,24,0,0,5,41,20,0,53,28,52,7,5],
		[1926,22,12,1,0,5,37,17,1,27,52,17,7,3],
		[1927,88,24,0,0,5,36,3,1,47,18,50,7,5],
		[1928,77,24,0,125,5,39,44,0,25,53,49,6,1],
		[1929,88,24,0,0,5,39,27,0,21,45,46,7,2],
		[1930,88,24,0,0,5,35,2,1,58,52,16,8,5],
		[1931,59,17,0,48,5,38,45,1,2,36,0,5,0],
		[1932,88,24,0,0,5,38,47,1,2,35,39,8,1],
		[1933,88,24,0,0,5,38,38,1,6,34,26,7,1],
		[1934,59,23,0,47,5,39,11,0,4,7,17,6,1],
		[1935,22,12,2,0,5,37,45,1,28,41,22,6,3],
		[1936,88,24,0,0,5,34,58,1,61,10,33,7,4],
		[1937,59,24,0,49,5,38,53,1,7,12,47,6,2],
		[1938,88,24,0,0,5,40,36,0,31,21,29,7,1],
		[1939,88,24,0,0,5,40,42,0,31,55,15,7,7],
		[1940,88,24,0,0,5,39,31,1,3,33,53,7,2],
		[1941,10,24,0,24,5,43,2,0,56,34,54,7,5],
		[1942,88,24,0,0,5,39,31,1,9,42,24,8,1],
		[1943,10,24,0,23,5,44,9,0,61,28,36,7,4],
		[1944,88,24,0,0,5,39,16,1,17,50,58,7,1],
		[1945,88,24,0,0,5,41,21,0,29,29,15,7,1],
		[1946,77,24,0,126,5,41,18,0,16,32,2,6,1],
		[1947,88,24,0,0,5,38,44,1,40,42,27,7,1],
		[1948,59,5,0,50,5,40,46,1,1,56,34,3,0],
		[1949,59,5,0,50,5,40,46,1,1,56,34,5,1],
		[1950,88,24,0,0,5,40,37,1,2,49,30,7,1],
		[1951,88,24,0,0,5,41,55,0,23,19,35,8,1],
		[1952,88,24,0,0,5,40,51,1,1,7,44,6,1],
		[1953,52,2,0,0,5,31,53,1,76,20,28,6,5],
		[1954,88,24,0,0,5,42,4,0,22,39,37,7,5],
		[1955,88,24,0,0,5,41,6,0,0,20,16,7,3],
		[1956,22,0,0,0,5,39,39,1,34,4,27,4,1],
		[1957,88,24,0,0,5,40,46,1,10,24,34,8,1],
		[1958,88,24,0,0,5,39,50,1,32,37,45,6,4],
		[1959,88,24,0,0,5,41,40,1,2,53,46,7,2],
		[1960,88,24,0,0,5,36,55,1,66,33,37,7,1],
		[1961,88,24,0,0,5,43,20,0,23,12,15,7,1],
		[1962,88,24,0,0,5,41,42,1,16,43,32,7,1],
		[1963,59,24,0,51,5,42,29,0,1,28,29,6,5],
		[1964,88,24,0,0,5,34,45,1,73,44,29,7,7],
		[1965,88,24,0,0,5,42,14,1,17,31,49,7,5],
		[1966,88,24,0,0,5,41,27,1,33,24,2,7,2],
		[1967,88,24,0,0,5,42,54,1,6,47,46,7,3],
		[1968,46,24,0,12,5,42,14,1,22,22,25,7,2],
		[1969,10,24,0,26,5,46,30,0,56,6,56,7,2],
		[1970,88,24,0,0,5,43,9,1,1,36,47,7,5],
		[1971,7,14,0,27,5,45,54,0,49,49,35,6,2],
		[1972,88,24,0,0,5,42,12,1,30,32,8,7,2],
		[1973,88,24,0,0,5,42,15,1,34,40,4,6,1],
		[1974,88,24,0,0,5,45,50,0,40,30,26,8,2],
		[1975,88,24,0,0,5,43,22,1,18,33,27,7,2],
		[1976,88,24,0,0,5,49,5,0,62,48,29,7,2],
		[1977,88,24,0,0,5,45,39,0,20,41,42,8,6],
		[1978,88,24,0,0,5,45,2,0,4,0,29,7,3],
		[1979,88,24,0,0,5,47,15,0,42,31,36,7,5],
		[1980,88,24,0,0,5,44,28,1,20,7,35,7,4],
		[1981,88,24,0,0,5,43,30,1,39,24,25,7,3],
		[1982,88,24,0,0,5,44,27,1,22,25,18,7,5],
		[1983,46,2,0,13,5,44,28,1,22,26,54,5,3],
		[1984,88,24,0,0,5,43,41,1,45,49,59,7,2],
		[1985,77,24,0,129,5,46,46,0,15,49,21,7,1],
		[1986,88,24,0,0,5,46,3,1,4,16,6,7,5],
		[1987,88,24,0,0,5,46,52,0,9,31,20,7,4],
		[1988,88,24,0,0,5,46,35,0,1,10,5,7,4],
		[1989,77,24,0,131,5,47,13,0,14,29,18,7,2],
		[1990,77,24,0,130,5,47,26,0,17,43,45,6,3],
		[1991,52,8,0,0,5,35,36,1,78,49,15,7,1],
		[1992,10,24,0,29,5,50,34,0,56,55,8,8,2],
		[1993,77,24,0,133,5,47,43,0,13,53,59,6,1],
		[1994,88,24,0,0,5,52,56,0,68,28,17,7,4],
		[1995,7,18,0,29,5,49,11,0,39,10,52,6,4],
		[1996,22,11,0,0,5,45,60,1,32,18,23,6,0],
		[1997,88,24,0,0,5,48,22,0,20,52,10,7,1],
		[1998,46,5,0,14,5,46,57,1,14,49,19,5,2],
		[1999,59,24,0,52,5,48,0,0,6,27,15,6,2],
		[2000,88,24,0,0,5,47,8,1,16,14,16,7,4],
		[2001,88,24,0,0,5,47,27,1,10,31,59,7,2],
		[2002,77,24,0,132,5,49,1,0,24,34,3,6,4],
		[2003,88,24,0,0,5,50,56,0,51,30,53,7,5],
		[2004,59,9,0,53,5,47,45,1,9,40,11,3,1],
		[2005,88,24,0,0,5,47,5,1,28,38,21,7,1],
		[2006,10,24,0,30,5,52,17,0,58,57,51,7,2],
		[2007,88,24,0,0,5,48,35,1,4,5,41,7,4],
		[2008,88,24,0,0,5,46,27,1,46,35,50,6,5],
		[2009,88,24,0,0,5,47,19,1,35,40,29,7,5],
		[2010,77,24,0,134,5,49,33,0,12,39,4,6,1],
		[2011,7,19,0,31,5,51,2,0,37,18,20,6,7],
		[2012,7,12,0,32,5,51,29,0,39,8,55,5,4],
		[2013,88,24,0,0,5,50,58,0,27,58,4,7,4],
		[2014,88,24,0,0,5,50,3,0,9,52,16,7,4],
		[2015,32,3,0,0,5,44,46,1,65,44,8,5,2],
		[2016,77,24,0,135,5,50,29,0,14,18,20,7,4],
		[2017,88,24,0,0,5,47,58,1,40,39,9,8,5],
		[2018,88,24,0,0,5,51,26,0,32,7,30,7,7],
		[2019,88,24,0,0,5,50,13,0,4,25,24,7,5],
		[2020,64,1,0,0,5,47,17,1,51,3,59,5,2],
		[2021,88,24,0,0,5,49,37,1,14,29,1,6,4],
		[2022,52,15,0,0,5,37,10,1,80,28,9,7,4],
		[2023,88,24,0,0,5,47,13,1,54,21,39,7,5],
		[2024,88,24,0,0,5,50,30,0,2,1,28,7,4],
		[2025,88,24,0,0,5,52,40,0,39,34,28,7,2],
		[2026,88,24,0,0,5,49,54,1,22,58,18,7,2],
		[2027,10,24,0,31,5,54,58,0,59,53,18,6,2],
		[2028,88,24,0,0,5,52,40,0,33,55,3,7,7],
		[2029,7,13,0,30,5,54,51,0,55,42,25,6,2],
		[2030,88,24,0,0,5,52,23,0,19,52,5,7,4],
		[2031,59,24,0,55,5,51,22,1,7,31,5,6,1],
		[2032,88,24,0,0,5,49,34,1,44,52,31,7,5],
		[2033,77,24,0,137,5,52,22,0,14,10,18,7,1],
		[2034,77,24,0,136,5,53,20,0,27,36,44,6,2],
		[2035,46,3,0,15,5,51,19,1,20,52,45,5,5],
		[2036,88,24,0,0,5,51,29,1,22,55,34,7,5],
		[2037,59,24,0,56,5,52,26,0,1,51,18,6,5],
		[2038,88,24,0,0,5,53,19,0,20,17,57,8,1],
		[2039,88,24,0,0,5,52,8,1,9,2,29,7,2],
		[2040,22,1,0,0,5,50,58,1,35,46,6,4,5],
		[2041,88,24,0,0,5,57,35,0,66,5,46,7,5],
		[2042,64,2,0,0,5,49,50,1,56,10,0,6,5],
		[2043,88,24,0,0,5,51,60,1,29,26,55,7,5],
		[2044,88,24,0,0,5,50,29,1,52,46,4,7,5],
		[2045,88,24,0,0,5,56,14,0,51,48,14,7,2],
		[2046,88,24,0,0,5,54,59,0,31,42,6,7,2],
		[2047,59,21,1,54,5,54,23,0,20,16,34,5,4],
		[2048,88,24,0,0,5,54,13,0,10,35,13,7,4],
		[2049,88,24,0,0,5,50,53,1,52,6,32,6,4],
		[2050,88,24,0,0,5,54,32,0,11,45,45,8,2],
		[2051,88,24,0,0,5,54,16,0,3,13,31,7,5],
		[2052,59,24,0,57,5,54,57,0,19,44,59,7,1],
		[2053,88,24,0,0,5,52,33,1,37,37,52,7,5],
		[2054,88,24,0,0,5,57,5,0,49,1,46,7,4],
		[2055,88,24,0,0,5,52,48,1,38,31,33,8,5],
		[2056,22,10,0,0,5,53,7,1,33,48,5,6,1],
		[2057,88,24,0,0,5,54,44,0,0,58,6,7,5],
		[2058,88,24,0,0,5,54,35,1,4,3,50,8,1],
		[2059,88,24,0,0,5,30,14,1,84,47,6,7,1],
		[2060,88,24,0,0,5,53,57,1,19,38,18,8,2],
		[2061,59,0,0,58,5,55,10,0,7,24,25,2,7],
		[2062,52,10,0,0,5,47,48,1,72,42,8,8,5],
		[2063,88,24,0,0,5,55,49,0,20,10,30,6,7],
		[2064,32,4,0,0,5,49,54,1,66,54,4,6,1],
		[2065,88,24,0,0,5,54,44,1,11,46,26,7,5],
		[2066,88,24,0,0,5,56,34,0,28,56,32,7,2],
		[2067,88,24,0,0,5,56,4,0,13,55,31,8,4],
		[2068,88,24,0,0,5,54,14,1,29,8,52,7,3],
		[2069,88,24,0,0,5,53,23,1,42,55,17,8,5],
		[2070,88,24,0,0,5,55,30,1,4,36,59,7,5],
		[2071,88,24,0,0,5,55,35,1,4,47,18,7,2],
		[2072,88,24,0,0,5,52,20,1,57,9,22,7,3],
		[2073,88,24,0,0,5,51,23,1,64,2,1,7,4],
		[2074,88,24,0,0,5,56,56,0,24,14,59,7,2],
		[2075,88,24,0,0,5,56,28,0,9,30,35,7,2],
		[2076,88,24,0,0,5,56,50,0,11,31,16,7,5],
		[2077,7,3,0,33,5,59,32,0,54,17,5,5,5],
		[2078,88,24,0,0,6,5,9,0,75,35,9,7,5],
		[2079,88,24,0,0,5,59,46,0,55,19,15,7,2],
		[2080,88,24,0,0,5,59,48,0,54,32,50,7,5],
		[2081,88,24,0,0,5,59,22,0,49,55,28,7,4],
		[2082,88,24,0,0,5,54,53,1,39,57,29,7,7],
		[2083,88,24,0,0,5,54,11,1,50,21,43,8,4],
		[2084,77,24,0,139,5,57,60,0,25,57,14,6,1],
		[2085,46,6,0,16,5,56,24,1,14,10,4,5,3],
		[2086,88,24,0,0,5,56,14,1,22,50,25,7,5],
		[2087,22,13,0,0,5,55,30,1,37,7,15,6,5],
		[2088,7,1,0,34,5,59,32,0,44,56,51,3,2],
		[2089,88,24,0,0,5,54,41,1,49,37,37,7,1],
		[2090,88,24,0,0,5,56,35,1,23,12,56,7,5],
		[2091,7,15,0,35,5,59,56,0,45,56,13,5,7],
		[2092,22,17,0,0,5,56,21,1,31,22,57,7,3],
		[2093,88,24,0,0,5,57,54,0,1,13,28,7,7],
		[2094,88,24,0,0,5,54,50,1,52,38,7,6,3],
		[2095,7,7,0,37,5,59,43,0,37,12,45,4,2],
		[2096,88,24,0,0,6,0,19,0,44,35,31,7,5],
		[2097,88,24,0,0,5,58,12,1,0,59,39,7,5],
		[2098,88,24,0,0,5,56,49,1,31,58,34,7,4],
		[2099,88,24,0,0,5,58,53,0,12,48,31,7,5],
		[2100,59,24,0,59,5,58,24,0,1,50,13,7,2],
		[2101,7,24,0,36,6,0,59,0,47,54,7,7,1],
		[2102,88,24,0,0,5,54,6,1,63,5,24,6,5],
		[2103,59,24,0,60,5,58,50,0,0,33,11,6,2],
		[2104,88,24,0,0,5,54,12,1,64,28,56,8,3],
		[2105,88,24,0,0,6,1,43,0,48,57,34,7,5],
		[2106,22,2,0,0,5,57,32,1,35,17,0,5,1],
		[2107,54,24,0,1,5,59,1,1,9,22,56,7,3],
		[2108,54,24,0,2,5,59,4,1,9,33,30,6,2],
		[2109,88,24,0,0,5,59,38,1,1,26,40,8,1],
		[2110,88,24,0,0,6,1,10,0,31,2,5,7,2],
		[2111,88,24,0,0,6,1,0,0,27,34,20,7,1],
		[2112,88,24,0,0,6,2,49,0,49,54,20,7,1],
		[2113,88,24,0,0,6,0,3,1,3,4,27,6,5],
		[2114,88,24,0,0,5,57,14,1,53,25,34,7,5],
		[2115,88,24,0,0,6,2,54,0,43,22,43,7,5],
		[2116,88,24,0,0,6,1,42,0,22,24,3,7,1],
		[2117,88,24,0,0,5,58,38,1,44,2,4,7,4],
		[2118,88,24,0,0,6,0,18,1,12,53,59,7,3],
		[2119,7,24,0,38,6,3,18,0,42,54,42,7,5],
		[2120,22,6,0,0,5,59,9,1,42,48,55,5,5],
		[2121,88,24,0,0,6,5,8,0,59,23,35,7,5],
		[2122,88,24,0,0,6,2,55,0,32,38,9,7,3],
		[2123,88,24,0,0,6,4,29,0,51,34,24,7,2],
		[2124,59,11,0,61,6,2,23,0,9,38,51,5,2],
		[2125,52,9,0,0,5,50,17,1,79,21,41,6,1],
		[2126,88,24,0,0,6,6,39,0,63,27,13,7,5],
		[2127,88,24,0,0,6,2,17,0,1,41,40,8,1],
		[2128,54,24,0,3,6,1,50,1,10,35,53,6,1],
		[2129,88,24,0,0,6,1,13,1,25,25,4,7,2],
		[2130,59,24,0,64,6,3,27,0,19,41,26,6,1],
		[2131,88,24,0,0,6,1,16,1,33,54,42,7,5],
		[2132,7,24,0,39,6,5,3,0,42,58,54,7,3],
		[2133,88,24,0,0,6,3,25,0,11,40,51,7,2],
		[2134,37,24,0,1,6,4,7,0,23,15,48,5,4],
		[2135,59,21,2,62,6,3,55,0,20,8,18,6,1],
		[2136,88,24,0,0,6,2,34,1,14,29,50,7,4],
		[2137,88,24,0,0,6,5,3,0,37,57,51,7,5],
		[2138,88,24,0,0,6,0,49,1,51,12,59,7,2],
		[2139,88,24,0,0,6,5,34,0,33,35,57,7,1],
		[2140,88,24,0,0,6,3,16,1,26,17,4,6,5],
		[2141,88,24,0,0,6,6,9,0,35,23,15,7,4],
		[2142,88,24,0,0,6,4,14,1,6,42,33,6,1],
		[2143,7,24,0,40,6,6,35,0,38,28,58,6,2],
		[2144,59,24,0,63,6,4,58,0,5,25,12,7,4],
		[2145,59,24,0,66,6,4,58,0,4,9,31,7,4],
		[2146,88,24,0,0,6,6,23,0,29,30,45,7,7],
		[2147,88,24,0,0,6,7,27,0,41,51,15,7,5],
		[2148,46,24,0,17,6,4,59,1,16,29,4,6,2],
		[2149,88,24,0,0,6,4,20,1,32,10,21,7,1],
		[2150,88,24,0,0,6,5,27,1,10,14,34,7,3],
		[2151,88,24,0,0,6,2,9,1,60,5,49,7,7],
		[2152,10,24,0,37,6,9,59,0,58,56,9,6,4],
		[2153,88,24,0,0,6,8,23,0,41,3,20,7,4],
		[2154,88,24,0,0,6,6,39,1,4,11,38,6,1],
		[2155,46,7,0,18,6,6,9,1,14,56,7,6,2],
		[2156,88,24,0,0,6,5,46,1,24,11,44,8,7],
		[2157,88,24,0,0,6,4,28,1,45,2,12,7,4],
		[2158,88,24,0,0,6,4,40,1,45,4,44,7,3],
		[2159,59,12,0,67,6,7,34,0,14,46,6,5,1],
		[2160,88,24,0,0,6,5,27,1,35,30,49,7,2],
		[2161,88,24,0,0,6,6,52,1,11,10,25,8,1],
		[2162,88,24,0,0,6,4,47,1,48,27,31,8,4],
		[2163,88,24,0,0,6,6,32,1,23,6,38,6,2],
		[2164,88,24,0,0,6,6,6,1,29,45,31,7,2],
		[2165,10,24,0,36,6,12,51,0,65,43,6,6,5],
		[2166,88,24,0,0,6,6,58,1,21,48,46,7,7],
		[2167,88,24,0,0,6,8,47,0,8,40,12,8,1],
		[2168,46,24,0,19,6,7,42,1,19,9,57,6,7],
		[2169,88,24,0,0,6,9,32,0,22,11,24,7,5],
		[2170,88,24,0,0,6,7,4,1,34,18,43,7,1],
		[2171,22,15,1,0,6,6,41,1,42,17,55,7,2],
		[2172,88,24,0,0,6,11,46,0,52,38,50,7,2],
		[2173,37,24,0,3,6,9,44,0,23,6,48,7,1],
		[2174,88,24,0,0,6,8,58,0,2,29,58,7,2],
		[2175,7,24,0,41,6,11,37,0,48,42,47,8,2],
		[2176,7,24,0,41,6,11,37,0,48,42,40,7,2],
		[2177,22,7,0,0,6,7,32,1,37,15,11,6,1],
		[2178,88,24,0,0,6,7,2,1,45,5,29,8,5],
		[2179,88,24,0,0,6,9,36,1,5,42,40,7,3],
		[2180,88,24,0,0,6,8,58,1,22,25,39,7,2],
		[2181,22,15,2,0,6,7,53,1,42,9,14,7,2],
		[2182,88,24,0,0,6,9,20,1,18,7,34,7,1],
		[2183,88,24,0,0,6,9,34,1,14,35,3,7,5],
		[2184,88,24,0,0,6,11,2,0,18,7,46,7,5],
		[2185,37,24,0,5,6,11,32,0,24,25,13,7,5],
		[2186,88,24,0,0,6,9,48,1,22,46,27,7,3],
		[2187,88,24,0,0,6,8,35,1,44,21,22,7,1],
		[2188,88,24,0,0,6,13,45,0,51,10,21,7,5],
		[2189,88,24,0,0,6,12,20,0,32,41,36,7,7],
		[2190,88,24,0,0,6,11,51,0,21,52,7,8,7],
		[2191,88,24,0,0,6,11,28,0,13,38,19,7,2],
		[2192,88,24,0,0,6,9,47,1,26,42,3,7,4],
		[2193,59,24,0,68,6,12,1,0,19,47,26,7,1],
		[2194,32,6,1,0,6,6,9,1,66,2,23,7,2],
		[2195,88,24,0,0,6,11,1,1,6,45,15,7,2],
		[2196,88,24,0,0,6,7,3,1,62,9,17,6,5],
		[2197,37,24,0,6,6,12,19,0,22,54,30,7,7],
		[2198,59,24,0,69,6,12,3,0,16,7,50,6,1],
		[2199,59,13,0,70,6,11,56,0,14,12,32,5,1],
		[2200,88,24,0,0,6,10,35,1,27,9,15,7,5],
		[2201,10,24,0,40,6,15,41,0,59,59,57,6,5],
		[2202,88,24,0,0,6,11,44,1,4,39,56,7,1],
		[2203,88,24,0,0,6,10,10,1,40,21,13,7,7],
		[2204,88,24,0,0,6,9,23,1,49,33,46,7,3],
		[2205,88,24,0,0,6,11,52,1,6,33,1,6,1],
		[2206,88,24,0,0,6,11,14,1,26,28,56,7,2],
		[2207,88,24,0,0,6,13,33,0,18,40,49,8,1],
		[2208,88,24,0,0,6,13,13,0,10,37,39,7,4],
		[2209,88,24,0,0,6,18,51,0,69,19,11,6,2],
		[2210,88,24,0,0,6,12,44,1,2,30,16,8,2],
		[2211,88,24,0,0,6,10,40,1,45,16,55,7,2],
		[2212,64,3,0,0,6,10,18,1,54,58,7,6,1],
		[2213,88,24,0,0,6,12,46,1,17,45,47,8,1],
		[2214,88,24,0,0,6,14,29,0,17,54,23,7,2],
		[2215,50,24,0,1,6,17,55,0,61,30,55,6,7],
		[2216,37,6,0,7,6,14,53,0,22,30,24,4,7],
		[2217,88,24,0,0,6,15,39,0,36,8,55,8,3],
		[2218,88,24,0,0,6,13,54,1,3,44,29,7,4],
		[2219,7,9,0,44,6,15,23,0,29,29,53,5,4],
		[2220,59,24,0,71,6,14,51,0,19,9,23,6,3],
		[2221,32,12,0,0,6,8,44,1,68,50,36,6,1],
		[2222,88,24,0,0,6,15,9,0,13,51,4,7,1],
		[2223,59,24,0,72,6,15,25,0,16,8,35,6,1],
		[2224,88,24,0,0,6,14,37,1,4,34,6,7,1],
		[2225,88,24,0,0,6,13,45,1,23,51,43,7,4],
		[2226,88,24,0,0,6,13,33,1,29,23,46,8,1],
		[2227,54,2,0,5,6,14,51,1,6,16,29,5,5],
		[2228,7,24,0,42,6,17,35,0,46,25,27,8,3],
		[2229,59,24,0,73,6,15,45,0,12,33,4,6,1],
		[2230,37,24,0,8,6,16,19,0,23,58,12,7,4],
		[2231,88,24,0,0,6,15,40,0,6,3,58,7,1],
		[2232,88,24,0,0,6,15,47,0,4,17,1,8,1],
		[2233,88,24,0,0,6,15,34,1,0,30,44,7,3],
		[2234,88,24,0,0,6,15,30,1,4,54,55,7,2],
		[2235,88,24,0,0,6,16,24,0,17,10,53,7,5],
		[2236,88,24,0,0,6,15,54,0,1,10,9,7,3],
		[2237,88,24,0,0,6,15,26,1,9,2,7,7,1],
		[2238,50,24,0,2,6,19,37,0,59,0,39,5,2],
		[2239,7,24,0,43,6,18,17,0,46,21,38,7,5],
		[2240,37,24,0,9,6,16,59,0,23,44,27,7,1],
		[2241,59,24,0,74,6,16,27,0,12,16,20,6,3],
		[2242,88,24,0,0,6,15,8,1,20,16,20,7,5],
		[2243,88,24,0,0,6,15,18,1,18,28,36,7,5],
		[2244,88,24,0,0,6,15,45,1,13,43,6,6,1],
		[2245,32,6,2,0,6,11,15,1,65,35,22,6,7],
		[2246,88,24,0,0,6,16,21,0,1,4,49,8,1],
		[2247,59,24,0,75,6,17,7,0,9,56,33,6,2],
		[2248,88,24,0,0,6,16,58,0,7,3,11,8,1],
		[2249,88,24,0,0,6,16,8,1,16,37,4,7,1],
		[2250,88,24,0,0,6,17,33,0,14,3,30,8,2],
		[2251,88,24,0,0,6,17,16,0,5,6,1,7,3],
		[2252,88,24,0,0,6,15,57,1,29,47,18,8,5],
		[2253,88,24,0,0,6,18,6,0,14,22,58,7,2],
		[2254,88,24,0,0,6,17,4,1,22,42,54,7,4],
		[2255,54,24,0,6,6,17,35,1,10,43,31,8,3],
		[2256,22,9,0,0,6,16,33,1,35,8,26,5,5],
		[2257,50,24,0,4,6,22,4,0,59,22,20,7,2],
		[2258,88,24,0,0,6,19,2,0,17,19,30,7,1],
		[2259,88,24,0,0,6,18,41,0,9,2,50,7,5],
		[2260,88,24,0,0,6,17,42,1,16,48,57,6,5],
		[2261,52,0,0,0,6,10,14,1,74,45,11,6,4],
		[2262,88,24,0,0,6,16,36,1,39,15,52,7,2],
		[2263,88,24,0,0,6,17,1,1,37,44,15,7,5],
		[2264,7,24,0,45,6,21,46,0,53,27,8,6,3],
		[2265,88,24,0,0,6,17,10,1,37,15,11,7,2],
		[2266,88,24,0,0,6,18,14,1,19,58,1,7,1],
		[2267,88,24,0,0,6,18,51,1,9,23,25,6,5],
		[2268,88,24,0,0,6,18,49,1,15,1,29,7,7],
		[2269,88,24,0,0,6,20,4,0,14,39,4,7,5],
		[2270,88,24,0,0,6,19,8,1,8,35,11,7,1],
		[2271,88,24,0,0,6,18,59,1,20,55,34,7,1],
		[2272,88,24,0,0,6,21,12,0,29,32,28,7,2],
		[2273,54,24,0,7,6,19,43,1,7,49,23,6,1],
		[2274,88,24,0,0,6,16,19,1,59,12,49,7,4],
		[2275,88,24,0,0,6,19,60,1,2,56,40,6,7],
		[2276,88,24,0,0,6,20,52,0,11,45,23,8,1],
		[2277,88,24,0,0,6,21,26,0,17,45,49,7,4],
		[2278,88,24,0,0,6,17,52,1,52,43,59,7,5],
		[2279,88,24,0,0,6,19,41,1,34,23,48,7,1],
		[2280,88,24,0,0,6,21,26,0,2,16,7,7,2],
		[2281,88,24,0,0,6,18,47,1,50,21,33,8,4],
		[2282,19,5,0,1,6,20,19,1,30,3,48,4,1],
		[2283,88,24,0,0,6,15,6,1,71,42,10,8,3],
		[2284,88,24,0,0,6,21,25,1,11,46,24,7,1],
		[2285,88,24,0,0,6,28,15,0,70,32,8,7,2],
		[2286,37,11,0,13,6,22,58,0,22,30,49,4,7],
		[2287,88,24,0,0,6,22,37,0,12,34,12,7,3],
		[2288,88,24,0,0,6,20,36,1,34,8,38,7,1],
		[2289,7,22,1,46,6,24,54,0,49,17,17,6,5],
		[2290,88,24,0,0,6,20,6,1,48,44,28,8,4],
		[2291,88,24,0,0,6,26,26,0,56,17,6,7,2],
		[2292,88,24,0,0,6,23,19,0,3,45,52,7,1],
		[2293,50,24,0,5,6,26,49,0,58,25,2,6,5],
		[2294,19,1,0,2,6,22,42,1,17,57,21,3,1],
		[2295,88,24,0,0,6,23,23,1,4,41,14,8,2],
		[2296,22,3,0,0,6,22,7,1,33,26,11,5,4],
		[2297,88,24,0,0,6,24,53,0,29,42,26,8,1],
		[2298,54,4,0,8,6,23,46,0,4,35,34,5,2],
		[2299,88,24,0,0,6,23,47,0,4,35,44,8,3],
		[2300,88,24,0,0,6,24,2,0,8,53,5,7,1],
		[2301,88,24,0,0,6,23,36,1,9,52,28,7,5],
		[2302,88,24,0,0,6,24,53,0,16,3,25,7,4],
		[2303,88,24,0,0,6,23,46,1,15,4,18,7,5],
		[2304,88,24,0,0,6,25,33,0,23,19,37,7,2],
		[2305,88,24,0,0,6,24,10,1,11,31,49,6,5],
		[2306,88,24,0,0,6,23,48,1,19,47,7,8,1],
		[2307,88,24,0,0,6,23,14,1,31,47,24,7,4],
		[2308,88,24,0,0,6,25,28,0,14,43,19,7,6],
		[2309,88,24,0,0,6,24,21,1,12,57,45,7,1],
		[2310,88,24,0,0,6,25,13,0,7,5,9,7,3],
		[2311,88,24,0,0,6,23,56,1,25,34,40,7,5],
		[2312,88,24,0,0,6,25,18,0,1,30,4,8,1],
		[2313,88,24,0,0,6,25,16,1,0,56,46,7,3],
		[2314,88,24,0,0,6,27,51,0,47,24,19,8,2],
		[2315,88,24,0,0,6,25,47,0,2,16,20,8,2],
		[2316,88,24,0,0,6,24,1,1,36,42,28,7,4],
		[2317,88,24,0,0,6,25,47,1,3,53,21,7,4],
		[2318,88,24,0,0,6,24,44,1,28,46,48,7,4],
		[2319,88,24,0,0,6,27,36,0,32,33,47,7,5],
		[2320,64,12,0,0,6,22,56,1,56,22,12,7,2],
		[2321,88,24,0,0,6,25,59,1,7,53,39,7,2],
		[2322,88,24,0,0,6,23,38,1,52,10,52,7,4],
		[2323,88,24,0,0,6,24,45,1,40,17,3,7,1],
		[2324,88,24,0,0,6,26,40,1,1,30,26,7,2],
		[2325,88,24,0,0,6,26,35,1,4,35,50,7,1],
		[2326,12,0,0,0,6,23,57,1,52,41,45,0,3],
		[2327,88,24,0,0,6,26,59,0,0,50,27,8,2],
		[2328,88,24,0,0,6,26,45,1,7,30,41,7,2],
		[2329,88,24,0,0,6,25,30,1,35,3,50,7,5],
		[2330,37,24,0,16,6,27,57,0,20,29,46,7,2],
		[2331,50,24,0,6,6,30,47,0,58,9,46,7,5],
		[2332,7,24,0,48,6,28,34,0,30,29,35,7,3],
		[2333,88,24,0,0,6,27,20,0,2,54,29,7,4],
		[2334,88,24,0,0,6,27,14,0,0,17,57,6,5],
		[2335,88,24,0,0,6,27,16,1,0,16,34,7,5],
		[2336,88,24,0,0,6,23,47,1,58,32,38,7,2],
		[2337,88,24,0,0,6,23,1,1,63,40,59,7,7],
		[2338,7,24,0,47,6,30,3,0,46,41,8,7,5],
		[2339,88,24,0,0,6,28,57,0,26,58,4,7,3],
		[2340,88,24,0,0,6,28,28,0,16,14,18,7,4],
		[2341,88,24,0,0,6,24,48,1,52,48,23,8,5],
		[2342,88,24,0,0,6,28,19,0,10,18,14,7,5],
		[2343,37,12,0,18,6,28,58,0,20,12,44,5,1],
		[2344,54,24,0,10,6,27,58,1,4,45,44,6,1],
		[2345,88,24,0,0,6,24,14,1,60,16,52,7,2],
		[2346,88,24,0,0,6,40,17,0,79,35,58,8,2],
		[2347,88,24,0,0,6,28,17,0,1,54,44,7,1],
		[2348,88,24,0,0,6,25,44,1,48,10,38,7,1],
		[2349,88,24,0,0,6,27,11,1,25,51,24,7,3],
		[2350,88,24,0,0,6,44,30,0,82,6,55,8,2],
		[2351,88,24,0,0,6,29,0,0,11,1,10,8,2],
		[2352,32,15,1,0,6,22,38,1,69,59,3,7,5],
		[2353,88,24,0,0,6,27,8,1,37,53,44,7,3],
		[2354,88,24,0,0,6,24,26,1,63,25,44,7,4],
		[2355,88,24,0,0,6,29,15,0,2,38,46,7,7],
		[2356,54,1,0,11,6,28,49,1,7,1,58,6,1],
		[2357,54,1,0,11,6,28,50,1,7,2,4,6,1],
		[2358,54,1,0,11,6,28,50,1,7,2,4,7,1],
		[2359,88,24,0,0,6,28,37,1,17,27,58,7,4],
		[2360,88,24,0,0,6,24,56,1,63,49,40,7,1],
		[2361,19,10,0,0,6,28,10,1,32,34,48,5,1],
		[2362,88,24,0,0,6,30,6,0,9,1,45,8,2],
		[2363,88,24,0,0,6,40,29,0,77,59,45,7,5],
		[2364,88,24,0,0,6,28,39,1,32,22,16,7,1],
		[2365,88,24,0,0,6,37,55,0,73,41,44,7,3],
		[2366,88,24,0,0,6,31,10,0,16,56,19,7,5],
		[2367,88,24,0,0,6,30,11,1,10,4,53,7,5],
		[2368,88,24,0,0,6,28,42,1,41,4,28,7,3],
		[2369,88,24,0,0,6,27,4,1,58,0,8,7,5],
		[2370,88,24,0,0,6,31,10,0,11,15,3,7,1],
		[2371,37,24,0,19,6,31,37,0,15,54,12,7,2],
		[2372,88,24,0,0,6,32,27,0,32,27,17,7,2],
		[2373,88,24,0,0,6,30,35,1,13,8,53,7,1],
		[2374,88,24,0,0,6,31,39,0,11,47,32,8,1],
		[2375,88,24,0,0,6,31,48,0,11,32,40,6,2],
		[2376,50,24,0,7,6,34,33,0,55,21,11,7,5],
		[2377,32,15,2,0,6,25,29,1,69,41,25,6,4],
		[2378,88,24,0,0,6,32,23,0,11,40,25,7,5],
		[2379,88,24,0,0,6,31,23,1,12,23,30,6,5],
		[2380,88,24,0,0,6,30,46,1,27,46,10,7,1],
		[2381,88,24,0,0,6,31,50,1,8,9,29,6,5],
		[2382,54,24,0,12,6,32,19,0,4,51,21,7,5],
		[2383,88,24,0,0,6,33,43,0,33,1,27,7,2],
		[2384,88,24,0,0,6,29,49,1,50,14,21,6,3],
		[2385,54,24,0,13,6,32,54,0,7,19,59,6,2],
		[2386,88,24,0,0,6,32,23,1,5,52,8,7,3],
		[2387,19,13,1,4,6,31,51,1,23,25,6,5,1],
		[2388,88,24,0,0,6,31,13,1,35,15,33,7,4],
		[2389,88,24,0,0,6,29,29,1,56,51,10,6,5],
		[2390,88,24,0,0,6,30,60,1,40,54,59,7,5],
		[2391,88,24,0,0,6,33,36,0,14,9,19,7,5],
		[2392,88,24,0,0,6,32,47,1,11,9,59,7,4],
		[2393,88,24,0,0,6,31,35,1,36,56,24,7,7],
		[2394,50,24,0,8,6,37,41,0,61,28,52,7,4],
		[2395,88,24,0,0,6,33,38,1,1,13,13,6,1],
		[2396,88,24,0,0,6,40,32,0,71,44,56,7,5],
		[2397,88,24,0,0,6,32,39,1,32,1,50,7,1],
		[2398,7,24,0,49,6,35,12,0,28,1,20,6,2],
		[2399,88,24,0,0,6,32,21,1,37,41,48,6,4],
		[2400,88,24,0,0,6,31,18,1,51,49,34,7,3],
		[2401,88,24,0,0,6,46,14,0,79,33,53,6,3],
		[2402,50,24,0,11,6,37,39,0,56,51,27,7,2],
		[2403,88,24,0,0,6,33,27,1,20,55,26,7,4],
		[2404,54,24,0,14,6,34,46,0,7,34,21,7,2],
		[2405,88,24,0,0,6,36,33,0,38,26,43,6,6],
		[2406,88,24,0,0,6,35,18,0,9,59,18,7,5],
		[2407,88,24,0,0,6,33,10,1,38,37,31,7,4],
		[2408,88,24,0,0,6,30,3,1,65,34,6,7,3],
		[2409,88,24,0,0,6,35,16,0,0,53,24,7,1],
		[2410,88,24,0,0,6,31,11,1,61,52,47,7,1],
		[2411,88,24,0,0,6,33,50,1,36,13,56,6,5],
		[2412,64,11,0,0,6,31,58,1,58,45,15,7,1],
		[2413,88,24,0,0,6,36,0,0,4,29,51,8,1],
		[2414,19,13,2,5,6,35,3,1,22,57,53,6,2],
		[2415,88,24,0,0,6,34,35,1,32,42,59,7,1],
		[2416,88,24,0,0,6,33,26,1,52,19,44,7,4],
		[2417,88,24,0,0,6,37,27,0,24,35,27,7,2],
		[2418,88,24,0,0,6,36,35,1,5,12,40,7,1],
		[2419,7,24,0,51,6,38,40,0,39,23,27,7,5],
		[2420,7,22,3,52,6,38,49,0,39,54,9,6,1],
		[2421,37,2,0,24,6,37,43,0,16,23,57,3,2],
		[2422,88,24,0,0,6,37,24,0,6,8,7,7,0],
		[2423,19,12,1,6,6,36,23,1,18,39,36,7,4],
		[2424,88,24,0,0,6,35,24,1,36,46,48,7,2],
		[2425,7,24,0,53,6,38,23,0,28,59,3,7,1],
		[2426,88,24,0,0,6,37,37,0,10,51,11,7,5],
		[2427,7,22,2,50,6,39,20,0,42,29,20,6,5],
		[2428,88,24,0,0,6,36,47,1,13,19,15,7,5],
		[2429,19,12,2,7,6,36,41,1,19,15,21,5,5],
		[2430,88,24,0,0,6,37,40,0,2,42,15,7,5],
		[2431,88,24,0,0,6,35,54,1,36,5,20,7,4],
		[2432,88,24,0,0,6,37,53,0,4,57,26,7,1],
		[2433,88,24,0,0,6,36,41,1,22,36,54,7,1],
		[2434,88,24,0,0,6,39,58,0,44,0,50,7,5],
		[2435,88,24,0,0,6,34,59,1,52,58,32,5,2],
		[2436,88,24,0,0,6,39,5,0,22,1,51,7,4],
		[2437,88,24,0,0,6,37,41,1,12,59,6,7,5],
		[2438,7,24,0,54,6,39,33,0,28,15,47,7,1],
		[2439,88,24,0,0,6,39,31,0,24,36,0,7,3],
		[2440,88,24,0,0,6,38,21,1,2,32,37,7,5],
		[2441,88,24,0,0,6,38,50,0,4,42,2,8,1],
		[2442,88,24,0,0,6,38,38,0,1,36,49,7,0],
		[2443,19,12,3,8,6,37,53,1,18,14,15,5,5],
		[2444,88,24,0,0,6,37,2,1,38,8,48,7,5],
		[2445,88,24,0,0,6,36,51,1,41,33,25,7,5],
		[2446,88,24,0,0,6,37,14,1,36,59,26,7,1],
		[2447,88,24,0,0,6,37,48,1,32,20,23,6,5],
		[2448,88,24,0,0,6,38,35,1,16,52,25,7,2],
		[2449,88,24,0,0,6,39,48,0,12,58,59,7,2],
		[2450,88,24,0,0,6,39,17,1,14,8,45,6,5],
		[2451,67,12,0,0,6,37,46,1,43,11,46,4,1],
		[2452,88,24,0,0,6,41,38,0,35,55,55,7,3],
		[2453,37,24,0,25,6,41,21,0,28,11,47,7,4],
		[2454,88,24,0,0,6,40,32,0,6,22,18,8,1],
		[2455,88,24,0,0,6,39,36,1,23,41,44,7,2],
		[2456,54,24,0,15,6,40,59,0,9,53,44,6,0],
		[2457,88,24,0,0,6,41,22,0,16,23,51,7,2],
		[2458,88,24,0,0,6,41,17,0,11,0,12,7,7],
		[2459,7,22,4,55,6,43,5,0,44,31,28,6,5],
		[2460,88,24,0,0,6,39,43,1,30,28,13,7,5],
		[2461,88,24,0,0,6,41,5,0,0,29,43,7,1],
		[2462,88,24,0,0,6,38,38,1,48,13,13,6,4],
		[2463,88,24,0,0,6,44,12,0,53,17,47,7,5],
		[2464,88,24,0,0,6,43,14,0,37,8,49,7,5],
		[2465,88,24,0,0,6,39,57,1,38,9,32,8,5],
		[2466,37,24,0,26,6,42,24,0,17,38,43,6,2],
		[2467,88,24,0,0,6,41,59,0,6,20,42,7,0],
		[2468,88,24,0,0,6,38,1,1,61,31,59,7,4],
		[2469,88,24,0,0,6,41,56,1,9,10,2,6,7],
		[2470,50,24,0,12,6,46,14,0,59,26,30,6,2],
		[2471,88,24,0,0,6,44,13,0,36,6,35,7,2],
		[2473,37,4,0,27,6,43,56,0,25,7,52,4,4],
		[2474,88,24,0,0,6,43,7,0,3,2,0,7,5],
		[2475,88,24,0,0,6,41,14,1,40,20,59,7,1],
		[2476,88,24,0,0,6,40,49,1,47,40,29,8,7],
		[2477,50,24,0,13,6,46,50,0,57,10,9,6,5],
		[2478,37,24,0,30,6,43,59,0,13,13,40,5,5],
		[2479,88,24,0,0,6,43,39,0,3,55,56,7,1],
		[2480,37,24,0,28,6,44,46,0,28,58,15,6,5],
		[2481,88,24,0,0,6,42,46,1,22,26,57,7,3],
		[2482,88,24,0,0,6,42,16,1,38,23,55,7,2],
		[2483,7,22,5,56,6,46,44,0,43,34,39,6,4],
		[2484,37,13,0,31,6,45,17,0,12,53,44,4,3],
		[2485,88,24,0,0,6,48,13,0,55,42,16,7,3],
		[2486,88,24,0,0,6,48,12,0,55,42,16,7,3],
		[2487,7,22,6,57,6,47,40,0,48,47,22,6,5],
		[2488,88,24,0,0,6,43,23,1,39,11,36,7,2],
		[2489,37,24,0,32,6,45,54,0,12,41,37,7,2],
		[2490,10,24,0,42,6,50,57,0,67,34,19,6,1],
		[2491,19,0,0,9,6,45,9,1,16,42,58,0,2],
		[2492,19,24,0,10,6,44,28,1,31,4,14,6,1],
		[2493,88,24,0,0,6,44,52,1,27,20,29,7,4],
		[2494,54,24,0,16,6,46,32,0,8,35,14,7,1],
		[2495,88,24,0,0,6,45,23,1,23,27,43,7,5],
		[2497,88,24,0,0,6,45,2,1,30,35,10,8,1],
		[2498,88,24,0,0,6,45,59,1,14,47,46,6,2],
		[2499,88,24,0,0,6,47,24,0,18,11,36,7,2],
		[2500,88,24,0,0,6,45,23,1,31,47,37,7,3],
		[2501,88,24,0,0,6,45,31,1,30,56,56,7,1],
		[2502,88,24,0,0,6,46,39,1,10,6,26,7,1],
		[2503,54,24,0,17,6,47,20,0,8,2,14,6,5],
		[2504,19,24,0,11,6,46,51,1,14,25,33,6,1],
		[2505,88,24,0,0,6,40,58,1,71,46,32,8,5],
		[2506,54,24,0,18,6,47,52,0,2,24,44,5,5],
		[2507,88,24,0,0,6,46,3,1,39,32,24,8,1],
		[2508,88,24,0,0,6,47,37,1,8,59,54,6,7],
		[2509,19,24,0,12,6,47,2,1,21,0,56,7,1],
		[2510,88,24,0,0,6,46,12,1,37,46,32,7,1],
		[2511,10,24,0,43,6,53,42,0,68,53,18,6,1],
		[2512,88,24,0,0,6,49,41,0,32,36,24,7,5],
		[2513,88,24,0,0,6,45,26,1,52,12,4,8,4],
		[2514,88,24,0,0,6,48,19,1,1,19,9,7,3],
		[2515,88,24,0,0,6,45,54,1,52,24,36,7,5],
		[2516,7,22,7,58,6,50,46,0,41,46,53,6,5],
		[2517,88,24,0,0,6,49,4,0,1,0,7,7,1],
		[2518,88,24,0,0,6,47,21,1,37,55,47,6,1],
		[2519,37,24,0,33,6,49,50,0,16,12,10,7,1],
		[2520,50,24,0,14,6,53,5,0,59,26,55,6,4],
		[2521,88,24,0,0,6,49,16,1,2,16,19,7,1],
		[2522,88,24,0,0,6,48,58,1,15,8,41,6,1],
		[2523,88,24,0,0,6,46,53,1,51,15,57,6,5],
		[2524,88,24,0,0,6,46,42,1,54,41,41,7,4],
		[2525,37,24,0,35,6,50,26,0,13,24,48,7,5],
		[2526,88,24,0,0,6,47,19,1,55,32,24,7,5],
		[2527,88,24,0,0,7,0,4,0,76,58,39,6,5],
		[2528,88,24,0,0,6,49,44,1,24,4,33,7,2],
		[2529,37,24,0,36,6,51,33,0,21,45,40,6,2],
		[2530,88,24,0,0,6,50,50,1,0,32,27,7,3],
		[2531,88,24,0,0,6,43,37,1,73,7,5,7,4],
		[2532,88,24,0,0,6,53,8,0,44,50,22,7,2],
		[2533,88,24,0,0,6,52,0,0,23,36,6,7,5],
		[2534,88,24,0,0,6,50,42,1,8,2,28,7,2],
		[2535,88,24,0,0,6,50,22,1,17,5,2,7,5],
		[2536,88,24,0,0,6,44,56,1,70,26,2,7,5],
		[2537,88,24,0,0,6,50,6,1,27,20,2,8,1],
		[2538,19,9,0,13,6,49,51,1,32,30,31,5,1],
		[2539,7,24,0,59,6,53,2,0,38,52,9,7,3],
		[2540,37,7,0,34,6,52,47,0,33,57,40,5,2],
		[2541,7,24,0,60,6,53,13,0,38,26,17,7,3],
		[2542,88,24,0,0,6,53,3,0,35,47,19,7,5],
		[2543,88,24,0,0,6,51,39,0,3,2,30,7,2],
		[2544,88,24,0,0,6,50,37,1,25,46,41,7,1],
		[2545,88,24,0,0,6,50,23,1,31,42,22,7,1],
		[2546,88,24,0,0,6,49,58,1,45,27,0,8,5],
		[2547,7,22,8,61,6,53,57,0,38,30,18,7,1],
		[2548,88,24,0,0,6,49,55,1,46,36,53,6,3],
		[2549,88,24,0,0,6,50,52,1,34,22,2,6,5],
		[2550,64,0,0,0,6,48,11,1,61,56,29,4,2],
		[2551,88,24,0,0,6,52,49,0,8,22,49,7,3],
		[2552,88,24,0,0,6,52,23,1,5,18,58,7,5],
		[2553,67,18,0,0,6,49,56,1,50,36,53,4,5],
		[2554,88,24,0,0,6,49,51,1,53,37,20,5,4],
		[2555,88,24,0,0,6,53,23,0,10,59,47,7,5],
		[2556,88,24,0,0,6,55,15,0,45,49,35,7,5],
		[2557,88,24,0,0,6,55,15,0,43,54,36,7,2],
		[2558,88,24,0,0,6,51,42,1,36,13,49,7,2],
		[2559,52,5,0,0,6,40,3,1,80,48,49,7,2],
		[2560,50,24,0,15,6,57,17,0,58,25,21,5,4],
		[2561,88,24,0,0,6,57,13,0,57,33,48,7,5],
		[2562,88,24,0,0,6,50,1,1,60,14,57,7,3],
		[2563,88,24,0,0,6,51,33,1,48,17,33,7,5],
		[2564,37,24,0,38,6,54,39,0,13,10,40,6,3],
		[2565,88,24,0,0,6,53,19,1,19,1,58,7,3],
		[2566,88,24,0,0,6,53,22,1,18,56,0,7,2],
		[2567,88,24,0,0,6,53,0,1,26,57,27,7,7],
		[2568,7,22,9,0,6,56,32,0,46,16,27,7,1],
		[2569,37,24,0,37,6,55,19,0,25,22,32,7,4],
		[2570,88,24,0,0,6,54,9,1,5,51,9,7,2],
		[2571,19,24,0,15,6,53,33,1,20,13,27,6,1],
		[2572,88,24,0,0,6,54,25,1,1,7,37,6,2],
		[2573,88,24,0,0,6,56,56,0,46,42,18,7,5],
		[2574,19,7,0,14,6,54,11,1,12,2,19,5,5],
		[2575,88,24,0,0,6,52,40,1,42,30,16,8,3],
		[2576,88,24,0,0,6,53,34,1,28,32,23,7,4],
		[2577,88,24,0,0,6,54,42,1,1,45,23,7,1],
		[2578,88,24,0,0,6,53,55,1,24,32,21,7,2],
		[2579,88,24,0,0,6,52,47,1,43,58,33,7,1],
		[2580,19,14,1,16,6,54,8,1,24,11,2,5,5],
		[2581,88,24,0,0,7,1,22,0,70,48,29,7,5],
		[2582,88,24,0,0,6,54,59,1,2,48,13,7,4],
		[2583,88,24,0,0,6,54,13,1,23,55,42,8,1],
		[2584,88,24,0,0,6,55,35,0,8,19,29,7,2],
		[2585,50,24,0,16,6,57,37,0,45,5,39,6,2],
		[2586,88,24,0,0,6,57,1,0,33,40,52,7,4],
		[2587,88,24,0,0,6,52,47,1,54,5,24,8,4],
		[2588,19,24,0,17,6,55,3,1,20,24,17,7,2],
		[2589,88,24,0,0,6,56,26,0,9,57,23,7,1],
		[2590,19,15,0,19,6,55,37,1,20,8,11,6,3],
		[2591,88,24,0,0,6,54,27,1,42,21,56,7,6],
		[2592,88,24,0,0,6,52,45,1,59,20,28,7,2],
		[2593,19,11,0,18,6,56,7,1,14,2,37,6,4],
		[2594,88,24,0,0,6,54,2,1,50,36,42,7,5],
		[2595,88,24,0,0,6,55,47,1,22,56,29,6,1],
		[2596,19,8,0,20,6,56,8,1,17,3,15,5,1],
		[2597,88,24,0,0,6,57,26,0,11,54,27,7,3],
		[2598,88,24,0,0,6,55,55,1,31,47,24,7,1],
		[2599,88,24,0,0,6,57,0,1,8,10,44,7,5],
		[2600,7,24,0,62,6,59,3,0,38,3,8,7,5],
		[2601,37,24,0,39,6,58,47,0,26,4,52,7,3],
		[2602,86,8,0,0,6,51,27,1,70,57,48,6,1],
		[2603,88,24,0,0,6,57,15,1,22,12,12,8,1],
		[2604,88,24,0,0,6,56,46,1,35,20,30,7,5],
		[2605,37,24,0,40,6,59,28,0,25,54,51,7,1],
		[2606,88,24,0,0,6,58,39,0,7,37,19,7,2],
		[2607,88,24,0,0,6,57,34,1,24,37,50,6,3],
		[2608,88,24,0,0,6,56,16,1,48,43,16,6,7],
		[2609,88,24,0,0,7,40,31,0,87,1,12,6,7],
		[2610,88,24,0,0,6,58,57,0,3,36,8,7,4],
		[2611,88,24,0,0,6,57,42,1,27,32,15,7,1],
		[2612,88,24,0,0,6,57,18,1,35,30,27,7,3],
		[2613,88,24,0,0,6,59,20,0,7,19,1,7,1],
		[2614,88,24,0,0,6,58,8,1,27,9,53,7,1],
		[2615,37,24,0,41,7,0,16,0,16,4,44,7,5],
		[2616,88,24,0,0,6,58,36,1,25,24,50,7,1],
		[2617,88,24,0,0,7,5,52,0,70,43,55,8,5],
		[2618,19,4,0,21,6,58,38,1,28,58,20,3,1],
		[2619,88,24,0,0,6,58,25,1,34,6,42,6,1],
		[2620,88,24,0,0,7,1,17,0,32,24,52,8,2],
		[2621,88,24,0,0,6,58,44,1,30,59,52,7,1],
		[2622,88,24,0,0,7,0,18,1,5,22,1,7,4],
		[2623,88,24,0,0,6,59,39,1,21,36,12,7,1],
		[2624,88,24,0,0,7,0,24,1,8,24,25,7,1],
		[2625,88,24,0,0,7,0,8,1,20,9,32,7,1],
		[2626,88,24,0,0,6,58,42,1,45,46,5,7,2],
		[2627,88,24,0,0,7,0,39,1,9,12,11,7,1],
		[2628,88,24,0,0,7,0,19,1,22,7,10,8,1],
		[2629,88,24,0,0,7,1,41,0,4,49,5,8,2],
		[2630,37,23,0,42,7,2,25,0,24,12,55,6,4],
		[2631,88,24,0,0,7,2,26,0,17,45,20,7,7],
		[2632,88,24,0,0,7,2,17,0,15,20,10,7,5],
		[2633,88,24,0,0,7,1,55,0,5,33,27,8,1],
		[2634,88,24,0,0,6,58,40,1,55,43,46,7,5],
		[2635,88,24,0,0,7,2,34,0,16,40,27,7,7],
		[2636,88,24,0,0,7,1,53,1,1,20,44,7,4],
		[2637,88,24,0,0,7,0,43,1,28,29,22,7,3],
		[2638,88,24,0,0,6,58,36,1,56,23,41,7,3],
		[2639,88,24,0,0,7,1,56,1,5,43,20,6,7],
		[2640,88,24,0,0,7,1,6,1,25,12,55,7,1],
		[2641,88,24,0,0,7,0,50,1,33,27,55,7,4],
		[2642,88,24,0,0,7,6,1,0,59,48,7,7,4],
		[2643,88,24,0,0,7,3,30,0,29,20,14,7,4],
		[2644,88,24,0,0,7,5,40,0,52,45,29,7,2],
		[2645,88,24,0,0,7,5,9,0,47,46,30,7,1],
		[2646,19,17,0,22,7,1,43,1,27,56,5,4,5],
		[2647,88,24,0,0,7,3,18,0,9,8,18,7,2],
		[2648,54,24,0,19,7,2,55,1,4,14,21,6,1],
		[2649,88,24,0,0,7,3,38,0,10,57,6,6,5],
		[2650,37,5,0,43,7,4,7,0,20,34,13,5,3],
		[2651,88,24,0,0,7,3,52,0,12,35,40,7,5],
		[2652,88,24,0,0,7,0,52,1,51,24,9,6,7],
		[2653,19,14,2,24,7,3,2,1,23,50,0,4,1],
		[2654,88,24,0,0,7,4,20,0,1,29,18,8,2],
		[2655,88,24,0,0,7,4,5,1,5,19,25,7,5],
		[2656,88,24,0,0,7,3,57,1,10,7,27,7,1],
		[2657,19,2,0,23,7,3,46,1,15,38,0,5,1],
		[2658,88,24,0,0,7,2,16,1,43,24,15,7,2],
		[2659,37,24,0,44,7,5,18,0,22,38,14,7,1],
		[2660,88,24,0,0,7,6,12,0,34,28,26,7,4],
		[2661,88,24,0,0,7,1,5,1,58,56,24,7,2],
		[2662,88,24,0,0,6,59,51,1,67,54,58,6,5],
		[2663,88,24,0,0,7,5,39,0,9,11,9,7,7],
		[2664,88,24,0,0,7,4,47,1,22,1,56,7,5],
		[2665,88,24,0,0,7,7,22,0,34,0,34,7,5],
		[2666,88,24,0,0,7,4,3,1,42,20,14,6,2],
		[2667,88,24,0,0,7,3,57,1,43,36,29,7,4],
		[2668,88,24,0,0,7,3,59,1,43,36,42,8,5],
		[2669,88,24,0,0,7,7,25,0,28,10,38,7,1],
		[2670,88,24,0,0,7,5,50,1,10,39,40,7,1],
		[2671,88,24,0,0,7,7,21,0,22,42,13,9,7],
		[2672,88,24,0,0,7,3,54,1,49,35,2,6,2],
		[2673,88,24,0,0,7,8,13,0,33,49,56,7,5],
		[2674,88,24,0,0,7,3,16,1,59,10,41,7,1],
		[2675,88,24,0,0,7,8,36,0,37,26,42,7,5],
		[2676,88,24,0,0,7,7,6,0,4,54,37,7,1],
		[2677,88,24,0,0,7,5,32,1,34,46,40,7,3],
		[2678,88,24,0,0,7,6,41,1,11,17,39,6,1],
		[2679,88,24,0,0,7,6,36,1,12,23,38,7,0],
		[2680,88,24,0,0,7,6,1,1,30,39,20,7,1],
		[2681,88,24,0,0,7,13,58,0,71,49,0,7,5],
		[2682,88,24,0,0,7,7,50,0,7,28,16,7,5],
		[2683,88,24,0,0,7,4,18,1,56,44,59,6,2],
		[2684,37,24,0,45,7,8,22,0,15,55,51,6,4],
		[2685,88,24,0,0,7,6,2,1,38,22,58,7,4],
		[2686,88,24,0,0,7,6,52,1,24,57,38,7,5],
		[2687,88,24,0,0,7,5,17,1,50,21,37,7,5],
		[2688,88,24,0,0,7,7,0,1,26,39,28,8,1],
		[2689,52,7,0,0,6,56,34,1,79,25,13,6,1],
		[2690,88,24,0,0,7,7,23,1,23,50,25,7,1],
		[2691,88,24,0,0,7,7,7,1,40,53,36,7,1],
		[2692,88,24,0,0,7,10,7,0,21,14,49,7,4],
		[2693,19,3,0,25,7,8,24,1,26,23,36,3,3],
		[2694,88,24,0,0,7,9,20,1,10,20,50,7,0],
		[2695,88,24,0,0,7,8,49,1,24,2,39,8,1],
		[2696,7,24,0,63,7,11,39,0,39,19,14,6,5],
		[2697,37,18,0,46,7,11,8,0,30,14,43,5,5],
		[2698,88,24,0,0,7,7,13,1,51,58,4,7,5],
		[2699,88,24,0,0,7,9,33,1,16,14,5,7,1],
		[2700,37,24,0,47,7,11,23,0,26,51,24,7,2],
		[2701,54,24,0,20,7,10,14,1,4,14,14,6,5],
		[2702,88,24,0,0,7,8,51,1,39,39,21,6,1],
		[2703,88,24,0,0,7,13,23,0,51,25,44,6,7],
		[2704,88,24,0,0,7,9,43,1,25,13,52,7,1],
		[2705,88,24,0,0,7,10,9,1,18,41,7,7,3],
		[2706,37,24,0,48,7,12,26,0,24,7,42,7,3],
		[2707,54,24,0,21,7,11,24,1,0,18,7,6,2],
		[2708,88,24,0,0,7,10,19,1,27,29,29,6,4],
		[2709,88,24,0,0,7,25,22,0,81,15,27,7,2],
		[2710,88,24,0,0,7,11,51,0,5,39,17,7,2],
		[2711,88,24,0,0,7,12,49,0,27,13,29,7,3],
		[2712,88,24,0,0,7,6,14,1,68,50,14,7,5],
		[2713,88,24,0,0,7,12,7,0,5,28,29,7,5],
		[2714,54,3,0,22,7,11,52,1,0,29,34,5,2],
		[2715,50,24,0,18,7,15,55,0,59,38,15,6,5],
		[2716,88,24,0,0,7,11,42,1,20,52,59,7,2],
		[2717,37,24,0,51,7,13,22,0,16,9,32,6,7],
		[2718,19,24,0,26,7,12,12,1,25,56,33,7,1],
		[2719,88,24,0,0,7,10,48,1,48,55,56,6,5],
		[2720,88,24,0,0,7,12,4,1,30,49,18,7,2],
		[2721,88,24,0,0,7,15,50,0,47,14,24,7,4],
		[2722,88,24,0,0,7,14,27,0,24,42,39,8,2],
		[2723,88,24,0,0,7,13,7,1,11,15,5,7,5],
		[2724,88,24,0,0,7,12,24,1,27,28,27,8,2],
		[2725,37,24,0,52,7,14,42,0,24,53,6,7,7],
		[2726,88,24,0,0,7,12,26,1,36,32,40,7,1],
		[2727,88,24,0,0,7,12,16,1,40,29,56,6,2],
		[2728,88,24,0,0,7,14,33,0,12,6,57,7,4],
		[2729,88,24,0,0,7,14,20,0,3,6,41,6,5],
		[2730,88,24,0,0,7,13,24,1,22,40,24,7,5],
		[2731,88,24,0,0,7,14,11,1,3,54,5,7,5],
		[2732,88,24,0,0,7,14,16,1,9,56,51,7,5],
		[2733,88,24,0,0,7,13,48,1,22,54,23,7,1],
		[2734,88,24,0,0,7,13,36,1,27,21,23,7,1],
		[2735,86,2,1,0,7,8,42,1,70,29,50,7,3],
		[2736,86,2,2,0,7,8,45,1,70,29,56,5,5],
		[2737,88,24,0,0,7,17,34,0,52,7,51,7,5],
		[2738,37,24,0,53,7,15,57,0,27,53,51,7,7],
		[2739,88,24,0,0,7,14,28,1,10,19,0,7,1],
		[2740,88,24,0,0,7,12,34,1,46,45,34,5,3],
		[2741,88,24,0,0,7,13,47,1,31,5,2,8,1],
		[2742,88,24,0,0,7,31,4,0,82,24,41,6,7],
		[2743,88,24,0,0,7,13,57,1,30,20,24,7,1],
		[2744,54,24,0,24,7,15,19,1,0,9,41,7,4],
		[2745,19,24,0,27,7,14,15,1,26,21,9,6,1],
		[2746,88,24,0,0,7,13,13,1,45,10,59,6,2],
		[2747,88,24,0,0,7,15,39,0,7,58,40,7,7],
		[2748,88,24,0,0,7,13,32,1,44,38,23,6,7],
		[2749,19,23,0,28,7,14,49,1,26,46,22,5,1],
		[2750,88,24,0,0,7,14,51,1,27,2,17,7,5],
		[2751,88,24,0,0,7,18,32,0,49,27,54,6,2],
		[2752,88,24,0,0,7,15,43,1,10,35,2,7,5],
		[2753,7,24,0,64,7,18,2,0,40,53,0,7,2],
		[2754,88,24,0,0,7,12,2,1,63,11,24,7,2],
		[2755,88,24,0,0,7,15,48,1,23,44,26,7,2],
		[2756,88,24,0,0,7,15,21,1,30,41,11,6,1],
		[2757,88,24,0,0,7,18,4,0,30,57,21,7,2],
		[2758,88,24,0,0,7,16,15,1,15,35,9,6,2],
		[2759,88,24,0,0,7,14,57,1,41,25,33,7,1],
		[2760,88,24,0,0,7,17,18,0,6,40,50,8,1],
		[2761,88,24,0,0,7,14,46,1,46,50,59,7,2],
		[2762,88,24,0,0,7,14,38,1,48,16,18,6,1],
		[2763,37,10,0,54,7,18,6,0,16,32,25,5,2],
		[2764,88,24,0,0,7,16,37,1,23,18,56,6,5],
		[2765,88,24,0,0,7,17,32,1,6,40,48,7,5],
		[2766,88,24,0,0,7,16,35,1,27,52,52,6,7],
		[2767,88,24,0,0,7,15,21,1,52,29,59,7,5],
		[2768,88,24,0,0,7,16,57,1,30,53,48,7,2],
		[2769,88,24,0,0,7,16,32,1,38,19,8,7,1],
		[2770,88,24,0,0,7,16,50,1,36,35,34,6,1],
		[2771,88,24,0,0,7,16,16,1,46,46,28,7,5],
		[2772,10,24,0,47,7,22,17,0,59,54,7,7,2],
		[2773,67,15,0,0,7,17,9,1,37,5,51,4,5],
		[2774,88,24,0,0,7,17,48,1,26,47,51,7,1],
		[2775,88,24,0,0,7,21,3,0,42,39,20,7,5],
		[2776,88,24,0,0,7,21,18,0,45,13,41,7,2],
		[2777,37,3,0,55,7,20,7,0,21,58,56,5,3],
		[2778,88,24,0,0,7,19,22,0,2,44,26,7,4],
		[2779,88,24,0,0,7,19,48,0,7,8,34,7,3],
		[2780,88,24,0,0,7,20,7,0,15,8,34,7,2],
		[2781,19,24,0,29,7,18,40,1,24,33,32,6,0],
		[2782,19,18,0,30,7,18,42,1,24,57,15,5,0],
		[2783,50,24,0,19,7,22,51,0,55,17,4,8,1],
		[2784,50,24,0,19,7,22,52,0,55,16,53,6,1],
		[2785,88,24,0,0,7,19,2,1,19,16,49,7,3],
		[2786,88,24,0,0,7,18,51,1,26,35,9,6,4],
		[2787,88,24,0,0,7,18,18,1,36,44,3,6,1],
		[2788,88,24,0,0,7,19,28,1,16,23,42,7,3],
		[2789,88,24,0,0,7,18,4,1,43,59,12,7,1],
		[2790,88,24,0,0,7,18,38,1,36,44,34,6,1],
		[2791,88,24,0,0,7,18,34,1,39,12,37,6,2],
		[2792,88,24,0,0,7,22,13,0,38,59,46,7,5],
		[2793,7,24,0,65,7,22,3,0,36,45,38,6,5],
		[2794,88,24,0,0,7,19,14,1,33,43,38,7,5],
		[2795,37,24,0,56,7,21,57,0,20,26,37,6,7],
		[2796,88,24,0,0,7,20,58,1,14,21,36,6,4],
		[2797,88,24,0,0,7,34,40,0,80,53,48,7,4],
		[2798,88,24,0,0,7,21,17,1,8,52,42,8,3],
		[2799,88,24,0,0,7,20,53,1,22,51,6,8,1],
		[2800,88,24,0,0,7,20,55,1,26,57,49,7,1],
		[2801,88,24,0,0,7,22,4,0,0,10,38,7,1],
		[2802,88,24,0,0,7,21,4,1,25,53,29,7,7],
		[2803,86,3,0,0,7,16,50,1,67,57,26,5,3],
		[2804,88,24,0,0,7,24,57,0,51,53,14,7,5],
		[2805,7,24,0,66,7,24,9,0,40,40,20,6,5],
		[2806,88,24,0,0,7,22,2,1,8,58,45,7,0],
		[2807,88,24,0,0,7,22,19,1,2,58,44,7,3],
		[2808,37,24,0,57,7,23,29,0,25,3,2,6,4],
		[2809,88,24,0,0,7,27,26,0,66,19,54,7,1],
		[2810,37,24,0,58,7,23,28,0,22,56,43,7,2],
		[2811,88,24,0,0,7,22,25,1,5,58,58,7,3],
		[2812,88,24,0,0,7,22,14,1,19,1,0,6,1],
		[2813,88,24,0,0,7,20,21,1,52,18,42,7,3],
		[2814,88,24,0,0,7,20,22,1,52,18,35,8,4],
		[2815,88,24,0,0,7,20,39,1,52,5,10,6,1],
		[2816,37,24,0,59,7,24,33,0,27,38,17,7,3],
		[2817,88,24,0,0,7,24,28,0,15,31,2,7,1],
		[2818,50,24,0,21,7,26,43,0,49,12,41,6,2],
		[2819,88,24,0,0,7,23,1,1,31,55,26,6,1],
		[2820,20,24,0,1,7,24,58,0,11,40,11,6,2],
		[2821,37,8,0,60,7,25,44,0,27,47,53,5,4],
		[2822,88,24,0,0,7,23,29,1,27,50,3,6,5],
		[2823,88,24,0,0,7,23,32,1,32,12,8,6,1],
		[2824,88,24,0,0,7,23,54,1,30,13,1,8,1],
		[2825,88,24,0,0,7,24,40,1,16,12,4,6,1],
		[2826,88,24,0,0,7,24,17,1,22,54,46,7,1],
		[2827,19,6,0,31,7,24,6,1,29,18,11,3,1],
		[2828,20,4,0,2,7,25,39,0,9,16,34,6,4],
		[2829,88,24,0,0,7,23,58,1,35,50,16,7,1],
		[2830,88,24,0,0,7,30,53,0,68,27,56,7,5],
		[2831,88,24,0,0,7,24,51,1,19,0,44,7,2],
		[2832,88,24,0,0,7,25,8,1,13,45,7,7,3],
		[2833,88,24,0,0,7,25,51,1,5,46,30,7,4],
		[2834,88,24,0,0,7,24,44,1,31,48,32,6,4],
		[2835,88,24,0,0,7,26,50,0,21,32,9,8,3],
		[2836,88,24,0,0,7,26,28,0,10,36,30,7,2],
		[2837,37,24,0,61,7,26,56,0,20,15,26,7,3],
		[2838,88,24,0,0,7,26,4,1,4,32,15,8,2],
		[2839,88,24,0,0,7,25,20,1,21,58,58,7,2],
		[2840,88,24,0,0,7,26,41,0,11,0,33,7,1],
		[2841,88,24,0,0,7,25,25,1,25,13,4,7,1],
		[2842,88,24,0,0,7,24,47,1,37,17,24,8,3],
		[2843,88,24,0,0,7,24,47,1,37,17,27,8,3],
		[2844,88,24,0,0,7,28,52,0,48,11,2,7,1],
		[2845,20,1,0,3,7,27,9,0,8,17,22,4,1],
		[2846,37,24,0,63,7,27,44,0,21,26,42,6,3],
		[2847,88,24,0,0,7,25,43,1,31,44,19,7,1],
		[2848,88,24,0,0,6,46,59,1,87,1,30,7,3],
		[2849,50,24,0,22,7,29,56,0,49,40,21,6,3],
		[2850,88,24,0,0,7,26,41,1,23,42,44,8,2],
		[2851,20,6,0,5,7,28,2,0,6,56,31,6,3],
		[2852,37,16,0,62,7,29,7,0,31,47,4,5,3],
		[2853,88,24,0,0,7,27,8,1,17,51,52,7,2],
		[2854,20,2,0,4,7,28,10,0,8,55,32,5,5],
		[2855,88,24,0,0,7,26,59,1,23,5,10,7,1],
		[2856,88,24,0,0,7,26,42,1,34,8,27,7,1],
		[2857,37,24,0,64,7,29,20,0,28,7,5,6,2],
		[2858,88,24,0,0,7,28,47,0,15,6,34,7,1],
		[2859,88,24,0,0,7,27,52,1,11,33,25,7,4],
		[2860,88,24,0,0,7,27,43,1,22,51,35,7,1],
		[2861,37,24,0,65,7,29,49,0,27,54,58,6,5],
		[2862,88,24,0,0,7,26,22,1,51,1,6,6,5],
		[2863,88,24,0,0,7,27,59,1,29,9,21,7,1],
		[2864,20,24,0,6,7,29,48,0,12,0,24,6,5],
		[2865,88,24,0,0,7,29,19,1,1,54,19,7,5],
		[2866,88,24,0,0,7,29,26,1,7,33,4,7,3],
		[2867,88,24,0,0,7,29,22,1,10,19,36,7,5],
		[2868,88,24,0,0,7,29,22,1,14,59,57,7,3],
		[2869,88,24,0,0,7,28,23,1,37,48,37,8,2],
		[2870,88,24,0,0,7,28,51,1,31,50,54,7,1],
		[2871,88,24,0,0,7,28,52,1,31,50,49,8,1],
		[2872,88,24,0,0,7,31,56,0,38,53,47,8,2],
		[2873,88,24,0,0,7,29,5,1,31,27,23,7,1],
		[2874,88,24,0,0,7,29,51,1,23,1,28,6,2],
		[2875,88,24,0,0,7,29,6,1,38,48,44,6,1],
		[2876,88,24,0,0,7,30,51,1,5,13,35,7,5],
		[2877,88,24,0,0,7,31,48,0,17,5,10,6,5],
		[2878,67,17,0,0,7,29,14,1,43,18,5,4,5],
		[2879,88,24,0,0,7,32,51,0,22,53,16,8,5],
		[2880,20,3,1,7,7,32,6,0,1,54,52,6,3],
		[2881,88,24,0,0,7,30,43,1,30,57,44,6,4],
		[2882,88,24,0,0,7,30,42,1,37,20,23,8,4],
		[2883,88,24,0,0,7,32,6,1,8,52,51,7,3],
		[2884,88,24,0,0,7,29,60,1,52,39,4,7,5],
		[2885,88,24,0,0,7,31,26,1,36,9,10,8,1],
		[2886,37,24,0,68,7,33,37,0,15,49,36,6,2],
		[2887,20,3,2,8,7,33,12,0,3,17,25,7,3],
		[2888,88,24,0,0,7,28,51,1,64,30,36,7,5],
		[2889,88,24,0,0,7,31,43,1,35,53,16,8,2],
		[2890,37,0,0,66,7,34,36,0,31,53,19,4,2],
		[2891,37,0,0,66,7,34,36,0,31,53,18,3,2],
		[2892,88,24,0,0,7,30,31,1,54,23,58,7,7],
		[2893,88,24,0,0,7,34,5,0,10,34,6,7,2],
		[2894,88,24,0,0,7,36,47,0,55,45,19,7,5],
		[2895,88,24,0,0,7,32,22,1,35,57,41,7,1],
		[2896,88,24,0,0,7,35,9,0,30,57,40,6,5],
		[2897,88,24,0,0,7,33,22,1,14,20,18,7,1],
		[2898,88,24,0,0,7,35,56,0,43,1,52,7,3],
		[2899,88,24,0,0,7,33,20,1,19,24,45,7,5],
		[2900,88,24,0,0,7,33,10,1,24,42,39,7,2],
		[2901,20,3,3,9,7,34,16,0,3,22,17,7,2],
		[2902,88,24,0,0,7,33,48,1,14,31,26,6,7],
		[2903,88,24,0,0,7,36,32,0,46,10,49,7,7],
		[2904,88,24,0,0,7,34,46,0,2,43,30,8,2],
		[2905,37,19,0,69,7,35,55,0,26,53,45,5,7],
		[2906,88,24,0,0,7,34,3,1,22,17,46,5,3],
		[2907,88,24,0,0,7,33,14,1,40,3,32,7,1],
		[2908,88,24,0,0,7,33,13,1,43,5,11,8,4],
		[2909,88,24,0,0,7,34,19,1,23,28,25,7,3],
		[2910,88,24,0,0,7,34,19,1,23,28,29,7,3],
		[2911,88,24,0,0,7,33,51,1,36,20,18,7,1],
		[2912,88,24,0,0,7,34,29,1,26,7,0,8,2],
		[2913,88,24,0,0,7,34,13,1,33,27,48,7,2],
		[2914,88,24,0,0,7,37,54,0,48,46,25,7,2],
		[2915,88,24,0,0,7,37,18,0,40,1,31,7,7],
		[2916,88,24,0,0,7,34,35,1,27,0,43,7,5],
		[2917,88,24,0,0,7,33,59,1,39,54,21,8,5],
		[2918,88,24,0,0,7,36,35,0,5,51,42,7,4],
		[2919,52,4,0,0,7,25,38,1,79,5,39,7,5],
		[2920,88,24,0,0,7,36,17,1,8,18,41,7,5],
		[2921,88,24,0,0,7,36,4,1,14,29,34,7,1],
		[2922,88,24,0,0,7,35,23,1,28,22,10,6,1],
		[2923,88,24,0,0,7,36,8,1,22,9,38,7,4],
		[2924,37,24,0,70,7,38,33,0,35,2,55,7,5],
		[2925,88,24,0,0,7,34,40,1,51,28,29,7,2],
		[2926,88,24,0,0,7,38,15,0,24,21,37,7,3],
		[2927,54,24,0,25,7,37,17,1,4,6,40,6,3],
		[2928,88,24,0,0,7,36,41,1,19,42,8,7,1],
		[2929,50,24,0,23,7,40,50,0,57,4,58,7,5],
		[2930,37,14,0,71,7,39,10,0,34,35,3,6,3],
		[2931,88,24,0,0,7,39,12,0,24,13,21,7,2],
		[2932,88,24,0,0,7,37,39,1,14,26,28,8,1],
		[2933,88,24,0,0,7,37,17,1,23,46,30,7,3],
		[2934,88,24,0,0,7,35,40,1,52,32,2,6,5],
		[2935,88,24,0,0,7,40,15,0,38,20,40,7,7],
		[2936,88,24,0,0,7,39,54,0,32,0,35,7,3],
		[2937,88,24,0,0,7,37,22,1,34,58,7,6,1],
		[2938,37,24,0,74,7,39,29,0,17,40,29,6,5],
		[2939,88,24,0,0,7,41,12,0,48,7,54,7,5],
		[2940,88,24,0,0,7,36,44,1,48,49,49,7,1],
		[2941,88,24,0,0,7,36,2,1,55,53,15,7,5],
		[2942,88,24,0,0,7,37,45,1,35,16,38,8,5],
		[2943,20,0,0,10,7,39,18,0,5,13,30,1,3],
		[2944,88,24,0,0,7,38,18,1,25,21,53,6,1],
		[2945,88,24,0,0,7,37,45,1,38,0,38,7,5],
		[2946,50,24,0,24,7,43,0,0,58,42,37,6,2],
		[2947,88,24,0,0,7,39,7,1,18,40,45,8,1],
		[2948,88,24,0,0,7,38,49,1,26,48,6,6,1],
		[2949,88,24,0,0,7,38,50,1,26,48,13,6,1],
		[2950,88,24,0,0,7,40,7,0,5,13,51,7,2],
		[2951,88,24,0,0,7,40,59,0,23,1,7,7,5],
		[2952,88,24,0,0,7,38,24,1,39,59,29,8,2],
		[2953,88,24,0,0,7,40,47,0,13,46,15,7,5],
		[2954,88,24,0,0,7,38,44,1,36,29,49,7,1],
		[2955,88,24,0,0,7,38,33,1,38,46,52,7,4],
		[2956,88,24,0,0,7,39,27,1,26,51,47,8,1],
		[2957,88,24,0,0,7,38,18,1,48,36,4,7,3],
		[2958,88,24,0,0,7,40,36,1,8,11,9,7,2],
		[2959,88,24,0,0,7,40,23,1,15,15,49,6,5],
		[2960,88,24,0,0,7,40,14,1,19,39,39,7,5],
		[2961,88,24,0,0,7,39,27,1,38,18,30,6,1],
		[2962,88,24,0,0,7,42,44,0,34,0,1,7,3],
		[2963,88,24,0,0,7,39,44,1,38,8,22,7,1],
		[2964,88,24,0,0,7,39,48,1,38,15,39,7,1],
		[2965,88,24,0,0,7,41,52,0,13,28,50,7,7],
		[2966,88,24,0,0,7,41,35,0,3,37,29,7,2],
		[2967,88,24,0,0,7,42,3,0,14,12,30,7,7],
		[2968,88,24,0,0,7,39,58,1,37,34,46,7,1],
		[2969,88,24,0,0,7,44,4,0,50,26,2,6,2],
		[2970,54,0,0,26,7,41,15,1,9,33,4,5,5],
		[2971,88,24,0,0,7,39,0,1,53,16,24,7,1],
		[2972,88,24,0,0,7,40,43,1,27,56,45,8,1],
		[2973,37,17,0,75,7,43,19,0,28,53,1,5,5],
		[2974,88,24,0,0,7,40,53,1,31,39,39,8,4],
		[2975,10,24,0,51,7,46,40,0,65,27,21,7,5],
		[2976,88,24,0,0,7,41,24,1,22,20,14,7,7],
		[2977,10,24,0,49,7,46,27,0,62,49,50,7,3],
		[2978,88,24,0,0,7,43,22,0,22,23,58,7,5],
		[2979,88,24,0,0,7,35,22,1,74,16,32,8,1],
		[2980,88,24,0,0,7,35,22,1,74,16,32,8,1],
		[2981,88,24,0,0,7,41,16,1,38,32,1,6,1],
		[2982,88,24,0,0,7,43,5,0,0,11,22,7,5],
		[2983,37,24,0,76,7,44,7,0,25,47,3,6,5],
		[2984,88,24,0,0,7,41,22,1,44,37,56,7,1],
		[2985,37,9,0,77,7,44,27,0,24,23,53,5,4],
		[2986,88,24,0,0,7,41,58,1,38,31,44,8,1],
		[2987,88,24,0,0,7,44,14,0,12,51,34,7,5],
		[2988,88,24,0,0,7,42,48,1,26,21,4,7,5],
		[2989,88,24,0,0,7,44,7,0,2,24,18,7,3],
		[2990,37,1,0,78,7,45,19,0,28,1,34,2,5],
		[2991,37,24,0,79,7,45,9,0,20,18,59,7,2],
		[2992,88,24,0,0,7,43,39,1,25,30,14,8,2],
		[2993,67,24,0,1,7,43,32,1,28,24,40,6,5],
		[2994,88,24,0,0,7,43,12,1,36,3,1,7,1],
		[2995,88,24,0,0,7,43,7,1,38,51,51,8,4],
		[2996,67,24,0,3,7,43,49,1,28,57,17,5,2],
		[2997,88,24,0,0,7,56,17,0,80,15,56,8,4],
		[2998,88,24,0,0,7,42,57,1,45,10,24,6,4],
		[2999,88,24,0,0,7,46,39,0,37,31,3,6,7],
		[3000,88,24,0,0,7,36,4,1,77,38,3,7,7],
		[3001,88,24,0,0,7,43,43,1,38,12,7,7,1],
		[3002,88,24,0,0,7,43,42,1,40,56,2,6,5],
		[3003,37,24,0,81,7,46,7,0,18,30,36,6,5],
		[3004,88,24,0,0,7,44,34,1,24,40,26,7,1],
		[3005,88,24,0,0,7,43,7,1,49,59,34,8,2],
		[3006,88,24,0,0,7,42,10,1,58,37,51,7,1],
		[3007,88,24,0,0,7,44,10,1,36,3,46,7,3],
		[3008,20,24,0,11,7,46,16,0,10,46,6,6,2],
		[3009,67,24,0,2,7,45,29,1,14,41,10,8,2],
		[3010,67,24,0,2,7,45,29,1,14,41,27,7,2],
		[3011,88,24,0,0,7,44,34,1,37,56,35,7,1],
		[3012,88,24,0,0,7,42,53,1,58,13,48,7,5],
		[3013,37,15,0,80,7,47,30,0,33,24,56,6,7],
		[3014,88,24,0,0,7,46,2,1,6,46,21,6,5],
		[3015,67,24,0,4,7,45,57,1,14,33,50,6,3],
		[3016,88,24,0,0,7,45,5,1,37,53,16,8,1],
		[3017,88,24,0,0,7,45,15,1,37,58,7,5,5],
		[3018,88,24,0,0,7,45,35,1,34,10,23,6,4],
		[3019,88,24,0,0,7,46,45,1,12,40,31,7,2],
		[3020,88,24,0,0,7,45,18,1,43,45,8,7,1],
		[3021,37,24,0,82,7,48,34,0,23,8,28,7,4],
		[3022,88,24,0,0,7,46,10,1,37,56,2,7,1],
		[3023,88,24,0,0,7,47,13,1,22,31,11,7,1],
		[3024,86,5,0,0,7,41,49,1,72,36,22,5,5],
		[3025,88,24,0,0,7,46,33,1,40,3,35,8,1],
		[3026,88,24,0,0,7,47,39,1,15,59,27,7,5],
		[3027,88,24,0,0,7,47,45,1,16,0,52,7,7],
		[3028,88,24,0,0,7,51,6,0,54,7,45,7,3],
		[3029,67,24,0,5,7,47,57,1,12,11,35,6,3],
		[3030,88,24,0,0,7,49,2,0,13,22,15,7,5],
		[3031,88,24,0,0,7,45,36,1,56,43,21,7,3],
		[3032,88,24,0,0,7,47,6,1,39,19,53,7,1],
		[3033,88,24,0,0,7,48,59,0,4,19,58,8,4],
		[3034,67,14,0,0,7,48,5,1,25,56,14,6,1],
		[3035,88,24,0,0,7,47,25,1,38,30,40,6,1],
		[3036,88,24,0,0,7,44,44,1,66,4,19,7,4],
		[3037,88,24,0,0,7,47,32,1,46,36,31,6,1],
		[3038,88,24,0,0,7,44,13,1,69,49,17,7,2],
		[3039,88,24,0,0,7,52,37,0,55,12,34,7,2],
		[3040,88,24,0,0,7,51,2,0,33,14,1,7,2],
		[3041,88,24,0,0,7,48,9,1,40,39,8,7,7],
		[3042,88,24,0,0,7,49,29,1,13,21,12,7,1],
		[3043,88,24,0,0,7,49,2,1,24,54,44,6,4],
		[3044,67,24,0,6,7,49,41,1,17,13,42,6,5],
		[3045,67,13,0,7,7,49,18,1,24,51,35,4,4],
		[3046,88,24,0,0,7,48,20,1,47,4,40,6,5],
		[3047,88,24,0,0,7,50,11,1,9,11,0,7,5],
		[3048,88,24,0,0,7,49,45,1,20,12,25,8,4],
		[3049,88,24,0,0,7,49,15,1,35,14,36,7,1],
		[3050,88,24,0,0,7,50,47,0,3,16,38,7,5],
		[3051,88,24,0,0,7,50,6,1,19,31,25,7,5],
		[3052,88,24,0,0,7,49,35,1,33,17,20,7,5],
		[3053,88,24,0,0,7,51,57,0,19,19,31,7,5],
		[3054,88,24,0,0,7,50,55,1,11,7,43,7,5],
		[3055,88,24,0,0,7,49,14,1,46,22,24,5,1],
		[3056,88,24,0,0,7,48,19,1,56,28,16,7,5],
		[3057,88,24,0,0,7,49,28,1,44,45,7,7,5],
		[3058,88,24,0,0,7,49,13,1,46,51,28,7,1],
		[3059,20,5,0,13,7,51,42,0,1,46,1,6,1],
		[3060,88,24,0,0,7,51,0,1,24,31,42,7,2],
		[3061,88,24,0,0,7,52,7,0,3,16,38,7,7],
		[3062,88,24,0,0,7,49,7,1,56,24,38,7,4],
		[3063,67,24,0,8,7,51,41,1,12,49,10,7,3],
		[3064,67,24,0,9,7,51,46,1,13,53,53,6,4],
		[3065,50,24,0,25,7,54,29,0,47,23,10,7,5],
		[3066,50,24,0,26,7,54,43,0,47,33,53,6,5],
		[3067,37,20,0,83,7,53,30,0,26,45,57,6,2],
		[3068,88,24,0,0,7,51,43,1,21,10,26,7,4],
		[3069,88,24,0,0,7,50,42,1,44,34,47,7,4],
		[3070,88,24,0,0,7,49,13,1,60,17,1,7,3],
		[3071,88,24,0,0,7,50,24,1,50,30,35,7,5],
		[3072,88,24,0,0,7,52,48,1,5,25,41,7,3],
		[3073,67,24,0,10,7,52,19,1,14,50,47,7,3],
		[3074,88,24,0,0,7,51,21,1,43,5,44,7,1],
		[3075,88,24,0,0,8,0,12,0,73,55,5,6,5],
		[3076,88,24,0,0,7,49,55,1,60,3,4,8,5],
		[3077,88,24,0,0,7,56,27,0,56,30,16,8,2],
		[3078,88,24,0,0,7,51,40,1,42,53,18,7,1],
		[3079,88,24,0,0,7,52,16,1,34,42,19,6,3],
		[3080,88,24,0,0,7,52,13,1,40,34,33,5,5],
		[3081,88,24,0,0,7,49,41,1,66,11,45,7,1],
		[3082,88,24,0,0,8,4,47,0,79,28,47,6,2],
		[3083,88,24,0,0,7,55,41,0,35,24,46,7,2],
		[3084,88,24,0,0,7,52,39,1,38,51,47,5,1],
		[3085,88,24,0,0,7,53,4,1,36,21,50,6,5],
		[3086,37,24,0,85,7,55,40,0,19,53,2,6,2],
		[3087,88,24,0,0,7,55,31,0,8,51,46,7,3],
		[3088,88,24,0,0,7,52,30,1,54,22,2,7,1],
		[3089,88,24,0,0,7,53,4,1,49,36,47,6,1],
		[3090,88,24,0,0,7,53,18,1,48,6,11,5,1],
		[3091,88,24,0,0,7,54,11,1,35,52,39,6,1],
		[3092,88,24,0,0,7,54,40,1,34,50,49,7,5],
		[3093,88,24,0,0,7,56,24,0,4,29,9,7,4],
		[3094,88,24,0,0,7,58,17,0,43,58,39,7,5],
		[3095,21,24,0,1,7,56,59,0,15,47,25,7,5],
		[3096,88,24,0,0,7,55,14,1,30,55,3,7,5],
		[3097,88,24,0,0,7,57,16,0,8,38,29,7,5],
		[3098,88,24,0,0,7,57,16,0,1,7,37,7,3],
		[3099,88,24,0,0,7,56,23,1,30,17,7,7,7],
		[3100,88,24,0,0,7,55,1,1,52,34,59,7,1],
		[3101,88,24,0,0,7,55,47,1,43,50,42,7,1],
		[3102,67,24,0,11,7,56,52,1,22,52,48,5,3],
		[3103,88,24,0,0,7,58,6,0,7,12,49,7,2],
		[3104,88,24,0,0,7,58,32,0,16,31,7,7,5],
		[3105,88,24,0,0,7,54,53,1,57,18,11,7,5],
		[3106,88,24,0,0,8,1,21,0,59,2,51,7,3],
		[3107,88,24,0,0,7,56,24,1,40,44,11,8,1],
		[3108,88,24,0,0,8,16,54,0,84,3,28,7,2],
		[3109,10,24,0,53,8,1,42,0,60,19,28,7,2],
		[3110,20,24,0,14,7,58,21,0,2,13,29,6,5],
		[3111,88,24,0,0,7,56,58,1,42,24,22,7,5],
		[3112,88,24,0,0,8,2,31,0,63,5,25,7,4],
		[3113,88,24,0,0,7,57,40,1,30,20,5,6,2],
		[3114,88,24,0,0,7,56,58,1,43,30,1,6,1],
		[3115,88,24,0,0,7,59,35,0,13,14,32,7,5],
		[3116,88,24,0,0,7,57,18,1,44,6,35,6,1],
		[3117,12,21,0,0,7,56,47,1,52,58,56,4,1],
		[3118,88,24,0,0,7,57,20,1,47,53,25,7,1],
		[3119,88,24,0,0,8,2,36,0,57,16,25,7,3],
		[3120,88,24,0,0,7,56,19,1,60,31,35,7,5],
		[3121,88,24,0,0,7,57,52,1,45,34,40,6,5],
		[3122,54,24,0,27,7,59,44,1,3,40,47,6,5],
		[3123,67,24,0,12,7,59,6,1,23,18,38,6,5],
		[3124,21,23,1,2,8,0,56,0,25,23,34,7,4],
		[3125,88,24,0,0,8,0,48,0,19,48,58,7,5],
		[3126,88,24,0,0,7,56,51,1,59,7,35,7,7],
		[3127,88,24,0,0,8,1,1,0,23,34,59,7,5],
		[3128,21,24,0,3,8,0,47,0,17,18,31,7,5],
		[3129,88,24,0,0,7,58,14,1,49,14,42,5,1],
		[3130,88,24,0,0,8,1,55,0,35,24,47,7,5],
		[3131,88,24,0,0,7,59,52,1,18,23,57,6,2],
		[3132,21,23,2,4,8,1,44,0,25,5,23,7,2],
		[3133,88,24,0,0,7,58,21,1,51,26,55,7,2],
		[3134,21,24,0,5,8,1,30,0,16,27,19,7,1],
		[3135,88,24,0,0,8,0,44,1,2,52,54,8,1],
		[3136,88,24,0,0,8,1,14,0,4,52,47,7,2],
		[3137,88,24,0,0,7,59,2,1,45,12,58,7,1],
		[3138,88,24,0,0,7,57,47,1,60,18,12,7,4],
		[3139,88,24,0,0,7,57,13,1,63,17,49,7,1],
		[3140,88,24,0,0,7,59,28,1,39,17,50,6,3],
		[3141,54,24,0,28,8,1,13,1,1,23,33,6,5],
		[3142,88,24,0,0,7,59,12,1,49,58,36,7,1],
		[3143,88,24,0,0,7,59,13,1,49,58,25,7,1],
		[3144,88,24,0,0,8,1,51,0,8,54,50,7,4],
		[3145,88,24,0,0,8,2,16,0,2,20,4,5,5],
		[3146,88,24,0,0,8,0,20,1,45,27,25,8,5],
		[3147,88,24,0,0,7,58,51,1,60,49,28,7,1],
		[3148,88,24,0,0,8,0,15,1,48,58,53,7,2],
		[3149,37,21,0,0,8,3,31,0,27,47,39,6,5],
		[3150,88,24,0,0,8,2,26,1,6,20,14,7,4],
		[3151,88,24,0,0,8,0,29,1,48,52,17,7,2],
		[3152,88,24,0,0,7,59,40,1,60,12,27,7,1],
		[3153,88,24,0,0,7,59,38,1,60,35,13,6,7],
		[3154,88,24,0,0,8,1,37,1,37,17,1,7,2],
		[3155,88,24,0,0,8,2,6,1,37,3,2,7,7],
		[3156,88,24,0,0,8,0,50,1,54,9,5,7,1],
		[3157,88,24,0,0,8,1,23,1,54,30,54,7,1],
		[3158,88,24,0,0,8,4,45,0,18,50,32,7,1],
		[3159,88,24,0,0,8,0,20,1,63,34,3,6,1],
		[3160,88,24,0,0,8,3,4,1,32,27,50,7,5],
		[3161,88,24,0,0,8,1,32,1,55,27,18,7,1],
		[3162,88,24,0,0,8,2,45,1,41,18,36,7,1],
		[3163,21,24,0,8,8,5,5,0,13,7,5,6,2],
		[3164,88,24,0,0,8,5,37,0,27,31,47,7,2],
		[3165,67,5,0,0,8,3,35,1,40,0,12,3,0],
		[3166,88,24,0,0,8,3,30,1,42,56,55,7,4],
		[3167,50,24,0,28,8,7,10,0,43,15,37,7,2],
		[3168,67,24,0,14,8,4,42,1,19,43,41,7,1],
		[3169,21,11,1,9,8,6,18,0,22,38,8,7,7],
		[3170,88,24,0,0,8,4,16,1,32,40,30,6,7],
		[3171,88,24,0,0,7,59,16,1,73,14,41,7,2],
		[3172,88,24,0,0,8,5,50,1,0,34,25,7,5],
		[3173,50,24,0,27,8,8,27,0,51,30,24,6,2],
		[3174,88,24,0,0,8,6,28,1,9,14,42,7,1],
		[3175,88,24,0,0,8,10,4,0,58,14,53,7,5],
		[3176,21,11,2,10,8,7,46,0,21,34,54,6,4],
		[3177,88,24,0,0,8,5,45,1,33,34,9,7,4],
		[3178,88,24,0,0,8,4,42,1,50,35,26,7,4],
		[3179,88,24,0,0,8,5,20,1,46,58,44,7,1],
		[3180,88,24,0,0,8,5,4,1,53,6,29,7,5],
		[3181,88,24,0,0,8,9,23,0,42,25,50,7,5],
		[3182,88,24,0,0,8,12,49,0,68,28,27,6,4],
		[3183,88,24,0,0,8,7,18,1,20,33,17,6,2],
		[3184,21,24,0,12,8,8,42,0,13,38,27,7,3],
		[3185,67,16,0,15,8,7,33,1,24,18,15,4,3],
		[3186,88,24,0,0,8,4,43,1,62,50,10,7,1],
		[3187,88,24,0,0,8,6,40,1,45,15,59,6,5],
		[3188,54,5,0,29,8,8,36,1,2,59,2,5,4],
		[3189,88,24,0,0,8,8,57,1,11,20,23,7,2],
		[3190,88,24,0,0,8,8,44,1,20,21,47,7,2],
		[3191,21,22,0,14,8,10,27,0,25,30,26,7,4],
		[3192,67,24,0,16,8,9,2,1,19,14,42,5,1],
		[3193,88,24,0,0,8,11,22,0,38,43,53,8,4],
		[3194,88,24,0,0,8,9,29,1,16,14,56,7,1],
		[3195,88,24,0,0,8,8,38,1,37,40,53,7,1],
		[3196,88,24,0,0,8,9,7,1,30,19,21,8,5],
		[3197,88,24,0,0,8,24,33,0,82,25,51,7,2],
		[3198,88,24,0,0,8,10,59,0,14,37,46,7,2],
		[3199,88,24,0,0,8,9,10,1,35,27,18,7,4],
		[3200,88,24,0,0,8,13,50,0,56,27,8,7,4],
		[3201,88,24,0,0,8,11,17,0,9,49,16,7,1],
		[3202,67,24,0,18,8,10,40,1,13,47,57,7,3],
		[3203,88,24,0,0,8,9,10,1,48,41,4,7,1],
		[3204,88,24,0,0,8,9,36,1,44,7,22,6,1],
		[3205,88,24,0,0,8,9,48,1,42,38,26,7,1],
		[3206,84,2,1,0,8,9,29,1,47,20,45,5,1],
		[3207,84,2,2,0,8,9,32,1,47,20,12,3,0],
		[3208,21,5,1,16,8,12,13,0,17,38,52,7,3],
		[3209,21,5,1,16,8,12,13,0,17,38,52,7,3],
		[3210,21,5,2,16,8,12,13,0,17,38,52,7,4],
		[3211,67,24,0,19,8,11,16,1,12,55,37,6,4],
		[3212,88,24,0,0,8,11,33,1,7,46,21,6,4],
		[3213,88,24,0,0,8,9,43,1,47,56,15,6,1],
		[3214,88,24,0,0,8,12,22,0,14,0,14,8,2],
		[3215,21,24,0,15,8,13,9,0,29,39,24,7,1],
		[3216,88,24,0,0,8,19,32,0,75,45,25,7,4],
		[3217,88,24,0,0,8,8,25,1,63,48,4,7,1],
		[3218,88,24,0,0,8,9,34,1,56,5,8,7,2],
		[3219,88,24,0,0,8,11,2,1,37,17,32,7,0],
		[3220,88,24,0,0,8,9,1,1,61,18,9,6,3],
		[3221,88,24,0,0,8,15,51,0,60,22,50,7,2],
		[3222,88,24,0,0,8,12,60,0,16,30,51,7,4],
		[3223,86,4,0,0,8,7,56,1,68,37,2,5,1],
		[3224,88,24,0,0,8,13,42,0,23,8,16,8,2],
		[3225,88,24,0,0,8,11,22,1,39,37,7,5,5],
		[3226,88,24,0,0,8,11,26,1,42,59,14,6,2],
		[3227,88,24,0,0,8,11,11,1,48,27,43,7,1],
		[3228,88,24,0,0,8,14,11,0,17,40,33,7,2],
		[3229,67,24,0,20,8,13,20,1,15,47,18,6,4],
		[3230,88,24,0,0,8,12,46,1,29,54,39,8,2],
		[3231,88,24,0,0,8,14,21,0,13,2,54,7,4],
		[3232,88,24,0,0,8,12,0,1,46,38,39,7,3],
		[3233,88,24,0,0,8,12,52,1,37,55,28,7,2],
		[3234,88,24,0,0,8,12,31,1,46,15,51,7,1],
		[3235,50,24,0,29,8,17,50,0,59,34,16,7,2],
		[3236,88,24,0,0,8,20,40,0,72,24,26,7,7],
		[3237,88,24,0,0,8,13,30,1,35,53,59,6,1],
		[3238,88,24,0,0,8,13,41,1,33,34,9,7,5],
		[3239,88,24,0,0,8,14,11,1,32,8,27,7,1],
		[3240,88,24,0,0,8,13,58,1,36,19,21,6,1],
		[3241,88,24,0,0,8,13,59,1,36,20,28,7,1],
		[3242,88,24,0,0,8,14,13,1,35,29,26,7,5],
		[3243,88,24,0,0,8,14,3,1,40,20,53,5,5],
		[3244,88,24,0,0,8,13,36,1,46,59,31,6,1],
		[3245,88,24,0,0,8,19,17,0,62,30,26,7,4],
		[3246,88,24,0,0,8,18,16,0,54,8,37,7,5],
		[3247,88,24,0,0,8,13,34,1,50,11,46,7,7],
		[3248,88,24,0,0,8,16,34,0,11,43,35,8,7],
		[3249,21,1,0,17,8,16,31,0,9,11,8,5,5],
		[3250,88,24,0,0,8,14,24,1,45,50,4,7,1],
		[3251,88,24,0,0,8,15,53,1,30,55,33,7,4],
		[3252,88,24,0,0,8,17,32,0,8,51,58,7,4],
		[3253,88,24,0,0,8,15,59,1,35,54,10,7,5],
		[3254,50,24,0,30,8,20,26,0,57,44,36,7,3],
		[3255,88,24,0,0,8,16,54,1,21,19,13,8,2],
		[3256,88,24,0,0,8,15,23,1,50,26,58,7,5],
		[3257,67,24,0,21,8,17,23,1,16,17,6,7,2],
		[3258,88,24,0,0,8,20,29,0,53,34,28,7,3],
		[3259,88,24,0,0,8,18,24,1,12,37,55,7,4],
		[3260,88,24,0,0,8,15,16,1,62,54,57,6,2],
		[3261,88,24,0,0,8,17,58,1,30,0,12,7,5],
		[3262,21,21,0,18,8,20,4,0,27,13,4,6,3],
		[3263,88,24,0,0,8,22,44,0,60,37,52,7,5],
		[3264,88,24,0,0,8,20,21,0,20,44,52,7,5],
		[3265,88,24,0,0,8,19,15,1,10,9,57,7,3],
		[3266,88,24,0,0,8,18,17,1,35,27,6,7,5],
		[3267,88,24,0,0,8,18,13,1,37,22,27,8,2],
		[3268,21,10,0,19,8,20,32,0,24,1,20,7,1],
		[3269,88,24,0,0,8,19,50,0,3,56,52,7,4],
		[3270,88,24,0,0,8,18,33,1,36,39,34,5,2],
		[3271,88,24,0,0,8,20,13,1,0,54,34,7,3],
		[3272,88,24,0,0,8,20,17,1,5,19,45,7,5],
		[3273,88,24,0,0,8,19,29,1,34,35,25,7,1],
		[3274,88,24,0,0,8,17,56,1,59,10,1,7,3],
		[3275,50,24,0,31,8,22,50,0,43,11,17,5,5],
		[3276,88,24,0,0,8,20,27,1,22,55,29,7,5],
		[3277,88,24,0,0,8,23,49,0,53,13,11,7,2],
		[3278,88,24,0,0,8,21,20,1,1,36,8,8,2],
		[3279,88,24,0,0,8,21,21,1,20,4,45,7,4],
		[3280,88,24,0,0,8,18,19,1,65,36,48,6,5],
		[3281,88,24,0,0,8,21,55,1,17,35,11,7,5],
		[3282,88,24,0,0,8,21,23,1,33,3,16,6,5],
		[3283,88,24,0,0,8,21,21,1,36,29,4,6,1],
		[3284,21,24,0,20,8,23,22,0,18,19,56,7,2],
		[3285,88,24,0,0,8,22,30,1,6,10,45,7,2],
		[3286,88,24,0,0,8,21,24,1,39,37,15,7,2],
		[3287,88,24,0,0,8,24,43,0,42,0,18,7,5],
		[3288,88,24,0,0,8,22,54,1,7,32,36,7,7],
		[3289,67,24,0,22,8,22,47,1,13,3,17,7,4],
		[3290,21,24,0,21,8,23,55,0,10,37,55,7,7],
		[3291,88,24,0,0,8,22,50,1,26,20,53,7,3],
		[3292,88,24,0,0,8,25,5,0,35,0,41,7,5],
		[3293,88,24,0,0,8,21,12,1,57,58,23,7,1],
		[3294,88,24,0,0,8,22,32,1,48,29,25,6,1],
		[3295,88,24,0,0,8,24,36,1,4,43,1,7,3],
		[3296,88,24,0,0,8,23,17,1,38,17,9,7,7],
		[3297,41,24,0,1,8,24,35,1,3,45,4,7,3],
		[3298,88,24,0,0,8,21,8,1,64,6,22,7,4],
		[3299,21,24,0,25,8,25,50,0,17,2,46,7,3],
		[3300,88,24,0,0,8,22,55,1,52,7,26,7,2],
		[3301,86,9,1,0,8,19,49,1,71,30,54,6,1],
		[3302,86,9,2,0,8,20,1,1,71,30,19,7,2],
		[3303,88,24,0,0,8,29,46,0,67,17,51,7,4],
		[3304,21,20,1,22,8,26,28,0,27,53,37,7,5],
		[3305,88,24,0,0,8,25,36,0,2,6,8,7,5],
		[3306,88,24,0,0,8,25,55,0,7,33,52,6,4],
		[3307,12,4,0,0,8,22,31,1,59,30,35,3,5],
		[3308,88,24,0,0,8,24,55,1,23,9,13,7,2],
		[3309,88,24,0,0,8,27,37,0,45,39,11,7,4],
		[3310,21,20,2,23,8,26,47,0,26,56,4,7,2],
		[3311,21,20,2,23,8,26,47,0,26,56,7,7,2],
		[3312,21,24,0,24,8,26,40,0,24,32,3,8,3],
		[3313,21,24,0,24,8,26,40,0,24,32,7,9,3],
		[3314,88,24,0,0,8,25,40,1,3,54,23,5,2],
		[3315,88,24,0,0,8,25,4,1,24,2,46,6,5],
		[3316,88,24,0,0,8,25,19,1,21,2,45,7,3],
		[3317,88,24,0,0,8,25,39,1,17,26,22,7,5],
		[3318,17,0,0,0,8,18,32,1,76,55,11,5,3],
		[3319,21,24,0,27,8,26,44,0,12,39,16,7,7],
		[3320,88,24,0,0,8,25,56,1,14,55,47,7,2],
		[3321,41,24,0,2,8,26,27,1,3,59,15,7,2],
		[3322,88,24,0,0,8,24,57,1,42,46,10,7,1],
		[3323,82,14,0,1,8,30,16,0,60,43,5,4,4],
		[3324,88,24,0,0,8,26,42,1,12,32,4,7,5],
		[3325,88,24,0,0,8,27,17,1,6,24,35,8,3],
		[3326,88,24,0,0,8,25,52,1,42,9,12,6,1],
		[3327,88,24,0,0,8,26,18,1,39,3,34,8,1],
		[3328,88,24,0,0,8,26,18,1,39,3,37,8,2],
		[3329,21,24,0,28,8,28,37,0,24,8,41,7,3],
		[3330,88,24,0,0,8,25,31,1,51,43,41,6,1],
		[3331,88,24,0,0,8,26,51,1,29,12,55,8,1],
		[3332,88,24,0,0,8,32,53,0,69,19,12,7,5],
		[3333,21,24,0,29,8,28,37,0,14,12,39,7,2],
		[3334,86,6,0,0,8,22,4,1,73,24,0,6,2],
		[3335,88,24,0,0,8,27,33,1,20,50,38,8,2],
		[3336,88,24,0,0,8,27,16,1,31,40,23,7,4],
		[3337,88,24,0,0,8,28,29,1,2,31,2,7,2],
		[3338,88,24,0,0,8,28,20,1,8,48,58,7,5],
		[3339,88,24,0,0,8,27,54,1,26,7,57,8,2],
		[3340,17,7,0,0,8,20,39,1,77,29,4,5,5],
		[3341,88,24,0,0,8,26,25,1,52,48,27,7,2],
		[3342,88,24,0,0,8,28,51,1,9,44,54,7,3],
		[3343,88,24,0,0,8,27,59,1,35,6,50,7,1],
		[3344,88,24,0,0,8,28,36,1,23,4,18,8,2],
		[3345,88,24,0,0,8,28,53,1,20,57,1,8,1],
		[3346,88,24,0,0,8,25,52,1,64,36,3,7,4],
		[3347,86,1,0,0,8,25,44,1,66,8,13,5,5],
		[3348,88,24,0,0,8,31,20,0,37,15,57,7,2],
		[3349,88,24,0,0,8,27,27,1,55,0,42,8,2],
		[3350,88,24,0,0,8,27,37,1,53,5,19,6,2],
		[3351,88,24,0,0,8,32,34,0,53,6,53,7,5],
		[3352,88,24,0,0,8,36,49,0,74,43,25,7,2],
		[3353,88,24,0,0,8,29,28,1,27,19,57,8,1],
		[3354,82,24,0,2,8,34,36,0,65,8,42,6,2],
		[3355,21,19,1,30,8,31,31,0,24,4,52,7,3],
		[3356,88,24,0,0,8,29,8,1,44,9,38,7,1],
		[3357,21,7,0,31,8,31,36,0,18,5,40,6,5],
		[3358,88,24,0,0,8,29,5,1,47,55,45,6,1],
		[3359,88,24,0,0,8,29,28,1,44,43,30,6,1],
		[3360,88,24,0,0,8,32,55,0,38,0,59,7,5],
		[3361,88,24,0,0,8,31,55,0,9,48,52,8,1],
		[3362,88,24,0,0,8,30,29,1,32,9,34,7,5],
		[3363,88,24,0,0,8,29,46,1,46,19,55,7,1],
		[3364,88,24,0,0,8,30,30,1,36,43,16,8,7],
		[3365,50,24,0,32,8,33,22,0,36,26,11,7,3],
		[3366,21,6,0,33,8,32,43,0,20,26,28,6,5],
		[3367,88,24,0,0,8,31,31,1,19,34,39,6,2],
		[3368,88,24,0,0,8,29,36,1,55,11,28,7,4],
		[3369,21,19,2,32,8,33,0,0,24,5,5,7,4],
		[3370,88,24,0,0,8,27,17,1,70,5,36,7,2],
		[3371,88,24,0,0,8,30,39,1,44,44,14,7,1],
		[3372,21,24,0,34,8,32,40,0,10,3,58,7,2],
		[3373,88,24,0,0,8,31,25,1,39,3,51,7,1],
		[3374,88,24,0,0,8,32,33,1,15,1,46,7,3],
		[3375,88,24,0,0,8,31,11,1,47,52,0,7,1],
		[3376,88,24,0,0,8,33,45,0,13,15,26,7,5],
		[3377,50,24,0,33,8,34,44,0,36,25,10,7,2],
		[3378,88,24,0,0,8,33,44,0,4,45,24,7,4],
		[3379,88,24,0,0,8,39,43,0,73,37,47,7,4],
		[3380,88,24,0,0,8,34,13,0,8,27,7,7,3],
		[3381,88,24,0,0,8,33,5,1,24,36,23,7,2],
		[3382,88,24,0,0,8,31,30,1,54,23,39,7,5],
		[3383,88,24,0,0,8,34,2,1,2,9,6,7,2],
		[3384,88,24,0,0,8,32,52,1,31,30,3,7,5],
		[3385,88,24,0,0,8,32,59,1,34,38,2,7,5],
		[3386,88,24,0,0,8,32,5,1,53,12,44,7,5],
		[3387,21,24,0,35,8,35,19,0,19,35,24,8,4],
		[3388,88,24,0,0,8,33,20,1,38,22,16,7,1],
		[3389,88,24,0,0,8,33,38,1,38,50,56,7,1],
		[3390,88,24,0,0,8,33,30,1,46,58,16,7,5],
		[3391,82,15,1,3,8,39,12,0,65,1,15,7,4],
		[3392,88,24,0,0,8,35,25,0,2,44,37,7,4],
		[3393,88,24,0,0,8,24,20,1,80,54,51,7,4],
		[3394,88,24,0,0,8,36,8,0,15,18,49,7,3],
		[3395,88,24,0,0,8,35,51,0,6,37,12,7,3],
		[3396,88,24,0,0,8,35,51,0,6,37,21,8,4],
		[3397,88,24,0,0,8,34,32,1,32,35,55,7,4],
		[3398,41,24,0,3,8,35,28,1,7,58,56,7,2],
		[3399,88,24,0,0,8,34,29,1,37,36,41,7,5],
		[3400,88,24,0,0,8,38,22,0,53,24,5,7,4],
		[3401,88,24,0,0,8,39,10,0,59,56,22,7,2],
		[3402,88,24,0,0,8,35,29,1,26,50,37,7,2],
		[3403,82,15,2,4,8,40,13,0,64,19,40,6,5],
		[3404,88,24,0,0,8,35,13,1,39,58,12,7,4],
		[3405,88,24,0,0,8,39,0,0,52,55,30,7,5],
		[3406,21,24,0,36,8,37,6,0,9,39,20,7,2],
		[3407,88,24,0,0,8,34,44,1,49,56,39,6,5],
		[3408,88,24,0,0,8,39,18,0,52,42,42,7,5],
		[3409,88,24,0,0,8,38,19,0,32,48,7,7,5],
		[3410,41,3,0,4,8,37,39,0,5,42,13,5,2],
		[3411,88,24,0,0,8,37,27,1,4,56,1,7,5],
		[3412,21,24,0,37,8,38,5,0,9,34,29,8,2],
		[3413,88,24,0,0,8,35,52,1,50,58,12,7,1],
		[3414,88,24,0,0,8,35,20,1,58,0,33,6,5],
		[3415,88,24,0,0,8,35,15,1,58,13,30,6,1],
		[3416,88,24,0,0,8,38,20,1,6,39,45,8,2],
		[3417,88,24,0,0,8,32,42,1,73,21,24,7,4],
		[3418,41,17,0,5,8,38,45,0,3,20,29,5,5],
		[3419,88,24,0,0,8,37,30,1,33,44,45,7,3],
		[3420,68,6,0,0,8,37,52,1,26,15,18,6,2],
		[3421,88,24,0,0,8,37,20,1,40,8,51,8,4],
		[3422,50,24,0,34,8,41,1,0,45,50,2,6,4],
		[3423,88,24,0,0,8,40,18,0,31,56,31,7,3],
		[3424,88,24,0,0,8,39,25,0,8,1,2,7,5],
		[3425,88,24,0,0,8,38,40,1,19,44,13,7,5],
		[3426,88,24,0,0,8,37,39,1,42,59,21,5,2],
		[3427,21,24,0,39,8,40,6,0,20,0,28,7,4],
		[3428,88,24,0,0,8,40,22,0,19,40,12,7,4],
		[3429,21,4,0,41,8,40,27,0,19,32,42,7,2],
		[3430,88,24,0,0,8,39,8,1,22,39,43,6,4],
		[3431,41,24,0,6,8,40,2,1,12,28,31,6,5],
		[3432,88,24,0,0,8,37,19,1,62,51,13,6,5],
		[3433,68,5,0,0,8,39,43,1,29,33,40,6,4],
		[3434,88,24,0,0,8,39,22,1,36,36,25,7,3],
		[3435,88,24,0,0,8,38,45,1,53,5,26,7,1],
		[3436,88,24,0,0,8,43,0,0,46,54,4,7,4],
		[3437,88,24,0,0,8,41,2,1,9,3,7,8,2],
		[3438,68,1,0,0,8,40,6,1,35,18,30,5,4],
		[3439,88,24,0,0,8,40,19,1,40,15,51,6,1],
		[3440,88,24,0,0,8,39,24,1,53,26,23,6,1],
		[3441,41,24,0,9,8,41,43,1,15,56,36,6,4],
		[3442,88,24,0,0,8,39,58,1,53,3,18,6,1],
		[3443,88,24,0,0,8,39,13,1,60,19,2,7,2],
		[3444,88,24,0,0,8,40,35,1,45,11,29,7,7],
		[3445,88,24,0,0,8,40,38,1,46,38,56,5,3],
		[3446,88,24,0,0,8,42,10,1,11,57,58,7,2],
		[3447,88,24,0,0,8,40,18,1,52,55,19,5,1],
		[3448,88,24,0,0,8,40,17,1,53,0,55,7,1],
		[3449,21,2,0,43,8,43,17,0,21,28,7,6,2],
		[3450,21,24,0,45,8,43,12,0,12,40,51,7,2],
		[3451,88,24,0,0,8,44,10,0,36,55,5,7,3],
		[3452,88,24,0,0,8,41,13,1,47,19,1,6,2],
		[3453,88,24,0,0,8,41,5,1,48,55,21,7,1],
		[3454,41,6,0,7,8,43,14,0,3,23,55,5,1],
		[3455,88,24,0,0,8,40,44,1,57,32,43,7,2],
		[3456,88,24,0,0,8,41,57,1,45,24,39,6,1],
		[3457,88,24,0,0,8,40,37,1,59,45,40,5,1],
		[3458,88,24,0,0,8,43,60,0,4,20,5,7,1],
		[3459,88,24,0,0,8,43,40,1,7,14,1,6,4],
		[3460,86,7,0,0,8,39,5,1,70,23,13,6,2],
		[3461,21,3,0,47,8,44,41,0,18,9,15,5,5],
		[3462,88,24,0,0,8,42,16,1,48,5,57,7,1],
		[3463,88,24,0,0,8,42,57,1,35,56,36,7,2],
		[3464,21,24,0,46,8,45,21,0,30,41,52,7,4],
		[3465,21,24,0,49,8,44,45,0,10,4,54,7,2],
		[3466,88,24,0,0,8,42,19,1,53,6,0,7,1],
		[3467,88,24,0,0,8,42,26,1,53,6,50,6,1],
		[3468,68,0,0,0,8,43,36,1,33,11,11,5,1],
		[3469,41,24,0,10,8,45,1,0,5,40,50,7,2],
		[3470,88,24,0,0,8,48,49,0,66,42,29,7,1],
		[3471,88,24,0,0,8,42,21,1,55,46,27,7,5],
		[3472,88,24,0,0,8,45,21,1,2,36,3,7,3],
		[3473,88,24,0,0,8,44,55,1,21,10,4,7,2],
		[3474,21,8,0,48,8,46,40,0,28,45,55,8,2],
		[3475,21,8,0,48,8,46,42,0,28,45,36,5,4],
		[3476,88,24,0,0,8,43,40,1,49,49,22,6,1],
		[3477,88,24,0,0,8,44,24,1,42,38,57,5,4],
		[3478,88,24,0,0,8,46,3,1,2,2,56,7,5],
		[3479,88,24,0,0,8,44,52,1,37,8,50,7,1],
		[3480,88,24,0,0,8,46,7,1,11,0,23,7,5],
		[3481,21,24,0,50,8,46,56,0,12,6,36,7,2],
		[3482,41,4,0,11,8,46,47,0,6,25,8,4,4],
		[3483,88,24,0,0,8,45,49,1,25,23,15,7,2],
		[3484,41,24,0,12,8,46,23,1,13,32,52,5,4],
		[3485,84,3,0,0,8,44,42,1,54,42,30,3,2],
		[3486,88,24,0,0,8,47,15,1,1,53,50,6,2],
		[3487,88,24,0,0,8,46,2,1,46,2,30,5,2],
		[3488,88,24,0,0,8,46,24,1,41,7,32,7,1],
		[3489,88,24,0,0,8,45,5,1,58,43,30,7,1],
		[3490,88,24,0,0,8,46,49,1,34,37,22,7,1],
		[3491,88,24,0,0,8,43,54,1,68,12,42,7,5],
		[3492,41,16,0,13,8,48,26,0,5,50,16,5,2],
		[3493,88,24,0,0,8,48,5,1,6,33,31,7,5],
		[3494,88,24,0,0,8,46,31,1,45,54,46,6,1],
		[3495,88,24,0,0,8,44,30,1,65,49,32,7,2],
		[3496,88,24,0,0,8,47,19,1,46,9,20,7,3],
		[3497,88,24,0,0,8,47,41,1,41,44,14,7,4],
		[3498,88,24,0,0,8,46,43,1,56,46,11,5,1],
		[3499,88,24,0,0,8,50,32,0,33,17,7,7,3],
		[3500,41,24,0,14,8,49,22,1,3,26,35,6,1],
		[3501,88,24,0,0,8,48,9,1,42,27,50,7,1],
		[3502,17,6,0,0,8,41,20,1,78,57,48,6,1],
		[3503,88,24,0,0,8,48,0,1,52,51,2,7,1],
		[3504,88,24,0,0,8,50,45,0,18,49,56,7,2],
		[3505,82,24,0,5,8,53,23,0,61,57,44,7,3],
		[3506,88,24,0,0,8,53,6,0,59,3,22,7,3],
		[3507,88,24,0,0,8,49,45,1,21,2,55,7,2],
		[3508,50,24,0,35,8,51,57,0,43,43,36,6,5],
		[3509,88,24,0,0,8,52,12,0,45,18,45,7,5],
		[3510,21,24,0,54,8,51,2,0,15,21,2,7,4],
		[3511,88,24,0,0,8,52,10,0,42,0,9,7,5],
		[3512,88,24,0,0,8,49,52,1,32,46,50,6,4],
		[3513,88,24,0,0,8,50,2,1,29,27,47,7,4],
		[3514,88,24,0,0,8,49,39,1,40,19,14,6,2],
		[3516,88,24,0,0,8,50,22,1,28,37,5,7,1],
		[3517,88,24,0,0,8,49,52,1,39,8,30,7,2],
		[3518,68,2,0,0,8,50,32,1,27,42,36,5,5],
		[3519,21,17,1,51,8,52,35,0,32,28,27,7,2],
		[3520,88,24,0,0,8,49,48,1,45,18,29,6,2],
		[3521,21,24,0,53,8,52,29,0,28,15,33,7,7],
		[3522,21,16,1,55,8,52,36,0,28,19,51,7,4],
		[3523,41,24,0,15,8,51,35,1,7,10,38,7,2],
		[3524,88,24,0,0,8,43,12,1,79,4,11,7,2],
		[3525,88,24,0,0,8,50,21,1,42,5,24,7,1],
		[3526,88,24,0,0,8,52,24,0,5,20,24,7,2],
		[3527,88,24,0,0,8,50,34,1,46,31,45,6,1],
		[3528,88,24,0,0,8,53,56,0,35,32,18,7,2],
		[3529,88,24,0,0,8,52,31,1,13,14,1,7,5],
		[3530,88,24,0,0,8,51,28,1,42,30,16,8,2],
		[3531,82,24,0,6,8,56,38,0,64,36,14,7,4],
		[3532,21,24,0,57,8,54,15,0,30,34,46,6,4],
		[3533,88,24,0,0,8,52,26,1,32,30,33,8,5],
		[3534,88,24,0,0,8,52,39,1,36,32,44,7,4],
		[3535,88,24,0,0,8,52,48,1,38,43,27,7,7],
		[3536,88,24,0,0,8,51,37,1,57,38,1,7,1],
		[3537,88,24,0,0,8,50,35,1,66,47,35,6,3],
		[3538,88,24,0,0,8,54,18,1,5,26,4,7,4],
		[3539,88,24,0,0,8,52,39,1,48,21,33,7,1],
		[3540,21,16,2,58,8,55,40,0,27,55,39,6,4],
		[3541,88,24,0,0,8,55,23,0,17,13,53,8,6],
		[3542,88,24,0,0,8,52,41,1,52,7,45,7,2],
		[3543,88,24,0,0,8,45,55,1,79,30,16,7,5],
		[3544,88,24,0,0,8,49,50,1,72,33,3,7,2],
		[3545,88,24,0,0,8,56,50,0,45,37,55,7,5],
		[3546,88,24,0,0,8,56,31,0,40,12,6,7,3],
		[3547,41,5,0,16,8,55,24,0,5,56,44,4,4],
		[3548,88,24,0,0,8,53,51,1,40,26,51,7,5],
		[3549,88,24,0,0,8,53,4,1,56,38,58,7,2],
		[3550,21,24,0,60,8,55,56,0,11,37,34,6,5],
		[3551,88,24,0,0,8,53,51,1,47,31,15,6,2],
		[3552,41,24,0,17,8,55,30,1,7,58,13,8,2],
		[3553,41,24,0,17,8,55,30,1,7,58,16,8,2],
		[3554,88,24,0,0,8,55,12,1,18,14,29,7,5],
		[3555,21,17,2,59,8,56,57,0,32,54,37,6,2],
		[3556,68,3,0,0,8,55,32,1,27,40,55,6,2],
		[3557,88,24,0,0,8,56,37,0,4,14,12,7,4],
		[3558,88,24,0,0,8,57,8,0,17,8,38,7,5],
		[3559,88,24,0,0,8,55,56,1,23,49,6,7,2],
		[3560,88,24,0,0,8,53,49,1,60,21,15,7,1],
		[3561,21,14,1,62,8,57,15,0,15,19,22,6,2],
		[3562,88,24,0,0,8,55,19,1,45,2,30,7,1],
		[3563,21,24,0,61,8,57,59,0,30,14,1,7,3],
		[3564,88,24,0,0,8,56,34,1,16,42,34,7,5],
		[3565,21,14,2,63,8,57,35,0,15,34,53,7,3],
		[3566,88,24,0,0,8,58,28,0,35,48,9,8,2],
		[3567,88,24,0,0,8,57,42,0,9,23,16,7,4],
		[3568,88,24,0,0,8,54,54,1,58,14,24,7,1],
		[3569,82,8,0,9,8,59,12,0,48,2,30,4,2],
		[3570,88,24,0,0,8,55,12,1,54,57,56,7,3],
		[3571,88,24,0,0,8,55,3,1,60,38,41,5,1],
		[3572,21,0,0,65,8,58,29,0,11,51,28,5,2],
		[3573,88,24,0,0,8,58,8,0,1,32,30,8,2],
		[3574,88,24,0,0,8,56,19,1,52,43,25,6,1],
		[3575,21,17,3,64,8,59,33,0,32,25,7,6,4],
		[3576,82,16,0,8,9,2,33,0,67,37,47,6,7],
		[3577,88,24,0,0,8,59,11,0,18,8,5,7,7],
		[3578,88,24,0,0,8,58,44,1,16,7,58,7,3],
		[3579,88,24,0,0,9,0,38,0,41,46,58,5,3],
		[3580,88,24,0,0,9,0,31,0,37,36,16,7,5],
		[3581,88,24,0,0,9,15,21,0,84,10,52,7,3],
		[3582,88,24,0,0,8,56,58,1,59,13,46,6,1],
		[3583,88,24,0,0,8,57,56,1,48,34,24,7,4],
		[3584,88,24,0,0,8,59,40,1,19,12,29,7,3],
		[3585,88,24,0,0,8,59,16,1,28,48,22,7,4],
		[3586,88,24,0,0,9,1,41,0,39,42,48,7,2],
		[3587,21,24,0,66,9,1,24,0,32,15,9,7,2],
		[3588,88,24,0,0,8,58,52,1,47,14,5,6,2],
		[3589,21,24,0,67,9,1,49,0,27,54,10,7,2],
		[3590,88,24,0,0,9,1,31,0,5,38,27,7,5],
		[3591,88,24,0,0,9,0,5,1,41,15,14,5,4],
		[3592,88,24,0,0,9,4,0,0,54,17,2,7,2],
		[3593,88,24,0,0,9,0,22,1,43,10,24,7,1],
		[3594,82,9,0,12,9,3,38,0,47,9,24,5,2],
		[3595,21,12,0,69,9,2,44,0,24,27,10,6,2],
		[3596,88,24,0,0,9,1,58,1,0,28,58,7,5],
		[3597,88,24,0,0,9,1,11,1,26,39,50,7,5],
		[3598,88,24,0,0,8,59,24,1,59,5,1,6,3],
		[3599,88,24,0,0,9,2,45,0,7,17,53,7,5],
		[3600,88,24,0,0,9,1,21,1,41,51,52,7,1],
		[3601,21,24,0,70,9,4,10,0,27,53,54,7,2],
		[3602,88,24,0,0,9,2,6,1,39,24,9,7,5],
		[3603,88,24,0,0,9,5,24,0,48,31,49,7,3],
		[3604,88,24,0,0,9,0,46,1,60,57,50,7,4],
		[3605,88,24,0,0,9,1,45,1,52,11,18,6,1],
		[3606,88,24,0,0,9,4,55,0,32,22,37,7,2],
		[3607,88,24,0,0,9,3,9,1,25,30,16,8,1],
		[3608,88,24,0,0,9,6,43,0,59,20,40,7,2],
		[3609,82,17,1,11,9,8,24,0,66,52,24,6,5],
		[3610,88,24,0,0,9,1,9,1,68,41,2,7,7],
		[3611,88,24,0,0,9,3,5,1,53,32,59,7,1],
		[3612,88,24,0,0,9,6,32,0,38,27,8,6,4],
		[3613,41,23,0,18,9,5,58,0,5,5,32,6,5],
		[3614,88,24,0,0,9,4,9,1,47,5,52,5,5],
		[3615,86,0,0,0,9,2,27,1,66,23,46,5,2],
		[3616,82,17,2,13,9,10,23,0,67,8,5,6,3],
		[3617,88,24,0,0,9,7,27,0,22,58,52,7,3],
		[3618,88,24,0,0,9,6,60,0,1,27,46,7,7],
		[3619,82,24,0,15,9,8,52,0,51,36,17,5,3],
		[3620,88,24,0,0,9,8,4,0,32,32,26,8,3],
		[3621,21,18,0,72,9,8,0,0,29,39,15,6,4],
		[3622,88,24,0,0,9,4,48,1,57,51,9,7,2],
		[3623,21,9,0,76,9,7,45,0,10,40,5,6,1],
		[3624,82,18,0,14,9,10,55,0,63,30,49,6,3],
		[3625,88,24,0,0,9,8,51,0,33,52,56,7,3],
		[3626,21,24,0,75,9,8,47,0,26,37,45,7,4],
		[3627,21,13,0,77,9,9,22,0,22,2,44,6,4],
		[3628,68,9,0,0,9,8,3,1,25,51,30,6,5],
		[3629,88,24,0,0,9,6,34,1,55,48,12,7,1],
		[3630,41,24,0,19,9,8,42,1,8,35,22,7,1],
		[3631,88,24,0,0,9,7,15,1,51,12,43,8,5],
		[3632,88,24,0,0,9,6,8,1,64,29,59,7,5],
		[3633,88,24,0,0,9,14,3,0,71,39,21,8,4],
		[3634,84,10,0,0,9,7,60,1,43,25,57,3,5],
		[3635,88,24,0,0,9,9,46,0,11,33,52,7,3],
		[3636,88,24,0,0,9,9,12,1,12,21,28,7,4],
		[3637,88,24,0,0,9,8,44,1,26,46,4,7,2],
		[3638,88,24,0,0,9,9,4,1,18,19,43,7,2],
		[3639,88,24,0,0,9,10,39,0,30,57,47,7,7],
		[3640,21,24,0,79,9,10,21,0,21,59,47,7,4],
		[3641,41,24,0,20,9,9,36,1,8,47,16,6,4],
		[3642,88,24,0,0,9,5,38,1,70,32,20,6,1],
		[3643,88,24,0,0,9,5,9,1,72,36,10,5,3],
		[3644,68,4,0,0,9,9,56,1,30,21,55,7,2],
		[3645,88,24,0,0,9,15,53,0,72,56,46,7,3],
		[3646,88,24,0,0,9,10,23,1,23,10,36,8,2],
		[3647,88,24,0,0,9,9,45,1,49,25,29,7,2],
		[3648,82,24,0,16,9,14,21,0,61,25,24,6,3],
		[3649,88,24,0,0,9,11,56,0,5,28,6,7,2],
		[3650,21,15,1,81,9,12,18,0,14,59,46,8,4],
		[3651,88,24,0,0,9,12,13,0,3,52,2,7,2],
		[3652,50,24,0,36,9,13,48,0,43,13,4,6,1],
		[3653,88,24,0,0,9,11,59,1,19,44,52,7,4],
		[3654,88,24,0,0,9,11,4,1,44,52,5,6,1],
		[3655,41,24,0,21,9,12,26,1,7,6,35,7,2],
		[3656,88,24,0,0,9,11,41,1,39,15,32,7,1],
		[3657,88,24,0,0,9,13,37,0,21,17,0,7,2],
		[3658,88,24,0,0,9,11,33,1,46,35,2,7,1],
		[3659,88,24,0,0,9,10,58,1,58,58,1,4,1],
		[3660,82,24,0,17,9,15,50,0,56,44,29,6,5],
		[3661,88,24,0,0,9,12,31,1,43,36,49,7,1],
		[3662,82,24,0,18,9,16,11,0,54,1,19,6,2],
		[3663,88,24,0,0,9,11,17,1,62,19,2,5,1],
		[3664,88,24,0,0,9,15,14,0,34,38,1,7,4],
		[3665,41,7,0,22,9,14,22,0,2,18,51,5,1],
		[3666,88,24,0,0,9,19,56,0,74,0,59,8,4],
		[3667,88,24,0,0,9,13,26,1,38,36,59,7,2],
		[3668,88,24,0,0,9,13,19,1,42,16,25,7,5],
		[3669,21,15,2,82,9,15,14,0,14,56,29,6,5],
		[3670,88,24,0,0,9,13,35,1,47,20,19,7,1],
		[3672,88,24,0,0,9,14,8,1,44,8,45,7,1],
		[3673,88,24,0,0,9,12,56,1,59,24,52,7,4],
		[3674,88,24,0,0,9,14,25,1,43,13,39,6,1],
		[3675,88,24,0,0,9,15,25,1,15,1,29,7,2],
		[3676,88,24,0,0,9,17,31,0,46,49,2,7,2],
		[3677,88,24,0,0,9,14,57,1,37,36,9,7,4],
		[3678,57,5,0,0,8,56,41,1,85,39,47,6,2],
		[3679,88,24,0,0,9,14,18,1,55,34,11,6,4],
		[3680,88,24,0,0,9,15,15,1,45,33,20,7,1],
		[3681,41,24,0,23,9,16,42,1,6,21,11,6,5],
		[3682,88,24,0,0,9,15,37,1,38,34,12,6,5],
		[3683,41,24,0,24,9,16,41,1,8,44,41,6,1],
		[3684,88,24,0,0,9,15,45,1,37,24,48,6,3],
		[3685,12,1,0,0,9,13,12,1,69,43,2,3,2],
		[3686,88,24,0,0,9,18,26,0,35,21,51,7,2],
		[3687,88,24,0,0,9,17,8,1,14,34,25,7,5],
		[3688,88,24,0,0,9,16,4,1,44,53,55,7,2],
		[3689,88,24,0,0,9,17,51,0,11,30,4,7,2],
		[3690,50,24,0,38,9,18,51,0,36,48,9,5,2],
		[3691,88,24,0,0,9,15,18,1,58,23,19,7,1],
		[3692,88,24,0,0,9,16,23,1,44,15,57,6,5],
		[3693,88,24,0,0,9,15,35,1,57,34,41,7,4],
		[3694,88,24,0,0,9,16,57,1,39,24,5,6,5],
		[3695,88,24,0,0,9,12,12,1,76,39,47,7,5],
		[3696,88,24,0,0,9,16,12,1,57,32,29,5,7],
		[3697,88,24,0,0,9,20,44,0,51,15,58,7,3],
		[3698,88,24,0,0,9,21,43,0,56,41,57,6,7],
		[3699,12,8,0,0,9,17,5,1,59,16,31,3,2],
		[3700,88,24,0,0,9,17,42,1,54,29,43,7,5],
		[3701,88,24,0,0,9,20,59,0,38,11,18,7,3],
		[3702,88,24,0,0,9,19,34,1,11,18,51,8,2],
		[3703,88,24,0,0,9,18,6,1,51,3,4,6,1],
		[3704,88,24,0,0,9,19,33,1,15,50,4,7,5],
		[3705,50,0,0,40,9,21,3,0,34,23,33,4,5],
		[3706,41,24,0,26,9,19,46,1,11,58,30,6,4],
		[3707,88,24,0,0,9,21,27,0,32,54,7,7,5],
		[3708,88,24,0,0,9,18,42,1,51,33,38,7,1],
		[3709,41,24,0,27,9,20,29,1,9,33,21,6,4],
		[3710,88,24,0,0,9,19,48,1,34,6,12,7,1],
		[3711,88,24,0,0,9,21,15,0,15,22,16,8,2],
		[3712,88,24,0,0,9,17,17,1,68,41,22,6,3],
		[3713,88,24,0,0,9,17,52,1,67,3,3,7,5],
		[3714,88,24,0,0,9,20,56,1,15,37,4,7,3],
		[3715,88,24,0,0,9,20,44,1,31,45,38,8,1],
		[3716,88,24,0,0,9,20,30,1,37,34,53,7,5],
		[3717,88,24,0,0,9,19,33,1,55,11,12,7,1],
		[3718,68,7,0,0,9,21,30,1,25,57,56,6,7],
		[3719,88,24,0,0,9,27,52,0,75,5,54,7,2],
		[3720,88,24,0,0,9,17,25,1,74,53,40,6,2],
		[3721,88,24,0,0,9,17,27,1,74,44,5,7,2],
		[3722,88,24,0,0,9,25,44,0,63,56,27,7,5],
		[3723,88,24,0,0,9,23,32,0,25,10,59,7,4],
		[3724,88,24,0,0,9,22,51,1,9,50,20,8,2],
		[3725,88,24,0,0,9,24,56,0,51,34,26,7,4],
		[3726,88,24,0,0,9,21,51,1,42,11,42,7,7],
		[3727,88,24,0,0,9,24,23,0,36,35,13,8,3],
		[3728,88,24,0,0,9,20,57,1,62,24,17,6,4],
		[3729,88,24,0,0,9,22,37,1,39,46,29,8,5],
		[3730,88,24,0,0,9,22,24,1,46,2,51,7,4],
		[3731,45,9,0,1,9,24,39,0,26,10,56,5,5],
		[3732,88,24,0,0,9,21,50,1,55,30,54,7,2],
		[3733,68,10,0,0,9,23,12,1,28,50,2,6,4],
		[3734,84,9,0,0,9,22,7,1,55,0,39,4,1],
		[3735,88,24,0,0,9,23,45,1,37,45,26,7,2],
		[3736,88,24,0,0,9,25,33,0,16,35,8,7,4],
		[3737,88,24,0,0,9,24,16,1,39,25,33,7,2],
		[3738,41,24,0,28,9,25,24,1,5,7,3,7,5],
		[3739,88,24,0,0,9,23,60,1,51,44,14,7,2],
		[3740,88,24,0,0,9,23,27,1,60,18,9,7,5],
		[3741,88,24,0,0,9,26,22,1,1,27,50,7,5],
		[3742,88,24,0,0,9,24,6,1,61,38,56,7,5],
		[3743,88,24,0,0,9,28,40,0,45,36,5,6,5],
		[3744,41,24,0,29,9,27,15,1,9,13,25,8,2],
		[3745,88,24,0,0,9,26,45,1,28,47,15,7,1],
		[3746,88,24,0,0,9,26,29,1,40,30,7,7,2],
		[3747,88,24,0,0,9,29,48,0,55,44,44,7,3],
		[3748,41,0,0,30,9,27,35,1,8,39,31,3,5],
		[3749,88,24,0,0,9,27,18,1,22,20,38,6,5],
		[3750,88,24,0,0,9,27,47,1,6,4,16,6,4],
		[3751,88,24,0,0,9,37,5,0,81,19,35,5,5],
		[3752,88,24,0,0,9,25,27,1,61,57,1,7,2],
		[3753,88,24,0,0,9,26,18,1,53,22,45,6,1],
		[3754,45,23,0,2,9,28,28,0,9,3,24,6,3],
		[3755,45,24,0,3,9,28,29,0,8,11,18,7,5],
		[3756,88,24,0,0,9,27,38,1,35,0,28,8,2],
		[3757,82,24,0,23,9,31,32,0,63,3,43,5,3],
		[3758,88,24,0,0,9,29,2,1,1,15,25,7,3],
		[3759,41,18,1,31,9,29,9,1,2,46,8,6,3],
		[3760,88,24,0,0,9,29,25,1,2,12,19,7,3],
		[3761,88,24,0,0,9,26,44,1,64,55,47,7,2],
		[3762,88,24,0,0,9,29,32,1,4,14,50,7,4],
		[3763,88,24,0,0,9,29,13,1,20,44,55,7,7],
		[3764,48,24,0,7,9,30,43,0,33,39,20,7,4],
		[3765,1,4,0,0,9,29,15,1,35,57,5,6,5],
		[3766,88,24,0,0,9,29,16,1,38,24,14,7,2],
		[3767,88,24,0,0,9,29,50,1,23,20,43,7,5],
		[3768,82,24,0,22,9,34,54,0,72,12,20,7,3],
		[3769,48,24,0,8,9,31,32,0,35,6,11,6,7],
		[3770,88,24,0,0,9,29,55,1,26,35,23,6,5],
		[3771,82,24,0,24,9,34,29,0,69,49,49,6,4],
		[3772,88,24,0,0,9,30,23,1,15,34,38,7,5],
		[3773,45,10,0,4,9,31,43,0,22,58,5,5,5],
		[3774,88,24,0,0,9,36,7,0,74,19,4,7,1],
		[3775,82,7,0,25,9,32,51,0,51,40,38,4,3],
		[3776,88,24,0,0,9,28,47,1,62,16,23,7,5],
		[3777,88,24,0,0,9,27,6,1,71,36,8,6,5],
		[3778,88,24,0,0,9,33,7,0,49,26,19,8,2],
		[3779,45,24,0,6,9,31,58,0,9,42,57,6,5],
		[3780,1,5,1,0,9,30,45,1,31,53,29,8,2],
		[3781,1,5,1,0,9,30,46,1,31,53,22,7,2],
		[3782,45,13,0,5,9,31,57,0,11,17,59,6,5],
		[3783,88,24,0,0,9,28,31,1,66,42,7,7,2],
		[3784,88,24,0,0,9,30,5,1,51,31,2,6,1],
		[3785,88,24,0,0,9,31,39,1,10,33,8,7,3],
		[3786,84,22,0,0,9,30,42,1,40,28,0,5,3],
		[3787,41,18,2,32,9,31,59,1,1,11,6,6,2],
		[3788,88,24,0,0,9,31,56,1,10,22,14,7,5],
		[3789,1,5,2,0,9,31,32,1,31,52,19,7,2],
		[3790,88,24,0,0,9,31,33,1,35,42,54,7,5],
		[3791,48,24,0,9,9,33,30,0,36,29,13,7,5],
		[3792,88,24,0,0,9,33,18,0,28,22,5,8,2],
		[3793,88,24,0,0,9,30,23,1,58,21,42,7,7],
		[3794,88,24,0,0,9,32,41,0,1,51,51,7,3],
		[3795,17,8,0,0,9,24,9,1,80,47,13,6,3],
		[3796,88,24,0,0,9,32,20,1,19,24,1,7,2],
		[3797,88,24,0,0,9,34,20,0,46,54,8,8,3],
		[3798,88,24,0,0,9,32,19,1,28,37,41,7,2],
		[3799,82,24,0,26,9,34,50,0,52,3,5,6,2],
		[3800,48,24,0,10,9,34,13,0,36,23,51,6,4],
		[3801,88,24,0,0,9,33,2,1,8,30,19,7,5],
		[3802,88,24,0,0,9,32,56,1,13,31,1,7,5],
		[3803,88,24,0,0,9,31,13,1,57,2,4,4,5],
		[3804,88,24,0,0,9,33,59,0,23,27,14,7,5],
		[3805,88,24,0,0,9,33,20,1,7,11,24,7,5],
		[3806,88,24,0,0,9,37,56,0,73,4,50,7,3],
		[3807,88,24,0,0,9,32,19,1,40,38,58,6,4],
		[3808,88,24,0,0,9,33,13,1,21,6,57,6,5],
		[3809,88,24,0,0,9,35,4,0,39,37,17,6,4],
		[3810,88,24,0,0,9,33,26,1,22,51,50,7,2],
		[3811,88,24,0,0,9,35,22,0,39,57,48,8,3],
		[3812,88,24,0,0,9,33,8,1,39,7,44,7,3],
		[3813,88,24,0,0,9,31,33,1,66,43,10,7,5],
		[3814,41,24,0,33,9,34,33,1,5,54,54,7,5],
		[3815,48,24,0,11,9,35,40,0,35,48,37,6,4],
		[3816,88,24,0,0,9,32,15,1,62,47,20,7,7],
		[3817,88,24,0,0,9,33,45,1,49,0,18,6,1],
		[3818,45,24,0,7,9,35,53,0,14,22,47,7,2],
		[3819,88,24,0,0,9,34,9,1,51,15,19,6,1],
		[3820,88,24,0,0,9,36,43,0,31,9,42,7,7],
		[3821,88,24,0,0,9,31,36,1,73,4,51,6,5],
		[3822,88,24,0,0,9,35,34,1,19,35,1,7,2],
		[3823,88,24,0,0,9,35,12,1,35,49,26,7,3],
		[3824,88,24,0,0,9,39,28,0,67,16,20,7,5],
		[3825,88,24,0,0,9,34,27,1,59,13,46,5,1],
		[3826,45,24,0,8,9,37,3,0,16,26,16,7,5],
		[3827,45,24,0,10,9,37,13,0,6,50,9,6,5],
		[3828,88,24,0,0,9,36,34,1,24,42,10,8,3],
		[3829,50,24,0,42,9,38,22,0,40,14,23,6,3],
		[3830,88,24,0,0,9,37,0,1,25,17,48,7,5],
		[3831,88,24,0,0,9,36,25,1,48,45,5,7,2],
		[3832,41,24,0,34,9,37,52,1,9,25,28,7,2],
		[3833,88,24,0,0,9,37,10,1,32,10,43,7,5],
		[3834,88,24,0,0,9,38,27,0,4,38,57,6,5],
		[3835,88,24,0,0,9,37,28,1,36,5,45,7,5],
		[3836,88,24,0,0,9,36,50,1,49,21,19,5,2],
		[3837,88,24,0,0,9,36,46,1,52,56,39,7,5],
		[3838,88,24,0,0,9,42,15,0,69,14,15,7,4],
		[3839,82,24,0,27,9,42,57,0,72,15,9,6,5],
		[3840,88,24,0,0,9,37,12,1,53,40,7,6,2],
		[3841,88,24,0,0,9,36,5,1,64,57,2,8,2],
		[3842,88,24,0,0,9,38,2,1,43,11,28,7,4],
		[3843,88,24,0,0,9,45,31,0,78,8,5,7,5],
		[3844,88,24,0,0,9,38,41,1,39,36,51,8,3],
		[3845,41,8,0,35,9,39,51,1,1,8,34,5,5],
		[3846,41,24,0,37,9,39,47,1,10,34,13,7,2],
		[3847,88,24,0,0,9,47,18,0,79,8,12,7,3],
		[3848,88,24,0,0,9,40,20,1,10,46,9,7,2],
		[3849,41,9,0,38,9,40,18,1,14,19,56,6,1],
		[3850,88,24,0,0,9,41,35,0,31,16,41,7,5],
		[3851,50,24,0,43,9,42,0,0,39,45,28,7,4],
		[3852,45,14,0,14,9,41,9,0,9,53,32,5,3],
		[3853,45,24,0,13,9,41,39,0,25,54,46,7,5],
		[3854,88,24,0,0,9,42,43,0,48,25,52,7,2],
		[3855,88,24,0,0,9,43,7,0,54,21,49,7,2],
		[3856,88,24,0,0,9,39,21,1,61,19,41,6,1],
		[3857,48,24,0,13,9,42,43,0,35,5,36,7,3],
		[3858,88,24,0,0,9,41,17,1,23,35,30,6,1],
		[3859,88,24,0,0,9,44,37,0,64,59,2,7,3],
		[3860,17,5,0,0,9,33,53,1,80,56,29,6,1],
		[3861,45,24,0,15,9,43,33,0,29,58,28,7,2],
		[3862,88,24,0,0,9,42,14,1,23,54,56,6,3],
		[3863,88,24,0,0,9,40,43,1,57,59,1,6,2],
		[3864,88,24,0,0,9,41,2,1,57,15,35,7,5],
		[3865,82,24,0,28,9,45,55,0,63,39,12,7,3],
		[3866,45,22,0,16,9,43,44,0,14,1,18,6,7],
		[3867,88,24,0,0,9,42,41,1,35,30,6,7,2],
		[3868,88,24,0,0,9,41,48,1,55,12,51,7,1],
		[3869,88,24,0,0,9,44,30,0,18,51,49,8,5],
		[3870,88,24,0,0,9,46,32,0,57,7,41,6,7],
		[3871,1,7,0,0,9,44,12,1,27,46,10,6,2],
		[3872,88,24,0,0,9,43,28,1,51,13,42,7,1],
		[3873,45,4,0,17,9,45,51,0,23,46,27,4,4],
		[3874,88,24,0,0,9,44,16,1,39,34,16,8,3],
		[3875,88,24,0,0,9,43,42,1,53,53,30,7,2],
		[3876,88,24,0,0,9,46,10,0,6,42,31,7,7],
		[3877,45,24,0,18,9,46,23,0,11,48,36,7,5],
		[3878,88,24,0,0,9,45,22,1,30,12,10,7,1],
		[3879,88,24,0,0,9,46,24,0,1,47,8,7,3],
		[3880,45,24,0,19,9,47,26,0,11,34,6,7,2],
		[3881,88,24,0,0,9,48,35,0,46,1,16,6,4],
		[3882,88,24,0,0,9,47,34,0,11,25,44,7,7],
		[3883,88,24,0,0,9,45,41,1,57,11,8,7,1],
		[3884,88,24,0,0,9,45,15,1,62,30,28,5,4],
		[3885,88,24,0,0,9,50,24,0,65,35,36,7,2],
		[3886,88,24,0,0,9,46,30,1,44,45,18,7,1],
		[3887,88,24,0,0,9,45,55,1,58,47,39,7,3],
		[3888,82,19,0,29,9,50,59,0,59,2,19,5,3],
		[3889,45,24,0,20,9,49,50,0,21,10,46,7,2],
		[3890,12,19,0,0,9,47,6,1,65,4,19,4,2],
		[3891,12,19,0,0,9,47,7,1,65,4,21,7,1],
		[3892,88,24,0,0,9,49,28,1,37,11,11,7,5],
		[3893,74,24,0,4,9,50,30,0,4,20,37,7,3],
		[3894,82,20,0,30,9,52,6,0,54,3,52,6,2],
		[3895,88,24,0,0,9,48,40,1,56,24,43,7,5],
		[3896,45,24,0,23,9,51,2,0,13,3,58,7,7],
		[3897,88,24,0,0,9,49,51,1,36,16,7,7,5],
		[3898,88,24,0,0,9,49,57,1,45,43,58,6,1],
		[3899,74,24,0,6,9,51,14,1,4,14,36,7,2],
		[3900,45,24,0,22,9,51,53,0,24,23,43,6,2],
		[3901,88,24,0,0,9,51,22,1,6,10,54,7,3],
		[3902,17,12,0,0,9,46,21,1,76,46,34,6,4],
		[3903,41,19,1,39,9,51,29,1,14,50,48,5,4],
		[3904,88,24,0,0,9,50,42,1,46,56,4,7,5],
		[3905,45,11,0,24,9,52,46,0,26,0,25,5,5],
		[3906,74,24,0,7,9,52,12,0,2,27,15,7,2],
		[3907,88,24,0,0,9,52,12,0,0,4,32,7,4],
		[3908,88,24,0,0,9,51,60,1,16,32,5,7,5],
		[3909,74,2,0,8,9,52,30,1,8,6,18,6,2],
		[3910,88,24,0,0,9,51,20,1,46,11,38,7,5],
		[3911,88,24,0,0,9,55,3,0,61,6,58,7,5],
		[3912,88,24,0,0,9,51,41,1,46,32,52,6,4],
		[3913,88,24,0,0,9,51,12,1,59,25,33,7,5],
		[3914,88,24,0,0,9,50,56,1,62,44,43,7,5],
		[3915,88,24,0,0,9,53,43,0,5,57,30,7,7],
		[3916,88,24,0,0,9,52,58,1,27,19,56,7,4],
		[3917,82,24,0,31,9,55,43,0,49,49,12,6,2],
		[3918,88,24,0,0,9,58,23,0,72,52,46,7,5],
		[3919,88,24,0,0,9,54,12,1,25,55,57,6,5],
		[3920,88,24,0,0,9,53,0,1,55,22,24,7,1],
		[3921,88,24,0,0,9,54,32,1,22,29,18,7,2],
		[3922,88,24,0,0,9,57,14,0,57,25,6,7,4],
		[3923,88,24,0,0,9,54,52,1,19,0,34,6,7],
		[3924,88,24,0,0,9,53,50,1,51,8,49,7,1],
		[3925,88,24,0,0,9,54,18,1,45,17,2,7,1],
		[3926,88,24,0,0,9,56,26,0,8,55,59,7,5],
		[3927,88,24,0,0,9,54,51,1,50,14,38,7,2],
		[3928,48,24,0,19,9,57,41,0,41,3,20,6,3],
		[3929,88,24,0,0,9,57,57,0,45,24,52,7,5],
		[3930,88,24,0,0,9,56,5,1,40,49,29,7,7],
		[3931,88,24,0,0,9,56,47,1,26,33,1,7,2],
		[3932,88,24,0,0,9,56,36,1,33,25,7,7,5],
		[3933,88,24,0,0,9,56,54,1,27,28,30,7,2],
		[3934,88,24,0,0,10,8,34,0,83,55,6,7,5],
		[3935,88,24,0,0,9,56,22,1,51,20,10,7,1],
		[3936,88,24,0,0,9,58,26,0,27,45,32,7,3],
		[3937,45,12,0,27,9,58,13,0,12,26,41,6,1],
		[3938,88,24,0,0,9,58,8,0,8,18,51,7,5],
		[3939,88,24,0,0,9,59,52,0,56,48,43,6,5],
		[3940,84,20,0,0,9,56,52,1,54,34,4,5,1],
		[3941,88,24,0,0,9,57,11,1,52,38,20,7,1],
		[3942,88,24,0,0,9,59,36,0,29,38,43,7,4],
		[3943,88,24,0,0,9,57,43,1,48,24,52,7,1],
		[3944,88,24,0,0,9,56,10,1,71,23,22,7,1],
		[3945,74,24,0,12,9,59,43,0,3,23,5,8,3],
		[3946,88,24,0,0,9,59,6,1,23,57,1,7,1],
		[3947,1,6,0,0,9,58,52,1,35,53,28,6,3],
		[3948,88,24,0,0,9,57,15,1,64,29,22,8,5],
		[3949,88,24,0,0,9,56,60,1,69,6,7,7,1],
		[3950,45,15,0,29,10,0,13,0,8,2,39,6,7],
		[3951,48,24,0,20,10,1,1,0,31,55,25,6,4],
		[3952,88,24,0,0,10,2,49,0,21,56,57,7,1],
		[3953,88,24,0,0,10,0,34,1,56,56,48,8,5],
		[3954,88,24,0,0,10,4,36,0,53,53,30,7,3],
		[3955,88,24,0,0,10,1,41,1,53,21,52,7,1],
		[3956,88,24,0,0,10,2,49,1,30,34,39,8,5],
		[3957,88,24,0,0,10,1,58,1,57,20,59,7,5],
		[3958,88,24,0,0,10,5,11,0,52,22,15,7,2],
		[3959,88,24,0,0,10,3,41,1,9,34,26,7,5],
		[3960,88,24,0,0,10,2,0,1,60,25,15,7,2],
		[3961,74,24,0,13,10,4,8,0,3,12,4,7,3],
		[3962,88,24,0,0,10,3,41,1,25,19,0,8,2],
		[3963,88,24,0,0,10,4,3,1,18,6,6,7,2],
		[3964,88,24,0,0,10,3,21,1,46,38,10,7,2],
		[3965,88,24,0,0,10,4,21,1,24,17,8,7,2],
		[3966,88,24,0,0,10,2,60,1,60,10,43,7,2],
		[3967,88,24,0,0,10,2,49,1,62,9,23,7,5],
		[3968,88,24,0,0,10,4,23,1,39,58,33,7,5],
		[3969,88,24,0,0,10,5,41,0,15,45,27,7,3],
		[3970,41,19,2,40,10,5,8,1,13,3,53,6,1],
		[3971,88,24,0,0,10,3,34,1,61,53,2,7,1],
		[3972,88,24,0,0,10,5,15,1,36,23,2,7,5],
		[3973,74,24,0,14,10,6,47,0,5,36,41,7,5],
		[3974,48,24,0,21,10,7,26,0,35,14,41,5,2],
		[3975,45,6,0,30,10,7,20,0,16,45,46,5,2],
		[3976,88,24,0,0,10,6,11,1,47,22,12,6,5],
		[3977,88,24,0,0,10,7,10,1,17,8,30,7,5],
		[3978,88,24,0,0,10,6,7,1,52,11,17,8,5],
		[3979,88,24,0,0,10,8,16,0,31,36,15,7,3],
		[3980,45,24,0,31,10,7,54,0,9,59,51,5,5],
		[3981,74,0,0,15,10,7,56,1,0,22,18,5,2],
		[3982,45,0,0,32,10,8,22,0,11,58,2,2,1],
		[3983,17,11,1,0,10,0,44,1,82,12,53,7,2],
		[3984,88,24,0,0,10,8,2,1,37,20,1,7,5],
		[3985,88,24,0,0,10,8,46,1,10,53,5,8,2],
		[3986,88,24,0,0,10,8,36,1,15,36,42,7,2],
		[3987,88,24,0,0,10,10,59,0,40,39,41,7,5],
		[3988,88,24,0,0,10,9,57,1,12,5,45,7,2],
		[3989,74,24,0,17,10,10,8,1,8,24,30,7,2],
		[3990,88,24,0,0,10,8,56,1,51,48,40,6,1],
		[3991,88,24,0,0,10,10,6,1,12,48,58,6,3],
		[3992,88,24,0,0,10,9,32,1,35,51,24,7,3],
		[3993,88,24,0,0,10,11,13,0,37,24,7,7,5],
		[3994,41,10,0,41,10,10,35,1,12,21,15,5,5],
		[3995,88,24,0,0,10,8,43,1,65,48,55,6,5],
		[3996,74,24,0,18,10,10,56,1,8,25,6,7,5],
		[3997,17,11,2,0,10,4,8,1,81,33,57,8,4],
		[3998,45,24,0,34,10,11,38,0,13,21,18,7,3],
		[3999,88,24,0,0,10,9,22,1,61,32,57,7,7],
		[4000,88,24,0,0,10,11,18,1,7,19,0,7,2],
		[4001,88,24,0,0,10,10,38,1,41,42,54,7,5],
		[4002,88,24,0,0,10,9,31,1,68,41,0,7,2],
		[4003,88,24,0,0,10,12,3,1,28,36,23,7,2],
		[4004,74,24,0,19,10,12,48,0,4,36,53,7,5],
		[4005,88,24,0,0,10,12,38,1,19,9,13,7,3],
		[4006,88,24,0,0,10,13,50,0,27,8,9,7,4],
		[4007,88,24,0,0,10,11,35,1,58,49,41,7,7],
		[4008,88,24,0,0,10,15,8,0,59,59,8,7,7],
		[4009,88,24,0,0,10,11,47,1,58,3,38,7,1],
		[4010,88,24,0,0,10,12,23,1,52,9,48,7,5],
		[4011,88,24,0,0,10,13,19,1,27,1,44,7,2],
		[4012,88,24,0,0,10,14,30,0,21,10,4,7,3],
		[4013,88,24,0,0,10,13,25,1,33,1,55,7,4],
		[4014,48,24,0,22,10,15,6,0,31,28,5,7,4],
		[4015,88,24,0,0,10,13,46,1,40,20,45,7,5],
		[4016,88,24,0,0,10,18,1,0,73,4,24,7,3],
		[4017,88,24,0,0,10,13,23,1,51,14,0,6,2],
		[4018,88,24,0,0,10,13,1,1,59,55,5,7,1],
		[4019,88,24,0,0,10,13,57,1,40,18,38,7,4],
		[4020,88,24,0,0,10,13,28,1,51,45,22,7,2],
		[4021,88,24,0,0,10,17,51,0,71,3,38,8,2],
		[4022,88,24,0,0,10,13,21,1,61,39,32,7,1],
		[4023,88,24,0,0,10,14,44,1,42,7,19,5,2],
		[4024,48,24,0,23,10,16,14,0,29,18,38,6,2],
		[4025,88,24,0,0,10,13,31,1,66,22,23,6,2],
		[4026,82,24,0,32,10,18,2,0,65,6,30,7,2],
		[4027,48,24,0,24,10,16,28,0,28,40,57,7,4],
		[4028,88,24,0,0,10,16,16,0,17,44,25,8,2],
		[4029,88,24,0,0,10,15,21,1,36,31,5,7,5],
		[4030,45,24,0,35,10,16,32,0,23,30,11,7,4],
		[4031,45,5,0,36,10,16,41,0,23,25,2,4,3],
		[4032,88,24,0,0,10,16,42,0,25,22,17,7,5],
		[4033,82,10,0,33,10,17,6,0,42,54,52,4,2],
		[4034,88,24,0,0,10,16,9,1,11,12,12,7,5],
		[4035,45,24,0,37,10,16,41,0,13,43,42,6,7],
		[4036,88,24,0,0,10,15,32,1,43,6,45,7,5],
		[4037,12,23,0,0,10,13,44,1,70,2,17,4,1],
		[4038,88,24,0,0,10,15,17,1,54,58,27,7,1],
		[4039,45,24,0,39,10,17,15,0,23,6,22,7,3],
		[4040,88,24,0,0,10,16,46,1,20,40,14,8,3],
		[4041,88,24,0,0,10,18,10,0,27,24,55,8,2],
		[4042,74,4,0,22,10,17,38,1,8,4,8,6,3],
		[4043,88,24,0,0,10,16,3,1,59,54,12,7,2],
		[4044,88,24,0,0,10,18,59,0,46,45,39,7,5],
		[4045,88,24,0,0,10,16,40,1,51,12,18,7,7],
		[4046,88,24,0,0,10,19,27,0,48,23,49,7,5],
		[4047,88,24,0,0,10,21,3,0,68,44,51,7,2],
		[4048,88,24,0,0,10,19,1,0,24,42,42,7,5],
		[4049,88,24,0,0,10,18,8,1,28,59,31,6,2],
		[4050,88,24,0,0,10,17,5,1,61,19,56,4,5],
		[4051,88,24,0,0,10,20,15,0,53,46,45,7,3],
		[4052,88,24,0,0,10,20,31,0,54,13,1,7,5],
		[4053,88,24,0,0,10,18,38,1,36,48,17,7,5],
		[4054,45,24,0,40,10,19,44,0,19,28,15,6,3],
		[4055,88,24,0,0,10,19,17,1,12,31,41,7,2],
		[4056,88,24,0,0,10,18,28,1,41,40,6,7,1],
		[4057,45,2,1,41,10,19,58,0,19,50,30,4,5],
		[4058,45,2,2,41,10,19,59,0,19,50,26,5,4],
		[4059,88,24,0,0,10,19,32,1,5,6,21,7,5],
		[4060,88,24,0,0,10,19,59,1,9,3,32,7,3],
		[4061,88,24,0,0,10,18,38,1,56,6,36,7,3],
		[4062,88,24,0,0,10,29,42,0,84,15,8,7,3],
		[4063,88,24,0,0,10,19,37,1,55,1,46,6,5],
		[4064,74,24,0,23,10,21,2,0,2,17,23,8,1],
		[4065,88,24,0,0,10,19,5,1,64,40,35,7,2],
		[4066,88,24,0,0,10,20,17,1,47,41,57,7,5],
		[4067,88,24,0,0,10,22,11,0,41,13,46,7,3],
		[4068,88,24,0,0,10,21,8,1,17,59,6,8,3],
		[4069,82,11,0,34,10,22,20,0,41,29,58,4,7],
		[4070,45,24,0,42,10,21,50,0,14,58,32,7,2],
		[4071,88,24,0,0,10,21,29,1,23,42,39,8,2],
		[4072,88,24,0,0,10,24,8,0,65,33,59,6,2],
		[4073,88,24,0,0,10,21,36,1,22,31,42,8,2],
		[4074,88,24,0,0,10,20,55,1,56,2,35,6,1],
		[4075,48,24,0,27,10,23,6,0,33,54,29,7,2],
		[4076,88,24,0,0,10,22,13,1,19,52,1,7,2],
		[4077,45,24,0,43,10,23,0,0,6,32,33,7,5],
		[4078,88,24,0,0,10,23,42,0,29,36,57,7,4],
		[4079,88,24,0,0,10,23,15,0,5,41,39,8,3],
		[4080,88,24,0,0,10,22,20,1,41,39,0,6,5],
		[4081,48,24,0,28,10,24,9,0,33,43,7,7,5],
		[4082,74,24,0,25,10,23,27,1,4,4,27,7,1],
		[4083,88,24,0,0,10,23,13,1,30,9,44,7,3],
		[4084,88,24,0,0,10,31,5,0,82,33,31,6,3],
		[4085,88,24,0,0,10,24,13,0,2,22,5,7,4],
		[4086,88,24,0,0,10,23,29,1,38,0,36,6,2],
		[4087,88,24,0,0,10,23,40,1,41,57,12,7,4],
		[4088,45,24,0,44,10,25,15,0,8,47,5,7,7],
		[4089,88,24,0,0,10,22,58,1,66,54,6,6,1],
		[4090,48,24,0,30,10,25,55,0,33,47,46,6,3],
		[4091,88,24,0,0,10,23,51,1,57,57,14,7,5],
		[4092,88,24,0,0,10,25,44,1,7,3,35,7,5],
		[4093,88,24,0,0,10,25,17,1,42,28,5,7,4],
		[4094,41,11,0,42,10,26,5,1,16,50,11,5,5],
		[4095,88,24,0,0,10,24,59,1,58,34,35,7,3],
		[4096,88,24,0,0,10,27,28,0,41,36,3,7,2],
		[4097,88,24,0,0,10,27,1,0,19,21,52,7,5],
		[4098,88,24,0,0,10,28,4,0,48,47,5,7,3],
		[4099,88,24,0,0,10,26,10,1,42,44,20,7,5],
		[4100,48,1,0,31,10,27,53,0,36,42,26,5,4],
		[4101,45,24,0,45,10,27,39,0,9,45,45,7,2],
		[4102,88,24,0,0,10,24,24,1,74,1,54,5,3],
		[4103,88,24,0,0,10,28,37,0,45,12,44,7,5],
		[4104,1,0,0,0,10,27,9,1,31,4,4,5,5],
		[4105,88,24,0,0,10,24,44,1,73,58,18,7,2],
		[4106,82,24,0,35,10,29,54,0,65,37,34,7,5],
		[4107,88,24,0,0,10,26,49,1,54,52,39,7,5],
		[4108,88,24,0,0,10,30,27,0,64,15,27,7,2],
		[4109,88,24,0,0,10,28,44,1,3,44,33,7,2],
		[4110,88,24,0,0,10,27,24,1,57,38,20,6,2],
		[4111,88,24,0,0,10,28,2,1,49,24,20,7,5],
		[4112,82,24,0,36,10,30,38,0,55,58,50,6,3],
		[4113,48,24,0,32,10,30,6,0,38,55,31,7,2],
		[4114,88,24,0,0,10,27,53,1,58,44,22,5,3],
		[4115,88,24,0,0,10,27,25,1,65,42,17,7,2],
		[4116,74,3,0,29,10,29,29,1,2,44,21,6,1],
		[4117,88,24,0,0,10,29,29,1,29,39,49,7,5],
		[4118,1,3,0,0,10,29,35,1,30,36,26,7,1],
		[4119,74,1,0,30,10,30,18,1,0,38,13,6,1],
		[4120,88,24,0,0,10,28,53,1,64,10,20,6,7],
		[4121,88,24,0,0,10,36,2,0,80,29,40,8,4],
		[4122,88,24,0,0,10,30,59,1,7,38,15,7,5],
		[4123,88,24,0,0,10,30,60,1,13,35,18,7,1],
		[4124,48,24,0,33,10,31,51,0,32,22,46,7,2],
		[4125,88,24,0,0,10,30,51,1,26,29,2,8,3],
		[4126,88,24,0,0,10,35,6,0,75,42,47,6,4],
		[4127,45,24,0,46,10,32,12,0,14,8,14,6,7],
		[4128,88,24,0,0,10,30,39,1,61,21,22,7,7],
		[4129,88,24,0,0,10,30,9,1,66,59,6,7,1],
		[4130,88,24,0,0,10,31,49,1,28,14,15,7,3],
		[4131,88,24,0,0,10,33,44,0,53,29,51,7,2],
		[4132,88,24,0,0,10,33,14,0,40,25,32,6,2],
		[4133,45,16,0,47,10,32,49,0,9,18,24,5,1],
		[4134,88,24,0,0,10,31,22,1,53,42,56,6,3],
		[4135,88,24,0,0,10,31,58,1,45,4,0,7,1],
		[4136,88,24,0,0,10,31,57,1,45,4,10,7,1],
		[4137,48,24,0,34,10,33,31,0,34,59,19,7,2],
		[4138,88,24,0,0,10,30,20,1,71,59,35,6,2],
		[4139,88,24,0,0,10,32,34,1,44,37,8,7,4],
		[4140,88,24,0,0,10,32,1,1,61,41,7,4,1],
		[4141,82,24,0,37,10,35,10,0,57,4,58,6,3],
		[4142,88,24,0,0,10,31,2,1,73,13,18,6,5],
		[4143,88,24,0,0,10,32,57,1,47,0,12,6,5],
		[4144,88,24,0,0,10,32,48,1,58,40,1,7,2],
		[4145,41,24,0,44,10,34,1,1,23,44,43,6,5],
		[4146,45,24,0,48,10,34,48,0,6,57,13,6,4],
		[4147,88,24,0,0,10,33,25,1,58,11,25,7,1],
		[4148,45,24,0,49,10,35,2,0,8,39,1,7,2],
		[4149,88,24,0,0,10,34,58,1,23,10,34,7,3],
		[4150,48,24,0,35,10,36,21,0,36,19,37,7,3],
		[4151,88,24,0,0,10,34,13,1,60,59,16,7,5],
		[4152,88,24,0,0,10,35,39,1,18,34,9,7,2],
		[4153,88,24,0,0,10,35,13,1,39,33,46,6,5],
		[4154,88,24,0,0,10,35,11,1,43,39,53,7,4],
		[4155,88,24,0,0,10,36,17,1,10,35,0,8,3],
		[4156,41,20,2,0,10,36,17,1,16,20,40,7,7],
		[4157,88,24,0,0,10,36,5,1,26,40,30,7,3],
		[4158,88,24,0,0,10,36,32,1,12,13,49,7,3],
		[4159,88,24,0,0,10,35,35,1,57,33,28,5,5],
		[4160,88,24,0,0,10,37,12,1,11,44,55,8,3],
		[4161,88,24,0,0,10,31,51,1,81,55,16,8,1],
		[4162,88,24,0,0,10,37,14,1,27,24,45,6,7],
		[4163,88,24,0,0,10,37,33,1,13,23,4,6,6],
		[4164,88,24,0,0,10,36,20,1,59,33,53,6,5],
		[4165,88,24,0,0,10,39,6,0,53,40,6,7,5],
		[4166,48,24,0,37,10,38,43,0,31,58,34,6,4],
		[4167,88,24,0,0,10,37,18,1,48,13,33,5,3],
		[4168,48,24,0,38,10,39,8,0,37,54,36,7,3],
		[4169,88,24,0,0,10,37,27,1,58,44,0,6,2],
		[4170,88,24,0,0,10,35,25,1,76,18,33,7,5],
		[4171,41,20,3,0,10,38,35,1,16,52,36,6,4],
		[4172,88,24,0,0,10,38,50,1,12,26,37,7,2],
		[4173,88,24,0,0,10,38,3,1,57,15,23,7,1],
		[4174,17,2,0,0,10,35,28,1,78,36,28,5,7],
		[4175,88,24,0,0,10,38,50,1,42,45,13,7,2],
		[4176,88,24,0,0,10,41,48,0,68,26,36,7,5],
		[4177,88,24,0,0,10,38,45,1,59,10,59,6,5],
		[4178,82,24,0,38,10,41,57,0,65,42,59,6,5],
		[4179,88,24,0,0,10,38,59,1,58,49,1,7,7],
		[4180,88,24,0,0,10,39,18,1,55,36,12,5,4],
		[4181,88,24,0,0,10,43,4,0,69,4,34,6,5],
		[4182,74,24,0,33,10,41,24,1,1,44,30,7,5],
		[4183,88,24,0,0,10,40,52,1,35,44,30,7,4],
		[4184,88,24,0,0,10,42,11,0,31,41,49,7,7],
		[4185,88,24,0,0,10,40,11,1,65,6,2,7,1],
		[4186,88,24,0,0,10,39,17,1,74,29,37,7,5],
		[4187,82,24,0,39,10,43,43,0,57,11,57,7,2],
		[4188,88,24,0,0,10,41,18,1,59,40,37,7,2],
		[4189,48,24,0,40,10,43,2,0,26,19,32,7,2],
		[4190,88,24,0,0,10,42,31,1,13,58,30,7,5],
		[4191,88,24,0,0,10,43,33,0,46,12,14,6,3],
		[4192,48,24,0,41,10,43,25,0,23,11,18,6,2],
		[4193,74,24,0,35,10,43,21,0,4,44,52,7,5],
		[4194,88,24,0,0,10,42,43,1,32,42,57,7,2],
		[4195,88,24,0,0,10,45,4,0,67,24,41,7,6],
		[4196,88,24,0,0,10,42,14,1,64,27,59,6,1],
		[4197,88,24,0,0,10,44,15,0,19,45,31,7,2],
		[4198,88,24,0,0,10,42,41,1,59,12,57,6,1],
		[4199,12,7,0,0,10,42,57,1,64,23,40,4,1],
		[4200,88,24,0,0,10,43,32,1,60,34,0,6,5],
		[4201,74,24,0,36,10,45,9,0,2,29,17,7,5],
		[4202,82,24,0,41,10,46,23,0,57,21,57,7,7],
		[4203,48,24,0,42,10,45,52,0,30,40,56,6,2],
		[4204,88,24,0,0,10,43,51,1,64,14,56,7,1],
		[4205,88,24,0,0,10,44,7,1,63,57,40,6,1],
		[4206,88,24,0,0,10,41,51,1,79,47,0,7,1],
		[4207,88,24,0,0,10,46,6,0,6,22,23,7,5],
		[4208,45,24,0,51,10,46,25,0,18,53,29,6,5],
		[4209,45,24,0,52,10,46,25,0,14,11,41,6,4],
		[4210,12,6,0,0,10,45,4,1,59,41,3,7,5],
		[4211,88,24,0,0,10,44,19,1,70,51,36,7,2],
		[4212,88,24,0,0,10,44,32,1,70,51,18,7,2],
		[4213,88,24,0,0,10,44,27,1,72,26,38,7,3],
		[4214,88,24,0,0,10,46,52,1,17,17,48,6,2],
		[4215,88,24,0,0,10,48,50,0,65,7,56,7,2],
		[4216,84,11,0,0,10,46,46,1,49,25,12,4,4],
		[4217,88,24,0,0,10,46,17,1,60,36,12,7,2],
		[4218,88,24,0,0,10,47,38,1,15,15,43,8,2],
		[4219,88,24,0,0,10,46,17,1,64,30,54,6,1],
		[4220,88,24,0,0,10,46,30,1,64,15,48,6,1],
		[4221,88,24,0,0,10,46,58,1,56,45,26,6,1],
		[4222,88,24,0,0,10,46,51,1,64,23,0,6,1],
		[4223,48,24,0,43,10,48,57,0,29,24,57,7,5],
		[4224,88,24,0,0,10,48,41,1,1,57,32,7,7],
		[4225,88,24,0,0,10,48,14,1,31,41,18,7,2],
		[4226,88,24,0,0,10,47,39,1,57,28,4,7,7],
		[4227,45,24,0,53,10,49,15,0,10,32,43,6,2],
		[4228,88,24,0,0,10,48,5,1,59,55,9,7,2],
		[4229,74,24,0,40,10,49,17,1,4,1,27,8,2],
		[4230,48,24,0,44,10,49,54,0,27,58,26,7,3],
		[4231,17,3,1,0,10,45,16,1,80,28,11,6,5],
		[4232,41,12,0,0,10,49,38,1,16,11,37,4,5],
		[4233,88,24,0,0,10,49,44,1,9,51,10,7,4],
		[4234,17,3,2,0,10,45,47,1,80,32,25,5,1],
		[4235,82,24,0,43,10,51,11,0,56,34,56,7,5],
		[4236,82,24,0,42,10,51,24,0,59,19,12,7,5],
		[4237,74,24,0,41,10,50,18,1,8,53,52,7,2],
		[4238,88,24,0,0,10,49,57,1,34,3,29,7,2],
		[4239,88,24,0,0,10,49,24,1,59,19,25,7,1],
		[4240,88,24,0,0,10,51,5,1,3,5,33,7,5],
		[4241,88,24,0,0,10,52,31,0,52,33,55,8,4],
		[4242,88,24,0,0,10,52,32,0,52,30,13,7,5],
		[4243,88,24,0,0,10,53,31,0,69,51,14,7,4],
		[4244,88,24,0,0,10,52,14,0,1,1,31,7,2],
		[4245,88,24,0,0,10,52,36,1,0,12,5,7,5],
		[4246,82,24,0,44,10,53,35,0,54,35,6,6,5],
		[4247,48,24,0,46,10,53,19,0,34,12,54,5,5],
		[4248,82,23,0,45,10,53,59,0,43,11,24,6,2],
		[4249,88,24,0,0,10,53,25,1,2,15,19,7,5],
		[4250,88,24,0,0,10,52,31,1,57,14,26,6,1],
		[4251,88,24,0,0,10,53,30,1,20,8,20,6,3],
		[4252,88,24,0,0,10,53,33,1,15,26,44,7,5],
		[4253,88,24,0,0,10,53,44,1,2,7,45,6,4],
		[4254,48,24,0,48,10,54,42,0,25,29,27,7,2],
		[4255,88,24,0,0,10,54,18,1,13,45,29,7,4],
		[4256,88,24,0,0,10,54,58,0,34,2,5,7,4],
		[4257,88,24,0,0,10,53,30,1,58,51,12,5,5],
		[4258,82,24,0,46,10,55,44,0,33,30,25,6,5],
		[4259,45,24,0,54,10,55,37,0,24,44,59,6,2],
		[4260,45,24,0,54,10,55,37,0,24,44,56,7,2],
		[4261,88,24,0,0,10,55,12,1,20,39,54,7,5],
		[4262,88,24,0,0,10,53,42,1,70,43,13,7,1],
		[4263,88,24,0,0,10,55,1,1,42,15,4,7,2],
		[4264,88,24,0,0,10,56,15,0,42,0,30,7,5],
		[4265,45,24,0,55,10,55,42,0,0,44,13,7,3],
		[4266,88,24,0,0,10,54,30,1,61,49,36,7,5],
		[4267,45,24,0,56,10,56,2,0,6,11,7,7,7],
		[4268,88,24,0,0,10,52,28,1,79,33,34,7,5],
		[4269,88,24,0,0,10,56,17,0,22,21,6,7,5],
		[4270,48,24,0,50,10,56,34,0,25,30,0,7,5],
		[4271,88,24,0,0,10,55,17,1,60,31,1,7,5],
		[4272,88,24,0,0,10,59,57,0,77,46,12,7,4],
		[4273,1,8,0,0,10,56,43,1,37,8,16,6,5],
		[4274,88,24,0,0,10,57,8,1,50,45,54,7,2],
		[4275,88,24,0,0,10,59,18,0,51,52,56,7,5],
		[4276,88,24,0,0,10,57,48,1,59,43,55,7,4],
		[4277,82,24,0,47,10,59,28,0,40,25,49,6,4],
		[4278,88,24,0,0,10,59,33,0,36,5,35,7,7],
		[4279,88,24,0,0,10,57,16,1,75,5,59,7,5],
		[4280,88,24,0,0,11,0,15,0,45,31,34,6,5],
		[4281,88,24,0,0,10,59,41,0,11,42,21,8,3],
		[4282,88,24,0,0,10,59,14,1,33,44,14,7,3],
		[4283,88,24,0,0,11,0,26,0,51,30,7,7,4],
		[4284,88,24,0,0,10,59,31,1,16,21,14,7,7],
		[4285,88,24,0,0,11,0,21,0,42,54,41,7,3],
		[4286,88,24,0,0,11,1,6,0,63,25,16,7,2],
		[4287,26,0,0,7,10,59,47,1,18,17,56,5,5],
		[4288,82,24,0,49,11,0,50,0,39,12,44,6,3],
		[4289,88,24,0,0,11,0,12,1,14,5,0,7,5],
		[4290,88,24,0,0,10,59,14,1,61,19,13,7,1],
		[4291,45,24,0,58,11,0,34,0,3,37,3,6,5],
		[4292,88,24,0,0,10,59,59,1,43,48,26,7,1],
		[4293,88,24,0,0,11,0,9,1,42,13,33,5,2],
		[4294,45,24,0,59,11,0,45,0,6,6,5,6,2],
		[4295,82,1,0,48,11,1,51,0,56,22,57,3,2],
		[4296,88,24,0,0,11,0,9,1,51,49,4,7,2],
		[4297,88,24,0,0,11,0,57,1,15,47,34,7,5],
		[4298,88,24,0,0,11,0,41,1,31,50,22,7,3],
		[4299,45,24,0,61,11,1,50,1,2,29,5,6,7],
		[4300,45,24,0,60,11,2,20,0,20,10,47,5,2],
		[4301,82,0,0,50,11,3,44,0,61,45,3,3,5],
		[4302,88,24,0,0,11,2,24,1,26,49,53,7,3],
		[4303,88,24,0,0,11,3,15,1,0,45,9,7,3],
		[4304,88,24,0,0,10,59,13,1,81,33,22,8,3],
		[4305,88,24,0,0,11,3,15,1,11,18,13,7,4],
		[4306,45,24,0,62,11,3,37,1,0,0,3,7,5],
		[4307,88,24,0,0,11,3,16,1,31,57,39,7,7],
		[4308,88,24,0,0,11,3,37,1,13,26,4,7,4],
		[4309,82,24,0,51,11,4,31,0,38,14,29,7,2],
		[4310,45,21,0,63,11,5,1,0,7,20,10,6,3],
		[4311,88,24,0,0,11,4,31,1,47,40,45,7,2],
		[4312,57,6,0,0,10,59,14,1,84,35,38,7,2],
		[4313,88,24,0,0,11,4,54,1,35,48,17,6,2],
		[4314,41,21,1,0,11,5,20,1,27,17,37,6,3],
		[4315,88,24,0,0,11,5,34,1,11,5,20,7,3],
		[4316,88,24,0,0,11,5,4,1,49,23,33,7,1],
		[4317,41,21,2,0,11,5,58,1,27,17,16,7,2],
		[4318,88,24,0,0,11,6,6,1,51,12,45,7,4],
		[4319,45,24,0,65,11,6,54,0,1,57,20,7,4],
		[4320,88,24,0,0,11,6,39,1,28,43,40,8,2],
		[4321,88,24,0,0,11,6,27,1,50,57,24,7,5],
		[4322,45,24,0,64,11,7,40,0,23,19,25,7,2],
		[4323,88,24,0,0,11,6,29,1,58,40,31,7,5],
		[4324,88,24,0,0,11,7,8,1,32,35,14,8,3],
		[4325,88,24,0,0,11,6,32,1,62,25,27,6,4],
		[4326,88,24,0,0,11,6,24,1,64,50,23,7,2],
		[4327,88,24,0,0,11,7,17,1,42,38,19,6,2],
		[4328,88,24,0,0,11,7,54,1,30,10,29,8,4],
		[4329,88,24,0,0,11,6,50,1,70,52,41,7,1],
		[4330,88,24,0,0,11,9,40,0,67,12,37,7,3],
		[4331,88,24,0,0,11,8,16,1,29,58,22,7,2],
		[4332,45,24,0,67,11,8,49,0,24,39,30,7,2],
		[4333,88,24,0,0,11,9,19,0,36,18,34,7,7],
		[4334,88,24,0,0,11,8,44,1,28,4,50,6,2],
		[4335,82,22,0,52,11,9,40,0,44,29,55,4,5],
		[4336,88,24,0,0,11,9,39,0,43,12,27,7,7],
		[4337,88,24,0,0,11,8,35,1,58,58,30,5,4],
		[4338,88,24,0,0,11,8,34,1,61,56,50,6,1],
		[4339,88,24,0,0,11,9,53,1,32,22,3,7,2],
		[4340,88,24,0,0,11,12,11,0,68,16,19,7,2],
		[4341,88,24,0,0,11,11,44,0,14,24,1,7,2],
		[4342,88,24,0,0,11,10,55,1,58,27,19,8,1],
		[4343,26,1,0,11,11,11,40,1,22,49,33,5,2],
		[4344,88,24,0,0,11,12,45,0,54,53,39,8,2],
		[4345,88,24,0,0,11,12,32,0,35,48,49,7,4],
		[4346,88,24,0,0,11,12,15,1,32,26,2,7,7],
		[4347,26,22,0,0,11,12,30,1,18,30,0,7,2],
		[4348,88,24,0,0,11,12,35,1,21,44,57,7,5],
		[4349,88,24,0,0,11,11,30,1,71,26,11,7,5],
		[4350,88,24,0,0,11,12,33,1,49,6,4,6,2],
		[4351,88,24,0,0,11,13,40,0,41,5,19,7,5],
		[4352,88,24,0,0,11,12,36,1,60,19,3,6,2],
		[4353,88,24,0,0,11,12,57,1,49,44,11,7,4],
		[4354,88,24,0,0,11,13,15,1,44,22,20,7,5],
		[4355,88,24,0,0,11,12,45,1,64,10,11,6,1],
		[4356,45,24,0,69,11,13,46,1,0,4,11,6,2],
		[4357,45,3,0,68,11,14,7,0,20,31,25,4,2],
		[4358,88,24,0,0,11,14,2,0,8,3,38,7,5],
		[4359,45,7,0,70,11,14,14,0,15,25,46,4,2],
		[4360,88,24,0,0,11,13,39,1,53,13,54,7,5],
		[4361,88,24,0,0,11,13,31,1,59,37,10,7,1],
		[4362,45,24,0,72,11,15,12,0,23,5,44,6,7],
		[4363,88,24,0,0,11,16,4,0,52,46,23,8,3],
		[4364,88,24,0,0,11,14,54,1,43,44,3,7,5],
		[4365,45,24,0,73,11,15,52,0,13,18,27,6,5],
		[4366,88,24,0,0,11,15,58,0,12,50,41,8,2],
		[4367,88,24,0,0,11,16,42,0,49,28,35,7,5],
		[4368,45,20,0,74,11,16,40,1,3,39,6,5,2],
		[4369,88,24,0,0,11,16,58,1,7,8,5,7,2],
		[4370,88,24,0,0,11,16,28,1,45,52,48,7,3],
		[4371,45,24,0,75,11,17,17,0,2,0,38,6,7],
		[4372,88,24,0,0,11,17,12,1,38,0,52,7,2],
		[4373,88,24,0,0,11,17,39,1,34,44,14,7,3],
		[4374,82,13,0,53,11,18,11,0,31,31,45,6,4],
		[4375,82,13,0,53,11,18,11,0,31,31,45,5,4],
		[4376,88,24,0,0,11,17,43,1,36,32,4,8,4],
		[4377,82,12,0,54,11,18,29,0,33,5,39,4,5],
		[4378,88,24,0,0,11,18,21,0,11,59,5,8,2],
		[4379,88,24,0,0,11,17,19,1,67,49,25,7,7],
		[4380,82,24,0,55,11,19,8,0,38,11,8,6,2],
		[4381,45,24,0,76,11,18,55,0,1,39,2,7,5],
		[4382,26,3,0,12,11,19,21,1,14,46,43,5,4],
		[4383,88,24,0,0,11,20,54,0,67,6,2,7,4],
		[4384,88,24,0,0,11,19,17,1,64,34,57,7,3],
		[4385,88,24,0,0,11,18,34,1,79,40,7,7,2],
		[4386,45,17,0,77,11,21,8,0,6,1,46,5,1],
		[4387,88,24,0,0,11,19,36,1,75,8,33,7,1],
		[4388,88,24,0,0,11,21,49,0,57,4,30,7,2],
		[4389,88,24,0,0,11,20,4,1,71,59,40,7,1],
		[4390,14,15,0,0,11,21,0,1,54,29,28,5,1],
		[4391,88,24,0,0,11,22,51,0,64,19,50,7,2],
		[4392,82,24,0,56,11,22,50,0,43,28,58,6,4],
		[4393,88,24,0,0,11,22,23,1,44,38,45,7,4],
		[4394,88,24,0,0,11,23,18,0,0,7,54,7,5],
		[4395,26,10,0,13,11,23,22,1,18,46,48,6,3],
		[4396,88,24,0,0,11,23,13,1,36,9,53,6,5],
		[4397,88,24,0,0,11,21,57,1,77,36,30,7,2],
		[4398,88,24,0,0,11,23,8,1,56,46,46,7,2],
		[4399,45,8,0,78,11,23,56,0,10,31,45,5,3],
		[4400,45,24,0,79,11,24,2,0,1,24,28,6,4],
		[4401,88,24,0,0,11,23,22,1,64,57,18,6,1],
		[4402,26,4,0,14,11,24,37,1,10,51,34,6,5],
		[4403,88,24,0,0,11,24,22,1,42,40,9,7,1],
		[4404,88,24,0,0,11,24,59,0,11,25,49,7,5],
		[4405,26,2,0,15,11,24,53,1,17,41,2,5,2],
		[4406,88,24,0,0,11,24,11,1,72,15,24,7,1],
		[4407,88,24,0,0,11,25,57,0,55,51,2,7,5],
		[4408,45,24,0,81,11,25,36,0,16,27,23,7,3],
		[4409,88,24,0,0,11,25,29,1,36,3,47,6,5],
		[4410,45,24,0,80,11,25,50,0,3,51,36,7,3],
		[4411,88,24,0,0,11,25,33,1,37,44,52,7,7],
		[4412,88,24,0,0,11,26,26,0,33,27,2,7,3],
		[4413,88,24,0,0,11,25,43,1,63,58,22,6,3],
		[4414,45,24,0,83,11,26,45,0,3,0,47,8,5],
		[4415,88,24,0,0,11,26,35,1,61,6,55,6,1],
		[4416,26,9,0,16,11,27,10,1,12,21,24,7,3],
		[4417,88,24,0,0,11,26,47,1,53,9,36,7,5],
		[4418,45,18,0,84,11,27,56,0,2,51,22,6,4],
		[4419,88,24,0,0,11,27,54,1,1,42,0,7,5],
		[4420,88,24,0,0,11,27,59,1,35,19,43,7,5],
		[4421,88,24,0,0,11,29,5,0,61,46,42,7,3],
		[4422,82,24,0,57,11,29,4,0,39,20,13,6,2],
		[4423,88,24,0,0,11,28,35,1,42,40,27,6,1],
		[4424,88,24,0,0,11,29,44,0,56,44,15,7,2],
		[4425,88,24,0,0,11,28,18,1,72,28,28,7,1],
		[4426,45,24,0,85,11,29,42,0,15,24,48,7,5],
		[4427,88,24,0,0,11,30,13,0,54,21,42,7,5],
		[4428,88,24,0,0,11,29,39,1,24,27,48,7,2],
		[4429,88,24,0,0,11,31,50,0,81,7,38,7,2],
		[4430,88,24,0,0,11,30,25,0,46,39,27,7,5],
		[4431,82,24,0,58,11,30,31,0,43,10,24,7,3],
		[4432,45,24,0,87,11,30,19,1,3,0,13,6,5],
		[4433,45,24,0,86,11,30,29,0,18,24,35,7,5],
		[4434,33,10,0,1,11,31,24,0,69,19,52,5,7],
		[4435,88,24,0,0,11,30,53,0,47,55,45,7,4],
		[4436,88,24,0,0,11,31,10,0,48,47,21,8,4],
		[4437,45,24,0,88,11,31,45,0,14,21,52,7,4],
		[4438,88,24,0,0,11,31,15,1,61,16,42,7,2],
		[4439,88,24,0,0,11,32,21,0,61,4,57,6,3],
		[4440,88,24,0,0,11,31,48,1,20,46,36,7,3],
		[4441,14,14,1,0,11,31,46,1,59,26,32,6,4],
		[4442,14,14,2,0,11,31,49,1,59,30,57,6,2],
		[4443,88,24,0,0,11,32,16,1,29,15,48,7,3],
		[4444,88,24,0,0,11,32,16,1,29,15,40,7,3],
		[4445,88,24,0,0,11,32,23,1,26,44,48,7,7],
		[4446,88,24,0,0,11,32,48,1,7,49,39,7,5],
		[4447,88,24,0,0,11,32,48,1,40,26,11,7,5],
		[4448,88,24,0,0,11,32,20,1,66,57,44,7,5],
		[4449,88,24,0,0,11,32,54,1,31,5,14,6,7],
		[4450,41,13,0,0,11,33,0,1,31,51,28,5,4],
		[4451,88,24,0,0,11,33,15,1,16,16,50,7,3],
		[4452,88,24,0,0,11,33,56,0,36,48,56,7,5],
		[4453,88,24,0,0,11,33,37,1,40,35,13,6,2],
		[4454,88,24,0,0,11,34,10,0,11,1,25,8,2],
		[4455,45,24,0,89,11,34,22,0,3,3,36,7,3],
		[4456,45,24,0,90,11,34,43,0,16,47,49,7,1],
		[4457,88,24,0,0,11,35,5,0,54,47,7,7,5],
		[4458,88,24,0,0,11,34,30,1,32,49,53,7,5],
		[4459,88,24,0,0,11,35,4,0,20,26,29,7,4],
		[4460,88,24,0,0,11,34,46,1,54,15,51,6,1],
		[4461,33,24,0,2,11,36,3,0,69,19,22,6,5],
		[4462,88,24,0,0,11,34,57,1,49,8,12,7,5],
		[4463,88,24,0,0,11,35,13,1,47,22,21,7,7],
		[4464,88,24,0,0,11,35,43,0,10,54,40,8,2],
		[4465,88,24,0,0,11,36,18,0,27,46,52,7,3],
		[4466,88,24,0,0,11,35,56,1,47,38,30,6,2],
		[4467,14,10,0,0,11,35,47,1,63,1,11,4,1],
		[4468,26,7,0,21,11,36,41,1,9,48,8,6,1],
		[4469,88,24,0,0,11,36,35,1,33,34,12,7,5],
		[4470,88,24,0,0,11,36,41,1,37,14,16,7,2],
		[4471,45,19,0,91,11,36,57,1,0,49,26,5,4],
		[4472,88,24,0,0,11,36,22,1,61,3,8,7,1],
		[4473,88,24,0,0,11,37,1,1,32,59,17,7,3],
		[4474,88,24,0,0,11,37,53,0,50,37,6,7,4],
		[4475,88,24,0,0,11,37,1,1,61,17,0,6,5],
		[4476,88,24,0,0,11,37,34,1,47,44,50,6,5],
		[4477,82,24,0,59,11,38,21,0,43,37,32,7,3],
		[4478,88,24,0,0,11,38,10,0,8,53,3,7,5],
		[4479,17,15,0,0,11,37,16,1,75,53,48,7,3],
		[4480,82,24,0,60,11,38,34,0,46,50,3,7,3],
		[4481,88,24,0,0,11,38,49,0,64,20,49,7,2],
		[4482,88,24,0,0,11,38,32,0,33,37,32,7,5],
		[4483,85,23,0,1,11,38,28,0,8,8,3,6,7],
		[4484,88,24,0,0,11,38,24,1,2,26,10,7,4],
		[4485,88,24,0,0,11,37,48,1,67,37,13,7,5],
		[4486,88,24,0,0,11,38,45,0,45,6,31,7,4],
		[4487,88,24,0,0,11,38,7,1,61,49,35,6,2],
		[4488,26,8,0,24,11,38,40,1,13,12,7,6,3],
		[4489,88,24,0,0,11,39,0,1,24,43,16,7,4],
		[4490,88,24,0,0,11,39,51,1,14,28,7,7,2],
		[4491,88,24,0,0,11,39,50,1,16,37,13,7,7],
		[4492,88,24,0,0,11,39,29,1,65,23,52,6,4],
		[4493,88,24,0,0,11,40,27,0,57,58,14,7,1],
		[4494,41,14,0,0,11,40,13,1,34,44,41,6,1],
		[4495,45,24,0,92,11,40,47,0,21,21,10,6,5],
		[4496,82,24,0,61,11,41,3,0,34,12,6,6,4],
		[4497,88,24,0,0,11,40,43,1,53,58,7,7,7],
		[4498,88,24,0,0,11,41,8,1,29,11,47,7,4],
		[4499,88,24,0,0,11,40,54,1,62,5,24,6,4],
		[4500,88,24,0,0,11,41,44,0,55,10,21,7,5],
		[4501,82,24,0,62,11,41,34,0,31,44,46,7,3],
		[4502,88,24,0,0,11,41,20,1,43,5,45,7,2],
		[4503,88,24,0,0,11,41,44,1,32,29,59,6,5],
		[4504,33,24,0,3,11,42,28,0,66,44,42,6,5],
		[4505,88,24,0,0,11,42,5,0,22,12,39,8,3],
		[4506,88,24,0,0,11,42,4,1,20,17,38,7,5],
		[4507,88,24,0,0,11,41,1,1,83,6,0,7,5],
		[4508,88,24,0,0,11,43,27,1,37,11,25,7,5],
		[4509,88,24,0,0,11,42,55,1,79,18,23,7,5],
		[4510,88,24,0,0,11,43,55,1,6,40,38,7,4],
		[4511,88,24,0,0,11,43,31,1,62,29,22,6,4],
		[4512,88,24,0,0,11,44,13,0,25,13,6,7,5],
		[4513,88,24,0,0,11,43,53,1,62,52,42,7,2],
		[4514,26,5,0,27,11,44,46,1,18,21,3,6,4],
		[4515,85,13,0,2,11,45,17,0,8,15,30,6,2],
		[4516,88,24,0,0,11,45,13,1,49,4,11,7,5],
		[4517,85,12,0,3,11,45,52,0,6,31,46,5,7],
		[4518,82,21,0,63,11,46,3,0,47,46,46,5,5],
		[4519,88,24,0,0,11,45,44,1,45,41,24,6,1],
		[4520,55,10,0,0,11,45,36,1,66,43,43,5,2],
		[4521,88,24,0,0,11,46,56,0,55,37,42,6,5],
		[4522,88,24,0,0,11,46,31,1,61,10,42,5,4],
		[4523,88,24,0,0,11,46,31,1,40,30,2,6,4],
		[4524,88,24,0,0,11,47,7,1,35,54,25,7,4],
		[4525,88,24,0,0,11,47,16,1,30,17,13,7,4],
		[4526,88,24,0,0,11,47,19,1,57,41,47,6,5],
		[4527,45,24,0,93,11,47,59,0,20,13,8,6,4],
		[4528,85,24,0,4,11,47,55,0,8,14,45,6,2],
		[4529,88,24,0,0,11,48,24,1,10,18,48,7,3],
		[4530,55,11,0,0,11,48,14,1,66,48,53,6,5],
		[4531,88,24,0,0,11,48,39,0,14,17,3,7,3],
		[4532,88,24,0,0,11,48,45,1,26,44,59,6,7],
		[4533,88,24,0,0,11,49,1,1,0,19,7,7,3],
		[4534,45,1,0,94,11,49,4,0,14,34,19,3,2],
		[4535,88,24,0,0,11,49,15,0,16,14,34,7,2],
		[4536,88,24,0,0,11,49,42,0,34,55,54,7,3],
		[4537,88,24,0,0,11,49,41,1,63,47,18,5,1],
		[4538,88,24,0,0,11,49,57,1,70,13,33,6,4],
		[4539,88,24,0,0,11,50,20,1,15,51,50,7,5],
		[4540,85,1,0,5,11,50,42,0,1,45,53,5,3],
		[4541,88,24,0,0,11,50,27,1,62,38,58,7,2],
		[4542,88,24,0,0,11,50,37,1,27,16,40,7,4],
		[4543,88,24,0,0,11,50,55,0,12,16,44,7,3],
		[4544,88,24,0,0,11,51,2,1,5,20,0,7,5],
		[4545,88,24,0,0,11,51,9,0,33,22,30,7,2],
		[4546,88,24,0,0,11,51,9,1,45,10,25,5,5],
		[4547,88,24,0,0,11,51,22,1,12,11,16,7,3],
		[4548,88,24,0,0,11,51,42,1,30,50,6,7,3],
		[4549,88,24,0,0,11,51,51,1,65,12,22,6,1],
		[4550,88,24,0,0,11,52,59,0,37,43,7,7,4],
		[4551,88,24,0,0,11,52,10,1,56,59,16,7,2],
		[4552,41,1,0,0,11,52,55,1,33,54,29,5,1],
		[4553,88,24,0,0,11,53,27,1,35,4,0,7,2],
		[4554,82,2,0,64,11,53,50,0,53,41,41,3,2],
		[4555,88,24,0,0,11,53,50,0,0,33,7,7,3],
		[4556,88,24,0,0,11,54,12,1,57,24,36,7,2],
		[4557,88,24,0,0,11,54,26,1,37,44,56,7,3],
		[4558,88,24,0,0,11,54,43,1,25,42,50,6,4],
		[4559,85,24,0,6,11,55,3,0,8,26,38,7,5],
		[4560,82,24,0,65,11,55,6,0,46,28,37,8,2],
		[4561,82,24,0,65,11,55,11,0,46,28,11,8,2],
		[4562,88,24,0,0,11,55,14,0,36,45,23,7,7],
		[4563,88,24,0,0,11,54,60,1,63,16,44,7,2],
		[4564,45,24,0,95,11,55,41,0,15,38,48,7,2],
		[4565,88,24,0,0,11,55,40,1,28,28,37,7,5],
		[4566,82,24,0,66,11,55,58,0,56,35,55,7,5],
		[4567,26,6,0,30,11,56,1,1,17,9,3,6,2],
		[4568,88,24,0,0,11,55,55,1,39,41,21,7,5],
		[4569,88,24,0,0,11,56,53,0,61,32,57,7,4],
		[4570,88,24,0,0,11,56,44,1,47,4,21,7,3],
		[4571,88,24,0,0,11,57,4,1,33,18,55,7,2],
		[4572,88,24,0,0,11,57,15,0,40,20,37,8,3],
		[4573,88,24,0,0,11,57,40,1,62,26,56,7,1],
		[4574,88,24,0,0,11,58,7,0,32,16,26,7,2],
		[4575,88,24,0,0,11,58,21,0,61,27,53,8,5],
		[4576,88,24,0,0,11,58,15,1,56,19,2,6,1],
		[4577,88,24,0,0,11,58,20,1,40,56,50,8,5],
		[4578,88,24,0,0,11,58,48,1,64,20,21,7,2],
		[4579,88,24,0,0,11,58,54,1,25,54,32,7,2],
		[4580,88,24,0,0,11,59,3,0,0,31,50,7,5],
		[4581,88,24,0,0,11,59,18,0,33,10,3,7,5],
		[4582,88,24,0,0,11,59,11,1,51,41,48,7,5],
		[4583,17,4,0,0,11,59,37,1,78,13,19,6,1],
		[4584,88,24,0,0,11,59,57,0,34,2,6,8,2],
		[4585,85,24,0,7,11,59,57,0,3,39,19,6,2],
		[4586,88,24,0,0,12,0,19,0,80,51,11,7,7],
		[4587,88,24,0,0,12,0,45,1,10,26,46,7,4],
		[4588,88,24,0,0,12,0,43,1,21,50,14,7,5],
		[4589,85,15,0,8,12,0,52,0,6,36,51,6,2],
		[4590,88,24,0,0,12,0,51,1,19,39,32,6,1],
		[4591,88,24,0,0,12,1,2,1,1,46,5,7,4],
		[4592,88,24,0,0,12,1,29,1,57,30,13,7,2],
		[4593,88,24,0,0,12,1,40,0,36,2,31,7,5],
		[4594,82,24,0,67,12,2,7,0,43,2,44,6,3],
		[4595,88,24,0,0,12,2,20,1,85,37,54,7,5],
		[4596,88,24,0,0,12,2,29,1,71,29,20,7,5],
		[4597,88,24,0,0,12,2,38,1,69,11,32,7,1],
		[4598,88,24,0,0,12,2,52,1,7,41,1,7,5],
		[4599,27,7,1,0,12,3,2,1,63,18,46,5,2],
		[4600,88,24,0,0,12,3,40,1,42,26,3,6,3],
		[4601,88,24,0,0,12,3,44,1,74,12,50,7,4],
		[4602,23,24,0,2,12,4,17,0,21,27,33,7,3],
		[4603,27,7,2,0,12,4,19,1,63,9,56,6,1],
		[4604,88,24,0,0,12,4,39,1,68,19,45,6,2],
		[4605,17,9,0,0,12,4,47,1,76,31,9,6,5],
		[4606,88,24,0,0,12,4,28,0,85,35,14,7,3],
		[4607,88,24,0,0,12,4,57,1,60,58,9,7,7],
		[4608,85,14,0,9,12,5,13,0,8,43,59,5,4],
		[4609,88,24,0,0,12,5,15,0,76,54,21,7,4],
		[4610,88,24,0,0,12,5,40,0,62,55,59,7,5],
		[4611,88,24,0,0,12,5,53,1,65,32,50,7,1],
		[4612,88,24,0,0,12,5,57,1,35,41,38,7,1],
		[4613,88,24,0,0,12,5,60,1,3,7,54,7,4],
		[4614,88,24,0,0,12,6,20,1,68,39,3,7,4],
		[4615,88,24,0,0,12,6,23,1,65,42,33,7,4],
		[4616,27,6,0,0,12,6,53,1,64,36,49,5,3],
		[4617,88,24,0,0,12,7,50,1,75,22,1,6,5],
		[4618,88,24,0,0,12,8,5,1,50,39,41,5,1],
		[4619,88,24,0,0,12,8,5,1,50,45,48,7,1],
		[4620,88,24,0,0,12,8,15,1,48,41,34,6,1],
		[4621,14,3,0,0,12,8,22,1,50,43,21,4,1],
		[4622,88,24,0,0,12,8,25,1,60,50,50,7,5],
		[4623,28,0,0,1,12,8,25,1,24,43,44,5,3],
		[4624,88,24,0,0,12,8,54,1,44,19,34,7,2],
		[4625,88,24,0,0,12,8,55,1,41,13,53,6,1],
		[4626,85,24,0,10,12,9,41,0,1,53,52,7,5],
		[4627,88,24,0,0,12,9,47,0,74,39,41,7,3],
		[4628,88,24,0,0,12,10,3,1,34,42,18,7,2],
		[4629,85,24,0,11,12,10,3,0,5,48,25,7,3],
		[4630,28,4,0,2,12,10,8,1,22,37,11,4,5],
		[4631,88,24,0,0,12,10,34,1,37,52,13,7,2],
		[4632,23,24,0,3,12,10,32,0,16,48,33,7,2],
		[4633,88,24,0,0,12,10,46,0,27,16,53,7,2],
		[4634,88,24,0,0,12,11,5,1,61,16,39,7,3],
		[4635,28,24,0,3,12,11,4,1,23,36,9,6,2],
		[4636,88,24,0,0,12,11,3,1,45,25,22,8,5],
		[4637,88,24,0,0,12,11,31,1,51,21,34,7,4],
		[4638,14,16,0,0,12,11,39,1,52,22,7,5,1],
		[4639,88,24,0,0,12,11,0,0,81,42,36,7,5],
		[4640,23,24,0,4,12,11,51,0,25,52,13,7,5],
		[4641,82,24,0,68,12,11,45,0,57,3,16,7,5],
		[4642,88,24,0,0,12,12,1,0,28,32,10,7,3],
		[4643,23,24,0,5,12,12,9,0,20,32,31,7,5],
		[4644,88,24,0,0,12,12,22,1,62,57,3,7,1],
		[4645,88,24,0,0,12,12,47,1,70,9,7,7,3],
		[4646,88,24,0,0,12,12,12,0,77,36,59,6,2],
		[4647,88,24,0,0,12,13,13,1,34,7,32,8,7],
		[4648,88,24,0,0,12,13,25,1,38,55,45,7,1],
		[4649,88,24,0,0,12,13,56,1,78,34,25,7,5],
		[4650,85,24,0,12,12,13,26,0,10,15,44,7,2],
		[4651,88,24,0,0,12,13,37,1,33,47,34,7,2],
		[4652,88,24,0,0,12,14,3,1,45,43,26,6,5],
		[4653,88,24,0,0,12,14,17,1,64,24,31,7,1],
		[4654,88,24,0,0,12,14,43,0,53,26,5,7,5],
		[4655,88,24,0,0,12,14,60,1,20,50,39,7,4],
		[4656,27,3,0,0,12,15,9,1,58,44,56,4,1],
		[4657,88,24,0,0,12,15,11,1,10,18,45,7,3],
		[4658,88,24,0,0,12,15,31,1,41,54,47,7,5],
		[4659,88,24,0,0,12,15,9,0,70,12,0,7,5],
		[4660,82,3,0,69,12,15,26,0,57,1,57,4,2],
		[4661,88,24,0,0,12,15,47,1,23,21,13,8,3],
		[4662,28,2,0,4,12,15,48,1,17,32,31,4,1],
		[4663,23,24,0,6,12,16,0,0,14,53,56,6,2],
		[4664,88,24,0,0,12,16,24,1,72,36,53,7,2],
		[4665,88,24,0,0,12,15,41,0,72,33,3,7,5],
		[4666,29,24,0,2,12,16,8,0,40,39,37,7,7],
		[4667,23,24,0,7,12,16,21,0,23,56,43,6,4],
		[4668,88,24,0,0,12,16,30,0,33,3,41,6,5],
		[4669,88,24,0,0,12,17,6,1,65,41,34,7,2],
		[4670,88,24,0,0,12,17,3,1,16,41,37,7,2],
		[4671,55,4,0,0,12,17,34,1,67,57,39,5,7],
		[4672,88,24,0,0,12,17,30,0,53,11,28,7,5],
		[4673,88,24,0,0,12,17,31,0,28,56,14,7,2],
		[4674,17,1,0,0,12,18,21,1,79,18,44,5,1],
		[4675,88,24,0,0,12,17,47,1,36,5,38,7,2],
		[4676,88,24,0,0,12,17,44,0,15,8,39,7,5],
		[4677,88,24,0,0,12,18,9,1,3,57,16,8,3],
		[4678,88,24,0,0,12,18,10,1,3,56,55,8,3],
		[4679,27,5,0,0,12,18,26,1,64,0,11,5,1],
		[4680,88,24,0,0,12,18,32,0,30,14,57,7,2],
		[4681,85,24,0,13,12,18,40,1,0,47,14,7,2],
		[4682,88,24,0,0,12,18,60,1,55,8,35,6,7],
		[4683,88,24,0,0,12,16,51,0,86,26,10,7,3],
		[4684,88,24,0,0,12,19,2,0,26,0,28,7,2],
		[4685,23,24,0,8,12,19,19,0,23,2,5,7,2],
		[4686,88,24,0,0,12,15,20,0,87,42,0,7,3],
		[4687,88,24,0,0,12,18,50,0,75,9,38,6,2],
		[4688,23,24,0,9,12,19,30,0,28,9,25,7,3],
		[4689,85,6,0,15,12,19,54,1,0,40,1,5,2],
		[4690,29,24,0,3,12,19,49,0,48,59,3,6,7],
		[4691,88,24,0,0,12,20,11,1,22,10,32,7,4],
		[4692,88,24,0,0,12,20,28,1,65,50,34,7,1],
		[4693,88,24,0,0,12,20,20,0,26,37,10,7,5],
		[4694,88,24,0,0,12,20,18,0,26,0,7,7,3],
		[4695,85,24,0,16,12,20,21,0,3,18,45,6,5],
		[4696,28,5,0,5,12,20,34,1,22,12,57,6,1],
		[4697,23,24,0,11,12,20,43,0,17,47,34,6,4],
		[4698,88,24,0,0,12,20,41,0,27,3,17,8,3],
		[4699,88,24,0,0,12,20,56,1,13,33,56,6,5],
		[4700,27,4,0,0,12,21,22,1,60,24,4,5,5],
		[4701,82,24,0,70,12,20,51,0,57,51,50,7,5],
		[4702,88,24,0,0,12,21,58,1,56,22,29,7,5],
		[4703,55,5,2,0,12,22,7,1,67,31,19,6,2],
		[4704,55,5,1,0,12,22,12,1,68,18,27,7,5],
		[4705,88,24,0,0,12,22,11,0,24,46,26,7,2],
		[4706,88,24,0,0,12,22,49,1,57,40,34,6,1],
		[4707,23,24,0,12,12,22,30,0,25,50,46,6,4],
		[4708,85,24,0,17,12,22,32,0,5,18,20,7,3],
		[4709,88,24,0,0,12,25,38,1,86,9,2,7,5],
		[4710,88,24,0,0,12,23,14,1,67,37,54,7,4],
		[4711,28,24,0,6,12,23,22,1,24,50,26,7,5],
		[4712,88,24,0,0,12,23,35,1,35,24,46,6,1],
		[4713,88,24,0,0,12,23,37,1,39,18,11,7,3],
		[4714,88,24,0,0,12,23,45,1,38,54,40,7,1],
		[4715,29,24,0,4,12,23,47,0,42,32,34,7,3],
		[4716,29,24,0,5,12,24,2,0,51,33,44,6,4],
		[4717,23,24,0,13,12,24,19,0,26,5,55,6,2],
		[4718,88,24,0,0,12,24,45,1,41,23,3,7,5],
		[4719,88,24,0,0,12,24,27,0,25,34,58,7,2],
		[4720,88,24,0,0,12,25,17,1,65,46,14,7,4],
		[4721,88,24,0,0,12,25,9,1,42,30,52,7,4],
		[4722,88,24,0,0,12,25,12,1,11,36,37,7,2],
		[4723,88,24,0,0,12,25,18,1,27,44,57,7,5],
		[4724,88,24,0,0,12,25,22,1,35,11,11,7,1],
		[4725,88,24,0,0,12,25,15,0,23,55,34,7,5],
		[4726,82,24,0,71,12,25,3,0,56,46,39,7,7],
		[4727,88,24,0,0,12,25,6,0,63,48,10,7,4],
		[4728,29,24,0,6,12,25,51,0,39,1,7,6,4],
		[4729,88,24,0,0,12,26,31,1,63,7,21,6,1],
		[4730,27,0,1,0,12,26,36,1,63,5,57,2,1],
		[4731,27,0,2,0,12,26,37,1,63,5,58,3,1],
		[4732,88,24,0,0,12,26,32,1,51,27,3,6,1],
		[4733,23,24,0,14,12,26,24,0,27,16,6,6,3],
		[4734,88,24,0,0,12,26,48,1,48,54,48,7,4],
		[4735,88,24,0,0,12,26,52,1,32,49,48,7,1],
		[4736,88,24,0,0,12,27,25,1,63,47,21,7,1],
		[4737,23,2,0,15,12,26,56,0,28,16,6,5,5],
		[4738,23,24,0,16,12,26,59,0,26,49,32,6,2],
		[4739,88,24,0,0,12,27,29,1,58,59,31,7,7],
		[4740,88,24,0,0,12,26,24,0,71,55,47,7,4],
		[4741,88,24,0,0,12,27,42,0,8,36,37,7,4],
		[4742,88,24,0,0,12,27,49,1,16,37,55,7,4],
		[4743,14,17,0,0,12,28,2,1,50,13,50,5,1],
		[4744,88,24,0,0,12,28,19,1,64,20,29,7,2],
		[4745,82,24,0,73,12,27,35,0,55,42,46,7,7],
		[4746,88,24,0,0,12,27,52,1,4,36,55,7,2],
		[4747,88,24,0,0,12,28,26,1,61,47,43,7,5],
		[4748,88,24,0,0,12,28,23,1,39,2,29,6,1],
		[4749,88,24,0,0,12,28,33,1,56,24,28,7,5],
		[4750,88,24,0,0,12,28,38,0,26,13,36,8,2],
		[4751,88,24,0,0,12,28,45,0,25,53,57,8,2],
		[4752,23,24,0,17,12,28,55,0,25,54,46,6,2],
		[4753,23,24,0,18,12,29,27,0,24,6,32,6,3],
		[4754,88,24,0,0,12,29,54,1,56,31,29,7,7],
		[4755,88,24,0,0,12,29,58,1,41,44,10,7,7],
		[4756,23,24,0,20,12,29,43,0,20,53,46,7,2],
		[4757,28,3,0,7,12,29,52,1,16,30,56,4,1],
		[4758,88,24,0,0,12,30,5,1,13,23,35,7,4],
		[4759,88,24,0,0,12,30,18,1,23,41,48,7,7],
		[4760,82,24,0,74,12,29,57,0,58,24,21,6,2],
		[4761,29,24,0,7,12,30,3,0,51,32,8,7,3],
		[4762,82,24,0,75,12,30,4,0,58,46,3,7,4],
		[4763,27,2,0,0,12,31,10,1,57,6,48,3,7],
		[4764,27,2,0,0,12,31,17,1,57,4,52,7,2],
		[4765,33,24,0,4,12,30,7,0,69,12,4,6,7],
		[4766,23,24,0,21,12,31,1,0,24,34,2,6,2],
		[4767,88,24,0,0,12,30,50,0,53,4,36,7,3],
		[4768,88,24,0,0,12,31,40,1,59,25,26,6,3],
		[4769,88,24,0,0,12,32,10,1,73,0,6,7,5],
		[4770,88,24,0,0,12,31,21,0,7,36,15,7,5],
		[4771,88,24,0,0,12,31,56,1,63,30,22,7,2],
		[4772,88,24,0,0,12,31,39,1,5,3,9,7,4],
		[4773,55,2,0,0,12,32,28,1,72,7,59,5,1],
		[4774,88,24,0,0,12,32,5,1,32,32,1,7,2],
		[4775,28,6,0,8,12,32,4,1,16,11,46,5,3],
		[4776,88,24,0,0,12,32,36,1,13,51,33,7,3],
		[4777,85,24,0,20,12,33,3,0,10,17,44,7,4],
		[4778,88,24,0,0,12,33,22,1,19,47,31,7,3],
		[4779,88,24,0,0,12,33,34,1,12,49,49,7,4],
		[4780,23,24,0,22,12,33,34,0,24,16,59,7,2],
		[4781,85,24,0,21,12,33,47,1,9,27,7,6,2],
		[4782,88,24,0,0,12,33,59,1,49,54,34,7,3],
		[4783,88,24,0,0,12,33,39,0,33,14,51,6,5],
		[4784,88,24,0,0,12,33,47,0,33,23,5,7,5],
		[4785,29,1,0,8,12,33,45,0,41,21,27,5,4],
		[4786,28,1,0,9,12,34,23,1,23,23,48,4,4],
		[4787,33,9,0,5,12,33,29,0,69,47,18,5,1],
		[4788,88,24,0,0,12,34,42,1,44,40,24,7,4],
		[4789,23,24,0,23,12,34,51,0,22,37,45,6,2],
		[4790,88,24,0,0,12,35,29,1,61,50,31,7,4],
		[4791,23,24,0,24,12,35,6,0,18,22,38,8,2],
		[4792,23,24,0,24,12,35,8,0,18,22,37,6,5],
		[4793,88,24,0,0,12,35,8,0,21,52,53,7,5],
		[4794,88,24,0,0,12,35,46,1,41,1,19,6,2],
		[4795,33,24,0,6,12,34,44,0,70,1,19,6,5],
		[4796,88,24,0,0,12,36,1,1,39,52,12,7,2],
		[4797,88,24,0,0,12,35,59,1,20,31,38,7,3],
		[4798,55,0,0,0,12,37,11,1,69,8,8,4,1],
		[4799,85,24,0,25,12,36,47,1,5,49,55,7,2],
		[4800,88,24,0,0,12,36,23,0,59,29,13,7,7],
		[4801,23,24,0,25,12,36,58,0,17,5,22,7,5],
		[4802,14,18,0,0,12,37,42,1,48,32,28,5,2],
		[4803,88,24,0,0,12,37,42,1,27,8,20,6,3],
		[4804,88,24,0,0,12,39,15,1,75,22,10,7,1],
		[4805,88,24,0,0,12,38,4,0,3,16,57,7,2],
		[4806,88,24,0,0,12,38,53,1,67,11,35,7,1],
		[4807,88,24,0,0,12,38,22,0,1,51,17,7,7],
		[4808,88,24,0,0,12,38,30,0,6,59,18,8,7],
		[4809,88,24,0,0,12,38,45,1,18,15,1,7,2],
		[4810,88,24,0,0,12,39,4,1,30,25,20,7,5],
		[4811,29,24,0,9,12,38,46,0,40,52,28,7,2],
		[4812,88,24,0,0,12,39,2,0,22,39,34,7,5],
		[4813,85,21,0,26,12,39,15,1,7,59,44,6,5],
		[4814,88,24,0,0,12,39,56,1,66,30,42,7,1],
		[4815,23,24,0,26,12,39,7,0,21,3,45,6,4],
		[4816,88,24,0,0,12,39,17,0,35,57,7,7,2],
		[4817,88,24,0,0,12,39,53,1,39,59,15,6,1],
		[4818,88,24,0,0,12,41,23,1,46,8,44,7,5],
		[4819,14,2,0,0,12,41,31,1,48,57,35,3,2],
		[4820,88,24,0,0,12,42,5,1,69,24,27,7,3],
		[4821,88,24,0,0,12,41,16,1,13,0,49,7,3],
		[4822,88,24,0,0,12,41,16,1,13,0,54,7,3],
		[4823,88,24,0,0,12,41,57,1,59,41,9,6,1],
		[4824,85,24,0,27,12,41,34,0,10,25,35,7,2],
		[4825,85,2,0,29,12,41,40,1,1,26,58,5,3],
		[4826,85,2,0,29,12,41,40,1,1,26,58,5,3],
		[4827,88,24,0,0,12,41,49,1,19,45,31,7,3],
		[4828,85,16,0,30,12,41,53,0,10,14,8,6,2],
		[4829,85,24,0,31,12,41,57,0,6,48,24,7,2],
		[4830,88,24,0,0,12,42,50,1,63,3,31,6,1],
		[4831,88,24,0,0,12,42,35,1,48,48,47,6,5],
		[4832,88,24,0,0,12,42,50,1,55,56,50,7,1],
		[4833,82,24,0,76,12,41,34,0,62,42,47,7,2],
		[4834,88,24,0,0,12,43,9,1,56,10,34,7,1],
		[4835,88,24,0,0,12,43,28,1,58,54,11,7,5],
		[4836,88,24,0,0,12,43,26,1,40,10,40,7,2],
		[4837,88,24,0,0,12,43,38,1,1,34,37,7,4],
		[4838,88,24,0,0,12,43,59,1,36,20,57,7,2],
		[4839,88,24,0,0,12,44,1,1,28,19,26,6,5],
		[4840,88,24,0,0,12,43,4,0,61,9,20,7,5],
		[4841,88,24,0,0,12,45,2,1,68,49,52,7,3],
		[4842,27,8,0,0,12,45,38,1,60,58,52,6,5],
		[4843,88,24,0,0,12,44,27,0,44,6,11,7,3],
		[4844,55,1,0,0,12,46,17,1,68,6,29,4,1],
		[4845,29,24,0,10,12,44,60,0,39,16,44,7,4],
		[4846,88,24,0,0,12,45,8,0,45,26,25,6,6],
		[4847,85,24,0,32,12,45,37,0,7,40,24,6,3],
		[4848,88,24,0,0,12,46,23,1,56,29,20,6,1],
		[4849,85,24,0,33,12,46,23,0,9,32,24,7,5],
		[4850,88,24,0,0,12,46,46,1,33,18,56,7,5],
		[4851,23,24,0,27,12,46,39,0,16,34,39,6,5],
		[4852,88,24,0,0,12,44,26,0,80,37,16,7,2],
		[4853,27,1,0,0,12,47,43,1,59,41,19,2,1],
		[4854,88,24,0,0,12,47,2,0,5,57,3,7,2],
		[4855,85,24,0,34,12,47,14,0,11,57,29,7,2],
		[4856,88,24,0,0,12,47,33,1,6,18,7,7,3],
		[4857,88,24,0,0,12,47,54,1,24,51,6,7,1],
		[4858,85,24,0,35,12,47,51,0,3,34,22,7,7],
		[4859,88,24,0,0,12,47,19,0,62,46,51,7,2],
		[4860,88,24,0,0,12,48,26,1,27,35,51,7,4],
		[4861,23,24,0,28,12,48,14,0,13,33,11,8,2],
		[4862,88,24,0,0,12,49,45,1,71,59,11,7,4],
		[4863,33,24,0,7,12,47,34,0,66,47,25,6,5],
		[4864,88,24,0,0,12,48,47,0,24,50,25,7,4],
		[4865,23,24,0,29,12,48,54,0,14,7,21,7,2],
		[4866,29,24,0,11,12,48,42,0,48,28,1,7,2],
		[4867,88,24,0,0,12,48,39,0,60,19,12,7,3],
		[4868,88,24,0,0,12,50,12,1,60,24,3,8,2],
		[4869,23,24,0,30,12,49,17,0,27,33,8,7,2],
		[4870,57,8,0,0,12,54,59,1,85,7,24,6,5],
		[4871,88,24,0,0,12,50,20,1,48,27,35,7,2],
		[4872,88,24,0,0,12,50,58,1,52,47,15,7,2],
		[4873,88,24,0,0,12,50,17,0,22,51,48,7,5],
		[4874,88,24,0,0,12,50,41,1,33,59,58,6,2],
		[4875,88,24,0,0,12,50,11,0,37,31,1,7,2],
		[4876,88,24,0,0,12,51,18,1,60,19,47,7,2],
		[4877,88,24,0,0,12,51,23,1,10,20,18,7,4],
		[4878,85,24,0,37,12,51,37,0,3,3,24,7,5],
		[4879,88,24,0,0,12,51,57,1,39,40,51,7,1],
		[4880,88,24,0,0,12,52,5,1,48,5,39,7,2],
		[4881,88,24,0,0,12,51,58,1,26,44,17,7,2],
		[4882,88,24,0,0,12,52,25,1,53,49,46,7,4],
		[4883,23,24,0,31,12,51,42,0,27,32,26,6,4],
		[4884,23,24,0,32,12,52,12,0,17,4,26,7,7],
		[4885,88,24,0,0,12,53,4,1,54,57,9,7,5],
		[4886,88,24,0,0,12,52,28,0,16,7,21,7,2],
		[4887,88,24,0,0,12,53,22,1,60,19,43,7,1],
		[4888,88,24,0,0,12,53,7,1,48,56,36,5,5],
		[4889,88,24,0,0,12,53,26,1,40,10,44,5,2],
		[4890,27,9,0,0,12,53,49,1,60,22,37,7,1],
		[4891,85,24,0,38,12,53,11,1,3,33,11,7,3],
		[4892,88,24,0,0,12,49,7,0,83,25,5,7,2],
		[4893,88,24,0,0,12,49,14,0,83,24,46,6,2],
		[4894,23,24,0,35,12,53,18,0,21,14,42,6,4],
		[4895,88,24,0,0,12,54,22,1,58,25,50,8,3],
		[4896,88,24,0,0,12,53,38,1,4,13,26,7,5],
		[4897,27,10,0,0,12,54,39,1,59,8,48,6,1],
		[4898,27,11,1,0,12,54,36,1,57,10,40,5,1],
		[4899,27,11,2,0,12,54,37,1,57,10,6,6,1],
		[4900,85,24,0,41,12,53,50,0,12,25,7,7,2],
		[4901,88,24,0,0,12,54,19,1,11,38,55,7,2],
		[4902,85,22,0,40,12,54,21,1,9,32,20,6,7],
		[4903,88,24,0,0,12,54,59,1,44,9,7,7,4],
		[4904,88,24,0,0,12,54,13,0,33,32,4,7,2],
		[4905,82,4,0,77,12,54,2,0,55,57,35,3,2],
		[4906,88,24,0,0,12,55,19,1,42,54,57,6,7],
		[4907,88,24,0,0,12,56,32,1,72,11,7,7,4],
		[4908,88,24,0,0,12,55,57,1,56,50,10,6,0],
		[4909,88,24,0,0,12,54,57,0,47,11,48,7,7],
		[4910,85,3,0,43,12,55,36,0,3,23,51,4,7],
		[4911,88,24,0,0,12,55,53,1,15,19,37,7,2],
		[4912,88,24,0,0,12,56,30,1,26,27,37,8,3],
		[4913,88,24,0,0,12,57,4,1,51,11,55,6,1],
		[4914,29,0,1,12,12,56,0,0,38,18,53,7,3],
		[4915,29,0,2,12,12,56,2,0,38,19,6,4,2],
		[4916,33,24,0,8,12,55,29,0,65,26,19,6,3],
		[4917,88,24,0,0,12,56,18,0,54,5,58,7,2],
		[4918,88,24,0,0,12,57,33,1,22,45,14,7,4],
		[4919,88,24,0,0,12,57,8,0,46,10,37,7,5],
		[4920,23,24,0,36,12,58,55,0,17,24,34,6,7],
		[4921,85,24,0,44,12,59,40,1,3,48,43,7,2],
		[4922,88,24,0,0,13,0,33,1,33,30,19,7,3],
		[4923,55,3,0,0,13,2,16,1,71,32,56,5,5],
		[4924,23,24,0,37,13,0,17,0,30,47,6,6,4],
		[4925,85,24,0,46,13,0,36,1,3,22,7,7,5],
		[4926,88,24,0,0,13,0,39,0,18,22,23,7,3],
		[4927,88,24,0,0,12,58,47,0,75,28,21,7,5],
		[4928,33,24,0,9,12,59,55,0,66,35,50,6,5],
		[4929,23,24,0,38,13,1,10,0,17,7,23,7,5],
		[4930,88,24,0,0,13,3,5,1,71,28,34,7,1],
		[4931,82,24,0,78,13,0,44,0,56,21,59,6,3],
		[4932,85,4,0,47,13,2,11,0,10,57,33,4,4],
		[4933,14,13,1,0,13,3,33,1,49,31,38,6,2],
		[4934,88,24,0,0,13,1,47,0,63,36,37,7,3],
		[4935,88,24,0,0,13,3,46,1,20,34,59,7,3],
		[4936,88,24,0,0,13,2,40,0,59,42,58,8,2],
		[4937,85,24,0,48,13,3,54,1,3,39,48,8,3],
		[4938,88,24,0,0,13,4,48,1,41,11,48,7,7],
		[4939,88,24,0,0,13,5,31,1,52,6,54,7,7],
		[4940,88,24,0,0,13,6,17,1,48,27,49,6,1],
		[4941,88,24,0,0,13,6,35,1,41,35,19,7,5],
		[4942,14,13,2,0,13,6,55,1,49,54,22,5,1],
		[4943,29,24,0,14,13,5,45,0,35,47,56,6,1],
		[4944,88,24,0,0,13,7,24,1,59,51,38,7,3],
		[4945,88,24,0,0,13,5,52,0,45,16,7,7,5],
		[4946,23,24,0,39,13,6,21,0,21,9,12,7,3],
		[4947,88,24,0,0,13,6,54,1,35,51,43,8,2],
		[4948,88,24,0,0,13,6,10,0,29,1,46,8,2],
		[4949,23,24,0,40,13,6,23,0,22,36,58,7,7],
		[4950,88,24,0,0,13,4,50,0,73,1,31,7,3],
		[4951,88,24,0,0,13,7,38,1,53,27,35,7,1],
		[4952,55,7,0,0,13,8,7,1,65,18,23,7,1],
		[4953,88,24,0,0,13,6,23,0,62,2,31,7,4],
		[4954,23,24,0,41,13,7,11,0,27,37,29,6,5],
		[4955,85,24,0,49,13,7,54,1,10,44,25,6,5],
		[4956,88,24,0,0,13,7,54,0,27,33,21,7,5],
		[4957,88,24,0,0,13,8,33,1,8,59,4,7,5],
		[4958,41,22,0,45,13,9,3,1,23,7,5,6,5],
		[4959,88,24,0,0,13,9,14,1,9,32,18,7,5],
		[4960,88,24,0,0,13,9,12,0,10,1,20,7,5],
		[4961,85,24,0,50,13,9,45,1,10,19,46,7,5],
		[4962,88,24,0,0,13,9,48,0,16,50,55,7,5],
		[4963,85,7,0,51,13,9,57,1,5,32,20,5,2],
		[4964,88,24,0,0,13,9,39,0,37,25,23,7,5],
		[4965,88,24,0,0,13,10,58,1,52,34,1,7,2],
		[4966,88,24,0,0,13,11,52,1,69,56,31,7,3],
		[4967,29,24,0,15,13,9,42,0,38,32,2,7,1],
		[4968,23,0,0,42,13,9,59,0,17,31,46,6,3],
		[4969,23,0,0,42,13,9,59,0,17,31,46,6,3],
		[4970,88,24,0,0,13,11,9,1,42,13,59,7,3],
		[4971,29,24,0,17,13,10,3,0,38,29,56,7,2],
		[4972,88,24,0,0,13,11,53,1,63,18,10,7,2],
		[4973,88,24,0,0,13,11,23,1,43,22,8,6,5],
		[4974,88,24,0,0,13,9,50,0,62,13,45,8,2],
		[4975,88,24,0,0,13,12,17,1,59,55,15,6,1],
		[4976,88,24,0,0,13,14,17,1,78,26,50,7,3],
		[4977,88,24,0,0,13,12,49,1,66,13,37,7,2],
		[4978,88,24,0,0,13,11,39,1,26,33,6,8,2],
		[4979,88,24,0,0,13,12,3,1,37,48,11,6,4],
		[4980,88,24,0,0,13,12,56,1,59,49,0,7,4],
		[4981,85,24,0,53,13,12,4,1,16,11,55,6,3],
		[4982,88,24,0,0,13,12,51,1,42,41,59,7,5],
		[4983,23,1,0,43,13,11,52,0,27,52,41,5,3],
		[4984,88,24,0,0,13,12,8,0,24,15,29,7,5],
		[4985,88,24,0,0,13,13,24,1,50,42,0,7,1],
		[4986,88,24,0,0,13,12,33,0,11,33,22,7,7],
		[4987,88,24,0,0,13,12,36,0,18,45,6,8,4],
		[4988,88,24,0,0,13,14,12,1,58,41,2,7,5],
		[4989,88,24,0,0,13,14,15,1,59,6,12,6,3],
		[4990,85,24,0,54,13,13,27,1,18,49,36,7,1],
		[4991,88,24,0,0,13,13,58,1,43,8,20,7,5],
		[4992,88,24,0,0,13,13,12,0,18,43,37,7,4],
		[4993,55,6,0,0,13,15,15,1,67,53,40,6,1],
		[4994,88,24,0,0,13,15,26,1,69,40,47,7,5],
		[4995,85,24,0,55,13,14,11,1,19,55,51,6,4],
		[4996,88,24,0,0,13,14,43,1,48,57,24,7,5],
		[4997,88,24,0,0,13,13,43,0,40,9,10,6,4],
		[4998,88,24,0,0,13,14,31,0,11,19,54,7,7],
		[4999,88,24,0,0,13,15,10,1,36,22,16,7,5],
		[5000,88,24,0,0,13,16,45,1,65,8,18,7,3],
		[5001,85,24,0,57,13,15,59,1,19,56,35,6,5],
		[5002,88,24,0,0,13,17,13,1,66,47,1,6,5],
		[5003,88,24,0,0,13,13,32,0,72,47,56,8,2],
		[5004,29,24,0,19,13,15,32,0,40,51,19,7,2],
		[5005,88,24,0,0,13,16,26,1,1,23,26,8,3],
		[5006,88,24,0,0,13,16,53,1,31,30,22,6,5],
		[5007,88,24,0,0,13,16,14,0,19,3,6,7,4],
		[5008,88,24,0,0,13,17,14,1,43,58,46,7,2],
		[5009,88,24,0,0,13,12,25,0,80,28,17,7,5],
		[5010,88,24,0,0,13,16,32,0,19,47,7,7,3],
		[5011,85,24,0,59,13,16,47,0,9,25,27,6,4],
		[5012,88,24,0,0,13,19,19,1,72,2,8,7,5],
		[5013,88,24,0,0,13,17,16,0,13,40,32,6,5],
		[5014,88,24,0,0,13,17,30,1,0,40,36,7,3],
		[5015,85,17,0,60,13,17,36,0,5,28,11,6,7],
		[5016,88,24,0,0,13,18,35,1,51,17,10,7,2],
		[5017,29,24,0,20,13,17,33,0,40,34,21,6,3],
		[5018,88,24,0,0,13,16,29,0,68,24,29,7,1],
		[5019,85,24,0,61,13,18,24,1,18,18,41,6,4],
		[5020,41,2,0,46,13,18,55,1,23,10,18,4,4],
		[5021,88,24,0,0,13,18,51,0,3,41,16,8,2],
		[5022,88,24,0,0,13,18,28,0,34,5,53,7,5],
		[5023,29,24,0,21,13,18,15,0,49,40,55,6,2],
		[5024,88,24,0,0,13,20,35,1,59,46,24,7,3],
		[5025,88,24,0,0,13,19,4,0,35,7,41,7,3],
		[5026,88,24,0,0,13,20,38,1,52,44,53,6,1],
		[5027,88,24,0,0,13,20,48,1,55,48,2,7,1],
		[5028,14,8,0,0,13,20,36,1,36,42,44,4,2],
		[5029,88,24,0,0,13,20,58,1,46,52,50,7,5],
		[5030,88,24,0,0,13,22,53,1,72,8,48,7,1],
		[5031,88,24,0,0,13,20,42,0,2,56,30,7,2],
		[5032,29,24,0,23,13,20,19,0,40,9,2,7,5],
		[5033,88,24,0,0,13,21,30,1,19,29,20,7,2],
		[5034,88,24,0,0,13,22,36,1,60,58,20,7,1],
		[5035,88,24,0,0,13,22,38,1,60,59,18,6,1],
		[5036,88,24,0,0,13,22,16,1,52,10,59,7,1],
		[5037,88,24,0,0,13,21,42,0,2,5,14,7,2],
		[5038,88,24,0,0,13,22,53,1,47,56,35,7,2],
		[5039,88,24,0,0,13,23,3,1,48,33,46,7,1],
		[5040,85,24,0,64,13,22,10,0,5,9,17,7,2],
		[5041,88,24,0,0,13,24,1,1,64,32,9,6,4],
		[5042,55,8,1,0,13,25,7,1,74,53,16,6,5],
		[5043,88,24,0,0,13,23,9,1,33,11,24,7,7],
		[5044,85,24,0,63,13,23,1,1,17,44,7,6,5],
		[5045,88,24,0,0,13,22,4,0,43,54,11,7,2],
		[5046,88,24,0,0,13,23,52,1,49,49,23,7,4],
		[5047,85,24,0,65,13,23,19,1,4,55,28,7,5],
		[5048,88,24,0,0,13,25,14,1,64,29,7,6,3],
		[5049,88,24,0,0,13,25,50,1,70,37,39,7,2],
		[5050,85,24,0,66,13,24,33,1,5,9,50,7,3],
		[5051,55,8,2,0,13,27,18,1,74,41,31,8,1],
		[5052,88,24,0,0,13,23,54,0,37,2,2,7,7],
		[5053,88,24,0,0,13,24,31,0,12,25,55,7,5],
		[5054,82,5,0,79,13,23,56,0,54,55,31,3,2],
		[5055,82,5,0,79,13,23,56,0,54,55,18,5,2],
		[5056,85,0,0,67,13,25,12,1,11,9,41,2,1],
		[5057,88,24,0,0,13,25,7,0,23,51,16,7,2],
		[5058,88,24,0,0,13,26,8,1,39,45,19,6,5],
		[5059,88,24,0,0,13,26,11,1,1,11,33,7,2],
		[5060,88,24,0,0,13,26,56,1,41,29,53,7,5],
		[5061,88,24,0,0,13,27,6,1,49,8,38,7,2],
		[5062,82,24,0,80,13,25,14,0,54,59,17,5,2],
		[5063,88,24,0,0,13,27,21,1,49,22,51,7,1],
		[5064,85,24,0,68,13,26,43,1,12,42,28,6,7],
		[5065,88,24,0,0,13,27,15,1,40,9,47,7,4],
		[5066,88,24,0,0,13,28,46,1,69,37,41,7,2],
		[5067,88,24,0,0,13,26,17,0,46,1,41,7,5],
		[5068,85,24,0,69,13,27,27,1,15,58,25,6,5],
		[5069,88,24,0,0,13,29,8,1,64,40,33,7,2],
		[5070,88,24,0,0,13,25,60,0,63,15,40,8,4],
		[5071,88,24,0,0,13,29,25,1,51,9,55,6,2],
		[5072,85,24,0,70,13,28,26,0,13,46,44,6,4],
		[5073,88,24,0,0,13,26,8,0,72,23,29,7,7],
		[5074,88,24,0,0,13,27,5,0,64,44,8,8,3],
		[5075,88,24,0,0,13,27,11,0,64,43,10,8,3],
		[5076,88,24,0,0,13,27,60,0,52,44,45,7,3],
		[5077,88,24,0,0,13,28,26,0,40,43,47,7,4],
		[5078,88,24,0,0,13,29,15,1,1,21,52,7,5],
		[5079,88,24,0,0,13,28,12,0,50,35,14,8,3],
		[5080,88,24,0,0,13,29,43,1,23,16,53,6,7],
		[5081,85,24,0,71,13,29,13,0,10,49,6,7,5],
		[5082,88,24,0,0,13,33,15,1,77,34,6,7,3],
		[5083,88,24,0,0,13,28,46,0,50,43,6,7,3],
		[5084,57,9,0,0,13,40,56,1,85,47,10,7,2],
		[5085,88,24,0,0,13,28,27,0,59,56,45,6,2],
		[5086,88,24,0,0,13,30,0,0,7,10,44,7,5],
		[5087,88,24,0,0,13,29,58,0,6,0,48,8,5],
		[5088,85,24,0,72,13,30,26,1,6,28,13,7,3],
		[5089,88,24,0,0,13,31,3,1,39,24,27,5,4],
		[5090,88,24,0,0,13,31,33,1,28,6,46,7,2],
		[5091,88,24,0,0,13,26,57,0,78,38,38,7,4],
		[5092,88,24,0,0,13,32,5,1,38,23,57,7,5],
		[5093,88,24,0,0,13,33,36,1,65,37,57,7,2],
		[5094,85,24,0,73,13,32,3,1,18,43,44,7,3],
		[5095,85,24,0,74,13,31,58,1,6,15,21,6,7],
		[5096,88,24,0,0,13,31,16,0,42,6,22,7,5],
		[5097,88,24,0,0,13,32,36,1,28,41,34,7,2],
		[5098,88,24,0,0,13,32,35,1,29,33,55,7,3],
		[5099,85,24,0,75,13,32,52,1,15,21,47,7,5],
		[5100,85,24,0,76,13,32,58,1,10,9,54,6,5],
		[5101,88,24,0,0,13,33,1,1,7,11,42,8,7],
		[5102,88,24,0,0,13,32,48,0,24,20,47,7,4],
		[5103,88,24,0,0,13,34,29,1,48,16,20,7,1],
		[5104,88,24,0,0,13,34,44,1,33,18,39,7,5],
		[5105,85,24,0,78,13,34,8,0,3,39,32,6,2],
		[5106,88,24,0,0,13,34,41,1,13,12,52,7,2],
		[5107,85,5,0,79,13,34,42,1,0,35,45,4,2],
		[5108,88,24,0,0,13,34,22,0,38,47,21,7,3],
		[5109,82,24,0,81,13,34,7,0,55,20,55,7,2],
		[5110,88,24,0,0,13,34,48,0,37,10,57,6,3],
		[5111,85,24,0,80,13,35,31,1,5,23,46,7,4],
		[5112,29,24,0,24,13,34,27,0,49,0,58,6,2],
		[5113,88,24,0,0,13,37,12,1,61,41,31,7,3],
		[5114,88,24,0,0,13,35,33,0,10,12,17,7,5],
		[5115,88,24,0,0,13,39,12,1,75,41,2,7,1],
		[5116,88,24,0,0,13,35,14,0,44,11,49,8,2],
		[5117,88,24,0,0,13,36,51,1,34,28,4,8,5],
		[5118,88,24,0,0,13,37,6,1,44,8,36,7,4],
		[5119,88,24,0,0,13,38,46,1,70,26,42,7,5],
		[5120,88,24,0,0,13,36,48,1,26,29,42,7,2],
		[5121,88,24,0,0,13,37,24,1,46,25,42,7,1],
		[5122,88,24,0,0,13,38,8,1,58,24,54,7,5],
		[5123,88,24,0,0,13,36,59,0,24,36,48,7,7],
		[5124,88,24,0,0,13,38,49,1,57,37,23,7,4],
		[5125,88,24,0,0,13,40,1,1,70,47,18,8,5],
		[5126,88,24,0,0,13,36,40,0,49,29,12,7,5],
		[5127,29,24,0,25,13,37,28,0,36,17,42,6,2],
		[5128,88,24,0,0,13,38,42,1,29,33,39,7,3],
		[5129,88,24,0,0,13,38,8,0,14,18,6,8,2],
		[5130,88,24,0,0,13,40,11,1,64,34,37,7,3],
		[5131,88,24,0,0,13,34,43,0,76,32,48,8,5],
		[5132,14,4,0,0,13,39,53,1,53,27,59,3,1],
		[5133,88,24,0,0,13,37,43,0,50,42,53,7,7],
		[5134,88,24,0,0,13,39,60,1,49,57,1,7,7],
		[5135,88,24,0,0,13,39,41,1,39,44,53,7,7],
		[5136,88,24,0,0,13,39,49,1,40,3,7,7,5],
		[5137,88,24,0,0,13,39,2,0,18,15,55,7,5],
		[5138,88,24,0,0,13,39,35,0,10,44,46,7,3],
		[5139,88,24,0,0,13,37,11,0,71,14,32,7,5],
		[5140,88,24,0,0,13,42,1,1,58,47,14,6,1],
		[5141,88,24,0,0,13,41,45,1,54,33,36,6,1],
		[5142,82,24,0,82,13,39,30,0,52,55,17,6,2],
		[5143,88,24,0,0,13,40,16,0,31,0,43,7,4],
		[5144,8,24,0,1,13,40,41,0,19,57,20,7,2],
		[5145,88,24,0,0,13,40,39,0,28,3,55,7,5],
		[5146,88,24,0,0,13,41,31,1,23,26,59,8,2],
		[5147,88,24,0,0,13,41,46,1,33,35,49,7,5],
		[5148,88,24,0,0,13,40,23,0,50,31,10,7,3],
		[5149,8,24,0,2,13,41,2,0,22,29,45,7,4],
		[5150,85,24,0,82,13,41,37,1,8,42,11,6,7],
		[5151,88,24,0,0,13,42,56,1,56,46,5,7,1],
		[5152,88,24,0,0,13,42,55,1,50,47,26,7,7],
		[5153,88,24,0,0,13,40,21,0,57,12,27,7,2],
		[5154,82,24,0,83,13,40,44,0,54,40,54,6,7],
		[5155,88,24,0,0,13,42,55,1,41,24,4,7,5],
		[5156,88,24,0,0,13,42,13,0,8,23,18,7,3],
		[5157,88,24,0,0,13,43,40,1,42,4,3,7,1],
		[5158,88,24,0,0,13,44,16,1,51,0,47,7,2],
		[5159,85,24,0,84,13,43,4,0,3,32,17,6,5],
		[5160,88,24,0,0,13,42,29,0,41,40,27,7,4],
		[5161,88,24,0,0,13,42,43,0,34,59,20,7,4],
		[5162,88,24,0,0,13,41,30,0,64,49,21,7,2],
		[5163,88,24,0,0,13,43,54,1,5,29,56,8,2],
		[5164,88,24,0,0,13,43,45,0,22,42,1,7,5],
		[5165,85,24,0,83,13,44,30,1,16,10,45,7,4],
		[5166,88,24,0,0,13,44,46,1,25,30,3,7,5],
		[5167,88,24,0,0,13,45,37,1,26,6,58,7,2],
		[5168,14,24,0,1,13,45,41,1,33,2,38,5,3],
		[5169,88,24,0,0,13,43,55,0,52,3,52,7,2],
		[5170,85,24,0,85,13,45,35,1,15,46,3,7,2],
		[5171,88,24,0,0,13,47,11,1,62,35,24,8,5],
		[5172,88,24,0,0,13,46,39,1,51,25,58,6,4],
		[5173,85,24,0,86,13,45,56,1,12,25,36,7,4],
		[5174,88,24,0,0,13,46,56,1,36,15,7,6,2],
		[5175,88,24,0,0,13,47,28,1,50,14,58,7,2],
		[5176,88,24,0,0,13,47,38,1,50,19,16,6,5],
		[5177,88,24,0,0,13,45,13,0,55,52,46,8,3],
		[5178,88,24,0,0,13,47,14,1,9,42,33,7,5],
		[5179,88,24,0,0,13,46,14,0,41,5,19,7,2],
		[5180,88,24,0,0,13,46,19,0,38,30,14,7,4],
		[5181,85,24,0,87,13,47,25,1,17,51,36,6,7],
		[5182,8,24,0,3,13,46,43,0,25,42,8,7,4],
		[5183,88,24,0,0,13,46,57,0,6,21,2,7,4],
		[5184,88,24,0,0,13,42,39,0,78,3,52,7,4],
		[5185,8,18,0,4,13,47,16,0,17,27,24,6,3],
		[5186,88,24,0,0,13,46,60,0,38,32,34,7,5],
		[5187,82,24,0,84,13,46,36,0,54,25,58,7,1],
		[5188,88,24,0,0,13,55,39,1,82,39,58,7,5],
		[5189,88,24,0,0,13,48,55,1,35,42,14,8,4],
		[5190,14,12,0,0,13,49,30,1,41,41,16,4,1],
		[5191,82,6,0,85,13,47,32,0,49,18,48,3,1],
		[5192,14,24,0,2,13,49,27,1,34,27,3,5,7],
		[5193,14,11,0,0,13,49,37,1,42,28,26,4,1],
		[5194,88,24,0,0,13,51,47,1,69,24,5,7,5],
		[5195,88,24,0,0,13,48,39,0,31,11,25,7,5],
		[5196,85,24,0,89,13,49,52,1,18,8,3,6,5],
		[5197,88,24,0,0,13,50,7,1,29,4,53,7,2],
		[5198,88,24,0,0,13,50,19,1,39,54,4,7,5],
		[5199,88,24,0,0,13,48,57,0,39,32,34,8,7],
		[5200,8,19,0,5,13,49,29,0,15,47,52,5,5],
		[5201,8,24,0,6,13,49,43,0,21,15,51,6,5],
		[5202,88,24,0,0,13,50,35,1,19,53,50,8,4],
		[5203,88,24,0,0,13,42,23,0,82,45,9,7,4],
		[5204,88,24,0,0,13,49,45,0,36,37,58,7,2],
		[5205,88,24,0,0,13,50,25,0,5,29,50,7,5],
		[5206,88,24,0,0,13,51,47,1,46,53,57,7,1],
		[5207,88,24,0,0,13,52,5,1,52,48,42,6,1],
		[5208,88,24,0,0,13,51,37,1,36,26,0,7,3],
		[5209,88,24,0,0,13,51,20,1,24,23,27,7,4],
		[5210,14,24,0,3,13,51,50,1,32,59,40,6,1],
		[5211,14,24,0,3,13,51,50,1,32,59,41,7,1],
		[5212,88,24,0,0,13,52,1,1,31,37,10,7,3],
		[5213,88,24,0,0,13,49,46,0,61,29,21,7,4],
		[5214,88,24,0,0,13,51,5,0,34,46,21,8,2],
		[5215,88,24,0,0,13,51,9,0,34,39,52,7,7],
		[5216,88,24,0,0,13,50,28,0,58,32,22,7,2],
		[5217,88,24,0,0,13,53,43,1,53,22,25,7,1],
		[5218,88,24,0,0,13,54,49,1,67,39,9,7,5],
		[5219,88,24,0,0,13,51,48,0,34,26,39,6,5],
		[5220,88,24,0,0,13,52,18,0,12,9,55,7,2],
		[5221,14,24,0,4,13,53,13,1,31,55,40,6,1],
		[5222,88,24,0,0,13,53,33,1,35,39,51,7,3],
		[5223,88,24,0,0,13,53,57,1,47,7,41,7,1],
		[5224,88,24,0,0,13,53,52,1,35,18,52,7,5],
		[5225,8,24,0,7,13,53,13,0,17,55,58,7,4],
		[5226,33,24,0,10,13,51,26,0,64,43,24,6,7],
		[5227,88,24,0,0,13,50,59,0,68,18,55,7,5],
		[5228,88,24,0,0,13,54,17,1,28,34,11,7,5],
		[5229,88,24,0,0,13,53,10,0,28,38,53,7,2],
		[5230,88,24,0,0,13,55,12,1,52,9,40,7,1],
		[5231,14,5,0,0,13,55,32,1,47,17,18,4,1],
		[5232,85,24,0,90,13,54,42,1,1,30,11,6,5],
		[5233,88,24,0,0,13,54,58,1,8,3,32,7,3],
		[5234,88,24,0,0,13,56,20,1,54,7,55,7,2],
		[5235,8,6,0,8,13,54,41,0,18,23,52,4,4],
		[5236,88,24,0,0,13,56,33,1,54,42,16,7,4],
		[5237,88,24,0,0,13,55,45,1,31,17,6,8,4],
		[5238,82,24,0,86,13,53,51,0,53,43,43,7,2],
		[5239,88,24,0,0,13,56,20,1,46,35,33,7,5],
		[5240,88,24,0,0,14,0,33,1,78,35,24,7,1],
		[5241,88,24,0,0,13,57,39,1,63,41,12,6,5],
		[5242,88,24,0,0,13,58,31,1,65,48,2,7,5],
		[5243,88,24,0,0,13,55,50,0,14,3,23,7,3],
		[5244,85,24,0,92,13,56,28,0,1,3,2,7,2],
		[5245,88,24,0,0,13,56,11,0,32,1,57,7,3],
		[5246,88,24,0,0,13,57,28,1,23,1,22,7,5],
		[5247,8,24,0,9,13,56,34,0,27,29,31,6,5],
		[5248,14,20,0,0,13,58,16,1,42,6,3,5,1],
		[5249,14,19,1,0,13,58,41,1,44,48,13,5,1],
		[5250,41,24,0,47,13,58,31,1,24,58,20,6,1],
		[5251,88,24,0,0,13,59,17,1,50,22,12,7,4],
		[5252,88,24,0,0,14,0,17,1,61,28,53,7,3],
		[5253,88,24,0,0,14,0,52,1,66,16,7,7,3],
		[5254,88,24,0,0,13,58,40,0,14,38,58,7,5],
		[5255,8,24,0,10,13,58,39,0,21,41,46,7,2],
		[5256,88,24,0,0,13,57,32,0,61,29,34,7,5],
		[5257,41,24,0,48,14,0,0,1,25,0,37,7,3],
		[5258,88,24,0,0,13,59,49,1,3,32,59,7,3],
		[5259,88,24,0,0,14,1,19,1,40,13,20,7,5],
		[5260,14,19,2,0,14,1,43,1,45,36,13,5,3],
		[5261,2,7,0,0,14,5,20,1,76,47,48,7,7],
		[5262,88,24,0,0,14,1,20,0,8,53,41,7,2],
		[5263,8,24,0,11,14,1,11,0,27,23,12,7,2],
		[5264,85,18,0,93,14,1,39,0,1,32,40,5,2],
		[5265,88,24,0,0,14,2,23,1,27,25,48,6,5],
		[5266,88,24,0,0,14,3,26,1,56,12,49,7,5],
		[5267,14,1,0,0,14,3,49,1,60,22,23,2,1],
		[5268,88,24,0,0,14,3,2,1,31,41,2,7,3],
		[5269,88,24,0,0,14,3,28,1,41,25,24,7,2],
		[5270,88,24,0,0,14,2,32,0,9,41,11,7,3],
		[5271,88,24,0,0,14,2,12,0,45,45,13,7,5],
		[5272,88,24,0,0,14,3,53,1,22,25,18,7,3],
		[5273,88,24,0,0,14,3,32,0,10,47,12,7,4],
		[5274,88,24,0,0,14,3,37,0,7,32,47,7,4],
		[5275,88,24,0,0,14,3,56,0,4,54,3,7,3],
		[5276,88,24,0,0,14,4,15,1,5,22,53,7,5],
		[5277,88,24,0,0,14,4,27,1,14,58,18,7,4],
		[5278,88,24,0,0,14,5,47,1,54,40,10,7,2],
		[5279,88,24,0,0,14,8,27,1,74,51,1,7,4],
		[5280,88,24,0,0,14,2,60,0,50,58,19,7,2],
		[5281,88,24,0,0,14,6,25,1,59,42,56,7,1],
		[5282,88,24,0,0,14,1,51,0,68,40,43,7,5],
		[5283,88,24,0,0,14,4,38,0,2,17,51,7,5],
		[5284,88,24,0,0,14,5,14,1,16,20,9,8,2],
		[5285,14,21,0,0,14,6,3,1,41,10,47,5,1],
		[5286,88,24,0,0,14,6,11,1,43,5,31,7,4],
		[5287,41,15,0,49,14,6,22,1,26,40,57,4,5],
		[5288,14,7,0,5,14,6,41,1,36,22,12,3,5],
		[5289,88,24,0,0,14,8,14,1,63,12,29,7,4],
		[5290,85,24,0,95,14,6,43,1,9,18,48,6,3],
		[5291,33,0,0,11,14,4,23,0,64,22,33,5,2],
		[5292,88,24,0,0,14,8,56,1,59,16,36,7,1],
		[5293,88,24,0,0,14,10,31,1,70,18,20,7,5],
		[5294,88,24,0,0,14,8,52,1,43,28,16,7,1],
		[5295,88,24,0,0,14,11,2,1,69,43,11,7,2],
		[5296,88,24,0,0,14,9,35,1,51,30,17,7,1],
		[5297,88,24,0,0,14,9,55,1,53,26,21,6,4],
		[5298,85,24,0,96,14,9,1,1,10,20,4,7,4],
		[5299,88,24,0,0,14,7,56,0,43,51,16,6,7],
		[5300,8,24,0,13,14,8,17,0,49,27,29,6,7],
		[5301,88,24,0,0,14,10,51,1,16,18,7,6,7],
		[5302,88,24,0,0,14,8,46,0,59,20,16,7,5],
		[5303,2,6,0,0,14,18,14,1,81,0,28,6,2],
		[5304,8,24,0,12,14,10,24,0,25,5,30,6,3],
		[5305,83,24,0,3,14,6,56,0,74,35,37,7,2],
		[5306,88,24,0,0,14,16,55,1,77,39,50,7,5],
		[5307,88,24,0,0,14,11,31,0,1,21,44,7,3],
		[5308,88,24,0,0,14,13,16,1,53,39,57,7,5],
		[5309,88,24,0,0,14,12,25,1,24,21,51,7,5],
		[5310,88,24,0,0,14,11,15,0,32,17,44,7,5],
		[5311,88,24,0,0,14,13,40,1,54,37,33,7,1],
		[5312,41,24,0,50,14,12,46,1,27,15,40,6,5],
		[5313,88,24,0,0,14,12,16,0,2,24,34,6,2],
		[5314,88,24,0,0,14,13,13,1,26,36,44,7,5],
		[5315,85,9,0,98,14,12,54,1,10,16,25,5,5],
		[5316,88,24,0,0,14,14,57,1,57,5,9,6,1],
		[5317,88,24,0,0,14,13,41,1,0,50,44,7,3],
		[5318,88,24,0,0,14,14,43,1,41,50,15,7,4],
		[5319,88,24,0,0,14,15,21,1,53,30,35,7,5],
		[5320,88,24,0,0,14,16,39,1,66,35,16,7,1],
		[5321,83,24,0,4,14,8,51,0,77,32,51,6,5],
		[5322,88,24,0,0,14,14,21,1,5,56,51,7,3],
		[5323,8,24,0,14,14,14,5,0,12,57,34,7,3],
		[5324,88,24,0,0,14,15,1,1,29,16,55,7,2],
		[5325,88,24,0,0,14,15,39,1,45,0,3,7,3],
		[5326,88,24,0,0,14,16,34,1,59,54,50,7,7],
		[5327,88,24,0,0,14,24,23,1,82,50,55,7,1],
		[5328,8,9,1,17,14,13,28,0,51,47,16,8,3],
		[5329,8,9,2,17,14,13,29,0,51,47,25,6,2],
		[5330,8,24,0,15,14,14,51,0,10,6,2,6,5],
		[5331,88,24,0,0,14,14,53,0,3,20,10,7,7],
		[5332,88,24,0,0,14,15,24,1,18,12,3,6,2],
		[5333,88,24,0,0,14,14,41,0,21,52,24,7,2],
		[5334,88,24,0,0,14,12,4,0,69,25,57,6,7],
		[5335,88,24,0,0,14,14,24,0,41,31,8,7,5],
		[5336,2,4,0,0,14,22,23,1,80,6,32,6,1],
		[5337,88,24,0,0,14,16,18,1,33,14,29,8,3],
		[5338,85,8,0,99,14,16,1,1,6,0,2,5,3],
		[5339,57,3,0,0,14,26,55,1,83,40,4,5,5],
		[5340,8,0,0,16,14,15,40,0,19,10,57,1,5],
		[5341,88,24,0,0,14,16,22,1,6,37,19,7,2],
		[5342,88,24,0,0,14,16,30,1,3,11,47,7,2],
		[5343,88,24,0,0,14,16,4,0,18,54,43,7,2],
		[5344,88,24,0,0,14,17,4,1,18,35,7,7,4],
		[5345,88,24,0,0,14,15,17,0,52,32,9,8,2],
		[5346,88,24,0,0,14,16,33,0,20,7,17,7,3],
		[5347,88,24,0,0,14,16,24,0,39,44,41,7,3],
		[5348,88,24,0,0,14,18,24,1,33,13,14,8,3],
		[5349,88,24,0,0,14,19,52,1,61,16,23,6,2],
		[5350,8,8,0,21,14,16,10,0,51,22,2,6,2],
		[5351,8,10,0,19,14,16,23,0,46,5,18,5,2],
		[5352,88,24,0,0,14,17,28,0,15,15,48,7,7],
		[5353,88,24,0,0,14,18,1,1,7,32,33,7,4],
		[5354,49,8,0,0,14,19,24,1,46,3,28,5,1],
		[5355,88,24,0,0,14,18,38,1,18,42,58,7,2],
		[5356,88,24,0,0,14,19,1,1,25,48,56,7,3],
		[5357,88,24,0,0,14,19,24,1,37,0,13,7,2],
		[5358,88,24,0,0,14,20,20,1,56,23,12,5,1],
		[5359,85,10,0,100,14,19,7,1,13,22,16,6,2],
		[5360,88,24,0,0,14,17,21,0,51,18,26,7,2],
		[5361,88,24,0,0,14,17,60,0,35,30,34,6,5],
		[5362,88,24,0,0,14,20,10,1,43,3,32,7,4],
		[5363,88,24,0,0,14,17,49,0,48,0,6,7,3],
		[5364,88,24,0,0,14,20,43,1,45,11,14,6,3],
		[5365,8,24,0,18,14,19,16,0,13,0,15,6,3],
		[5366,85,19,0,102,14,19,33,1,2,15,56,6,4],
		[5367,14,22,0,0,14,20,33,1,37,53,7,5,2],
		[5368,88,24,0,0,14,19,41,0,0,23,3,7,2],
		[5369,88,24,0,0,14,18,56,0,38,46,3,8,4],
		[5370,8,24,0,20,14,19,45,0,16,18,25,6,5],
		[5371,88,24,0,0,14,22,37,1,58,27,34,6,4],
		[5372,88,24,0,0,14,18,56,0,54,51,51,8,2],
		[5373,88,24,0,0,14,19,48,0,38,47,38,7,2],
		[5374,88,24,0,0,14,20,9,0,30,25,45,7,2],
		[5375,88,24,0,0,14,22,39,1,48,19,13,7,1],
		[5376,88,24,0,0,14,22,20,1,34,47,13,7,1],
		[5377,88,24,0,0,14,23,20,1,50,46,20,7,5],
		[5378,88,24,0,0,14,23,2,1,39,30,44,5,1],
		[5379,88,24,0,0,14,25,6,1,68,11,43,7,2],
		[5380,88,24,0,0,14,23,48,1,53,10,36,7,5],
		[5381,41,24,0,51,14,23,6,1,27,45,14,6,5],
		[5382,88,24,0,0,14,25,40,1,66,10,24,7,2],
		[5383,47,24,0,2,14,23,26,1,11,42,51,7,4],
		[5384,88,24,0,0,14,23,15,0,1,14,30,7,4],
		[5385,88,24,0,0,14,23,23,0,8,26,42,8,3],
		[5386,88,24,0,0,14,23,23,0,8,26,48,6,2],
		[5387,88,24,0,0,14,23,7,0,25,20,17,7,3],
		[5388,88,24,0,0,14,24,1,0,8,14,37,7,2],
		[5389,88,24,0,0,14,29,37,1,76,43,45,7,5],
		[5390,88,24,0,0,14,24,49,1,24,48,23,6,4],
		[5391,88,24,0,0,14,27,7,1,65,49,18,7,5],
		[5392,88,24,0,0,14,24,11,0,5,49,12,6,2],
		[5393,88,24,0,0,14,24,41,1,11,40,11,7,3],
		[5394,88,24,0,0,14,24,18,0,8,5,6,7,5],
		[5395,49,18,1,0,14,26,8,1,45,13,17,6,1],
		[5396,49,18,2,0,14,26,11,1,45,22,46,5,3],
		[5397,88,24,0,0,14,25,30,1,19,58,11,8,2],
		[5398,88,24,0,0,14,26,13,1,42,19,9,7,5],
		[5399,88,24,0,0,14,25,48,1,26,51,9,7,4],
		[5400,88,24,0,0,14,26,50,1,39,52,26,7,1],
		[5401,88,24,0,0,14,27,12,1,46,8,4,7,2],
		[5402,88,24,0,0,14,25,29,0,38,23,35,7,5],
		[5403,88,24,0,0,14,28,44,1,59,11,52,7,2],
		[5404,8,7,0,23,14,25,12,0,51,51,3,5,3],
		[5405,8,24,0,22,14,26,27,0,19,13,37,6,3],
		[5406,85,24,0,104,14,27,24,1,6,7,13,7,2],
		[5407,41,24,0,52,14,28,10,1,29,29,30,6,1],
		[5408,88,24,0,0,14,31,17,1,67,43,2,7,5],
		[5409,85,20,0,105,14,28,12,1,2,13,41,6,4],
		[5410,85,24,0,106,14,28,42,1,6,54,2,6,5],
		[5411,88,24,0,0,14,27,27,0,41,1,30,8,3],
		[5412,88,24,0,0,14,30,9,1,45,19,18,7,1],
		[5413,88,24,0,0,14,30,21,1,49,31,9,6,2],
		[5414,88,24,0,0,14,28,32,0,28,17,21,9,2],
		[5415,88,24,0,0,14,28,33,0,28,17,27,8,2],
		[5416,88,24,0,0,14,28,16,0,36,11,49,7,5],
		[5417,88,24,0,0,14,30,57,1,40,50,42,7,5],
		[5418,88,24,0,0,14,29,51,0,0,49,44,7,2],
		[5419,88,24,0,0,14,31,11,1,38,52,11,7,5],
		[5420,8,24,0,24,14,28,38,0,49,50,41,7,4],
		[5421,88,24,0,0,14,32,33,1,56,53,16,8,3],
		[5422,88,24,0,0,14,29,50,0,31,47,28,7,2],
		[5423,88,24,0,0,14,29,37,0,41,47,45,7,4],
		[5424,88,24,0,0,14,30,45,0,4,46,20,7,5],
		[5425,49,17,0,0,14,32,37,1,50,27,25,5,1],
		[5426,88,24,0,0,14,33,32,1,54,59,54,7,3],
		[5427,88,24,0,0,14,33,30,1,52,40,48,7,5],
		[5428,88,24,0,0,14,33,10,1,30,42,51,7,5],
		[5429,8,16,0,25,14,31,50,0,30,22,17,5,5],
		[5430,83,24,0,5,14,27,32,0,75,41,46,5,5],
		[5431,88,24,0,0,14,34,8,1,42,5,59,8,2],
		[5432,88,24,0,0,14,35,17,1,60,0,57,7,5],
		[5433,88,24,0,0,14,32,20,0,26,40,38,7,2],
		[5434,8,24,0,26,14,32,33,0,22,15,36,7,3],
		[5435,8,2,0,27,14,32,5,0,38,18,30,4,2],
		[5436,88,24,0,0,14,30,46,0,63,11,8,7,3],
		[5437,88,24,0,0,14,31,43,0,60,13,32,7,3],
		[5438,88,24,0,0,14,34,51,1,20,26,21,8,2],
		[5439,88,24,0,0,14,35,32,1,41,31,2,7,1],
		[5440,14,6,0,0,14,35,30,1,42,9,28,3,1],
		[5441,88,24,0,0,14,33,20,0,36,57,34,7,3],
		[5442,88,24,0,0,14,32,31,0,55,23,52,7,5],
		[5443,88,24,0,0,14,37,46,1,67,55,56,7,3],
		[5444,88,24,0,0,14,36,19,1,46,14,43,7,5],
		[5445,88,24,0,0,14,34,12,0,32,32,4,7,3],
		[5446,88,24,0,0,14,36,24,1,39,35,50,7,5],
		[5447,8,17,0,28,14,34,41,0,29,44,42,5,3],
		[5448,88,24,0,0,14,34,39,0,36,37,33,7,5],
		[5449,88,24,0,0,14,36,44,1,40,12,42,7,1],
		[5450,88,24,0,0,14,37,20,1,46,8,2,6,4],
		[5451,88,24,0,0,14,34,16,0,57,3,55,7,3],
		[5452,88,24,0,0,14,34,40,0,49,22,6,7,7],
		[5453,49,16,0,0,14,37,53,1,49,25,33,5,1],
		[5454,88,24,0,0,14,36,7,0,23,15,1,7,5],
		[5455,88,24,0,0,14,36,60,1,12,18,19,7,3],
		[5456,88,24,0,0,14,38,20,1,38,47,39,7,5],
		[5457,88,24,0,0,14,39,11,1,46,35,3,7,3],
		[5458,88,24,0,0,14,39,25,1,49,3,20,7,3],
		[5459,14,0,1,0,14,39,36,1,60,50,7,1,4],
		[5460,14,0,2,0,14,39,36,1,60,50,8,2,5],
		[5461,88,24,0,0,14,40,33,1,56,26,27,7,5],
		[5462,88,24,0,0,14,38,14,0,18,17,54,7,5],
		[5463,18,0,0,0,14,42,30,1,64,58,31,4,2],
		[5464,88,24,0,0,14,38,13,0,43,38,31,7,5],
		[5465,88,24,0,0,14,41,56,1,58,36,58,7,3],
		[5466,88,24,0,0,14,41,1,1,36,8,6,7,2],
		[5467,88,24,0,0,14,38,15,0,54,1,24,7,2],
		[5468,8,24,0,33,14,38,50,0,44,24,16,6,2],
		[5469,49,0,0,0,14,41,56,1,47,23,18,3,1],
		[5470,2,0,0,0,14,47,52,1,79,2,41,5,5],
		[5471,88,24,0,0,14,41,58,1,37,47,37,5,1],
		[5472,88,24,0,0,14,40,22,0,21,58,32,7,4],
		[5473,88,24,0,0,14,40,42,0,13,32,3,7,3],
		[5474,88,24,0,0,14,41,51,1,30,56,0,7,2],
		[5475,8,15,1,29,14,40,44,0,16,25,6,6,1],
		[5476,8,15,2,29,14,40,44,0,16,25,4,7,2],
		[5477,8,5,0,30,14,41,9,0,13,43,42,6,2],
		[5478,8,5,0,30,14,41,9,0,13,43,42,5,2],
		[5479,88,24,0,0,14,33,38,0,79,39,37,7,5],
		[5480,8,24,0,31,14,41,39,0,8,9,42,6,4],
		[5481,8,24,0,32,14,41,44,0,11,39,38,7,4],
		[5482,88,24,0,0,14,45,17,1,62,52,33,6,2],
		[5483,88,24,0,0,14,41,54,0,21,7,25,7,4],
		[5484,47,24,0,4,14,43,14,1,24,59,51,7,1],
		[5485,88,24,0,0,14,43,39,1,35,10,25,5,5],
		[5486,88,24,0,0,14,44,56,1,58,28,40,7,5],
		[5487,85,11,0,107,14,43,4,1,5,39,30,5,3],
		[5488,88,24,0,0,14,45,11,1,55,36,7,7,1],
		[5489,88,24,0,0,14,44,59,1,35,11,31,6,2],
		[5490,8,24,0,34,14,43,25,0,26,31,40,6,7],
		[5491,88,24,0,0,15,28,19,1,88,7,59,7,2],
		[5492,88,24,0,0,14,42,3,0,61,15,43,7,3],
		[5493,88,24,0,0,14,43,44,0,40,27,33,7,5],
		[5494,88,24,0,0,14,46,29,1,47,26,28,7,2],
		[5495,88,24,0,0,14,47,1,1,52,23,1,6,4],
		[5496,88,24,0,0,14,45,12,1,1,25,4,7,7],
		[5497,41,24,0,54,14,46,0,1,25,26,35,6,3],
		[5498,88,24,0,0,14,47,12,1,52,12,20,7,2],
		[5499,88,24,0,0,14,46,7,1,23,9,11,7,4],
		[5500,88,24,0,0,14,48,44,1,66,35,38,7,1],
		[5501,85,24,0,108,14,45,30,0,0,43,2,7,1],
		[5502,8,14,0,35,14,45,15,0,16,57,52,6,4],
		[5503,47,24,0,5,14,45,58,1,15,27,35,7,5],
		[5504,88,24,0,0,14,46,11,1,21,10,34,7,3],
		[5505,8,4,0,36,14,44,59,0,27,4,30,6,2],
		[5506,8,4,0,36,14,44,59,0,27,4,27,4,5],
		[5507,88,24,0,0,14,45,21,0,18,53,5,7,5],
		[5508,88,24,0,0,14,47,5,1,38,17,27,7,5],
		[5509,88,24,0,0,14,47,32,1,43,33,27,7,4],
		[5510,88,24,0,0,14,45,14,0,32,47,18,7,7],
		[5511,85,24,0,109,14,46,15,0,1,53,34,5,2],
		[5512,88,24,0,0,14,46,6,0,15,7,55,7,7],
		[5513,88,24,0,0,14,47,14,1,21,19,29,7,5],
		[5514,41,24,0,55,14,47,23,1,25,37,28,7,2],
		[5515,88,24,0,0,14,49,7,1,56,40,4,7,5],
		[5516,41,24,0,56,14,47,45,1,26,5,15,6,4],
		[5517,41,24,0,57,14,47,58,1,26,38,47,7,1],
		[5518,88,24,0,0,14,47,55,1,12,50,23,7,5],
		[5519,88,24,0,0,14,48,38,1,36,38,5,7,7],
		[5520,88,24,0,0,14,53,14,1,73,11,24,7,4],
		[5521,88,24,0,0,14,49,19,1,24,15,6,7,5],
		[5522,88,24,0,0,14,48,54,1,0,50,52,7,1],
		[5523,47,11,0,7,14,49,19,1,14,8,56,6,2],
		[5524,88,24,0,0,14,48,23,0,24,22,0,7,3],
		[5525,57,15,1,0,15,1,51,1,83,13,40,7,4],
		[5526,41,24,0,58,14,50,17,1,27,57,37,5,5],
		[5527,88,24,0,0,14,52,35,1,63,48,36,7,4],
		[5528,49,14,0,0,14,51,38,1,43,34,32,5,1],
		[5529,88,24,0,0,14,49,7,0,37,48,40,7,3],
		[5530,47,0,1,8,14,50,41,1,15,59,50,6,3],
		[5531,47,0,2,9,14,50,53,1,16,2,30,4,2],
		[5532,88,24,0,0,14,49,58,0,28,36,57,7,2],
		[5533,8,24,0,38,14,49,19,0,46,6,58,7,3],
		[5534,88,24,0,0,14,50,16,0,23,54,43,7,4],
		[5535,47,24,0,11,14,51,1,1,2,17,57,6,4],
		[5536,88,24,0,0,14,51,0,1,0,15,26,7,5],
		[5537,88,24,0,0,14,49,32,0,51,22,29,8,3],
		[5538,8,24,0,39,14,49,41,0,48,43,14,7,3],
		[5539,18,5,0,0,14,54,42,1,65,59,29,7,1],
		[5540,88,24,0,0,14,57,53,1,76,39,46,6,5],
		[5541,88,24,0,0,14,50,30,0,37,16,19,6,5],
		[5542,88,24,0,0,14,52,33,1,30,34,37,7,4],
		[5543,88,24,0,0,14,52,51,1,37,48,12,6,1],
		[5544,8,13,0,37,14,51,23,0,19,6,4,6,4],
		[5545,57,15,2,0,15,4,47,1,83,2,18,7,4],
		[5546,88,24,0,0,14,55,35,1,60,6,51,6,5],
		[5547,88,24,0,0,15,0,12,1,77,9,37,7,4],
		[5548,47,24,0,12,14,54,20,1,24,38,32,6,5],
		[5549,88,24,0,0,14,54,38,1,33,18,2,7,5],
		[5550,88,24,0,0,14,53,23,0,15,42,16,7,3],
		[5551,18,7,0,0,14,56,44,1,62,46,51,6,1],
		[5552,88,24,0,0,14,51,26,0,59,17,38,6,5],
		[5553,88,24,0,0,14,53,24,0,19,9,10,7,5],
		[5554,47,13,1,13,14,54,23,1,11,53,54,7,4],
		[5555,88,24,0,0,14,59,56,1,75,1,57,7,1],
		[5556,88,24,0,0,14,56,17,1,52,48,35,6,2],
		[5557,57,23,0,0,15,11,8,1,84,47,15,7,1],
		[5558,88,24,0,0,14,55,45,1,33,51,21,6,2],
		[5559,88,24,0,0,14,56,32,1,47,52,45,7,1],
		[5560,88,24,0,0,14,57,1,1,51,26,49,8,7],
		[5561,88,24,0,0,14,56,36,1,39,24,58,7,2],
		[5562,88,24,0,0,14,56,31,1,32,38,12,7,5],
		[5563,83,1,0,7,14,50,42,0,74,9,20,3,5],
		[5564,47,13,2,15,14,56,46,1,11,24,35,6,5],
		[5565,88,24,0,0,14,57,14,1,29,9,28,7,1],
		[5566,88,24,0,0,14,58,9,1,48,51,47,7,4],
		[5567,88,24,0,0,14,56,13,0,14,26,47,7,2],
		[5568,88,24,0,0,14,57,28,1,21,24,56,7,5],
		[5569,88,24,0,0,14,55,59,0,32,18,1,7,2],
		[5570,47,24,0,16,14,57,11,1,4,20,47,5,3],
		[5571,49,1,0,0,14,58,32,1,43,8,2,4,1],
		[5572,88,24,0,0,14,58,37,1,39,54,24,7,5],
		[5573,88,24,0,0,14,57,33,1,0,10,3,7,5],
		[5574,88,24,0,0,14,57,4,0,21,33,19,7,2],
		[5575,88,24,0,0,14,57,12,0,16,23,18,7,4],
		[5576,14,9,0,0,14,59,10,1,42,6,15,4,1],
		[5577,41,24,0,59,14,58,39,1,27,39,26,7,2],
		[5578,47,24,0,17,14,58,13,1,11,9,18,8,2],
		[5579,88,24,0,0,14,59,14,1,37,52,53,7,1],
		[5580,88,24,0,0,14,59,27,1,43,9,36,7,3],
		[5581,88,24,0,0,14,56,23,0,49,37,43,7,3],
		[5582,47,24,0,18,14,58,54,1,11,8,39,7,5],
		[5583,88,24,0,0,14,58,53,1,4,59,21,7,3],
		[5584,88,24,0,0,14,59,23,0,4,34,4,7,7],
		[5585,88,24,0,0,15,1,13,1,38,3,30,7,5],
		[5586,47,3,0,19,15,0,58,1,8,31,8,6,1],
		[5587,88,24,0,0,15,1,58,1,34,21,32,7,2],
		[5588,8,24,0,40,14,59,37,0,39,15,55,7,3],
		[5589,88,24,0,0,14,57,35,0,65,55,57,6,7],
		[5590,88,24,0,0,15,1,20,1,2,45,18,7,7],
		[5591,41,24,0,60,15,2,6,1,28,3,38,7,2],
		[5592,88,24,0,0,15,0,52,0,22,2,44,7,5],
		[5593,18,6,0,0,15,4,48,1,64,1,54,6,4],
		[5594,88,24,0,0,15,1,49,1,0,8,26,7,7],
		[5595,88,24,0,0,15,2,59,1,32,38,36,6,1],
		[5596,88,24,0,0,14,50,20,0,82,30,43,7,3],
		[5597,88,24,0,0,15,0,39,0,47,16,40,7,1],
		[5598,88,24,0,0,15,7,9,1,71,54,19,8,5],
		[5599,88,24,0,0,15,2,45,1,3,1,53,8,2],
		[5600,8,23,0,41,15,2,7,0,25,0,29,6,5],
		[5601,85,24,0,110,15,2,54,0,2,5,29,5,5],
		[5602,8,1,0,42,15,1,57,0,40,23,26,5,4],
		[5603,47,17,0,20,15,4,4,1,25,16,55,4,7],
		[5604,88,24,0,0,15,4,43,1,40,51,41,7,7],
		[5605,49,15,0,0,15,5,7,1,47,3,4,6,1],
		[5606,49,15,0,0,15,5,7,1,47,3,4,6,1],
		[5607,88,24,0,0,15,5,19,1,41,4,2,6,4],
		[5608,88,24,0,0,15,1,27,0,60,12,16,7,2],
		[5609,88,24,0,0,15,3,6,0,35,12,21,7,4],
		[5610,88,24,0,0,15,4,6,0,5,29,33,8,3],
		[5611,88,24,0,0,15,7,57,1,65,16,32,7,5],
		[5612,88,24,0,0,15,3,7,0,44,38,40,8,3],
		[5613,88,24,0,0,15,3,37,0,34,33,58,8,4],
		[5614,88,24,0,0,15,5,48,1,25,47,23,8,1],
		[5615,88,24,0,0,15,6,14,1,36,15,51,7,5],
		[5616,8,22,0,43,15,4,27,0,26,56,51,6,5],
		[5617,88,24,0,0,15,7,26,1,49,5,18,7,4],
		[5618,8,24,0,44,15,3,47,0,47,39,16,6,3],
		[5619,88,24,0,0,15,6,33,1,30,55,8,7,2],
		[5620,88,24,0,0,15,6,27,1,22,1,55,7,5],
		[5621,88,24,0,0,15,9,30,1,67,5,3,7,3],
		[5622,47,12,0,21,15,6,38,1,16,15,25,6,5],
		[5623,88,24,0,0,15,9,26,1,63,38,34,7,2],
		[5624,88,24,0,0,15,8,12,1,40,35,2,7,1],
		[5625,88,24,0,0,15,8,39,1,42,52,4,7,1],
		[5626,49,10,0,0,15,8,51,1,45,16,47,5,1],
		[5627,8,24,0,47,15,5,26,0,48,9,4,7,2],
		[5628,88,24,0,0,15,12,34,1,72,46,13,7,1],
		[5629,88,24,0,0,15,3,58,0,65,55,11,7,2],
		[5630,88,24,0,0,15,6,35,0,36,27,20,7,3],
		[5631,88,24,0,0,15,7,40,0,5,29,53,7,5],
		[5632,88,24,0,0,15,10,45,1,61,25,21,7,4],
		[5633,88,24,0,0,15,7,20,0,18,26,30,7,2],
		[5634,8,24,0,45,15,7,18,0,24,52,9,6,3],
		[5635,88,24,0,0,15,6,17,0,54,33,23,6,4],
		[5636,88,24,0,0,15,10,8,1,38,47,33,7,4],
		[5637,88,24,0,0,15,11,16,1,55,20,46,7,4],
		[5638,8,24,0,46,15,8,24,0,26,18,4,7,5],
		[5639,88,24,0,0,15,8,53,0,13,14,6,7,4],
		[5640,88,24,0,0,15,8,36,0,25,6,31,7,5],
		[5641,88,24,0,0,15,10,19,1,26,19,58,7,5],
		[5642,88,24,0,0,15,11,35,1,45,16,39,7,5],
		[5643,88,24,0,0,15,11,32,1,45,16,46,8,5],
		[5644,88,24,0,0,15,14,19,1,70,4,46,7,6],
		[5645,88,24,0,0,15,13,1,1,61,44,38,7,5],
		[5646,49,9,1,0,15,11,56,1,48,44,16,5,1],
		[5647,49,9,2,0,15,11,58,1,48,44,37,7,2],
		[5648,88,24,0,0,15,8,20,0,50,3,18,7,5],
		[5649,49,5,0,0,15,12,17,1,52,5,57,4,4],
		[5650,88,24,0,0,15,12,31,1,48,13,7,7,5],
		[5651,88,24,0,0,15,12,50,1,44,30,2,6,1],
		[5652,47,8,1,24,15,12,13,1,19,47,30,6,2],
		[5653,88,24,0,0,15,13,7,1,36,5,29,7,1],
		[5654,88,24,0,0,15,12,4,0,18,58,33,7,7],
		[5655,88,24,0,0,15,13,18,1,24,0,30,7,1],
		[5656,47,8,2,25,15,13,19,1,19,38,51,7,2],
		[5657,47,24,0,23,15,13,29,1,25,18,33,7,4],
		[5658,88,24,0,0,15,13,53,1,26,11,37,7,4],
		[5659,88,24,0,0,15,12,44,0,19,17,9,8,4],
		[5660,49,24,0,1,15,14,37,1,31,31,9,6,3],
		[5661,88,24,0,0,15,16,36,1,60,54,14,7,1],
		[5662,47,24,0,26,15,14,34,1,17,46,7,7,1],
		[5663,88,24,0,0,15,15,54,1,48,4,27,7,2],
		[5664,18,3,0,0,15,16,57,1,60,57,27,6,0],
		[5665,88,24,0,0,15,13,32,0,22,59,0,7,2],
		[5666,18,4,0,0,15,17,39,1,63,36,38,6,5],
		[5667,88,24,0,0,15,16,4,1,41,29,28,6,4],
		[5668,88,24,0,0,15,16,11,1,43,29,5,7,1],
		[5669,88,24,0,0,15,14,51,1,5,30,10,7,5],
		[5670,18,1,0,0,15,17,31,1,58,48,4,5,2],
		[5671,79,2,0,0,15,18,55,1,68,40,46,4,2],
		[5672,88,24,0,0,15,10,44,0,67,46,53,7,2],
		[5673,88,24,0,0,15,13,36,0,38,15,53,7,5],
		[5674,88,24,0,0,15,14,6,0,31,47,17,7,5],
		[5675,73,24,0,3,15,15,11,0,4,56,22,6,5],
		[5676,8,21,0,48,15,14,29,0,29,9,51,6,2],
		[5677,88,24,0,0,15,14,10,0,42,10,17,7,7],
		[5678,88,24,0,0,15,16,23,1,22,23,58,7,5],
		[5679,73,24,0,4,15,15,49,0,0,22,20,7,2],
		[5680,88,24,0,0,15,18,49,1,60,29,47,6,0],
		[5681,8,3,0,49,15,15,30,0,33,18,53,4,4],
		[5682,88,24,0,0,15,18,9,1,41,3,39,7,2],
		[5683,49,11,0,0,15,18,32,1,47,52,30,5,1],
		[5684,88,24,0,0,15,20,41,1,67,28,53,7,1],
		[5685,47,1,0,27,15,17,0,1,9,22,59,4,1],
		[5686,49,24,0,2,15,17,50,1,30,8,56,5,4],
		[5687,88,24,0,0,15,18,56,1,40,47,18,7,1],
		[5688,88,24,0,0,15,18,41,1,31,12,34,7,4],
		[5689,88,24,0,0,15,19,32,1,37,5,48,7,4],
		[5690,88,24,0,0,15,18,26,1,0,27,41,7,5],
		[5691,88,24,0,0,15,14,38,0,67,20,48,6,3],
		[5692,88,24,0,0,15,18,25,0,20,34,22,7,4],
		[5693,88,24,0,0,15,14,52,0,68,56,43,8,2],
		[5694,73,24,0,5,15,19,19,0,1,45,55,6,3],
		[5695,49,3,0,0,15,21,22,1,40,38,51,4,1],
		[5696,88,24,0,0,15,21,35,1,40,44,59,7,2],
		[5697,88,24,0,0,15,21,30,1,38,13,9,7,2],
		[5698,49,12,1,0,15,22,8,1,47,55,40,6,3],
		[5699,49,12,2,0,15,21,48,1,48,19,4,7,4],
		[5700,88,24,0,0,15,23,10,1,60,39,25,7,3],
		[5701,47,24,0,28,15,20,54,1,18,9,31,7,4],
		[5702,88,24,0,0,15,19,30,0,32,30,55,7,2],
		[5703,47,14,0,29,15,21,1,1,15,32,54,7,3],
		[5704,18,2,0,0,15,23,23,1,59,19,15,6,1],
		[5705,49,20,1,0,15,21,48,1,36,15,41,5,5],
		[5706,88,24,0,0,15,20,47,1,2,24,48,7,5],
		[5707,88,24,0,0,15,21,8,1,5,49,29,7,5],
		[5708,49,4,0,0,15,22,41,1,44,41,22,4,1],
		[5709,25,14,0,1,15,20,9,0,29,36,58,7,5],
		[5710,73,24,0,6,15,21,2,0,0,42,55,6,5],
		[5711,88,24,0,0,15,21,7,0,24,57,28,7,5],
		[5712,49,20,2,0,15,23,9,1,36,51,31,6,1],
		[5713,88,24,0,0,15,26,15,1,68,18,33,7,4],
		[5714,83,24,0,11,15,17,6,0,71,49,26,6,5],
		[5715,88,24,0,0,15,20,5,0,51,57,31,7,2],
		[5716,88,24,0,0,15,20,42,0,44,26,3,7,3],
		[5717,73,24,0,7,15,22,23,0,12,34,3,7,2],
		[5718,8,24,0,50,15,21,49,0,32,56,2,6,1],
		[5719,49,19,0,0,15,24,45,1,39,42,37,6,2],
		[5720,88,24,0,0,15,23,52,1,12,22,10,7,4],
		[5721,73,24,0,8,15,23,44,1,1,1,21,7,3],
		[5722,88,24,0,0,15,25,7,1,38,10,10,8,2],
		[5723,47,4,0,31,15,24,12,1,10,19,20,6,3],
		[5724,88,24,0,0,15,25,20,1,38,44,1,6,2],
		[5725,88,24,0,0,15,27,33,1,64,31,53,7,5],
		[5726,88,24,0,0,15,22,37,0,39,34,53,7,5],
		[5727,25,6,0,2,15,23,12,0,30,17,16,7,4],
		[5728,25,6,0,2,15,23,12,0,30,17,16,7,4],
		[5729,57,16,0,0,15,43,17,1,84,27,55,7,2],
		[5730,2,9,1,0,15,31,31,1,73,23,22,6,1],
		[5731,88,24,0,0,15,22,37,0,62,2,50,7,2],
		[5732,88,24,0,0,15,24,5,0,45,16,16,7,5],
		[5733,8,11,1,51,15,24,29,0,37,22,38,5,3],
		[5734,8,11,2,51,15,24,31,0,37,20,52,8,4],
		[5735,83,2,0,13,15,20,44,0,71,50,2,4,2],
		[5736,88,24,0,0,15,27,18,1,36,46,4,6,1],
		[5737,88,24,0,0,15,22,38,0,63,20,29,7,5],
		[5738,88,24,0,0,15,28,27,1,51,35,51,7,4],
		[5739,73,18,1,9,15,25,47,0,15,25,41,6,7],
		[5740,88,24,0,0,15,25,53,0,19,28,51,7,4],
		[5741,88,24,0,0,15,26,17,0,34,20,9,6,5],
		[5742,88,24,0,0,15,29,24,1,46,43,58,6,5],
		[5743,47,5,1,32,15,28,15,1,16,42,59,7,5],
		[5744,33,8,0,12,15,24,56,0,58,57,58,4,5],
		[5745,88,24,0,0,15,27,39,0,25,6,6,7,7],
		[5746,73,24,0,10,15,28,38,0,1,50,32,6,2],
		[5747,25,1,0,3,15,27,50,0,29,6,21,5,3],
		[5748,88,24,0,0,15,26,33,0,54,1,12,7,2],
		[5749,88,24,0,0,15,30,36,1,20,43,42,7,2],
		[5750,47,5,3,34,15,30,40,1,16,36,34,7,4],
		[5751,88,24,0,0,15,32,4,1,38,37,23,7,2],
		[5752,88,24,0,0,15,28,45,0,47,12,5,7,2],
		[5753,88,24,0,0,15,31,50,1,32,52,52,7,1],
		[5754,88,24,0,0,15,27,41,0,62,16,32,8,2],
		[5755,88,24,0,0,15,27,51,0,60,40,13,7,5],
		[5756,88,24,0,0,15,31,43,1,20,9,53,7,2],
		[5757,88,24,0,0,15,39,18,1,77,55,5,7,5],
		[5758,88,24,0,0,15,30,55,0,8,34,45,8,3],
		[5759,88,24,0,0,15,28,57,0,55,11,42,7,2],
		[5760,88,24,0,0,15,30,23,0,31,17,10,7,2],
		[5761,88,24,0,0,15,30,28,0,36,48,15,7,5],
		[5762,88,24,0,0,15,32,37,1,19,40,14,7,2],
		[5763,8,12,1,52,15,30,56,0,40,49,59,6,5],
		[5764,47,5,4,35,15,32,55,1,16,51,10,7,1],
		[5765,88,24,0,0,15,33,9,1,24,29,22,8,2],
		[5766,88,24,0,0,15,36,17,1,65,36,48,8,3],
		[5767,88,24,0,0,15,34,2,1,40,3,58,7,7],
		[5768,88,24,0,0,15,29,21,0,62,5,59,7,5],
		[5769,88,24,0,0,15,31,22,0,36,36,59,7,3],
		[5770,73,18,2,12,15,32,10,0,16,3,22,7,1],
		[5771,79,4,0,0,15,36,43,1,66,19,1,5,5],
		[5772,73,24,0,11,15,32,58,1,1,11,11,7,5],
		[5773,88,24,0,0,15,34,21,1,39,20,58,7,1],
		[5774,8,12,2,53,15,31,47,0,40,53,58,6,2],
		[5775,47,24,0,36,15,34,37,1,28,2,49,6,5],
		[5776,49,2,0,0,15,35,9,1,41,10,1,4,1],
		[5777,47,24,0,37,15,34,11,1,10,3,52,6,5],
		[5778,25,7,0,4,15,32,56,0,31,21,33,5,1],
		[5779,88,24,0,0,15,34,21,1,5,41,42,8,3],
		[5780,88,24,0,0,15,34,27,1,9,11,0,6,1],
		[5781,88,24,0,0,15,35,53,1,44,57,31,6,1],
		[5782,2,9,2,0,15,40,21,1,73,26,48,7,1],
		[5783,88,24,0,0,15,33,53,0,17,8,16,7,3],
		[5784,88,24,0,0,15,36,12,1,44,23,49,6,5],
		[5785,88,24,0,0,15,30,56,0,64,12,31,7,5],
		[5786,88,24,0,0,15,41,55,1,76,4,55,7,1],
		[5787,47,2,0,38,15,35,32,1,14,47,22,5,4],
		[5788,73,3,0,13,15,34,48,0,10,32,15,5,3],
		[5789,73,3,0,13,15,34,48,0,10,32,21,5,3],
		[5790,88,24,0,0,15,36,11,1,33,5,34,7,1],
		[5791,88,24,0,0,15,35,5,0,1,40,8,8,3],
		[5792,88,24,0,0,15,40,12,1,70,13,40,7,2],
		[5793,25,0,0,5,15,34,41,0,26,42,53,3,2],
		[5794,47,19,0,39,15,37,2,1,28,8,6,5,5],
		[5795,73,18,3,15,15,35,33,0,17,39,20,7,4],
		[5796,88,24,0,0,15,35,53,0,11,15,56,7,5],
		[5797,49,23,0,0,15,38,3,1,42,34,3,5,5],
		[5798,88,24,0,0,15,38,50,1,52,22,22,6,2],
		[5799,73,24,0,14,15,36,34,1,0,33,42,8,4],
		[5800,25,11,0,6,15,35,15,0,39,0,36,6,7],
		[5801,88,24,0,0,15,37,29,1,26,16,48,7,1],
		[5802,73,24,0,16,15,36,30,0,10,0,36,6,5],
		[5803,88,24,0,0,15,39,57,1,59,54,30,7,3],
		[5804,73,18,5,18,15,36,29,0,16,7,8,7,3],
		[5805,88,24,0,0,15,38,33,1,39,9,39,8,1],
		[5806,88,24,0,0,15,37,48,1,23,8,30,7,5],
		[5807,88,24,0,0,15,38,42,1,39,7,41,7,2],
		[5808,88,24,0,0,15,35,49,0,38,22,26,7,5],
		[5809,88,24,0,0,15,38,16,1,28,12,24,7,5],
		[5810,88,24,0,0,15,38,16,1,21,0,58,7,4],
		[5811,88,24,0,0,15,35,16,0,53,55,19,7,5],
		[5812,47,18,0,40,15,38,39,1,29,46,40,5,1],
		[5813,88,24,0,0,15,36,53,0,29,59,28,8,3],
		[5814,47,24,0,41,15,38,55,1,19,18,7,6,4],
		[5815,88,24,0,0,15,38,40,1,8,47,40,8,3],
		[5816,88,24,0,0,15,38,40,1,8,47,28,7,3],
		[5817,88,24,0,0,15,36,4,0,52,4,11,8,3],
		[5818,88,24,0,0,15,35,57,0,54,37,50,7,2],
		[5819,88,24,0,0,15,39,21,1,23,9,1,7,2],
		[5820,49,22,1,3,15,39,46,1,34,24,43,6,4],
		[5821,88,24,0,0,15,40,58,1,47,44,8,7,5],
		[5822,88,24,0,0,15,40,15,1,31,12,49,7,5],
		[5823,8,20,0,54,15,37,50,0,40,21,12,6,4],
		[5824,47,24,0,42,15,40,17,1,23,49,5,6,5],
		[5825,88,24,0,0,15,41,11,1,44,39,40,6,3],
		[5826,83,7,0,15,15,31,25,0,77,20,58,6,5],
		[5827,88,24,0,0,15,38,49,0,34,40,30,7,5],
		[5828,88,24,0,0,15,37,32,0,54,30,32,7,5],
		[5829,88,24,0,0,15,29,11,0,80,26,55,8,4],
		[5830,88,24,0,0,15,38,16,0,46,47,52,7,3],
		[5831,88,24,0,0,15,40,10,0,12,3,11,7,4],
		[5832,88,24,0,0,15,42,37,1,49,29,22,7,5],
		[5833,25,5,1,7,15,39,22,0,36,38,12,7,1],
		[5834,25,5,2,7,15,39,23,0,36,38,9,6,1],
		[5835,88,24,0,0,15,38,34,0,50,25,24,7,4],
		[5836,88,24,0,0,15,43,55,1,60,17,14,7,4],
		[5837,88,24,0,0,15,42,38,1,37,25,30,6,4],
		[5838,47,9,0,43,15,41,57,1,19,40,44,6,7],
		[5839,49,22,2,4,15,42,41,1,34,42,38,6,1],
		[5840,73,18,6,19,15,40,59,0,16,1,29,7,4],
		[5841,88,24,0,0,15,39,10,0,57,55,28,7,5],
		[5842,73,8,0,21,15,41,33,0,19,40,13,6,2],
		[5843,73,21,0,20,15,41,47,0,12,50,51,6,2],
		[5844,88,24,0,0,15,37,39,0,69,17,0,7,5],
		[5845,73,18,7,22,15,41,55,0,18,27,50,7,2],
		[5846,88,24,0,0,15,44,23,1,41,49,10,7,2],
		[5847,88,24,0,0,15,43,25,1,15,2,36,7,5],
		[5848,47,6,0,44,15,44,4,1,15,40,22,6,3],
		[5849,25,2,0,8,15,42,45,0,26,17,44,5,1],
		[5850,88,24,0,0,15,43,11,0,13,40,4,7,4],
		[5851,88,24,0,0,15,47,54,1,65,26,33,7,2],
		[5852,88,24,0,0,15,47,54,1,65,26,33,7,3],
		[5853,73,22,0,23,15,44,2,0,2,30,54,7,4],
		[5854,73,0,0,24,15,44,16,0,6,25,32,4,5],
		[5855,25,15,0,9,15,43,59,0,32,30,57,7,4],
		[5856,88,24,0,0,15,46,13,1,28,3,42,8,3],
		[5857,88,24,0,0,15,42,51,0,52,21,39,7,1],
		[5858,73,18,8,26,15,44,42,0,17,15,51,7,2],
		[5859,88,24,0,0,15,45,24,0,5,26,49,7,2],
		[5860,88,24,0,0,15,46,44,1,34,40,57,7,1],
		[5861,88,24,0,0,15,45,40,0,0,53,29,7,5],
		[5862,88,24,0,0,15,47,25,1,40,11,39,7,4],
		[5863,73,24,0,25,15,46,6,1,1,48,16,6,1],
		[5864,88,24,0,0,15,47,29,1,37,54,59,7,4],
		[5865,88,24,0,0,15,48,50,1,52,26,17,7,5],
		[5866,88,24,0,0,15,46,45,1,6,7,13,7,5],
		[5867,73,1,0,28,15,46,11,0,15,25,19,5,2],
		[5868,73,10,0,27,15,46,27,0,7,21,11,5,4],
		[5869,88,24,0,0,15,50,7,1,53,12,34,7,1],
		[5870,73,19,0,31,15,47,17,0,14,6,55,7,2],
		[5871,88,24,0,0,15,49,58,1,48,54,43,7,2],
		[5872,88,24,0,0,15,50,16,1,45,24,6,7,2],
		[5873,88,24,0,0,15,51,7,1,55,3,21,7,1],
		[5874,88,24,0,0,15,48,13,0,13,47,19,7,5],
		[5875,88,24,0,0,15,48,57,1,3,49,7,7,2],
		[5876,88,24,0,0,15,52,57,1,65,9,9,8,2],
		[5877,88,24,0,0,15,48,2,0,31,44,9,7,5],
		[5878,88,24,0,0,15,46,35,0,55,28,29,7,5],
		[5879,73,9,0,35,15,48,44,0,18,8,30,5,7],
		[5880,88,24,0,0,15,48,34,0,28,9,24,7,4],
		[5881,73,11,0,32,15,49,37,1,3,25,49,5,2],
		[5882,88,24,0,0,15,51,32,1,47,3,38,7,5],
		[5883,49,21,0,5,15,50,58,1,33,37,38,5,1],
		[5884,88,24,0,0,15,53,23,1,62,36,25,7,5],
		[5885,71,24,0,1,15,50,59,1,25,45,5,6,1],
		[5886,88,24,0,0,15,46,40,0,62,35,58,6,2],
		[5887,88,24,0,0,15,47,38,0,55,22,36,7,2],
		[5888,73,23,0,34,15,50,18,0,2,11,47,6,4],
		[5889,25,3,0,10,15,49,36,0,26,4,6,6,4],
		[5890,88,24,0,0,15,52,52,1,50,36,55,8,5],
		[5891,79,9,0,0,15,55,30,1,68,36,11,6,4],
		[5892,73,4,0,37,15,50,49,0,4,28,40,5,2],
		[5893,88,24,0,0,15,52,13,1,29,53,12,7,5],
		[5894,88,24,0,0,15,50,42,0,15,8,1,6,7],
		[5895,73,24,0,36,15,51,16,1,3,5,26,6,2],
		[5896,88,24,0,0,15,51,38,1,14,8,1,7,4],
		[5897,79,1,0,0,15,55,9,1,63,25,50,4,3],
		[5898,88,24,0,0,15,54,53,1,60,44,36,7,1],
		[5899,73,16,0,38,15,51,16,0,20,58,40,6,5],
		[5900,88,24,0,0,15,55,32,1,60,10,40,7,4],
		[5901,25,9,0,11,15,51,14,0,35,39,27,6,5],
		[5902,47,10,0,45,15,53,20,1,20,10,2,6,1],
		[5903,83,5,0,16,15,44,4,0,77,47,40,5,2],
		[5904,71,24,0,2,15,53,37,1,25,19,38,6,1],
		[5905,88,24,0,0,15,56,6,1,60,28,58,7,2],
		[5906,88,24,0,0,15,53,54,1,24,31,59,6,1],
		[5907,88,24,0,0,15,53,56,1,23,58,41,6,1],
		[5908,47,7,0,46,15,53,50,1,16,43,46,5,4],
		[5909,88,24,0,0,15,52,56,0,17,24,13,7,5],
		[5910,88,24,0,0,15,54,30,1,27,20,19,7,1],
		[5911,73,24,0,39,15,53,12,0,13,11,48,7,4],
		[5912,71,24,0,3,15,54,40,1,25,14,37,7,1],
		[5913,88,24,0,0,15,53,35,0,16,4,30,7,3],
		[5914,39,21,0,1,15,52,41,0,42,27,6,6,3],
		[5915,47,24,0,47,15,55,0,1,19,22,59,7,1],
		[5916,88,24,0,0,15,55,30,1,31,5,1,7,5],
		[5917,71,24,0,4,15,55,30,1,26,15,57,7,2],
		[5918,88,24,0,0,15,56,7,1,39,51,51,7,1],
		[5919,73,24,0,40,15,54,40,0,8,34,49,7,2],
		[5920,88,24,0,0,15,58,58,1,65,2,16,7,1],
		[5921,88,24,0,0,15,57,4,1,48,9,44,7,3],
		[5922,88,24,0,0,15,52,17,0,55,49,36,7,4],
		[5923,88,24,0,0,15,56,14,1,31,47,9,7,3],
		[5924,88,24,0,0,15,54,35,0,20,18,39,6,7],
		[5925,49,13,1,0,15,56,54,1,33,57,59,6,2],
		[5926,49,13,2,0,15,56,54,1,33,57,51,7,1],
		[5927,88,24,0,0,15,56,14,1,14,23,58,7,3],
		[5928,71,16,0,5,15,56,53,1,29,12,51,5,1],
		[5929,88,24,0,0,15,57,21,1,36,11,6,7,5],
		[5930,88,24,0,0,15,56,33,1,14,49,45,7,2],
		[5931,88,24,0,0,15,55,40,0,18,37,14,7,1],
		[5932,39,24,0,2,15,54,38,0,43,8,19,6,7],
		[5933,73,2,0,41,15,56,27,0,15,39,42,5,3],
		[5934,88,24,0,0,15,57,40,1,20,58,59,7,1],
		[5935,88,24,0,0,15,58,31,1,37,30,11,7,5],
		[5936,25,10,0,12,15,55,48,0,37,56,49,6,3],
		[5937,88,24,0,0,15,59,54,1,54,1,16,7,1],
		[5938,39,24,0,4,15,55,31,0,42,33,58,7,1],
		[5939,88,24,0,0,16,1,11,1,63,46,36,7,3],
		[5940,73,20,0,0,15,57,15,0,14,24,52,7,5],
		[5941,47,24,0,48,15,58,11,1,14,16,46,6,1],
		[5942,88,24,0,0,15,58,35,1,24,49,53,6,1],
		[5943,88,24,0,0,15,59,30,1,41,44,40,6,5],
		[5944,71,15,0,6,15,58,51,1,26,6,51,4,1],
		[5945,88,24,0,0,15,59,58,1,40,39,10,7,5],
		[5946,88,24,0,0,16,1,6,1,54,34,40,7,2],
		[5947,25,4,0,13,15,57,35,0,26,52,40,5,5],
		[5948,49,6,0,0,16,0,7,1,38,23,49,4,1],
		[5949,88,24,0,0,15,55,50,0,58,54,42,7,2],
		[5950,88,24,0,0,15,57,30,0,39,41,43,7,5],
		[5951,88,24,0,0,16,2,52,1,62,32,30,7,1],
		[5952,88,24,0,0,16,0,54,1,40,26,7,7,2],
		[5953,71,3,0,7,16,0,20,1,22,37,18,3,1],
		[5954,47,24,0,49,16,0,20,1,16,32,0,6,3],
		[5955,88,24,0,0,16,5,56,1,72,24,3,7,5],
		[5956,88,24,0,0,16,1,20,1,31,53,22,7,5],
		[5957,88,24,0,0,15,58,58,0,36,38,38,7,5],
		[5958,88,24,0,0,15,59,30,0,25,55,13,3,1],
		[5959,47,24,0,50,16,0,48,1,8,24,41,7,2],
		[5960,88,24,0,0,15,57,47,0,54,44,59,6,3],
		[5961,56,8,1,0,16,3,32,1,57,46,31,6,2],
		[5962,56,6,0,0,16,3,13,1,49,13,47,6,4],
		[5963,88,24,0,0,16,0,51,0,4,25,39,7,5],
		[5964,88,24,0,0,15,59,4,0,49,52,52,7,3],
		[5965,88,24,0,0,16,2,39,1,29,8,9,7,5],
		[5966,39,24,0,5,16,1,14,0,17,49,6,6,4],
		[5967,88,24,0,0,16,3,24,1,38,36,9,6,1],
		[5968,25,16,0,15,16,1,3,0,33,18,13,6,4],
		[5969,88,24,0,0,16,3,21,1,25,51,55,6,5],
		[5970,88,24,0,0,16,3,34,1,32,0,2,7,3],
		[5971,25,8,0,14,16,1,27,0,29,51,4,6,2],
		[5972,73,15,0,44,16,2,18,0,22,48,16,6,2],
		[5973,88,24,0,0,16,3,55,1,24,43,35,7,5],
		[5974,88,24,0,0,16,4,18,1,33,12,52,7,2],
		[5975,88,24,0,0,16,4,37,1,37,51,47,7,3],
		[5976,73,24,0,43,16,3,46,0,4,59,12,7,4],
		[5977,71,13,0,0,16,4,22,1,11,22,23,6,3],
		[5978,71,13,0,0,16,4,22,1,11,22,23,6,3],
		[5979,88,24,0,0,16,7,24,1,56,11,29,7,3],
		[5980,56,3,0,0,16,6,29,1,45,10,24,6,2],
		[5981,88,24,0,0,16,2,6,0,52,54,57,7,5],
		[5982,39,19,0,6,16,2,48,0,46,2,12,6,1],
		[5983,88,24,0,0,16,3,19,0,36,37,54,7,2],
		[5984,71,1,1,8,16,5,26,1,19,48,20,4,1],
		[5985,71,1,2,8,16,5,27,1,19,48,7,6,1],
		[5986,33,7,0,13,16,1,53,0,58,33,55,5,3],
		[5987,49,7,0,0,16,6,36,1,36,48,8,5,1],
		[5988,88,24,0,0,16,6,6,1,23,36,23,7,1],
		[5989,88,24,0,0,16,5,45,1,6,17,30,8,3],
		[5990,88,24,0,0,16,5,60,1,6,8,22,7,5],
		[5991,88,24,0,0,16,7,16,1,36,45,20,7,3],
		[5992,88,24,0,0,16,5,38,0,8,5,46,7,2],
		[5993,71,23,1,9,16,6,48,1,20,40,9,5,1],
		[5994,56,8,2,0,16,9,19,1,57,56,4,7,1],
		[5995,88,24,0,0,16,3,9,0,59,24,39,7,7],
		[5996,88,24,0,0,16,7,3,1,14,4,15,7,4],
		[5997,71,23,2,10,16,7,24,1,20,52,7,5,4],
		[5998,88,24,0,0,16,7,52,1,24,27,43,7,1],
		[5999,88,24,0,0,16,8,34,1,39,6,19,8,2],
		[6000,88,24,0,0,16,8,34,1,39,5,35,8,2],
		[6001,88,24,0,0,16,8,8,1,26,19,36,6,7],
		[6002,71,24,0,11,16,7,36,1,12,44,44,7,1],
		[6003,88,24,0,0,16,8,44,1,23,41,8,7,1],
		[6004,73,24,0,45,16,7,38,0,9,53,30,7,2],
		[6005,88,24,0,0,16,7,22,0,21,49,21,7,5],
		[6006,88,24,0,0,16,9,32,1,32,38,59,7,5],
		[6007,88,24,0,0,16,9,53,1,33,32,45,7,1],
		[6008,39,9,0,7,16,8,5,0,17,2,49,6,4],
		[6009,39,9,0,7,16,8,5,0,17,3,16,7,5],
		[6010,73,24,0,47,16,8,28,0,8,32,3,7,7],
		[6011,88,24,0,0,16,8,59,0,3,27,16,7,5],
		[6012,88,24,0,0,16,9,55,1,18,20,27,7,3],
		[6013,39,24,0,8,16,8,47,0,17,12,21,7,2],
		[6014,88,24,0,0,16,9,11,0,6,22,44,7,5],
		[6015,88,24,0,0,16,11,18,1,41,7,11,7,3],
		[6016,88,24,0,0,16,9,51,1,3,28,1,6,5],
		[6017,88,24,0,0,16,11,2,1,29,24,59,6,5],
		[6018,25,18,0,16,16,8,58,0,36,29,27,6,5],
		[6019,56,5,0,0,16,13,23,1,55,32,27,7,3],
		[6020,2,3,1,0,16,20,21,1,78,41,45,6,7],
		[6021,2,3,2,0,16,20,27,1,78,40,2,6,5],
		[6022,88,24,0,0,16,13,17,1,53,40,18,7,7],
		[6023,39,20,0,11,16,8,46,0,44,56,6,5,1],
		[6024,56,9,0,0,16,13,29,1,54,37,50,6,4],
		[6025,88,24,0,0,16,6,20,0,67,48,37,6,2],
		[6026,71,12,0,14,16,11,59,1,19,26,59,7,1],
		[6027,71,12,0,14,16,11,60,1,19,27,38,5,1],
		[6028,71,24,0,13,16,12,18,1,27,55,35,6,1],
		[6029,71,24,0,12,16,12,16,1,28,25,3,7,1],
		[6030,79,3,0,0,16,15,26,1,63,41,8,5,4],
		[6031,71,22,0,15,16,12,0,1,10,3,51,6,2],
		[6032,88,24,0,0,16,11,30,0,9,42,45,8,3],
		[6033,71,24,0,16,16,12,7,1,8,32,51,6,2],
		[6034,88,24,0,0,16,3,31,0,76,47,37,7,2],
		[6035,88,24,0,0,16,11,29,0,16,39,56,7,2],
		[6036,88,24,0,0,16,9,3,0,57,56,16,7,2],
		[6037,88,24,0,0,16,17,6,1,67,56,29,7,2],
		[6038,88,24,0,0,16,9,26,0,55,49,44,7,5],
		[6039,39,24,0,10,16,11,38,0,23,29,41,7,7],
		[6040,88,24,0,0,16,15,50,1,57,54,44,7,2],
		[6041,88,24,0,0,16,12,57,1,4,13,15,7,2],
		[6042,88,24,0,0,16,13,46,1,24,25,19,7,1],
		[6043,88,24,0,0,16,11,40,0,33,20,33,7,5],
		[6044,88,24,0,0,16,14,22,1,33,0,41,7,5],
		[6045,56,7,0,0,16,15,15,1,47,22,20,6,1],
		[6046,88,24,0,0,16,11,48,0,36,25,30,7,5],
		[6047,39,24,0,9,16,13,15,0,5,1,16,6,5],
		[6048,71,21,0,17,16,13,51,1,11,50,15,6,5],
		[6049,88,24,0,0,16,15,24,1,42,53,59,7,5],
		[6050,88,24,0,0,16,11,48,0,42,22,28,7,5],
		[6051,88,24,0,0,16,14,29,1,21,6,27,7,2],
		[6052,88,24,0,0,16,12,45,0,26,40,15,8,3],
		[6053,88,24,0,0,16,14,39,1,18,32,7,7,5],
		[6054,88,24,0,0,16,14,54,1,25,28,37,7,1],
		[6055,88,24,0,0,16,16,43,1,53,48,40,6,7],
		[6056,58,3,0,1,16,14,21,1,3,41,40,4,7],
		[6057,88,24,0,0,16,14,14,0,5,54,7,7,5],
		[6058,56,2,1,0,16,17,1,1,50,4,6,6,3],
		[6059,88,24,0,0,16,17,21,1,53,5,12,7,2],
		[6060,71,24,0,18,16,15,37,1,8,22,10,7,4],
		[6061,88,24,0,0,16,15,52,1,14,50,57,7,2],
		[6062,88,24,0,0,16,18,52,1,57,53,59,7,3],
		[6063,25,17,0,17,16,14,41,0,33,51,31,7,4],
		[6064,25,17,0,17,16,14,41,0,33,51,30,8,4],
		[6065,39,24,0,16,16,15,29,0,18,48,30,7,5],
		[6066,88,24,0,0,16,16,59,1,21,18,14,8,1],
		[6067,88,24,0,0,16,16,55,1,3,57,12,7,2],
		[6068,88,24,0,0,16,15,47,0,27,25,20,7,5],
		[6069,88,24,0,0,16,12,25,0,67,8,39,7,4],
		[6070,88,24,0,0,16,18,18,1,28,36,50,6,2],
		[6071,56,10,0,0,16,19,18,1,42,40,26,6,2],
		[6072,56,2,2,0,16,19,50,1,50,9,20,5,4],
		[6073,88,24,0,0,16,20,25,1,55,8,24,7,5],
		[6074,25,19,0,18,16,16,45,0,29,9,1,7,2],
		[6075,58,4,0,2,16,18,19,1,4,41,33,4,4],
		[6076,88,24,0,0,16,19,8,1,20,13,4,7,5],
		[6077,88,24,0,0,16,19,33,1,30,54,24,6,3],
		[6078,88,24,0,0,16,19,0,1,14,52,21,7,5],
		[6079,83,24,0,19,16,10,50,0,75,52,39,6,1],
		[6080,88,24,0,0,16,20,33,1,39,25,51,7,1],
		[6081,71,14,0,19,16,20,38,1,24,10,10,6,2],
		[6082,83,24,0,20,16,12,32,0,75,12,38,7,5],
		[6083,88,24,0,0,16,22,28,1,49,34,20,6,1],
		[6084,71,17,0,20,16,21,11,1,25,35,34,4,1],
		[6085,88,24,0,0,16,22,29,1,43,54,44,7,4],
		[6086,88,24,0,0,16,17,15,0,59,45,18,6,7],
		[6087,88,24,0,0,16,20,4,0,21,7,57,7,4],
		[6088,88,24,0,0,16,14,34,0,73,23,42,7,2],
		[6089,88,24,0,0,16,25,22,1,63,7,29,7,2],
		[6090,88,24,0,0,16,19,11,0,49,2,17,7,5],
		[6091,88,24,0,0,16,19,55,0,39,42,31,6,3],
		[6092,39,18,0,22,16,19,44,0,46,18,48,5,1],
		[6093,73,17,0,50,16,22,4,0,1,1,45,6,3],
		[6094,88,24,0,0,16,24,1,1,39,11,35,6,4],
		[6095,39,2,0,20,16,21,55,0,19,9,11,5,2],
		[6096,88,24,0,0,16,22,39,1,2,4,47,7,1],
		[6097,88,24,0,0,16,23,57,1,33,11,58,7,2],
		[6098,79,5,0,0,16,28,28,1,70,5,4,6,3],
		[6099,88,24,0,0,16,24,54,1,45,20,57,7,2],
		[6100,88,24,0,0,16,24,32,1,37,33,57,6,1],
		[6101,88,24,0,0,16,18,9,0,68,33,16,7,5],
		[6102,2,2,0,0,16,33,27,1,78,53,50,5,4],
		[6103,25,13,0,19,16,22,6,0,30,53,31,6,5],
		[6104,58,22,0,4,16,24,6,1,20,2,15,6,5],
		[6105,88,24,0,0,16,24,40,1,29,42,12,8,4],
		[6106,88,24,0,0,16,24,40,1,29,42,17,7,4],
		[6107,25,12,1,20,16,22,21,0,33,47,57,6,7],
		[6108,25,12,2,21,16,22,29,0,33,42,13,6,5],
		[6109,79,8,0,0,16,27,57,1,64,3,29,6,3],
		[6110,88,24,0,0,16,22,57,0,32,19,59,7,2],
		[6111,39,24,0,21,16,24,11,0,6,56,53,7,2],
		[6112,58,16,0,5,16,25,35,1,23,26,50,6,1],
		[6113,58,16,0,5,16,25,35,1,23,26,46,7,1],
		[6114,88,24,0,0,16,28,15,1,58,35,59,7,1],
		[6115,56,4,0,0,16,27,11,1,47,33,18,5,1],
		[6116,83,6,0,21,16,17,30,0,75,45,19,6,3],
		[6117,39,23,0,24,16,25,25,0,14,2,0,6,1],
		[6118,58,21,0,7,16,27,1,1,18,27,23,5,1],
		[6119,88,24,0,0,16,25,48,0,18,53,33,8,7],
		[6120,88,24,0,0,16,29,45,1,57,45,21,7,4],
		[6121,88,24,0,0,16,26,12,0,11,24,27,7,4],
		[6122,88,24,0,0,16,28,15,1,37,10,46,7,5],
		[6123,39,24,0,25,16,25,24,0,37,23,38,7,2],
		[6124,88,24,0,0,16,26,50,0,2,20,51,7,4],
		[6125,88,24,0,0,16,30,49,1,61,38,1,6,5],
		[6126,88,24,0,0,16,21,49,0,69,6,34,6,5],
		[6127,88,24,0,0,16,24,25,0,55,12,18,7,2],
		[6128,88,24,0,0,16,27,44,1,7,35,53,6,7],
		[6129,58,19,0,3,16,27,48,1,8,22,18,6,2],
		[6130,88,24,0,0,16,23,47,0,61,41,48,7,4],
		[6131,88,24,0,0,16,29,42,1,46,14,36,6,1],
		[6132,33,6,0,14,16,23,60,0,61,30,51,4,4],
		[6133,88,24,0,0,17,15,59,1,87,33,59,8,4],
		[6134,71,0,0,21,16,29,24,1,26,25,55,2,7],
		[6135,88,24,0,0,16,34,19,1,70,59,17,7,5],
		[6136,88,24,0,0,16,28,34,0,0,39,54,6,5],
		[6137,88,24,0,0,16,28,49,1,8,7,44,7,3],
		[6138,88,24,0,0,16,45,54,1,83,14,20,8,5],
		[6139,88,24,0,0,17,0,59,1,86,21,52,7,2],
		[6140,88,24,0,0,16,29,47,1,14,33,3,7,4],
		[6141,71,24,0,22,16,30,12,1,25,6,54,6,1],
		[6142,88,24,0,0,16,31,42,1,41,49,1,6,1],
		[6143,88,24,0,0,16,31,23,1,34,42,16,5,1],
		[6144,88,24,0,0,16,30,30,1,7,30,54,8,2],
		[6145,88,24,0,0,16,31,23,1,26,32,16,7,5],
		[6146,39,24,0,30,16,28,39,0,41,52,54,6,7],
		[6147,58,20,0,8,16,31,8,1,16,36,46,5,4],
		[6148,39,1,0,27,16,30,13,0,21,29,23,4,4],
		[6149,58,10,0,10,16,30,55,0,1,59,2,5,2],
		[6150,88,24,0,0,16,28,43,0,51,24,28,7,4],
		[6151,79,7,0,0,16,35,45,1,65,29,43,7,4],
		[6152,88,24,0,0,16,30,34,0,20,28,45,6,4],
		[6153,58,23,0,9,16,32,8,1,21,27,59,5,2],
		[6154,88,24,0,0,16,31,13,0,22,11,43,7,5],
		[6155,56,11,0,0,16,34,5,1,44,2,43,6,1],
		[6156,39,24,0,34,16,30,6,0,48,57,39,7,2],
		[6157,88,24,0,0,16,31,3,0,35,13,30,7,5],
		[6158,39,24,0,28,16,32,36,0,5,31,16,7,1],
		[6159,39,24,0,29,16,32,36,0,11,29,17,6,5],
		[6160,88,24,0,0,16,35,8,1,45,14,41,7,5],
		[6161,33,24,0,15,16,27,59,0,68,46,5,6,2],
		[6162,88,24,0,0,16,31,47,0,45,35,54,7,2],
		[6163,2,1,0,0,16,43,5,1,77,31,3,5,5],
		[6164,88,24,0,0,16,36,23,1,42,51,32,6,0],
		[6165,71,18,0,23,16,35,53,1,28,12,58,4,1],
		[6166,88,24,0,0,16,36,23,1,35,15,20,5,5],
		[6167,88,24,0,0,16,38,53,1,60,59,25,7,1],
		[6168,39,17,0,35,16,34,6,0,42,26,13,5,1],
		[6169,88,24,0,0,16,35,26,0,17,3,26,7,2],
		[6170,88,24,0,0,16,32,26,0,60,49,24,7,2],
		[6171,58,24,0,12,16,36,22,1,2,19,29,7,5],
		[6172,79,6,1,0,16,41,23,1,68,17,46,7,1],
		[6173,88,24,0,0,16,25,43,0,78,57,50,7,3],
		[6174,88,24,0,0,16,38,26,1,43,23,55,7,1],
		[6175,58,5,0,13,16,37,10,1,10,34,2,4,0],
		[6176,88,24,0,0,16,36,43,0,15,29,53,7,1],
		[6177,88,24,0,0,16,40,51,1,60,26,46,7,3],
		[6178,88,24,0,0,16,39,5,1,37,13,3,7,1],
		[6179,88,24,0,0,16,38,2,1,6,32,17,7,2],
		[6180,88,24,0,0,16,31,28,0,72,36,43,7,5],
		[6181,88,24,0,0,16,37,48,0,13,41,13,7,3],
		[6182,88,24,0,0,16,43,22,1,67,25,57,7,2],
		[6183,88,24,0,0,16,36,11,0,46,36,48,7,4],
		[6184,33,24,0,16,16,36,12,0,52,54,1,7,1],
		[6185,33,24,0,17,16,36,14,0,52,55,28,6,1],
		[6186,33,24,0,17,16,36,14,0,52,55,27,8,2],
		[6187,88,24,0,0,16,41,20,1,48,45,47,7,0],
		[6188,88,24,0,0,16,41,40,1,49,39,6,7,1],
		[6189,88,24,0,0,16,39,39,1,9,33,16,7,3],
		[6190,88,24,0,0,16,40,35,1,20,24,31,7,4],
		[6191,88,24,0,0,16,30,39,0,77,26,48,7,5],
		[6192,88,24,0,0,16,41,46,1,33,8,47,7,4],
		[6193,88,24,0,0,16,41,36,1,24,28,5,7,3],
		[6194,39,24,0,36,16,40,35,0,4,12,26,8,2],
		[6195,39,24,0,37,16,40,39,0,4,13,11,7,2],
		[6196,88,24,0,0,16,41,34,1,17,44,32,6,4],
		[6197,88,24,0,0,16,43,3,1,46,4,14,7,3],
		[6198,88,24,0,0,16,36,55,0,63,4,22,7,5],
		[6199,88,24,0,0,16,38,0,0,56,0,56,6,5],
		[6200,39,24,0,42,16,38,45,0,48,55,42,6,7],
		[6201,88,24,0,0,16,41,12,1,1,0,2,7,2],
		[6202,88,24,0,0,16,41,54,1,19,55,28,7,3],
		[6203,88,24,0,0,16,40,51,0,12,23,42,7,2],
		[6204,88,24,0,0,16,46,40,1,67,6,35,6,2],
		[6205,58,24,0,14,16,41,43,0,1,10,52,7,3],
		[6206,88,24,0,0,16,43,46,1,41,7,8,7,2],
		[6207,88,24,0,0,16,44,40,1,53,9,9,7,4],
		[6208,88,24,0,0,16,41,1,0,24,51,31,7,5],
		[6209,88,24,0,0,16,43,54,1,41,6,47,7,1],
		[6210,88,24,0,0,16,43,48,1,38,9,24,7,1],
		[6211,88,24,0,0,16,43,39,1,32,6,22,7,1],
		[6212,39,5,0,40,16,41,17,0,31,36,11,4,4],
		[6213,39,24,0,39,16,41,37,0,26,55,1,7,3],
		[6214,88,24,0,0,16,44,43,1,40,50,23,7,1],
		[6215,88,24,0,0,16,46,21,1,58,30,13,7,1],
		[6216,88,24,0,0,16,44,17,1,27,27,22,8,2],
		[6217,79,0,0,0,16,48,40,1,69,1,40,3,5],
		[6218,88,24,0,0,16,45,0,1,28,30,35,7,2],
		[6219,88,24,0,0,16,47,20,1,58,20,29,7,1],
		[6220,39,6,0,44,16,42,54,0,38,55,20,5,4],
		[6221,88,24,0,0,16,46,48,1,39,22,38,6,5],
		[6222,88,24,0,0,16,43,52,0,34,2,20,7,3],
		[6223,33,24,0,18,16,40,55,0,64,35,21,6,5],
		[6224,58,24,0,16,16,45,30,0,1,1,13,7,1],
		[6225,71,24,0,25,16,46,51,1,25,31,43,8,4],
		[6226,88,24,0,0,16,42,58,0,55,41,25,7,2],
		[6227,88,24,0,0,16,45,23,0,15,44,43,7,7],
		[6228,39,24,0,43,16,45,50,0,8,34,57,6,5],
		[6229,5,6,0,0,16,49,47,1,59,2,29,5,5],
		[6230,88,24,0,0,16,45,12,0,43,13,2,7,5],
		[6231,88,24,0,0,16,52,17,1,67,40,55,7,5],
		[6232,58,24,0,19,16,47,10,0,2,3,52,7,2],
		[6233,88,24,0,0,16,51,54,1,65,22,32,7,1],
		[6234,39,24,0,45,16,47,46,0,5,14,48,6,1],
		[6235,88,24,0,0,16,48,27,1,14,54,34,7,2],
		[6236,88,24,0,0,16,50,36,1,50,2,44,7,2],
		[6237,88,24,0,0,16,45,18,0,56,46,55,6,3],
		[6238,88,24,0,0,16,37,53,0,78,55,6,7,4],
		[6239,88,24,0,0,16,48,9,0,13,35,26,7,4],
		[6240,88,24,0,0,16,49,28,1,15,40,3,7,2],
		[6241,71,4,0,26,16,50,10,1,34,17,36,3,5],
		[6242,88,24,0,0,16,47,20,0,42,14,20,7,7],
		[6243,58,24,0,20,16,49,50,1,10,46,59,6,3],
		[6244,88,24,0,0,16,50,60,1,37,30,52,7,1],
		[6245,88,24,0,0,16,51,34,1,41,13,50,6,0],
		[6246,88,24,0,0,16,49,35,0,13,15,41,7,2],
		[6247,71,11,1,0,16,51,52,1,38,2,51,4,1],
		[6248,88,24,0,0,16,50,22,1,2,39,14,7,3],
		[6249,88,24,0,0,16,52,19,1,41,51,16,7,2],
		[6250,39,24,0,47,16,50,19,0,7,14,52,6,2],
		[6251,88,24,0,0,16,54,1,1,57,54,34,7,7],
		[6252,71,11,2,0,16,52,20,1,38,1,3,5,1],
		[6253,88,24,0,0,16,55,25,1,63,16,11,7,2],
		[6254,39,24,0,52,16,49,14,0,45,59,0,6,2],
		[6255,58,24,0,21,16,51,25,0,1,12,58,7,2],
		[6256,88,24,0,0,16,49,41,0,43,25,50,7,5],
		[6257,88,24,0,0,16,53,43,1,43,3,3,7,7],
		[6258,39,24,0,50,16,50,39,0,29,48,24,7,7],
		[6259,88,24,0,0,16,50,43,0,32,33,13,7,5],
		[6260,88,24,0,0,16,54,2,1,41,48,23,6,1],
		[6261,88,24,0,0,16,53,59,1,41,59,41,7,1],
		[6262,71,5,1,0,16,53,60,1,42,21,44,6,1],
		[6263,88,24,0,0,16,54,12,1,41,51,1,7,0],
		[6264,88,24,0,0,16,50,36,0,41,53,48,7,5],
		[6265,88,24,0,0,16,54,20,1,41,49,12,8,0],
		[6266,88,24,0,0,16,54,27,1,42,28,44,7,3],
		[6267,88,24,0,0,16,43,6,0,77,30,51,7,3],
		[6268,39,24,0,49,16,52,5,0,14,58,27,8,1],
		[6269,88,24,0,0,16,53,25,1,20,24,56,7,4],
		[6270,39,24,0,51,16,51,45,0,24,39,23,6,5],
		[6271,71,5,2,0,16,54,35,1,42,21,41,5,5],
		[6272,88,24,0,0,16,54,58,1,41,9,4,7,0],
		[6273,88,24,0,0,16,54,36,1,30,35,14,7,2],
		[6274,88,24,0,0,16,56,9,1,50,40,30,7,1],
		[6275,88,24,0,0,16,56,29,1,52,17,2,7,1],
		[6276,88,24,0,0,16,59,34,1,69,16,6,7,2],
		[6277,88,24,0,0,16,54,11,1,1,36,44,7,3],
		[6278,88,24,0,0,16,54,40,1,11,47,33,8,2],
		[6279,39,24,0,53,16,52,58,0,31,42,6,6,3],
		[6280,58,24,0,23,16,54,36,1,6,9,14,6,5],
		[6281,58,8,0,25,16,54,1,0,10,9,55,5,1],
		[6282,88,24,0,0,16,55,58,1,33,30,26,7,5],
		[6283,88,24,0,0,16,56,36,1,40,49,25,7,1],
		[6284,88,24,0,0,16,56,2,1,16,48,22,7,5],
		[6285,5,5,0,0,16,58,37,1,55,59,25,4,5],
		[6286,88,24,0,0,16,53,18,0,47,25,1,7,5],
		[6287,88,24,0,0,16,54,55,0,20,57,31,6,4],
		[6288,71,24,0,27,16,57,11,1,33,15,34,6,5],
		[6289,88,24,0,0,16,58,18,1,50,38,28,7,1],
		[6290,88,24,0,0,16,55,16,0,13,37,11,7,3],
		[6291,58,24,0,24,16,56,48,1,23,9,0,7,2],
		[6292,39,24,0,56,16,55,2,0,25,43,50,7,4],
		[6293,39,24,0,54,16,55,22,0,18,26,0,6,5],
		[6294,88,24,0,0,16,57,4,1,19,32,24,7,1],
		[6295,5,4,1,0,16,59,35,1,53,9,38,5,5],
		[6296,88,24,0,0,16,57,26,1,10,57,48,7,4],
		[6297,88,24,0,0,17,0,6,1,54,35,49,7,2],
		[6298,88,24,0,0,16,58,52,1,37,37,16,7,2],
		[6299,58,9,0,27,16,57,40,0,9,22,30,4,5],
		[6300,88,24,0,0,17,0,27,1,48,38,52,7,4],
		[6301,88,24,0,0,16,57,32,0,13,53,3,7,5],
		[6302,88,24,0,0,16,58,42,1,14,52,11,8,3],
		[6303,88,24,0,0,17,0,32,1,45,27,6,8,5],
		[6304,88,24,0,0,17,1,47,1,58,57,30,7,1],
		[6305,39,24,0,57,16,57,31,0,25,21,10,7,4],
		[6306,88,24,0,0,16,56,6,0,50,2,20,8,7],
		[6307,88,24,0,0,16,57,42,0,24,22,53,7,5],
		[6308,88,24,0,0,16,59,58,1,25,5,31,7,7],
		[6310,58,24,0,26,17,0,10,1,24,59,21,7,3],
		[6311,88,24,0,0,17,0,37,1,35,56,3,7,5],
		[6312,88,24,0,0,17,1,46,1,51,7,51,7,2],
		[6313,88,24,0,0,16,57,50,0,42,30,45,7,5],
		[6314,5,4,2,0,17,3,9,1,53,14,13,6,3],
		[6315,33,24,0,19,16,56,2,0,65,8,5,6,3],
		[6316,88,24,0,0,17,1,53,1,32,8,37,6,1],
		[6317,88,24,0,0,17,0,29,0,6,35,1,8,2],
		[6318,58,24,0,30,17,1,4,1,4,13,21,6,5],
		[6319,33,24,0,20,16,56,25,0,65,2,21,7,3],
		[6320,88,24,0,0,17,4,25,1,57,42,44,7,1],
		[6321,58,24,0,29,17,1,51,1,18,53,8,7,5],
		[6322,83,4,0,22,16,45,58,0,82,2,14,5,4],
		[6323,88,24,0,0,17,3,42,1,47,9,36,7,2],
		[6324,39,4,0,58,17,0,17,0,30,55,35,5,2],
		[6325,88,24,0,0,17,0,58,0,22,37,56,7,5],
		[6326,88,24,0,0,17,1,33,0,14,56,58,7,1],
		[6327,88,24,0,0,17,3,51,1,38,9,8,7,3],
		[6328,88,24,0,0,17,1,10,0,27,11,47,8,3],
		[6329,88,24,0,0,17,1,59,0,8,27,2,7,2],
		[6330,88,24,0,0,16,59,22,0,56,41,19,7,5],
		[6331,88,24,0,0,17,5,5,1,45,30,6,7,2],
		[6332,39,24,0,59,17,1,36,0,33,34,6,6,2],
		[6333,88,24,0,0,17,2,19,0,25,30,20,7,4],
		[6334,88,24,0,0,17,4,49,1,34,7,22,6,1],
		[6335,88,24,0,0,16,56,17,0,73,7,40,7,3],
		[6336,88,24,0,0,17,2,17,0,31,53,5,7,5],
		[6337,88,24,0,0,17,3,8,0,14,5,31,6,7],
		[6338,88,24,0,0,17,5,49,1,44,6,18,7,2],
		[6339,88,24,0,0,17,3,10,0,14,30,40,8,4],
		[6340,88,24,0,0,17,4,45,1,20,29,41,7,1],
		[6341,88,24,0,0,17,3,39,0,13,36,19,7,2],
		[6342,88,24,0,0,17,3,58,0,13,34,3,7,5],
		[6343,88,24,0,0,17,3,53,0,19,41,26,7,5],
		[6344,88,24,0,0,17,6,20,1,37,13,39,7,2],
		[6345,88,24,0,0,16,59,3,0,69,11,11,7,5],
		[6346,39,24,0,61,17,3,30,0,35,24,51,8,7],
		[6347,88,24,0,0,17,6,28,1,35,27,4,7,0],
		[6348,88,24,0,0,17,1,17,0,60,38,57,7,5],
		[6349,88,24,0,0,17,5,17,0,0,42,9,7,3],
		[6350,88,24,0,0,17,6,12,1,21,33,53,7,2],
		[6351,88,24,0,0,17,3,54,0,34,47,25,7,2],
		[6352,88,24,0,0,17,4,41,0,19,35,57,7,1],
		[6353,88,24,0,0,17,5,32,1,0,53,31,7,1],
		[6354,88,24,0,0,17,6,53,1,26,30,47,7,2],
		[6355,39,24,0,60,17,5,23,0,12,44,27,6,2],
		[6356,88,24,0,0,17,10,6,1,61,40,32,7,1],
		[6357,88,24,0,0,17,12,20,1,70,43,16,7,5],
		[6358,88,24,0,0,17,6,10,0,9,44,0,7,5],
		[6359,88,24,0,0,17,6,13,0,10,27,15,7,4],
		[6360,88,24,0,0,17,2,15,0,64,36,2,7,4],
		[6361,88,24,0,0,17,6,53,1,1,39,23,7,2],
		[6362,88,24,0,0,17,5,5,0,43,48,44,7,2],
		[6363,88,24,0,0,17,4,50,0,48,48,15,7,5],
		[6364,88,24,0,0,17,6,18,0,22,5,3,7,5],
		[6365,88,24,0,0,17,8,15,1,17,36,33,7,5],
		[6366,88,24,0,0,17,8,48,1,30,24,13,7,2],
		[6367,88,24,0,0,17,8,14,1,1,4,46,7,2],
		[6368,88,24,0,0,17,13,18,1,67,11,48,7,5],
		[6369,33,11,0,21,17,5,20,0,54,28,13,7,3],
		[6370,33,11,0,21,17,5,20,0,54,28,13,7,3],
		[6371,88,24,0,0,17,10,42,1,44,33,27,6,4],
		[6372,88,24,0,0,17,8,55,1,3,52,58,7,4],
		[6373,88,24,0,0,17,16,36,1,74,31,59,7,2],
		[6374,88,24,0,0,17,11,39,1,48,52,27,7,7],
		[6375,88,24,0,0,17,9,48,1,10,31,24,7,3],
		[6376,88,24,0,0,17,7,47,0,40,30,58,7,2],
		[6377,88,24,0,0,17,8,2,0,35,56,7,6,2],
		[6378,58,6,0,35,17,10,23,1,15,43,29,3,2],
		[6379,88,24,0,0,17,1,40,0,75,17,50,7,3],
		[6380,71,6,0,0,17,12,9,1,43,14,21,4,3],
		[6381,88,24,0,0,17,12,16,1,39,30,25,7,2],
		[6382,88,24,0,0,17,12,17,1,38,49,20,7,5],
		[6383,88,24,0,0,17,8,17,0,50,50,32,7,2],
		[6384,88,24,0,0,17,14,13,1,56,53,18,7,7],
		[6385,88,24,0,0,17,10,46,0,12,28,2,8,2],
		[6386,88,24,0,0,17,12,14,1,25,15,17,8,2],
		[6387,88,24,0,0,17,12,25,1,27,45,43,7,1],
		[6388,88,24,0,0,17,9,33,0,40,46,38,6,5],
		[6389,88,24,0,0,17,12,59,1,32,26,19,7,1],
		[6390,88,24,0,0,17,11,45,0,7,53,41,7,5],
		[6391,39,24,0,63,17,11,3,0,24,14,16,7,2],
		[6392,88,24,0,0,17,14,28,1,39,46,1,8,4],
		[6393,58,24,0,37,17,12,28,0,10,35,7,6,7],
		[6394,88,24,0,0,17,12,54,0,0,21,7,8,3],
		[6395,88,24,0,0,17,10,31,0,52,24,32,7,1],
		[6396,33,5,0,22,17,8,47,0,65,42,53,4,1],
		[6397,88,24,0,0,17,15,19,1,33,32,54,7,0],
		[6398,88,24,0,0,17,15,36,1,38,35,38,7,3],
		[6399,88,24,0,0,17,11,40,0,49,44,48,7,2],
		[6400,88,24,0,0,17,20,13,1,70,2,44,8,4],
		[6401,58,24,0,36,17,15,21,1,26,36,10,6,5],
		[6402,58,24,0,36,17,15,21,1,26,36,5,6,5],
		[6403,88,24,0,0,17,15,52,1,30,12,38,7,1],
		[6404,88,24,0,0,17,15,20,1,14,35,2,7,5],
		[6405,88,24,0,0,17,16,22,1,35,44,58,7,4],
		[6406,39,0,1,64,17,14,39,0,14,23,25,4,7],
		[6407,39,0,2,64,17,14,39,0,14,23,24,6,4],
		[6408,88,24,0,0,17,19,12,1,59,41,40,7,5],
		[6409,88,24,0,0,17,17,4,1,32,39,46,7,3],
		[6410,39,3,0,65,17,15,2,0,24,50,21,4,2],
		[6411,2,8,0,0,17,22,6,1,70,7,24,6,1],
		[6412,88,24,0,0,17,16,14,0,2,11,10,7,2],
		[6413,88,24,0,0,17,16,43,1,6,14,42,7,5],
		[6414,88,24,0,0,17,16,32,0,1,12,38,7,1],
		[6415,58,24,0,41,17,16,37,1,0,26,43,6,5],
		[6416,88,24,0,0,17,19,3,1,46,38,2,6,4],
		[6417,2,5,0,0,17,21,59,1,67,46,14,6,5],
		[6418,39,15,0,67,17,15,3,0,36,48,33,4,5],
		[6419,88,24,0,0,17,15,42,0,23,44,34,7,5],
		[6420,88,24,0,0,17,18,48,1,44,7,47,7,1],
		[6421,88,24,0,0,17,12,33,0,62,52,28,7,3],
		[6422,88,24,0,0,17,18,20,1,32,33,12,7,1],
		[6423,88,24,0,0,17,19,30,1,50,3,48,7,3],
		[6424,58,14,0,39,17,18,1,1,24,17,13,6,5],
		[6425,58,14,0,39,17,18,1,1,24,17,3,8,3],
		[6426,88,24,0,0,17,18,57,1,34,59,23,7,5],
		[6427,88,24,0,0,17,19,25,1,44,13,23,8,1],
		[6428,88,24,0,0,17,18,19,1,16,18,43,7,7],
		[6429,88,24,0,0,17,31,27,1,80,51,33,7,7],
		[6430,88,24,0,0,17,17,36,0,23,5,27,7,5],
		[6431,39,24,0,68,17,17,20,0,33,6,0,6,1],
		[6432,88,24,0,0,17,18,5,0,17,19,5,7,2],
		[6433,88,24,0,0,17,18,37,0,10,51,52,6,5],
		[6434,88,24,0,0,17,18,53,0,6,5,7,8,3],
		[6435,88,24,0,0,17,19,53,1,17,45,23,7,2],
		[6436,39,24,0,69,17,17,40,0,37,17,30,6,2],
		[6437,88,24,0,0,17,16,49,0,49,41,28,8,5],
		[6438,88,24,0,0,17,22,55,1,58,0,37,7,4],
		[6439,88,24,0,0,17,19,60,1,5,55,2,7,4],
		[6440,88,24,0,0,17,24,1,1,62,51,51,7,1],
		[6441,88,24,0,0,17,20,34,1,19,19,58,8,4],
		[6442,88,24,0,0,17,23,7,1,56,31,31,7,4],
		[6443,88,24,0,0,17,18,49,0,28,49,23,7,5],
		[6444,88,24,0,0,17,18,23,0,38,48,41,7,4],
		[6445,58,13,0,40,17,21,0,1,21,6,46,5,3],
		[6446,73,12,0,53,17,20,50,1,12,50,49,5,2],
		[6447,88,24,0,0,17,24,19,1,60,40,25,7,1],
		[6448,88,24,0,0,17,16,29,0,60,40,14,7,5],
		[6449,88,24,0,0,17,20,53,1,10,41,46,7,3],
		[6450,88,24,0,0,17,22,39,1,37,48,18,7,1],
		[6451,5,8,0,0,17,23,16,1,47,28,6,6,1],
		[6452,88,24,0,0,17,20,19,0,18,3,26,6,7],
		[6453,58,7,0,42,17,22,1,1,24,59,58,4,1],
		[6454,88,24,0,0,17,22,38,1,35,54,36,7,3],
		[6455,88,24,0,0,17,20,10,0,25,32,15,6,2],
		[6456,88,24,0,0,17,22,55,1,37,13,14,7,5],
		[6457,39,24,0,70,17,20,54,0,24,29,58,6,2],
		[6458,39,24,0,72,17,20,40,0,32,28,4,6,4],
		[6459,58,24,0,43,17,23,22,1,28,8,35,6,5],
		[6460,88,24,0,0,17,24,13,1,44,9,45,6,1],
		[6461,5,1,0,0,17,25,18,1,55,31,48,4,5],
		[6462,5,2,0,0,17,25,24,1,56,22,39,4,1],
		[6463,88,24,0,0,17,21,33,0,16,43,51,7,7],
		[6464,39,24,0,74,17,20,21,0,46,14,27,7,7],
		[6465,88,24,0,0,17,22,51,1,2,23,18,7,4],
		[6466,88,24,0,0,17,21,31,0,28,45,29,7,4],
		[6467,88,24,0,0,17,20,34,0,48,11,18,7,3],
		[6468,5,9,0,0,17,26,0,1,50,38,1,6,4],
		[6469,88,24,0,0,17,21,44,0,39,58,28,7,3],
		[6470,88,24,0,0,17,25,3,1,34,41,47,7,2],
		[6471,88,24,0,0,17,28,8,1,63,2,11,7,1],
		[6472,88,24,0,0,17,24,42,1,21,26,30,7,4],
		[6473,88,24,0,0,17,24,37,1,18,26,45,7,1],
		[6474,88,24,0,0,17,25,6,1,24,14,37,7,5],
		[6475,88,24,0,0,17,26,56,1,51,56,57,7,1],
		[6476,88,24,0,0,17,23,58,0,8,51,10,7,5],
		[6477,88,24,0,0,17,26,52,1,45,50,37,6,1],
		[6478,88,24,0,0,17,27,12,1,50,37,49,7,1],
		[6479,88,24,0,0,17,21,45,0,53,25,14,7,5],
		[6480,39,24,0,73,17,24,7,0,22,57,37,7,3],
		[6481,88,24,0,0,17,24,32,0,16,18,4,7,2],
		[6482,88,24,0,0,17,24,34,0,15,36,22,7,1],
		[6483,88,24,0,0,17,27,58,1,52,17,50,7,5],
		[6484,39,16,0,75,17,23,41,0,37,8,48,6,2],
		[6485,39,16,0,75,17,23,41,0,37,8,45,6,1],
		[6486,58,24,0,44,17,26,22,1,24,10,31,5,2],
		[6487,88,24,0,0,17,28,39,1,55,10,11,7,4],
		[6488,88,24,0,0,17,24,2,0,38,34,58,7,3],
		[6489,88,24,0,0,17,25,58,1,1,39,6,7,3],
		[6490,88,24,0,0,17,26,55,1,25,56,36,7,2],
		[6491,88,24,0,0,17,24,27,0,36,57,7,7,4],
		[6492,58,24,0,45,17,27,21,1,29,52,1,5,3],
		[6493,88,24,0,0,17,26,38,1,5,5,12,6,3],
		[6494,88,24,0,0,17,27,38,1,29,43,28,7,1],
		[6495,88,24,0,0,17,25,54,0,16,55,3,7,7],
		[6496,88,24,0,0,17,27,2,1,12,30,45,7,3],
		[6497,88,24,0,0,17,26,19,0,7,35,44,7,1],
		[6498,58,17,0,49,17,26,31,0,4,8,25,5,5],
		[6499,88,24,0,0,17,26,1,0,26,52,44,7,2],
		[6500,5,3,0,0,17,31,6,1,60,41,2,5,1],
		[6501,88,24,0,0,17,28,56,1,36,46,42,7,5],
		[6502,88,24,0,0,17,26,49,0,20,4,51,7,1],
		[6503,88,24,0,0,17,29,26,1,38,31,0,7,2],
		[6504,88,24,0,0,17,28,2,1,8,12,30,7,3],
		[6505,88,24,0,0,17,31,23,1,56,55,14,7,1],
		[6506,88,24,0,0,17,26,46,0,34,41,45,7,2],
		[6507,88,24,0,0,17,28,50,0,0,19,50,6,2],
		[6508,71,19,0,34,17,30,46,1,37,17,45,4,1],
		[6509,39,24,0,77,17,26,44,0,48,15,36,7,2],
		[6510,5,0,0,0,17,31,51,1,49,52,34,4,1],
		[6511,88,24,0,0,17,25,41,0,60,2,54,7,2],
		[6512,88,24,0,0,17,29,47,1,5,55,11,7,5],
		[6513,88,24,0,0,17,31,49,1,46,2,11,7,3],
		[6514,88,24,0,0,17,26,5,0,58,39,7,8,2],
		[6516,88,24,0,0,17,30,24,1,1,3,45,6,4],
		[6517,88,24,0,0,17,31,47,1,33,42,10,7,5],
		[6518,88,24,0,0,17,25,0,0,67,18,23,7,5],
		[6519,58,24,0,51,17,31,25,1,23,57,46,6,1],
		[6520,88,24,0,0,17,31,44,1,26,16,11,7,1],
		[6521,88,24,0,0,17,30,22,0,11,55,30,7,2],
		[6522,88,24,0,0,17,32,25,1,34,16,47,7,3],
		[6523,88,24,0,0,17,33,7,1,41,10,25,7,1],
		[6524,88,24,0,0,17,31,21,0,2,43,28,7,4],
		[6525,88,24,0,0,17,35,35,1,59,50,46,7,1],
		[6526,39,10,0,76,17,30,44,0,26,6,38,5,5],
		[6527,71,10,0,35,17,33,37,1,37,6,14,3,1],
		[6528,88,24,0,0,17,30,55,0,31,9,30,7,4],
		[6529,88,24,0,0,17,19,37,0,80,8,11,7,5],
		[6530,88,24,0,0,17,35,20,1,53,21,10,7,1],
		[6531,88,24,0,0,17,30,40,0,38,52,56,7,3],
		[6532,88,24,0,0,17,32,15,0,11,55,49,7,1],
		[6533,39,24,0,78,17,31,50,0,28,24,27,7,2],
		[6534,88,24,0,0,17,33,30,1,5,44,41,7,2],
		[6535,88,24,0,0,17,34,43,1,32,34,54,7,0],
		[6536,33,1,0,23,17,30,26,0,52,18,5,4,4],
		[6537,5,17,0,1,17,35,40,1,46,30,20,6,2],
		[6538,88,24,0,0,17,32,1,0,34,16,15,8,4],
		[6539,88,24,0,0,17,35,43,1,37,26,24,7,2],
		[6540,88,24,0,0,17,30,44,0,57,52,35,7,5],
		[6541,88,24,0,0,17,33,23,0,19,15,24,7,3],
		[6542,88,24,0,0,17,33,39,0,16,19,3,7,5],
		[6543,88,24,0,0,17,33,43,0,14,50,30,7,7],
		[6544,88,24,0,0,17,34,46,1,11,14,31,7,1],
		[6545,58,24,0,52,17,35,19,1,22,2,38,8,1],
		[6546,88,24,0,0,17,36,33,1,38,38,7,5,5],
		[6547,88,24,0,0,17,37,27,1,50,3,36,7,5],
		[6548,58,24,0,53,17,34,37,0,9,35,12,7,2],
		[6549,5,15,0,0,17,38,6,1,54,30,1,6,2],
		[6550,88,24,0,0,17,33,7,0,41,14,37,7,5],
		[6551,88,24,0,0,17,34,27,0,16,30,14,7,2],
		[6552,88,24,0,0,18,1,34,1,85,12,53,7,3],
		[6553,71,7,0,0,17,37,19,1,42,59,52,3,3],
		[6554,33,12,1,24,17,32,11,0,55,11,3,6,2],
		[6555,33,12,2,25,17,32,16,0,55,10,23,6,2],
		[6556,58,0,0,55,17,34,56,0,12,33,36,3,2],
		[6557,88,24,0,0,17,37,27,1,38,3,56,7,4],
		[6558,88,24,0,0,17,38,9,1,42,52,50,7,1],
		[6559,88,24,0,0,17,35,60,0,20,59,46,7,2],
		[6560,88,24,0,0,17,33,32,0,57,33,32,7,4],
		[6561,73,13,0,55,17,37,35,1,15,23,55,5,3],
		[6562,88,24,0,0,17,37,36,1,15,34,16,7,3],
		[6563,88,24,0,0,17,35,42,0,37,18,6,7,4],
		[6564,88,24,0,0,17,36,8,0,28,11,5,7,5],
		[6565,88,24,0,0,17,44,20,1,72,13,15,7,3],
		[6566,33,24,0,27,17,31,58,0,68,8,6,6,5],
		[6567,58,11,0,57,17,37,51,1,8,7,8,6,1],
		[6568,88,24,0,0,17,38,10,1,10,55,35,7,5],
		[6569,5,10,0,0,17,40,24,1,49,24,56,6,3],
		[6570,88,24,0,0,17,36,37,0,30,47,7,7,2],
		[6571,39,24,0,79,17,37,31,0,24,18,36,7,2],
		[6572,88,24,0,0,17,41,16,1,46,55,19,7,2],
		[6573,33,24,0,26,17,34,60,0,61,52,30,6,4],
		[6574,39,24,0,82,17,36,38,0,48,35,8,6,5],
		[6575,88,24,0,0,17,39,9,0,2,1,41,7,5],
		[6576,88,24,0,0,17,42,4,1,50,30,38,7,7],
		[6577,88,24,0,0,17,38,58,0,13,19,45,7,3],
		[6578,88,24,0,0,17,40,12,1,2,9,9,7,5],
		[6579,88,24,0,0,17,38,50,0,32,44,22,7,4],
		[6580,71,9,0,0,17,42,29,1,39,1,48,3,1],
		[6581,73,14,0,56,17,41,25,1,12,52,31,5,2],
		[6582,60,6,0,0,17,45,44,1,64,43,26,5,5],
		[6583,88,24,0,0,17,42,51,1,36,56,45,7,5],
		[6584,88,24,0,0,17,39,58,0,31,12,9,7,7],
		[6585,5,11,0,0,17,44,9,1,51,50,3,6,4],
		[6586,88,24,0,0,17,44,56,1,57,32,43,7,4],
		[6587,88,24,0,0,17,43,7,1,33,3,4,7,7],
		[6588,39,8,0,85,17,39,28,0,46,0,23,5,1],
		[6589,88,24,0,0,17,41,11,0,15,10,41,7,2],
		[6590,88,24,0,0,17,41,32,0,6,18,46,7,4],
		[6591,88,24,0,0,17,40,41,0,31,17,15,7,5],
		[6592,88,24,0,0,17,41,6,0,24,30,48,7,5],
		[6593,88,24,0,0,17,43,18,1,27,53,3,7,2],
		[6594,88,24,0,0,17,41,59,0,15,57,7,7,3],
		[6595,58,24,0,58,17,43,26,1,21,41,0,6,3],
		[6596,33,23,0,28,17,36,57,0,68,45,29,6,3],
		[6597,88,24,0,0,17,44,42,1,42,43,44,7,2],
		[6598,88,24,0,0,17,36,40,0,69,34,15,7,3],
		[6599,88,24,0,0,17,40,38,0,43,28,15,8,5],
		[6600,88,24,0,0,17,43,49,1,13,30,31,7,3],
		[6601,88,24,0,0,17,43,47,1,7,4,46,7,1],
		[6602,39,24,0,83,17,42,28,0,24,33,51,7,5],
		[6603,58,1,0,60,17,43,28,0,4,34,2,4,5],
		[6604,88,24,0,0,17,43,22,0,14,17,42,7,3],
		[6605,88,24,0,0,17,40,36,0,57,18,37,8,5],
		[6606,88,24,0,0,17,37,9,0,72,27,21,7,4],
		[6607,88,24,0,0,17,41,22,0,51,49,5,7,5],
		[6608,39,24,0,84,17,43,22,0,24,19,40,7,4],
		[6609,58,24,0,61,17,44,34,0,2,34,46,7,2],
		[6610,88,24,0,0,17,44,35,0,2,34,44,8,2],
		[6611,88,24,0,0,17,44,17,0,14,24,37,7,2],
		[6612,88,24,0,0,17,43,6,0,44,5,4,7,5],
		[6613,88,24,0,0,17,47,7,1,38,6,42,7,1],
		[6614,88,24,0,0,17,48,38,1,55,24,6,7,2],
		[6615,71,8,1,0,17,47,35,1,40,7,37,4,3],
		[6616,76,24,0,3,17,47,34,1,27,49,51,6,3],
		[6617,88,24,0,0,17,47,46,1,22,28,41,7,4],
		[6618,88,24,0,0,17,43,59,0,53,48,6,7,2],
		[6619,88,24,0,0,17,45,40,0,31,30,17,7,2],
		[6620,88,24,0,0,17,47,37,1,14,43,33,7,1],
		[6621,88,24,0,0,17,48,28,1,26,58,30,7,1],
		[6622,88,24,0,0,17,50,28,1,53,36,44,7,1],
		[6623,39,11,0,86,17,46,28,0,27,43,14,4,4],
		[6624,88,24,0,0,17,51,36,1,60,9,52,7,5],
		[6625,88,24,0,0,17,45,54,0,38,52,53,8,5],
		[6626,88,24,0,0,17,45,59,0,39,19,21,8,5],
		[6627,88,24,0,0,17,47,8,0,17,41,50,7,2],
		[6628,88,24,0,0,17,49,11,1,31,42,12,6,1],
		[6629,58,2,0,62,17,47,54,0,2,42,26,5,2],
		[6630,88,24,0,0,17,49,52,1,37,2,36,4,5],
		[6631,71,8,2,0,17,50,11,1,40,5,26,6,2],
		[6632,88,24,0,0,17,51,11,1,53,7,50,7,1],
		[6633,88,24,0,0,17,48,20,0,3,48,15,7,1],
		[6634,88,24,0,0,17,53,18,1,65,29,21,7,5],
		[6635,88,24,0,0,17,57,42,1,76,10,39,7,5],
		[6636,33,22,1,31,17,41,56,0,72,8,56,6,3],
		[6637,33,22,1,31,17,41,58,0,72,9,25,7,4],
		[6638,88,24,0,0,17,48,25,0,20,33,56,7,4],
		[6639,88,24,0,0,17,49,19,0,1,57,40,7,5],
		[6640,88,24,0,0,17,51,45,1,45,36,2,7,4],
		[6641,88,24,0,0,17,47,8,0,47,36,44,7,2],
		[6642,88,24,0,0,17,48,48,0,19,15,19,7,2],
		[6643,88,24,0,0,17,51,33,1,40,46,21,7,7],
		[6644,39,24,0,87,17,48,49,0,25,37,22,6,5],
		[6645,88,24,0,0,17,51,13,1,30,33,26,8,2],
		[6646,88,24,0,0,18,5,27,1,81,29,11,7,5],
		[6647,88,24,0,0,17,52,14,1,34,47,57,7,1],
		[6648,88,24,0,0,17,52,20,1,34,25,0,7,4],
		[6649,88,24,0,0,17,52,53,1,41,59,48,7,3],
		[6650,88,24,0,0,17,50,44,0,11,56,48,7,5],
		[6651,88,24,0,0,17,52,49,1,34,6,51,7,5],
		[6652,88,24,0,0,17,52,56,1,35,1,7,7,1],
		[6653,88,24,0,0,17,52,58,1,35,37,27,7,3],
		[6654,88,24,0,0,17,50,23,0,29,19,20,7,5],
		[6655,88,24,0,0,17,50,48,0,22,18,59,7,2],
		[6656,33,24,0,30,17,49,4,0,50,46,52,6,2],
		[6657,88,24,0,0,17,53,20,1,34,43,50,7,1],
		[6658,88,24,0,0,17,53,23,1,34,53,43,7,5],
		[6659,88,24,0,0,17,51,60,1,1,14,12,7,5],
		[6660,88,24,0,0,17,53,46,1,34,47,9,7,1],
		[6661,88,24,0,0,17,52,39,1,6,8,37,7,3],
		[6662,88,24,0,0,17,53,55,1,34,45,9,7,1],
		[6663,88,24,0,0,17,53,58,1,34,49,54,7,2],
		[6664,39,24,0,88,17,50,3,0,48,23,39,8,1],
		[6665,88,24,0,0,17,51,59,0,15,19,33,7,5],
		[6666,88,24,0,0,17,53,4,1,10,53,59,7,5],
		[6667,88,24,0,0,17,52,35,0,1,18,18,7,5],
		[6668,88,24,0,0,17,54,27,1,34,27,59,7,1],
		[6669,88,24,0,0,17,51,14,0,40,4,21,7,4],
		[6670,88,24,0,0,17,53,14,0,6,6,5,7,3],
		[6671,88,24,0,0,17,55,8,1,36,28,33,7,1],
		[6672,88,24,0,0,17,54,54,1,24,53,14,7,0],
		[6673,88,24,0,0,17,52,5,0,39,58,56,7,5],
		[6674,88,24,0,0,17,52,1,0,46,38,36,7,5],
		[6675,88,24,0,0,17,56,47,1,44,20,32,6,5],
		[6676,88,24,0,0,17,54,14,0,11,7,50,7,3],
		[6677,39,24,0,90,17,53,18,0,40,0,29,6,5],
		[6678,88,24,0,0,17,56,56,1,40,18,20,7,5],
		[6679,88,24,0,0,17,55,55,1,18,48,8,8,2],
		[6680,88,24,0,0,17,56,42,1,28,3,55,7,2],
		[6681,88,24,0,0,17,56,19,1,15,48,45,7,2],
		[6682,88,24,0,0,17,57,48,1,41,42,58,6,7],
		[6683,88,24,0,0,17,57,58,1,39,8,13,7,2],
		[6684,88,24,0,0,17,56,18,0,0,40,13,7,1],
		[6685,39,24,0,89,17,55,25,0,26,3,0,6,3],
		[6686,88,24,0,0,17,56,48,1,4,4,55,6,4],
		[6687,88,24,0,0,17,55,51,0,22,27,51,7,5],
		[6688,33,13,0,32,17,53,32,0,56,52,22,5,5],
		[6689,88,24,0,0,17,57,4,0,0,3,59,7,2],
		[6690,88,24,0,0,17,56,56,0,6,29,16,7,1],
		[6691,88,24,0,0,17,58,56,1,36,51,30,7,4],
		[6692,88,24,0,0,17,58,39,1,28,45,33,7,1],
		[6693,88,24,0,0,17,59,5,1,30,15,11,6,7],
		[6694,88,24,0,0,17,59,6,1,30,15,12,8,4],
		[6695,39,7,0,91,17,56,15,0,37,15,2,5,5],
		[6696,88,24,0,0,17,57,27,0,11,2,39,7,2],
		[6697,88,24,0,0,17,57,14,0,23,59,45,7,4],
		[6698,58,12,0,64,17,59,2,1,9,46,25,4,5],
		[6699,88,24,0,0,17,55,24,0,55,58,17,7,3],
		[6700,76,24,0,4,17,59,48,1,23,48,58,6,1],
		[6701,33,24,0,35,17,49,27,0,76,57,46,6,3],
		[6702,88,24,0,0,17,56,48,0,45,21,3,7,7],
		[6703,39,13,0,92,17,57,46,0,29,14,52,5,4],
		[6704,88,24,0,0,18,0,0,1,20,20,21,7,5],
		[6705,33,2,0,33,17,56,36,0,51,29,20,3,5],
		[6706,88,24,0,0,17,59,37,1,4,49,17,7,5],
		[6707,39,12,0,94,17,58,30,0,30,11,22,5,3],
		[6708,88,24,0,0,18,1,48,1,36,22,40,7,1],
		[6709,88,24,0,0,18,0,16,0,0,37,46,7,2],
		[6710,73,5,0,57,18,0,29,1,3,41,25,6,3],
		[6711,88,24,0,0,17,58,42,0,36,17,16,7,4],
		[6712,58,24,0,66,18,0,16,0,4,22,7,6,1],
		[6713,39,24,0,93,18,0,3,0,16,45,3,6,5],
		[6714,58,24,0,67,18,0,39,0,2,55,54,5,1],
		[6715,76,24,0,6,18,1,23,1,17,9,25,7,5],
		[6716,88,24,0,0,18,1,54,1,22,46,50,7,1],
		[6717,88,24,0,0,17,50,11,0,78,18,24,7,5],
		[6718,88,24,0,0,17,58,52,0,45,28,34,7,1],
		[6719,88,24,0,0,18,0,53,0,6,16,6,7,1],
		[6720,88,24,0,0,18,0,28,0,19,30,21,8,1],
		[6721,57,21,0,0,18,54,47,1,87,36,21,6,5],
		[6722,88,24,0,0,18,0,57,0,15,5,36,7,4],
		[6723,58,24,0,68,18,1,45,0,1,18,19,5,2],
		[6724,76,24,0,7,18,2,51,1,24,16,56,6,3],
		[6725,33,22,2,34,17,55,11,0,72,0,18,6,3],
		[6726,88,24,0,0,18,0,36,0,33,12,50,7,5],
		[6727,88,24,0,0,18,3,2,1,22,43,6,8,1],
		[6728,88,24,0,0,17,59,56,0,45,30,5,7,7],
		[6729,39,24,0,95,18,1,30,0,21,35,43,6,4],
		[6730,39,24,0,95,18,1,30,0,21,35,44,6,2],
		[6731,88,24,0,0,18,11,16,1,75,53,29,7,5],
		[6732,88,24,0,0,18,2,46,1,5,21,31,8,1],
		[6733,58,18,0,69,18,3,5,1,8,10,49,7,3],
		[6734,58,18,0,69,18,3,5,1,8,10,50,6,3],
		[6735,88,24,0,0,17,54,27,0,75,10,15,7,5],
		[6736,76,24,0,9,18,3,52,1,24,21,38,7,0],
		[6737,88,24,0,0,18,1,36,0,33,18,41,7,5],
		[6738,39,24,0,96,18,2,23,0,20,50,1,6,1],
		[6739,88,24,0,0,18,4,50,1,35,54,5,7,5],
		[6740,88,24,0,0,18,7,48,1,64,33,0,7,5],
		[6741,39,24,0,97,18,2,30,0,22,55,23,7,1],
		[6742,76,2,1,0,18,5,1,1,29,34,48,6,3],
		[6743,5,7,0,0,18,6,38,1,50,5,30,5,1],
		[6744,88,24,0,0,18,3,15,0,19,36,47,8,2],
		[6745,60,15,0,0,18,8,35,1,63,40,6,5,2],
		[6746,76,2,2,10,18,5,49,1,30,25,27,4,5],
		[6747,88,24,0,0,18,4,37,0,1,55,9,7,1],
		[6748,88,24,0,0,18,6,24,1,36,1,11,7,4],
		[6749,88,24,0,0,18,6,50,1,43,25,29,7,2],
		[6750,88,24,0,0,18,6,50,1,43,25,29,7,2],
		[6751,88,24,0,0,18,12,35,1,73,40,18,7,3],
		[6752,58,24,0,70,18,5,27,0,2,29,58,5,5],
		[6753,88,24,0,0,18,3,9,0,48,27,52,7,2],
		[6754,88,24,0,0,18,4,40,0,23,56,33,7,3],
		[6755,88,24,0,0,18,6,7,1,8,19,26,7,1],
		[6756,88,24,0,0,18,6,15,1,4,45,5,7,5],
		[6757,88,24,0,0,18,6,7,1,0,26,48,7,4],
		[6758,88,24,0,0,18,5,43,0,12,0,14,8,2],
		[6759,88,24,0,0,18,8,30,1,45,46,2,7,1],
		[6760,88,24,0,0,18,9,58,1,59,2,24,7,5],
		[6761,60,8,0,0,18,10,26,1,62,0,8,6,4],
		[6762,88,24,0,0,18,7,11,1,21,26,38,7,1],
		[6763,88,24,0,0,18,5,30,0,21,38,49,7,5],
		[6764,88,24,0,0,18,4,43,0,40,5,3,8,3],
		[6765,39,24,0,98,18,6,2,0,22,13,8,6,7],
		[6766,88,24,0,0,18,8,5,1,28,27,26,6,4],
		[6767,88,24,0,0,18,5,1,0,41,56,48,7,3],
		[6768,88,24,0,0,18,5,50,0,32,13,50,7,5],
		[6769,88,24,0,0,18,7,48,1,17,9,15,7,5],
		[6770,58,24,0,71,18,7,18,0,8,44,2,6,4],
		[6771,58,24,0,72,18,7,21,0,9,33,50,5,2],
		[6772,88,24,0,0,18,9,22,1,36,40,21,8,1],
		[6773,88,24,0,0,18,8,54,1,25,28,21,8,1],
		[6774,88,24,0,0,18,14,24,1,70,45,5,8,1],
		[6775,39,24,0,99,18,7,2,0,30,33,43,6,3],
		[6776,88,24,0,0,18,7,48,0,13,4,16,8,2],
		[6777,88,24,0,0,18,9,60,1,32,43,11,7,5],
		[6778,88,24,0,0,18,11,5,1,47,30,47,7,5],
		[6779,39,14,0,103,18,7,33,0,28,45,45,5,1],
		[6780,88,24,0,0,18,10,6,1,30,43,43,7,5],
		[6781,39,24,0,100,18,7,50,0,26,6,5,7,2],
		[6782,39,24,0,100,18,7,50,0,26,5,51,7,2],
		[6783,78,4,0,0,18,11,14,1,45,57,16,6,5],
		[6784,88,24,0,0,18,8,34,0,14,17,5,7,2],
		[6785,88,24,0,0,18,9,43,1,13,56,4,7,5],
		[6786,88,24,0,0,18,11,6,1,41,21,33,7,3],
		[6787,39,24,0,102,18,8,46,0,20,48,52,5,1],
		[6788,88,24,0,0,18,10,55,1,33,47,59,7,1],
		[6789,83,3,0,23,17,32,13,0,86,35,11,5,2],
		[6790,88,24,0,0,18,6,54,0,50,49,22,7,5],
		[6791,88,24,0,0,18,7,29,0,43,27,42,6,4],
		[6792,88,24,0,0,18,7,6,0,49,42,38,7,2],
		[6793,88,24,0,0,18,8,2,0,36,24,5,6,5],
		[6794,39,24,0,101,18,8,53,0,20,2,43,6,2],
		[6795,58,24,0,73,18,9,34,0,3,59,36,7,3],
		[6796,88,24,0,0,18,14,16,1,63,41,22,7,5],
		[6797,88,24,0,0,18,9,54,0,3,7,11,7,3],
		[6798,88,24,0,0,18,11,15,1,19,50,32,7,2],
		[6799,88,24,0,0,18,9,10,0,30,28,10,7,5],
		[6800,88,24,0,0,18,10,40,0,3,19,27,7,5],
		[6801,76,24,0,11,18,11,43,1,23,42,4,6,5],
		[6802,88,24,0,0,18,11,58,1,28,54,5,8,1],
		[6803,88,24,0,0,18,10,9,0,16,28,36,7,1],
		[6804,88,24,0,0,18,13,13,1,41,20,10,6,1],
		[6805,88,24,0,0,18,15,41,1,63,3,20,7,5],
		[6806,88,24,0,0,18,9,38,0,38,27,27,7,5],
		[6807,88,24,0,0,18,9,59,0,36,27,59,7,4],
		[6808,88,24,0,0,18,18,1,1,68,13,45,7,1],
		[6809,33,24,0,40,18,0,3,0,80,0,3,7,3],
		[6810,33,24,0,41,18,0,9,0,80,0,15,7,3],
		[6811,83,24,0,24,17,30,48,0,86,58,5,7,2],
		[6812,76,11,0,13,18,13,46,1,21,3,32,5,1],
		[6813,88,24,0,0,18,13,10,1,4,0,42,8,2],
		[6814,88,24,0,0,18,11,45,0,33,26,49,7,2],
		[6815,39,24,0,104,18,11,54,0,31,24,19,6,7],
		[6816,76,24,0,14,18,14,16,1,21,42,47,6,5],
		[6817,88,24,0,0,18,10,32,0,54,17,12,7,5],
		[6818,88,24,0,0,18,15,53,1,44,12,24,6,4],
		[6819,88,24,0,0,18,17,8,1,56,1,24,6,1],
		[6820,88,24,0,0,18,13,17,0,21,52,49,7,5],
		[6821,88,24,0,0,18,17,1,1,51,4,6,7,1],
		[6822,76,24,0,15,18,15,13,1,20,43,42,6,1],
		[6823,76,24,0,16,18,15,13,1,20,23,17,7,0],
		[6824,88,24,0,0,18,12,43,0,41,8,49,7,5],
		[6825,88,24,0,0,18,15,31,1,18,39,41,7,2],
		[6826,88,24,0,0,18,13,5,0,38,46,25,7,1],
		[6827,88,24,0,0,18,11,7,0,60,24,34,7,2],
		[6828,88,24,0,0,18,19,40,1,63,53,13,7,3],
		[6829,57,20,0,0,18,23,36,1,75,2,39,6,2],
		[6830,88,24,0,0,18,15,58,1,3,37,3,7,2],
		[6831,88,24,0,0,18,14,44,0,29,12,26,8,3],
		[6832,76,6,0,0,18,17,38,1,36,45,42,4,7],
		[6833,88,24,0,0,18,17,36,1,34,6,26,7,1],
		[6834,88,24,0,0,18,16,6,0,2,22,40,7,7],
		[6835,88,24,0,0,18,17,24,1,28,39,9,7,2],
		[6836,88,24,0,0,18,17,24,1,28,17,21,7,4],
		[6837,88,24,0,0,18,29,20,1,80,13,58,7,5],
		[6838,88,24,0,0,18,17,12,1,17,22,26,7,5],
		[6839,88,24,0,0,18,18,40,1,42,17,18,7,1],
		[6840,88,24,0,0,18,16,53,1,3,0,26,7,4],
		[6841,88,24,0,0,18,17,29,1,18,27,48,8,0],
		[6842,88,24,0,0,18,18,3,1,27,2,33,6,5],
		[6843,88,24,0,0,18,17,24,1,9,45,31,7,2],
		[6844,88,24,0,0,18,17,5,0,1,0,21,8,3],
		[6845,88,24,0,0,18,15,39,0,42,9,34,7,1],
		[6846,88,24,0,0,18,18,42,1,25,36,17,8,5],
		[6847,88,24,0,0,18,15,33,0,45,12,34,7,4],
		[6848,88,24,0,0,18,18,43,1,18,37,10,8,1],
		[6849,88,24,0,0,18,14,41,0,56,35,18,7,3],
		[6850,33,24,0,36,18,13,54,0,64,23,50,6,3],
		[6851,88,24,0,0,18,18,3,0,13,46,37,7,1],
		[6852,88,24,0,0,18,18,8,0,18,7,53,7,1],
		[6853,88,24,0,0,18,17,7,0,40,56,12,7,4],
		[6854,88,24,0,0,18,18,8,0,23,17,48,8,5],
		[6855,60,13,0,0,18,23,14,1,61,29,38,5,5],
		[6856,88,24,0,0,18,20,55,1,37,29,15,7,5],
		[6857,88,24,0,0,18,19,10,0,7,15,35,6,5],
		[6858,88,24,0,0,18,20,9,1,15,49,54,6,5],
		[6859,76,3,0,19,18,20,60,1,29,49,41,4,5],
		[6860,39,24,0,105,18,19,11,0,24,26,46,6,5],
		[6861,88,24,0,0,18,21,31,1,24,54,54,7,7],
		[6862,88,24,0,0,18,22,19,1,38,39,25,6,5],
		[6863,88,24,0,0,18,21,23,1,18,51,36,7,3],
		[6864,88,24,0,0,18,22,0,1,28,25,48,7,2],
		[6865,33,24,0,37,18,15,17,0,68,45,21,7,5],
		[6866,58,24,0,74,18,20,52,0,3,22,38,6,4],
		[6867,88,24,0,0,18,19,52,0,29,39,58,7,5],
		[6868,39,24,0,106,18,20,18,0,21,57,41,6,7],
		[6869,73,6,0,58,18,21,19,1,2,53,56,4,5],
		[6870,88,24,0,0,18,22,53,1,36,40,10,6,2],
		[6871,88,24,0,0,18,25,32,1,63,1,17,7,2],
		[6872,51,9,0,1,18,19,52,0,36,3,52,5,5],
		[6873,88,24,0,0,18,21,29,0,5,26,9,7,1],
		[6874,88,24,0,0,18,23,29,1,36,14,18,7,5],
		[6875,88,24,0,0,18,24,18,1,44,6,37,6,1],
		[6876,39,24,0,108,18,20,57,0,29,51,32,7,2],
		[6877,39,24,0,107,18,21,1,0,28,52,12,6,2],
		[6878,88,24,0,0,18,23,2,1,10,13,7,7,1],
		[6879,76,4,0,20,18,24,10,1,34,23,5,3,1],
		[6880,88,24,0,0,18,19,56,0,51,20,52,7,5],
		[6881,88,24,0,0,18,23,12,1,12,0,53,7,1],
		[6882,88,24,0,0,18,22,9,0,23,17,7,6,7],
		[6883,88,24,0,0,18,22,35,0,12,1,44,7,2],
		[6884,72,5,0,0,18,23,40,1,8,56,3,6,4],
		[6885,88,24,0,0,18,22,49,0,17,49,36,6,5],
		[6886,88,24,0,0,18,21,7,0,49,43,32,7,5],
		[6887,88,24,0,0,18,23,3,0,16,41,17,7,5],
		[6888,76,24,0,18,18,25,2,1,30,45,24,7,5],
		[6889,88,24,0,0,18,25,22,1,35,59,30,7,5],
		[6890,88,24,0,0,18,24,4,1,3,35,0,7,3],
		[6891,88,24,0,0,18,21,33,0,49,7,18,6,7],
		[6892,88,24,0,0,18,24,42,1,7,4,31,7,5],
		[6893,88,24,0,0,18,25,55,1,33,56,43,7,1],
		[6894,88,24,0,0,18,26,54,1,48,7,1,6,5],
		[6895,39,24,0,109,18,23,42,0,21,46,11,5,5],
		[6896,76,24,0,21,18,25,21,1,20,32,30,6,5],
		[6897,78,0,0,0,18,26,58,1,45,58,6,5,1],
		[6898,88,24,0,0,18,24,57,1,1,34,46,7,3],
		[6899,88,24,0,0,18,32,55,1,73,57,56,7,5],
		[6900,88,24,0,0,18,25,9,0,5,5,5,8,1],
		[6901,88,24,0,0,18,23,57,0,38,44,21,7,5],
		[6902,88,24,0,0,18,25,39,0,8,1,55,7,4],
		[6903,51,11,0,2,18,24,14,0,39,30,26,6,2],
		[6904,88,24,0,0,18,24,59,0,27,23,43,7,2],
		[6905,78,5,0,0,18,28,50,1,49,4,15,5,4],
		[6906,88,24,0,0,18,25,55,0,14,58,0,7,1],
		[6907,88,24,0,0,18,27,50,1,29,48,59,7,3],
		[6908,88,24,0,0,18,29,57,1,57,31,23,7,5],
		[6909,88,24,0,0,18,27,44,1,26,38,5,7,2],
		[6910,88,24,0,0,18,28,27,1,38,59,44,7,2],
		[6911,88,24,0,0,18,23,48,0,53,18,3,7,2],
		[6912,88,24,0,0,18,42,14,1,81,48,28,7,1],
		[6913,76,10,0,22,18,27,58,1,25,25,18,4,5],
		[6914,88,24,0,0,18,28,6,1,26,45,26,7,2],
		[6915,88,24,0,0,18,29,13,1,43,50,45,7,4],
		[6916,60,12,0,0,18,31,22,1,62,16,42,6,1],
		[6917,88,24,0,0,18,25,59,0,29,49,44,7,2],
		[6918,73,24,0,59,18,27,13,0,0,11,46,6,4],
		[6919,88,24,0,0,18,27,57,1,17,48,0,7,1],
		[6920,33,20,0,43,18,20,46,0,71,20,16,5,2],
		[6921,88,24,0,0,18,29,17,1,38,51,4,8,1],
		[6922,88,24,0,0,18,29,56,1,47,13,13,7,5],
		[6923,33,24,0,39,18,23,55,0,58,48,2,6,2],
		[6924,88,24,0,0,18,26,41,0,26,26,58,8,1],
		[6925,88,24,0,0,18,27,50,0,3,44,55,7,5],
		[6926,88,24,0,0,18,28,57,1,26,34,54,8,2],
		[6927,33,21,0,44,18,21,3,0,72,43,58,5,3],
		[6928,88,24,0,0,18,27,59,0,6,11,39,7,1],
		[6929,88,24,0,0,18,29,22,1,25,15,23,8,1],
		[6930,72,2,0,0,18,29,12,1,14,33,57,6,2],
		[6931,88,24,0,0,18,31,3,1,41,54,49,7,2],
		[6932,88,24,0,0,18,29,47,1,14,34,54,7,1],
		[6933,88,24,0,0,18,30,12,1,18,43,44,7,5],
		[6934,78,3,1,0,18,31,45,1,45,54,54,6,1],
		[6935,73,24,0,60,18,29,41,1,1,59,7,6,5],
		[6936,88,24,0,0,18,31,5,1,32,59,21,6,2],
		[6937,88,24,0,0,18,31,56,1,43,30,28,7,5],
		[6938,78,3,2,0,18,32,2,1,45,45,26,6,1],
		[6939,88,24,0,0,18,33,30,1,58,42,33,7,4],
		[6940,88,24,0,0,18,30,14,1,5,43,27,7,4],
		[6941,88,24,0,0,18,30,5,0,4,3,55,8,1],
		[6942,88,24,0,0,18,32,21,1,39,42,14,6,2],
		[6943,88,24,0,0,18,29,36,0,23,51,58,7,1],
		[6944,88,24,0,0,18,31,26,1,18,24,10,6,2],
		[6945,33,24,0,42,18,25,59,0,65,33,49,6,5],
		[6946,88,24,0,0,18,31,26,1,10,47,45,7,1],
		[6947,88,24,0,0,18,31,53,1,19,7,30,8,4],
		[6948,88,24,0,0,18,33,1,1,39,53,32,7,3],
		[6949,88,24,0,0,18,27,42,0,59,32,57,7,5],
		[6950,88,24,0,0,18,30,42,0,20,48,55,8,4],
		[6951,24,7,0,0,18,33,30,1,42,18,45,6,4],
		[6952,24,9,1,0,18,33,23,1,38,43,13,7,2],
		[6953,24,9,2,0,18,33,23,1,38,43,34,7,1],
		[6954,88,24,0,0,18,34,31,1,52,53,31,7,5],
		[6955,88,24,0,0,18,31,4,0,16,55,43,7,2],
		[6956,88,24,0,0,18,32,21,1,14,38,39,7,2],
		[6957,73,24,0,61,18,31,57,1,1,0,11,7,2],
		[6958,88,24,0,0,18,32,7,0,3,39,35,7,2],
		[6959,88,24,0,0,18,32,43,1,14,51,56,7,5],
		[6960,88,24,0,0,18,33,58,1,33,1,0,6,1],
		[6961,76,24,0,24,18,33,54,1,24,1,57,6,5],
		[6962,88,24,0,0,18,33,39,1,14,51,13,7,2],
		[6963,88,24,0,0,18,33,23,1,5,54,41,7,2],
		[6964,88,24,0,0,18,51,58,1,83,18,59,8,5],
		[6965,76,24,0,25,18,34,33,1,24,13,21,8,3],
		[6966,88,24,0,0,18,32,46,0,23,37,1,7,5],
		[6967,88,24,0,0,18,33,23,0,8,16,6,7,1],
		[6968,88,24,0,0,18,32,50,0,30,33,15,6,1],
		[6969,88,24,0,0,18,35,21,1,20,50,27,7,3],
		[6970,88,24,0,0,18,35,2,1,10,58,38,6,4],
		[6971,88,24,0,0,18,33,23,0,30,53,33,8,1],
		[6972,88,24,0,0,18,35,60,1,29,41,57,7,5],
		[6973,72,0,0,0,18,35,12,1,8,14,39,5,5],
		[6974,88,24,0,0,18,32,11,0,52,6,56,8,1],
		[6975,88,24,0,0,18,34,20,0,20,27,59,8,2],
		[6976,88,24,0,0,18,34,48,0,10,53,30,7,2],
		[6977,88,24,0,0,18,35,13,0,18,12,12,7,2],
		[6978,33,24,0,45,18,32,35,0,57,2,44,6,3],
		[6979,88,24,0,0,18,31,15,0,65,26,10,8,2],
		[6980,88,24,0,0,18,35,30,0,23,36,20,7,4],
		[6981,88,24,0,0,18,35,53,0,16,58,32,7,4],
		[6982,60,5,0,0,18,43,2,1,71,25,41,5,5],
		[6983,88,24,0,0,18,33,57,0,52,21,13,6,5],
		[6984,88,24,0,0,18,35,14,0,34,27,28,7,1],
		[6985,88,24,0,0,18,36,28,0,9,7,21,6,3],
		[6986,88,24,0,0,18,39,14,1,47,54,35,7,2],
		[6987,88,24,0,0,18,36,39,0,6,40,19,6,3],
		[6988,88,24,0,0,18,37,54,1,21,23,52,7,2],
		[6989,88,24,0,0,18,38,5,1,14,0,17,7,1],
		[6990,88,24,0,0,18,38,31,1,23,30,18,7,1],
		[6991,88,24,0,0,18,39,35,1,43,11,10,6,7],
		[6992,88,24,0,0,18,37,13,0,11,25,18,7,1],
		[6993,88,24,0,0,18,37,36,1,0,18,34,7,2],
		[6994,88,24,0,0,18,47,49,1,77,52,2,7,3],
		[6995,88,24,0,0,18,37,9,0,16,11,54,7,4],
		[6996,88,24,0,0,18,42,23,1,64,38,35,7,2],
		[6997,88,24,0,0,18,36,37,0,33,28,8,6,1],
		[6998,88,24,0,0,18,38,53,1,21,3,7,7,4],
		[6999,88,24,0,0,18,38,24,1,3,11,37,7,3],
		[7000,88,24,0,0,18,38,19,1,1,6,48,8,3],
		[7001,51,0,0,3,18,36,56,0,38,47,1,1,2],
		[7002,88,24,0,0,18,38,21,0,8,50,2,7,7],
		[7003,88,24,0,0,18,36,46,0,43,13,19,7,3],
		[7004,88,24,0,0,18,43,37,1,64,33,4,7,5],
		[7005,88,24,0,0,18,41,31,1,48,5,42,7,5],
		[7006,88,24,0,0,18,29,45,0,77,32,49,7,5],
		[7007,88,24,0,0,18,40,1,1,7,47,26,7,5],
		[7008,88,24,0,0,18,39,37,0,5,15,51,7,3],
		[7009,88,24,0,0,18,38,7,0,39,40,5,7,7],
		[7010,88,24,0,0,18,39,52,0,7,21,30,7,4],
		[7011,76,24,0,26,18,41,52,1,23,50,0,7,2],
		[7012,88,24,0,0,18,45,27,1,64,52,17,6,2],
		[7013,88,24,0,0,18,36,13,0,65,29,19,7,3],
		[7014,88,24,0,0,18,41,43,1,14,33,51,7,3],
		[7015,88,24,0,0,18,45,12,1,61,5,42,7,5],
		[7016,88,24,0,0,18,40,2,0,30,50,58,7,5],
		[7017,88,24,0,0,18,39,33,0,40,56,6,7,1],
		[7018,88,24,0,0,18,37,34,0,62,31,36,7,2],
		[7019,88,24,0,0,18,40,12,0,38,22,2,7,2],
		[7020,72,3,0,0,18,42,16,1,9,3,9,6,3],
		[7021,24,10,0,0,18,43,47,1,38,19,25,6,2],
		[7022,88,24,0,0,18,45,24,1,56,52,54,7,5],
		[7023,88,24,0,0,18,42,55,1,19,17,2,7,7],
		[7024,88,24,0,0,18,42,36,1,7,4,24,7,5],
		[7025,88,24,0,0,18,24,9,0,83,10,31,7,2],
		[7026,88,24,0,0,18,44,8,1,36,43,7,7,5],
		[7027,88,24,0,0,18,49,44,1,72,59,41,7,1],
		[7028,88,24,0,0,18,39,53,0,52,11,46,7,2],
		[7029,88,24,0,0,18,44,19,1,35,38,31,6,1],
		[7030,88,24,0,0,18,41,41,0,31,37,4,7,1],
		[7031,88,24,0,0,18,44,57,1,39,41,11,6,5],
		[7032,72,4,0,0,18,43,31,1,8,16,31,6,4],
		[7033,88,24,0,0,18,42,8,0,34,44,48,7,1],
		[7034,88,24,0,0,18,43,51,1,6,49,7,7,3],
		[7035,88,24,0,0,18,44,50,1,25,0,40,7,1],
		[7036,60,7,0,0,18,48,38,1,65,4,40,7,2],
		[7037,88,24,0,0,18,46,59,1,50,5,40,8,3],
		[7038,88,24,0,0,18,45,19,1,21,0,5,7,3],
		[7039,76,20,0,27,18,45,39,1,26,59,27,4,1],
		[7040,3,24,0,4,18,44,50,0,2,3,36,6,1],
		[7041,88,24,0,0,18,43,17,0,39,18,1,7,5],
		[7042,88,24,0,0,18,40,56,0,62,44,59,7,5],
		[7043,88,24,0,0,18,43,36,0,36,33,24,7,4],
		[7044,88,24,0,0,18,43,52,0,31,55,36,7,3],
		[7045,88,24,0,0,18,46,1,1,19,36,23,7,7],
		[7046,76,24,0,28,18,46,21,1,22,23,32,6,5],
		[7047,88,24,0,0,18,44,40,0,23,35,23,7,3],
		[7048,88,24,0,0,18,45,28,0,5,29,59,7,2],
		[7049,33,24,0,46,18,42,38,0,55,32,22,6,1],
		[7050,24,11,0,0,18,47,45,1,40,24,22,6,4],
		[7051,51,4,1,4,18,44,20,0,39,40,12,6,2],
		[7052,51,4,1,4,18,44,20,0,39,40,16,7,3],
		[7053,51,4,2,5,18,44,23,0,39,36,47,6,2],
		[7054,51,4,2,5,18,44,23,0,39,36,46,6,3],
		[7055,88,24,0,0,18,46,43,1,10,7,30,7,3],
		[7056,51,5,1,6,18,44,46,0,37,36,18,5,2],
		[7057,51,5,2,7,18,44,48,0,37,35,40,7,3],
		[7058,88,24,0,0,18,45,36,0,21,59,6,8,1],
		[7059,3,24,0,5,18,46,29,1,0,57,42,7,2],
		[7060,88,24,0,0,18,43,29,0,53,52,19,7,2],
		[7061,39,24,0,110,18,45,40,0,20,32,47,5,3],
		[7062,24,6,1,0,18,48,51,1,43,40,48,6,2],
		[7063,72,1,0,0,18,47,11,1,4,44,52,5,4],
		[7064,88,24,0,0,18,46,5,0,26,39,44,6,5],
		[7065,88,24,0,0,18,49,27,1,45,48,37,7,4],
		[7066,88,24,0,0,18,47,29,1,5,42,18,6,5],
		[7067,88,24,0,0,18,46,41,0,18,42,21,7,5],
		[7068,24,6,2,0,18,49,35,1,43,26,2,7,1],
		[7069,39,24,0,111,18,47,1,0,18,10,53,5,2],
		[7070,88,24,0,0,18,49,17,1,34,44,55,8,5],
		[7071,88,24,0,0,18,44,55,0,54,53,48,7,4],
		[7072,88,24,0,0,18,48,45,1,18,36,5,7,4],
		[7073,88,24,0,0,18,46,13,0,41,26,30,7,1],
		[7074,60,10,0,0,18,52,13,1,62,11,15,5,1],
		[7075,88,24,0,0,18,44,18,0,61,2,53,7,4],
		[7076,88,24,0,0,18,48,3,0,4,14,29,7,5],
		[7077,88,24,0,0,18,49,36,1,19,8,32,8,2],
		[7078,76,24,0,29,18,49,40,1,20,19,29,6,5],
		[7079,88,24,0,0,18,48,16,0,23,30,51,7,3],
		[7080,88,24,0,0,18,46,59,0,46,18,54,8,2],
		[7081,88,24,0,0,18,47,58,0,31,45,25,7,1],
		[7082,88,24,0,0,18,43,10,0,70,47,34,7,5],
		[7083,88,24,0,0,18,49,41,1,5,54,46,7,5],
		[7084,88,24,0,0,18,46,43,0,52,59,17,7,1],
		[7085,88,24,0,0,18,49,37,0,0,50,9,7,2],
		[7086,88,24,0,0,18,48,53,0,19,19,43,7,2],
		[7087,78,9,0,0,18,52,40,1,52,6,27,6,4],
		[7088,76,24,0,30,18,50,51,1,22,9,44,8,2],
		[7089,88,24,0,0,18,50,20,1,7,54,27,8,6],
		[7090,88,24,0,0,18,47,40,0,49,4,30,7,2],
		[7091,88,24,0,0,18,49,14,0,25,2,47,8,2],
		[7092,88,24,0,0,18,52,27,1,46,35,43,7,7],
		[7093,88,24,0,0,18,53,12,1,51,55,52,7,1],
		[7094,88,24,0,0,18,50,59,1,9,46,27,7,3],
		[7095,88,24,0,0,18,53,3,1,48,21,36,7,2],
		[7096,88,24,0,0,18,48,16,0,48,46,3,7,2],
		[7097,88,24,0,0,18,52,60,1,46,35,9,7,2],
		[7098,88,24,0,0,18,49,44,0,31,37,45,8,2],
		[7099,88,24,0,0,18,50,46,0,10,58,35,8,5],
		[7100,51,12,1,8,18,49,46,0,32,48,46,7,1],
		[7101,3,24,0,8,18,51,22,1,3,19,4,7,3],
		[7102,51,12,2,9,18,49,53,0,32,33,3,6,2],
		[7103,88,24,0,0,18,52,29,1,26,39,1,7,4],
		[7104,88,24,0,0,18,52,37,1,29,22,46,7,5],
		[7105,88,24,0,0,18,52,42,1,30,44,3,8,1],
		[7106,51,1,0,10,18,50,5,0,33,21,46,4,1],
		[7107,60,9,0,0,18,56,57,1,67,14,1,5,3],
		[7108,88,24,0,0,18,54,32,1,49,52,43,8,2],
		[7109,88,24,0,0,18,52,2,0,13,57,56,7,1],
		[7110,88,24,0,0,18,53,2,1,9,34,34,7,2],
		[7111,88,24,0,0,18,56,55,1,62,48,4,7,5],
		[7112,88,24,0,0,18,51,36,0,28,47,1,7,5],
		[7113,39,24,0,112,18,52,16,0,21,25,31,6,1],
		[7114,76,24,0,33,18,54,0,1,21,21,35,7,5],
		[7115,88,24,0,0,18,51,37,0,36,32,19,7,1],
		[7116,76,12,1,32,18,54,10,1,22,44,42,6,5],
		[7117,88,24,0,0,18,45,47,0,74,5,8,6,5],
		[7118,88,24,0,0,18,52,7,0,41,23,0,7,1],
		[7119,88,24,0,0,18,54,43,1,15,36,11,6,1],
		[7120,76,12,2,35,18,55,7,1,22,40,17,6,5],
		[7121,76,17,0,34,18,55,16,1,26,17,48,3,1],
		[7122,88,24,0,0,18,56,17,1,42,42,38,6,5],
		[7123,88,24,0,0,18,51,35,0,52,58,30,7,4],
		[7124,33,24,0,50,18,46,22,0,75,26,2,6,2],
		[7125,33,14,0,47,18,51,12,0,59,23,18,6,4],
		[7126,88,24,0,0,18,55,31,1,16,22,36,7,3],
		[7127,60,23,0,0,18,58,36,1,60,12,2,6,5],
		[7128,88,24,0,0,18,56,1,1,23,10,25,7,1],
		[7129,88,24,0,0,18,56,41,1,37,20,36,6,1],
		[7130,88,24,0,0,19,0,4,1,66,39,12,7,5],
		[7131,51,3,1,11,18,53,44,0,36,58,18,7,1],
		[7132,88,24,0,0,18,54,13,0,27,54,34,7,5],
		[7133,39,24,0,113,18,54,45,0,22,38,42,6,4],
		[7134,78,10,0,0,18,58,28,1,52,56,19,6,2],
		[7135,88,24,0,0,18,55,28,0,6,36,55,7,5],
		[7136,88,24,0,0,18,57,35,1,39,49,24,7,2],
		[7137,88,24,0,0,18,53,14,0,50,42,30,6,4],
		[7138,88,24,0,0,18,54,14,0,41,13,32,8,3],
		[7139,51,3,2,12,18,54,30,0,36,53,56,5,7],
		[7140,88,24,0,0,18,54,53,0,33,58,7,7,4],
		[7141,73,7,1,63,18,56,13,0,4,12,13,6,2],
		[7142,73,7,2,63,18,56,15,0,4,12,7,6,2],
		[7143,88,24,0,0,18,56,23,1,1,48,0,7,1],
		[7144,88,24,0,0,18,56,26,0,2,28,16,7,4],
		[7145,76,13,1,36,18,57,21,1,20,39,23,6,2],
		[7146,88,24,0,0,18,54,52,0,41,36,10,6,5],
		[7147,88,24,0,0,18,56,4,0,17,59,42,8,1],
		[7148,88,24,0,0,18,56,6,0,18,6,19,7,5],
		[7149,72,6,0,0,18,57,4,1,5,50,46,6,5],
		[7150,76,13,2,37,18,57,44,1,21,6,24,5,5],
		[7151,88,24,0,0,18,58,21,1,31,2,10,7,5],
		[7152,24,4,0,0,18,58,43,1,37,6,27,6,3],
		[7153,88,24,0,0,18,53,46,0,57,29,13,7,5],
		[7154,88,24,0,0,18,54,47,0,48,51,35,7,3],
		[7155,88,24,0,0,18,58,21,1,24,52,36,8,2],
		[7156,88,24,0,0,18,59,11,1,39,32,5,7,2],
		[7157,51,24,0,13,18,55,20,0,43,56,46,5,7],
		[7158,73,24,0,64,18,57,17,0,2,32,7,7,1],
		[7159,88,24,0,0,18,58,25,1,22,31,46,7,2],
		[7160,88,24,0,0,18,45,38,0,79,56,33,7,2],
		[7161,88,24,0,0,19,3,30,1,68,45,19,7,3],
		[7162,88,24,0,0,18,57,2,0,32,54,5,6,3],
		[7163,88,24,0,0,18,58,24,0,6,14,25,7,3],
		[7164,88,24,0,0,18,59,27,1,18,34,1,7,4],
		[7165,88,24,0,0,18,58,15,0,17,21,39,6,3],
		[7166,88,24,0,0,18,59,24,1,12,50,26,7,1],
		[7167,3,24,0,10,18,58,47,0,13,54,24,7,3],
		[7168,88,24,0,0,19,0,25,1,24,56,32,7,5],
		[7169,88,24,0,0,19,1,3,1,37,3,39,8,1],
		[7170,88,24,0,0,19,1,4,1,37,3,43,7,1],
		[7171,88,24,0,0,18,58,45,0,19,47,39,8,1],
		[7172,3,24,0,11,18,59,6,0,13,37,21,6,3],
		[7173,88,24,0,0,18,59,18,0,10,8,27,8,1],
		[7174,88,24,0,0,18,58,2,0,38,15,58,7,1],
		[7175,33,24,0,48,18,56,45,0,57,48,54,7,5],
		[7176,3,4,0,13,18,59,37,0,15,4,6,5,5],
		[7177,88,24,0,0,19,2,9,1,41,54,36,7,2],
		[7178,51,2,0,14,18,58,57,0,32,41,22,4,1],
		[7179,88,24,0,0,18,58,47,0,40,40,45,7,1],
		[7180,33,19,0,52,18,54,24,0,71,17,50,6,5],
		[7181,88,24,0,0,18,59,46,0,26,13,50,6,5],
		[7182,88,24,0,0,19,1,38,1,22,41,44,7,5],
		[7183,88,24,0,0,18,59,58,0,22,48,53,7,7],
		[7184,88,24,0,0,18,57,28,0,58,13,31,7,2],
		[7185,88,24,0,0,18,59,12,0,39,13,4,7,1],
		[7186,88,24,0,0,19,1,34,1,15,16,57,7,4],
		[7187,88,24,0,0,18,56,26,0,65,15,29,7,4],
		[7188,24,5,0,0,19,3,7,1,42,5,43,6,1],
		[7190,88,24,0,0,19,3,57,1,51,1,7,7,5],
		[7191,88,24,0,0,18,57,17,0,62,23,48,7,4],
		[7192,51,10,0,15,19,0,1,0,32,8,44,6,5],
		[7193,3,24,0,12,19,1,41,1,5,44,20,5,5],
		[7194,76,5,0,38,19,2,37,1,29,52,49,4,2],
		[7195,88,24,0,0,19,2,28,1,24,50,49,7,5],
		[7196,88,24,0,0,18,58,60,0,50,48,34,7,4],
		[7197,88,24,0,0,19,3,18,1,38,15,12,7,3],
		[7198,88,24,0,0,19,1,6,0,19,18,35,7,5],
		[7199,88,24,0,0,18,53,33,0,75,47,15,7,2],
		[7200,88,24,0,0,19,1,23,0,20,50,1,8,1],
		[7201,88,24,0,0,19,0,19,0,40,41,3,8,7],
		[7202,88,24,0,0,19,1,17,0,26,17,29,7,1],
		[7203,88,24,0,0,19,3,4,1,19,14,43,7,4],
		[7204,88,24,0,0,19,0,55,0,33,48,8,7,5],
		[7205,88,24,0,0,19,3,7,1,19,6,12,7,3],
		[7206,88,24,0,0,19,1,35,0,25,1,33,8,5],
		[7207,88,24,0,0,19,1,50,0,22,15,50,7,2],
		[7208,88,24,0,0,19,2,22,0,8,22,27,7,5],
		[7209,3,24,0,14,19,2,55,1,3,41,56,6,2],
		[7210,88,24,0,0,19,0,14,0,50,32,1,6,1],
		[7211,88,24,0,0,19,4,25,1,31,2,49,7,2],
		[7212,88,24,0,0,19,1,48,0,33,37,17,7,1],
		[7213,78,16,0,0,19,6,20,1,52,20,27,6,3],
		[7214,88,24,0,0,19,3,32,0,1,49,8,7,2],
		[7215,51,24,0,16,19,1,26,0,46,56,5,6,2],
		[7216,88,24,0,0,19,2,53,0,19,39,40,7,5],
		[7217,76,14,0,39,19,4,41,1,21,44,30,5,4],
		[7218,33,24,0,49,19,0,43,0,55,39,30,6,4],
		[7219,88,24,0,0,19,4,11,0,3,19,50,8,2],
		[7220,88,24,0,0,19,4,24,1,5,41,6,8,6],
		[7221,88,24,0,0,19,9,53,1,68,25,29,6,4],
		[7222,88,24,0,0,19,3,43,0,21,16,4,8,3],
		[7223,88,24,0,0,19,6,56,1,48,17,57,7,2],
		[7224,88,24,0,0,18,58,53,0,69,31,52,8,2],
		[7225,3,24,0,15,19,4,58,1,4,1,53,6,5],
		[7226,24,2,0,0,19,6,25,1,37,3,48,6,3],
		[7227,24,2,0,0,19,6,25,1,37,3,48,6,3],
		[7228,57,17,0,0,21,8,46,1,88,57,23,6,3],
		[7229,88,24,0,0,19,2,7,0,52,15,40,7,4],
		[7230,88,24,0,0,19,5,41,1,15,39,37,7,1],
		[7231,88,24,0,0,19,5,19,1,1,30,46,8,3],
		[7232,88,24,0,0,19,6,53,1,37,48,37,7,4],
		[7233,88,24,0,0,19,8,52,1,55,43,13,7,5],
		[7234,76,18,0,40,19,6,56,1,27,40,14,4,5],
		[7235,3,5,0,17,19,5,25,0,13,51,48,4,2],
		[7236,3,10,0,16,19,6,15,1,4,52,57,4,1],
		[7237,88,24,0,0,19,4,58,0,31,44,40,7,7],
		[7238,88,24,0,0,19,4,58,0,30,44,0,7,7],
		[7239,88,24,0,0,19,6,52,1,16,13,44,7,1],
		[7240,88,24,0,0,19,7,31,1,28,38,13,7,5],
		[7241,88,24,0,0,19,7,9,1,18,44,16,7,1],
		[7242,24,3,0,0,19,8,21,1,40,29,48,6,5],
		[7243,88,24,0,0,19,6,22,0,8,13,48,7,7],
		[7244,88,24,0,0,19,5,47,0,29,55,18,7,7],
		[7245,88,24,0,0,19,7,9,0,0,38,30,8,1],
		[7246,88,24,0,0,19,8,15,1,24,39,25,7,1],
		[7247,88,24,0,0,18,57,57,0,77,3,3,8,3],
		[7248,3,24,0,18,19,6,59,0,11,4,17,6,1],
		[7249,88,24,0,0,19,8,17,1,19,17,24,7,1],
		[7250,88,24,0,0,19,6,38,0,24,15,3,7,2],
		[7251,33,24,0,51,19,4,55,0,53,23,48,6,2],
		[7252,88,24,0,0,19,5,10,0,49,55,24,7,5],
		[7253,88,24,0,0,19,6,38,0,28,37,43,7,3],
		[7254,24,0,0,0,19,9,28,1,37,54,16,5,2],
		[7255,88,24,0,0,19,9,40,1,39,49,41,7,5],
		[7256,88,24,0,0,19,9,36,1,36,9,53,8,2],
		[7257,88,24,0,0,19,9,58,1,41,53,33,7,1],
		[7258,88,24,0,0,19,6,17,0,41,24,50,7,1],
		[7259,24,1,0,0,19,10,2,1,39,20,27,5,5],
		[7260,88,24,0,0,19,7,57,0,16,51,12,7,4],
		[7261,51,24,0,17,19,7,26,0,32,30,6,6,3],
		[7262,51,8,0,18,19,7,18,0,36,6,1,6,1],
		[7263,88,24,0,0,19,8,4,0,21,41,56,7,3],
		[7264,76,15,0,41,19,9,46,1,21,1,25,4,3],
		[7265,88,24,0,0,19,9,48,1,19,48,13,7,5],
		[7266,3,24,0,19,19,8,60,0,6,4,24,6,3],
		[7267,88,24,0,0,19,8,40,0,16,51,5,7,3],
		[7268,88,24,0,0,19,11,2,1,39,0,18,7,1],
		[7269,88,24,0,0,19,9,52,1,0,25,41,7,1],
		[7270,88,24,0,0,19,11,19,1,29,30,8,7,1],
		[7271,88,24,0,0,19,12,46,1,50,29,11,7,4],
		[7272,88,24,0,0,19,9,4,0,34,36,2,8,4],
		[7273,88,24,0,0,19,12,10,1,37,34,58,8,4],
		[7274,60,18,0,0,19,16,29,1,69,11,26,7,2],
		[7275,88,24,0,0,19,8,26,0,52,25,32,7,5],
		[7276,88,24,0,0,19,12,28,1,21,39,29,7,4],
		[7277,88,24,0,0,19,13,14,1,25,54,24,7,5],
		[7278,88,24,0,0,19,17,12,1,66,39,41,7,2],
		[7279,3,24,0,20,19,12,41,1,7,56,22,6,1],
		[7280,88,24,0,0,19,11,31,0,26,44,9,7,3],
		[7281,88,24,0,0,19,14,40,1,45,11,36,7,4],
		[7282,88,24,0,0,19,13,16,1,12,16,57,7,5],
		[7283,51,24,0,19,19,11,46,0,31,17,0,7,1],
		[7284,88,24,0,0,19,11,23,0,40,25,45,7,2],
		[7285,88,24,0,0,19,12,34,0,16,50,47,8,1],
		[7286,88,24,0,0,19,12,37,0,21,33,16,7,2],
		[7287,3,24,0,21,19,13,43,0,2,17,37,6,1],
		[7288,88,24,0,0,19,13,44,0,5,30,57,7,2],
		[7289,88,24,0,0,19,16,22,1,45,27,59,6,5],
		[7290,33,24,0,55,19,9,46,0,65,58,43,7,2],
		[7291,88,24,0,0,19,15,33,1,24,10,45,7,3],
		[7292,76,22,0,42,19,15,32,1,25,15,24,6,4],
		[7293,88,24,0,0,19,12,5,0,49,51,15,8,4],
		[7294,88,24,0,0,19,12,5,0,49,51,22,8,4],
		[7295,33,24,0,53,19,11,41,0,56,51,33,6,4],
		[7296,88,24,0,0,19,16,33,1,33,31,18,7,4],
		[7297,88,24,0,0,19,18,9,1,53,23,12,7,3],
		[7298,51,6,0,20,19,13,46,0,39,8,46,5,1],
		[7299,88,24,0,0,19,15,3,0,20,12,12,7,4],
		[7300,88,24,0,0,19,15,20,0,15,5,1,7,4],
		[7301,75,24,0,1,19,15,17,0,21,13,56,7,2],
		[7302,88,24,0,0,19,15,25,0,30,31,35,7,7],
		[7303,3,24,0,22,19,16,31,0,4,50,5,7,2],
		[7304,76,24,0,43,19,17,38,1,18,57,11,6,4],
		[7305,88,24,0,0,19,15,57,0,27,27,20,8,1],
		[7306,87,24,0,1,19,16,13,0,21,23,25,6,1],
		[7307,88,24,0,0,19,16,27,0,14,32,41,7,1],
		[7308,88,24,0,0,19,15,59,0,27,55,37,7,3],
		[7309,33,24,0,54,19,13,55,0,57,42,18,6,5],
		[7310,33,3,0,57,19,12,33,0,67,39,42,4,4],
		[7311,88,24,0,0,19,15,19,0,50,4,15,7,4],
		[7312,33,24,0,59,19,9,10,0,76,33,38,6,2],
		[7313,88,24,0,0,19,17,48,0,2,1,54,7,2],
		[7314,51,7,0,21,19,16,22,0,38,8,1,5,5],
		[7315,3,23,1,25,19,17,49,0,11,35,43,6,3],
		[7316,88,24,0,0,19,19,40,1,35,25,17,7,1],
		[7317,88,24,0,0,19,19,0,1,15,32,11,7,5],
		[7318,87,24,0,2,19,17,44,0,23,1,32,6,1],
		[7319,3,24,0,23,19,18,33,0,1,5,7,6,5],
		[7320,88,24,0,0,19,24,5,1,68,22,16,7,5],
		[7321,3,24,0,24,19,18,51,0,0,20,21,7,5],
		[7322,88,24,0,0,19,16,51,0,46,59,57,7,3],
		[7323,88,24,0,0,19,20,26,1,31,49,4,8,7],
		[7324,88,24,0,0,19,18,1,0,31,1,20,8,2],
		[7325,88,24,0,0,19,18,53,0,9,37,5,7,4],
		[7326,88,24,0,0,19,18,49,0,19,36,38,8,1],
		[7327,88,24,0,0,19,20,38,1,22,24,9,7,3],
		[7328,30,9,0,1,19,17,6,0,53,22,7,5,4],
		[7329,78,6,0,0,19,22,51,1,54,25,25,6,2],
		[7330,88,24,0,0,19,21,30,1,34,59,2,7,4],
		[7331,3,24,0,28,19,19,39,0,12,22,29,7,3],
		[7332,3,23,2,29,19,19,53,0,11,32,6,7,2],
		[7333,3,24,0,26,19,20,33,1,5,24,57,6,4],
		[7334,88,24,0,0,19,22,10,1,42,0,58,7,5],
		[7335,88,24,0,0,19,19,4,0,33,23,20,8,1],
		[7336,3,24,0,27,19,20,36,1,0,53,32,6,1],
		[7337,76,1,1,0,19,22,38,1,44,27,32,5,1],
		[7338,88,24,0,0,19,19,1,0,37,26,43,7,2],
		[7339,88,24,0,0,19,21,37,1,19,14,3,7,1],
		[7340,76,16,1,44,19,21,40,1,17,50,50,5,3],
		[7341,88,24,0,0,19,18,38,0,49,34,11,7,5],
		[7342,76,19,0,46,19,21,44,1,15,57,18,6,1],
		[7343,76,1,2,0,19,23,13,1,44,47,59,5,3],
		[7344,76,16,2,45,19,21,51,1,18,18,30,7,4],
		[7345,88,24,0,0,19,19,39,0,37,19,50,7,4],
		[7346,88,24,0,0,19,20,33,0,35,11,10,7,1],
		[7347,88,24,0,0,19,22,21,1,8,12,4,7,1],
		[7348,76,0,0,0,19,23,53,1,40,36,58,5,1],
		[7349,88,24,0,0,19,22,22,1,0,15,9,7,4],
		[7350,88,24,0,0,19,24,21,1,43,43,23,7,7],
		[7351,88,24,0,0,19,19,37,0,54,22,34,7,2],
		[7352,33,18,0,60,19,15,33,0,73,21,20,5,5],
		[7353,88,24,0,0,19,23,5,1,7,24,1,7,5],
		[7354,88,24,0,0,19,22,48,0,9,54,47,7,3],
		[7355,88,24,0,0,19,24,30,1,27,51,56,7,1],
		[7356,88,24,0,0,19,20,16,0,57,38,43,7,7],
		[7357,88,24,0,0,19,23,8,0,14,55,16,8,3],
		[7358,87,24,0,3,19,22,51,0,26,15,45,6,1],
		[7359,88,24,0,0,19,22,33,0,33,31,5,7,5],
		[7360,88,24,0,0,19,25,4,1,29,18,33,7,5],
		[7361,88,24,0,0,19,19,46,0,64,23,27,8,1],
		[7362,76,21,1,47,19,25,17,1,24,30,31,6,2],
		[7363,76,21,3,49,19,25,30,1,23,57,44,6,5],
		[7364,88,24,0,0,19,23,47,0,20,15,52,7,1],
		[7365,88,24,0,0,19,21,25,0,57,46,1,7,5],
		[7366,88,24,0,0,19,25,2,1,4,53,3,8,2],
		[7367,88,24,0,0,19,25,22,1,13,53,49,7,5],
		[7368,88,24,0,0,19,23,34,0,33,13,20,7,4],
		[7369,75,24,0,2,19,24,22,0,16,56,16,7,2],
		[7370,88,24,0,0,19,27,48,1,54,19,31,7,5],
		[7371,33,15,0,58,19,20,40,0,65,42,53,6,2],
		[7372,30,24,0,2,19,24,8,0,29,37,17,6,1],
		[7373,3,24,0,31,19,24,58,0,11,56,40,6,4],
		[7374,88,24,0,0,19,24,22,0,28,5,16,8,1],
		[7375,76,24,0,50,19,26,19,1,21,46,36,7,5],
		[7376,88,24,0,0,19,24,6,0,36,27,7,7,5],
		[7377,3,3,0,30,19,25,30,0,3,6,53,4,3],
		[7378,88,24,0,0,19,26,11,1,15,3,11,7,1],
		[7379,88,24,0,0,19,26,25,1,14,33,4,8,2],
		[7380,88,24,0,0,19,26,57,1,29,44,36,7,1],
		[7381,88,24,0,0,19,23,24,0,50,16,17,8,1],
		[7382,88,24,0,0,19,23,57,0,43,23,17,7,4],
		[7383,88,24,0,0,19,31,11,1,68,26,2,7,5],
		[7384,88,24,0,0,19,25,22,0,20,16,17,7,2],
		[7385,87,24,0,4,19,25,29,0,19,47,55,6,5],
		[7386,88,24,0,0,19,25,26,0,24,54,46,7,3],
		[7387,3,12,0,32,19,26,31,0,0,20,19,6,3],
		[7388,88,24,0,0,19,29,53,1,55,26,29,7,5],
		[7389,88,24,0,0,19,26,24,0,13,1,26,7,3],
		[7390,87,24,0,5,19,26,13,0,20,5,52,7,2],
		[7391,88,24,0,0,19,26,29,0,19,53,29,7,7],
		[7392,88,24,0,0,19,29,24,1,43,26,45,7,2],
		[7393,78,11,0,0,19,30,35,1,55,6,36,7,3],
		[7394,83,10,0,0,17,16,57,0,89,2,16,7,7],
		[7395,30,24,0,4,19,26,9,0,36,19,4,6,1],
		[7396,88,24,0,0,19,27,34,0,14,16,57,7,1],
		[7397,88,24,0,0,19,28,21,0,2,55,49,7,1],
		[7398,88,24,0,0,19,29,52,1,26,59,8,7,5],
		[7399,88,24,0,0,19,30,15,1,32,5,32,8,3],
		[7400,3,24,0,35,19,29,1,0,1,57,1,7,2],
		[7401,88,24,0,0,19,25,47,0,58,1,38,8,1],
		[7402,88,24,0,0,19,29,22,1,7,2,38,8,3],
		[7403,88,24,0,0,19,27,37,0,37,56,28,7,1],
		[7404,88,24,0,0,19,29,18,0,0,14,46,7,5],
		[7405,87,0,0,6,19,28,42,0,24,39,54,5,7],
		[7406,87,24,0,8,19,28,57,0,24,46,7,7,5],
		[7407,88,24,0,0,19,29,22,0,14,35,45,7,5],
		[7408,30,8,1,7,19,27,26,0,52,19,14,7,2],
		[7409,87,24,0,7,19,29,21,0,20,16,47,7,1],
		[7410,88,24,0,0,19,30,54,1,21,18,44,7,2],
		[7411,88,24,0,0,19,32,54,1,53,11,9,7,3],
		[7412,88,24,0,0,19,30,11,0,2,54,15,7,5],
		[7413,88,24,0,0,19,26,27,0,62,33,26,7,5],
		[7414,3,24,0,36,19,30,40,1,2,47,20,6,7],
		[7415,88,24,0,0,19,30,33,0,3,26,40,7,2],
		[7416,88,24,0,0,19,33,22,1,45,16,19,7,2],
		[7417,30,1,1,6,19,30,43,0,27,57,35,4,5],
		[7418,30,1,2,6,19,30,45,0,27,57,55,6,1],
		[7419,88,24,0,0,19,30,47,0,36,13,43,7,1],
		[7420,30,8,2,10,19,29,42,0,51,43,47,5,2],
		[7421,88,24,0,0,19,31,22,0,26,37,2,7,5],
		[7422,88,24,0,0,19,34,9,1,40,2,5,7,2],
		[7423,88,24,0,0,19,21,40,0,79,36,10,7,2],
		[7424,78,8,0,0,19,35,13,1,48,5,57,6,5],
		[7425,88,24,0,0,19,15,8,0,83,27,46,8,2],
		[7426,30,24,0,8,19,31,46,0,34,27,11,6,1],
		[7427,88,24,0,0,19,31,19,0,50,18,24,7,5],
		[7428,88,24,0,0,19,31,14,0,55,43,55,7,5],
		[7429,3,11,0,38,19,34,5,0,7,22,44,5,5],
		[7430,3,24,0,37,19,35,7,1,10,33,37,6,4],
		[7431,76,24,0,51,19,36,2,1,24,43,9,7,2],
		[7432,88,24,0,0,19,35,30,1,7,27,37,7,5],
		[7433,88,24,0,0,19,35,34,1,12,15,10,7,5],
		[7434,88,24,0,0,19,38,26,1,57,59,0,7,5],
		[7435,88,24,0,0,19,39,52,1,66,41,8,7,2],
		[7436,88,24,0,0,19,33,36,0,38,45,44,8,2],
		[7437,87,24,0,9,19,34,35,0,19,46,24,6,1],
		[7438,88,24,0,0,19,35,25,0,2,54,48,7,3],
		[7439,88,24,0,0,19,36,26,1,18,51,10,7,3],
		[7440,76,24,0,52,19,36,42,1,24,53,1,6,1],
		[7441,30,24,0,9,19,34,51,0,29,27,47,6,3],
		[7442,88,24,0,0,19,33,42,0,49,15,45,7,7],
		[7443,88,24,0,0,19,37,3,1,18,13,52,7,5],
		[7444,88,24,0,0,19,34,41,0,42,24,46,6,2],
		[7445,88,24,0,0,19,36,8,0,11,9,0,8,2],
		[7446,3,9,0,39,19,36,54,1,7,1,39,6,1],
		[7447,3,8,0,41,19,36,43,1,1,17,11,5,1],
		[7448,88,24,0,0,19,33,10,0,60,9,31,7,5],
		[7449,88,24,0,0,19,36,16,0,14,23,30,7,5],
		[7450,88,24,0,0,19,31,0,0,70,59,22,7,5],
		[7451,88,24,0,0,19,34,20,0,51,14,12,7,3],
		[7452,88,24,0,0,19,36,8,0,22,35,9,7,1],
		[7453,88,24,0,0,19,34,40,0,48,9,53,8,2],
		[7454,88,24,0,0,19,37,34,1,14,18,6,6,3],
		[7455,88,24,0,0,19,41,38,1,65,51,15,7,7],
		[7456,88,24,0,0,19,36,53,0,11,16,24,7,4],
		[7457,30,24,0,11,19,35,48,0,36,56,40,7,1],
		[7458,88,24,0,0,19,36,38,0,20,19,58,8,3],
		[7459,88,24,0,0,19,40,18,1,54,25,3,7,5],
		[7460,3,24,0,42,19,37,47,1,4,38,51,6,3],
		[7461,88,24,0,0,19,39,42,1,45,16,41,7,3],
		[7462,33,17,0,61,19,32,22,0,69,39,40,6,5],
		[7463,75,4,0,4,19,37,17,0,16,27,46,7,4],
		[7464,88,24,0,0,19,39,56,1,39,26,0,8,2],
		[7465,88,24,0,0,19,35,56,0,50,14,19,8,4],
		[7466,88,24,0,0,19,37,9,0,29,20,1,7,1],
		[7467,88,24,0,0,19,36,57,0,38,23,2,8,1],
		[7468,88,24,0,0,19,36,38,0,44,41,42,6,4],
		[7469,30,7,0,13,19,36,27,0,50,13,16,5,3],
		[7470,76,24,0,53,19,39,49,1,23,25,40,7,1],
		[7471,88,24,0,0,19,38,49,0,3,22,54,7,1],
		[7472,88,24,0,0,19,38,18,0,20,46,58,7,5],
		[7473,88,24,0,0,19,40,7,1,23,25,43,7,5],
		[7474,3,17,0,44,19,39,12,0,5,23,52,6,1],
		[7475,88,24,0,0,19,39,25,0,16,34,17,7,5],
		[7476,76,24,0,54,19,40,43,1,16,17,36,7,5],
		[7477,88,24,0,0,19,37,57,0,49,17,4,7,4],
		[7478,30,20,0,12,19,39,23,0,30,9,12,6,4],
		[7479,75,0,0,5,19,40,6,0,18,0,50,5,4],
		[7480,3,24,0,45,19,40,43,1,0,37,16,7,2],
		[7481,88,24,0,0,19,39,45,0,33,58,45,7,2],
		[7482,88,24,0,0,19,40,28,0,20,28,36,8,1],
		[7483,30,24,0,14,19,39,27,0,42,49,6,6,1],
		[7484,88,24,0,0,19,38,41,0,54,58,26,7,3],
		[7485,88,24,0,0,19,40,40,0,23,43,3,8,1],
		[7486,88,24,0,0,19,41,6,0,13,48,56,7,1],
		[7487,88,24,0,0,19,39,34,0,45,57,29,7,4],
		[7488,75,1,0,6,19,41,3,0,17,28,34,5,4],
		[7489,76,24,0,55,19,42,31,1,16,7,26,6,3],
		[7490,88,24,0,0,19,41,15,0,22,27,10,7,5],
		[7491,88,24,0,0,19,43,38,1,37,32,20,7,1],
		[7492,88,24,0,0,19,40,41,0,43,4,40,7,7],
		[7493,3,24,0,46,19,42,13,0,12,11,36,7,1],
		[7494,88,24,0,0,19,56,2,1,81,20,59,7,5],
		[7495,88,24,0,0,19,40,50,0,45,31,30,6,3],
		[7496,88,24,0,0,19,43,34,1,15,28,12,6,3],
		[7497,3,21,0,47,19,42,34,0,11,49,36,6,4],
		[7498,88,24,0,0,19,49,25,1,72,30,12,6,2],
		[7499,88,24,0,0,19,41,58,0,40,15,14,7,2],
		[7500,88,24,0,0,19,40,13,0,60,30,26,8,2],
		[7501,88,24,0,0,19,42,49,0,29,19,54,7,3],
		[7502,88,24,0,0,19,42,45,0,32,25,36,7,2],
		[7503,30,24,0,16,19,41,49,0,50,31,31,7,4],
		[7504,88,24,0,0,19,41,52,0,50,31,3,7,4],
		[7505,88,24,0,0,19,43,10,0,30,40,43,7,2],
		[7506,87,24,0,10,19,43,43,0,25,46,19,6,4],
		[7507,88,24,0,0,19,46,1,1,31,54,31,7,1],
		[7508,88,24,0,0,19,43,56,0,27,8,8,7,1],
		[7509,88,24,0,0,19,42,4,0,55,27,48,7,7],
		[7510,78,12,0,0,19,48,1,1,56,21,45,6,2],
		[7511,3,22,0,48,19,44,34,0,13,18,10,7,1],
		[7512,88,24,0,0,19,43,51,0,34,9,45,7,1],
		[7513,88,24,0,0,19,49,53,1,66,48,46,7,5],
		[7514,88,24,0,0,19,43,45,0,41,46,23,7,7],
		[7515,76,24,0,56,19,46,22,1,19,45,40,6,5],
		[7516,88,24,0,0,19,45,52,1,2,53,0,7,1],
		[7517,30,24,0,15,19,44,17,0,37,21,16,6,4],
		[7518,88,24,0,0,19,44,49,0,29,15,53,8,3],
		[7519,3,19,0,49,19,45,40,0,7,36,48,7,2],
		[7520,88,24,0,0,19,44,38,0,34,24,50,8,7],
		[7521,88,24,0,0,19,48,55,1,52,53,17,7,5],
		[7522,88,24,0,0,19,43,15,0,58,0,59,7,4],
		[7523,88,24,0,0,19,44,49,0,40,43,0,7,7],
		[7524,88,24,0,0,19,51,1,1,65,36,18,7,3],
		[7525,3,2,0,50,19,46,16,0,10,36,48,4,5],
		[7526,88,24,0,0,19,43,40,0,57,2,33,7,5],
		[7527,88,24,0,0,19,50,22,1,61,3,41,7,1],
		[7528,30,3,0,18,19,44,59,0,45,7,51,4,1],
		[7529,88,24,0,0,19,45,40,0,36,5,28,7,1],
		[7530,88,24,0,0,19,45,51,0,35,0,46,7,5],
		[7531,88,24,0,0,19,50,45,1,59,11,35,6,2],
		[7532,88,24,0,0,19,48,3,1,13,42,12,7,2],
		[7533,88,24,0,0,19,46,40,0,25,8,2,8,2],
		[7534,30,24,0,17,19,46,26,0,33,43,40,6,3],
		[7535,88,24,0,0,19,46,35,0,32,53,19,7,5],
		[7536,75,3,0,7,19,47,23,0,18,32,3,5,7],
		[7537,88,24,0,0,19,50,14,1,47,33,26,7,7],
		[7538,88,24,0,0,19,49,12,1,28,47,20,7,3],
		[7540,88,24,0,0,19,47,49,0,25,23,2,7,5],
		[7541,88,24,0,0,19,49,2,1,10,52,15,7,5],
		[7542,88,24,0,0,19,48,30,0,10,41,39,7,3],
		[7543,88,24,0,0,19,47,28,0,38,24,27,7,1],
		[7544,3,15,0,52,19,48,42,0,11,48,57,7,4],
		[7545,88,24,0,0,19,44,19,0,69,20,13,7,2],
		[7546,75,5,0,8,19,48,59,0,19,8,32,6,2],
		[7547,88,24,0,0,19,47,27,0,47,54,28,7,7],
		[7548,88,24,0,0,19,52,38,1,54,58,16,7,4],
		[7549,88,24,0,0,19,52,39,1,54,58,36,8,2],
		[7550,88,24,0,0,19,48,44,0,35,18,41,8,3],
		[7551,88,24,0,0,19,48,51,0,33,26,14,7,1],
		[7552,88,24,0,0,19,51,51,1,39,52,28,6,2],
		[7553,3,24,0,51,19,50,47,1,10,45,49,6,3],
		[7554,88,24,0,0,19,50,18,0,7,54,9,8,1],
		[7555,88,24,0,0,19,49,28,0,38,42,36,7,4],
		[7556,88,24,0,0,19,49,55,0,28,26,26,7,1],
		[7557,3,0,0,53,19,50,47,0,8,52,6,2,2],
		[7558,88,24,0,0,19,54,40,1,61,10,15,7,2],
		[7559,88,24,0,0,19,51,11,1,2,27,39,7,5],
		[7560,3,14,0,54,19,51,2,0,10,24,56,6,3],
		[7561,76,24,0,57,19,52,12,1,19,2,42,7,4],
		[7562,88,24,0,0,19,51,18,0,9,37,49,7,2],
		[7563,88,24,0,0,19,46,45,0,68,26,18,7,3],
		[7564,30,21,0,0,19,50,34,0,32,54,51,5,7],
		[7565,87,24,0,12,19,51,4,0,22,36,36,6,1],
		[7566,30,24,0,19,19,50,34,0,38,43,21,6,7],
		[7567,88,24,0,0,19,50,37,0,40,35,59,7,1],
		[7568,88,24,0,0,19,50,47,0,37,49,35,7,7],
		[7569,88,24,0,0,19,52,4,0,11,37,44,7,4],
		[7570,3,6,0,55,19,52,28,0,1,0,20,5,3],
		[7571,88,24,0,0,19,53,6,1,14,36,11,7,2],
		[7572,88,24,0,0,19,52,16,0,10,21,5,8,1],
		[7573,88,24,0,0,19,52,2,0,24,59,32,7,2],
		[7574,75,24,0,9,19,52,22,0,18,40,19,7,0],
		[7575,88,24,0,0,19,53,19,1,3,6,52,7,2],
		[7576,30,24,0,20,19,50,38,0,52,59,17,6,5],
		[7577,88,24,0,0,19,51,19,0,47,22,38,7,3],
		[7578,88,24,0,0,19,54,18,1,23,56,28,7,5],
		[7579,88,24,0,0,19,58,41,1,69,9,50,7,2],
		[7580,88,24,0,0,19,53,23,0,4,24,2,8,1],
		[7581,76,8,0,0,19,55,16,1,41,52,6,5,5],
		[7582,33,4,0,63,19,48,10,0,70,16,4,5,4],
		[7583,88,24,0,0,19,52,16,0,36,25,56,7,5],
		[7584,3,24,0,56,19,54,8,1,8,34,27,7,5],
		[7585,88,24,0,0,19,55,5,1,33,2,47,7,5],
		[7586,88,24,0,0,19,56,58,1,57,55,32,8,5],
		[7587,88,24,0,0,19,57,6,1,58,54,5,6,1],
		[7588,88,24,0,0,19,58,53,1,68,45,44,7,2],
		[7589,88,24,0,0,19,51,59,0,47,1,39,7,0],
		[7590,60,4,0,0,20,0,36,1,72,54,38,5,2],
		[7591,88,24,0,0,19,52,7,0,47,55,55,7,1],
		[7592,87,24,0,13,19,53,28,0,24,4,47,6,1],
		[7593,3,24,0,57,19,54,38,1,8,13,38,7,1],
		[7594,3,24,0,57,19,54,38,1,8,14,14,7,1],
		[7595,3,13,0,59,19,54,15,0,8,27,41,6,4],
		[7596,3,24,0,58,19,54,45,0,0,16,25,7,2],
		[7597,76,23,0,58,19,55,50,1,26,17,58,6,4],
		[7598,88,24,0,0,19,54,40,0,7,8,25,7,2],
		[7599,88,24,0,0,19,55,20,1,6,44,3,8,3],
		[7600,88,24,0,0,19,53,1,0,47,48,27,7,1],
		[7601,88,24,0,0,19,54,31,0,24,19,10,7,2],
		[7602,3,1,0,60,19,55,19,0,6,24,24,5,4],
		[7603,60,11,1,0,20,0,23,1,66,56,58,7,5],
		[7604,76,24,0,59,19,56,57,1,27,10,12,6,5],
		[7605,88,24,0,0,19,57,41,1,38,3,30,8,3],
		[7606,88,24,0,0,19,54,48,0,36,59,46,7,4],
		[7607,88,24,0,0,19,55,7,0,30,11,43,8,1],
		[7608,30,24,0,23,19,53,17,0,57,31,25,6,1],
		[7609,75,24,0,10,19,56,1,0,16,38,5,6,4],
		[7610,3,20,0,61,19,56,14,0,11,25,26,6,2],
		[7611,88,24,0,0,19,53,35,0,59,42,32,7,2],
		[7612,60,11,2,0,20,1,52,1,66,56,39,6,5],
		[7613,30,24,0,22,19,55,52,0,38,29,12,6,1],
		[7614,76,24,0,61,19,57,57,1,15,29,29,6,2],
		[7615,30,6,0,21,19,56,18,0,35,5,0,5,5],
		[7616,88,24,0,0,19,57,0,0,20,59,53,7,2],
		[7617,88,24,0,0,19,58,56,1,30,32,17,7,5],
		[7618,76,24,0,60,19,58,57,1,26,11,44,6,4],
		[7619,30,22,0,24,19,55,38,0,52,26,20,6,2],
		[7620,88,24,0,0,19,56,44,0,36,15,3,7,1],
		[7621,88,24,0,0,20,0,25,1,49,21,4,7,5],
		[7622,75,24,0,11,19,57,45,0,16,47,21,7,1],
		[7623,76,7,1,0,19,59,44,1,35,16,35,5,1],
		[7624,76,7,2,0,19,59,51,1,34,41,52,6,2],
		[7625,88,24,0,0,20,1,45,1,59,22,34,6,7],
		[7626,88,24,0,0,19,55,22,0,58,15,1,7,4],
		[7627,88,24,0,0,20,0,27,1,43,2,36,7,7],
		[7628,88,24,0,0,19,57,14,0,40,22,5,6,1],
		[7629,88,24,0,0,20,0,16,1,37,42,8,7,4],
		[7630,88,24,0,0,20,0,48,1,45,6,47,7,2],
		[7631,88,24,0,0,20,0,20,1,33,42,14,7,3],
		[7632,88,24,0,0,19,56,45,0,50,54,9,7,2],
		[7633,88,24,0,0,19,55,55,0,58,50,46,6,5],
		[7634,88,24,0,0,19,56,19,0,56,41,13,7,2],
		[7635,75,2,0,12,19,58,45,0,19,29,32,4,7],
		[7636,88,24,0,0,19,59,23,0,1,22,40,7,4],
		[7637,88,24,0,0,19,59,47,1,9,57,30,7,3],
		[7638,88,24,0,0,19,57,56,0,42,15,39,7,2],
		[7639,88,24,0,0,20,1,26,1,40,48,51,7,2],
		[7640,88,24,0,0,19,58,38,0,30,59,1,6,1],
		[7641,87,24,0,14,19,59,11,0,23,6,5,7,3],
		[7642,88,24,0,0,19,58,34,0,38,6,20,7,1],
		[7643,88,24,0,0,20,1,24,1,22,44,14,7,4],
		[7644,88,24,0,0,20,5,33,1,67,19,15,7,4],
		[7645,75,24,0,13,20,0,3,0,17,31,0,6,7],
		[7646,88,24,0,0,19,59,21,0,45,46,20,7,2],
		[7647,30,24,0,25,19,59,55,0,37,2,34,6,1],
		[7648,88,24,0,0,20,0,59,0,8,33,29,7,5],
		[7649,76,24,0,63,20,1,59,1,13,38,13,7,2],
		[7650,76,24,0,62,20,2,40,1,27,42,35,6,7],
		[7651,88,24,0,0,19,59,15,0,52,3,21,7,1],
		[7652,88,24,0,0,20,3,34,1,37,56,27,6,5],
		[7653,87,24,0,15,20,1,6,0,27,45,13,6,2],
		[7654,88,24,0,0,19,58,29,0,63,32,3,7,2],
		[7655,88,24,0,0,20,1,15,0,37,5,56,7,5],
		[7656,88,24,0,0,20,1,45,0,24,48,1,7,1],
		[7657,87,24,0,16,20,2,1,0,24,56,17,6,3],
		[7658,88,24,0,0,20,3,44,1,22,35,44,7,3],
		[7659,88,24,0,0,20,4,20,1,32,3,23,6,5],
		[7660,30,24,0,26,20,1,22,0,50,6,17,6,5],
		[7661,88,24,0,0,20,4,1,1,7,28,11,8,3],
		[7662,88,24,0,0,20,3,16,0,18,30,2,7,5],
		[7663,88,24,0,0,20,8,21,1,66,21,17,7,5],
		[7664,88,24,0,0,20,3,30,0,16,1,53,7,1],
		[7665,60,3,0,0,20,8,44,1,66,10,55,5,4],
		[7666,88,24,0,0,19,58,42,0,70,22,1,7,4],
		[7667,3,24,0,62,20,4,23,1,0,42,34,7,5],
		[7668,88,24,0,0,20,5,32,1,33,0,0,8,1],
		[7669,3,18,0,63,20,4,8,0,7,16,41,7,5],
		[7670,88,24,0,0,20,3,37,0,29,53,48,7,4],
		[7671,88,24,0,0,20,5,5,1,11,35,58,7,3],
		[7672,75,24,0,15,20,4,6,0,17,4,12,7,4],
		[7673,78,13,0,0,20,7,23,1,52,52,51,6,7],
		[7674,88,24,0,0,20,7,35,1,55,0,59,7,3],
		[7675,76,24,0,65,20,5,26,1,12,39,55,8,2],
		[7676,33,24,0,64,20,1,29,0,64,49,16,6,7],
		[7677,88,24,0,0,20,4,59,0,23,12,37,7,2],
		[7678,88,24,0,0,20,4,36,0,32,13,7,7,1],
		[7679,75,6,0,16,20,5,10,0,19,59,28,6,5],
		[7680,88,24,0,0,20,5,27,0,15,30,1,7,7],
		[7681,88,24,0,0,20,6,12,1,4,4,42,7,5],
		[7682,33,24,0,65,20,2,20,0,64,38,4,8,4],
		[7683,88,24,0,0,20,5,10,0,38,28,42,7,4],
		[7684,88,24,0,0,20,4,29,0,48,13,47,7,2],
		[7685,33,16,0,67,20,2,49,0,67,52,25,6,5],
		[7686,33,24,0,69,19,59,37,0,76,28,53,7,7],
		[7687,88,24,0,0,20,5,7,0,51,50,22,7,7],
		[7688,87,24,0,17,20,6,53,0,23,36,52,6,1],
		[7689,30,24,0,27,20,6,22,0,35,58,21,6,5],
		[7690,3,24,0,64,20,8,2,1,0,40,42,7,5],
		[7691,88,24,0,0,20,11,7,1,57,31,26,7,1],
		[7692,88,24,0,0,20,5,22,0,56,20,29,7,3],
		[7693,88,24,0,0,20,7,50,0,9,23,59,7,3],
		[7694,88,24,0,0,20,8,31,1,10,3,46,7,1],
		[7695,88,24,0,0,20,4,45,0,63,53,26,7,2],
		[7696,88,24,0,0,20,8,7,0,16,39,51,7,7],
		[7697,88,24,0,0,20,6,14,0,53,9,57,7,3],
		[7698,88,24,0,0,20,24,54,1,83,18,38,7,2],
		[7699,88,24,0,0,20,7,41,0,34,25,23,7,1],
		[7700,88,24,0,0,20,8,38,0,10,43,33,7,1],
		[7701,33,24,0,66,20,5,33,0,61,59,44,6,5],
		[7702,88,24,0,0,20,7,12,0,50,13,45,8,2],
		[7703,88,24,0,0,20,11,12,1,36,6,4,6,5],
		[7704,88,24,0,0,20,4,53,0,68,1,38,7,7],
		[7705,75,7,0,17,20,9,57,0,20,54,55,7,3],
		[7706,88,24,0,0,20,12,24,1,42,46,50,7,5],
		[7707,88,24,0,0,20,14,27,1,63,24,57,7,3],
		[7708,30,24,0,28,20,9,26,0,36,50,23,6,1],
		[7709,88,24,0,0,20,11,10,1,8,50,32,7,1],
		[7710,3,7,0,65,20,11,18,1,0,49,17,4,1],
		[7711,87,24,0,18,20,10,34,0,26,54,15,7,2],
		[7712,11,13,1,1,20,11,58,1,12,23,33,7,5],
		[7713,88,24,0,0,20,11,4,0,21,8,5,7,5],
		[7714,88,24,0,0,20,14,19,1,52,26,44,7,5],
		[7715,11,13,2,2,20,12,26,1,12,37,3,7,3],
		[7716,88,24,0,0,20,11,21,0,21,52,32,7,1],
		[7717,88,24,0,0,20,12,35,0,0,52,3,7,1],
		[7718,87,24,0,19,20,11,48,0,26,48,32,6,5],
		[7719,87,24,0,20,20,12,1,0,26,28,44,7,1],
		[7720,3,24,0,66,20,13,14,1,1,0,34,6,5],
		[7721,88,24,0,0,20,12,4,0,47,44,13,8,1],
		[7722,88,24,0,0,20,15,17,1,27,1,58,7,5],
		[7723,88,24,0,0,20,13,41,0,24,14,20,8,2],
		[7724,3,16,0,67,20,14,17,0,15,11,51,6,2],
		[7725,88,24,0,0,20,15,51,1,30,0,19,7,5],
		[7726,88,24,0,0,20,12,32,0,51,27,49,7,5],
		[7727,33,24,0,68,20,11,35,0,62,4,43,7,3],
		[7728,88,24,0,0,20,16,24,1,36,27,16,7,7],
		[7729,88,24,0,0,20,16,27,1,35,11,52,8,3],
		[7730,30,24,0,30,20,13,18,0,46,48,57,6,2],
		[7731,87,24,0,21,20,14,15,0,28,41,41,6,2],
		[7732,88,24,0,0,20,19,3,1,63,13,52,7,5],
		[7733,88,24,0,0,20,13,43,0,43,22,45,7,5],
		[7734,88,24,0,0,20,14,5,0,36,36,19,7,2],
		[7735,30,24,0,31,20,13,38,0,46,44,29,5,5],
		[7736,30,24,0,29,20,14,32,0,36,48,23,6,2],
		[7737,88,24,0,0,20,14,22,0,42,6,13,8,1],
		[7738,11,24,0,3,20,16,23,1,12,20,13,7,1],
		[7739,88,24,0,0,20,15,16,0,25,35,31,6,1],
		[7740,30,24,0,33,20,13,24,0,56,34,4,5,2],
		[7741,87,24,0,22,20,15,30,0,23,30,31,6,4],
		[7742,88,24,0,0,20,13,28,0,60,38,26,7,5],
		[7743,88,24,0,0,20,15,24,0,33,43,46,7,5],
		[7744,87,24,0,23,20,15,46,0,27,48,51,6,5],
		[7745,88,24,0,0,20,18,56,1,47,42,39,7,7],
		[7746,75,24,0,18,20,16,20,0,21,35,55,7,5],
		[7747,11,0,0,5,20,17,39,1,12,30,30,5,4],
		[7748,11,24,0,4,20,18,1,1,21,48,36,7,5],
		[7749,88,24,0,0,20,19,18,1,47,34,49,7,3],
		[7750,15,9,0,1,20,8,53,0,77,42,41,5,1],
		[7751,30,24,0,32,20,15,28,0,47,42,52,5,5],
		[7752,88,24,0,0,20,16,3,0,38,53,52,7,2],
		[7753,87,24,0,24,20,16,47,0,24,40,16,6,4],
		[7754,11,0,2,6,20,18,3,1,12,32,41,5,4],
		[7755,88,24,0,0,20,15,43,0,50,13,58,7,2],
		[7756,88,24,0,0,20,16,1,0,45,34,46,7,3],
		[7757,88,24,0,0,20,16,28,0,37,3,23,7,1],
		[7758,88,24,0,0,20,20,32,1,55,3,3,7,7],
		[7759,88,24,0,0,20,16,55,0,40,21,54,6,5],
		[7760,88,24,0,0,20,17,32,0,29,8,53,7,4],
		[7761,11,17,0,7,20,19,24,1,19,7,7,6,5],
		[7762,88,24,0,0,20,17,29,0,42,43,19,7,5],
		[7763,30,24,0,34,20,17,47,0,38,1,59,6,1],
		[7764,88,24,0,0,20,20,28,1,29,11,50,7,2],
		[7765,88,24,0,0,20,20,52,1,35,40,25,7,5],
		[7766,88,24,0,0,20,21,41,1,49,59,58,7,4],
		[7767,88,24,0,0,20,18,7,0,40,43,56,7,0],
		[7768,88,24,0,0,20,19,43,1,1,4,43,7,5],
		[7769,30,24,0,36,20,18,29,0,37,0,0,7,2],
		[7770,30,24,0,35,20,18,39,0,34,58,58,6,3],
		[7771,88,24,0,0,20,19,29,0,13,13,1,7,7],
		[7772,88,24,0,0,20,20,26,1,6,21,42,8,5],
		[7773,11,12,0,8,20,20,40,1,12,45,33,6,1],
		[7774,88,24,0,0,20,20,0,0,13,32,53,7,2],
		[7775,88,24,0,0,20,20,47,1,14,47,6,7,2],
		[7776,11,1,0,9,20,21,1,1,14,46,53,4,3],
		[7777,88,24,0,0,20,18,50,0,46,19,22,7,1],
		[7778,88,24,0,0,20,20,21,0,14,34,9,7,4],
		[7779,76,9,1,0,20,22,28,1,42,2,59,7,2],
		[7780,88,24,0,0,20,20,21,0,17,47,35,7,5],
		[7781,88,24,0,0,20,18,25,0,55,23,50,7,2],
		[7782,88,24,0,0,20,19,48,0,37,7,57,8,2],
		[7783,88,24,0,0,20,17,31,0,66,51,14,7,4],
		[7784,88,24,0,0,20,20,15,0,39,24,12,7,2],
		[7785,88,24,0,0,20,33,18,1,80,57,54,7,4],
		[7786,88,24,0,0,20,19,56,0,46,50,15,8,1],
		[7787,76,9,2,0,20,23,53,1,42,25,22,7,2],
		[7788,88,24,0,0,20,23,1,1,9,39,17,7,4],
		[7789,87,24,0,25,20,22,3,0,24,26,46,7,1],
		[7790,60,0,0,0,20,25,39,1,56,44,6,3,1],
		[7791,88,24,0,0,20,20,30,0,53,35,46,7,5],
		[7792,33,24,0,71,20,19,37,0,62,15,27,7,1],
		[7793,88,24,0,0,20,22,52,0,14,33,5,7,3],
		[7794,88,24,0,0,20,23,11,0,5,20,35,6,4],
		[7795,88,24,0,0,20,22,3,0,41,7,53,7,4],
		[7796,30,2,0,37,20,22,14,0,40,15,24,3,3],
		[7797,88,24,0,0,20,22,37,0,31,15,54,7,5],
		[7798,88,24,0,0,20,22,5,0,45,47,42,7,5],
		[7799,88,24,0,0,20,25,48,1,40,47,47,7,5],
		[7800,88,24,0,0,20,22,45,0,41,1,34,7,5],
		[7801,88,24,0,0,20,25,27,1,28,39,48,7,4],
		[7802,88,24,0,0,20,22,56,0,42,59,0,7,5],
		[7803,88,24,0,0,20,24,38,0,1,4,7,7,1],
		[7804,88,24,0,0,20,20,6,0,68,52,49,7,7],
		[7805,88,24,0,0,20,21,11,0,63,58,49,7,5],
		[7806,30,24,0,39,20,23,52,0,32,11,24,5,5],
		[7807,88,24,0,0,20,23,44,0,37,28,35,7,1],
		[7808,88,24,0,0,20,26,53,1,37,24,11,7,5],
		[7809,88,24,0,0,20,25,43,1,2,48,1,7,5],
		[7810,88,24,0,0,20,25,44,0,10,3,23,7,5],
		[7811,88,24,0,0,20,25,41,0,21,24,35,7,4],
		[7812,88,24,0,0,20,38,19,1,81,17,20,7,5],
		[7813,88,24,0,0,20,26,1,0,19,51,54,7,5],
		[7814,11,15,0,10,20,27,19,1,18,12,42,6,1],
		[7815,88,24,0,0,20,24,32,0,53,33,7,8,1],
		[7816,88,24,0,0,20,26,23,0,17,18,56,7,5],
		[7817,88,24,0,0,20,28,47,1,35,35,45,7,1],
		[7818,88,24,0,0,20,25,5,0,59,36,0,7,2],
		[7819,88,24,0,0,20,28,44,1,15,44,30,7,5],
		[7820,88,24,0,0,20,28,8,0,8,26,15,7,4],
		[7821,3,24,0,68,20,28,25,1,3,21,28,7,1],
		[7822,11,16,0,11,20,28,52,1,17,48,49,6,3],
		[7823,88,24,0,0,20,27,8,0,34,19,44,7,3],
		[7824,88,24,0,0,20,28,17,0,2,56,13,7,4],
		[7825,88,24,0,0,20,29,31,1,22,23,30,7,7],
		[7826,30,24,0,40,20,27,34,0,38,26,25,7,2],
		[7827,88,24,0,0,20,26,24,0,56,38,20,7,1],
		[7828,30,24,0,43,20,27,2,0,49,23,0,7,3],
		[7829,11,14,0,12,20,29,53,1,18,35,12,8,2],
		[7830,11,14,0,12,20,29,54,1,18,35,0,7,2],
		[7831,3,24,0,69,20,29,39,1,2,53,8,6,5],
		[7832,88,24,0,0,20,30,57,1,29,6,45,7,2],
		[7833,88,24,0,0,20,29,21,0,20,5,16,8,2],
		[7834,30,24,0,41,20,29,24,0,30,22,7,5,3],
		[7835,30,24,0,42,20,29,20,0,36,27,17,7,2],
		[7836,31,24,0,1,20,30,18,0,10,53,45,7,2],
		[7837,88,24,0,0,20,31,4,1,15,3,23,7,4],
		[7838,88,24,0,0,20,35,52,1,69,36,40,7,5],
		[7839,88,24,0,0,20,30,58,0,20,36,21,7,2],
		[7840,88,24,0,0,20,31,13,0,11,15,38,8,1],
		[7841,88,24,0,0,20,29,60,0,45,55,43,7,5],
		[7842,88,24,0,0,20,32,52,1,24,56,38,7,2],
		[7843,88,24,0,0,20,29,27,0,56,4,5,7,1],
		[7844,30,23,1,45,20,30,4,0,48,57,6,6,1],
		[7845,88,24,0,0,20,32,24,1,9,51,12,7,4],
		[7846,53,12,0,0,20,33,55,1,44,30,58,6,5],
		[7847,30,24,0,44,20,30,59,0,36,56,9,7,3],
		[7848,60,20,1,0,20,35,35,1,60,34,54,6,3],
		[7849,88,24,0,0,20,31,58,0,25,48,16,7,2],
		[7850,15,7,0,2,20,29,35,0,62,59,39,5,2],
		[7851,30,23,2,46,20,31,19,0,49,13,13,6,7],
		[7852,31,4,0,2,20,33,13,0,11,18,12,5,1],
		[7853,88,24,0,0,20,34,56,1,38,5,23,7,2],
		[7854,88,24,0,0,20,31,21,0,52,18,35,7,5],
		[7855,88,24,0,0,20,34,12,1,13,43,16,7,3],
		[7856,88,24,0,0,20,34,47,1,30,28,25,7,1],
		[7857,88,24,0,0,20,33,54,0,10,3,35,8,2],
		[7858,31,6,0,3,20,33,57,0,13,1,38,6,2],
		[7859,60,16,0,0,20,37,35,1,61,31,48,6,3],
		[7860,88,24,0,0,20,31,47,0,56,46,48,7,5],
		[7861,88,24,0,0,20,32,52,0,43,11,30,8,1],
		[7862,88,24,0,0,20,34,10,0,20,59,7,7,1],
		[7863,57,11,1,0,20,42,3,1,76,10,50,7,3],
		[7864,57,11,2,0,20,41,44,1,75,21,2,8,4],
		[7865,88,24,0,0,20,35,32,1,16,31,33,7,2],
		[7866,30,24,0,47,20,33,54,0,35,15,3,6,5],
		[7867,88,24,0,0,20,33,48,0,41,46,20,7,5],
		[7868,88,24,0,0,20,30,1,0,72,31,54,7,5],
		[7869,43,0,0,0,20,37,34,1,47,17,29,4,5],
		[7870,88,24,0,0,20,33,55,0,46,41,38,7,1],
		[7871,31,5,0,4,20,35,19,0,14,40,27,6,2],
		[7872,88,24,0,0,20,39,51,1,62,54,28,7,5],
		[7873,3,24,0,70,20,36,44,1,2,33,0,6,5],
		[7874,87,24,0,26,20,36,8,0,25,52,57,7,2],
		[7875,60,20,2,0,20,40,3,1,60,32,56,6,3],
		[7876,88,24,0,0,20,34,50,0,51,51,15,7,2],
		[7877,88,24,0,0,20,37,52,1,25,6,32,7,3],
		[7878,88,24,0,0,20,37,18,0,0,5,49,7,1],
		[7879,33,24,0,73,20,31,30,0,74,57,17,6,2],
		[7880,87,24,0,27,20,37,5,0,26,27,43,7,1],
		[7881,60,19,0,0,20,41,57,1,66,45,39,6,1],
		[7882,31,1,0,6,20,37,33,0,14,35,43,5,3],
		[7883,31,8,0,5,20,37,49,0,11,22,40,6,2],
		[7884,3,24,0,71,20,38,20,1,1,6,19,5,4],
		[7885,30,24,0,48,20,37,32,0,31,34,21,7,1],
		[7886,88,24,0,0,20,37,55,0,18,16,9,7,7],
		[7887,88,24,0,0,20,37,33,0,31,31,19,7,3],
		[7888,88,24,0,0,20,37,24,0,38,19,43,7,5],
		[7889,11,18,0,14,20,39,16,1,14,57,17,6,1],
		[7890,88,24,0,0,20,39,13,1,2,24,46,7,1],
		[7891,87,24,0,29,20,38,31,0,21,12,4,6,2],
		[7892,31,7,0,8,20,38,44,0,13,18,54,7,5],
		[7893,88,24,0,0,20,40,20,1,33,25,55,6,5],
		[7894,87,24,0,28,20,38,32,0,24,6,58,6,1],
		[7895,88,24,0,0,20,38,35,0,23,40,50,7,5],
		[7896,31,9,0,7,20,39,8,0,10,5,10,6,4],
		[7897,4,24,0,1,20,39,25,0,0,29,11,6,5],
		[7898,88,24,0,0,20,40,12,1,23,46,26,7,4],
		[7899,88,24,0,0,20,39,5,0,15,50,17,7,1],
		[7900,11,19,0,15,20,40,3,1,18,8,19,6,7],
		[7901,33,24,0,75,20,28,15,0,81,25,22,6,4],
		[7902,88,24,0,0,20,40,36,1,26,38,42,8,3],
		[7903,88,24,0,0,20,39,11,0,21,49,2,7,2],
		[7904,88,24,0,0,20,38,60,0,30,20,4,7,5],
		[7905,88,24,0,0,20,40,33,1,16,7,27,7,4],
		[7906,31,0,0,9,20,39,38,0,15,54,43,5,1],
		[7907,88,24,0,0,20,39,52,0,11,14,59,7,3],
		[7908,33,24,0,74,20,29,28,0,81,5,29,7,5],
		[7909,88,24,0,0,20,41,24,1,31,35,54,7,7],
		[7910,88,24,0,0,20,41,24,1,26,0,0,7,5],
		[7911,88,24,0,0,20,39,33,0,40,34,46,7,1],
		[7912,88,24,0,0,20,39,23,0,45,40,1,8,1],
		[7913,60,1,0,0,20,44,58,1,66,12,11,4,2],
		[7914,88,24,0,0,20,40,45,0,19,56,7,7,4],
		[7915,88,24,0,0,20,42,53,1,39,33,31,7,5],
		[7916,88,24,0,0,20,39,0,0,56,0,18,7,3],
		[7917,88,24,0,0,20,40,36,0,29,48,19,7,2],
		[7918,31,24,0,10,20,41,16,0,14,34,59,7,5],
		[7919,88,24,0,0,20,40,3,0,43,27,31,7,5],
		[7920,43,6,0,0,20,44,2,1,51,55,16,6,2],
		[7921,30,24,0,49,20,41,3,0,32,18,26,7,4],
		[7922,88,24,0,0,20,41,0,0,39,4,56,8,1],
		[7923,88,24,0,0,20,41,58,0,17,31,17,7,4],
		[7924,30,0,0,50,20,41,26,0,45,16,49,2,2],
		[7925,88,24,0,0,20,40,18,0,60,30,19,7,3],
		[7926,88,24,0,0,20,41,57,0,41,43,1,7,1],
		[7927,88,24,0,0,20,42,22,0,35,27,22,8,1],
		[7928,31,3,0,11,20,43,28,0,15,4,28,5,2],
		[7929,30,24,0,51,20,42,13,0,50,20,24,6,1],
		[7930,88,24,0,0,20,29,3,0,83,37,32,7,2],
		[7931,88,24,0,0,20,45,13,1,27,14,50,8,4],
		[7932,88,24,0,0,20,43,24,0,35,35,16,7,3],
		[7933,88,24,0,0,20,46,20,1,39,11,57,7,1],
		[7934,60,17,0,0,20,49,18,1,68,46,35,6,5],
		[7935,88,24,0,0,20,46,19,1,36,7,13,7,3],
		[7936,11,22,0,16,20,46,6,1,25,16,15,5,3],
		[7937,11,24,0,17,20,46,10,1,21,30,51,7,2],
		[7938,88,24,0,0,20,42,40,0,60,36,5,7,2],
		[7939,87,24,0,30,20,44,53,0,25,16,14,6,5],
		[7940,88,24,0,0,20,43,14,0,57,6,51,7,1],
		[7941,88,24,0,0,20,45,28,0,18,5,25,7,7],
		[7942,30,24,0,52,20,45,40,0,30,43,11,5,4],
		[7943,53,8,0,0,20,48,29,1,43,59,19,6,3],
		[7944,88,24,0,0,20,44,22,0,56,29,17,7,7],
		[7945,15,24,0,4,20,43,11,0,66,39,27,7,2],
		[7946,88,24,0,0,20,47,4,1,2,29,12,7,5],
		[7947,31,2,1,12,20,46,39,0,16,7,28,6,3],
		[7948,31,2,2,12,20,46,40,0,16,7,27,5,5],
		[7949,30,4,0,53,20,46,13,0,33,58,13,3,5],
		[7950,4,4,0,2,20,47,41,1,9,29,45,5,2],
		[7951,4,24,0,3,20,47,44,1,5,1,40,5,7],
		[7952,43,5,0,0,20,49,29,1,46,13,37,6,5],
		[7953,31,24,0,13,20,47,48,0,6,0,30,7,2],
		[7954,88,24,0,0,20,47,48,0,3,18,24,7,2],
		[7955,88,24,0,0,20,45,21,0,57,34,47,6,3],
		[7956,88,24,0,0,20,47,11,0,34,22,27,6,5],
		[7957,15,6,0,3,20,45,17,0,61,50,20,4,5],
		[7958,88,24,0,0,20,46,39,0,46,31,54,7,2],
		[7959,88,24,0,0,20,51,38,1,62,25,45,7,2],
		[7960,88,24,0,0,20,51,39,1,62,25,45,8,2],
		[7961,88,24,0,0,20,49,18,1,25,46,53,7,1],
		[7962,88,24,0,0,20,46,21,0,52,59,43,7,5],
		[7963,30,10,0,54,20,47,25,0,36,29,27,6,1],
		[7964,88,24,0,0,20,49,21,1,18,2,9,7,5],
		[7965,53,0,0,0,20,49,58,1,33,46,47,6,4],
		[7966,88,24,0,0,20,47,21,0,45,34,47,7,5],
		[7967,88,24,0,0,20,44,33,0,69,45,7,7,4],
		[7968,43,8,0,0,20,51,30,1,51,36,30,6,5],
		[7969,88,24,0,0,20,47,49,0,47,49,55,7,5],
		[7970,88,24,0,0,20,50,47,1,32,3,16,7,5],
		[7971,88,24,0,0,20,51,1,1,37,54,48,7,5],
		[7972,88,24,0,0,20,47,53,0,52,24,26,7,4],
		[7973,31,24,0,15,20,49,38,0,12,32,43,7,3],
		[7974,31,24,0,14,20,49,48,0,7,51,51,7,2],
		[7975,88,24,0,0,20,49,59,0,5,32,41,7,5],
		[7976,88,24,0,0,20,50,42,1,12,32,42,7,5],
		[7977,30,24,0,55,20,48,56,0,46,6,51,6,1],
		[7978,88,24,0,0,20,48,43,0,51,54,38,7,1],
		[7979,53,1,0,0,20,51,59,1,33,10,38,7,2],
		[7980,11,23,0,18,20,51,49,1,26,55,9,5,7],
		[7981,88,24,0,0,20,50,37,0,18,3,5,8,2],
		[7982,4,24,0,4,20,51,26,1,5,37,35,7,3],
		[7983,88,24,0,0,20,49,55,0,46,39,40,7,1],
		[7984,30,24,0,56,20,50,5,0,44,3,34,6,2],
		[7985,4,24,0,5,20,52,9,1,5,30,25,7,1],
		[7986,43,1,0,0,20,54,49,1,58,27,15,5,5],
		[7987,88,24,0,0,20,53,40,1,39,48,36,6,5],
		[7988,88,24,0,0,20,51,28,0,28,15,2,7,3],
		[7989,88,24,0,0,20,53,1,1,23,46,59,7,5],
		[7990,4,11,0,6,20,52,39,1,8,59,0,6,2],
		[7991,88,24,0,0,20,53,25,1,30,43,7,7,5],
		[7992,88,24,0,0,20,54,35,1,50,43,40,7,1],
		[7993,88,24,0,0,20,49,17,0,64,2,32,7,1],
		[7994,88,24,0,0,20,53,6,1,11,34,25,7,4],
		[7995,87,24,0,31,20,52,8,0,27,5,49,6,4],
		[7996,88,24,0,0,20,52,0,0,32,50,57,7,1],
		[7997,88,24,0,0,20,54,7,1,27,55,32,7,7],
		[7998,88,24,0,0,20,53,58,1,6,53,23,7,3],
		[7999,88,24,0,0,20,53,7,0,29,38,58,7,5],
		[8000,11,24,0,19,20,54,48,1,17,55,23,7,5],
		[8001,30,24,0,57,20,53,15,0,44,23,14,6,1],
		[8002,33,24,0,76,20,42,35,0,82,31,52,7,2],
		[8003,88,24,0,0,20,53,19,0,45,10,55,6,5],
		[8004,88,24,0,0,20,53,26,0,42,24,37,8,2],
		[8005,88,24,0,0,20,53,54,0,33,26,16,6,5],
		[8006,88,24,0,0,20,55,8,1,1,22,24,8,2],
		[8007,88,24,0,0,20,54,22,0,28,31,19,8,1],
		[8008,87,24,0,32,20,54,34,0,28,3,27,6,5],
		[8009,88,24,0,0,20,54,22,0,40,42,11,8,1],
		[8010,88,24,0,0,20,55,41,0,4,31,58,7,4],
		[8011,31,24,0,17,20,55,37,0,13,43,17,6,5],
		[8012,31,24,0,16,20,55,39,0,12,34,7,7,2],
		[8013,88,24,0,0,20,56,47,1,26,17,47,7,3],
		[8014,88,24,0,0,20,56,18,1,3,33,41,8,1],
		[8015,4,24,0,7,20,56,54,1,9,41,51,7,5],
		[8016,88,24,0,0,20,47,33,0,80,33,8,6,5],
		[8017,88,24,0,0,20,57,11,0,0,27,49,7,5],
		[8018,88,24,0,0,20,57,41,1,16,1,54,7,2],
		[8019,88,24,0,0,21,1,28,1,68,12,35,7,2],
		[8020,88,24,0,0,20,55,50,0,47,25,4,7,1],
		[8021,57,0,0,0,21,4,43,1,77,1,26,6,2],
		[8022,88,24,0,0,20,56,13,0,51,4,30,8,1],
		[8023,88,24,0,0,20,56,35,0,44,55,30,7,0],
		[8024,88,24,0,0,20,58,42,1,14,28,58,7,3],
		[8025,88,24,0,0,20,56,26,0,50,43,43,7,3],
		[8026,88,24,0,0,20,56,26,0,49,11,45,7,4],
		[8027,88,24,0,0,21,0,22,1,51,15,55,7,3],
		[8028,30,12,0,58,20,57,10,0,41,10,2,5,2],
		[8029,88,24,0,0,20,56,17,0,56,53,15,7,1],
		[8030,31,24,0,18,20,58,26,0,10,50,21,6,4],
		[8031,88,24,0,0,20,59,60,1,36,7,47,7,3],
		[8032,87,24,0,33,20,58,16,0,22,19,33,6,5],
		[8033,11,24,0,20,20,59,36,1,19,2,7,7,1],
		[8034,34,4,0,1,20,59,4,0,4,17,37,6,3],
		[8035,88,24,0,0,20,58,20,0,44,28,18,7,5],
		[8036,88,24,0,0,20,58,31,0,41,56,25,7,1],
		[8037,88,24,0,0,20,59,51,0,16,49,27,8,3],
		[8038,88,24,0,0,21,0,4,0,7,30,59,7,3],
		[8039,53,2,0,0,21,1,18,1,32,15,28,6,4],
		[8040,88,24,0,0,20,58,30,0,50,27,44,7,1],
		[8041,4,24,0,11,21,0,34,1,4,43,49,7,4],
		[8042,88,24,0,0,21,2,13,1,43,0,7,8,4],
		[8043,88,24,0,0,20,54,44,0,75,55,32,7,4],
		[8044,88,24,0,0,21,0,28,0,19,19,46,7,7],
		[8045,88,24,0,0,21,1,45,1,26,52,52,7,2],
		[8046,88,24,0,0,21,2,27,1,38,31,50,7,5],
		[8047,30,24,0,59,20,59,50,0,47,31,16,6,1],
		[8048,53,5,0,0,21,2,58,1,38,37,54,6,3],
		[8049,88,24,0,0,20,59,25,0,59,26,19,7,5],
		[8050,88,24,0,0,21,3,10,1,27,43,55,7,5],
		[8051,88,24,0,0,21,1,13,0,36,1,34,7,4],
		[8052,88,24,0,0,21,8,48,1,76,12,45,8,5],
		[8053,30,24,0,60,21,1,11,0,46,9,21,6,1],
		[8054,88,24,0,0,21,2,60,1,0,55,29,8,1],
		[8055,43,11,0,0,21,5,14,1,54,43,38,6,5],
		[8056,88,24,0,0,21,3,3,0,1,31,55,7,3],
		[8057,88,24,0,0,21,3,2,0,14,43,48,7,7],
		[8058,4,24,0,12,21,4,5,1,5,49,24,8,2],
		[8059,4,24,0,12,21,4,5,1,5,49,23,7,4],
		[8060,11,6,0,22,21,4,24,1,19,51,18,6,2],
		[8061,88,24,0,0,21,9,22,1,73,10,23,7,3],
		[8062,88,24,0,0,21,2,24,0,44,47,28,7,7],
		[8063,88,24,0,0,21,3,5,0,38,39,27,7,4],
		[8064,88,24,0,0,21,2,49,0,45,50,56,7,1],
		[8065,88,24,0,0,21,2,9,0,56,40,11,7,1],
		[8066,34,24,0,3,21,4,35,0,5,30,10,7,5],
		[8067,88,24,0,0,21,4,42,0,2,56,31,7,5],
		[8068,88,24,0,0,21,4,45,0,2,16,11,7,4],
		[8069,53,6,0,0,21,6,26,1,41,23,10,7,5],
		[8070,53,3,0,0,21,6,1,1,30,7,30,7,5],
		[8071,88,24,0,0,21,3,52,0,41,37,41,7,3],
		[8072,88,24,0,0,21,3,26,0,50,21,7,7,5],
		[8073,88,24,0,0,21,8,33,1,63,55,44,7,5],
		[8074,88,24,0,0,21,3,43,0,46,51,43,7,3],
		[8075,11,7,0,23,21,5,57,1,17,13,58,5,2],
		[8076,88,24,0,0,21,6,25,1,32,20,30,6,5],
		[8077,34,24,0,4,21,5,27,0,5,57,30,7,3],
		[8078,88,24,0,0,21,3,48,0,53,17,10,7,5],
		[8079,30,13,0,62,21,4,56,0,43,55,40,5,5],
		[8080,11,24,0,24,21,7,8,1,25,0,21,6,7],
		[8081,88,24,0,0,21,11,21,1,72,32,39,7,5],
		[8082,88,24,0,0,21,6,24,0,26,55,28,7,5],
		[8083,88,24,0,0,21,7,45,1,17,27,19,7,2],
		[8084,88,24,0,0,21,6,30,0,31,11,5,7,3],
		[8085,30,24,0,61,21,6,55,0,38,44,45,6,5],
		[8086,30,24,0,61,21,6,55,0,38,44,36,7,5],
		[8087,11,21,0,25,21,8,34,1,21,11,37,6,2],
		[8088,88,24,0,0,21,7,34,0,15,39,31,7,5],
		[8089,30,24,0,63,21,6,36,0,47,38,54,6,5],
		[8090,88,24,0,0,21,8,28,0,6,59,22,7,5],
		[8091,11,24,0,27,21,9,33,1,20,33,23,7,3],
		[8092,60,14,0,0,21,13,21,1,70,7,35,6,7],
		[8093,4,12,0,13,21,9,36,1,11,22,18,6,4],
		[8094,88,24,0,0,21,8,39,0,30,12,21,7,1],
		[8095,88,24,0,0,21,9,58,0,2,56,36,7,3],
		[8096,88,24,0,0,21,10,47,1,9,21,14,7,5],
		[8097,34,2,0,5,21,10,21,0,10,7,54,6,3],
		[8098,34,24,0,6,21,10,31,0,10,2,56,7,2],
		[8099,88,24,0,0,21,6,23,0,71,25,55,7,3],
		[8100,88,24,0,0,21,12,14,1,40,16,10,7,3],
		[8101,88,24,0,0,21,10,32,0,22,27,17,8,2],
		[8102,88,24,0,0,21,11,41,1,14,28,20,7,3],
		[8103,88,24,0,0,21,9,59,0,45,30,9,8,1],
		[8104,88,24,0,0,21,13,3,1,39,25,31,6,3],
		[8105,88,24,0,0,21,11,4,0,36,17,57,8,1],
		[8106,88,24,0,0,21,10,16,0,53,33,48,7,1],
		[8107,88,24,0,0,21,10,31,0,47,41,31,7,1],
		[8108,88,24,0,0,21,13,19,1,36,25,26,7,5],
		[8109,88,24,0,0,21,9,29,0,63,17,44,8,1],
		[8110,88,24,0,0,21,13,17,1,27,37,10,6,5],
		[8111,88,24,0,0,21,18,16,1,75,20,48,8,2],
		[8112,88,24,0,0,21,5,29,0,78,7,35,7,1],
		[8113,88,24,0,0,21,9,32,0,68,29,25,8,7],
		[8114,88,24,0,0,21,15,46,1,53,15,47,7,2],
		[8115,30,5,0,64,21,12,56,0,30,13,37,4,4],
		[8116,88,24,0,0,21,13,29,0,15,58,57,7,2],
		[8117,88,24,0,0,21,15,15,1,40,30,23,7,5],
		[8118,88,24,0,0,21,14,17,1,10,36,19,8,1],
		[8119,88,24,0,0,21,11,48,0,59,59,11,7,1],
		[8120,88,24,0,0,21,13,26,0,36,38,1,7,3],
		[8121,88,24,0,0,21,14,37,0,0,5,32,7,7],
		[8122,88,24,0,0,21,15,7,1,17,20,42,7,4],
		[8123,34,3,0,7,21,14,29,0,10,0,25,5,3],
		[8124,88,24,0,0,21,15,47,1,36,12,39,7,5],
		[8125,88,24,0,0,21,18,0,1,64,40,54,7,1],
		[8126,88,24,0,0,21,14,10,0,29,54,4,7,4],
		[8127,11,20,0,28,21,15,38,1,20,39,6,6,4],
		[8128,11,24,0,29,21,15,45,1,15,10,17,6,7],
		[8129,88,24,0,0,21,32,4,1,84,48,36,7,5],
		[8130,30,18,0,65,21,14,48,0,38,2,44,5,3],
		[8131,34,0,0,8,21,15,49,0,5,14,52,5,4],
		[8132,88,24,0,0,21,16,40,1,1,36,28,7,5],
		[8133,88,24,0,0,21,13,43,0,64,24,14,7,4],
		[8134,88,24,0,0,21,17,14,1,13,16,44,7,2],
		[8135,53,4,0,0,21,17,56,1,32,10,21,6,2],
		[8136,88,24,0,0,21,15,37,0,47,58,25,7,1],
		[8137,11,24,0,30,21,17,57,1,17,59,7,6,1],
		[8138,88,24,0,0,21,16,30,0,42,15,5,7,5],
		[8139,11,24,0,31,21,18,16,1,17,27,44,8,3],
		[8140,43,7,0,0,21,19,52,1,53,26,59,5,2],
		[8141,4,24,0,15,21,18,11,1,4,31,10,7,1],
		[8142,88,24,0,0,21,18,54,1,28,45,56,7,4],
		[8143,30,17,0,67,21,17,25,0,39,23,41,5,1],
		[8144,88,24,0,0,21,17,23,0,42,41,0,7,1],
		[8145,88,24,0,0,21,20,10,1,45,1,20,7,6],
		[8146,30,19,0,66,21,17,55,0,34,53,49,5,1],
		[8147,88,24,0,0,21,17,2,0,53,59,51,7,2],
		[8148,88,24,0,0,21,19,46,1,26,21,11,8,4],
		[8149,88,24,0,0,21,18,52,0,11,12,12,7,5],
		[8150,88,24,0,0,21,17,14,0,55,47,53,7,5],
		[8151,53,7,1,0,21,20,46,1,40,48,35,6,2],
		[8152,88,24,0,0,21,21,16,1,49,56,16,7,5],
		[8153,88,24,0,0,21,17,19,0,58,36,42,7,1],
		[8154,30,24,0,68,21,18,27,0,43,56,45,6,0],
		[8155,88,24,0,0,21,18,55,0,41,2,27,7,2],
		[8156,88,24,0,0,21,24,17,1,69,44,3,7,6],
		[8157,88,24,0,0,21,19,22,0,38,14,15,7,3],
		[8158,88,24,0,0,21,20,14,0,22,1,35,7,1],
		[8159,88,24,0,0,21,25,18,1,71,47,58,7,5],
		[8160,4,24,0,16,21,21,4,1,4,33,36,7,4],
		[8161,88,24,0,0,21,19,29,0,49,30,37,7,1],
		[8162,15,0,0,5,21,18,35,0,62,35,8,3,2],
		[8163,34,24,0,9,21,21,5,0,7,21,16,7,7],
		[8164,88,24,0,0,21,19,16,0,58,37,25,7,7],
		[8165,88,24,0,0,21,21,4,0,23,51,21,7,5],
		[8166,88,24,0,0,21,20,50,0,32,27,10,7,4],
		[8167,11,8,0,32,21,22,15,1,16,50,4,5,4],
		[8168,88,24,0,0,21,15,42,0,77,0,44,7,5],
		[8169,88,24,0,0,21,21,22,0,32,36,46,7,2],
		[8170,88,24,0,0,21,21,1,0,40,20,44,7,3],
		[8171,15,24,0,6,21,19,22,0,64,52,19,6,1],
		[8172,88,24,0,0,21,23,1,1,22,40,8,7,7],
		[8173,61,24,0,1,21,22,5,0,19,48,16,5,5],
		[8174,88,24,0,0,21,13,22,0,81,13,51,7,2],
		[8175,4,24,0,17,21,22,56,1,9,19,10,7,7],
		[8176,88,24,0,0,21,33,54,1,82,40,59,7,1],
		[8177,88,24,0,0,21,24,21,1,46,36,54,7,2],
		[8178,34,1,0,10,21,22,54,0,6,48,40,6,2],
		[8179,88,24,0,0,21,20,34,0,60,45,25,7,4],
		[8180,53,7,2,0,21,24,25,1,41,0,24,7,2],
		[8181,60,2,0,0,21,26,27,1,65,21,58,5,3],
		[8182,88,24,0,0,21,22,42,0,30,18,35,7,5],
		[8183,11,24,0,33,21,24,10,1,20,51,7,6,5],
		[8184,88,24,0,0,21,24,8,1,22,44,49,7,5],
		[8185,88,24,0,0,21,22,0,0,49,23,20,7,5],
		[8186,88,24,0,0,21,22,47,0,38,38,3,8,2],
		[8187,4,24,0,18,21,24,12,1,12,52,41,6,3],
		[8188,43,2,0,0,21,26,15,1,54,39,38,7,3],
		[8189,88,24,0,0,21,23,23,0,37,24,24,8,3],
		[8190,88,24,0,0,21,23,59,0,24,16,27,7,3],
		[8191,88,24,0,0,21,24,25,0,10,10,27,7,3],
		[8192,4,24,0,20,21,24,52,1,3,23,54,7,3],
		[8193,88,24,0,0,21,23,48,0,37,21,5,7,5],
		[8194,88,24,0,0,21,24,7,0,25,18,44,7,2],
		[8195,4,24,0,19,21,25,13,1,9,44,55,7,3],
		[8196,88,24,0,0,21,28,45,1,69,30,19,6,7],
		[8197,88,24,0,0,21,24,23,0,24,31,44,7,5],
		[8198,88,24,0,0,21,24,34,0,26,10,28,7,2],
		[8199,4,24,0,21,21,25,17,1,3,33,24,6,5],
		[8200,88,24,0,0,21,26,23,1,37,49,46,7,5],
		[8201,88,24,0,0,21,33,21,1,80,2,21,7,2],
		[8202,88,24,0,0,21,27,2,1,42,32,52,7,2],
		[8203,88,24,0,0,21,25,52,0,0,32,4,7,2],
		[8204,11,5,0,34,21,26,40,1,22,24,41,5,4],
		[8205,88,24,0,0,21,26,28,0,1,6,12,7,3],
		[8206,88,24,0,0,21,24,56,0,49,19,24,8,1],
		[8207,11,24,0,35,21,27,15,1,21,11,46,7,5],
		[8208,88,24,0,0,21,25,20,0,46,42,52,7,3],
		[8209,30,24,0,69,21,25,47,0,36,40,3,7,1],
		[8210,88,24,0,0,21,26,27,0,19,22,32,7,2],
		[8211,88,24,0,0,21,29,0,1,53,42,21,7,5],
		[8212,88,24,0,0,21,28,14,1,11,34,6,8,3],
		[8213,11,24,0,36,21,28,43,1,21,48,26,6,4],
		[8214,65,24,0,5,21,29,4,1,31,14,19,8,2],
		[8215,30,24,0,70,21,27,21,0,37,7,0,6,1],
		[8216,88,24,0,0,21,26,52,0,48,50,6,6,2],
		[8217,87,24,0,35,21,27,40,0,27,36,31,6,2],
		[8218,88,24,0,0,21,26,45,0,52,53,55,7,1],
		[8219,88,24,0,0,21,28,25,0,8,11,44,7,7],
		[8220,88,24,0,0,21,28,8,0,32,13,31,7,3],
		[8221,88,24,0,0,21,28,60,0,17,54,21,7,5],
		[8222,88,24,0,0,21,29,60,1,19,8,52,8,3],
		[8223,88,24,0,0,21,28,60,0,22,10,46,7,7],
		[8224,88,24,0,0,21,27,25,0,59,45,0,7,7],
		[8225,61,24,0,2,21,29,57,0,23,38,20,6,7],
		[8226,88,24,0,0,21,28,53,0,55,25,7,7,1],
		[8227,15,24,0,7,21,27,46,0,66,48,33,6,1],
		[8228,30,24,0,71,21,29,27,0,46,32,26,6,5],
		[8229,38,13,0,0,21,32,6,1,41,10,45,6,5],
		[8230,65,24,0,6,21,32,15,1,33,56,41,7,2],
		[8231,88,24,0,0,21,31,10,0,12,8,15,7,1],
		[8232,4,1,0,22,21,31,34,1,5,34,16,4,4],
		[8233,88,24,0,0,21,33,18,1,52,44,15,7,5],
		[8234,88,24,0,0,21,38,56,1,79,26,33,7,3],
		[8235,88,24,0,0,21,32,33,1,24,35,26,7,2],
		[8236,88,24,0,0,21,33,24,1,44,50,55,7,5],
		[8237,88,24,0,0,21,30,20,0,52,57,29,7,2],
		[8238,15,1,0,8,21,28,40,0,70,33,39,4,1],
		[8239,88,24,0,0,21,24,50,0,80,31,29,7,4],
		[8240,88,24,0,0,21,32,27,0,23,23,40,8,1],
		[8241,88,24,0,0,21,34,17,1,42,55,30,7,5],
		[8242,88,24,0,0,21,31,28,0,52,37,12,7,4],
		[8243,88,24,0,0,21,30,59,0,60,27,34,7,1],
		[8244,88,24,0,0,21,34,53,1,29,41,46,7,1],
		[8245,11,24,0,37,21,34,51,1,20,5,4,7,3],
		[8246,88,24,0,0,21,32,57,0,49,58,40,7,2],
		[8247,88,24,0,0,21,35,16,1,23,27,15,7,4],
		[8248,88,24,0,0,21,33,18,0,45,51,15,7,5],
		[8249,88,24,0,0,21,38,3,1,64,49,27,7,2],
		[8250,88,24,0,0,21,34,34,0,22,45,17,7,3],
		[8251,88,24,0,0,21,35,18,1,3,58,59,7,4],
		[8252,30,16,0,73,21,33,59,0,45,35,31,5,4],
		[8253,65,24,0,8,21,36,11,1,26,10,17,7,2],
		[8254,57,12,0,0,21,41,29,1,77,23,24,5,5],
		[8255,30,24,0,72,21,34,47,0,38,32,3,6,5],
		[8256,65,24,0,7,21,36,49,1,33,2,53,7,2],
		[8257,88,24,0,0,21,35,19,0,28,11,50,7,3],
		[8258,88,24,0,0,21,35,27,0,24,27,8,7,2],
		[8259,88,24,0,0,21,34,28,0,51,41,54,7,1],
		[8260,11,4,0,39,21,37,5,1,19,27,58,6,1],
		[8261,88,24,0,0,21,36,14,0,30,3,20,7,4],
		[8262,88,24,0,0,21,36,2,0,45,22,29,7,7],
		[8263,88,24,0,0,21,37,34,1,0,23,25,7,2],
		[8264,4,13,0,23,21,37,45,1,7,51,15,6,2],
		[8265,61,24,0,3,21,37,44,0,6,37,6,7,2],
		[8266,30,24,0,74,21,36,57,0,40,24,49,6,2],
		[8267,61,24,0,5,21,37,45,0,19,19,7,6,3],
		[8268,88,24,0,0,21,39,6,1,33,40,45,7,4],
		[8269,88,24,0,0,21,39,60,1,52,21,33,7,3],
		[8270,61,24,0,4,21,38,32,0,5,46,18,7,2],
		[8271,88,24,0,0,21,40,34,1,55,44,15,7,5],
		[8272,88,24,0,0,21,37,28,0,44,41,48,7,2],
		[8273,88,24,0,0,21,39,28,1,10,34,37,7,5],
		[8274,88,24,0,0,21,38,45,0,25,29,56,7,4],
		[8275,88,24,0,0,21,37,39,0,54,2,32,7,5],
		[8276,88,24,0,0,21,39,1,0,20,15,55,7,3],
		[8277,4,24,0,25,21,39,33,0,2,14,37,6,5],
		[8278,11,2,0,40,21,40,6,1,16,39,44,5,3],
		[8279,15,24,0,9,21,37,55,0,62,4,55,6,1],
		[8280,57,10,0,0,21,50,54,1,82,43,9,6,4],
		[8281,88,24,0,0,21,38,58,0,57,29,21,7,0],
		[8282,88,24,0,0,21,41,46,1,25,6,7,7,5],
		[8283,11,24,0,42,21,41,33,1,14,2,51,6,4],
		[8284,30,24,0,75,21,40,11,0,43,16,26,6,7],
		[8285,11,24,0,41,21,42,1,1,23,15,46,6,4],
		[8286,88,24,0,0,21,45,29,1,71,0,32,7,1],
		[8287,4,24,0,26,21,42,10,0,1,17,7,7,5],
		[8288,11,9,0,43,21,42,40,1,18,51,59,6,4],
		[8289,61,24,0,7,21,42,16,0,5,40,48,6,7],
		[8290,88,24,0,0,21,40,43,0,54,52,20,7,5],
		[8291,30,24,0,76,21,41,34,0,40,48,19,7,2],
		[8292,88,24,0,0,21,42,33,0,10,49,29,7,1],
		[8293,88,24,0,0,21,43,14,1,19,37,15,7,2],
		[8294,88,24,0,0,22,45,29,1,88,49,6,8,3],
		[8295,11,24,0,44,21,43,4,1,14,23,59,7,3],
		[8297,88,24,0,0,21,42,1,0,35,30,37,7,6],
		[8298,88,24,0,0,21,42,8,0,45,45,57,7,7],
		[8299,88,24,0,0,21,44,30,1,38,33,9,7,4],
		[8300,30,24,0,77,21,42,23,0,41,4,38,7,2],
		[8301,30,15,1,80,21,42,6,0,51,11,23,6,1],
		[8302,11,24,0,45,21,44,1,1,14,44,58,7,3],
		[8303,88,24,0,0,21,45,19,1,49,29,55,7,5],
		[8304,88,24,0,0,21,42,39,0,49,36,1,7,4],
		[8305,65,8,0,9,21,44,57,1,33,1,33,5,2],
		[8306,88,24,0,0,21,43,6,0,41,9,18,6,7],
		[8307,30,24,0,79,21,43,26,0,38,17,2,7,2],
		[8308,61,4,0,8,21,44,11,0,9,52,30,3,5],
		[8309,30,11,1,78,21,44,9,0,28,44,34,6,3],
		[8310,30,11,2,78,21,44,8,0,28,44,35,7,4],
		[8311,11,24,0,46,21,45,0,1,9,4,57,6,4],
		[8312,88,24,0,0,21,42,45,0,59,16,16,7,5],
		[8313,61,24,0,9,21,44,31,0,17,21,0,5,4],
		[8314,88,24,0,0,21,44,31,0,14,46,19,7,4],
		[8315,61,9,0,10,21,44,39,0,25,38,42,5,3],
		[8316,15,11,0,0,21,43,30,0,58,46,48,5,7],
		[8317,15,24,0,11,21,41,55,0,71,18,41,6,5],
		[8318,11,24,0,47,21,46,16,1,9,16,33,7,7],
		[8319,11,10,0,48,21,46,32,1,11,21,57,7,2],
		[8320,88,24,0,0,21,45,45,0,35,51,26,7,4],
		[8321,61,24,0,12,21,46,4,0,22,56,56,6,5],
		[8322,11,3,0,49,21,47,2,1,16,7,38,4,2],
		[8323,88,24,0,0,21,48,16,1,47,18,13,7,4],
		[8324,88,24,0,0,21,43,4,0,72,19,13,6,5],
		[8325,88,24,0,0,21,46,24,0,25,33,48,7,5],
		[8326,65,7,0,10,21,47,44,1,30,53,54,6,2],
		[8327,88,24,0,0,21,44,53,0,62,27,38,7,0],
		[8328,61,24,0,11,21,47,14,0,2,41,10,7,2],
		[8329,88,24,0,0,21,46,17,0,43,3,39,8,4],
		[8330,88,24,0,0,21,47,5,0,17,11,39,7,3],
		[8331,88,24,0,0,21,50,0,1,64,42,45,7,5],
		[8332,88,24,0,0,21,47,38,1,5,55,2,7,2],
		[8333,43,14,0,0,21,50,47,1,69,37,46,7,5],
		[8334,15,12,0,10,21,45,27,0,61,7,15,5,2],
		[8335,30,15,2,81,21,46,48,0,49,18,34,5,1],
		[8336,88,24,0,0,21,48,8,0,36,34,50,7,5],
		[8337,88,24,0,0,21,49,41,1,12,43,23,7,2],
		[8338,88,24,0,0,21,48,29,0,38,38,55,7,1],
		[8339,15,24,0,12,21,47,25,0,60,41,34,7,7],
		[8340,88,24,0,0,21,50,13,1,16,50,41,7,5],
		[8341,88,24,0,0,21,49,27,0,20,27,45,7,1],
		[8342,88,24,0,0,21,47,1,0,70,9,3,7,2],
		[8343,61,24,0,14,21,49,51,0,30,10,27,6,2],
		[8344,61,24,0,13,21,50,9,0,17,17,8,6,3],
		[8345,88,24,0,0,21,49,40,0,41,8,56,7,2],
		[8346,88,24,0,0,21,51,42,1,18,37,23,7,3],
		[8347,88,24,0,0,21,49,19,0,61,16,22,7,7],
		[8348,88,24,0,0,21,51,34,0,19,49,36,7,1],
		[8349,88,24,0,0,21,51,5,0,39,32,12,7,1],
		[8350,88,24,0,0,21,52,18,0,21,16,23,8,7],
		[8351,11,11,0,51,21,53,18,1,13,33,6,6,3],
		[8352,88,24,0,0,21,55,12,1,61,53,11,7,3],
		[8353,38,2,0,0,21,53,56,1,37,21,54,4,1],
		[8354,61,24,0,15,21,52,30,0,28,47,36,7,3],
		[8355,88,24,0,0,21,53,36,1,10,18,42,8,1],
		[8356,61,24,0,16,21,53,4,0,25,55,30,6,1],
		[8357,88,24,0,0,21,52,1,0,55,47,49,7,1],
		[8358,88,24,0,0,21,53,37,0,19,40,6,7,2],
		[8359,88,24,0,0,21,53,58,0,6,51,52,7,4],
		[8360,88,24,0,0,21,54,10,1,4,16,34,7,5],
		[8361,88,24,0,0,21,51,37,0,65,45,10,7,2],
		[8362,43,15,0,0,21,56,14,1,57,53,58,7,2],
		[8363,88,24,0,0,21,54,36,1,3,18,4,7,3],
		[8364,88,24,0,0,21,54,17,0,19,43,6,7,5],
		[8365,88,24,0,0,21,55,56,1,30,36,23,7,4],
		[8366,88,24,0,0,21,56,23,1,37,15,13,6,2],
		[8367,88,24,0,0,21,57,2,1,37,44,49,7,3],
		[8368,43,3,0,0,21,57,55,1,54,59,33,5,3],
		[8369,43,9,1,0,21,58,30,1,59,0,44,7,3],
		[8370,88,24,0,0,22,1,52,1,77,39,45,7,2],
		[8371,15,24,0,13,21,54,53,0,56,36,41,7,1],
		[8372,88,24,0,0,21,56,24,0,21,14,23,7,5],
		[8373,61,24,0,17,21,56,56,0,12,4,35,7,2],
		[8374,88,24,0,0,21,55,21,0,61,32,31,7,4],
		[8375,88,24,0,0,21,55,31,0,65,19,15,7,1],
		[8376,88,24,0,0,21,58,13,1,5,25,29,7,3],
		[8377,88,24,0,0,21,57,2,0,48,40,7,7,1],
		[8378,88,24,0,0,21,58,44,1,21,10,58,7,7],
		[8379,88,24,0,0,21,59,18,1,38,23,43,7,5],
		[8380,88,24,0,0,22,3,4,1,76,7,7,7,3],
		[8381,88,24,0,0,22,0,24,1,55,52,58,7,1],
		[8382,88,24,0,0,21,58,55,1,4,22,23,7,5],
		[8383,88,24,0,0,21,56,39,0,63,37,32,6,7],
		[8384,88,24,0,0,21,57,11,0,66,9,22,7,1],
		[8385,61,24,0,18,22,0,8,0,6,43,3,7,1],
		[8386,65,6,0,12,22,0,50,1,28,27,13,6,1],
		[8387,43,4,0,0,22,3,22,1,56,47,10,6,5],
		[8388,88,24,0,0,21,58,53,0,62,41,54,7,7],
		[8389,88,24,0,0,21,59,23,0,57,39,30,8,2],
		[8390,4,24,0,28,22,1,5,0,0,36,18,7,5],
		[8391,88,24,0,0,22,0,27,0,33,0,22,7,3],
		[8392,61,24,0,20,22,1,5,0,13,7,11,7,3],
		[8393,61,24,0,19,22,1,9,0,8,15,26,7,5],
		[8394,88,24,0,0,22,2,12,1,17,54,13,7,4],
		[8395,88,24,0,0,21,57,51,0,74,59,48,7,5],
		[8396,4,24,0,29,22,2,27,1,16,57,51,7,2],
		[8397,88,24,0,0,22,2,1,0,10,58,26,7,1],
		[8398,88,24,0,0,22,3,17,1,29,54,15,8,3],
		[8399,88,24,0,0,22,0,39,0,62,29,17,8,1],
		[8400,15,24,0,16,21,59,15,0,73,10,48,6,3],
		[8401,4,24,0,30,22,3,16,1,6,31,21,7,5],
		[8402,4,14,0,31,22,3,19,1,2,9,19,6,1],
		[8403,88,24,0,0,22,1,51,0,52,52,56,7,1],
		[8404,61,24,0,21,22,3,19,0,11,23,11,7,1],
		[8405,65,24,0,13,22,4,24,1,29,55,0,7,5],
		[8406,15,24,0,14,22,2,5,0,58,0,2,7,0],
		[8407,88,24,0,0,22,2,57,0,44,39,0,7,2],
		[8408,88,24,0,0,22,4,37,1,26,49,21,7,1],
		[8409,43,9,2,0,22,5,51,1,59,38,10,7,5],
		[8410,4,24,0,32,22,4,47,1,0,54,24,6,2],
		[8411,38,10,0,0,22,6,7,1,39,32,36,5,5],
		[8412,88,24,0,0,22,4,34,0,32,56,31,7,4],
		[8413,61,12,0,22,22,5,41,0,5,3,31,6,5],
		[8414,4,0,0,34,22,5,47,1,0,19,11,4,4],
		[8415,88,24,0,0,22,5,11,0,26,40,26,7,5],
		[8416,15,24,0,18,22,3,53,0,63,7,11,6,7],
		[8417,15,13,0,17,22,3,47,0,64,37,40,5,2],
		[8418,4,8,0,33,22,6,26,1,13,52,11,5,1],
		[8419,61,24,0,23,22,5,35,0,28,57,50,7,1],
		[8420,88,24,0,0,22,10,43,1,75,52,50,8,5],
		[8421,88,24,0,0,22,5,16,0,46,44,41,7,7],
		[8422,88,24,0,0,22,5,51,0,45,6,44,7,2],
		[8423,88,24,0,0,21,58,13,0,82,52,11,8,3],
		[8424,88,24,0,0,22,6,2,0,45,0,52,6,5],
		[8425,38,0,0,0,22,8,14,1,46,57,40,3,1],
		[8426,15,24,0,20,22,5,1,0,62,47,8,6,5],
		[8427,88,24,0,0,22,5,51,0,48,13,54,7,1],
		[8428,15,24,0,19,22,5,9,0,62,16,48,6,0],
		[8429,88,24,0,0,22,6,12,0,45,14,55,7,2],
		[8430,61,8,0,24,22,7,1,0,25,20,42,5,3],
		[8431,65,11,0,14,22,8,23,1,32,59,19,6,2],
		[8432,88,24,0,0,22,11,55,1,76,6,58,7,5],
		[8433,65,19,0,0,22,8,26,1,34,2,38,6,7],
		[8434,88,24,0,0,22,6,14,0,56,20,35,7,2],
		[8435,88,24,0,0,22,7,29,0,19,28,32,7,3],
		[8436,88,24,0,0,22,7,30,0,18,0,2,7,7],
		[8437,88,24,0,0,22,8,43,1,33,7,32,7,2],
		[8438,61,24,0,25,22,7,50,0,21,42,10,7,1],
		[8439,4,24,0,35,22,8,59,1,18,31,11,7,1],
		[8440,88,24,0,0,22,9,58,1,48,6,26,7,5],
		[8441,88,24,0,0,22,8,17,0,25,32,37,7,3],
		[8442,88,24,0,0,22,7,10,0,58,50,27,7,4],
		[8443,88,24,0,0,22,7,26,0,53,18,26,7,2],
		[8444,88,24,0,0,22,9,56,1,34,0,53,6,2],
		[8445,88,24,0,0,22,8,17,0,49,47,47,7,5],
		[8446,88,24,0,0,22,10,0,1,28,17,33,7,2],
		[8447,65,18,0,15,22,10,9,1,32,32,54,6,3],
		[8448,88,24,0,0,22,8,41,0,45,44,31,7,4],
		[8449,61,15,1,27,22,9,14,0,33,10,20,7,4],
		[8450,61,7,0,26,22,10,12,0,6,11,52,5,2],
		[8451,88,24,0,0,22,10,21,1,3,53,39,7,2],
		[8452,4,24,0,38,22,10,38,1,11,33,54,6,1],
		[8453,88,24,0,0,22,10,34,1,4,16,2,7,5],
		[8454,61,15,2,29,22,9,59,0,33,10,42,5,3],
		[8455,88,24,0,0,22,10,19,0,19,37,1,7,4],
		[8456,88,24,0,0,22,10,22,0,14,37,48,7,5],
		[8457,88,24,0,0,22,11,2,1,21,13,57,7,3],
		[8458,88,24,0,0,22,10,37,0,11,37,28,7,7],
		[8459,61,24,0,28,22,10,30,0,20,58,41,7,2],
		[8460,88,24,0,0,22,10,52,0,30,33,11,7,2],
		[8461,88,24,0,0,22,11,51,0,16,2,26,7,5],
		[8462,4,24,0,39,22,12,26,1,14,11,38,7,3],
		[8463,88,24,0,0,22,11,10,0,50,49,24,6,2],
		[8464,88,24,0,0,22,12,58,1,26,19,40,7,2],
		[8465,15,5,0,21,22,10,51,0,58,12,4,4,5],
		[8466,88,24,0,0,22,12,8,0,24,57,0,7,5],
		[8467,88,24,0,0,22,12,44,1,4,43,15,7,3],
		[8468,15,24,0,24,22,9,48,0,72,20,28,6,4],
		[8469,15,10,0,22,22,11,31,0,59,24,52,6,0],
		[8470,88,24,0,0,22,13,44,1,25,10,51,7,3],
		[8471,57,22,0,0,22,17,51,1,77,30,42,7,3],
		[8472,88,24,0,0,22,11,49,0,56,50,22,6,3],
		[8473,88,24,0,0,22,10,15,0,72,6,40,7,1],
		[8474,88,24,0,0,22,10,39,0,70,7,58,7,3],
		[8475,88,24,0,0,22,12,48,0,34,36,17,6,5],
		[8476,88,24,0,0,22,11,57,0,59,5,5,7,5],
		[8477,88,24,0,0,22,14,39,1,41,22,54,7,4],
		[8478,65,10,0,16,22,14,19,1,27,46,1,6,1],
		[8479,88,24,0,0,22,12,2,0,60,45,34,6,5],
		[8480,4,24,0,41,22,14,18,1,21,4,27,6,5],
		[8481,57,4,0,0,22,20,2,1,80,26,23,6,7],
		[8482,88,24,0,0,22,13,39,0,28,36,30,7,5],
		[8483,88,24,0,0,22,12,22,0,63,17,29,7,7],
		[8484,88,24,0,0,22,15,35,1,44,27,7,7,4],
		[8485,88,24,0,0,22,13,53,0,39,42,54,5,5],
		[8486,38,11,1,0,22,15,37,1,41,20,48,6,4],
		[8487,88,24,0,0,22,13,49,0,45,26,27,7,2],
		[8488,38,11,2,0,22,16,27,1,41,37,39,6,4],
		[8489,88,24,0,0,22,14,44,0,42,57,14,7,2],
		[8490,88,24,0,0,22,13,50,0,63,9,45,7,1],
		[8491,88,24,0,0,22,15,60,0,8,32,58,7,2],
		[8492,88,24,0,0,22,16,37,1,25,53,54,7,5],
		[8493,88,24,0,0,22,12,53,0,73,18,26,7,5],
		[8494,15,4,0,23,22,15,2,0,57,2,37,5,3],
		[8495,88,24,0,0,22,16,34,1,1,35,47,7,2],
		[8496,4,24,0,42,22,16,48,1,12,49,53,6,5],
		[8497,88,24,0,0,22,16,60,1,23,8,24,7,4],
		[8498,44,24,0,1,22,15,58,0,37,44,56,5,5],
		[8499,4,7,0,43,22,16,50,1,7,47,0,5,4],
		[8500,88,24,0,0,22,16,53,1,9,2,24,7,5],
		[8501,88,24,0,0,22,18,16,1,53,37,40,6,4],
		[8502,81,0,0,0,22,18,30,1,60,15,35,4,5],
		[8503,88,24,0,0,22,16,30,0,27,48,15,7,4],
		[8504,4,24,0,44,22,17,7,1,5,23,14,7,4],
		[8505,57,19,0,0,22,31,37,1,85,58,2,7,5],
		[8506,88,24,0,0,22,16,27,0,57,13,13,7,4],
		[8507,88,24,0,0,22,18,4,1,0,14,16,7,3],
		[8508,4,24,0,45,22,19,1,1,13,18,18,7,4],
		[8509,88,24,0,0,22,20,36,1,57,30,36,7,5],
		[8510,88,24,0,0,22,18,56,0,37,46,10,7,2],
		[8511,15,24,0,25,22,18,13,0,62,48,16,7,5],
		[8512,4,16,0,46,22,20,12,1,7,49,16,6,1],
		[8513,61,24,0,30,22,20,28,0,5,47,22,6,1],
		[8514,88,24,0,0,22,20,56,0,8,11,12,7,3],
		[8515,43,12,0,0,22,24,37,1,72,15,20,6,2],
		[8516,4,24,0,47,22,21,36,1,21,35,54,6,5],
		[8517,88,24,0,0,22,21,0,0,26,56,7,7,7],
		[8518,4,2,0,48,22,21,39,1,1,23,14,5,2],
		[8519,88,24,0,0,22,20,40,0,50,58,51,7,5],
		[8520,61,24,0,31,22,21,31,0,12,12,19,6,1],
		[8521,38,15,1,0,22,22,44,1,45,56,52,8,7],
		[8522,61,24,0,32,22,21,19,0,28,19,50,6,1],
		[8523,44,24,0,2,22,21,2,0,46,32,12,6,1],
		[8524,38,15,2,0,22,23,8,1,45,55,43,7,3],
		[8525,88,24,0,0,22,18,20,0,76,29,17,8,2],
		[8526,88,24,0,0,22,25,51,1,75,0,56,7,4],
		[8527,88,24,0,0,22,25,11,1,70,25,54,7,3],
		[8528,88,24,0,0,22,21,51,0,42,4,42,7,1],
		[8529,4,24,0,49,22,23,31,1,24,45,45,7,4],
		[8530,88,24,0,0,22,23,32,1,7,11,40,7,4],
		[8531,88,24,0,0,22,24,56,1,57,47,50,6,4],
		[8532,61,24,0,33,22,23,40,0,20,50,54,7,3],
		[8533,4,24,0,51,22,24,7,1,4,50,13,7,2],
		[8534,4,24,0,50,22,24,27,1,13,31,46,7,4],
		[8535,88,24,0,0,22,23,0,0,57,17,4,7,1],
		[8536,88,24,0,0,22,23,54,0,38,34,25,7,3],
		[8537,88,24,0,0,22,23,0,0,62,25,12,7,2],
		[8538,44,1,0,3,22,23,34,0,52,13,45,5,4],
		[8539,4,15,0,52,22,25,17,0,1,22,39,6,1],
		[8540,81,3,0,0,22,27,20,1,64,57,59,5,1],
		[8541,44,24,0,4,22,24,31,0,49,28,35,6,1],
		[8542,88,24,0,0,22,26,11,1,23,40,57,7,2],
		[8543,88,24,0,0,22,25,41,0,18,26,40,7,5],
		[8544,4,24,0,53,22,26,34,1,16,44,29,8,4],
		[8545,4,24,0,53,22,26,34,1,16,44,33,7,4],
		[8546,88,24,0,0,22,13,11,0,86,6,29,6,1],
		[8547,88,24,0,0,22,28,38,1,67,29,21,7,2],
		[8548,61,24,0,34,22,26,37,0,4,23,37,7,3],
		[8549,88,24,0,0,22,26,46,0,37,26,38,7,1],
		[8550,88,24,0,0,22,23,41,0,78,14,36,8,1],
		[8551,61,24,0,35,22,27,52,0,4,41,44,6,5],
		[8552,38,12,0,0,22,28,39,1,39,7,55,6,4],
		[8553,88,24,0,0,22,27,27,0,39,48,35,7,1],
		[8554,88,24,0,0,22,26,59,0,56,26,0,8,1],
		[8555,88,24,0,0,22,27,46,0,31,50,25,7,5],
		[8556,38,3,1,0,22,29,16,1,43,29,44,5,4],
		[8557,88,24,0,0,22,26,1,0,70,46,15,6,5],
		[8558,4,5,1,55,22,28,50,1,0,1,13,6,3],
		[8559,4,5,2,55,22,28,50,1,0,1,12,5,3],
		[8560,38,3,2,0,22,29,46,1,43,44,58,5,7],
		[8561,15,24,0,26,22,27,5,0,65,7,56,6,1],
		[8562,61,24,0,36,22,29,8,0,9,7,44,7,5],
		[8563,88,24,0,0,22,29,46,1,27,6,26,7,3],
		[8564,88,24,0,0,22,29,10,0,26,45,47,7,5],
		[8565,88,24,0,0,22,30,2,1,12,54,54,7,3],
		[8566,61,24,0,37,22,29,58,0,4,25,54,6,3],
		[8567,4,24,0,56,22,30,17,1,14,35,9,7,1],
		[8568,88,24,0,0,22,28,20,0,64,5,8,7,5],
		[8569,88,24,0,0,22,29,44,0,35,43,32,8,2],
		[8570,65,5,0,0,22,30,54,1,26,4,25,7,5],
		[8571,15,3,0,27,22,29,10,0,58,24,55,5,3],
		[8572,44,24,0,5,22,29,32,0,47,42,25,5,7],
		[8573,4,17,0,57,22,30,39,1,10,40,41,6,2],
		[8574,61,24,0,38,22,30,2,0,32,34,21,7,1],
		[8575,88,24,0,0,22,30,7,0,49,21,22,7,5],
		[8576,65,1,0,17,22,31,30,1,32,20,46,5,2],
		[8577,88,24,0,0,22,35,26,1,78,46,18,7,5],
		[8578,15,16,1,28,22,26,43,0,78,47,9,7,2],
		[8579,44,24,0,6,22,30,29,0,43,7,24,6,1],
		[8580,88,24,0,0,22,31,18,1,2,54,40,7,5],
		[8581,88,24,0,0,22,31,18,1,6,33,18,7,3],
		[8582,81,12,0,0,22,33,0,1,61,58,56,6,7],
		[8583,4,24,0,58,22,31,41,1,10,54,20,7,2],
		[8584,88,24,0,0,22,31,34,0,29,32,34,7,2],
		[8585,44,0,0,7,22,31,18,0,50,16,57,5,2],
		[8586,61,24,0,39,22,32,36,0,20,13,48,7,3],
		[8587,88,24,0,0,22,32,47,0,15,51,48,7,5],
		[8588,88,24,0,0,22,32,26,0,39,46,47,7,2],
		[8589,88,24,0,0,22,32,19,0,54,2,15,7,4],
		[8590,4,24,0,60,22,34,3,1,1,34,27,7,4],
		[8591,15,16,2,29,22,29,53,0,78,49,27,7,2],
		[8592,4,19,0,59,22,34,42,1,20,42,30,6,3],
		[8593,88,24,0,0,22,35,53,1,57,53,1,7,2],
		[8594,88,24,0,0,22,33,41,0,56,37,30,7,4],
		[8595,88,24,0,0,22,33,3,0,69,54,49,8,2],
		[8596,88,24,0,0,22,35,37,1,23,59,28,7,5],
		[8597,4,6,0,62,22,35,21,1,0,7,3,5,1],
		[8598,88,24,0,0,22,33,17,0,70,22,26,7,2],
		[8599,88,24,0,0,22,32,16,0,76,13,35,7,2],
		[8600,38,17,1,0,22,36,29,1,40,34,58,7,2],
		[8601,88,24,0,0,22,36,35,1,31,39,50,7,5],
		[8602,38,17,2,0,22,36,59,1,40,35,28,7,2],
		[8603,44,24,0,8,22,35,52,0,39,38,3,7,1],
		[8604,88,24,0,0,22,36,8,0,35,34,38,7,5],
		[8605,88,24,0,0,22,36,36,0,11,41,49,7,2],
		[8606,88,24,0,0,22,35,53,0,50,4,16,7,1],
		[8607,88,24,0,0,22,35,52,0,56,4,12,7,2],
		[8608,88,24,0,0,22,37,5,0,12,34,38,7,5],
		[8609,88,24,0,0,22,36,49,0,35,39,9,7,5],
		[8610,4,9,0,63,22,37,45,1,4,13,41,6,5],
		[8611,88,24,0,0,22,39,8,1,52,41,32,8,3],
		[8612,88,24,0,0,22,38,22,1,7,53,52,7,4],
		[8613,44,24,0,9,22,37,22,0,51,32,43,6,2],
		[8614,88,24,0,0,22,38,45,1,28,44,52,7,5],
		[8615,15,24,0,31,22,35,46,0,73,38,35,6,3],
		[8616,88,24,0,0,22,38,52,1,33,4,53,7,2],
		[8617,88,24,0,0,22,38,18,0,45,10,59,7,4],
		[8618,61,24,0,40,22,38,53,0,19,31,20,7,4],
		[8619,88,24,0,0,22,39,44,1,28,19,31,7,5],
		[8620,88,24,0,0,22,40,49,1,57,25,20,7,5],
		[8621,88,24,0,0,22,38,38,0,56,47,45,6,7],
		[8622,44,24,0,10,22,39,16,0,39,3,1,6,0],
		[8623,88,24,0,0,22,40,22,1,30,39,32,7,5],
		[8624,61,24,0,41,22,39,47,0,19,40,52,7,2],
		[8625,88,24,0,0,22,37,13,0,75,22,18,7,7],
		[8626,88,24,0,0,22,39,34,0,37,35,34,7,4],
		[8627,15,24,0,30,22,38,39,0,63,35,4,6,2],
		[8628,65,4,0,18,22,40,39,1,27,2,37,5,1],
		[8629,88,24,0,0,22,40,48,1,3,33,15,7,3],
		[8630,57,1,0,0,22,46,3,1,81,22,54,5,2],
		[8631,88,24,0,0,22,40,53,0,14,32,58,7,4],
		[8632,44,24,0,11,22,40,31,0,44,16,35,5,5],
		[8633,88,24,0,0,22,40,18,0,53,50,46,7,5],
		[8634,61,5,0,42,22,41,28,0,10,49,53,4,1],
		[8635,88,24,0,0,22,42,37,1,47,12,38,7,4],
		[8636,38,1,0,0,22,42,40,1,46,53,5,3,7],
		[8637,65,24,0,19,22,42,22,1,29,21,39,7,7],
		[8638,88,24,0,0,22,41,31,0,30,57,57,7,5],
		[8639,88,24,0,0,22,42,43,1,44,14,52,7,5],
		[8640,44,24,0,12,22,41,29,0,40,13,32,6,1],
		[8641,61,14,0,43,22,41,45,0,29,18,27,6,2],
		[8642,88,24,0,0,22,41,57,0,14,30,59,7,5],
		[8643,88,24,0,0,22,41,36,0,41,32,58,7,4],
		[8644,38,16,0,0,22,43,30,1,41,24,52,6,5],
		[8645,88,24,0,0,22,43,4,1,8,18,42,7,2],
		[8646,88,24,0,0,22,44,17,1,60,29,58,7,3],
		[8647,4,24,0,67,22,43,14,1,6,57,46,7,2],
		[8648,88,24,0,0,22,42,21,0,53,54,32,7,5],
		[8649,4,24,0,66,22,43,35,1,18,49,49,6,5],
		[8650,61,6,0,44,22,43,0,0,30,13,17,4,4],
		[8651,88,24,0,0,22,42,56,0,37,48,10,7,1],
		[8652,88,24,0,0,22,43,5,0,47,10,7,7,2],
		[8653,88,24,0,0,22,43,43,0,10,56,21,8,4],
		[8654,88,24,0,0,22,44,5,0,39,27,56,7,5],
		[8655,38,6,0,0,22,45,38,1,53,30,1,6,5],
		[8656,44,24,0,13,22,44,6,0,41,49,9,6,5],
		[8657,88,24,0,0,22,45,41,1,46,32,51,7,5],
		[8658,88,24,0,0,22,46,8,1,48,58,44,8,3],
		[8659,88,24,0,0,22,46,28,1,49,41,9,7,5],
		[8660,61,24,0,45,22,45,28,0,19,22,0,7,4],
		[8661,88,24,0,0,22,44,49,0,52,31,2,8,5],
		[8662,88,24,0,0,22,46,44,1,46,56,22,8,2],
		[8663,57,13,0,0,22,50,23,1,80,7,27,6,1],
		[8664,88,24,0,0,22,49,41,1,77,3,2,8,2],
		[8665,61,13,0,46,22,46,42,0,12,10,22,5,3],
		[8666,88,24,0,0,22,46,10,0,44,32,46,7,3],
		[8667,61,10,0,47,22,46,32,0,23,33,56,5,4],
		[8668,88,24,0,0,22,47,19,1,34,9,40,7,5],
		[8669,88,24,0,0,22,48,21,1,61,41,3,7,5],
		[8670,4,24,0,68,22,47,33,1,19,36,48,6,4],
		[8671,88,24,0,0,22,47,47,1,38,13,19,8,3],
		[8672,88,24,0,0,22,49,17,1,70,20,52,7,2],
		[8673,4,18,1,69,22,47,43,1,14,3,23,7,2],
		[8674,88,24,0,0,22,47,56,1,25,54,43,7,4],
		[8675,38,4,0,0,22,48,33,1,51,19,1,4,2],
		[8676,4,24,0,70,22,48,30,1,10,33,20,7,2],
		[8677,88,24,0,0,22,47,23,0,58,28,58,7,1],
		[8678,88,24,0,0,22,48,11,0,37,25,0,7,4],
		[8679,4,18,2,71,22,49,36,1,13,35,33,5,7],
		[8680,88,24,0,0,22,49,59,1,32,48,19,7,3],
		[8681,88,24,0,0,22,49,32,0,10,28,44,8,3],
		[8682,88,24,0,0,22,48,48,0,54,24,54,7,1],
		[8683,88,24,0,0,22,48,44,0,62,56,18,7,5],
		[8684,61,11,0,48,22,50,0,0,24,36,6,4,4],
		[8685,88,24,0,0,22,51,2,1,39,9,25,6,7],
		[8686,88,24,0,0,22,51,45,1,59,52,53,7,5],
		[8687,88,24,0,0,22,49,1,0,68,34,13,7,3],
		[8688,88,24,0,0,22,49,46,0,55,54,10,6,5],
		[8689,88,24,0,0,22,52,10,1,63,11,19,7,5],
		[8690,44,24,0,14,22,50,22,0,41,57,13,7,1],
		[8691,88,24,0,0,22,50,39,0,19,8,27,7,5],
		[8692,88,24,0,0,22,50,10,0,50,40,37,7,4],
		[8693,65,24,0,21,22,51,21,1,29,32,10,7,4],
		[8694,15,8,0,32,22,49,41,0,66,12,2,5,5],
		[8695,65,2,0,22,22,52,32,1,32,52,32,5,2],
		[8696,88,24,0,0,22,51,23,0,61,41,49,7,4],
		[8697,61,17,0,49,22,52,24,0,9,50,8,6,3],
		[8698,4,10,0,73,22,52,37,1,7,34,47,5,7],
		[8699,44,24,0,15,22,52,2,0,43,18,45,6,7],
		[8700,38,18,1,0,22,53,38,1,48,35,53,7,4],
		[8701,43,16,0,0,22,54,39,1,70,4,25,7,4],
		[8702,88,24,0,0,22,47,29,0,83,9,14,6,5],
		[8703,88,24,0,0,22,53,2,0,16,50,28,7,5],
		[8704,4,24,0,74,22,53,29,1,11,37,0,7,1],
		[8705,88,24,0,0,22,52,52,0,50,24,43,7,1],
		[8706,88,24,0,0,22,53,11,0,40,10,2,7,1],
		[8707,88,24,0,0,22,53,4,0,60,6,4,7,5],
		[8708,88,24,0,0,22,53,40,0,44,44,57,7,2],
		[8709,4,3,0,76,22,54,39,1,15,49,15,4,2],
		[8710,4,24,0,78,22,54,34,1,7,12,17,7,5],
		[8711,4,24,0,77,22,54,46,1,16,16,19,7,5],
		[8712,88,24,0,0,22,54,7,0,40,22,37,7,5],
		[8713,88,24,0,0,22,55,15,1,36,23,19,7,5],
		[8714,88,24,0,0,22,54,36,0,16,56,30,7,7],
		[8715,66,24,0,1,22,54,60,0,1,3,53,7,2],
		[8716,88,24,0,0,22,55,11,1,4,59,16,7,5],
		[8717,61,16,0,50,22,55,14,0,8,48,57,6,2],
		[8718,88,24,0,0,22,55,3,0,37,4,37,7,3],
		[8719,88,24,0,0,22,55,51,1,31,37,59,7,5],
		[8720,65,3,0,23,22,55,57,1,32,32,23,5,4],
		[8721,88,24,0,0,22,56,24,1,31,33,56,7,5],
		[8722,38,18,3,0,22,56,48,1,47,58,9,7,2],
		[8723,88,24,0,0,22,55,45,0,36,21,6,7,1],
		[8724,88,24,0,0,22,56,52,0,11,50,54,8,2],
		[8725,44,24,0,16,22,56,24,0,41,36,14,7,1],
		[8726,88,24,0,0,22,56,26,0,49,44,1,6,5],
		[8727,88,24,0,0,22,57,17,1,4,48,36,7,4],
		[8728,65,0,0,24,22,57,39,1,29,37,20,2,2],
		[8729,61,24,0,51,22,57,28,0,20,46,8,6,4],
		[8730,88,24,0,0,22,57,33,0,3,48,37,7,5],
		[8731,88,24,0,0,22,57,5,0,48,41,3,6,1],
		[8732,88,24,0,0,22,58,35,1,35,31,23,7,3],
		[8733,88,24,0,0,22,57,41,0,39,18,32,7,1],
		[8734,88,24,0,0,22,58,16,1,2,23,43,7,4],
		[8735,88,24,0,0,22,58,24,1,1,24,37,7,3],
		[8736,88,24,0,0,22,51,2,0,85,22,25,7,5],
		[8737,88,24,0,0,22,58,35,0,9,21,25,7,4],
		[8738,88,24,0,0,22,58,43,0,7,20,23,7,2],
		[8739,61,24,0,52,22,59,12,0,11,43,44,7,2],
		[8740,88,24,0,0,22,59,36,1,29,27,44,7,2],
		[8741,88,24,0,0,22,59,36,1,13,4,15,7,5],
		[8742,66,24,0,2,22,59,27,0,0,57,46,6,5],
		[8743,88,24,0,0,23,0,6,1,25,9,51,7,5],
		[8744,88,24,0,0,22,59,10,0,52,39,16,7,5],
		[8745,88,24,0,0,22,59,9,0,59,48,53,7,1],
		[8746,88,24,0,0,23,0,25,1,25,37,36,7,5],
		[8747,38,5,0,0,23,0,53,1,52,45,15,5,4],
		[8748,88,24,0,0,22,54,25,0,84,20,46,6,5],
		[8749,88,24,0,0,23,1,8,1,50,57,0,7,5],
		[8750,66,24,0,3,23,0,38,0,0,11,9,7,4],
		[8751,88,24,0,0,23,0,43,0,3,0,42,7,5],
		[8752,88,24,0,0,23,0,5,0,56,56,43,6,4],
		[8753,88,24,0,0,23,0,43,0,31,4,59,8,1],
		[8754,88,24,0,0,23,1,19,1,28,51,13,7,5],
		[8755,88,24,0,0,23,0,34,0,45,22,30,8,2],
		[8756,88,24,0,0,23,1,23,1,22,47,27,7,2],
		[8757,4,24,0,81,23,1,24,1,7,3,40,7,5],
		[8758,88,24,0,0,23,0,55,0,38,42,29,8,1],
		[8759,88,24,0,0,23,1,32,1,4,42,41,7,5],
		[8760,88,24,0,0,23,2,34,1,36,25,15,7,5],
		[8761,88,24,0,0,23,1,31,0,57,6,20,7,5],
		[8762,0,14,0,1,23,1,55,0,42,19,34,5,1],
		[8763,4,24,0,82,23,2,33,1,6,34,27,7,7],
		[8764,88,24,0,0,23,2,44,1,20,52,14,7,5],
		[8765,88,24,0,0,23,2,33,0,31,46,50,8,3],
		[8766,0,24,0,2,23,2,36,0,42,45,28,6,2],
		[8767,65,15,0,0,23,3,30,1,34,44,58,6,3],
		[8768,88,24,0,0,23,2,45,0,44,3,32,7,1],
		[8769,88,24,0,0,23,4,52,1,68,49,13,7,3],
		[8770,88,24,0,0,23,2,44,0,55,14,11,8,1],
		[8771,88,24,0,0,23,3,60,1,41,28,42,7,5],
		[8772,88,24,0,0,23,3,57,1,4,47,43,8,3],
		[8773,66,1,0,4,23,3,53,0,3,49,12,6,1],
		[8774,38,9,0,0,23,4,40,1,53,57,54,6,5],
		[8775,61,1,0,53,23,3,47,0,28,4,58,3,7],
		[8776,88,24,0,0,23,4,1,0,6,37,0,7,3],
		[8777,88,24,0,0,23,3,24,0,60,26,43,8,1],
		[8778,88,24,0,0,23,3,22,0,58,33,53,7,4],
		[8779,88,24,0,0,23,3,33,0,67,12,33,6,5],
		[8780,0,24,0,3,23,4,11,0,50,3,8,6,5],
		[8781,61,0,0,54,23,4,46,0,15,12,19,3,1],
		[8782,4,24,0,83,23,5,10,1,7,41,37,6,3],
		[8783,88,24,0,0,23,5,13,1,17,4,45,7,5],
		[8784,88,24,0,0,23,5,6,0,16,33,47,7,4],
		[8785,88,24,0,0,23,5,18,0,1,18,25,7,4],
		[8786,88,24,0,0,23,8,24,1,79,28,51,7,2],
		[8787,38,7,0,0,23,6,53,1,43,31,14,5,3],
		[8788,88,24,0,0,23,6,18,0,18,31,3,7,3],
		[8789,4,24,0,86,23,6,41,1,23,44,35,5,4],
		[8790,38,19,0,0,23,6,54,1,38,53,32,7,2],
		[8791,88,24,0,0,23,7,10,1,49,36,24,7,5],
		[8792,88,24,0,0,23,6,32,0,19,54,39,7,3],
		[8793,88,24,0,0,23,7,15,1,50,41,11,7,3],
		[8794,88,24,0,0,23,8,36,1,73,35,11,7,5],
		[8795,61,24,0,55,23,7,0,0,9,24,34,6,7],
		[8796,61,24,0,56,23,7,7,0,25,28,6,6,4],
		[8797,13,24,0,1,23,6,37,0,59,25,11,6,1],
		[8798,88,24,0,0,23,7,28,0,32,49,33,7,2],
		[8799,88,24,0,0,23,7,29,0,21,8,3,7,2],
		[8800,88,24,0,0,23,7,18,0,46,4,5,8,1],
		[8801,88,24,0,0,23,7,10,0,52,48,59,7,5],
		[8802,88,24,0,0,23,8,21,1,28,49,24,7,4],
		[8803,88,24,0,0,23,7,10,0,59,43,39,7,1],
		[8804,0,24,0,4,23,7,39,0,46,23,14,6,5],
		[8805,0,24,0,5,23,7,45,0,49,17,45,7,3],
		[8806,88,24,0,0,23,8,12,0,44,33,42,8,2],
		[8807,66,24,0,5,23,8,41,0,2,7,40,6,4],
		[8808,88,24,0,0,23,7,48,0,63,38,0,7,1],
		[8809,88,24,0,0,23,10,12,1,66,51,27,7,5],
		[8810,88,24,0,0,23,12,12,1,80,54,46,7,5],
		[8811,88,24,0,0,23,7,57,0,64,13,21,7,5],
		[8812,4,24,0,88,23,9,27,1,21,10,21,5,5],
		[8813,88,24,0,0,23,9,45,1,28,5,19,7,5],
		[8814,88,24,0,0,23,9,57,1,42,51,38,7,3],
		[8815,61,24,0,57,23,9,32,0,8,40,38,6,7],
		[8816,88,24,0,0,23,9,50,1,14,30,38,7,2],
		[8817,4,24,0,89,23,9,55,1,22,27,27,6,4],
		[8818,88,24,0,0,23,10,10,1,40,35,30,7,7],
		[8819,15,15,0,33,23,7,54,0,75,23,15,5,4],
		[8820,38,8,0,0,23,10,22,1,45,14,48,5,5],
		[8821,61,24,0,58,23,10,2,0,9,49,19,6,1],
		[8822,13,24,0,2,23,9,44,0,59,19,59,7,2],
		[8823,88,24,0,0,23,10,47,1,29,31,30,8,3],
		[8824,88,24,0,0,23,10,43,0,17,35,40,7,5],
		[8825,0,24,0,6,23,10,27,0,43,32,39,7,3],
		[8826,61,24,0,59,23,11,44,0,8,43,12,6,2],
		[8827,61,24,0,60,23,11,49,0,26,50,50,7,4],
		[8828,88,24,0,0,23,13,15,1,49,37,8,8,4],
		[8829,88,24,0,0,23,14,7,1,62,42,0,7,4],
		[8830,0,24,0,7,23,12,33,0,49,24,23,6,3],
		[8831,88,24,0,0,23,13,4,0,29,26,30,7,4],
		[8832,88,24,0,0,23,13,17,0,57,10,6,7,5],
		[8833,88,24,0,0,23,13,27,0,11,3,54,7,4],
		[8834,4,20,0,90,23,14,19,1,6,2,56,5,7],
		[8835,88,24,0,0,23,14,59,1,41,6,20,7,5],
		[8836,88,24,0,0,23,14,40,1,10,41,19,7,5],
		[8837,88,24,0,0,23,14,14,0,50,37,4,7,2],
		[8838,88,24,0,0,23,14,22,0,29,46,18,7,3],
		[8839,88,24,0,0,23,14,37,0,24,6,11,7,5],
		[8840,88,24,0,0,23,15,34,1,3,29,47,7,2],
		[8841,4,22,1,91,23,15,54,1,9,5,16,5,5],
		[8842,61,24,0,61,23,15,46,0,28,14,52,7,4],
		[8843,88,24,0,0,23,16,58,1,62,0,4,7,3],
		[8844,88,24,0,0,23,14,37,0,74,13,52,7,2],
		[8845,88,24,0,0,23,15,58,0,24,46,16,8,3],
		[8846,88,24,0,0,23,16,40,1,44,29,21,7,5],
		[8847,88,24,0,0,23,16,50,1,41,11,40,7,5],
		[8848,81,2,0,0,23,17,26,1,58,14,9,5,3],
		[8849,88,24,0,0,23,19,8,1,79,28,22,7,5],
		[8850,4,21,0,92,23,16,51,1,7,43,36,6,7],
		[8851,88,24,0,0,23,15,38,0,70,53,17,7,3],
		[8852,66,2,0,6,23,17,10,0,3,16,56,5,4],
		[8853,88,24,0,0,23,16,42,0,53,12,49,7,3],
		[8854,88,24,0,0,23,16,27,0,61,57,47,8,1],
		[8855,88,24,0,0,23,18,20,1,67,28,16,7,5],
		[8856,88,24,0,0,23,17,40,1,11,42,47,7,2],
		[8857,88,24,0,0,23,17,17,0,45,9,51,7,5],
		[8858,4,22,2,93,23,17,54,1,9,10,57,5,1],
		[8859,38,20,0,0,23,18,10,1,40,49,28,7,3],
		[8860,0,24,0,8,23,17,45,0,49,0,55,6,7],
		[8861,88,24,0,0,23,17,56,0,45,29,20,7,1],
		[8862,57,18,0,0,23,28,4,1,87,28,56,6,5],
		[8863,70,2,0,0,23,18,49,1,32,31,55,5,5],
		[8864,0,24,0,9,23,18,23,0,41,46,25,7,2],
		[8865,4,22,3,95,23,18,58,1,9,36,39,6,2],
		[8866,4,24,0,94,23,19,7,1,13,27,32,6,4],
		[8867,88,24,0,0,23,17,19,0,75,17,57,7,2],
		[8868,4,24,0,96,23,19,24,1,5,7,28,7,3],
		[8869,88,24,0,0,23,19,24,1,18,4,31,7,5],
		[8870,88,24,0,0,23,19,2,0,45,8,14,8,2],
		[8871,88,24,0,0,23,19,43,1,33,42,29,7,5],
		[8872,15,14,0,34,23,18,38,0,68,6,42,6,5],
		[8873,88,24,0,0,23,19,27,0,34,47,36,7,1],
		[8874,0,24,0,11,23,19,30,0,48,37,31,6,5],
		[8875,88,24,0,0,23,19,42,0,48,22,51,7,5],
		[8876,0,24,0,10,23,19,52,0,42,4,41,7,7],
		[8877,88,24,0,0,23,20,50,1,50,18,24,7,3],
		[8878,66,24,0,7,23,20,21,0,5,22,53,6,5],
		[8879,88,24,0,0,23,20,41,1,5,54,29,7,5],
		[8880,61,18,0,62,23,20,38,0,23,44,25,6,2],
		[8881,88,24,0,0,23,20,14,0,61,58,12,7,5],
		[8882,61,24,0,63,23,20,50,0,30,24,54,7,7],
		[8883,88,24,0,0,23,21,16,1,26,59,12,7,4],
		[8884,88,24,0,0,23,20,44,0,44,6,59,7,2],
		[8885,0,24,0,12,23,20,53,0,38,10,56,7,3],
		[8886,88,24,0,0,23,20,35,0,62,12,47,7,5],
		[8887,61,24,0,64,23,21,55,0,31,48,45,6,1],
		[8888,88,24,0,0,23,21,58,0,26,36,32,8,3],
		[8889,88,24,0,0,23,22,57,1,60,3,21,7,7],
		[8890,4,24,0,97,23,22,39,1,15,2,21,6,2],
		[8891,61,24,0,65,23,22,41,0,20,49,43,7,1],
		[8892,4,24,0,98,23,22,58,1,20,6,2,5,5],
		[8893,61,24,0,66,23,23,5,0,12,18,50,6,5],
		[8894,88,24,0,0,23,22,33,0,60,8,1,7,5],
		[8895,88,24,0,0,23,23,54,1,53,48,30,7,2],
		[8896,88,24,0,0,23,23,45,1,43,7,28,7,5],
		[8897,88,24,0,0,23,23,32,0,0,17,29,7,5],
		[8898,88,24,0,0,23,24,13,1,51,53,29,7,7],
		[8899,88,24,0,0,23,23,48,0,32,31,53,8,3],
		[8900,88,24,0,0,23,24,8,1,18,41,15,7,4],
		[8901,88,24,0,0,23,25,19,1,56,50,57,7,5],
		[8902,88,24,0,0,23,24,35,0,41,6,46,8,1],
		[8903,61,24,0,67,23,24,51,0,32,23,6,7,1],
		[8904,13,24,0,4,23,24,50,0,62,16,58,6,7],
		[8905,61,19,0,68,23,25,23,0,23,24,15,5,3],
		[8906,4,24,0,99,23,26,3,1,20,38,31,5,5],
		[8907,38,14,0,0,23,26,37,1,52,43,18,7,3],
		[8908,88,24,0,0,23,27,7,1,66,34,52,7,5],
		[8909,88,24,0,0,23,27,15,1,58,28,34,7,4],
		[8910,88,24,0,0,23,27,9,1,50,9,26,7,1],
		[8911,66,9,0,8,23,26,56,0,1,15,20,6,2],
		[8912,66,24,0,9,23,27,15,0,1,7,21,7,4],
		[8913,0,24,0,13,23,27,7,0,42,54,43,7,1],
		[8914,88,24,0,0,23,28,1,1,35,32,40,7,5],
		[8915,61,24,0,69,23,27,40,0,25,10,2,7,2],
		[8916,66,7,0,10,23,27,58,0,6,22,44,5,5],
		[8917,88,24,0,0,23,28,5,1,11,26,59,7,4],
		[8918,88,24,0,0,23,27,17,0,70,21,35,7,2],
		[8919,88,24,0,0,23,29,1,1,63,6,39,7,2],
		[8920,88,24,0,0,23,29,1,1,44,29,52,7,5],
		[8921,88,24,0,0,23,29,1,1,9,15,58,7,5],
		[8922,88,24,0,0,23,29,6,0,23,2,52,7,4],
		[8923,61,24,0,70,23,29,9,0,12,45,38,6,4],
		[8924,88,24,0,0,23,29,32,1,4,31,58,7,5],
		[8925,88,24,0,0,23,30,7,0,49,7,59,7,5],
		[8926,88,24,0,0,23,30,2,0,58,32,56,6,1],
		[8927,88,24,0,0,23,30,40,0,38,39,43,7,4],
		[8928,88,24,0,0,23,31,1,1,6,17,18,7,5],
		[8929,88,24,0,0,23,31,27,1,44,50,37,7,5],
		[8930,0,24,0,14,23,31,17,0,39,14,11,6,5],
		[8931,88,24,0,0,23,31,32,1,4,5,14,7,3],
		[8932,4,24,0,100,23,31,42,1,21,22,10,7,2],
		[8933,88,24,0,0,23,31,43,0,28,24,13,7,2],
		[8934,66,24,0,13,23,31,58,1,1,5,9,7,5],
		[8935,88,24,0,0,23,33,20,1,77,23,7,7,4],
		[8936,88,24,0,0,23,32,25,0,34,57,9,8,1],
		[8937,70,1,0,0,23,32,58,1,37,49,6,5,1],
		[8938,88,24,0,0,23,27,1,0,87,18,27,7,2],
		[8939,4,24,0,101,23,33,17,1,20,54,52,6,2],
		[8940,61,24,0,71,23,33,28,0,22,29,56,6,7],
		[8941,88,24,0,0,23,33,43,0,45,3,29,7,4],
		[8942,88,24,0,0,23,33,56,0,20,50,27,7,7],
		[8943,61,24,0,72,23,33,57,0,31,19,31,6,5],
		[8944,66,24,0,14,23,34,9,1,1,14,51,7,2],
		[8945,88,24,0,0,23,35,13,1,64,41,22,8,3],
		[8946,88,24,0,0,23,34,49,1,15,14,45,7,5],
		[8947,0,24,0,15,23,34,38,0,40,14,11,7,2],
		[8948,61,24,0,73,23,34,38,0,33,29,50,7,5],
		[8949,63,8,0,0,23,35,5,1,42,36,54,6,2],
		[8950,88,24,0,0,23,34,47,0,38,1,26,7,5],
		[8951,88,24,0,0,23,35,32,1,7,27,52,7,4],
		[8952,88,24,0,0,23,34,59,0,71,38,32,7,4],
		[8953,88,24,0,0,23,35,56,0,24,33,40,7,7],
		[8954,66,24,0,16,23,36,23,0,2,6,8,7,3],
		[8955,88,24,0,0,23,36,31,0,32,54,15,7,3],
		[8956,88,24,0,0,23,37,5,1,31,52,15,8,5],
		[8957,88,24,0,0,23,38,24,1,76,52,12,7,5],
		[8958,88,24,0,0,23,37,40,1,13,3,37,7,4],
		[8959,88,24,0,0,23,37,51,1,45,29,33,6,2],
		[8960,61,24,0,74,23,37,40,0,16,49,32,7,2],
		[8961,0,10,0,16,23,37,34,0,46,27,29,5,4],
		[8962,88,24,0,0,23,37,32,0,44,25,45,7,1],
		[8963,61,24,0,75,23,37,57,0,18,24,2,7,2],
		[8964,88,24,0,0,23,37,59,0,46,11,59,8,4],
		[8965,0,8,0,17,23,38,8,0,43,16,5,5,1],
		[8966,63,7,0,0,23,39,28,1,46,38,16,7,2],
		[8967,0,24,0,18,23,39,8,0,50,28,18,6,1],
		[8968,4,23,1,102,23,39,47,1,14,13,18,6,3],
		[8969,66,8,0,17,23,39,57,0,5,37,35,5,3],
		[8970,88,24,0,0,23,39,55,0,9,40,38,7,2],
		[8971,88,24,0,0,23,39,10,0,75,17,34,7,2],
		[8972,88,24,0,0,23,39,21,0,74,0,10,7,4],
		[8973,88,24,0,0,23,40,3,0,37,39,9,8,3],
		[8974,15,2,0,35,23,39,21,0,77,37,57,4,5],
		[8975,70,11,0,0,23,40,38,1,32,4,23,6,5],
		[8976,0,9,0,19,23,40,25,0,44,20,2,5,1],
		[8977,88,24,0,0,23,40,41,0,36,43,15,7,3],
		[8978,88,24,0,0,23,41,7,1,24,9,37,8,7],
		[8979,88,24,0,0,23,41,9,1,11,40,50,7,4],
		[8980,4,24,0,103,23,41,35,1,18,1,38,6,5],
		[8981,88,24,0,0,23,41,27,0,49,30,44,7,2],
		[8982,4,24,0,104,23,41,46,1,17,48,59,6,4],
		[8983,88,24,0,0,23,41,57,0,7,15,2,7,2],
		[8984,66,10,0,18,23,42,3,0,1,46,48,6,2],
		[8985,88,24,0,0,23,41,55,0,57,15,36,7,4],
		[8986,88,24,0,0,23,42,15,0,44,59,31,8,5],
		[8987,88,24,0,0,23,42,28,1,15,26,52,6,5],
		[8988,4,23,2,105,23,42,43,1,14,32,42,5,1],
		[8989,88,24,0,0,23,42,21,0,64,30,56,8,7],
		[8990,88,24,0,0,23,42,32,0,61,40,46,7,5],
		[8991,61,24,0,77,23,43,22,0,10,19,53,6,7],
		[8992,88,24,0,0,23,43,50,1,15,17,4,7,7],
		[8993,88,24,0,0,23,44,1,1,45,5,0,7,5],
		[8994,88,24,0,0,23,44,25,1,70,29,25,7,4],
		[8995,88,24,0,0,23,44,41,1,78,47,29,7,5],
		[8996,88,24,0,0,23,44,12,1,64,24,16,7,5],
		[8997,61,24,0,78,23,43,60,0,29,21,42,6,5],
		[8998,4,24,0,106,23,44,12,1,18,16,37,6,1],
		[8999,88,24,0,0,23,44,29,1,26,14,47,7,3],
		[9000,88,24,0,0,23,44,48,0,55,47,59,8,4],
		[9001,88,24,0,0,23,46,1,1,40,10,57,7,2],
		[9002,4,24,0,107,23,46,1,1,18,40,41,6,3],
		[9003,0,22,0,20,23,46,2,0,46,25,13,6,4],
		[9004,66,24,0,19,23,46,24,0,3,29,12,6,6],
		[9005,88,24,0,0,23,46,37,0,66,46,56,7,1],
		[9006,63,17,0,0,23,47,16,1,50,13,36,6,1],
		[9007,88,24,0,0,23,47,23,1,68,23,39,8,3],
		[9008,13,18,0,5,23,47,4,0,58,39,7,6,5],
		[9009,88,24,0,0,23,47,16,1,11,54,39,7,5],
		[9010,88,24,0,0,23,47,2,0,57,27,5,7,5],
		[9011,88,24,0,0,23,47,33,0,46,49,57,7,1],
		[9012,66,24,0,20,23,47,57,1,2,45,42,6,4],
		[9013,88,24,0,0,23,47,55,0,67,48,25,6,2],
		[9014,88,24,0,0,23,48,33,1,6,22,50,7,5],
		[9015,88,24,0,0,23,48,49,0,2,12,51,7,3],
		[9016,70,3,0,0,23,48,56,1,28,7,49,6,2],
		[9017,88,24,0,0,23,48,39,0,64,52,35,7,2],
		[9018,13,24,0,6,23,48,50,0,62,12,52,6,2],
		[9019,88,24,0,0,23,48,54,0,59,58,44,7,2],
		[9020,88,24,0,0,23,49,12,0,58,57,47,7,3],
		[9021,88,24,0,0,23,49,32,1,15,51,40,7,5],
		[9022,66,24,0,21,23,49,28,0,1,4,34,7,2],
		[9023,88,24,0,0,23,49,45,1,62,50,22,8,5],
		[9024,88,24,0,0,23,49,41,0,36,25,31,7,4],
		[9025,61,24,0,79,23,49,39,0,28,50,33,7,2],
		[9026,88,24,0,0,23,49,50,1,25,19,53,7,2],
		[9027,88,24,0,0,23,50,15,1,9,58,27,7,5],
		[9028,88,24,0,0,23,50,22,0,51,37,18,7,3],
		[9029,88,24,0,0,23,50,33,1,14,24,7,7,5],
		[9030,61,24,0,80,23,51,21,0,9,18,48,7,7],
		[9031,4,24,0,108,23,51,21,1,18,54,32,6,1],
		[9032,57,2,1,0,23,52,6,1,82,1,8,6,4],
		[9033,66,24,0,22,23,51,58,0,2,55,49,7,5],
		[9034,88,24,0,0,23,51,58,0,77,35,58,8,3],
		[9035,88,24,0,0,23,52,23,0,21,40,15,7,7],
		[9036,61,20,0,81,23,52,29,0,19,7,13,6,7],
		[9037,88,24,0,0,23,52,30,1,14,15,4,7,5],
		[9038,88,24,0,0,23,52,25,0,75,32,41,7,5],
		[9039,61,24,0,82,23,52,37,0,10,56,51,6,2],
		[9040,88,24,0,0,23,52,51,1,8,59,48,7,5],
		[9041,66,24,0,24,23,52,56,1,3,9,20,7,4],
		[9042,66,24,0,25,23,53,5,0,2,5,26,7,2],
		[9043,88,24,0,0,23,53,21,1,24,13,45,7,2],
		[9044,88,24,0,0,23,54,21,1,27,2,32,7,2],
		[9045,13,16,0,7,23,54,23,0,57,29,58,6,4],
		[9046,88,24,0,0,23,54,39,1,40,18,0,7,3],
		[9047,88,24,0,0,23,54,47,0,0,6,33,7,7],
		[9048,66,24,0,26,23,55,8,0,7,4,16,7,1],
		[9049,88,24,0,0,23,55,17,1,31,55,18,7,1],
		[9050,88,24,0,0,23,55,17,1,31,53,3,8,1],
		[9051,88,24,0,0,23,55,23,0,25,57,18,8,5],
		[9052,88,24,0,0,23,55,34,0,57,24,44,7,1],
		[9053,88,24,0,0,23,55,34,0,47,21,21,7,4],
		[9054,88,24,0,0,23,56,30,1,24,44,14,7,4],
		[9055,88,24,0,0,23,56,42,0,22,38,53,7,7],
		[9056,88,24,0,0,23,56,28,0,83,11,28,8,2],
		[9057,88,24,0,0,23,57,4,0,42,39,30,7,3],
		[9058,88,24,0,0,23,57,8,1,26,37,25,7,5],
		[9059,88,24,0,0,23,57,9,0,55,42,21,7,3],
		[9060,88,24,0,0,23,57,20,1,62,57,23,7,2],
		[9061,57,2,2,0,23,57,33,1,82,10,12,7,5],
		[9062,81,6,0,0,23,57,35,1,64,17,54,6,2],
		[9063,88,24,0,0,23,57,34,0,60,1,25,7,1],
		[9064,61,22,0,84,23,57,46,0,25,8,29,6,7],
		[9065,16,24,0,1,23,58,21,1,15,50,51,7,5],
		[9066,88,24,0,0,23,58,25,0,51,23,19,6,7],
		[9067,66,24,0,27,23,58,40,1,3,33,22,6,4],
		[9068,88,24,0,0,23,58,49,0,32,22,54,8,1],
		[9069,63,15,0,0,23,58,56,1,52,44,45,6,5],
		[9070,88,24,0,0,23,58,47,0,46,24,47,8,1],
		[9071,13,17,0,8,23,59,1,0,55,45,18,6,1],
		[9072,66,23,0,28,23,59,19,0,6,51,48,5,3],
		[9073,88,24,0,0,23,59,28,1,29,29,6,7,5],
		[9074,88,24,0,0,23,59,29,0,33,43,28,8,4],
		[9075,88,24,0,0,23,59,29,0,33,43,28,8,4],
		[9076,81,4,0,0,23,59,55,1,65,34,38,6,1],
		[9077,88,24,0,0,0,0,19,1,44,17,26,7,4],
		[9078,88,24,0,0,0,0,24,0,26,55,6,7,3],
		[9079,88,24,0,0,0,0,31,0,59,33,35,7,4],
		[9080,88,24,0,0,0,0,44,0,45,15,12,7,1],
		[9081,63,18,0,0,0,1,5,1,48,48,36,7,4],
		[9082,88,24,0,0,0,1,20,1,50,20,14,7,7],
		[9083,88,24,0,0,0,1,19,0,49,58,54,7,4],
		[9084,57,7,0,0,0,1,36,1,77,3,57,6,5],
		[9085,88,24,0,0,0,1,37,0,61,13,23,7,3],
		[9086,88,24,0,0,0,1,44,0,42,22,2,7,1],
		[9087,66,24,0,29,0,1,49,1,3,1,39,6,1],
		[9088,61,24,0,85,0,2,10,0,27,4,55,7,4],
		[9089,66,24,0,30,0,1,58,1,6,0,51,5,7],
		[9090,88,24,0,0,0,2,7,1,14,40,34,8,7],
		[9091,70,5,0,0,0,2,20,1,29,43,13,6,1],
		[9092,66,24,0,31,0,2,24,0,8,57,25,7,2],
		[9093,66,24,0,32,0,2,30,0,8,29,8,7,3],
		[9094,88,24,0,0,0,2,36,0,66,5,56,7,4],
		[9095,88,24,0,0,0,2,58,1,20,2,46,7,3],
		[9096,88,24,0,0,0,3,8,1,24,8,43,7,4],
		[9097,88,24,0,0,0,3,26,0,63,38,31,7,1],
		[9098,16,24,0,2,0,3,44,1,17,20,10,6,1],
		[9099,88,24,0,0,0,3,52,0,66,42,44,7,7],
		[9100,13,24,0,9,0,4,14,0,62,17,16,7,2],
		[9101,88,24,0,0,0,4,20,1,16,31,44,7,5],
		[9102,88,24,0,0,0,4,20,1,29,16,7,7,2],
		[9103,16,24,0,3,0,4,30,1,10,30,34,6,5],
		[9104,88,24,0,0,0,4,42,0,67,10,0,7,5],
		[9105,88,24,0,0,0,4,37,0,42,5,32,7,1],
		[9106,88,24,0,0,0,4,31,1,72,53,52,8,3],
		[9107,88,24,0,0,0,4,54,0,34,39,35,7,4],
		[9108,88,24,0,0,0,4,41,1,71,26,13,7,1],
		[9109,88,24,0,0,0,4,56,0,26,38,56,7,5],
		[9110,88,24,0,0,0,5,6,0,61,18,51,7,1]		

		]
		//↓は星座の線を引く時に使った。本番版では使ってないけど、残しておく。
	//[HR番号,星座,バイエル符号(ギリシア文字),バイエル符号の上（下）付き数字,フラムスティード番号,赤経,赤緯,視等級（四捨五入した整数）格納値=実際の視等級+1,スペクトル分類]
	private const STARS:Array = [
		[271,0,6,0,18,14.3000,23.4175,5,4],//なぜか0番目が無視されるので
		[15,0,0,0,1,2.0958,29.0906,3,1],
		[21,13,1,0,-9,2.2958,59.1497,3,3],
		[25,63,4,0,127,2.3542,-45.7475,5,5],
		[39,61,2,0,68,3.3083,15.1836,4,1],
		[74,16,8,0,-12,4.8583,-8.8239,5,5],
		[77,81,5,0,127,5.0167,-64.8747,5,3],
		[98,42,1,0,127,6.4375,-77.2542,4,4],
		[99,63,0,0,127,6.5708,-42.3061,3,5],
		[126,81,1,1,127,7.8875,-62.9581,5,1],
		[154,0,15,0,9,9.2208,33.7194,5,1],
		[163,0,4,0,10,9.6375,29.3117,5,4],
		[165,0,3,0,11,9.8333,30.8608,4,5],
		[168,13,0,0,-2,10.1292,56.5372,3,5],
		[188,16,1,0,-4,10.8958,-17.9867,3,4],
		[215,0,5,0,14,11.8333,24.2672,5,5],
		[224,66,3,0,43,12.1708,7.5850,5,5],
		[226,0,12,0,15,12.4542,41.0789,6,1],
		[264,13,2,0,7,14.1792,60.7167,3,1],
		[269,0,11,0,17,14.1875,38.4994,5,2],
		//[271,0,6,0,18,14.3000,23.4175,5,4],
		[280,70,0,0,127,14.6500,-29.3575,5,1],
		[294,66,4,0,51,15.7375,7.8900,5,5],
		[322,63,1,0,127,16.5208,-46.7186,4,4],
		[334,16,6,0,11,17.1458,-10.1822,4,5],
		[335,0,20,0,22,17.3750,47.2419,5,1],
		[337,0,1,0,23,17.4333,35.6206,3,7],
		[338,63,5,0,127,17.0958,-55.2458,5,1],
		[352,66,18,0,63,17.9167,30.0897,6,5],
		[360,66,20,0,65,18.4375,24.5836,6,5],
		[383,66,19,0,70,19.8667,27.2642,6,2],
		[402,16,7,0,25,21.0042,-8.1833,5,5],
		[403,13,3,0,17,21.4542,60.2353,4,2],
		[424,83,0,0,-19,37.9542,89.2642,3,3],
		[429,63,2,0,127,22.0917,-43.3183,4,7],
		[437,66,6,0,79,22.8708,15.3458,5,4],
		[440,63,3,0,127,22.8125,-49.0728,5,5],
		[464,0,24,0,31,24.5000,48.6283,5,5],
		[472,35,0,0,127,24.4292,-57.2367,1,1],
		[489,66,12,0,86,25.3583,5.4875,5,5],
		[496,62,20,0,127,25.9167,50.6886,5,1],
		[509,16,18,0,32,26.0167,-15.9375,5,4],
		[510,66,14,0,90,26.3500,9.1578,5,4],
		[539,16,5,0,35,27.8667,-10.3350,5,5],
		[542,13,4,0,25,28.6000,63.6700,4,1],
		[544,80,0,0,-18,28.2708,29.5789,4,3],
		[545,6,2,1,-15,28.3833,19.2958,6,1],
		[553,6,1,0,-14,28.6583,20.8081,4,2],
		[566,35,21,0,127,28.9917,-51.6089,5,4],
		[591,42,0,0,127,29.6917,-61.5697,4,3],
		[595,66,0,0,93,30.5125,2.7636,6,2],
		[603,0,2,1,37,30.9750,42.3297,3,5],
		[612,36,12,0,127,31.1208,-29.2969,6,1],
		[617,6,0,0,-7,31.7917,23.4625,3,5],
		[622,80,1,0,-16,32.3875,34.9872,4,2],
		[664,80,2,0,-11,34.3292,33.8472,5,2],
		[681,16,14,0,48,34.8375,-2.9775,4,7],
		[718,16,13,2,53,37.0417,8.4600,5,1],
		[721,35,9,0,127,36.7458,-47.7039,5,1],
		[778,40,6,0,127,39.3500,-52.5431,6,2],
		[779,16,3,0,62,39.8708,0.3286,5,1],
		[789,88,24,0,127,39.9500,-42.8917,6,2],
		[794,35,8,0,127,40.1667,-39.8556,5,5],
		[799,62,7,0,-7,41.0500,49.2283,5,3],
		[802,40,5,0,127,40.1667,-54.5500,6,3],
		[804,16,2,0,66,40.8250,3.2358,4,2],
		[810,40,8,0,127,40.6417,-50.8003,6,4],
		[811,16,15,0,69,41.0292,-13.8586,5,1],
		[813,16,11,0,67,41.2375,10.1142,5,3],
		[818,35,18,1,-19,41.2750,-18.5725,5,3],
		[834,62,6,0,-5,42.6750,55.8956,5,5],
		[838,6,24,0,21,42.4958,27.2606,5,1],
		[841,36,1,0,127,42.2708,-32.4058,5,5],
		[854,62,18,0,-2,43.5667,52.7625,5,4],
		[874,35,6,0,-17,44.1083,-8.8981,5,5],
		[896,16,10,0,71,44.9292,8.9075,6,1],
		[897,35,7,1,127,44.5667,-40.3047,4,2],
		[909,40,1,0,127,44.7000,-64.0714,6,2],
		[911,16,0,0,72,45.5708,4.0897,4,7],
		[915,62,2,0,3,46.2000,53.5064,4,4],
		[919,35,18,3,-9,45.6000,-23.6244,5,2],
		[921,62,16,0,5,46.2958,38.8403,4,7],
		[934,40,11,0,127,45.9042,-59.7378,6,3],
		[936,62,1,0,6,47.0417,40.9556,3,1],
		[937,62,8,0,127,47.2667,49.6133,5,4],
		[941,62,9,0,7,47.3750,44.8572,5,5],
		[963,36,0,0,127,48.0167,-28.9869,5,3],
		[1003,35,18,4,-4,49.8792,-21.7578,5,7],
		[1008,88,24,0,127,49.9833,-43.0697,5,4],
		[1017,62,0,0,13,51.0792,49.8611,3,3],
		[1030,77,14,0,-19,51.2042,9.0289,5,4],
		[1035,88,24,0,127,52.2667,59.9403,5,1],
		[1038,77,13,0,-18,51.7917,9.7328,5,1],
		[1084,35,4,0,-2,53.2333,-9.4583,5,5],
		[1088,35,18,5,-1,53.4458,-21.6328,5,1],
		[1101,77,24,0,-10,54.2167,0.4017,5,3],
		[1106,88,24,0,127,54.2750,-40.2747,6,5],
		[1122,62,3,0,19,55.7333,47.7875,4,1],
		[1131,62,14,0,18,56.0792,32.2883,5,1],
		[1136,35,3,0,3,55.8125,-9.7633,5,5],
		[1148,10,2,0,127,57.5917,71.3322,6,2],
		[1155,88,24,0,127,57.3792,65.5261,5,7],
		[1162,35,15,0,6,56.5375,-12.1017,5,7],
		[1173,35,18,6,7,56.7125,-23.2497,5,3],
		[1175,69,1,0,127,56.0500,-64.8069,5,5],
		[1195,88,24,0,127,57.3625,-36.2003,5,4],
		[1203,62,5,0,24,58.5333,31.8836,4,1],
		[1208,42,2,0,127,56.8083,-74.2389,4,7],
		[1213,35,18,8,13,58.4292,-24.6125,6,1],
		[1220,62,4,0,25,59.4625,40.0103,4,1],
		[1228,62,13,0,26,59.7417,35.7911,5,0],
		[1231,35,2,0,14,59.5083,-13.5086,4,7],
		[1239,77,10,0,15,60.1708,12.4903,4,1],
		[1240,35,18,9,16,59.9833,-24.0164,6,1],
		[1247,69,3,0,127,59.6875,-61.4003,6,7],
		[1251,77,12,0,18,60.7875,5.9892,5,2],
		[1261,62,10,0,27,61.6458,50.3514,5,2],
		[1273,62,24,0,28,62.1667,47.7125,5,1],
		[1298,35,14,1,18,62.9667,-6.8375,5,3],
		[1303,62,11,0,31,63.7250,48.4094,5,4],
		[1324,88,24,0,127,64.5625,50.2956,6,2],
		[1326,40,0,0,127,63.5000,-42.2944,5,5],
		[1336,69,0,0,127,63.6083,-62.4739,4,4],
		[1338,32,2,0,127,64.0083,-51.4867,5,3],
		[1346,77,2,0,34,64.9500,15.6275,5,5],
		[1347,35,19,4,21,64.4750,-33.7983,5,1],
		[1355,69,4,0,127,64.1208,-59.3019,5,5],
		[1373,77,3,1,41,65.7333,17.5425,5,5],
		[1393,35,24,0,23,66.0083,-34.0169,5,5],
		[1409,77,4,0,54,67.1542,19.1803,5,4],
		[1412,77,7,2,58,67.1667,15.8708,4,2],
		[1443,9,3,0,127,67.7083,-44.9539,6,1],
		[1453,35,19,1,30,68.3792,-29.7667,6,5],
		[1457,77,0,0,67,68.9792,16.5092,2,5],
		[1463,35,12,0,28,69.0792,-3.3525,5,1],
		[1464,35,19,2,32,68.8875,-30.5622,5,4],
		[1465,32,0,0,127,68.5000,-55.0450,4,2],
		[1502,9,0,0,127,70.1417,-41.8639,5,3],
		[1503,9,1,0,127,70.5167,-37.1444,6,3],
		[1520,35,11,0,37,71.3750,-3.2547,5,1],
		[1542,10,0,0,-11,73.5125,66.3428,5,0],
		[1543,59,15,3,-19,72.4583,6.9614,4,3],
		[1544,59,15,2,-18,72.6542,8.9003,5,2],
		[1552,59,15,4,-17,72.8000,5.6050,5,1],
		[1567,59,15,5,-12,73.5625,2.4406,5,1],
		[1568,10,24,0,-13,74.3208,53.7522,5,2],
		[1570,59,15,1,-13,73.7250,10.1508,6,2],
		[1577,7,8,0,-17,74.2500,33.1661,4,5],
		[1580,59,14,2,-11,74.0917,13.5144,5,5],
		[1601,59,15,6,-10,74.6375,1.7142,5,5],
		[1603,10,1,0,-10,75.8542,60.4422,5,4],
		[1605,7,4,0,-13,75.4917,43.8233,4,3],
		[1612,7,5,0,-12,75.6208,41.0758,5,5],
		[1638,59,24,0,-9,76.1417,15.4042,6,2],
		[1641,7,6,0,-10,76.6292,41.2344,4,1],
		[1652,9,2,1,127,76.1000,-35.4833,6,5],
		[1654,46,4,0,-18,76.3667,-22.3711,4,5],
		[1666,35,1,0,47,76.9625,-5.0864,4,2],
		[1674,32,5,0,127,76.3792,-57.4728,6,3],
		[1677,52,1,0,127,75.6792,-71.3144,6,4],
		[1702,46,11,0,-15,78.2333,-16.2056,4,1],
		[1705,46,9,0,-16,78.3083,-12.9414,5,1],
		[1708,7,0,0,-7,79.1708,45.9981,1,4],
		[1713,59,1,0,-1,78.6333,-8.2017,1,1],
		[1756,46,10,0,-14,79.8958,-13.1767,5,1],
		[1788,59,6,0,8,81.1208,-2.3969,4,1],
		[1790,59,2,0,4,81.2833,6.3497,3,1],
		[1791,77,1,0,92,81.5750,28.6075,3,1],
		[1829,46,1,0,-11,82.0625,-20.7594,4,4],
		[1852,59,3,0,14,83.0000,-0.2992,3,0],
		[1862,22,4,0,127,82.8042,-35.4706,5,5],
		[1865,46,0,0,-9,83.1833,-17.8222,4,3],
		[1879,59,10,0,19,83.7833,9.9342,5,0],
		[1903,59,4,0,26,84.0542,-1.2019,3,1],
		[1910,77,5,0,103,84.4125,21.1425,4,1],
		[1922,32,1,0,127,83.4083,-62.4897,5,3],
		[1948,59,5,0,30,85.1917,-1.9428,3,0],
		[1956,22,0,0,127,84.9125,-34.0742,4,1],
		[1983,46,2,0,-7,86.1167,-22.4483,5,3],
		[1998,46,5,0,-6,86.7375,-14.8219,5,2],
		[2004,59,9,0,33,86.9375,-9.6697,3,1],
		[2015,32,3,0,127,86.1917,-65.7356,5,2],
		[2020,64,1,0,127,86.8208,-51.0664,5,2],
		[2035,46,3,0,-5,87.8292,-20.8792,5,5],
		[2040,22,1,0,127,87.7417,-35.7683,4,5],
		[2042,64,2,0,127,87.4583,-56.1667,6,5],
		[2047,59,21,1,34,88.5958,20.2761,5,4],
		[2061,59,0,0,38,88.7917,7.4069,2,7],
		[2077,7,3,0,13,89.8833,54.2847,5,5],
		[2085,46,6,0,-4,89.1000,-14.1678,5,3],
		[2088,7,1,0,14,89.8833,44.9475,3,2],
		[2095,7,7,0,17,89.9292,37.2125,4,2],
		[2102,88,24,0,127,88.5250,-63.0900,6,5],
		[2106,22,2,0,127,89.3833,-35.2833,5,1],
		[2120,22,6,0,127,89.7875,-42.8153,5,5],
		[2124,59,11,0,41,90.5958,9.6475,5,2],
		[2134,37,24,0,-19,91.0292,23.2633,5,4],
		[2135,59,21,2,42,90.9792,20.1383,6,1],
		[2155,46,7,0,-2,91.5375,-14.9353,6,2],
		[2159,59,12,0,47,91.8917,14.7683,5,1],
		[2199,59,13,0,50,92.9833,14.2089,5,1],
		[2209,88,24,0,127,94.7125,69.3197,6,2],
		[2216,37,6,0,-13,93.7208,22.5067,4,7],
		[2227,54,2,0,-15,93.7125,-6.2747,5,5],
		[2238,50,24,0,-18,94.9042,59.0108,5,2],
		[2261,52,0,0,127,92.5583,-74.7531,6,4],
		[2286,37,11,0,-7,95.7417,22.5136,4,7],
		[2294,19,1,0,-18,95.6750,-17.9558,3,1],
		[2296,22,3,0,127,95.5292,-33.4364,5,4],
		[2298,54,4,0,-12,95.9417,4.5928,5,2],
		[2326,12,0,0,127,95.9875,-52.6958,0,3],
		[2343,37,12,0,-2,97.2417,20.2122,5,1],
		[2356,54,1,0,-9,97.2042,-7.0328,6,1],
		[2385,54,24,0,-7,98.2250,7.3331,6,2],
		[2421,37,2,0,4,99.4292,16.3992,3,2],
		[2429,19,12,2,-13,99.1708,-19.2558,5,5],
		[2451,67,12,0,127,99.4417,-43.1961,4,1],
		[2456,54,24,0,-5,100.2458,9.8956,6,0],
		[2473,37,4,0,7,100.9833,25.1311,4,4],
		[2484,37,13,0,11,101.3208,12.8956,4,3],
		[2491,19,0,0,-11,101.2875,-16.7161,0,2],
		[2506,54,24,0,-2,101.9667,2.4122,5,5],
		[2527,88,24,0,127,105.0167,76.9775,6,5],
		[2540,37,7,0,14,103.1958,33.9611,5,2],
		[2550,64,0,0,127,102.0458,-61.9414,4,2],
		[2560,50,24,0,-5,104.3208,58.4225,5,4],
		[2574,19,7,0,-6,103.5458,-12.0386,5,5],
		[2580,19,14,1,-4,103.5333,-24.1839,5,5],
		[2596,19,8,0,0,104.0333,-17.0542,5,1],
		[2618,19,4,0,1,104.6583,-28.9722,3,1],
		[2650,37,5,0,23,106.0292,20.5703,5,3],
		[2657,19,2,0,3,105.9417,-15.6333,5,1],
		[2689,52,7,0,127,104.1417,-79.4203,6,1],
		[2693,19,3,0,5,107.1000,-26.3933,3,3],
		[2697,37,18,0,26,107.7833,30.2453,5,5],
		[2714,54,3,0,2,107.9667,-0.4928,5,2],
		[2736,86,2,2,127,107.1875,-70.4989,5,5],
		[2763,37,10,0,34,109.5250,16.5403,5,2],
		[2773,67,15,0,127,109.2875,-37.0975,4,5],
		[2777,37,3,0,35,110.0292,21.9822,5,3],
		[2803,86,3,0,127,109.2083,-67.9572,5,3],
		[2818,50,24,0,1,111.6792,49.2114,6,2],
		[2821,37,8,0,40,111.4333,27.7981,5,4],
		[2827,19,6,0,11,111.0250,-29.3031,3,1],
		[2845,20,1,0,-17,111.7875,8.2894,4,1],
		[2891,37,0,0,46,113.6500,31.8883,3,2],
		[2905,37,19,0,49,113.9792,26.8958,5,7],
		[2922,88,24,0,127,113.8458,-28.3694,6,1],
		[2943,20,0,0,-10,114.8250,5.2250,1,3],
		[2948,88,24,0,127,114.7042,-26.8017,6,1],
		[2970,54,0,0,6,115.3125,-9.5511,5,5],
		[2985,37,9,0,57,116.1125,24.3981,5,4],
		[2990,37,1,0,58,116.3292,28.0261,2,5],
		[2996,67,24,0,-17,115.9542,-28.9547,5,2],
		[3045,67,13,0,-13,117.3250,-24.8597,4,4],
		[3117,12,21,0,127,119.1958,-52.9822,4,1],
		[3165,67,5,0,127,120.8958,-40.0033,3,0],
		[3185,67,16,0,-5,121.8875,-24.3042,4,3],
		[3188,54,5,0,9,122.1500,-2.9839,5,4],
		[3207,84,2,2,127,122.3833,-47.3367,3,0],
		[3223,86,4,0,127,121.9833,-68.6172,5,1],
		[3249,21,1,0,-3,124.1292,9.1856,5,5],
		[3275,50,24,0,11,125.7083,43.1881,5,5],
		[3307,12,4,0,127,125.6292,-59.5097,3,5],
		[3318,17,0,0,127,124.6333,-76.9197,5,3],
		[3323,82,14,0,-19,127.5667,60.7181,4,4],
		[3347,86,1,0,127,126.4333,-66.1370,5,5],
		[3410,41,3,0,-16,129.4125,5.7036,5,2],
		[3418,41,17,0,-15,129.6875,3.3414,5,5],
		[3438,68,1,0,127,130.0250,-35.3083,5,4],
		[3449,21,2,0,23,130.8208,21.4686,6,2],
		[3454,41,6,0,-13,130.8083,3.3986,5,1],
		[3461,21,3,0,27,131.1708,18.1542,5,5],
		[3468,68,0,0,127,130.9000,-33.1864,5,1],
		[3475,21,8,0,28,131.6750,28.7600,5,4],
		[3482,41,4,0,-9,131.6958,6.4189,4,4],
		[3485,84,3,0,127,131.1750,-54.7083,3,2],
		[3492,41,16,0,-7,132.1083,5.8378,5,2],
		[3518,68,2,0,127,132.6333,-27.7100,5,5],
		[3547,41,5,0,-4,133.8500,5.9456,4,4],
		[3569,82,8,0,-11,134.8000,48.0417,4,2],
		[3572,21,0,0,45,134.6208,11.8578,5,2],
		[3579,88,24,0,127,135.1583,41.7828,5,3],
		[3594,82,9,0,-8,135.9083,47.1567,5,2],
		[3612,88,24,0,127,136.6333,38.4522,6,4],
		[3615,86,0,0,127,135.6125,-66.3961,5,2],
		[3634,84,10,0,127,137.0000,-43.4325,3,5],
		[3665,41,7,0,2,138.5917,2.3142,5,1],
		[3685,12,1,0,127,138.3000,-69.7172,3,2],
		[3690,50,24,0,18,139.7125,36.8025,5,2],
		[3699,12,8,0,127,139.2708,-59.2753,3,2],
		[3705,50,0,0,20,140.2625,34.3925,4,5],
		[3731,45,9,0,-19,141.1625,26.1822,5,5],
		[3734,84,9,0,127,140.5292,-55.0108,4,1],
		[3748,41,0,0,10,141.8958,-8.6586,3,5],
		[3757,82,24,0,3,142.8833,63.0619,5,3],
		[3765,1,4,0,127,142.3125,-35.9514,6,5],
		[3773,45,10,0,-16,142.9292,22.9681,5,5],
		[3775,82,7,0,5,143.2125,51.6772,4,3],
		[3786,84,22,0,127,142.6750,-40.4667,5,3],
		[3800,48,24,0,-10,143.5542,36.3975,6,4],
		[3845,41,8,0,15,144.9625,-1.1428,5,5],
		[3873,45,4,0,-3,146.4625,23.7742,4,4],
		[3888,82,19,0,9,147.7458,59.0386,5,3],
		[3903,41,19,1,19,147.8708,-14.8467,5,4],
		[3905,45,11,0,4,148.1917,26.0069,5,5],
		[3909,74,2,0,-12,148.1250,-8.1050,6,2],
		[3940,84,20,0,127,149.2167,-54.5678,5,1],
		[3970,41,19,2,20,151.2833,-13.0647,6,1],
		[3974,48,24,0,1,151.8583,35.2447,5,2],
		[3975,45,6,0,10,151.8333,16.7628,5,2],
		[3981,74,0,0,-5,151.9833,-0.3717,5,2],
		[3982,45,0,0,12,152.0917,11.9672,2,1],
		[3994,41,10,0,21,152.6458,-12.3542,5,5],
		[4023,88,24,0,127,153.6833,-42.1219,5,2],
		[4031,45,5,0,16,154.1708,23.4172,4,3],
		[4033,82,10,0,13,154.2750,42.9144,4,2],
		[4037,12,23,0,127,153.4333,-70.0381,4,1],
		[4050,88,24,0,127,154.2708,-61.3322,4,5],
		[4057,45,2,1,21,154.9917,19.8417,4,5],
		[4069,82,11,0,14,155.5833,41.4994,4,7],
		[4090,48,24,0,10,156.4792,33.7961,6,3],
		[4094,41,11,0,22,156.5208,-16.8364,5,5],
		[4100,48,1,0,11,156.9708,36.7072,5,4],
		[4104,1,0,0,127,156.7875,-31.0678,5,5],
		[4116,74,3,0,9,157.3708,-2.7392,6,1],
		[4119,74,1,0,10,157.5750,-0.6369,6,1],
		[4140,88,24,0,127,158.0042,-61.6853,4,1],
		[4174,17,2,0,127,158.8667,-78.6078,5,7],
		[4199,12,7,0,127,160.7375,-64.3945,4,1],
		[4216,84,11,0,127,161.6917,-49.4200,4,4],
		[4232,41,12,0,127,162.4083,-16.1936,4,5],
		[4234,17,3,2,127,161.4458,-80.5403,5,1],
		[4247,48,24,0,26,163.3292,34.2150,5,5],
		[4273,1,8,0,127,164.1792,-37.1378,6,5],
		[4287,26,0,0,-13,164.9458,-18.2989,5,5],
		[4295,82,1,0,28,165.4625,56.3825,3,2],
		[4301,82,0,0,30,165.9333,61.7508,3,5],
		[4335,82,22,0,32,167.4167,44.4986,4,5],
		[4343,26,1,0,-9,167.9167,-22.8258,5,2],
		[4357,45,3,0,48,168.5292,20.5236,4,2],
		[4359,45,7,0,50,168.5583,15.4294,4,2],
		[4375,82,13,0,33,169.5458,31.5292,5,4],
		[4377,82,12,0,34,169.6208,33.0942,4,5],
		[4382,26,3,0,-8,169.8375,-14.7786,5,4],
		[4386,45,17,0,57,170.2833,6.0294,5,1],
		[4390,14,15,0,127,170.2500,-54.4911,5,1],
		[4399,45,8,0,58,170.9833,10.5292,5,3],
		[4402,26,4,0,-6,171.1542,-10.8594,6,5],
		[4405,26,2,0,-5,171.2208,-17.6839,5,2],
		[4434,33,10,0,-19,172.8500,69.3311,5,7],
		[4441,14,14,1,127,172.9417,-59.4422,6,4],
		[4450,41,13,0,127,173.2500,-31.8578,5,4],
		[4468,26,7,0,1,174.1708,-9.8022,6,1],
		[4514,26,5,0,7,176.1917,-18.3508,6,4],
		[4517,85,12,0,-17,176.4667,6.5294,5,7],
		[4518,82,21,0,43,176.5125,47.7794,5,5],
		[4520,55,10,0,127,176.4000,-66.7286,5,2],
		[4534,45,1,0,74,177.2667,14.5719,3,2],
		[4540,85,1,0,-15,177.6750,1.7647,5,3],
		[4552,41,1,0,127,178.2292,-33.9081,5,1],
		[4554,82,2,0,44,178.4583,53.6947,3,2],
		[4567,26,6,0,10,179.0042,-17.1508,6,2],
		[4583,17,4,0,127,179.9042,-78.2220,6,1],
		[4608,85,14,0,-11,181.3042,8.7331,5,4],
		[4621,14,3,0,127,182.0917,-50.7225,4,1],
		[4623,28,0,0,-19,182.1042,-24.7289,5,3],
		[4630,28,4,0,-18,182.5333,-22.6197,4,5],
		[4638,14,16,0,127,182.9125,-52.3686,5,1],
		[4656,27,3,0,127,183.7875,-58.7489,4,1],
		[4660,82,3,0,49,183.8583,57.0325,4,2],
		[4662,28,2,0,-16,183.9500,-17.5419,4,1],
		[4671,55,4,0,127,184.3917,-67.9608,5,7],
		[4674,17,1,0,127,184.5875,-79.3122,5,1],
		[4689,85,6,0,-5,184.9750,-0.6669,5,2],
		[4730,27,0,1,127,186.6500,-63.0992,2,1],
		[4737,23,2,0,-5,186.7333,28.2683,5,5],
		[4743,14,17,0,127,187.0083,-50.2306,5,1],
		[4757,28,3,0,-13,187.4667,-16.5156,4,1],
		[4763,27,2,0,127,187.7917,-57.1133,3,7],
		[4773,55,2,0,127,188.1167,-72.1331,5,1],
		[4785,29,1,0,-12,188.4375,41.3575,5,4],
		[4786,28,1,0,-11,188.5958,-23.3967,4,4],
		[4787,33,9,0,-15,188.3708,69.7883,5,1],
		[4798,55,0,0,127,189.2958,-69.1356,4,1],
		[4817,88,24,0,127,189.9708,-39.9875,6,1],
		[4819,14,2,0,127,190.3792,-48.9597,3,2],
		[4825,85,2,0,9,190.4167,-1.4494,5,3],
		[4844,55,1,0,127,191.5708,-68.1081,4,1],
		[4853,27,1,0,127,191.9292,-59.6886,2,1],
		[4905,82,4,0,57,193.5083,55.9597,3,2],
		[4910,85,3,0,23,193.9000,3.3975,4,7],
		[4915,29,0,2,-8,194.0083,38.3183,4,2],
		[4923,55,3,0,127,195.5667,-71.5489,5,5],
		[4932,85,4,0,27,195.5458,10.9592,4,4],
		[4963,85,7,0,31,197.4875,-5.5389,5,2],
		[4968,23,0,0,22,197.4958,17.5294,6,3],
		[4983,23,1,0,23,197.9667,27.8781,5,3],
		[5020,41,2,0,26,199.7292,-23.1717,4,4],
		[5028,14,8,0,127,200.1500,-36.7122,4,2],
		[5054,82,5,0,59,200.9833,54.9253,3,2],
		[5056,85,0,0,47,201.3000,-11.1614,2,1],
		[5089,88,24,0,127,202.7625,-39.4075,5,4],
		[5107,85,5,0,59,203.6750,-0.5958,4,2],
		[5132,14,4,0,127,204.9708,-53.4664,3,1],
		[5185,8,18,0,-16,206.8167,17.4567,6,3],
		[5190,14,12,0,127,207.3750,-41.6878,4,1],
		[5191,82,6,0,65,206.8833,49.3133,3,1],
		[5193,14,11,0,127,207.4042,-42.4739,4,1],
		[5231,14,5,0,127,208.8833,-47.2883,4,1],
		[5235,8,6,0,-12,208.6708,18.3978,4,4],
		[5248,14,20,0,127,209.5667,-42.1008,5,1],
		[5249,14,19,1,127,209.6708,-44.8036,5,1],
		[5264,85,18,0,73,210.4125,1.5444,5,2],
		[5267,14,1,0,127,210.9542,-60.3731,2,1],
		[5285,14,21,0,127,211.5125,-41.1797,5,1],
		[5287,41,15,0,29,211.5917,-26.6825,4,5],
		[5288,14,7,0,-15,211.6708,-36.3700,3,5],
		[5291,33,0,0,-9,211.0958,64.3758,5,2],
		[5329,8,9,2,-3,213.3708,51.7903,6,2],
		[5338,85,8,0,79,214.0042,-6.0006,5,3],
		[5339,57,3,0,127,216.7292,-83.6678,5,5],
		[5340,8,0,0,-4,213.9167,19.1825,1,5],
		[5351,8,10,0,-1,214.0958,46.0883,5,2],
		[5367,14,22,0,127,215.1375,-37.8853,5,2],
		[5404,8,7,0,3,216.3000,51.8508,5,3],
		[5429,8,16,0,5,217.9583,30.3714,5,5],
		[5435,8,2,0,7,218.0208,38.3083,4,2],
		[5440,14,6,0,127,218.8750,-42.1578,3,1],
		[5459,14,0,1,127,219.9000,-60.8353,1,4],
		[5463,18,0,0,127,220.6250,-64.9753,4,2],
		[5469,49,0,0,127,220.4833,-47.3883,3,1],
		[5470,2,0,0,127,221.9667,-79.0447,5,5],
		[5478,8,5,0,10,220.2875,13.7283,5,2],
		[5487,85,11,0,87,220.7667,-5.6583,5,3],
		[5506,8,4,0,16,221.2458,27.0742,4,5],
		[5511,85,24,0,89,221.5625,1.8928,5,2],
		[5526,41,24,0,38,222.5708,-27.9603,5,5],
		[5531,47,0,2,-11,222.7208,-16.0417,4,2],
		[5563,83,1,0,-13,222.6750,74.1556,3,5],
		[5571,49,1,0,127,224.6333,-43.1339,4,1],
		[5576,14,9,0,127,224.7917,-42.1042,4,1],
		[5602,8,1,0,22,225.4875,40.3906,5,4],
		[5603,47,17,0,0,226.0167,-25.2819,4,7],
		[5649,49,5,0,127,228.0708,-52.0992,4,4],
		[5670,18,1,0,127,229.3792,-58.8011,5,2],
		[5671,79,2,0,127,229.7292,-68.6794,4,2],
		[5681,8,3,0,29,228.8750,33.3147,4,4],
		[5683,49,11,0,127,229.6333,-47.8750,5,1],
		[5685,47,1,0,7,229.2500,-9.3831,4,1],
		[5695,49,3,0,127,230.3417,-40.6475,4,1],
		[5704,18,2,0,127,230.8458,-59.3208,6,1],
		[5708,49,4,0,127,230.6708,-44.6894,4,1],
		[5735,83,2,0,-7,230.1833,71.8339,4,2],
		[5744,33,8,0,-8,231.2333,58.9661,4,5],
		[5747,25,1,0,-17,231.9583,29.1058,5,3],
		[5776,49,2,0,127,233.7875,-41.1669,4,1],
		[5778,25,7,0,-16,233.2333,31.3592,5,1],
		[5787,47,2,0,18,233.8833,-14.7894,5,4],
		[5788,73,3,0,-7,233.7000,10.5375,5,3],
		[5793,25,0,0,-15,233.6708,26.7147,3,2],
		[5794,47,19,0,19,234.2583,-28.1350,5,5],
		[5812,47,18,0,20,234.6625,-29.7778,5,1],
		[5820,49,22,1,-17,234.9417,-34.4119,6,4],
		[5842,73,8,0,1,235.3875,19.6703,6,2],
		[5849,25,2,0,-12,235.6875,26.2956,5,1],
		[5854,73,0,0,4,236.0667,6.4256,4,5],
		[5867,73,1,0,8,236.5458,15.4219,5,2],
		[5879,73,9,0,15,237.1833,18.1417,5,7],
		[5881,73,11,0,12,237.4042,-3.4303,5,2],
		[5883,49,21,0,-15,237.7417,-33.6272,5,1],
		[5889,25,3,0,-10,237.4000,26.0683,6,4],
		[5892,73,4,0,17,237.7042,4.4778,5,2],
		[5897,79,1,0,127,238.7875,-63.4306,4,3],
		[5903,83,5,0,-4,236.0167,77.7944,5,2],
		[5914,39,21,0,-19,238.1708,42.4517,6,3],
		[5928,71,16,0,-15,239.2208,-29.2142,5,1],
		[5933,73,2,0,21,239.1125,15.6617,5,3],
		[5944,71,15,0,-14,239.7125,-26.1142,4,1],
		[5947,25,4,0,-7,239.3958,26.8778,5,5],
		[5948,49,6,0,127,240.0292,-38.3969,4,1],
		[5953,71,3,0,-13,240.0833,-22.6217,3,1],
		[5962,56,6,0,127,240.8042,-49.2297,6,4],
		[5971,25,8,0,-6,240.3625,29.8511,6,2],
		[5980,56,3,0,127,241.6208,-45.1733,6,2],
		[5984,71,1,1,-12,241.3583,-19.8056,4,1],
		[5986,33,7,0,-7,240.4708,58.5653,5,3],
		[6020,2,3,1,127,245.0875,-78.6958,6,7],
		[6023,39,20,0,-9,242.1917,44.9350,5,1],
		[6027,71,12,0,-6,243.0000,-19.4606,5,1],
		[6056,58,3,0,-19,243.5875,-3.6944,4,7],
		[6072,56,2,2,127,244.9583,-50.1556,5,4],
		[6075,58,4,0,-18,244.5792,-4.6925,4,4],
		[6084,71,17,0,0,245.2958,-25.5928,4,1],
		[6092,39,18,0,2,244.9333,46.3133,5,1],
		[6095,39,2,0,0,245.4792,19.1531,5,2],
		[6102,2,2,0,127,248.3625,-78.8972,5,4],
		[6104,58,22,0,-16,246.0250,-20.0375,6,5],
		[6112,58,16,0,-15,246.3958,-23.4472,6,1],
		[6115,56,4,0,127,246.7958,-47.5550,5,1],
		[6116,83,6,0,1,244.3750,75.7553,6,3],
		[6117,39,23,0,4,246.3542,14.0333,6,1],
		[6118,58,21,0,-13,246.7542,-18.4564,5,1],
		[6129,58,19,0,-17,246.9500,-8.3717,6,2],
		[6132,33,6,0,-6,246.0000,61.5142,4,4],
		[6134,71,0,0,1,247.3500,-26.4319,2,7],
		[6147,58,20,0,-12,247.7833,-16.6128,5,4],
		[6148,39,1,0,7,247.5542,21.4897,4,4],
		[6149,58,10,0,-10,247.7292,1.9839,5,2],
		[6159,39,24,0,9,248.1500,11.4881,6,5],
		[6163,2,1,0,127,250.7708,-77.5175,5,5],
		[6165,71,18,0,3,248.9708,-28.2161,4,1],
		[6168,39,17,0,15,248.5250,42.4369,5,1],
		[6175,58,5,0,-7,249.2917,-10.5672,4,0],
		[6212,39,5,0,20,250.3208,31.6031,4,4],
		[6217,79,0,0,127,252.1667,-69.0278,3,5],
		[6220,39,6,0,24,250.7250,38.9222,5,4],
		[6229,5,6,0,127,252.4458,-59.0414,5,5],
		[6241,71,4,0,6,252.5417,-34.2933,3,5],
		[6247,71,11,1,127,252.9667,-38.0475,4,1],
		[6271,71,5,2,127,253.6458,-42.3614,5,5],
		[6285,5,5,0,127,254.6542,-55.9903,4,5],
		[6295,5,4,1,127,254.8958,-53.1606,5,5],
		[6299,58,9,0,7,254.4167,9.3750,4,5],
		[6322,83,4,0,2,251.4917,82.0372,5,4],
		[6324,39,4,0,38,255.0708,30.9264,5,2],
		[6378,58,6,0,15,257.5958,-15.7247,3,2],
		[6380,71,6,0,127,258.0375,-43.2392,4,3],
		[6396,33,5,0,2,257.1958,65.7147,4,1],
		[6406,39,0,1,44,258.6625,14.3903,4,7],
		[6410,39,3,0,45,258.7583,24.8392,4,2],
		[6418,39,15,0,47,258.7625,36.8092,4,5],
		[6453,58,7,0,22,260.5042,-24.9994,4,1],
		[6461,5,1,0,127,261.3250,-55.5300,4,5],
		[6462,5,2,0,127,261.3500,-56.3775,4,1],
		[6484,39,16,0,55,260.9208,37.1467,6,2],
		[6492,58,24,0,25,261.8375,-29.8669,5,3],
		[6500,5,3,0,127,262.7750,-60.6839,5,1],
		[6508,71,19,0,14,262.6917,-37.2958,4,1],
		[6510,5,0,0,127,262.9625,-49.8761,4,1],
		[6526,39,10,0,56,262.6833,26.1106,5,5],
		[6527,71,10,0,15,263.4042,-37.1039,3,1],
		[6536,33,1,0,3,262.6083,52.3014,4,4],
		[6553,71,7,0,127,264.3292,-42.9978,3,3],
		[6554,33,12,1,4,263.0458,55.1842,6,2],
		[6556,58,0,0,35,263.7333,12.5600,3,2],
		[6561,73,13,0,35,264.3958,-15.3986,5,3],
		[6580,71,9,0,127,265.6208,-39.0300,3,1],
		[6582,60,6,0,127,266.4333,-64.7239,5,5],
		[6588,39,8,0,65,264.8667,46.0064,5,1],
		[6603,58,1,0,40,265.8667,4.5672,4,5],
		[6615,71,8,1,127,266.8958,-40.1269,4,3],
		[6623,39,11,0,66,266.6167,27.7206,4,4],
		[6629,58,2,0,42,266.9750,2.7072,5,2],
		[6630,88,24,0,127,267.4667,-37.0433,4,5],
		[6688,33,13,0,12,268.3833,56.8728,5,5],
		[6695,39,7,0,71,269.0625,37.2506,5,5],
		[6698,58,12,0,44,269.7583,-9.7736,4,5],
		[6703,39,13,0,72,269.4417,29.2478,5,4],
		[6705,33,2,0,13,269.1500,51.4889,3,5],
		[6743,5,7,0,127,271.6583,-50.0917,5,1],
		[6745,60,15,0,127,272.1458,-63.6683,5,2],
		[6746,76,2,2,-10,271.4542,-30.4242,4,5],
		[6779,39,14,0,83,271.8875,28.7625,5,1],
		[6783,78,4,0,127,272.8083,-45.9544,6,5],
		[6789,83,3,0,3,263.0542,86.5864,5,2],
		[6812,76,11,0,-7,273.4417,-21.0589,5,1],
		[6832,76,6,0,127,274.4083,-36.7617,4,7],
		[6855,60,13,0,127,275.8083,-61.4939,5,5],
		[6859,76,3,0,-1,275.2500,-29.8281,4,5],
		[6869,73,6,0,38,275.3292,-2.8989,4,5],
		[6879,76,4,0,0,276.0417,-34.3847,3,1],
		[6897,78,0,0,127,276.7417,-45.9683,5,1],
		[6905,78,5,0,127,277.2083,-49.0708,5,4],
		[6913,76,10,0,2,276.9917,-25.4217,4,5],
		[6920,33,20,0,23,275.1917,71.3378,5,2],
		[6927,33,21,0,24,275.2625,72.7328,5,3],
		[6930,72,2,0,127,277.3000,-14.5658,6,2],
		[6951,24,7,0,127,278.3750,-42.3125,6,4],
		[6973,72,0,0,127,278.8000,-8.2442,5,5],
		[6982,60,5,0,127,280.7583,-71.4281,5,5],
		[7001,51,0,0,-17,279.2333,38.7836,1,2],
		[7020,72,3,0,127,280.5667,-9.0525,6,3],
		[7039,76,20,0,7,281.4125,-26.9908,4,1],
		[7051,51,4,1,-16,281.0833,39.6700,6,2],
		[7056,51,5,1,-14,281.1917,37.6050,5,2],
		[7063,72,1,0,127,281.7958,-4.7478,5,4],
		[7074,60,10,0,127,283.0542,-62.1875,5,1],
		[7106,51,1,0,-10,282.5208,33.3628,4,1],
		[7107,60,9,0,127,284.2375,-67.2336,5,3],
		[7121,76,17,0,14,283.8167,-26.2967,3,1],
		[7139,51,3,2,-8,283.6250,36.8989,5,7],
		[7141,73,7,1,43,284.0542,4.2036,6,2],
		[7176,3,4,0,-7,284.9042,15.0683,5,5],
		[7178,51,2,0,-6,284.7375,32.6894,4,1],
		[7193,3,24,0,-8,285.4208,-5.7389,5,5],
		[7194,76,5,0,18,285.6542,-29.8803,4,2],
		[7226,24,2,0,127,286.6042,-37.0633,6,3],
		[7234,76,18,0,20,286.7333,-27.6706,4,5],
		[7235,3,5,0,-3,286.3542,13.8633,4,2],
		[7236,3,10,0,-4,286.5625,-4.8825,4,1],
		[7242,24,3,0,127,287.0875,-40.4967,6,5],
		[7254,24,0,0,127,287.3667,-37.9044,5,2],
		[7259,24,1,0,127,287.5083,-39.3408,5,5],
		[7310,33,3,0,37,288.1375,67.6617,4,4],
		[7328,30,9,0,-19,289.2750,53.3686,5,4],
		[7377,3,3,0,10,291.3750,3.1147,4,3],
		[7405,87,0,0,-14,292.1750,24.6650,5,7],
		[7417,30,1,1,-14,292.6792,27.9597,4,5],
		[7420,30,8,2,-10,292.4250,51.7297,5,2],
		[7447,3,8,0,21,294.1792,-1.2864,5,1],
		[7479,75,0,0,-15,295.0250,18.0139,5,4],
		[7488,75,1,0,-14,295.2625,17.4761,5,4],
		[7525,3,2,0,30,296.5667,10.6133,4,5],
		[7528,30,3,0,-2,296.2458,45.1308,4,1],
		[7536,75,3,0,-13,296.8458,18.5342,5,7],
		[7557,3,0,0,33,297.6958,8.8683,2,2],
		[7570,3,6,0,35,298.1167,1.0056,5,3],
		[7582,33,4,0,43,297.0417,70.2678,5,4],
		[7590,60,4,0,127,300.1500,-72.9106,5,2],
		[7592,87,24,0,-7,298.3667,24.0797,6,1],
		[7602,3,1,0,40,298.8292,6.4067,5,4],
		[7635,75,2,0,-8,299.6875,19.4922,4,7],
		[7665,60,3,0,127,302.1833,-66.1819,5,4],
		[7710,3,7,0,45,302.8250,-0.8214,4,1],
		[7747,11,0,0,-15,304.4125,-12.5083,5,4],
		[7776,11,1,0,-11,305.2542,-14.7814,4,3],
		[7790,60,0,0,127,306.4125,-56.7350,3,1],
		[7796,30,2,0,17,305.5583,40.2567,3,3],
		[7850,15,7,0,-18,307.3958,62.9942,5,2],
		[7852,31,4,0,-18,308.3042,11.3033,5,1],
		[7869,43,0,0,127,309.3917,-47.2914,4,5],
		[7882,31,1,0,-14,309.3875,14.5953,5,3],
		[7906,31,0,0,-11,309.9083,15.9119,5,1],
		[7913,60,1,0,127,311.2417,-66.2031,4,2],
		[7920,43,6,0,127,311.0083,-51.9211,6,2],
		[7924,30,0,0,30,310.3583,45.2803,2,2],
		[7928,31,3,0,-9,310.8667,15.0744,5,2],
		[7936,11,22,0,-4,311.5250,-25.2708,5,3],
		[7948,31,2,2,-8,311.6667,16.1242,5,5],
		[7949,30,4,0,33,311.5542,33.9703,3,5],
		[7950,4,4,0,-18,311.9208,-9.4958,5,2],
		[7957,15,6,0,-17,311.3208,61.8389,4,5],
		[7965,53,0,0,127,312.4917,-33.7797,6,4],
		[7980,11,23,0,-2,312.9542,-26.9192,5,7],
		[7986,43,1,0,127,313.7042,-58.4542,5,5],
		[8039,53,2,0,127,315.3250,-32.2578,6,4],
		[8048,53,5,0,127,315.7417,-38.6317,6,3],
		[8075,11,7,0,3,316.4875,-17.2328,5,2],
		[8097,34,2,0,-15,317.5875,10.1317,6,3],
		[8115,30,5,0,44,318.2333,30.2269,4,4],
		[8123,34,3,0,-13,318.6208,10.0069,5,3],
		[8131,34,0,0,-12,318.9542,5.2478,5,4],
		[8140,43,7,0,127,319.9667,-53.4497,5,2],
		[8162,15,0,0,-15,319.6458,62.5856,3,2],
		[8181,60,2,0,127,321.6125,-65.3661,5,3],
		[8204,11,5,0,14,321.6667,-22.4114,5,4],
		[8232,4,1,0,2,322.8917,-5.5711,4,4],
		[8238,15,1,0,-12,322.1667,70.5608,4,1],
		[8254,57,12,0,127,325.3708,-77.3900,5,5],
		[8260,11,4,0,19,324.2708,-19.4661,6,1],
		[8278,11,2,0,20,325.0250,-16.6622,5,3],
		[8305,65,8,0,-11,326.2375,-33.0258,5,2],
		[8308,61,4,0,-12,326.0458,9.8750,3,5],
		[8315,61,9,0,-10,326.1625,25.6450,5,3],
		[8316,15,11,0,127,325.8750,58.7800,5,7],
		[8322,11,3,0,29,326.7583,-16.1272,4,2],
		[8326,65,7,0,-10,326.9333,-30.8983,6,2],
		[8353,38,2,0,127,328.4833,-37.3650,4,1],
		[8368,43,3,0,127,329.4792,-54.9925,5,3],
		[8411,38,10,0,127,331.5292,-39.5433,5,5],
		[8414,4,0,0,14,331.4458,-0.3197,4,4],
		[8418,4,8,0,13,331.6083,-13.8697,5,1],
		[8425,38,0,0,127,332.0583,-46.9611,3,1],
		[8430,61,8,0,4,331.7542,25.3450,5,3],
		[8431,65,11,0,-6,332.0958,-32.9886,6,2],
		[8450,61,7,0,6,332.5500,6.1978,5,2],
		[8454,61,15,2,9,332.4958,33.1783,5,3],
		[8465,15,5,0,1,332.7125,58.2011,4,5],
		[8485,88,24,0,127,333.4708,39.7150,5,5],
		[8486,38,11,1,127,333.9042,-41.3467,6,4],
		[8494,15,4,0,3,333.7583,57.0436,5,3],
		[8498,44,24,0,-19,333.9917,37.7489,5,5],
		[8499,4,7,0,23,334.2083,-7.7833,5,4],
		[8502,81,0,0,127,334.6250,-60.2597,4,5],
		[8518,4,2,0,28,335.4125,-1.3872,5,2],
		[8523,44,24,0,-18,335.2583,46.5367,6,1],
		[8538,44,1,0,-17,335.8917,52.2292,5,4],
		[8539,4,15,0,32,336.3208,1.3775,6,1],
		[8540,81,3,0,127,336.8333,-64.9664,5,1],
		[8541,44,24,0,-16,336.1292,49.4764,6,1],
		[8556,38,3,1,127,337.3167,-43.4956,5,4],
		[8558,4,5,1,35,337.2083,-0.0203,6,3],
		[8571,15,3,0,7,337.2917,58.4153,5,3],
		[8572,44,24,0,-15,337.3833,47.7069,5,7],
		[8576,65,1,0,-3,337.8750,-32.3461,5,2],
		[8579,44,24,0,-14,337.6208,43.1233,6,1],
		[8585,44,0,0,-13,337.8250,50.2825,5,2],
		[8597,4,6,0,42,338.8375,-0.1175,5,1],
		[8628,65,4,0,-2,340.1625,-27.0436,5,1],
		[8630,57,1,0,127,341.5125,-81.3817,5,2],
		[8632,44,24,0,-9,340.1292,44.2764,5,5],
		[8634,61,5,0,22,340.3667,10.8314,4,1],
		[8636,38,1,0,127,340.6667,-46.8847,3,7],
		[8650,61,6,0,24,340.7500,30.2214,4,4],
		[8667,61,10,0,27,341.6333,23.5656,5,4],
		[8675,38,4,0,127,342.1375,-51.3169,4,2],
		[8679,4,18,2,51,342.4000,-13.5925,5,7],
		[8684,61,11,0,28,342.5000,24.6017,4,4],
		[8694,15,8,0,12,342.4208,66.2006,5,5],
		[8695,65,2,0,2,343.1333,-32.8756,5,2],
		[8698,4,10,0,53,343.1542,-7.5797,5,7],
		[8709,4,3,0,56,343.6625,-15.8208,4,2],
		[8720,65,3,0,3,343.9875,-32.5397,5,4],
		[8728,65,0,0,4,344.4125,-29.6222,2,2],
		[8747,38,5,0,127,345.2208,-52.7542,5,4],
		[8762,0,14,0,-19,345.4792,42.3261,5,1],
		[8775,61,1,0,33,345.9458,28.0828,3,7],
		[8781,61,0,0,34,346.1917,15.2053,3,1],
		[8812,4,24,0,68,347.3625,-21.1725,5,5],
		[8834,4,20,0,70,348.5792,-6.0489,5,7],
		[8848,81,2,0,127,349.3583,-58.2358,5,3],
		[8852,66,2,0,-14,349.2917,3.2822,5,4],
		[8858,4,22,2,73,349.4750,-9.1825,5,1],
		[8863,70,2,0,127,349.7042,-32.5319,5,5],
		[8892,4,24,0,78,350.7417,-20.1006,5,5],
		[8911,66,9,0,-12,351.7333,1.2556,6,2],
		[8916,66,7,0,-10,351.9917,6.3789,5,5],
		[8937,70,1,0,127,353.2417,-37.8183,5,1],
		[8961,0,10,0,-4,354.3917,46.4581,5,4],
		[8965,0,8,0,-3,354.5333,43.2681,5,1],
		[8969,66,8,0,-3,354.9875,5.6264,5,3],
		[8974,15,2,0,15,354.8375,77.6325,4,5],
		[8976,0,9,0,-1,355.1042,44.3339,5,1],
		[8984,66,10,0,-2,355.5125,1.7800,6,2],
		[9016,70,3,0,127,357.2333,-28.1303,6,2],
		[9072,66,23,0,8,359.8292,6.8633,5,3],
		[9076,81,4,0,127,359.9792,-65.5772,6,1]]
}
