/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fuhU
 */

// forked from 9re's 車が動くアニメーション
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class AnimationExample extends Sprite
    {
        // 車のクラス
        private var _car:Car;
        
        public function AnimationExample() 
        {
            // 車のクラスのインスタンスを作る
            // 色は赤にする
            _car = new Car(0xd00000);
            _car.putGas(50)        // ガソリンを50入れる
            _car.y = 200;          // 車のy座標を200に
            addChild(_car);        // 表示リストに追加
            
            // 1フレーム毎に実行する処理にmoveCarを追加する
            addEventListener(Event.ENTER_FRAME, moveCar);
        }
        
        private function moveCar(e:Event):void 
        {
            _car.move();           // 車を動かす
        }
    } 
}

import flash.display.Sprite;

class Car extends Sprite {
	
	private var _gas:int = 0;
	//private var _amount:int;
	
	public function Car(_fillColor:uint) {
		_draw(_fillColor);
	}
	
	public function putGas(_amount:int):void {
		if (_amount < 0) {
			return;
		}
		_gas += _amount;
	}
	
	public function move():void {
		if (_gas > 10) {
			x += 5;
		} else {
			x += _gas / 2;
		}
		_gas--;
		if (_gas < 0) {
			_gas = 0;
		}
	}
	
	public function _draw(_fillColor:uint):void {
		graphics.beginFill(_fillColor);
		graphics.drawCircle(0, 0, 100);
		graphics.endFill();
	}
}