/**
 * Copyright monodreamer ( http://wonderfl.net/user/monodreamer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/frtz
 */

// forked from xoul's Particle
package
{
    import flash.geom.Rectangle;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    [SWF(width=450, height=450, frameRate=60)]
    
    public class Main extends Sprite
    {
        
        private const NUM_PARTICLES : int = 10000;
        private const SPEED : Number = 1;
        private const MAX_POWER : Number = 100;
        
        private var _canvas : BitmapData;  
        private var _pixels : Vector.<Pixel>;
        
        private var _alphaTransform : ColorTransform;
        private var _blurFilter : BlurFilter;
        
        private var _zeroPoint : Point;
        private var _rect:Rectangle;
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 60;
            
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
            _rect = _canvas.rect;
            addChild( new Bitmap( _canvas ) );
            
            _pixels = new Vector.<Pixel>( NUM_PARTICLES, true );
            
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                var pixel : Pixel = new Pixel;
                pixel.x = Math.random() * stage.stageWidth;
                pixel.y = Math.random() * stage.stageHeight;
                pixel.dx = 0;
                pixel.dy = 0;
                pixel.lastX = pixel.x;
                pixel.lastY = pixel.y;
                pixel.color = 0xFFFFFF;
                _pixels[i] = pixel;
            }
            
            _alphaTransform = new ColorTransform( 1, 1, 1, .9 );
            _blurFilter = new BlurFilter;
            _zeroPoint = new Point;
            
             addChild(new Stats);
             
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            stage.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );           
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.lock();
            _canvas.applyFilter( _canvas, _rect, _zeroPoint, _blurFilter );
            _canvas.colorTransform( _rect, _alphaTransform );
            
            var mx:Number = mouseX, my:Number = mouseY, ox:Number, oy:Number;
            var pixel : Pixel;
            var angle : Number;
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
               pixel = _pixels[i];
                
               ox = pixel.x;
               oy = pixel.y;

               angle = Math.atan2( pixel.y - my, pixel.x - mx );
               //pixel.x += pixel.dx -= SPEED * Math.cos( angle );
               //pixel.y += pixel.dy -= SPEED * Math.sin( angle );

                //drawLine( pixel.lastX, pixel.lastY, pixel.x, pixel.y, pixel.color );
                efla(_canvas, ox, oy, pixel.x = ox + (pixel.dx -= SPEED * Math.cos( angle )), pixel.y = oy + (pixel.dy -= SPEED * Math.sin( angle )) , pixel.color);
                pixel.dx *= .95;
                pixel.dy *= .95;

            }            
            //_canvas.applyFilter( _canvas, _rect, _zeroPoint, _blurFilter );
            _canvas.unlock();
        }
        
        private function onMouseDown( e : MouseEvent ) : void
        {
            var pixel : Pixel;
            var randAngle : Number;
            var randPower : Number;
            
            for( var i : int = 0; i < NUM_PARTICLES; ++i )
            {
                pixel = _pixels[i];
                randAngle = Math.random() * ( Math.PI << 1 );
                randPower = Math.random() * MAX_POWER - ( MAX_POWER >> 1 );
                pixel.dx = randPower * Math.cos( randAngle );
                pixel.dy = randPower * Math.sin( randAngle );
            }
        }
        
        private function drawLine( startX : Number, startY : Number, endX : Number, endY : Number, color : Number ) : void
        {
            var dx : Number = endX - startX;
            var dy : Number = endY - startY;
            var a : Number;
            var b : Number;
            var tmp : Number;
            var len : Number;
            var i : int;
            
            if( getAbs( dx ) > getAbs( dy ) )
            {
                a = dy / dx;
                b = startY;
                
                if( startX > endX )
                {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                    b = endY;
                }
                
                len = endX - startX;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i + startX, i * a + b, color );
                }
            }
            else
            {
                a = dx / dy;
                b = startX;
                
                if( startY > endY )
                {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                    b = endX;
                }
                
                len = endY - startY;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i * a + b, i + startY, color );
                }
            }
        }
        
                // Extremely Fast Line Algorithm : http://wonderfl.net/c/A69m
        private function efla(bmd:BitmapData, x:int, y:int, x2:int, y2:int, color:uint):void {
            var shortLen:int = y2 - y;
            var longLen:int = x2 - x;
            if (!longLen) if (!shortLen) return;
            var i:int, id:int, inc:int;
            var multDiff:Number;
            
            // bmd.lock();
            
            // TODO: check for this above, swap x/y/len and optimize loops to ++ and -- (operators twice as fast, still only 2 loops)
            if ((shortLen ^ (shortLen >> 31)) - (shortLen >> 31) > (longLen ^ (longLen >> 31)) - (longLen >> 31)) {
                if (shortLen < 0) {
                    inc = -1;
                    id = -shortLen % 4;
                } else {
                    inc = 1;
                    id = shortLen % 4;
                }
                multDiff = !shortLen ? longLen : longLen / shortLen;
                
                if (id) {
                    bmd.setPixel32(x, y, color);
                    i += inc;
                    if (--id) {
                        bmd.setPixel32(x + i * multDiff, y + i, color);
                        i += inc;
                        if (--id) {
                            bmd.setPixel32(x + i * multDiff, y + i, color);
                            i += inc;
                        }
                    }
                }
                while (i != shortLen) {
                    bmd.setPixel32(x + i * multDiff, y + i, color);
                    i += inc;
                    bmd.setPixel32(x + i * multDiff, y + i, color);
                    i += inc;
                    bmd.setPixel32(x + i * multDiff, y + i, color);
                    i += inc;
                    bmd.setPixel32(x + i * multDiff, y + i, color);
                    i += inc;
                }
            } else {
                if (longLen < 0) {
                    inc = -1;
                    id = -longLen % 4;
                } else {
                    inc = 1;
                    id = longLen % 4;
                }
                multDiff = !longLen ? shortLen : shortLen / longLen;
                
                if (id) {
                    bmd.setPixel32(x, y, color);
                    i += inc;
                    if (--id) {
                        bmd.setPixel32(x + i, y + i * multDiff, color);
                        i += inc;
                        if (--id) {
                            bmd.setPixel32(x + i, y + i * multDiff, color);
                            i += inc;
                        }
                    }
                }
                while (i != longLen) {
                    bmd.setPixel32(x + i, y + i * multDiff, color);
                    i += inc;
                    bmd.setPixel32(x + i, y + i * multDiff, color);
                    i += inc;
                    bmd.setPixel32(x + i, y + i * multDiff, color);
                    i += inc;
                    bmd.setPixel32(x + i, y + i * multDiff, color);
                    i += inc;
                }
            }
            //bmd.unlock();
        }
        
        private function getAbs( x : Number ) : Number
        {
            return x < 0 ? -x : x;
        }
    }
}

class Pixel {
    public var lastX:Number, lastY:Number, startX:Number, startY:Number, x:Number, y:Number;
    public var color:uint, dx:Number, dy:Number;
}
