/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/frmg
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundTransform;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author nagai
     * sound by AlainMikuni 
     *
     * ピッチを変えてみるテスト
     * 色々気持ち悪い
     * 
     */
    
    [SWF(width="465",height="465")]
    public class Main extends Sprite 
    {
        private var sound:Sound;
        private var sound_mix:Sound;
        private var _right:Sprite;
        private var _left:Sprite;
        
        public function Main():void 
        {
            addChild(new Stats());
            
            var _url:String = "http://www.takasumi-nagai.com/soundfiles/sound004.mp3";
                
            PlaySound(_url);
            
            _left = new Sprite();
            _left.graphics.beginFill(0);
            _left.graphics.drawCircle(0, 0, 5);
            _left.graphics.endFill();
            _left.x = stage.stageWidth / 2;
            _left.y = stage.stageHeight / 2;
            addChild(_left);
            
            _right = new Sprite();
            _right.graphics.beginFill(0);
            _right.graphics.drawCircle(0, 0, 5);
            _right.graphics.endFill();
            _right.x = stage.stageWidth / 2;
            _right.y = stage.stageHeight / 2;
            _right.blendMode="invert";
            addChild(_right);
            
            Wonderfl.capture_delay(16);
        }
        
        private function PlaySound(url:String):void {
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound_mix = new Sound();
            sound = new Sound();
            sound.load(new URLRequest(url), _context);
            sound.addEventListener(Event.COMPLETE, SoundLoadComplete);
        }
        
        private function SoundLoadComplete(e:Event):void 
        {
            sound_mix.addEventListener(SampleDataEvent.SAMPLE_DATA, SoundExtract);
            sound_mix.play(0, 0, new SoundTransform(0.5));
        }
        
        private function SoundExtract(e:SampleDataEvent):void 
        {
            var _byte:ByteArray = new ByteArray();
            sound.extract(_byte, 4096);
            Drawing(_byte);
            e.data.writeBytes(Pitch(_byte));
        }
        
        private function Drawing(_byte:ByteArray):void
        {
            _byte.position = 0;
            
            var _l:Number = 0;
            var _r:Number = 0;
            
            for (var i:int; i < 32; i++)
            {
                _l += _byte.readFloat();
                _r += _byte.readFloat();
            }
            
            _left.scaleX = _left.scaleY = _l;
            _right.scaleX = _right.scaleY = _r;
            
        }
        
        private function Pitch(_byte:ByteArray):ByteArray
        {
            var ba:ByteArray = new ByteArray();
            _byte.position = 0;
            while (_byte.bytesAvailable > 0)
            {
                ba.writeFloat(_byte.readFloat());
                ba.writeFloat(_byte.readFloat());
                if (_byte.bytesAvailable > 0)
                {
                    _byte.position += 8;
                }
            }
            return ba;
        }
        
        
    }
    
}