/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/frJG
 */

package {
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    /**
     * 加法混色と減法混色(1)
     * @author YOSHIDA, Akio (Aquioux)
     * @see http://aquioux.net/blog/?p=2818
     */
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#808080")]
    

    public class Main extends Sprite {
        // 表示オブジェクト
        private var rSp_:Sprite;            // 赤チャンネルのコンテナ
        private var gSp_:Sprite;            // 緑チャンネルのコンテナ
        private var bSp_:Sprite;            // 青チャンネルのコンテナ
        private var backGroundSp_:Sprite;    // ステージを覆う Sprite（ステージ全体の背景色を変えるためのもの）

        // ボタン
        private var modeButton_:PushButton;    // モード切り替えボタン
      
        // ブレンドモード
        private const RGB_BLEND_MODE:String = BlendMode.ADD;
        private const CMY_BLEND_MODE:String = BlendMode.SUBTRACT;
        private var currentBlendMode_:String;
        
        // ステージ塗りつぶし色
        private const RGB_BACKGROUND_COLOR:uint = 0x000000;
        private const CMY_BACKGROUND_COLOR:uint = 0xFFFFFF;
        private var currentFillColor_:uint;
       
        // PushButton のラベル
        private const RGB_LABEL:String = "RGB";
        private const CMY_LABEL:String = "CMY";
        private var currentLabel_:String;
        
        // モード切り替えトグル
        private var toggle_:Boolean;
        

        // コンストラクタ
        public function Main() {
            var size:int = 200;
            
            // 各 BitmapData 生成
            var sourceBmd:BitmapData = new BitmapData(size, size, false, 0xFFFFFF);
            var rBmd:BitmapData = new BitmapData(size, size, false, 0x000000);
            var gBmd:BitmapData = rBmd.clone();
            var bBmd:BitmapData = rBmd.clone();

            // copyChannel 実行
            var rect:Rectangle = new Rectangle(0, 0, size, size);
            var zero:Point = new Point(0, 0);
            rBmd.copyChannel(sourceBmd, rect, zero, BitmapDataChannel.RED,   BitmapDataChannel.RED);
            gBmd.copyChannel(sourceBmd, rect, zero, BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            bBmd.copyChannel(sourceBmd, rect, zero, BitmapDataChannel.BLUE,  BitmapDataChannel.BLUE);
            
            // ステージを覆う Sprite 生成
            backGroundSp_ = new Sprite();
            addChild(backGroundSp_);
            
            // 各チャンネル Sprite 生成（各チャンネル Bitmap をドラッグできるように wrap する）
            rSp_ = new Sprite();
            gSp_ = new Sprite();
            bSp_ = new Sprite();
            rSp_.buttonMode = true;
            gSp_.buttonMode = true;
            bSp_.buttonMode = true;
            rSp_.addChild(new Bitmap(rBmd));
            gSp_.addChild(new Bitmap(gBmd));
            bSp_.addChild(new Bitmap(bBmd));
            
            // 各チャンネル Sprite 初期配置
            var sw:int = stage.stageWidth;
            var sh:int = stage.stageHeight;
            rSp_.x = Math.random() * (sw - size - 20) + 10;
            rSp_.y = Math.random() * (sh - size - 20) + 10;
            gSp_.x = Math.random() * (sw - size - 20) + 10;
            gSp_.y = Math.random() * (sh - size - 20) + 10;
            bSp_.x = Math.random() * (sw - size - 20) + 10;
            bSp_.y = Math.random() * (sh - size - 20) + 10;
            addChild(rSp_);
            addChild(gSp_);
            addChild(bSp_);
            
            // 各チャンネル Sprite にイベントリスナー登録
            rSp_.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            gSp_.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            bSp_.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            rSp_.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            gSp_.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            bSp_.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
           
            var buttonWidth:int = 50;
            // モード切り替えボタン
            modeButton_ = new PushButton(this, 0, 0, "", modeButtonHandler);
            modeButton_.width = buttonWidth;
            
            // 初回表示
            modeButtonHandler(null);
        }
        
        // モード切り替えボタンのイベントハンドラ
        private function modeButtonHandler(event:MouseEvent):void {
            // トグルによる判別
            if (toggle_) {
                // CMY
                currentBlendMode_ = CMY_BLEND_MODE;
                currentFillColor_ = CMY_BACKGROUND_COLOR;
                currentLabel_     = CMY_LABEL;
            } else {
                // RGB
                currentBlendMode_ = RGB_BLEND_MODE;
                currentFillColor_ = RGB_BACKGROUND_COLOR;
                currentLabel_     = RGB_LABEL;
            }
            // トグルをスイッチ
            toggle_ = !toggle_;
            // モード切り替え処理実行
            update();
        }
        // モード切り替え処理
        private function update():void {
            // 各チャンネル Bitmap
            rSp_.blendMode = currentBlendMode_;
            gSp_.blendMode = currentBlendMode_;
            bSp_.blendMode = currentBlendMode_;
            
            // ステージを覆う Sprite
            var g:Graphics = backGroundSp_.graphics;
            g.beginFill(currentFillColor_);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            g.endFill();
            
            // モード切り替えボタンのラベル
            modeButton_.label = currentLabel_;
        }
        
        // 各チャンネル Sprite のマウスイベントハンドラ
        private function mouseDownHandler(event:MouseEvent):void {
            event.target.startDrag();
        }
        private function mouseUpHandler(e:MouseEvent):void {
            e.target.stopDrag();
        }
    }
}
