/**
 * Copyright beinteractive ( http://wonderfl.net/user/beinteractive )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fqit
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	
	public class Sample extends Sprite
	{
		public function Sample()
		{
			var box:Box = addNewBox(30, 100);
			
			// Create a tween
			_t = BetweenAS3.bezier(box,
				{x: 385, y: 207}, // to
				null, // from
				{
					x: [58.05, 145.9, 246.7, 345.55],
					y: [61.4, 80.65, 167.05, 209.3]
				}, // control points
				3.0, // time
				Cubic.easeOut // easing
			);
			
			// Set to be never stop
			_t.stopOnComplete = false;
			
			// Start the tween
			_t.play();
			
			// MouseUp listener
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		
		private var _t:ITween;
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			// Stop the tween if playing
			// Start the tween if stopping
			_t.togglePause();
			
			// Note: You can use gotoAndPlay(time) or gotoAndStop(time) too.
		}
		
		private function addNewBox(x:Number, y:Number):Box
		{
			var box:Box = new Box();
			box.x = x;
			box.y = y;
			addChild(box);
			return box;
		}
	}
}

import flash.display.Sprite;

internal class Box extends Sprite
{
	public function Box()
	{
		graphics.beginFill(0);
		graphics.drawRect(-10, -10, 20, 20);
		graphics.endFill();
	}
}