/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fqGy
 */

// forked from Jacek.Czapczynski's fux-on_sound_XCV54
// forked from flux-on sound
// SiON TENORION for v0.57
package 
{
    import flash.system.*;
    import flash.utils.*;
    import flash.display.*;
    import flash.events.*;
    import flash.text.TextField;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    public class Tenorion extends Sprite 
    {
        private var beatCounter : int;
        private var matrixPad : MatrixPad;
        public function Tenorion() 
        {
            with (addChild(matrixPad = new MatrixPad(stage))) 
            {
                x = y = 72;
            }
            beatCounter = 0;
            var _timer : Timer = new Timer(200);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();
            var sound : Sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSample);
            sound.play();
        } 
        private function timerHandler(evt : TimerEvent) : void
        {
            var beatIndex : int = beatCounter & 15;
            matrixPad.beat(beatIndex);
            beatCounter++;
        }
        private function onSample(e : SampleDataEvent) : void
        {
            var bytes : ByteArray = e.data;
            var pos : Number = e.position;
            var d : Number;
            var p : Number;
            var f : Number;
            var beatIndex : int = beatCounter & 15;
            for (var i : uint = 0; i < 2048; i++)
            {
                d = 0;
                p = pos + i;
                for (var j : int = 0; j < 16; j++) 
                {
                   if (matrixPad.sequences[j] & (1 << beatIndex))
                   {
                       d += Math.sin(p * j * 110) / 2;
                   }
                }
                bytes.writeFloat(d);
                bytes.writeFloat(d);
            }
        }
    }
}
import flash.display.*;
import flash.events.*;
import flash.geom.*;
class MatrixPad extends Bitmap 
{
    public var sequences : Vector.<int> = new Vector.<int>(16);
    private var canvas : Shape = new Shape();
    private var buffer : BitmapData = new BitmapData(320, 320, true, 0);
    private var padOn : BitmapData  = _pad(0x303050, 0x6060a0);
    private var padOff : BitmapData = _pad(0x303050, 0x909040);
    private var pt : Point = new Point();
    private var colt : ColorTransform = new ColorTransform(1, 1, 1, 0.1)
    function MatrixPad(stage : Stage) 
    {
        super(new BitmapData(320, 320, false, 0));
        var i : int;
        for (i = 0; i < 256; i++) 
        {
            pt.x = (i & 15) * 20;
            pt.y = (i & 240) * 1.25;
            buffer.copyPixels(padOff, padOff.rect, pt);
            bitmapData.copyPixels(padOff, padOff.rect, pt);
        }
        for (i = 0; i < 16; i++) sequences[i] = 0;
        addEventListener("enterFrame", _onEnterFrame);
        stage.addEventListener("click",  _onClick);
    }   
    private function _pad(border : int, face : int) : BitmapData 
    {
        var pix : BitmapData = new BitmapData(20, 20, false, 0);
        canvas.graphics.clear();
        canvas.graphics.lineStyle(1, border);
        canvas.graphics.beginFill(face);
        canvas.graphics.drawRect(1, 1, 17, 17);
        canvas.graphics.endFill();
        pix.draw(canvas);
        return pix;
    }
    private function _onEnterFrame(e : Event) : void 
    {
        bitmapData.draw(buffer, null, colt);
    }
    private function _onClick(e : Event) : void 
    {
        if (mouseX >= 0 && mouseX < 320 && mouseY >= 0 && mouseY < 320) 
        {
            var track : int = 15 - int(mouseY * 0.05);
            var beat : int = int(mouseX * 0.05);
            sequences[track] ^= 1 << beat;
            pt.x = beat * 20;
            pt.y = (15 - track) * 20;
            if (sequences[track] & (1 << beat)) buffer.copyPixels(padOn, padOn.rect, pt);
            else buffer.copyPixels(padOff, padOff.rect, pt);
        }
    }
    public function beat(beat16th : int) : void 
    {
        for (pt.x = beat16th * 20, pt.y = 0; pt.y < 320; pt.y += 20) bitmapData.copyPixels(padOn, padOn.rect, pt);
    }
}
