/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fpaL
 */

// forked from yonatan's GPU texture IO benchmark
// forked from wh0's AGAL feedback
package {
    import flash.display.*;
    import flash.display3D.*;
    import flash.display3D.textures.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    import com.bit101.components.*;

    public class FlashTest extends Sprite {
        private var stage3D:Stage3D;
        private var context3D:Context3D;
        private var tex:Texture;
        private const SIZE:int = 512;

        public function FlashTest() {
            //loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, function (e:UncaughtErrorEvent):void { Wonderfl.log(e.error); } );
            if (stage.stage3Ds.length == 0) throw 'no stage3D';
            
            // Obtain a 3D rendering context by requesting one from an instance of Stage3D.
            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, context3DCreate);
            stage3D.requestContext3D();
        }
        
        private function context3DCreate(e:Event):void {
            // The runtime dispatches this when the requested context is ready
            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, context3DCreate);
            context3D = stage3D.context3D;
            context3D.configureBackBuffer(stage.stageWidth, stage.stageHeight, 0, false);
            var bd:BitmapData = new BitmapData(SIZE, SIZE, true, 0x00000000);
            bd.perlinNoise(SIZE, SIZE, 6, 9988, false, true);
            tex = context3D.createTexture(SIZE, SIZE, Context3DTextureFormat.BGRA, true);
            var cnt:int = 0;
            var start:Number = getTimer();
            var seconds:int = 1;
            while(getTimer()-start < seconds*1000) {
                tex.uploadFromBitmapData(bd);
                cnt++;
            }
            StatsCollectorLoader.init(stage, {driver: context3D.driverInfo, MBPS: cnt/seconds});
            new Label(this, 0, 0, context3D.driverInfo + " - " + cnt/seconds + " MB/sec.");
        }
    }
}

import flash.display.*;
import flash.net.*;
import flash.system.*;
class StatsCollectorLoader {
    private static const URL:String = "http://swf.wonderfl.net/swf/usercode/e/e1/e154/e154bcc18ae75cf6c70f29a108e6af3eba3055d6.swf";
    public static function init(stage:Stage, results:Object): void {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener("complete", function(e:*):void { loader.content["init"](stage, results); });
        loader.load(new URLRequest(URL), new LoaderContext(true));
    }
}
