/**
 * Copyright J.J ( http://wonderfl.net/user/J.J )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fo9A
 */

package  {
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display3D.textures.Texture;
    import flash.display3D.Context3DTextureFormat;
    import flash.display.Bitmap;
    import flash.display3D.Program3D;
    import flash.display3D.Context3DProgramType;
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display3D.VertexBuffer3D;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Context3D;
    import flash.display.Stage3D;
    import flash.events.Event;
    import flash.display.Sprite;
    /**

     * @author javid jafari

     */
     
    public class Invert extends Sprite {
        
        private var img_src : Bitmap
        private var c3d : Context3D;
        private var w : int;
        private var h : int;
        private var vertices : Vector.<Number>;
        private var indxBuffer : IndexBuffer3D;
        private var vrtxBuffer : VertexBuffer3D;
        private var tex : Texture;
        private var level : int;

        public function Invert() {
            if(stage) inits()
            else addEventListener(Event.ADDED_TO_STAGE, inits)
        }

        private function inits(event : Event=null) : void {            
            var loader:Loader=new Loader()
           loader.load(new URLRequest('http://www.bongiovi.tw/wonderfl/rock.jpg'),new LoaderContext(true))
           loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded)           
           //onLoaded(null)
        }

        private function onLoaded(event : Event) : void {
            img_src=event.target.content as Bitmap
           // img_src.bitmapData=new BitmapData(256,256,false,0)
          //  img_src.bitmapData.noise(.5,0,255)
            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, CreatedC3d)            
            stage.stage3Ds[0].requestContext3D()
        }
        private function CreatedC3d(event : Event) : void {
          
            w=stage.stageWidth,h=stage.stageHeight
            var s3d:Stage3D=event.target as Stage3D
            c3d=s3d.context3D
            c3d.configureBackBuffer(w, h, 1)
            var o:Number=1
            var offs:Number=1
            vertices=Vector.<Number>([
            -o,o,0,   0,0, offs,
            o,o,0,    1,0, offs,
            o,-o,0,   1,1, offs,
            -o,-o,0,  0,1, offs,
            ])
            indxBuffer=c3d.createIndexBuffer(6)
            indxBuffer.uploadFromVector(Vector.<uint>([0,1,2,0,2,3]), 0, 6)

            vrtxBuffer=c3d.createVertexBuffer(4, 6)
            vrtxBuffer.uploadFromVector(vertices,0,4)

            var bmp:Bitmap=img_src          
            tex=c3d.createTexture(256, 256, Context3DTextureFormat.BGRA, false)
            tex.uploadFromBitmapData(bmp.bitmapData)
                        
            var vertexAssembler:AGALMiniAssembler=new AGALMiniAssembler()
            vertexAssembler.assemble(Context3DProgramType.VERTEX,
            'mov op, va0\n'+
            'mov v0, va1\n'+
            'mov v1, va2\n'
            )
            var fragmentAssembler:AGALMiniAssembler=new AGALMiniAssembler()
            fragmentAssembler.assemble(Context3DProgramType.FRAGMENT, 
            'tex ft0, v0, fs0 <2d,linear,nomip>\n'+

            'sub ft1.x, v1.x, ft0.x\n'+

            'sub ft1.y, v1.x, ft0.y\n'+

            'sub ft1.z, v1.x, ft0.z\n'+

            'mov ft0.x, ft1.x\n'+

            'mov ft0.y, ft1.y\n'+

            'mov ft0.z, ft1.z\n'+

            'mov oc, ft0\n')                        
            var p3d:Program3D=c3d.createProgram()
            p3d.upload(vertexAssembler.agalcode, fragmentAssembler.agalcode)
            //set data
            c3d.setVertexBufferAt(0, vrtxBuffer,0,'float3')
            c3d.setVertexBufferAt(1, vrtxBuffer,3,'float2')
            c3d.setVertexBufferAt(2, vrtxBuffer,5,'float1')
            c3d.setTextureAt(0, tex)
            c3d.setProgram(p3d)
            addEventListener(Event.ENTER_FRAME, loop)

        }



        private function loop(event : Event) : void {
            c3d.clear()
            c3d.drawTriangles(indxBuffer)
            c3d.present()

        }

    }

}

