/**
 * Copyright hogefuga ( http://wonderfl.net/user/hogefuga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fnqB
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    public class Main extends Sprite {
        private var count:int = 0;
        private var bmd:BitmapData;
        private var ct:ColorTransform;
        private var s:Sprite;
        private var pmx:Number;
        private var pmy:Number;
        
        public function Main() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            bmd = new BitmapData(465, 465, false, 0);
            ct = new ColorTransform(0.98, 0.98, 0.98);
            s = new Sprite();
            pmx = mouseX;
            pmy = mouseY;
            addChild(new Bitmap(bmd));
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            count++;
            s.graphics.clear();
            var d:Number = 0.5 * Math.sqrt((mouseX - pmx) * (mouseX - pmx) + (mouseY - pmy) * (mouseY - pmy));
            var r:int = (Math.sin(count * 0.1) * 0.25 + 0.75) * 255;
            var g:int = (Math.sin(count * 0.15) * 0.25 + 0.75) * 255;
            var b:int = (Math.sin(count * 0.21) * 0.25 + 0.75) * 255;
            s.graphics.beginFill(r << 16 | g << 8 | b, 1 / (1 + d * 0.02));
            s.graphics.drawCircle((mouseX + pmx) * 0.5, (mouseY + pmy) * 0.5, d);
            s.graphics.endFill();
            pmx = mouseX;
            pmy = mouseY;
            bmd.draw(s);
            bmd.colorTransform(bmd.rect, ct);
        }
    
    }

}