/**
 * Copyright Test_Dept ( http://wonderfl.net/user/Test_Dept )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fniD
 */

package {

	import flash.display.Sprite;

	/**
	 * GeomTest
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#ffffff", width="465", height="465")]
	public class GeomTest extends Sprite {
		public function GeomTest() {
			addChild(new GeomTestImpl() );	
		}		
	}
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFieldType;

class GeomTestImpl extends Sprite {
		
	private var _a : UIPoint;
	private var _b : UIPoint;
	private var _c : UIPoint;
	private var _d : UIPoint;
	private var _o : UIPoint;
	private var _p : UIPoint;

	public function GeomTestImpl() {
		addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
	}
	
	private function addedToStageHandler(event : Event) : void {

		addChild(_a = new UIPoint(0x000000, 50, 400, "a", true) );
		addChild(_b = new UIPoint(0x000000, 400, 50, "b", true) );
		addChild(_c = new UIPoint(0x000000, 300, 300, "c", true) );
		addChild(_o = new UIPoint(0x000000, 30, 430, "o", true) );
		addChild(_p = new UIPoint(0x000000, 0, 0, "p") );
		addChild(_d = new UIPoint(0x000000, 0, 0, "c'") );

		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(event : Event) : void {

		var a : Point = new Point(_a.x, _a.y);
		var b : Point = new Point(_b.x, _b.y);
		var c : Point = new Point(_c.x, _c.y);
		var o : Point = new Point(_o.x, _o.y);
				
		var ref_c : Point = GeoUtil.getCRef(a, b, c);
		_d.x = ref_c.x;
		_d.y = ref_c.y;

		var p_bc : Point = GeoUtil.getCrossPoint(o, a, b, ref_c);
		var p_ac : Point = GeoUtil.getCrossPoint(o, b, a, ref_c);
		
		var new_c : Point;
		
		if (p_bc != null) {
			new_c = p_bc;	
		} else if (p_ac != null) {
			new_c = p_ac;	
		} else {
			new_c = ref_c;
		}

		_p.visible = (new_c != ref_c);
		_p.x = new_c.x;
		_p.y = new_c.y;

		var g : Graphics = graphics;
		g.clear();
		g.lineStyle(1, 0x000000);
		
		g.beginFill(0x0000ff, 0.2);
		g.moveTo(a.x, a.y);
		g.lineTo(b.x, b.y);
		g.lineTo(c.x, c.y);
		g.endFill();

		g.beginFill(0x0000ff, 0.2);
		g.moveTo(a.x, a.y);
		g.lineTo(b.x, b.y);
		g.lineTo(ref_c.x, ref_c.y);
		g.endFill();

		g.beginFill(0xff0000, 0.2);
		g.moveTo(a.x, a.y);
		g.lineTo(b.x, b.y);
		g.lineTo(new_c.x, new_c.y);
		g.endFill();
	}
}

class GeoUtil {

	public static function getCRef(
		a : Point, b : Point, c : Point
	) : Point {

		var m1 : Matrix = new Matrix();
		var m2 : Matrix = new Matrix(
			b.x - a.x, b.y - a.y, a.y - b.y, b.x - a.x);
		var m3 : Matrix = new Matrix(1, 0, 0, -1);

		m1.translate(-a.x, -a.y);
		
		m2.invert();
		m1.concat(m2);
		
		m1.concat(m3);
		
		m2.invert();
		m1.concat(m2);
		
		m1.translate(a.x, a.y);
		
		return m1.transformPoint(new Point(c.x, c.y) );
	}
	
	public static function getCrossPoint(
		o : Point,
		a : Point, b : Point, c : Point
	) : Point {
		
		var mat : Matrix = new Matrix(
			a.x - o.x, a.y - o.y,
			c.x - b.x, c.y - b.y);
		
		mat.invert();
		
		var st : Point = mat.transformPoint(b.subtract(o) );
		
		var s : Number = st.x;
		var t : Number = -st.y;
		
		if (0 <= t && t <= 1) {
			return new Point(
				o.x + (a.x - o.x) * s,
				o.y + (a.y - o.y) * s);
		} else {
			return null;
		}
	}
}

class UIPoint extends Sprite {

	private var _pressed : Boolean;
	private var _dragX : Number;
	private var _dragY : Number;
	
	public function UIPoint(
		color : uint, x : Number, y : Number, label : String,
		movable : Boolean = false
	) {

		var g : Graphics = graphics;
		g.clear();
		g.beginFill(color, 0.5);
		g.drawCircle(0, 0, 5);
		g.endFill();
		
		var labelField : TextField = new TextField();
		labelField.type = TextFieldType.DYNAMIC;
		labelField.autoSize = TextFieldAutoSize.LEFT;
		labelField.selectable = false;
		labelField.text = label;
		labelField.x = 4;
		labelField.y = 4;
		addChild(labelField);

		this.x = x;
		this.y = y;
		
		buttonMode = movable;
		useHandCursor = movable;

		if (movable) {
			_pressed = false;
			addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);	
		}
	}
	
	private function mouseDownHandler(event : MouseEvent) : void {

		if (_pressed) return;
		
		stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUpHandler);
		stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMoveHandler);
		stage.addEventListener(Event.MOUSE_LEAVE, stage_mouseLeaveHandler);

		_dragX = mouseX;
		_dragY = mouseY;
		_pressed = true;
	}

	private function stage_mouseMoveHandler(event : MouseEvent) : void {
		x += (mouseX - _dragX);
		y += (mouseY - _dragY);
	}
	
	private function stage_mouseUpHandler(event : MouseEvent) : void {
		releaseMouse();
	}
	
	private function stage_mouseLeaveHandler(event : Event) : void {
		releaseMouse();
	}

	private function releaseMouse() : void {

		if (!_pressed) return;

		stage.removeEventListener(MouseEvent.MOUSE_UP, stage_mouseUpHandler);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMoveHandler);
		stage.removeEventListener(Event.MOUSE_LEAVE, stage_mouseLeaveHandler);
		
		_pressed = false;
	}
}
