/**
 * Copyright yutaka ( http://wonderfl.net/user/yutaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fnKR
 */

// forked from checkmate's Saqoosha challenge for amateurs
package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    
    [SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=60)]

    public class GradationTest1 extends Sprite {
        
        // 090909 yutaka
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        private var dummy:Sprite;
        
        public function GradationTest1() {
            
            // 090909 yutaka
            dummy = new Sprite();
            bmd = new BitmapData(465, 465, true, 0x000000);
            bmp = new Bitmap(bmd);
            addChild(bmp);
            
            // Gradationクラスを作る。任意の数のカラー値を渡すことができる。
            var grad:Gradation = new Gradation(0xff0000, 0x00ff00, 0x0000ff);
            for (var y:int = 0; y < 465; y++) {
                // getColorでグラデーションを構成する中間色を取り出す。渡す値は0〜1。滑らかにこの値を変化させることでグラデーションを作り出す。
/*
                graphics.beginFill(grad.getColor(y / 464));
                graphics.drawRect(0, y, 465, 1);
                graphics.endFill();
*/
                // 090909 yutaka
                dummy.graphics.beginFill(grad.getColor(y / 464));
                dummy.graphics.drawRect(0, y, 465, 1);
                dummy.graphics.endFill();
            }
            
            // 090909 yutaka
            for (var i:uint=0; i<360; i++){
                bmd.draw(dummy);
            }
            
        }
    }
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }

    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }

    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}