/**
 * Copyright hourglasseye ( http://wonderfl.net/user/hourglasseye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fkzC
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class CircleCollision extends Sprite
    {
        public function CircleCollision()
        {
        		var count:int = 25;
        		var circles:Array = [];
        		for( var i:int = 0; i < count; i++ )
        		{
        			var circle:Circle = new Circle();
        			circles.push( circle );
        			addChild( circle );
        		}
        		
        		var lastIteration:Number = new Date().getTime();
        		addEventListener( Event.ENTER_FRAME, function( e:Event ) : void {
        			var thisIteration:Number = new Date().getTime();
        			var deltaTime:Number = ( thisIteration - lastIteration ) * 0.001;
        			lastIteration = thisIteration;
        			for( var i:int = 0; i < count; i++ )
        			{
        				var circle:Circle = circles[i];
        				circle.update( deltaTime );
        			}
        			for( i = 0; i < count; i++ )
        			{
        				var a:Circle = circles[i];
        				for( var j:int = i + 1; j < count; j++ )
        				{
        					var b:Circle = circles[j];
        					a.collide( b );
        				}
        			}
        		} );
        }
    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.geom.Point;

class Circle extends Sprite
{
	private var radius:Number;
	private var direction:Point;
	private var speed:Number;
	private var dragged:Boolean;
	
	public function Circle()
	{
		dragged = false;
		radius = 10 + Math.random() * 30;
		speed = 20 + Math.random() * 35;
		x = radius * 0.5 + Math.random() * ( 465 - radius * 0.5 );
		y = radius * 0.5 + Math.random() * ( 465 - radius * 0.5 );
		
		graphics.beginFill( 0x0000FF, 0.5 );
		graphics.lineStyle( 1, 0x0000FF );
		graphics.drawCircle( 0, 0, radius );
		graphics.endFill();
		
		direction = new Point( Math.random() - 0.5, Math.random() - 0.5 );
		direction.normalize( 1 );
		
		addEventListener( MouseEvent.MOUSE_DOWN, function( e:MouseEvent ) : void {
			dragged = true;
		} );
		addEventListener( MouseEvent.MOUSE_UP, function( e:MouseEvent ) : void {
			dragged = false;
		} );
	}
	
	public function update( deltaTime:Number ) : void
	{
		if( dragged )
		{
			x = stage.mouseX;
			y = stage.mouseY;
		}
		else
		{
			x += direction.x * deltaTime * speed;
			y += direction.y * deltaTime * speed;
			if( x < radius )
			{
				direction.x *= -1;
				x = radius;
			}
			if( x > 465 - radius )
			{
				x = 465 - radius;
				direction.x *= -1;
			}
			if( y < radius )
			{
				direction.y *= -1;
				y = radius;
			}
			if( y > 465 - radius )
			{
				y = 465 - radius;
				direction.y *= -1;
			}
		}
	}
	
	public function collide( circle:Circle ) : void
	{
		if( Point.distance( new Point( x, y ), new Point( circle.x, circle.y ) ) < radius + circle.radius )
		{
			var overlap:Number = ( radius + circle.radius ) - Point.distance( new Point( x, y ), new Point( circle.x, circle.y ) );
			var projection:Point = new Point( x - circle.x, y - circle.y );
			projection.normalize( overlap * 0.5 );
			x += projection.x;
			y += projection.y;
			circle.x -= projection.x;
			circle.y -= projection.y;
			projection.normalize( 1 );
			direction.x = projection.x;
			direction.y = projection.y;
			circle.direction.x = -projection.x;
			circle.direction.y = -projection.y;
		}
	}
}