/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fks8
 */

package {
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	public class Main extends Sprite {
		private const N:uint = 300;
		private var array:Array = [];
		
		public function Main() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			for(var i:uint = 0; i < N; i++) {
				var sp:myClass = new myClass(0, Math.random() * 10 + 1, 10, Math.random() * 0xFFFFFF);
				sp.x = Math.random() * stage.stageWidth;
				sp.y = -Math.random() * 100 - 10;
				
				array.push(sp);
				addChild(sp);
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		}
		
		private function onMouseDown(e:MouseEvent):void {
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			for(var i:uint = 0; i < N; i++) {
				array[i].v = Math.random() * 10 + 10;
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame2);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onMouseUp(e:MouseEvent):void {
			removeEventListener(Event.ENTER_FRAME, onEnterFrame2);
			for(var i:uint = 0; i < N; i++) {
				if(array[i].x == mouseX && array[i].y == mouseY) {
					array[i].vx = Math.random() * 40 - 20;
					array[i].vy = Math.random() * 40 - 20;
				}
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onEnterFrame(e:Event):void {
			for(var i:uint = 0; i < N; i++) {
				array[i].x += array[i].vx;
				array[i].y += array[i].vy;
				
				array[i].vy++;
				
				if(array[i].x > stage.stageWidth - 10) {
					array[i].x = stage.stageWidth - 10;
					array[i].vx = -array[i].vx / 2;
				} else if(array[i].x < 10) {
					array[i].x = 10;
					array[i].vx = -array[i].vx / 2;
				}
				if(array[i].y > stage.stageHeight - 10) {
					array[i].y = stage.stageHeight - 10;
					array[i].vy = -array[i].vy / 2;
				}
			}
		}
		
		private function onEnterFrame2(e:Event):void {
			for(var i:uint = 0; i < N; i++) {
				var arc:Number = Math.atan2(mouseY - array[i].y, mouseX - array[i].x);
				array[i].vx = Math.cos(arc) * array[i].v;
				array[i].vy = Math.sin(arc) * array[i].v;
				
				array[i].x += array[i].vx;
				array[i].y += array[i].vy;
				
				if((array[i].vx < 0 && array[i].x < mouseX) || (array[i].vx > 0 && array[i].x > mouseX)) {
					array[i].x = mouseX;
					array[i].vx = 0;
				}
				if((array[i].vy < 0 && array[i].y < mouseY) || (array[i].vy > 0 && array[i].y > mouseY)) {
					array[i].y = mouseY;
					array[i].vy = 0;
				}
			}
		}
	}
}

import flash.display.Sprite;

class myClass extends Sprite {
	private var _vx:Number;
	private var _vy:Number;
	private var _v:Number;
	
	public function get vx():Number {
		return _vx;
	}
	public function set vx(v:Number):void {
		_vx = v;
	}
	public function get vy():Number {
		return _vy;
	}
	public function set vy(v:Number):void {
		_vy = v;
	}
	public function get v():Number {
		return _v;
	}
	public function set v(v:Number):void {
		_v = v;
	}
	
	public function myClass(vx:Number, vy:Number, r:Number, color:uint) {
		_vx = vx;
		_vy = vy;
		
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, r);
		graphics.endFill();
	}
}