/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fkro
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {

        public var p:Sprite;
        public var col:Sprite;

        public var vx:Number = 0;
        public var vy:Number = 0;

        public var prad:Number = 16;

        public function FlashTest() {
            
            p = new Sprite();
            p.graphics.clear();
            p.graphics.lineStyle(2,0xFF0000);
            p.graphics.drawCircle(0,0,prad);
            p.x = 200;
            p.y = 200;
            
            col = new Sprite();
            col.graphics.clear();
            col.graphics.beginFill(0, 1);
            col.graphics.drawRect(0,0,400,64);
            col.graphics.endFill();
            col.graphics.beginFill(0,1);
            col.graphics.drawRect(0,0,32,400);
            col.graphics.endFill();
            col.graphics.beginFill(0, 1);
            col.graphics.drawRect(0,300,400,64);
            col.graphics.endFill();
            col.graphics.beginFill(0,1);
            col.graphics.drawRect(360,0,32,400);
            col.graphics.endFill();
            col.graphics.beginFill(0,1);
            col.graphics.drawRect(250,250,64,64);
            col.graphics.endFill();
            
            addChild(col);
            addChild(p);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        
        public function kdown(e:KeyboardEvent):void 
        { vecKey[e.keyCode] = true; }
        public function kup(e:KeyboardEvent):void
        { vecKey[e.keyCode] = false; }
        
        public function onEnter(e:Event):void
        {
            if (vecKey[Keyboard.UP]) { vy -= 0.4;}
            if (vecKey[Keyboard.DOWN]) { vy += 0.4;}
            if (vecKey[Keyboard.LEFT]) { vx -= 0.4;}
            if (vecKey[Keyboard.RIGHT]) { vx += 0.4;}
            
            vx *= 0.97;
            vy *= 0.97;
            
            var fx:Number;
            var fy:Number;
           
            var nx:Number;
            var ny:Number;
            var mag:Number;
            mag = Math.sqrt(vx*vx+vy*vy);
            if (mag == 0) { mag = 0.000000001; }
            nx = vx / mag;
            ny = vy / mag;
            
            fx = p.x + vx + (nx*prad);
            fy = p.y + vy + (ny*prad);
            
            graphics.clear();
            graphics.lineStyle(2,0x00FF00);
            graphics.moveTo(p.x,p.y);
            graphics.lineTo(fx,fy);
            
            if (col.hitTestPoint(p.x+prad,p.y,true)) { p.x -=1; }
            if (col.hitTestPoint(p.x-prad,p.y,true)) { p.x +=1; }
            if (col.hitTestPoint(p.x,p.y+prad,true)) { p.y -=1; }
            if (col.hitTestPoint(p.x,p.y-prad,true)) { p.y +=1; }
            
            
            if (col.hitTestPoint(fx,fy,true))
            {
                vx = 0;
                vy = 0;   
               /*
                if (col.hitTestPoint(fx,p.y, true)) { vx =0; }
                if (col.hitTestPoint(p.x,fy,true)) { vy = 0;}
                if (vx != 0 && vy != 0)
                { vx = 0; vy =0;}
                */ 
            }
            else
            {
             p.x += vx;
             p.y += vy;
            }
           
            
            
        }//onenter
        
        
    }//classend
}