/**
 * Copyright Nos_lkSsvOhB ( http://wonderfl.net/user/Nos_lkSsvOhB )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fkmN
 */

// forked from mousepancyo's 光るリボン（Ribbon Light）
// forked from nutsu's SketchSample6
package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
    
    public class Main extends Sprite{
        
        private const WIDTH:Number  = 465;
        private const HEIGHT:Number = 465;
        
        private var _sketch:CurveSketch;
        private var _bmd:BitmapData;
        private var _bm:Bitmap;
        private var _container:Sprite = new Sprite();

        public function Main() {
            graphics.beginFill(0)
            graphics.drawRect(0, 0, WIDTH, HEIGHT)
            graphics.endFill()
            addChild(_container);
            //
            _sketch = new CurveSketch();
            _bmd = new BitmapData(WIDTH, HEIGHT, true, 0);
            _container.addChild(_sketch);
            _container.addChild(_bm = new Bitmap(_bmd) as Bitmap);
            _bm.blendMode = "add";
            //
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void{
            _bmd.draw(_sketch, null, null, "add");
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(), new BlurFilter(8, 8, 3));
        }
    }
}



//package {
    import frocessing.display.F5MovieClip2D;
    import frocessing.geom.FGradientMatrix;
    import frocessing.color.ColorHSV
    
    class CurveSketch extends F5MovieClip2D
    {
        //位置
        private var xx:Number;
        private var yy:Number;

        private var mx:Number=0;
        private var my:Number=0;
        
        private var ti:Number=0;
        private var tu:Number=0;
        private var d:Number=0;
        private var ux0:Number=0;
        private var uy0:Number=0;
        private var ux1:Number=0;
        private var uy1:Number=0;
        private var ts:Number=2;
        
        private var m:int=0;
        private var k:int=0;
        private var lx:Array=new Array(6);
        private var ly:Array=new Array(6);
        private var ax:Array=new Array(6);
        private var ay:Array=new Array(6);
        
        //描画座標
        private var px0:Array;
        private var py0:Array;
        private var px1:Array;
        private var py1:Array;
        
        private var t:Number = 0;
        
        //描画グループ
        private var shapes:Array;
        
        public function CurveSketch() 
        {
            lx[0]=[39,33,26,25,32,46,60,66,60,56,54,41,28,24];
            ly[0]=[206,210,207,197,187,190,190,184,192,217,242,251,247,242];
            ax[0]=[37,29,23,27,38,55,66,66,54,59,50,33,24];
            ay[0]=[209,211,204,190,184,196,184,184,200,235,250,253,242];
            lx[1]=[48,69,79,81];
            ly[1]=[219,213,214,216];
            ax[1]=[61,77,81];
            ay[1]=[214,212,216];
            lx[2]=[94,89,79,72,78,93,109,118,115,107,103,109,120,134,145,145,137,133,135,142,154,165,166,158,153,155,162,170,173,172,174,183,191,192,186,177,176,184,193,198,200];
            ly[2]=[190,185,193,222,247,250,242,233,227,230,241,249,249,231,207,194,197,224,248,250,231,207,194,197,224,248,249,240,234,240,249,250,243,234,229,230,239,249,250,245,243];
            ax[2]=[94,85,74,71,85,101,118,119,112,102,104,115,126,142,148,142,133,133,137,147,162,169,163,153,153,157,168,173,173,171,177,189,194,191,182,173,179,189,197,200];
            ay[2]=[186,185,202,242,253,248,237,229,226,235,247,252,247,216,199,189,205,244,253,247,216,199,189,205,243,253,246,234,235,245,253,248,238,230,228,233,246,253,248,243];
            lx[3]=[242,240,234,230,236,250,263,267,261,252,254,264,274,280,279,277,275,278,287,298,304,302,296,287,282,284,291,299,305,307];
            ly[3]=[193,199,200,193,184,187,187,183,191,217,242,251,247,229,206,206,228,245,251,242,220,200,188,183,186,193,197,197,196,195];
            ax[3]=[243,238,230,231,242,259,267,267,256,249,259,269,279,281,278,276,275,282,292,304,305,300,292,283,281,287,295,304,307];
            ay[3]=[196,202,199,187,182,192,183,184,199,235,250,252,242,216,196,216,240,251,251,234,207,193,183,183,190,196,198,197,195];
            lx[4]=[312,318,321,320,321,328,337,341,337,328,324,331,341,351,356,359,365,364,359,359,365,375,388,392,384,379,383,396,410,418,415,406,399,400,409,417,419,414,404,401];
            ly[4]=[246,239,234,238,247,250,246,238,230,230,237,247,249,237,228,230,230,231,241,249,250,242,219,195,197,225,249,250,242,236,231,229,237,247,250,243,228,210,203,206];
            ax[4]=[316,321,321,319,324,333,341,341,334,323,326,336,347,356,356,363,367,362,357,362,369,381,395,390,379,379,388,404,417,419,412,401,397,404,415,419,420,408,401];
            ay[4]=[244,234,234,243,251,250,243,233,228,232,243,252,246,228,228,232,228,235,247,252,249,236,202,189,205,245,254,247,238,235,227,232,242,252,249,237,220,201,206];
            lx[5]=[440,437,437,441,443,440,435,436,441,441,439];
            ly[5]=[251,249,244,244,249,245,219,194,194,220,240];
            ax[5]=[439,435,439,444,442,438,433,439,444,439];
            ay[5]=[252,247,242,246,252,238,201,188,201,240];
           
            //初期化
            mx = lx[m][k];
            my = ly[m][k];
            xx = mx;
            yy = my;
            px0 = [xx, xx, xx, xx];
            py0 = [yy, yy, yy, yy];
            px1 = [xx, xx, xx, xx];
            py1 = [yy, yy, yy, yy];
                        
            shapes = [];
            
            //線と塗りの色指定
            noStroke();            
        }
        
        public function draw():void
        {
            if(ti<=1000){
                if(m<6){
                    if(k<lx[m].length-1){
                        d=1/ts;
                        ux0=(1-tu)*lx[m][k]+tu*ax[m][k];
                        ux1=(1-tu)*ax[m][k]+tu*lx[m][k+1];
                        uy0=(1-tu)*ly[m][k]+tu*ay[m][k];
                        uy1=(1-tu)*ay[m][k]+tu*ly[m][k+1];
                        mx=(1-tu)*ux0+tu*ux1;
                        my=(1-tu)*uy0+tu*uy1;
                        if(tu>=1){
                            tu=0;
                            k++;
                        }else{
                            tu+=d;
                        }
                    }else{
                        m++;
                        k=0;
                        mx=lx[m][k];
                        my=ly[m][k];
                    }
                }
                
                //新しい描画座標
                var x0:Number = mx + 2;
                var y0:Number = my - 2;
                var x1:Number = mx - 2;
                var y1:Number = my + 2;
            
                if(shapes.length<=410){
                    //描画座標
                    px0.shift(); px0.push( x0 );
                    py0.shift(); py0.push( y0 );
                    px1.shift(); px1.push( x1 );
                    py1.shift(); py1.push( y1 );
                    var _px0:Array = [px0[0], px0[1], px0[2], px0[3]];
                    var _py0:Array = [py0[0], py0[1], py0[2], py0[3]];
                    var _px1:Array = [px1[0], px1[1], px1[2], px1[3]];
                    var _py1:Array = [py1[0], py1[1], py1[2], py1[3]];
                    shapes.push( { px0:_px0, py0:_py0, px1:_px1, py1:_py1, mtx:null} );
                }
//                if (shapes.length >= 500) shapes.shift();

                var shapesLength:int = shapes.length;
                for (var i:int = shapesLength-1; i >= 0; i--) 
                {
                    var sh:Object = shapes[i];

                    var color:ColorHSV = new ColorHSV(t, 0.8, 1, 0.1)
                    t += 0.002;

                    beginFill(int(color), 0.2)
                    beginShape();
                    curveVertex( sh.px0[0], sh.py0[0] );
                    curveVertex( sh.px0[1], sh.py0[1] );
                    curveVertex( sh.px0[2], sh.py0[2] );
                    curveVertex( sh.px0[3], sh.py0[3] );
                    vertex( sh.px1[2], sh.py1[2] );
                    curveVertex( sh.px1[3], sh.py1[3] );
                    curveVertex( sh.px1[2], sh.py1[2] );
                    curveVertex( sh.px1[1], sh.py1[1] );
                    curveVertex( sh.px1[0], sh.py1[0] );
                    endShape();
                }
                ti++;
            }
        }
    }