/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fkHv
 */

/**
 * @author esukei
 * 行列使うのめんどくさかったから
 * 入れ子にしたオブジェクトで任意の点で回転と拡大してみるテスト
 */
package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class MovingCenter extends Sprite {
        
        //中心軸用スプライト
        private var center:Sprite;
        //■用スプライト
        private var square:Sprite;
        
        //初期位置を保存用
        private var defaultX:Number;
        private var defaultY:Number;
        
        public function MovingCenter() {
            
            //中心軸用スプライト
            center = new Sprite();
            //■用スプライト
            square = new Sprite();
            //■描画
            square.graphics.beginFill(0x999999);
            square.graphics.drawRect(-100,-50,200,100);
            square.graphics.endFill();
            
            //初期位置を画面中心に
            center.x = stage.stageWidth / 2;
            center.y = stage.stageHeight / 2;
            
            //初期位置を保存
            defaultX = center.x;
            defaultY = center.y;
            
            //■を中心軸用スプライトにおく
            center.addChild(square);
            //中心軸用スプライトをステージに置く
            addChild(center);
            
            //メインループ
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(event:Event):void
        {
            //中心をマウスの位置に移動
            center.x = mouseX;
            center.y = mouseY;
            
            //中心軸の動きをキャンセル
            square.x = defaultX - mouseX;
            square.y = defaultY - mouseY;
            
            //軸回転
            center.rotation += 1;
            
            //軸拡縮
            center.scaleX = Math.sin(center.rotation / 180 * Math.PI) * 0.5 + 1.0;
            center.scaleY = Math.sin(center.rotation / 180 * Math.PI) * 0.5 + 1.0;
            
        }
    }
}