/**
 * Copyright shihu ( http://wonderfl.net/user/shihu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fkBY
 */

// forked from kotobuki's FIO Basic Example: SignalScope
// forked from kotobuki's Gainer Basic Example: SignalScope
// A very basic SignalScope example for FIO modules
// 3 analog input channels version
// 
// Reference
// http://funnel.cc/Software/ActionScript3
// http://funnel.cc/Hardware/FIO

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.*;

    [SWF(backgroundColor="0x808080")]

    public class GainerTest extends Sprite {
        private const NUM_CHANNELS:int = 3;

        private var fio:Fio;
        private var scopes:Array;

        public function GainerTest() {
            var config:Configuration = Fio.FIRMATA;
            fio = new Fio([1], config);

            scopes = new Array(NUM_CHANNELS);
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i] = new SignalScope(0, 0 + (53 * i), 200, "A" + i);
                addChild(scopes[i]);
            }

            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i].update(fio.ioModule(1).analogPin(i));
            }
        }
    }
}
