/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fkAO
 */

/*
背景色のRGBから3つのBGMのボリュームを制御する
*/
package  
{
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.filters.GlowFilter;
	[SWF(width = "465", height = "465", backgroundColor = 0x000000, frameRate = "60")]
	public class WalkerPlanet 
	extends Sprite
	{
		
		public function WalkerPlanet() 
		{
			var planetR:Number = 300;
			var spaceR:Number = stage.stageHeight + planetR *  Math.SQRT2;
			var groundY:Number = 400;
			
			//space
			var space:Space = new Space(planetR, spaceR);
			space.rotation = 90;
			
			//walker
			var walker:Walker = new Walker();
			space.x = walker.x = stage.stageWidth / 2;
			space.y = planetR + groundY;
			walker.y = groundY;

			//bgm
			var bgm:BGM = new BGM();
			
			//current RGB
			var bd:BitmapData = new BitmapData(1, 1);
			var bmp:Bitmap = new Bitmap(bd);	
			bmp.width = bmp.height = 20;
			bmp.x = 10;
			bmp.y = stage.stageHeight - 30;
			bmp.filters = [
				new GlowFilter(0xFFFFFF, 1, 2, 2, 5)
			];
			
			//add
			addChild(space);
			addChild(walker);
			addChild(bmp);	
			
			stage.addEventListener(Event.ENTER_FRAME, function():void {
				var t:Number = Math.tan(-Math.PI/ 2 + space.rotation * Math.PI / 180);
				space.rotation -= walker.mouseX * 0.002;
				var mtx:Matrix = new Matrix();
				mtx.rotate( -( - space.rotation * Math.PI / 180));
				mtx.translate(0, groundY + planetR - 150);
				bd.draw(space,mtx);
				bgm.setVols(bd.getPixel(0, 0));				
			});
		}
	}
}
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import flash.events.TimerEvent;
import flash.media.SoundChannel;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

import flash.media.Sound;
import flash.net.URLRequest;
class BGM
extends Object
{
	
/*
"a quiet satellite is passing above" by mic
http://www.dance-industries.com/view_artist.php?ID=4554&track=16906

"eastern feel" by mic
http://www.dance-industries.com/view_artist.php?ID=4554&track=16909

"Metro" by Djfredse
http://www.dance-industries.com/view_artist.php?ID=6016&track=26322

*/
	private var r:SndVol = new SndVol(new URLRequest(
		"http://www.t-p.jp/wonderfl/sound/loop/a quiet satellite is passing above.mp3"));
	private var g:SndVol = new SndVol(new URLRequest(
		"http://www.t-p.jp/wonderfl/sound/loop/eastern feel.mp3"));
	private var b:SndVol = new SndVol(new URLRequest(
		"http://www.t-p.jp/wonderfl/sound/loop/Metro.mp3"));
		

	public function BGM():void 
	{
		r.setVol(0.0);
		g.setVol(0.0);
		b.setVol(0.0);
	}
	public function setVols(vol:uint):void 
	{
		b.setVol(Math.min(0.3, Math.max(0.05, Math.pow((vol & 0xFF) / 255, 2) ) ), 0);	
		vol >>= 8;
		g.setVol(Math.min(0.3, Math.max(0.0, Math.pow((vol & 0xFF) / 255, 2) )), -1.0 );		
		vol >>= 8;
		r.setVol(Math.min(0.3, Math.max(0.05, Math.pow(vol / 255, 2) )), 1.0);
	}
}
import flash.media.SoundLoaderContext;
import flash.media.SoundTransform;
class SndVol
extends Sound
{
	private var sc:SoundChannel;
	public function SndVol(stream:URLRequest = null, context:SoundLoaderContext = null) : void
	{
		super(stream, context);
		sc = play(0, 100);
	}
	public function setVol(vol:Number = 1.0, pan:Number = 0):void 
	{

		var st:SoundTransform = sc.soundTransform;
		st.volume = vol;
		st.pan = pan;
		sc.soundTransform = st;
	}
}
import flash.events.MouseEvent
class Space
extends Sprite
{
	public function Space(planetR:Number, spaceR:Number):void 
	{
		//planet
		var planet:Planet = new Planet();
		planet.width = planet.height = planetR * 2;
		
		//sky
		var sky:Sky = new Sky(spaceR);
		sky.addEventListener(Event.ENTER_FRAME, function():void {
			sky.rotation += 360 / 60 / 60;
		});
		addEventListener(MouseEvent.MOUSE_DOWN, function ():void 
		{
			sky.draw(spaceR);
		});
		
		//add
		addChild(sky);
		//bldgs
		for (var i:uint = 0; i < 30; i++)
		{
			var bldg:Bldg = new Bldg();
			var rad:Number = Math.random() * Math.PI * 2;
			var pt:Point = Point.polar(planetR -10, rad);
			bldg.width = (Math.random() * 0.8 + 0.2) * 100;
			bldg.height = (Math.random() * 0.7 + 0.3) * 100;
			bldg.x = pt.x;
			bldg.y = pt.y;
			bldg.rotation = rad * 180 / Math.PI + 90;
			addChild(bldg);
		}
		addChild(planet);

	}
}
class Sky
extends Sprite
{
	public function Sky(spaceR:Number):void 
	{
		draw(spaceR);
	}
	public function draw(spaceR:Number ):void 
	{
		var mtr:Matrix = new Matrix();
		mtr.createGradientBox(spaceR * 4, spaceR * 4, 0, -spaceR * 2,  -spaceR * 2 * 0.5);
		
		
		var colors:Array = new Array();
		var alphas:Array = new Array();
		var ratios:Array = new Array();
		var r:Number = 255;
		var g:Number = 255;
		var b:Number = 255;
		var minRatio:Number = 27 + Math.random()*18;
		var maxRatio:Number =  220 + Math.random()*12;
		var ratioSpan:Number = maxRatio - minRatio;
		var ratio:Number = minRatio;

		//white
		colors.push(0xFFFFFF);
		alphas.push(1);
		ratios.push(minRatio-1);
		//grd
		var num:uint = 3 + Math.floor(Math.random() * 7);
		for (var i:uint = 0; i < num; i++)
		{
			ratio = minRatio + ratioSpan * (i / num);
			var rgbVol:Number =  255 * (maxRatio - ratio) / ratioSpan;
			r = (Math.random() * 0.9 + 0.1) * rgbVol;
			g = (Math.random() * 0.9 + 0.1) * rgbVol;
			b = (Math.random() * 0.9 + 0.1) * rgbVol;
			colors.push(uint(r) * 0x10000 + uint(g) * 0x100 + uint(b));
			alphas.push(1.0);
			ratios.push(ratio);
		}
		//black
		colors.push(0);
		alphas.push(1);
		ratios.push(maxRatio);
		

		graphics.clear();
		graphics.beginGradientFill(
			GradientType.RADIAL,
			colors, alphas, ratios,
			mtr
		);
		graphics.drawCircle(0, 0,  spaceR);
		
	}
}
class Planet
extends Sprite
{
	public function Planet():void 
	{
		graphics.beginFill(0x333333);
		graphics.drawCircle(0, 0, 100);
		

	}
}
class Bldg
extends Sprite
{
	public function Bldg():void 
	{
		var vol:Number = Math.random() * 0x10 + 0x10;
		graphics.beginFill(
			(vol << 16) + (vol << 8) + vol
			//((Math.random() * 0.2 + 0.1) * 255 << 16)
			//+ ((Math.random() * 0.2 + 0.1) * 255 << 8)
			//+ ((Math.random() * 0.2 + 0.1) * 255)
		);
		graphics.drawRect( -50, -100, 100, 100);
	}
}
	
class Walker
extends Sprite 
{
	private var rad:Number;
	private var r:Number = 0;
	private const PI2:Number = Math.PI * 2;
	private var speed:Number = 0.05;
	private var rAdd:Number = Math.PI * speed;
	private var legs:Sprite = new Sprite();
	private var body:Sprite = new Sprite();

	public function Walker():void 
	{		
		//body
		body.graphics.beginFill(0)//x666666);
		body.graphics.drawRoundRect(-40, 0, 80, 60, 60, 60);
		body.graphics.beginFill(0xFFFFFF);
		body.graphics.drawCircle( -20, 20, 4);
		body.graphics.drawCircle( 20, 20, 4);
		
		//legs
		var legNum:uint = 4;
		for (var i:uint = 0; i < legNum; i ++)
		{
			var leg:Leg = new Leg();
			leg.r = PI2 * (i *1.5) / legNum;
			leg.length = 100;
			leg.rMul = Math.random() + 0.2;
			legs.addChild(leg);
		}
		//add
		addChild(body);
		addChild(legs);
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		//
		enterFrameHandler(null);

	}
	private function enterFrameHandler(e:Event):void 
	{
		var d:Number = (mouseX - legs.x) * 0.01;
//		legs.x += d;
//		body.x  = legs.x;

		r = (r + d * 0.02 ) % PI2;
		legs.graphics.clear();
		var heights:Array = new Array();
		for (var i:uint; i < legs.numChildren; i++) 
		{
			var leg:Leg = legs.getChildAt(i) as Leg;
			var pt:Point = Point.polar(leg.length/2, Math.abs(Math.sin(r + leg.r)) * (i %2 ==0 ? -1 : 1) *1.0 + Math.PI / 2);
			
			var lx:Number = (Math.ceil(i/2)) * 60 / legs.numChildren *  ((i % 2 == 0) ? 1 : -1)
			+ ((legs.numChildren % 2 == 0) ? 30/ legs.numChildren : 0);

			legs.graphics.moveTo(lx, 0);
			legs.graphics.lineStyle(16, 0);
			legs.graphics.lineTo(lx + pt.x, pt.y);
			legs.graphics.lineTo(lx, pt.y*2);
			heights.push(pt.y*2)
		}

		heights.sort(Array.NUMERIC | Array.DESCENDING);
		legs.y = - heights[0];

		body.y = legs.y - body.height *0.75;
	}
	
}
	


class Leg
extends Sprite
{
	public var r:Number;
	public var length:Number;
	public var rMul:Number;
	public function Leg():void 
	{
	}
}
