/**
 * Copyright NME ( http://wonderfl.net/user/NME )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fjAr
 */

// forked from kawamura's Wheel Count

//Modified the code to make it work like a turn table 
//and keep accurate position info so 
//it could be used with audio

package 
{
    import flash.display.Sprite;
    import flash.events.Event;

    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.frameRate = 121;
            layout();
        }
        
        private function layout():void 
        {
            var wheel:Wheel = new Wheel();
            addChild(wheel);
            wheel.x = stage.stageWidth * 0.5;
            wheel.y = stage.stageHeight * 0.5;
        }
        
    }
}
import flash.utils.setInterval;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;

class Wheel extends Sprite 
{
    private var wheel:Sprite;
    private var theta:Number;
    private var vw:Number = 0;
    private var preTheta:Number;
    private var tf:TextField;
    private var isDown:Boolean = false;
    
    //just some math stored so we don't have to repeat it every loop.
    private var toDeg:Number = 180/Math.PI;
    private var twoPi:Number = Math.PI*2;
    private var defaultAngleIncrementation:Number = twoPi/60;
    
    private var iid:uint;//interval id
    
    public function Wheel() 
    {
        if (stage) init();
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        var g:Graphics;
        wheel = new Sprite();
        addChild(wheel);
        g = wheel.graphics;
        g.beginFill(0xFF0000);
        g.drawCircle(0, 0, 150);
        var point:Sprite = new Sprite();
        wheel.addChild(point);
        g = point.graphics;
        g.beginFill(0xFFFFFF);
        g.drawCircle(0, 0, 10);
        point.y = -100;
        
        point = new Sprite();
        wheel.addChild(point);
        g = point.graphics;
        g.beginFill(0);
        g.drawCircle(0, 0, 1);
        //
        tf = new TextField();
        addChild(tf);
        tf.text = "0"
        tf.selectable = false;
        tf.mouseEnabled = false;
        //
        theta = 0;
        //
        wheel.buttonMode = true;
        wheel.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
        //wheel.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveEH);
        //
        //addEventListener(Event.ENTER_FRAME, enterFrameListener);
        
        //
        iid = setInterval(onInterval,1000/121);
        //wheel.addEventListener(MouseEvent.MOUSE_MOVE,function(e:MouseEvent):void{onInterval();});  
        //only updates on mouse event, so we need to separate the update of the display, and the reaction to the mouse for something like audio
        
    }
    private function mouseMoveEH(e:MouseEvent):void{
        e.updateAfterEvent();
    }
    
    private function mouseDownListener(e:MouseEvent):void 
    {
        isDown = true;
        preTheta = Math.atan2(this.mouseY, this.mouseX);
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        
    }
    
    private function mouseUpListener(e:MouseEvent):void 
    {
        isDown = false;
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
    
    
    private function onInterval():void
    //private function enterFrameListener(e:Event):void 
    {
        tf.text = '';
        if (isDown) //this section could probably be onMouseMove for faster response to movement
        {
            //these variables are hoisted anyways so declaring them elsewhere at the top might help(me at the very least) for conceptualization
            //
            var currentTheta:Number = Math.atan2(this.mouseY, this.mouseX);
            var dw:Number = (currentTheta - preTheta);
            
            if (dw > Math.PI)
            {
                dw -= twoPi;
            }
            else if (dw < -Math.PI)
            {
                dw += twoPi;
            }
            vw = dw;
            theta += dw ;
            preTheta = currentTheta;
            tf.appendText(dw+'\n');
        }
        //this section could probably be onInterval if mouse is not down on the wheel.
        //you could make it continue spinning in the correct direction, if playing audio or keep it the same if using it for scrubbing through data
       else//right now this relies on the frame rate... which might not be a good thing for something like audio playback
       {
           //vw *= 0.69;
          
          theta += defaultAngleIncrementation; //it's the same as the commented line below
          //theta += twoPi/65;
          
          //theta += vw; //makes it go in the same direction, but of course damped down
       }
        wheel.rotation = (theta*toDeg)%360;
        
        //it could be Math.Floor instead of int, if it is a bigger number that was possible; yet, int is faster if amongst -2^31 to +2^31
        //tf.text += ''+Math.floor(theta / twoPi);
        tf.appendText(String(theta/twoPi)); //to show the actual value * 2Pi
       
        
    }
}
