/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fipQ
 */



//Box2D_06_06.as
package {
    //▼インポート
    import flash.display.Sprite;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import flash.events.Event;
    import Box2D.Collision.Shapes.b2MassData;
    import flash.display.SimpleButton;
    import flash.events.MouseEvent;

    public class Box2D_06_06 extends Sprite {
        //▼定数定義
        //1mを表すピクセル数
        private static const DRAW_SCALE:Number = 100;
        //▼プロパティ定義
        private var _world:b2World;
        private var _bArrow:b2Body;
        
        private var btn1:Sprite = new Sprite();
        private var btn2:Sprite = new Sprite()
        
        private function debugDraw():void {
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = this;
            debugDraw.m_drawScale = DRAW_SCALE;
            debugDraw.m_fillAlpha = 0.3;
            debugDraw.m_lineThickness = 1;
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            _world.SetDebugDraw(debugDraw);
        }
        
        //▼コンストラクタ定義
        public function Box2D_06_06() {
            addChild(btn1);
            btn1.graphics.beginFill(0x0);
            btn1.graphics.drawRect(0,0,20,20);
            btn1.graphics.endFill();
           
            addChild(btn2);
            btn2.graphics.beginFill(0x0);
            btn2.graphics.drawRect(0,0,20,20);
            btn2.graphics.endFill();
            btn2.x = 50;
            
            //▼物理エンジンのセットアップ
            //物理エンジン適用範囲の設定（ステージの100ピクセル外側）
            var worldRegion:b2AABB = new b2AABB();//矩形作成
            worldRegion.lowerBound.Set(-1, -1);
            worldRegion.upperBound.Set(6.5, 5);
            //重力の設定
            var gravity:b2Vec2 = new b2Vec2(0, 9.8);
            //範囲・重力・スリープの有無を指定して物理ワールドを作成
            _world = new b2World(worldRegion, gravity, true);
            
            //▼床（静体）の生成
            //BodyDefの設定
            var bdFloor:b2BodyDef = new b2BodyDef();
            bdFloor.position.Set(5.5 / 2, 3);
            //ShapeDefの設定
            var pdFloor:b2PolygonDef = new b2PolygonDef();
            pdFloor.SetAsBox(2, 0.15);
            //ボディの生成
            var bFloor:b2Body = _world.CreateBody(bdFloor);
            bFloor.CreateShape(pdFloor);
            
            
            
            //▼やじり型（動体）の生成
            var bdArrow:b2BodyDef = new b2BodyDef();
            bdArrow.position.Set(0, 0);
            //bdArrow.angle = Math.PI / 30;
            //1つめのb2ShapeDefオブジェクトを生成
            var shape1:b2PolygonDef = new b2PolygonDef();
            shape1.vertexCount = 3;
            shape1.vertices[0].Set(0, -0.25);
            shape1.vertices[1].Set(0,0);
            shape1.vertices[2].Set(-0.25, 0.25);
            shape1.density = 1;
            shape1.restitution = 0.5;
            //2つめのb2ShapeDefオブジェクトを生成
            var shape2:b2PolygonDef = new b2PolygonDef();
            shape2.vertexCount = 3;
            shape2.vertices[0].Set(0, -0.25);
            shape2.vertices[1].Set(0.25, 0.25);
            shape2.vertices[2].Set(0, 0);
            shape1.density = 1;
            shape2.restitution = 0.5;
            //ボディの生成
            _bArrow = _world.CreateBody(bdArrow);
            _bArrow.CreateShape(shape1);
            _bArrow.CreateShape(shape2);
            //位置の設定
            _bArrow.SetXForm(new b2Vec2(5.5 / 2, 1), Math.PI / 180 * 10);
            //質量の設定
            _bArrow.SetMassFromShapes();
            
            //▼重心の変更
            trace(_bArrow.GetLocalCenter());//変更前の重心座標
            var massData:b2MassData = new b2MassData();
            massData.mass = _bArrow.GetMass();//自動設定された質量を再設定
            massData.center = new b2Vec2(0, 0);//明示的にx = 0, y = 0を指定
            massData.I = _bArrow.GetInertia();//自動設定された回転の慣性を再設定
            _bArrow.SetMass(massData);
            trace(_bArrow.GetLocalCenter());//変更後の重心座標
            
            //▼描画設定
            var dd:b2DebugDraw = new b2DebugDraw();
            dd.m_sprite = this;
            dd.m_drawScale = DRAW_SCALE; //1mを100ピクセルにする
            dd.m_fillAlpha = 0.3; //塗りのアルファ値
            dd.SetFlags(b2DebugDraw.e_shapeBit);//物体を表示する設定に
            _world.SetDebugDraw(dd);//物理ワールドにセット
            
            //▼イベントリスナーの追加
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            btn1.addEventListener(MouseEvent.CLICK, _rotate_btn_clickHandler);
            btn2.addEventListener(MouseEvent.CLICK, _move_btn_clickHandler);
            debugDraw();
        }
        
        //▼イベントリスナー定義
        private function _enterFrameHandler(eventObj:Event):void {
            _world.Step(1 / 24, 10);//物理シミュレーションの更新
        }
        //以下ボタン用イベントリスナー
        private function _rotate_btn_clickHandler(eventObj:MouseEvent):void {
            _bArrow.SetXForm(_bArrow.GetPosition(), _bArrow.GetAngle() + Math.PI / 180 * 30);
        }
        private function _move_btn_clickHandler(eventObj:MouseEvent):void {
            var curPosition:b2Vec2 = _bArrow.GetPosition();
            curPosition.Add(new b2Vec2(0, -0.5))
            _bArrow.SetXForm(curPosition, _bArrow.GetAngle());
        }
    }
}