/**
 * Copyright ultranoir ( http://wonderfl.net/user/ultranoir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fhju
 */

// forked from Hidetaro's ParticleGirl !?
package {
	import flash.display.Sprite;
	import flash.events.*;
	import flash.filters.BlurFilter;
	import flash.net.*;

	import org.papervision3d.view.layer.*;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.*;
	import org.papervision3d.core.effects.*;
	import org.papervision3d.core.effects.utils.*;
	import org.papervision3d.view.BasicView;
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]

	public class ParticleGirl extends BasicView {
		private var xml:XML;
		private var hairPixels:Pixels;
		private var oppaiPixels:Pixels;
		private var bodyPixels:Pixels;
		private var vartexData_hair:Vector.<MyParticles> = new Vector.<MyParticles>();
		private var vartexData_oppai:Vector.<MyParticles> = new Vector.<MyParticles>();
		private var vartexData_body:Vector.<MyParticles> = new Vector.<MyParticles>();
		private var op:Oppai = new Oppai();
		private var spring:Number=0.1;
		private var friction:Number=0.90;

		public function ParticleGirl():void {
			super(0, 0, true, true);
			var xmlLoader:URLLoader = new URLLoader();
			xmlLoader.load(new URLRequest("http://www.akibahideki.com/particle_data/bodydata.dat"));
			xmlLoader.addEventListener(Event.COMPLETE, xmlLoaded);
			camera.z=-1000;
			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport,550,400,true,0,BitmapClearMode.CLEAR_PRE,true);
			viewport.containerSprite.addLayer(layer);
			layer.addEffect(new BitmapLayerEffect(new BlurFilter(8, 8, 4), false));
			hairPixels=new Pixels(layer);
			oppaiPixels=new Pixels(layer);
			bodyPixels=new Pixels(layer);
			scene.addChild(hairPixels);
			scene.addChild(bodyPixels);
			scene.addChild(oppaiPixels);
			scene.addChild(op);
			op.localRotationY=hairPixels.localRotationY=bodyPixels.localRotationY=oppaiPixels.localRotationY=-180;
		}

		private function xmlLoaded(e:Event):void {
			xml=XML(e.target.data);
			//Make a Hair
			var ar:Array=xml.float_array[1].split("\n");
			for (var i:uint = 0; i<ar.length; i++) {
				var oneVartex:Array=ar[i].split(" ");
				vartexData_hair.push(setParticles(oneVartex));
			}
			drawParticle(vartexData_hair, hairPixels);
			//Make an Oppai
			var ar2:Array=xml.float_array[2].split("\n");
			for (var i2:uint = 0; i2<ar2.length; i2++) {
				var oneVartex2:Array=ar2[i2].split(" ");
				vartexData_oppai.push(setParticles(oneVartex2));
			}
			drawParticle(vartexData_oppai, oppaiPixels);
			//Make a Body
			var ar3:Array=xml.float_array[0].split("\n");
			for (var i3:uint = 0; i3<ar3.length; i3++) {
				var oneVartex3:Array=ar3[i3].split(" ");
				vartexData_body.push(setParticles(oneVartex3));
			}
			drawParticle(vartexData_body, bodyPixels);
			addEventListener(Event.ENTER_FRAME,enterFrames);
		}

		private function setParticles(oneVartex:Array):MyParticles {
			var particle:MyParticles = new MyParticles();
			particle.x=oneVartex[0]*5000;
			particle.y=oneVartex[1]*5000-800;
			particle.z=oneVartex[2]*5000;
			particle.color=0xffff99cc;
			return particle;
		}

		private function drawParticle(vertexes:Vector.<MyParticles>, pixels_obj:Pixels):void {
			var len:uint=vertexes.length;
			var px:MyParticles;
			for (var i:uint = 0; i<len; i++) {
				px=vertexes[i];
				var p:Pixel3D=new Pixel3D(px.color);
				p.x=px.x;
				p.y=px.y;
				p.z=px.z;
				if (pixels_obj==oppaiPixels) {//Oppaiなら
					op.oppaiPosition.push(new Array(p.x,p.y,p.z));
				}
				pixels_obj.addPixel3D(p);
			}
		}

		private function enterFrames(event:Event):void {
			allRotation(new Array(hairPixels,oppaiPixels,bodyPixels,op));
			oppaiHandler(vartexData_oppai);
			startRendering();
		}

		private function oppaiHandler(vec:Vector.<MyParticles>):void {
			var particle:MyParticles;
			for (var i:uint = 0; i<vec.length; i++) {
				particle=vec[i];
				var dx:Number=(op.getRotationPoint(i).x)-particle.x;
				var dy:Number=(op.getRotationPoint(i).y)-particle.y;
				var ax:Number=dx*(spring*((1)*0.090+(i*0.001)));//ここで調節
				var ay:Number=dy*(spring*((1)*0.090+(i*0.001)));
				particle.vx+=ax;
				particle.vy+=ay;
				particle.vx*=friction;
				particle.vy*=friction;
				particle.x+=particle.vx;
				particle.y+=particle.vy;
				oppaiPixels.pixels[i].x=particle.x;
			}
		}

		private function allRotation(ar:Array):void {
			var i:uint=ar.length;
			while (i--) {
				ar[i].rotationY += (mouseX-stage.stageWidth/2)*0.01;
				ar[i].rotationX += (mouseY-stage.stageHeight/2)*0.01;
			}
		}

		private function rand(num:Number):int {
			return Math.floor(Math.random()*num);
		}
	}
}

class MyParticles {
	public var x:Number,y:Number,z:Number,vx:Number=0,vy:Number=0,vz:Number=0,color:uint;
}

import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.core.math.Number3D;

class Oppai extends DisplayObject3D {
	public var oppaiPosition:Array=[];
	public function getRotationPoint(index:uint):Number3D {
		var newX:Number=Math.cos(degreeToRadian(rotationY))*oppaiPosition[index][0];
		var newY:Number=Math.cos(degreeToRadian(rotationZ))*oppaiPosition[index][1];
		var newZ:Number=Math.sin(degreeToRadian(rotationY))*oppaiPosition[index][2];
		return new Number3D(newX,newY,newZ);
	}

	private function degreeToRadian(rote:Number):Number {
		return rote*Math.PI / 180;
	}
}

