/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fhVd
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import starling.core.Starling;
    [SWF(width = 465, height = 465, backgroundColor = 0x292929, frameRate=60)]
    public class FlashTest extends flash.display.Sprite {
        
        public var mStarling:Starling;
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
        
        public function FlashTest()
        {
            Wonderfl.disable_capture();
            
            //addChild(new Bitmap(source));            
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Starling.multitouchEnabled = false;
            
            mStarling = new Starling(Game, stage);
            mStarling.start();
            mStarling.showStats = true;
            //addEventListener(Event.ENTER_FRAME, ready, false, 0, true);
        }
        
        /*
        private function ready(evt:Event):void {
            removeEventListener(Event.ENTER_FRAME, ready);
            mStarling.shareContext = true;
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }

        private function update(evt:Event):void {
            mStarling.context.clear();
            mStarling.render();
            mStarling.context.drawToBitmapData(source);
            mStarling.context.present();
        }
        */
        
        
    }
}

Class  
{
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.filters.BevelFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    
    
    import starling.display.Sprite;
    import starling.textures.Texture;
    import starling.events.TouchEvent;
    import starling.events.Touch;
    import starling.events.TouchPhase;
    import starling.text.TextField;
    import starling.events.EnterFrameEvent;
    
    /**
     * ...
     * @author ypc
     */
    class Game extends Sprite
    {
        public var blockArray:Array;
        public var blockNumWidth:int = 20;
        public var blockNumHeight:int = 20;
        
        public var blockWidth:int = 20;
        public var blockHeight:int = 20;
        public var blockTypeNum:int = 5;
        
        public var _width:int = 465;
        public var _height:int = 465;
        
        public var blockBitmapData:BitmapData;
        public var blockTexture:Texture;
        
        public var colors:Array = [0x6c6c6c, 0x227800, 0x0077c3, 0x7800ff, 0xfa5800, 0xff0080];
        public var bevelFilter:BevelFilter;
        
        public var touchedBlock:Block;
        
        public var diamond:int = 0;
        public var gold:int = 10;
        public var fracture:int = 0;
        public var fractureToGold:int = 300;
        public var goldText:TextField;
        
        public var frameRate:int = 60;
        
        public var fractureSpeed:int = 1;
        public var speedText:TextField;
        
        public var gameOverText:TextField;
        
        public var fogArray:Array;
        
        public var blockPrice:Object = {
            0    : 5,
            1    : 50,
            2    : 500,
            3    : 5000,
            4    : 50000,
            5    : 500000
        }
        
        public var blockFractureBonus:Object = {
            0    : 1,
            1    : 10,
            2    : 100,
            3    : 1000,
            4    : 10000,
            5    : 100000
        }
        
        public function Game() 
        {
            
            bevelFilter = new BevelFilter();
            bevelFilter.strength = .5;
            
            initBlock();
            
            initBlockArray();
            
            goldText = new TextField(200, 20, "Gold : " + String(gold), "Arial", 12, 0xffff00);
            goldText.x = 465 - 210;
            goldText.y = 3;
            goldText.hAlign = "right";
            addChild(goldText);
            
            
            speedText = new TextField(300, 20, String(int(fractureSpeed * frameRate / fractureToGold * 10)/10) + " Gold / sec.", "Arial", 12, 0xcccccc);
            speedText.x = _width / 2 - 150;
            speedText.y = 3;
            speedText.hAlign = "center";
            addChild(speedText);
            
            
            gameOverText = new TextField(200, 80, "You Win!", "Courier New", 36, 0xffffff, true);
            gameOverText.hAlign = "center";
            gameOverText.x = _width / 2 - 100;
            gameOverText.y = _height / 2 - 40;
            //addChild(gameOverText);
            
            addEventListener(TouchEvent.TOUCH, onTouch);
            addEventListener(EnterFrameEvent.ENTER_FRAME, onUpdate);
            
        }
        
        
        public function onUpdate(e:EnterFrameEvent):void
        {
            fracture += fractureSpeed;
            
            if (fracture >= fractureToGold)
            {
                var plusGold:int = fracture / fractureToGold;
                
                gold += plusGold;
                goldText.text = "Gold : " + String(gold);
                
                fracture -= plusGold * fractureToGold;
            }
            
            
            
        }
        
        public function onTouch(e:TouchEvent):void
        {
            var touch:Touch = e.getTouch(stage);
            var isAdj:Boolean = false;
            
            if (touch)
            {
                if (touch.phase == TouchPhase.BEGAN && touch.target is Block)
                {
                    touchedBlock = touch.target as Block;
                    //trace(touchedBlock._id);
                    
                    if (touchedBlock._occupied == false &&  blockPrice[touchedBlock._id] <= gold)
                    {
                        if (checkAdj(touchedBlock) == true)
                        {
                            
                            gold -= blockPrice[touchedBlock._id];
                            fractureSpeed += blockFractureBonus[touchedBlock._id];
                            //touchedBlock.alpha = 1;
                            touchedBlock._occupied = true;
                            
                            goldText.text = "Gold : " + String(gold);
                            speedText.text = String(int(fractureSpeed * frameRate / fractureToGold * 10) / 10) + " Gold / sec.";
                            
                            fogArray[touchedBlock._y][touchedBlock._x].visible = false;
                            
                            //game Over Check
                            if (touchedBlock._id == 5)
                            {
                                addChild(gameOverText);
                                removeEventListener(TouchEvent.TOUCH, onTouch);
                                removeEventListener(EnterFrameEvent.ENTER_FRAME, onUpdate);
                            }
                            
                        }
                    }
                    
                    
                }
            }
        }
        
        public function checkAdj(block:Block):Boolean
        {
            var bx:int = block._x;
            var by:int = block._y;
            
            if (bx > 0)
            {
                if (blockArray[by][bx - 1]._occupied == true)
                {
                    return true;
                }
            }
            if (bx < blockWidth - 1)
            {
                if (blockArray[by][bx + 1]._occupied == true)
                {
                    return true;
                }
            }
            if (by > 0)
            {
                if (blockArray[by - 1][bx]._occupied == true)
                {
                    return true;
                }
            }
            if (by < blockHeight - 1)
            {
                if (blockArray[by + 1][bx]._occupied == true)
                {
                    return true;
                }
            }
            
            return false;
            
            
        }
        
        public function initBlockArray():void
        {
            var i:int, j:int;
            var block:Block;
            var id:int;
            var color:uint;
            var fog:Image;
            
            blockArray = [];
            fogArray = [];
            
            for (i = 0; i < blockNumWidth; i += 1)
            {
                blockArray[i] = [];
                fogArray[i] = [];
                
                for (j = 0; j < blockNumHeight; j += 1)
                {
                    id = int(Math.random() * Math.random() * Math.random() * blockTypeNum);
                    //id = int(Math.random() * blockTypeNum);
                    
                    block = new Block(Texture.fromTexture(blockTexture, new Rectangle(id * blockWidth, 0, blockWidth, blockHeight)));
                    block._id = id;
                    
                    blockArray[i].push(block);
                    block.x = _width / 2 + (j - blockNumWidth / 2) * blockWidth;
                    block.y = _height / 2 + (i - blockNumHeight / 2) * blockHeight;
                    
                    block._x = j;
                    block._y = i;
                    
                    //block.alpha = 0.2;
                    
                    addChild(block);
                    
                    
                    fog = new Image(Texture.fromTexture(blockTexture, new Rectangle(6 * blockWidth + 8, 8, blockWidth - 8, blockHeight - 8)));
                    fog.x = block.x + 4;
                    fog.y = block.y + 4;
                    fog.touchable = false;
                    
                    fogArray[i].push(fog);
                    addChild(fog);
                    
                }
            }
            
            if (blockArray[0][0]._id != 0)
            {
                block = blockArray[0][0];
                block._id = 0;
                block.texture = Texture.fromTexture(blockTexture, new Rectangle(0, 0, blockWidth, blockWidth));
                block.readjustSize();
            }
            
            //blockArray[0][0].alpha = 1; //시작 셀 표시
            blockArray[0][0]._occupied = true;
            fogArray[0][0].visible = false;
            
            block = blockArray[blockWidth - 1][blockWidth - 1]; //boss
            block._id = 5;
            block.texture = Texture.fromTexture(blockTexture, new Rectangle(5 * blockWidth, 0, blockWidth, blockWidth));
            block.readjustSize();
            
        }
       
        public function initBlock():void
        {
            
            blockBitmapData = new BitmapData(blockWidth * 7, blockHeight, false, 0x000000);
            
            var i:int;
            for (i = 0; i < 6; i += 1)
            {
                drawBlock(i, colors[i]);
            }
            
            
            
            //fogBitmapData = new BitmapData(blockWidth, blockHeight, true, 0x00ffffff);
            var fog:Shape = new Shape;
            fog.graphics.beginFill(0x000000);
            //fog.graphics.drawCircle(blockWidth / 2, blockHeight / 2, blockWidth / 2);
            fog.graphics.drawRect(8, 8, blockWidth - 8, blockHeight - 8);
            fog.graphics.endFill();
            blockBitmapData.draw(fog, new Matrix(1, 0, 0, 1, 6 * blockWidth, 0));
            //
            //fogBitmapData.draw(fog);
            //
            //fogTexture = Texture.fromBitmapData(fogBitmapData, false);
            
            
            blockTexture = Texture.fromBitmapData(blockBitmapData, false);
        }
        
        public function drawBlock(index:int, color:uint):void
        {
            var rect:Shape;
            rect = new Shape();
            
            rect.graphics.lineStyle(1, color);
            rect.graphics.beginFill(color);
            rect.graphics.drawRect(0, 0, blockWidth, blockHeight);
            
            rect.filters = [bevelFilter];
            
            
            blockBitmapData.draw(rect, new Matrix(1, 0, 0, 1, index * blockWidth, 0));
            
        }
        
    }

}

Class  
{
    import starling.display.Image;
    import starling.textures.Texture;
    
    /**
     * ...
     * @author ypc
     */
    class Block extends Image
    {    
        public var _id:int;
        public var _occupied:Boolean = false;
        
        public var _x:int;
        public var _y:int;
        
        public function Block(texture:Texture) 
        {
            super(texture);
        }
        
    }

}