/**
 * Copyright asobuno2010 ( http://wonderfl.net/user/asobuno2010 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fh5aU
 */

//Tweensyの練習
//thanks to @author kanariia http://blog.kanariia.net/archives/389
//TweensyOriginalサンプル1
//    mcが右から左に 移動して、2秒後に完了。
//        mcをクリックしたら一時停止、再クリックで再開する。
//        完了イベントを取得、完了したらマウスイベント削除。
//        ムービークリップのサブクラスである
//        TweensyTimeline使う
//        イージング使用
//        トゥイーンの遅延
//        プロパティpausedで条件判定して、トゥイーンの一時停止・再開
//        トゥイーン完了イベント取得

package {
            import com.flashdynamix.motion.*;
            import fl.motion.easing.*;
            import flash.display.MovieClip;
            import flash.text.TextField;
            import flash.events.MouseEvent;
            import flash.events.Event;
            import tween
            
            public class sample1 extends MovieClip {
                private var tween:TweensyTimeline;
                private var tf:TextField;
                public function sample1() {
                    
                    //テキストフィールドを作成、追加
                    tf = new TextField();
                    tf.x = 0;
                    tf.y = this.height;
                    
                    addChild(tf);
                    
                    //x軸0から450まで1.5秒かけてQuartic.easeInOutで動かす
                    tween = Tweensy.fromTo (this, {x:0}, {x:450}, 5.0, Quartic.easeOut);
                    
                    //目的地についたら１秒待つ
                    tween.delayEnd = 2.0;
                    
                    //トゥイーンが完了したら、completeTween関数を実行
                    tween.onComplete = completeTween;
                    
                    //イベントリスナー登録
                    addEventListener(MouseEvent.CLICK, pauseTween);
                    
                    //オーバー時のマウスカーソルの形状人さし指に
                    buttonMode = true;
                }
                public function pauseTween(e:Event) {
                    if (tween.paused){ //一時停止してたら
                        tween.resume();
                        tf.text = "再開したよ";
                    }else {            //そうでなければ一時停止
                    tween.pause();
                    tf.text = "一時停止したよ";
                    }
                }
                public function completeTween():void {
                    tf.text = "完了したよ";
                    //イベントリスナー削除
                    removeEventListener(MouseEvent.CLICK, pauseTween);
                    //オーバー時のマウスカーソルの形状デフォルトに
                    buttonMode = false;
}
            }}