/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fgRT
 */

// forked from Vladik's Draw Arc
package {import flash.display.Sprite;import flash.events.Event;[SWF(backgroundColor=0x84B7EE, width=465, height=456, frameRate=30)]public class FakeStage extends Sprite {
    public var bgColor:uint = 0x333333;            
public function FakeStage() {stage ? init() : addEventListener(Event.ADDED_TO_STAGE,init);} private function init(e:Event = null):void {removeEventListener(Event.ADDED_TO_STAGE,init);fillBg();addChild(new Main());stage.addEventListener(Event.RESIZE,fillBg);}private function fillBg(e:Event=null):void{graphics.clear();graphics.beginFill(bgColor);graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);graphics.endFill();}}}
import flash.display.*;
import flash.events.Event;
import flash.utils.getTimer;

class Main extends Sprite
{   
    private var wh:Wheel;

    private var w:Number;
    private var h:Number;

    public function Main()
    {
        addEventListener(Event.ADDED_TO_STAGE,init);} private function init(e:Event):void {removeEventListener(Event.ADDED_TO_STAGE,init);        
        
        wh = new Wheel();
        addChild(wh);
        wh.x = wh.y = 250;
        wh.draw();
        addEventListener(Event.ENTER_FRAME,loop);
    }
    
    private function loop(e:Event):void
    {
        wh.rotation+= 2;
        
        wh.value1 = (getTimer() % 1000) / 1000;
        wh.value2 = Do.abs(wh.rotation / 180);
        wh.value3 = 1 - wh.value2;
        
        wh.draw();
    }

}




class Wheel extends Sprite
{
    private var g:Graphics;
    
    public var radius:Number;
    
    public var color1:Number = 0x00FFFF;
    public var color2:Number = 0xFFFF00;
    public var color3:Number = 0xFF00FF;
    
    public var value1:Number = 1;
    public var value2:Number = 1;
    public var value3:Number = 1;
    
    public function Wheel(){
        radius = 80;
        g = this.graphics
    }
    
    public function draw():void
    {
        var r:Number = 360 / 3;
        var gap:Number = radius * .25;

        g.clear();
     
        g.beginFill(color1, .4);
        arc(radius, r, 0);
        g.beginFill(color2, .4);
        arc(radius, r, r);
        g.beginFill(color3, .4);
        arc(radius, r, r * 2);
        
        g.beginFill(color1, 1);
        arc(gap + (value1 * (radius - gap)), r, 0);
        g.beginFill(color2, 1);
        arc(gap + (value2 * (radius - gap)), r, r);
        g.beginFill(color3, 1);
        arc(gap + (value3 * (radius - gap)), r, r * 2);
        
        g.beginFill(0xFFFFFF);
        g.drawCircle(0,0,gap);
        g.endFill();
    }
    
    private function arc(rad:Number, arc:Number, start:Number):void
    {
        g.moveTo(0,0);
        Do.drawArc(
            g, 
            rad,
            arc,
            start
        );
        g.lineTo(0,0);
        g.endFill();
    }

}

//Class source : http://icodesnip.com/snippet/actionscript-3/as3-drawing-shapes-arc-burst-dashed-line-gear-polygon-star-wedge-line
class Do
{
    public static function drawArc(target:Graphics, radius:Number, arc:Number, startAngle:Number=0, yRadius:Number=0):void
    {
        // if startAngle is undefined, startAngle = 0
        if (startAngle == 0)
            startAngle = 0;
        
        // if yRadius is undefined, yRadius = radius
        if (yRadius == 0)
            yRadius = radius;
     
        // Init vars
        var segAngle:Number, theta:Number, angle:Number, angleMid:Number, segs:Number, ax:Number, ay:Number, bx:Number, by:Number, cx:Number, cy:Number;
        // no sense in drawing more than is needed :)
        if (Do.abs(arc) > 360)
            arc = 360;
                    
        // Flash uses 8 segments per circle, to match that, we draw in a maximum
        // of 45 degree segments. First we calculate how many segments are needed
        // for our arc.
        segs = Do.ceil(Do.abs(arc) / 45);
        // Now calculate the sweep of each segment
        segAngle = arc / segs;
        // The math requires radians rather than degrees. To convert from degrees
        // use the formula (degrees/180)*Math.PI to get radians. 
        theta = -(segAngle / 180) * Math.PI;
        // convert angle startAngle to radians
        angle = -(startAngle / 180) * Math.PI;
                
        // if our arc is larger than 45 degrees, draw as 45 degree segments
        // so that we match Flash's native circle routines.
        if (segs > 0)
        {
            target.lineTo(Math.cos(angle) * radius, Math.sin(angle) * yRadius);
            // Loop for drawing arc segments
            for (var i:int = 0; i < segs; ++i)
                {
                    // increment our angle
                    angle += theta;
                    // find the angle halfway between the last angle and the new
                    angleMid = angle - (theta / 2);
                    // calculate our end point
                    bx = Math.cos(angle) * radius;
                    by = Math.sin(angle) * yRadius;
                    // calculate our control point
                    cx = Math.cos(angleMid) * (radius / Math.cos(theta / 2));
                    cy = Math.sin(angleMid) * (yRadius / Math.cos(theta / 2));
                    // draw the arc segment
                    target.curveTo(cx, cy, bx, by);
                }
         }
    }
        
    /*
    * new abs function, about 25x faster than Math.abs
    */
    public static function abs(value:Number):Number
    {
        return value < 0 ? -value : value;
    }
    /*
    * new ceil function about 75% faster than Math.ceil.
    */
    public static function ceil(value:Number):Number
    {
        return (value % 1) ? int(value) + 1 : value;
    }
}
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    //