/**
 * Copyright KiKiKi ( http://wonderfl.net/user/KiKiKi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fgPV
 */

package {
    //マイクテスト1,2,3...
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.media.Microphone;
    import flash.media.SoundTransform;
    import flash.media.SoundMixer;
    import flash.events.Event;
    import flash.geom.Matrix;
    
    [SWF(backgroundColor = '#FFFFFF', frameRate=30)]
    public class Main extends Sprite {
        
        private var _mic:Microphone;
        private var _canvas:BitmapData;
        private var CANVAS_WIDTH:int = 465;
        private var CANVAS_HEIGHT:int = 465;
        private var _color:uint = 0xFF0000;
        private var _colors:Array = [0xFF0000,
                                     0x00FF00,
                                     0x0000FF,
                                     0xFFFF00,
                                     0x00FFFF,
                                     0xFF00FF
                                    ];
        
        public function Main() {
            _mic = Microphone.getMicrophone();
            //ダイアログ
            _mic.setLoopBack(true);
            
            //ハウリング対策
            var stf:SoundTransform = SoundMixer.soundTransform;
            stf.volume = 0;
            SoundMixer.soundTransform = stf;
            
            //_canvas
            _canvas = new BitmapData(CANVAS_WIDTH, CANVAS_HEIGHT, false, 0xFFFFFF)
            this.addChild(new Bitmap(_canvas));
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(evt:Event):void {
            if(_mic.muted) {
                return;
            }
            
            var level:Number = _mic.activityLevel;
            if(level < 5) {
                return;
            }
            
            
            trace(_mic.activityLevel);
            
            var mtx:Matrix = new Matrix();
            var inkx:Number = Math.random() * CANVAS_WIDTH;
            var inky:Number = Math.random() * CANVAS_HEIGHT;
            mtx.translate(inkx, inky);
            var ink:Ink = new Ink(Math.random() * level / 2, _color);
            BitmapDataUtil.loopDraw(_canvas, ink, mtx);
            
            changeRandomColor();
        }
        
        private function changeRandomColor():void {
            var n:int = Math.random() * _colors.length;
            n = ( n <= 0 )? 0 : n-1;
            _color = _colors[n];
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.filters.DisplacementMapFilter;

class Ink extends Sprite {
    private var _size:Number;
    private var _color:uint;
    public function Ink(size:Number, color:uint):void {
        _size  = size;
        _color = color;
        
        //center
        create(size, 0,0);
        
        var count:Number = Math.random() * 10;
        for(var i:int = 0; i < count; i++) {
            //角度
            var r:Number = Math.random()*2*Math.PI;
            //最大距離
            var maxv:Number = size * 3;
            //中心からの距離
            var v:Number = Math.random()*maxv;
            //サイズ
            var s:Number = size * Math.pow( (maxv - v)/maxv, 2 );
            
            //add Ink
            create(s, v * Math.cos(r), v * Math.sin(r));
        }
    
    }
    
    private function create(size:Number, _x:Number, _y:Number):void {
        size = (size < 1)? 1 : size;
        var ink:Sprite = new Sprite();
        var g:Graphics = ink.graphics;
        g.beginFill(_color);
        g.drawCircle(0, 0, size);
        g.endFill();
        addChild(ink);
        ink.x = _x;
        ink.y = _y;
    }
}

import flash.display.BitmapData;
import flash.display.IBitmapDrawable;
import flash.display.DisplayObject;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.geom.Rectangle;

class BitmapDataUtil {
    public static function loopDraw(targetBitmapData:BitmapData,
         source:IBitmapDrawable,
         matrix:Matrix = null,
         colorTransform:ColorTransform = null,
         blendMode:String = null,
         clipRect:Rectangle = null,
         smoothing:Boolean = false
         ):void {
        
        //最終的にdrawするBitmapData
        var tmpBitmapData:BitmapData = new BitmapData(targetBitmapData.width, targetBitmapData.height, true, 0x00FFFFFF);
        
        var targetRect:Rectangle = targetBitmapData.rect;
        
        //source rect
        var sourceRect:Rectangle;
        if(source as BitmapData) {
            var b:BitmapData = source as BitmapData;
            sourceRect = b.rect;
        } else if(source as DisplayObject) {
            var d:DisplayObject = source as DisplayObject;
            sourceRect = d.getRect(d);
        } else {
            return;
        }
        
        if(matrix != null) {
            sourceRect.x += matrix.tx;
            sourceRect.y += matrix.ty;
        }
        
        tmpBitmapData.draw(source, matrix);
        
        var translateX:Number = 0;
        var translateY:Number = 0;
        
        //x方向のはみ出し
        if(sourceRect.left < 0) {
            translateX = targetBitmapData.width;
        } else if(sourceRect.right > targetRect.right) {
            translateX = -targetBitmapData.width;
        }
        
        //y方向のはみ出し
        if(sourceRect.top < 0) {
            translateY = targetBitmapData.height;
        } else if (sourceRect.bottom > targetRect.bottom) {
            translateY = -targetBitmapData.height;
        }
        
        //ずらしてdraw
        matrix.translate(translateX,0);
        tmpBitmapData.draw(source, matrix);
        matrix.translate(0,translateY);
        tmpBitmapData.draw(source, matrix);
        matrix.translate.(-translateX, 0);
        tmpBitmapData.draw(source, matrix);
        
        targetBitmapData.draw(tmpBitmapData,
                              null,
                              colorTransform,
                              blendMode,
                              clipRect,
                              smoothing);
    }
    
    public function BitmapDataUtil() {
    }
    
    
}