/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ffMC
 */

// forked from keno42's カチャカチャ
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.media.Sound;
    import flash.net.URLRequest;
    public class FlashTest extends Sprite {
        private var spA:Sprite = new Sprite();
        private var spB:Sprite = new Sprite();
        private var status:int = 0;
        private var sound:Sound = new Sound();
        private var isSoundReady:Boolean = false;
        
        public function FlashTest() {
            // write as3 code here..
            
            loadSound();
            
            this.graphics.lineStyle(0,0);
            this.graphics.beginFill(0xFFFF00);
            this.graphics.drawCircle( 230, 210, 200);
            this.graphics.beginFill(0);
            this.graphics.drawEllipse( 130, 100, 40, 90);
            this.graphics.drawEllipse( 290, 100, 40, 90);
            drawSp();
            addChild(spA);
            addChild(spB);
            spA.x = 130;
            spB.x = 130;
            spA.y = 290;
            spB.y = 290;
            drawStatus();
            setTimer();
        }
        private function loadSound():void{
            sound.addEventListener(Event.COMPLETE, function():void{isSoundReady=true;});
            sound.load(new URLRequest("http://keno.serio.jp/sound/noise01.mp3"));
        }
        private function drawStatus():void{
            if( status == 0 ){
                spA.visible = true;
            } else {
                spA.visible = false;
            }
            spB.visible = !spA.visible;
        }
        private function drawSp():void{
            spA.graphics.lineStyle(0,0);
            spA.graphics.beginFill(0xFF0000);
            spA.graphics.drawEllipse(10, -25, 180, 50);
            spB.graphics.lineStyle(0,0);
            spB.graphics.lineTo(200,0);
        }
        private function changeStatus():void{
            status = 1 - status;
            if( status == 0 && isSoundReady ) sound.play();
            drawStatus();
        }
        private function setTimer():void{
            var timer:Timer = new Timer(100, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE,
                function():void{
                    changeStatus();
                    setTimer();
                }
            );
            if( status == 0 ){ // 50-100msで口を閉じる
                timer.delay -= 50 * Math.random();
            } else { // 100-400msでまた口をあける
                timer.delay += 300 * Math.random();
            }
            timer.start();
        }

    }
}