/**
 * Copyright chabudai ( http://wonderfl.net/user/chabudai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ffKa
 */

package {
	import caurina.transitions.Tweener;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.filters.DisplacementMapFilter;
	import flash.media.Camera;
	import flash.media.Video;

	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.geom.Point
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.display.Loader;

    public class WonderflTest extends Sprite {
		private var sp:Sprite;
		private var offset:Array;
		private var bmd:BitmapData;
		private var displacementmapfilter:DisplacementMapFilter;
		private var cameraBmd:BitmapData;
		private var cameraBmp:Bitmap;
		private var camera:Camera;
        private var video:Video;
		private var flg:Boolean = false;
		private var g:Bitmap;
		private var me:Bitmap;
		private var saisyo:Bitmap;
		private var _loader1:Loader = new Loader();
		private var _loader2:Loader = new Loader();
		private var _loader3:Loader = new Loader();
        
        public function WonderflTest() {
			Security.loadPolicyFile("http://chabudai.org/crossdomain.xml");
			_loader1.contentLoaderInfo.addEventListener(Event.INIT, _loadInitHandler1 );
			_loader2.contentLoaderInfo.addEventListener(Event.INIT, _loadInitHandler2 );
			_loader3.contentLoaderInfo.addEventListener(Event.INIT, _loadInitHandler3 );
            _loader1.load( new URLRequest("http://chabudai.org/temp/saisyo.png") );
            _loader2.load( new URLRequest("http://chabudai.org/temp/me.png") );
            _loader3.load( new URLRequest("http://chabudai.org/temp/gunya.png") );
		}
		
		private function _loadInitHandler1(e:Event):void {
            var tmp:BitmapData = new BitmapData( _loader1.width, _loader1.height, true, 0 );
            tmp.draw( _loader1 );
			saisyo = new Bitmap(tmp);
        }
		
		private function _loadInitHandler2(e:Event):void {
             var tmp:BitmapData = new BitmapData( _loader2.width, _loader2.height, true, 0 );
            tmp.draw( _loader2 );
			me = new Bitmap(tmp);
        }
		
		private function _loadInitHandler3(e:Event):void {
             var tmp:BitmapData = new BitmapData( _loader3.width, _loader3.height, true, 0 );
            tmp.draw( _loader3 );
			g = new Bitmap(tmp);
            init();
        }
			
		private function init():void {
			sp = new Sprite();
			addChild(sp);
			
			//camera
			camera = Camera.getCamera();
			camera.setMode(250, 250, 15);
			video = new Video(camera.width, camera.height);
            video.attachCamera(camera);
			
			//filter
			bmd = new BitmapData(500, 500, false, 0xffffffff);
			offset = [new Point(0, 0)];
			displacementmapfilter = new DisplacementMapFilter(bmd, new Point(0, 0), 2, 2, 0, 0, "wrap");
			
			cameraBmd = new BitmapData(camera.width, camera.height, false, 0xffffff);
			cameraBmp = new Bitmap(cameraBmd);
			cameraBmp.x = -20;
			cameraBmp.y = -20;
			cameraBmp.scaleX = 2;
            cameraBmp.scaleY = 2;

			sp.addChild(cameraBmp);
			
			//最初
			sp.addChild(saisyo);
			
			addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			addEventListener(Event.ENTER_FRAME, onEnterframe);
		}
		
		private function onMouseDown(e:MouseEvent):void {
			removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			flg = true;
			sp.removeChild(saisyo);
			
			g.alpha = 0;
			sp.addChild(g);
			sp.addChild(me);
			
			Tweener.addTween(g, { alpha:1, time:1, transition:"linear" } );
		}
		
		private function onEnterframe(e:Event):void {
			offset[0].y -= 3;
			bmd.perlinNoise(60, 60, 1, 5, true, true, 7, true, offset);
				
			cameraBmd.draw(video);
			if (flg == true && displacementmapfilter.scaleX < 100) {
				displacementmapfilter.scaleX += 1;
				displacementmapfilter.scaleY += 1;
			}
			sp.filters = [displacementmapfilter];
		}

	}
}
