/**
 * Copyright sugyan ( http://wonderfl.net/user/sugyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fei2
 */

// forked from sugyan's forked from: flash on 2010-1-21
// forked from sugyan's flash on 2010-1-21
/* ドラッグ操作で滲むような線を描く */
package {
	import flash.filters.BlurFilter;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
    import flash.display.Sprite;
	import flash.geom.Point;
	import flash.events.Event;
	import flash.events.MouseEvent;

    public class FlashTest extends Sprite {
        private var _line:MyLine = new MyLine(5, 0xFF0000);
        private var _bmp:Bitmap = new Bitmap();
        private var _bmd:BitmapData = new BitmapData(465, 465, false, 0x000000);
    	    
        public function FlashTest() {
            _bmp.bitmapData = _bmd;
            addChild(_bmp);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function (event:MouseEvent):void {
                _line.startDraw(new Point(event.stageX, event.stageY));
                stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            });
            stage.addEventListener(MouseEvent.MOUSE_UP, function (event:MouseEvent):void {
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            });
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onMouseMove(event:MouseEvent):void {
            _line.drawLine(new Point(event.stageX, event.stageY));
            _bmd.draw(_line);
        }
        
        private function onEnterFrame(event:Event):void {
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(0, 0), new BlurFilter(5, 5));
        }
    }
}


import flash.geom.Point;
import flash.display.Sprite;

class MyLine extends Sprite {
    private var _prevX:Number;
    private var _prevY:Number;
    private var _thickness:Number;
    private var _color:uint;

    public function MyLine(thickness:Number, color:uint) {
        _thickness = thickness;
        _color = color;
	}
	
	public function startDraw(point:Point):void {
		_prevX = point.x;
		_prevY = point.y;
	}
	
	public function drawLine(point:Point):void {
        graphics.clear();
        graphics.lineStyle(_thickness, _color);
        graphics.moveTo(_prevX, _prevY);
        graphics.lineTo(point.x, point.y);
        _prevX = point.x;
        _prevY = point.y;
	}
}