/**
 * Copyright ninehundred ( http://wonderfl.net/user/ninehundred )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fdSt
 */

// forked from checkmate's Saqoosha challenge for amateurs

/**
 * [ Frocessing ColorLerp Sample001 ]
 * 
 * @author : +light <9hundred.net>
 * @see    : http://wonderfl.net/code/7ed2d650b9d513edf9a499fb704c19ecb7aa4694
 * 
 * frocessing.color.ColorLerpのサンプル001
 * 
 */

package
{
	import flash.display.*;
	import flash.events.*;
	import flash.system.*;
	import flash.geom.*;
	import net.hires.debug.Stats;

	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]

    public class FrocessingTest extends Sprite
	{

		// ================================================== //
		// パラメーター
		// ================================================== //
		private var Upper			:Sprite;
		private var Lower			:Sprite;
		private var Canvas			:Bitmap;
		private const SW			:int = 465;
		private const SH			:int = 465;
		private const MAX			:int = 1;

		private var _grad			:Gradation;
		private var _particleList	:Array = [];


		// ================================================== //
		// コンストラクタ＆準備
		// ================================================== //
		public function FrocessingTest()
		{
			if(stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
        }

		private function init():void
		{
		    Wonderfl.disable_capture();
			removeEventListener(Event.ADDED_TO_STAGE, init);

			// ステージの基本設定準備
			initStage();
			Upper = addChildAt(new Sprite(), 0) as Sprite;
			Lower = addChildAt(new Sprite(), 0) as Sprite;

			//*// グラデーションの生成
			Lower.mask = Upper;
			_grad  = new Gradation(0xff0000, 0xff8000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0x8000ff);
			Canvas = Lower.addChild(new Bitmap(new BitmapData(SW, SH, false))) as Bitmap;
			for(var i:int=0; i<465; i++)
				Canvas.bitmapData.fillRect(new Rectangle(0, i, SW, 1), _grad.getColor(i/464));//*/

			addChild(new Stats());
			this.addEventListener(Event.ENTER_FRAME, render);
		}





		/**
		 * MAIN METHOD
		 */
		 
		// ================================================== //
		// Render
		// ================================================== //
		private function render(e:Event=null):void
		{
			var i:int, p:Particle, ang:Number;
			for(i=_particleList.length-1; i>=0; --i)
			{
				p   = _particleList[i];
				p.move();
				if(p.x > SW) Upper.removeChild(_particleList.splice(i, 1)[0]);
			}

			for(i=0; i<MAX; i++)
			{
				p   = Upper.addChildAt(new Particle(), 0) as Particle;
				_particleList.push(p);
			}
		}





		/**
		 * MAIN METHOD
		 */

		// ================================================== //
		// Render
		// ================================================== //





		/**
		 * COMMON METHOD
		 */

		// ================================================== //
		// ステージ設定
		// ================================================== //
		private function initStage():void
		{
			stage.align                  = StageAlign.TOP_LEFT;
			stage.scaleMode              = StageScaleMode.NO_SCALE;
			stage.quality                = StageQuality.HIGH;
			stage.displayState           = StageDisplayState.NORMAL;
			stage.frameRate              = 60;
			stage.showDefaultContextMenu = false;
		}


		// ================================================== //
		// 内側の格子状のライン
		// ================================================== //
		private function initGrid():void
		{
			var tw:int          = SW;
			var th:int          = SH;
			var col:int         = 0x66FFFFFF;
			var LineSpr:Sprite  = Lower.addChild(new Sprite()) as Sprite;
			var bmdW:BitmapData = new BitmapData(tw, 1, true, col);
			var xi:int, yi:int

			for(yi=0; yi<th; yi+=20)
			{
				var bmpH:Bitmap = LineSpr.addChild(new Bitmap()) as Bitmap;
				bmpH.y = yi;
				bmpH.bitmapData = bmdW;
			}
		}


		// ================================================== //
		// 配列のシャッフル
		// ================================================== //
		private function shuffle(_arr:Array):Array
		{
			var arr:Array = [];
			arr           = _arr;
			var i:Number  = arr.length;
			while (i--)
			{
				var j:Number = Math.floor(Math.random()*(i+1));
				var t:* = arr[i];
				arr[i]  = arr[j];
				arr[j]  = t;
			}
			return arr;
		}





    }
}



/**
 * Particle
 */

import flash.display.Sprite;
class Particle extends Sprite
{

	private var spdX	:Number;
	private var spdA	:Number;
	private var deg		:Number;

	public function Particle()
	{
		spdX = Math.random() * 2 + 2;
		spdA = Math.random() * 1 + 1;
		deg = Math.random()*360
		
		
		var size:int = Math.random() * 10 + 5;
			graphics.beginFill(0xFFFFFF, Math.random());
			graphics.drawCircle(size/2, size/2, size);// graphics.drawRect(0, 0, size, size);
			graphics.endFill();

		this.x = -size;
		this.y = 465 * Math.random();
	}

	public function move():void
	{
		deg = (deg+spdA) % 360;
		this.x += this.spdX;
		this.y += Math.sin(deg * Math.PI/180);
	}
}



/**
 * Gradation
 */

import frocessing.color.ColorLerp;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;
class Gradation
{
	private var _colors:Array;
	private var _easing:IEasing;
	
	public function Gradation(...args):void
	{
		_colors = args.concat();
		_easing = Linear.linear;
	}
	
	public function setEasing(easing:IEasing):void
	{
		_easing = easing;
	}
	
	public function getColor(position:Number):uint
	{
		position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
		var idx:int = position;
		var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
		if (alpha == 0)
		{
			return _colors[idx];
		}
		else
		{
			return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
		}
	}
}