/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fcwC
 */

package {
    import flash.ui.*;
    import fl.controls.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.display.*;
    
    [SWF(width=465,height=465,frameRate=60)]
    
    public class FlashTest extends Sprite {
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        private var prevMouseX:int;
        private var prevMouseY:int;
        private var world:BitmapData;
        private var bitmap:Bitmap;
        private var count:int;
        private var mousePressed:Boolean;
        public function FlashTest() {
            initialize();            
        }
        
        private function initialize():void {
            count = 0;
            world = new BitmapData(WIDTH, HEIGHT, false, 0);
            world.draw(stage);
            bitmap = new Bitmap(world);
            addChild(bitmap);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,
                function():void {
                    mousePressed = true;
                });
                stage.addEventListener(MouseEvent.MOUSE_UP,
                function():void {
                    mousePressed = false;
                });
                addEventListener(Event.ENTER_FRAME, frame);
                stage.quality = StageQuality.LOW;
        }
        
        private function frame(e:Event):void {
            var s:Sprite = new Sprite();
            world.lock();
            if(mousePressed) {
                s.graphics.beginFill(0xffffff);
                s.graphics.drawEllipse(mouseX - 3, mouseY - 3, 6, 6);
                s.graphics.endFill();
                s.graphics.lineStyle(10, 0xffffff);
                s.graphics.moveTo(prevMouseX, prevMouseY);
                s.graphics.lineTo(mouseX, mouseY);
                world.draw(s);
            }
            world.fillRect(new Rectangle(0, 0, WIDTH, 1), 0);
            world.fillRect(new Rectangle(0, 0, 1, HEIGHT), 0);
            world.fillRect(new Rectangle(0, HEIGHT - 1, WIDTH, 1), 0);
            world.fillRect(new Rectangle(WIDTH - 1.0, WIDTH, HEIGHT), 0);
            prevMouseX = mouseX;
            prevMouseY = mouseY;
            var i:int;
            var j:int;
            for(i = 1; i < WIDTH - 1; i++) {
                for(j = 1; j < HEIGHT - 1; j++) {
                    doPixel(i, j);
                }
            }
            count++;
            world.unlock();
        }
        
        private function doPixel(x:int, y:int):void {
            world.setPixel(x, y,(world.getPixel(x-1,y)+world.getPixel(x,y-1)+world.getPixel(x+1,y)+world.getPixel(x,y+1))>>2);
        }



    }
}