/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fcPL
 */

// forked from Vladik's Text Field Resize Bug
package {
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.setInterval;
    [SWF(width="465", height="465", backgroundColor="0x394E60", frameRate="60")]
    public class TextFieldResizeBug extends Sprite {
        public static var $log:TextField = new TextField;
        public function TextFieldResizeBug() {
            if ( stage ) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
            } private function init(e:Event = null):void { var s:Sprite = new Sprite; addChild(s);
            removeEventListener(Event.ADDED_TO_STAGE, init);s.graphics.beginFill(0x394E60);
            onInit(); $log.defaultTextFormat = new TextFormat('_sans', 16, 0xC4C4C4 ); s.graphics.drawRect(0, 0, 10000, 10000);
            $log.autoSize = 'left'; addChild($log); s.graphics.endFill(); $log.selectable = false; $log.x = 20; $log.y = 20;
        }
        
        private var tf:TextFormat = new TextFormat('_sans', 38, 0xFFFFFF, true);
        private var text:TextField;
        private var applyTextFormat:Boolean = true;
        
        private function onInit():void
        {
            var ui:Shape = new Shape(); addChild(ui);
            var g:Graphics = ui.graphics;
            
            text = new TextField();
            addChild( text );
            text.defaultTextFormat = tf;
            text.text = "Resize Bug";
            text.border = true;
            text.borderColor = 0x999999;
                        text.multiline = true;
            text.autoSize = 'left';
            
            setInterval( function():void
            {
                if ( text.type == 'dynamic' ) 
                {
                    text.type = 'input';
                    text.mouseEnabled = true;
                    text.selectable = true;
                    text.type = "input";
                    stage.focus = text;
                    
                    if ( applyTextFormat ) {
                        
                        // Each time the formatting is applied the textField is resized for no reason
                        text.defaultTextFormat = tf;
                        text.setTextFormat( tf );
                        /////////////////////////////////////////////////////////////////////////////
                        
                    }
                }
                else 
                {
                    text.type = 'dynamic';
                    text.mouseEnabled = false;
                    text.selectable = false;
                    text.type = "dynamic";
                    stage.focus = null;
                    
                    if ( applyTextFormat ) {
                        
                        // Commenting out any line below still forces the bug to accure
                        text.defaultTextFormat = tf;
                        text.setTextFormat( tf );
                        ///////////////////////////////////////////////////////////////
                        
                    }
                }
                
                /////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////
                //    SOLUTION 
                /////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////
                
                var width2:Number = text.width + ( text.type == 'input' ? 0 : text.getLineMetrics(0).descent );
                
                /////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////
                /////////////////////////////////////////////////////////////
                
                log( 
                    '<textformat tabstops="[110,220,330,440]">', 
                    'Width:\t<b>',         text.width, '</b>',
                    ' \tWidth2:\t<b>',         width2, '</b>',
                    '\nApply TF:\t<b>',     applyTextFormat.toString().toUpperCase(), '</b>',
                    '\tType:\t<b>',         text.type.toUpperCase(), '</b>',
                    '</textformat>'
                );
                
                text.x = ( stage.stageWidth - text.width ) / 2;
                text.y = 90;
                
                g.clear();
                g.beginFill( 0x59AA84 ); g.drawRect( text.x, 84, width2, 8 ); g.endFill();
                
                g.lineStyle(3, 0x999999);
                g.moveTo( -10, 90 );
                g.lineTo( stage.stageWidth + 20, 90 );
                
                
            }, 1000 );
            
            var style:Shape = new Shape(); addChild(style);
            
            style.graphics.beginFill( 0x0, 0.4 );
            style.graphics.drawRoundRect( 10, 180, stage.stageWidth - 20, 105, 5 );
            style.graphics.endFill();
            
            addButton( 40, 'TF', 0.5, 0.5, function():void {
                
                applyTextFormat = !applyTextFormat;
            });
            
            addButton( 40, 'B', 0.15, 0.5, function():void {
                
                tf.bold = !Boolean(tf.bold);
            });
            
            style.graphics.beginFill( 0x0, 0.4 );
            style.graphics.drawRoundRect( 10, 295, stage.stageWidth - 20, 60, 5 );
            style.graphics.endFill();
            
            
            addButton( 25, 'aA', 0.1, 0.7);
            
            addButton( 20, '12', 0.3, 0.7, function():void {
                
                tf.size = 12;
            });
            
            addButton( 20, '18', 0.4, 0.7, function():void {
                
                tf.size = 18;
            });
            
            addButton( 20, '24', 0.5, 0.7, function():void {
                
                tf.size = 24;
            });
            
            addButton( 20, '34', 0.6, 0.7, function():void {
                
                tf.size = 34;
            });
            
            addButton( 20, '42', 0.7, 0.7, function():void {
                
                tf.size = 42;
            });
            
            addButton( 20, '58', 0.8, 0.7, function():void {
                
                tf.size = 58;
            });
            
            style.graphics.beginFill( 0x0, 0.4 );
            style.graphics.drawRoundRect( 10, 365, stage.stageWidth - 20, 60, 5 );
            style.graphics.endFill();
            
            
            addButton( 25, 'F', 0.1, 0.85);
            
            addButton( 20, 'A', 0.3, 0.85, function():void {
                
                tf.font = "Arial, Helvetica, sans-serif";
            });
            
            addButton( 20, 'V', 0.45, 0.85, function():void {
                
                tf.font = "Verdana, Geneva, sans-serif";
            });
            addButton( 20, 'T', 0.6, 0.85, function():void {
                
                tf.font = "Tahoma, Geneva, sans-serif";
            });
            
            addButton( 20, 'G', 0.75, 0.85, function():void {
                
                tf.font = "Georgia, serif";
            });
            
            addButton( 20, 'C', 0.9, 0.85, function():void {
                
                tf.font = '"Courier New", Courier, monospace';
            });
        }
        
        private function addButton( size:Number, text:String = "", px:Number = 0.5, py:Number = 0.5, f:Function = null ):void
        {
            new Circle( this, size, stage.stageWidth * px, stage.stageHeight * py, text, f );
        }
        
        
    }
    
}
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

function log(...args):void
{
    TextFieldResizeBug.$log.htmlText = args.join('');
}

class Circle extends Sprite
{
    private var t:TextField;
    public function Circle( parent:Sprite, radius:Number, x:Number, y:Number, text:String = "", onClick:Function = null )
    {
        graphics.beginFill(0x59AA84, 1);
        graphics.drawCircle(0,0, radius);
        graphics.endFill();
        if( onClick!=null )addEventListener('click', function(e:*):void { onClick(); } );
        if( onClick!=null )buttonMode = useHandCursor = true;
        parent.addChild( this );
        this.x = x;
        this.y = y;
        
        if ( text != "" )
        {
            t = new TextField();
            t.mouseEnabled = false;
            addChild( t );
            t.autoSize = "left";
            t.defaultTextFormat = new TextFormat('Verdana, Geneva, sans-serif', radius, 0xFFFFFF);
            t.text = text;
            t.alpha = 1;
            t.selectable = false;
            t.x = -t.width / 2;
            t.y = -t.height / 2;
        }
    }
}