/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fcJs
 */

// forked from vasari's forked from: flash on 2010-3-5
// forked from hiro_rec's flash on 2010-3-5
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.utils.Timer;
    
    
    [SWF(frameRate="48", backgroundColor="0x000000")]
    
    public class ParticleDemo extends Sprite
    {
        private var container:Sprite;
        private var pList:Vector.<Bitmap>;
        private var timer:Timer;
        
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        
        
        public function ParticleDemo()
        {
            initialize();
        }
        
        private function initialize():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            container = new Sprite();
            addChild(container);
            
            pList = new Vector.<Bitmap>();
            
            addEventListener(Event.ENTER_FRAME, render);
            
            timer = new Timer(500, 25);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            bmp = new Bitmap();
            bmp.bitmapData = bmd;
            bmp.blendMode = BlendMode.HARDLIGHT;
            addChild(bmp);
        }
        
        private var w:int = 400;
        
        private function timerHandler(event:TimerEvent):void
        {
            var bmd:BitmapData = new BitmapData(Math.random() * 200 + 100, int(Math.random() * 5 + 1), false, 0xFFFFFF);
            var p:Bitmap = new Bitmap(bmd);
            var glow1:GlowFilter = new GlowFilter(0xdcecff, 0.9, 5, 5, 3, 3);
            var glow2:GlowFilter = new GlowFilter(0x0078ff, 0.7, 10, 10, 5, 2);
            
            p.x = Math.random() * w - w / 1;
            p.y = Math.random() * w - w / 1;
            p.z = Math.random() * w - w / 1;
            
            p.rotationY = 0;
            p.filters = [glow2];
            
            pList.push(p);
            container.addChild(p);
            
            container.x = w / 2;
            container.y = w / 2;
            container.z = w / 2 * -1;
        }
        
        private var speed:Number = 0.05;
        private var pt:Point = new Point();
        
        private var matrix:Array = [
                                1.0, 0, 0, 0, 0,
                                0, 1.1, 0, 0, 0,
                                0, 0, 1.5, 0, 0,
                                0, 0, 0, 0.49, 0
                                ];
            
        private var matrixFilter:ColorMatrixFilter = new ColorMatrixFilter(matrix);
        
        private function render(event:Event):void
        {
            container.rotationY += (stage.mouseX - stage.stageHeight / 2 - container.rotationY) * 0.01;
            container.rotationX += (stage.mouseY - stage.stageWidth / 2 - container.rotationX) * 0.01;
            speed += ((stage.mouseX - stage.stageWidth / 2) * 0.001 - speed) * 0.1;
            
            var len:int = pList.length;
            var p:Bitmap;
            
            for (var i:int = 0; i < len; i++)
            {
                p = pList[i];
                p.z += (p.z + 300 - p.z) * 0.3;
                
                if (p.z > 1000)
                {
                    p.z = -1000;
                    p.x = Math.random() * w - w / 2;
                    p.y = Math.random() * w - w / 2;
                }
            }
            
            bmd.draw(stage);
            
            bmd.applyFilter(bmd, bmd.rect, pt, matrixFilter);
            bmd.applyFilter(bmd, bmd.rect, pt, new GlowFilter(0x0042ff, 0.05, 10, 0, 3));
            bmd.applyFilter(bmd, bmd.rect, pt, new BlurFilter(20, 1));
            
        }
    }
}
