/**
 * Copyright andrey.mir ( http://wonderfl.net/user/andrey.mir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fcDG
 */

// forked from actionscriptbible's Chapter 15 Example 4
package {
  import flash.display.*;
  import flash.events.*;
  import flash.geom.*;
  public class ch15ex4 extends Sprite {
    protected var cube:Cube;
    protected var angularVelocity:Vector3D;
    protected var layers:Vector.<Shape> = new Vector.<Shape>();
    protected var colors:Vector.<uint> = new <uint>[0xD97C2B,0x496B73];
    protected var firstFrame:Boolean = true;
    public function ch15ex4() {
      cube = new Cube(200);
      cube.x = stage.stageWidth/2; cube.y = stage.stageHeight/2;
      addChild(cube);
      for (var i:int = 0; i < colors.length; i++) {
        layers[i] = new Shape();
        addChild(layers[i]);
      }
      stage.addEventListener(MouseEvent.CLICK, onClick);
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
      onClick(null);
    }
    protected function onClick(event:MouseEvent):void {
      var r:Function = function():Number {return Math.random() * 8 - 4};
      angularVelocity = new Vector3D(0, 5.1, 2);
      firstFrame = true;
      for (var i:int = 0; i < layers.length; i++) {
        layers[i].graphics.clear();
        layers[i].graphics.lineStyle(0, colors[i], 1);
      }
    }
    protected function onEnterFrame(event:Event):void {
      cube.rotationX += angularVelocity.x;
      cube.rotationY += angularVelocity.y;
      cube.rotationZ += angularVelocity.z;
      for (var i:int = 0; i < layers.length; i++) {
        var p:Point = cube.local3DToGlobal(cube.vertices[i]);
        if (firstFrame) {
          layers[i].graphics.moveTo(p.x, p.y);
        } else {
          layers[i].graphics.lineTo(p.x, p.y);
        }
      }
      firstFrame = false;
    }
  }
}
import flash.display.*;
import flash.geom.Vector3D;
class Cube extends Sprite {
  public var vertices:Vector.<Vector3D>;
  public function Cube(size:Number = 50) {
    var S2:Number = size/2;
    for (var side:int = 0; side < 6; side++) {
      var face:Sprite = new Sprite();
      face.graphics.lineStyle(8, 0, 0.1, false, LineScaleMode.NORMAL);
      face.graphics.drawRect(-S2, -S2, size, size);
      addChild(face);
    }
    vertices = new Vector.<Vector3D>();
    vertices.push(new Vector3D(-S2, -S2, -S2));
    vertices.push(new Vector3D(S2, S2, S2));
    getChildAt(0).rotationY = 90; getChildAt(0).x = -S2;
    getChildAt(1).rotationY = -90; getChildAt(1).x = S2;
    getChildAt(2).z = -S2;
    getChildAt(3).rotationY = 180; getChildAt(3).z = S2;
    getChildAt(4).rotationX = 90; getChildAt(4).y = S2;
    getChildAt(5).rotationX = -90; getChildAt(5).y = -S2;
  }
}