/**
 * Copyright fuwatty ( http://wonderfl.net/user/fuwatty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fcBC
 */

// forked from kotobuki's Wanco x Gainer
package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import net.wonderfl.widget.Wanco;
    import flash.events.Event;

    import funnel.*;
    import funnel.ui.*;
    import funnel.gui.*;
    
    public class FlashTest extends Sprite {
        private var gainer:Gainer;
        private var yAxisPin:Pin;
        private var board:Shape;
        private var wanco:Wanco;
        
        private var spX:int =3;
        private var preSpX:int;
        private var accSpX:Number;
        private var accY:Number;
        private var fallY:int =-stage.stageHeight;
        private var r:Number;
        
        private var flag:Boolean =true;
        private var dFlag:Boolean =false;
        private var count:Number =0;
        
       
        public function FlashTest() {
            gainer = new Gainer();
            
            board = new Shape();
            board.graphics.lineStyle(30, 0xf0e354);
            board.graphics.moveTo(-150, 0);
            board.graphics.lineTo(150, 0);
            board.x = stage.stageWidth/2;
            board.y = 300;
            this.addChild(board);

            wanco = new Wanco();
            wanco.x = Math.random()*(stage.stageWidth/2)+100;
            this.addChild(wanco);
             
            yAxisPin = gainer.analogInput(1);
            yAxisPin.addFilter(new Scaler(0.3, 0.7, -1, 1, Scaler.LINEAR, true));
            yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            
       
            gainer.button.addEventListener(ButtonEvent.PRESS, onButtonPress);
            
            addEventListener(Event.ENTER_FRAME, enterHandler);
        }
        
       private function onButtonPress(e:ButtonEvent):void {
       	
       	flag=true;
       
            wanco.x = Math.random()*(stage.stageWidth/2)+100;
            fallY = -stage.stageHeight/2;
            wanco.scaleX=1;
            wanco.scaleY=1;
            
            wanco.heart();
            count=0;
        }
        
       
        
        private function enterHandler(event:Event):void {
        	
        accSpX　= spX +(yAxisPin.value)*5;
        	
        	if(accSpX<0){
        		spX = -3;
        	}else{
        		spX = 3;
        	}
      
       	if(preSpX != spX){
        		wanco.jump2();
        	}
        	
        	board.rotation = Math.asin(yAxisPin.value) / Math.PI * 180;
        		   	
        r = (wanco.x-board.x)/(Math.cos(yAxisPin.value)/ Math.PI * 180); 	
        
        if(wanco.x>board.x+160||wanco.x<board.x-160){
        		
        		dFlag = true;
        	}else {
        		
          	accY = board.y+(Math.sin(yAxisPin.value)/ Math.PI * 180)*r-10;
        	}
        	
        	if(dFlag){
        		
        		fallY +=10;
        	if(wanco.y>stage.stageHeight){
        			 wanco.pout();
        		     wanco.scaleX = 1+count*0.3;
                 wanco.scaleY = 1+count*0.3;
        			 wanco.x = Math.random()*(stage.stageWidth/2)+100;
        			fallY = -stage.stageHeight/2;
        			dFlag = false;
        			flag = true;
        		}	
        	}
        	
        	if(flag){
        		fallY +=10;
        		if(fallY>0){
        			fallY =0;
        			flag =false;
        			count++;
        		}
        	}
        	 	
        	wanco.y = accY + fallY;
       
        wanco.x += accSpX;
        
        	preSpX = spX;
        
        }
    }  
}