/**
 * Copyright devm ( http://wonderfl.net/user/devm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fc6x
 */

package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BlendMode;
    
    import flash.filters.BlurFilter;
    
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    
    import flash.events.Event;

    import net.hires.debug.Stats;
    
    public class RotationExample extends Sprite {
        
        private var _canvas : BitmapData;
        private var _linesHolder : Sprite;
        
        private var _totalLines : int = 400;
        private var _gridSize : int = Math.sqrt( _totalLines );
        
        private var _linesArray : Array;
        private var _lineSize : int = 20;
        
        
        //Constructor
        [ SWF( frameRate=60, width=456, height=456 ) ]
        public function RotationExample() {
            
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0x0 );
            addChild( new Bitmap( _canvas ) );
            
            initLines();
            addEventListener( Event.ENTER_FRAME, update );
            
            var s:Stats = new Stats();
            addChild(s);
        }
        
        //the loop
        private function update( evt:Event ) : void {
            updateLines();
        }
        
        //create initial lines
        private function initLines() : void {
            
            _linesHolder = new Sprite();
            _linesArray = new Array();
            
            var count : int = 0;
            var lnX : int = _lineSize;
            var lnY : int = _lineSize;
            
            for( var i : int = 0; i < _totalLines; i++ ) {
                
                var ln : Sprite = new Sprite();
                ln.graphics.lineStyle( 1, 0xFFFFF );
                ln.graphics.moveTo( 0, 0 );
                ln.graphics.lineTo( _lineSize , 0 );
                ln.x = lnX;
                ln.y = lnY;
                
                lnX += _lineSize;
                
                count++;
                if( count == _gridSize ) {
                    lnX = _lineSize;
                    lnY += _lineSize;
                    count = 0;
                }
                _linesHolder.addChild( ln );
                _linesArray.push( ln );
            }
        }
        
        //rotate em based on mouse movement
        private function updateLines() : void{
            
            for( var i : int = 0; i < _totalLines; i++ ) {
                var ln : Sprite = _linesArray[i] as Sprite;
                var dx : Number = mouseX - ln.x;
                var dy : Number = mouseY - ln.y;
                var radians : Number = Math.atan2( dy, dx );
                ln.rotation = radians * 180 / Math.PI;
            }
            _canvas.colorTransform( _canvas.rect, new ColorTransform( 0, 0.99, 0 ) );
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(2, 2));
            _canvas.draw( _linesHolder );
        }
    }
}