/**
 * Copyright aduka ( http://wonderfl.net/user/aduka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fbpm
 */

// forked from usagifrask's 賢者の鼓動 -Philosopher's Heart Beat-
// forked from checkmate's Checkmate Vol.6 Professional
package  
{
	/*
左の黒いエリアで激しくクリック、または激しくカーソル移動すると、
あなたの鼓動は徐々に早まり、あなたはエモーショナルを止めることができないでしょう。
あなたは知っていることでしょう、この鼓動の激しさを…

Click and move your cursor like crazy over the black area on the left side of the screen. Your heartbeat will gradually become more and more intense. 
You can't stop yourself can you? You know it, the intensity of the pulse. 
	*/
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Point;
	import flash.filters.BlurFilter;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.utils.Timer;
	
	
	 [SWF(width = "600", height = "300", backgroundColor = "0xFFFFFF", frameRate = "30")]
	
	public class checkmateProfessional extends Sprite
	{
		private var container:Shape = new Shape();
		private var maskShape:Shape = new Shape();
		private var leftPad:Sprite = new Sprite();
		
		private var startX:Number = stage.stageWidth/2;
		private var startY:Number = stage.stageHeight / 2;
		private var endX:Number = stage.stageWidth;;
		private var endY:Number = startY;
		private var curX:Number = startX;
		private var curY:Number = startY;

		private var minAmplitude:Number = 5;
		private var curAmplitude:Number = minAmplitude;
		
		private var heartBeat:Sound = new Sound();
		private var isPlayed:Boolean = false;
		
		private var maskTimer:Timer = new Timer(10);
		private var defaultMaskSpeed:int = 8;

		private var beatSpeed:Number=0;
		private var maxBeatSpeed:int = 170;
		private var speedDownTimer:Timer = new Timer(50);
		
	
		private var prevPoint:Point = new Point(0,0);
		
		private const BLACK:uint = 0x000000;
		private const LINECOLOR:uint = 0xFFAACC;

		public function checkmateProfessional() 
		{
			heartBeat.load(new URLRequest('http://usagifrask.com/checkmate/heartbeat.mp3'));
			
			addChild(container); 
			addChild(maskShape); 
			addChild(leftPad);

			maskShape.graphics.lineStyle(2,BLACK);
			maskShape.graphics.beginFill(BLACK);
			maskShape.graphics.drawRect(0, 0, stage.stageWidth/2, stage.stageHeight);
			maskShape.graphics.endFill();
			maskShape.filters = [new BlurFilter(100)];
			container.cacheAsBitmap = true;
			container.mask = maskShape;
			
			leftPad.graphics.lineStyle(2, BLACK);
			leftPad.graphics.beginFill(BLACK);
			leftPad.graphics.drawRect(0, 0, stage.stageWidth/2, stage.stageHeight);
			leftPad.graphics.endFill();

			leftPad.addEventListener(MouseEvent.MOUSE_MOVE,moveHandler);
			leftPad.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {addSpeed(+15)});
			speedDownTimer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {addSpeed(-3)});
			speedDownTimer.start();

			maskTimer.addEventListener(TimerEvent.TIMER, doMove);
			maskTimer.start();
			
			writeLine();
			
		}
		
		private function doMove(e:TimerEvent):void 
		{
			maskShape.x += defaultMaskSpeed+beatSpeed*0.1;
			if (!isPlayed) {
				isPlayed = true;
				heartBeat.play();
			}
			if (maskShape.x >= stage.stageWidth * 2) {
				isPlayed = false;
				maskShape.x = 0;
				writeLine();
			}
		}
		
		private function moveHandler (e:MouseEvent) :void
		{	
			addSpeed(int(Point.distance(prevPoint, new Point(mouseX, mouseY))/10));
			prevPoint = new Point(mouseX, mouseY);
		}

		private function writeLine():void 
		{
			clearLine();
			while (	(curX += 2) < endX ) {
				curY = startY;
				curAmplitude = minAmplitude + beatSpeed/2;
				if ( curX >10 && (curX  % (100-beatSpeed/5)) < 15)  {
					curY += int((Math.random() * curAmplitude * 2 )- curAmplitude) ;			
				}
				container.graphics.lineTo(curX, curY);
			}
		}
		
		private function clearLine():void
		{
			container.graphics.clear();
			container.graphics.lineStyle(2, LINECOLOR);
			container.graphics.moveTo(startX, startY);
			curX = startX;
		}
		
		private function addSpeed(val:int) :void{
			beatSpeed += val;
			if ( beatSpeed < 0) beatSpeed = 0;
			else if (beatSpeed > maxBeatSpeed) beatSpeed = maxBeatSpeed;
		}
	}
}
