/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fahe
 */

package  
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    

    public class SimpleBox2D extends MovieClip 
    {
        private var w:b2World;
        private var debugDisplay:b2DebugDraw;
        
        public function SimpleBox2D() 
        {
            var aabb:b2AABB = new b2AABB();
            aabb.upperBound = new b2Vec2(100, 100);
            aabb.lowerBound = new b2Vec2(-100, -100);
            w = new b2World(aabb, new b2Vec2(0,10), true);
            
            debugDisplay = new b2DebugDraw();
            debugDisplay.m_sprite = Sprite(addChild(new Sprite));
            debugDisplay.m_drawFlags = b2DebugDraw.e_shapeBit;
            debugDisplay.m_drawScale = 30;
            //debugDisplay.SetFlags( b2DebugDraw.e_shapeBit );
            w.SetDebugDraw(debugDisplay);
            var a:b2Body = createBox(1, 1, 1, 1,1);
            var b:b2Body = createBox(465/30*0.5, 5, 455/30, 1);
            //update(null);
            addEventListener(Event.ENTER_FRAME, update);
        
        }
        
        private function createBox(x:Number, y:Number, w:Number, h:Number,density:Number=0):b2Body 
        {
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.x = x;
            bodyDef.position.y = y;
            //bodyDef.angle =2;
            //bodyDef = new b2BodyDef();
            //loc = new b2Vec2(p.x, p.y);
            /*
            bodyDef.linearDamping
            bodyDef.angularDamping 
            bodyDef.fixedRotation 
            bodyDef.isBullet 
            bodyDef.isSleeping 
            bodyDef.allowSleep 
            */
            var boxDef:b2PolygonDef = new b2PolygonDef();
            var hw:Number = w / 2;
            var hh:Number = h / 2;
            boxDef.SetAsBox(hw, hh);
            boxDef.density = density;
            /*
            boxDef.friction =
            boxDef.restitution = 
            boxDef.filter.maskBits =
            boxDef.filter.categoryBits =
            boxDef.filter.groupIndex = 
            */
            var body:b2Body = this.w.CreateBody(bodyDef);
            body.CreateShape(boxDef);
            body.SetMassFromShapes();
            return body;
        }
        protected function update(e:Event):void
        {
            trace( "SimpleBox2D.update > e : " + e );
            var timeStep:Number = 1 / 30;
            var positionIterations:int = 10;

            w.Step(timeStep,positionIterations);
        }
        
    }

}