/**
 * Copyright nemu90kWw ( http://wonderfl.net/user/nemu90kWw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fagk
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(frameRate='60', width='465', height='465', backgroundColor='0x000000')]
    public class Wipe extends Sprite
    {
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        
        private var screen:Bitmap;
        private var buffer:BitmapData;
        
        public function Wipe() 
        {
            buffer = new BitmapData(WIDTH, HEIGHT, false, 0);
            screen = new Bitmap(buffer);
            addChild(screen);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private var count:int = 0;
        private var color:int = 0x000000;
        private var step:int = 0;
        
        private function update(e:Event):void
        {
            var pos:int = count;
            
            if (count == 0)
            {
                if (color == 0x000000) {color = 0xFFFFFF;}
                else {color = 0x000000;}
                
                step = 14 + Math.floor(Math.random() * 81);
            }
            
            while (pos < WIDTH * HEIGHT)
            {
                buffer.setPixel(pos % WIDTH, Math.floor(pos / WIDTH), color);
                pos += step;
            }
            
            count++;
            
            if (count == step + 60) {
                count = 0;
            }
        }
    }
}