/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/faP2
 */

// forked from Nobinho's  I wanna play Rockman but he couldn't jump
// forked from Takatsukier's  I wanna play Rockman
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var charaChip:BitmapData;
		private const C_WIDTH:int = 31;//キャラの幅
		private const C_HEIGHT:int = 30;//キャラの高さ
		
		private var frame:int = 0;//時間制御用変数
		private var charaX:int = 0;//charaX軸
		private var charaY:int = 0;//charaY軸
		private var prevcy:int = 0;
        //copyPixelsで切り出したキャラを入れているBitmapData
		private var chara:BitmapData;
 		
 		private var left:Boolean = false;
 		private var right:Boolean = false;	
 		private var jump:Boolean = false;
 		private const SPEED:int = 10;
 		private var Rockman:Bitmap;
 		 		
 		
		public function Main(){
			var loader:Loader = new Loader();
		    loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest
            ("http://assets.wonderfl.net/images/related_images/c/c6/c6d0/c6d025f7dd6b2bd96b138515d408767b398e1f02"),
			new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void{
			// チップ画像読み込み
			var loader:Loader = event.currentTarget.loader;
			charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
			charaChip.draw(loader);
            //背景透過処理
			charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0xFF0000, 0x0, 0xFFFFFF);
			
			chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
			
			//デカイの作成
			Rockman = new Bitmap(chara);
			Rockman.scaleX = Rockman.scaleY = 3;
			Rockman.x = stage.stageWidth/2;
			Rockman.y = stage.stageHeight/1-Rockman.height;
			addChild(Rockman);
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);			
		}
		
		private function onEnterFrame(event:Event):void{
			if (left)Rockman.x -= SPEED,charaY=7;
			else if(right)Rockman.x += SPEED,charaY=1;
			else if(!right||!left)charaY =0;
			
			if(jump){
				charaY += 2;
				Rockman.y += charaY;
				
				if(Rockman.y + Rockman.height > stage.stageHeight){
					Rockman.y = stage.stageHeight - Rockman.height;
					jump = false;
				}
			}
			
			if (prevcy != charaY || frame++ % 10 == 0){
				chara.copyPixels(charaChip, 
    				new Rectangle(C_WIDTH * (charaX+0) , C_HEIGHT * charaY , C_WIDTH,C_HEIGHT), new Point());
				charaX = (charaX + 1) % 3;
				prevcy = charaY;
			}
		}
		
		private function onKeyDown(event:KeyboardEvent):void{
			if (event.keyCode == 37) left = true;
			if (event.keyCode == 39) right = true;
			if (event.keyCode == 38){
				if(jump) return;
				jump = true;
				charaY = -20;
			}
		}
		
		private function onKeyUp(event:KeyboardEvent):void{
			if (event.keyCode == 37) left = false;
			if (event.keyCode == 39) right = false;
		}
		
	}
}
