/**
 * Copyright aftercider ( http://wonderfl.net/user/aftercider )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fa6D
 */

package {
    /**
     * @author aftercider
     */
    
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var circleObject:CircleObject = new CircleObject();
            circleObject.x = stage.stageWidth / 2;
            circleObject.y = stage.stageHeight / 2;
            this.addChild(circleObject);            
        }
    }
}

import flash.events.MouseEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;
import flash.display.Sprite;
class CircleObject extends Sprite 
    {
        private const radius:Number = 10;
        public var _parent:CircleObject;
        private var children:Array;
        static internal var sid:int = 0;
        private var id:int;
        public var parentAngle:Number = 0;
        static public var soundArray:Array = null;
        static internal const octarb:String = "cdefgab";
        
        public function CircleObject() 
        {
            super();
            this.graphics.beginFill(int(Math.random()*0xffffff));
            this.graphics.drawCircle(0, 0, radius);
            
            children = [];
            this.addEventListener(MouseEvent.MOUSE_OVER, clickHandler);
            this.id = sid++;
            
            if (sound == null) {
                soundArray = [];
                for (var i:int = 0; i < 7; i++) 
                {
                    var sound:Sound = new Sound();
                    sound.load(new URLRequest("http://www.aftercider.com/actionscript/sound/"+octarb.charAt(i)+".mp3"));
                    soundArray.push(sound);
                }
            }
        }
        
        public function set parentCircle(p:CircleObject):void {
            this._parent = p;
            //parentAngle = Math.atan2(p.x,p.y);
        }
        
        public function add(child:CircleObject):Array {
            
            var theta:Number = this.parentAngle + (Math.random()-0.5)*1.8*Math.PI;
            child.x = Math.cos(theta) * radius * 2;
            child.y = Math.sin(theta) * radius * 2;
            child.parentAngle = theta;
            this.addChild(child);
            
            this.children.push(child);
            child.parentCircle = this;
            return this.children;
        }
        
        private function clickHandler(me:MouseEvent):void {
            if (me.target != this) return;
            //trace("roll over:" + sid)
            soundArray[int(Math.random()*7)].play();
            this.add(new CircleObject());
        }
    }